/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.jdbc.PostgresDialect$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Using;
import scala.util.Using$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\r=g\u0001B\u001f?\t&CQ!\u001b\u0001\u0005\u0002)DQ\u0001\u001c\u0001\u0005B5Dqa\u001f\u0001C\u0002\u0013%A\u0010C\u0004\u0002\u001a\u0001\u0001\u000b\u0011B?\t\u0011\u0005m\u0001A1A\u0005\nqDq!!\b\u0001A\u0003%Q\u0010\u0003\u0005\u0002 \u0001\u0011\r\u0011\"\u0003}\u0011\u001d\t\t\u0003\u0001Q\u0001\nuDq!a\t\u0001\t\u0003\n)\u0003C\u0004\u0002,\u0001!\t%!\f\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@!9\u0011q\u000e\u0001\u0005\n\u0005E\u0004bBA>\u0001\u0011\u0005\u0013Q\u0010\u0005\b\u0003+\u0003A\u0011IAL\u0011\u001d\ti\n\u0001C!\u0003?Cq!!,\u0001\t\u0003\ny\u000bC\u0004\u00024\u0002!\t%!.\t\u0013\u0005}\u0006!%A\u0005\u0002\u0005\u0005\u0007bBAl\u0001\u0011\u0005\u0013\u0011\u001c\u0005\b\u0003k\u0004A\u0011IA|\u0011\u001d\u0011)\u0001\u0001C!\u0005\u000fAqA!\u0005\u0001\t\u0003\u0012\u0019\u0002C\u0004\u0003V\u0001!\tEa\u0016\t\u000f\tu\u0003\u0001\"\u0011\u0003`!9!q\u0010\u0001\u0005B\t\u0005\u0005\"\u0003BD\u0001\t\u0007IQ\u0002BE\u0011!\u0011I\n\u0001Q\u0001\u000e\t-\u0005b\u0002BN\u0001\u0011\u0005#Q\u0014\u0004\u0007\u0005\u000b\u0004\u0001Aa2\t\r%lB\u0011\u0001Bi\u0011\u001d\u0011).\bC!\u0005/DqA!9\u001e\t\u0003\u0012\u0019\u000fC\u0004\u0003r\u0002!\tEa=\t\u000f\r\u0005\u0001\u0001\"\u0011\u0004\u0004!91q\u0002\u0001\u0005B\rE\u0001bBB\n\u0001\u0011\u00053\u0011\u0003\u0005\b\u0007+\u0001A\u0011IB\t\u0011\u001d\u00199\u0002\u0001C!\u0007#Aqa!\u0007\u0001\t\u0003\u001aY\u0002C\u0004\u0004.\u0001!\tea\f\t\u000f\re\u0002\u0001\"\u0011\u0004<!91q\b\u0001\u0005B\r\u0005\u0003bBB'\u0001\u0011\u00053q\n\u0005\t\u0007K\u0002\u0011\u0011!C\u0001U\"I1q\r\u0001\u0002\u0002\u0013\u00053\u0011\u000e\u0005\n\u0007W\u0002\u0011\u0011!C\u0001\u0007[B\u0011ba\u001c\u0001\u0003\u0003%\ta!\u001d\t\u0013\r]\u0004!!A\u0005B\re\u0004\"CBB\u0001\u0005\u0005I\u0011ABC\u0011%\u0019I\tAA\u0001\n\u0003\u001aY\tC\u0005\u0004\u0010\u0002\t\t\u0011\"\u0011\u0004\u0012\"I11\u0013\u0001\u0002\u0002\u0013\u00053Q\u0013\u0005\n\u0007/\u0003\u0011\u0011!C!\u00073;\u0011b!(?\u0003\u0003EIaa(\u0007\u0011ur\u0014\u0011!E\u0005\u0007CCa![\u001c\u0005\u0002\re\u0006\"CBJo\u0005\u0005IQIBK\u0011!\u0019YlNA\u0001\n\u0003S\u0007\"CB_o\u0005\u0005I\u0011QB`\u0011%\u0019)mNA\u0001\n\u0013\u00199MA\bQ_N$xM]3t\t&\fG.Z2u\u0015\ty\u0004)\u0001\u0003kI\n\u001c'BA!C\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0007\u0012\u000bQa\u001d9be.T!!\u0012$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0015aA8sO\u000e\u00011C\u0002\u0001K\u001dR;V\f\u0005\u0002L\u00196\ta(\u0003\u0002N}\tY!\n\u001a2d\t&\fG.Z2u!\ty%+D\u0001Q\u0015\t\t\u0006)\u0001\u0005dCR\fG._:u\u0013\t\u0019\u0006KA\u0007T#2\u001buN\u001c4IK2\u0004XM\u001d\t\u0003\u0017VK!A\u0016 \u0003#9{G*Z4bGfTEIQ\"FeJ|'\u000f\u0005\u0002Y76\t\u0011LC\u0001[\u0003\u0015\u00198-\u00197b\u0013\ta\u0016LA\u0004Qe>$Wo\u0019;\u0011\u0005y3gBA0e\u001d\t\u00017-D\u0001b\u0015\t\u0011\u0007*\u0001\u0004=e>|GOP\u0005\u00025&\u0011Q-W\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0007N\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002f3\u00061A(\u001b8jiz\"\u0012a\u001b\t\u0003\u0017\u0002\t\u0011bY1o\u0011\u0006tG\r\\3\u0015\u00059\f\bC\u0001-p\u0013\t\u0001\u0018LA\u0004C_>dW-\u00198\t\u000bI\u0014\u0001\u0019A:\u0002\u0007U\u0014H\u000e\u0005\u0002uq:\u0011QO\u001e\t\u0003AfK!a^-\u0002\rA\u0013X\rZ3g\u0013\tI(P\u0001\u0004TiJLgn\u001a\u0006\u0003of\u000b1d];qa>\u0014H/\u001a3BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u001cX#A?\u0011\u000by\f9!a\u0003\u000e\u0003}TA!!\u0001\u0002\u0004\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u000bI\u0016AC2pY2,7\r^5p]&\u0019\u0011\u0011B@\u0003\u0007M+G\u000f\u0005\u0003\u0002\u000e\u0005]QBAA\b\u0015\u0011\t\t\"a\u0005\u0002\t1\fgn\u001a\u0006\u0003\u0003+\tAA[1wC&\u0019\u00110a\u0004\u00029M,\b\u000f]8si\u0016$\u0017iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8tA\u0005A2/\u001e9q_J$X\rZ*ue&twMR;oGRLwN\\:\u00023M,\b\u000f]8si\u0016$7\u000b\u001e:j]\u001e4UO\\2uS>t7\u000fI\u0001\u0013gV\u0004\bo\u001c:uK\u00124UO\\2uS>t7/A\ntkB\u0004xN\u001d;fI\u001a+hn\u0019;j_:\u001c\b%A\njgN+\b\u000f]8si\u0016$g)\u001e8di&|g\u000eF\u0002o\u0003OAa!!\u000b\n\u0001\u0004\u0019\u0018\u0001\u00034v]\u000et\u0015-\\3\u00023%\u001cxJ\u00196fGRtu\u000e\u001e$pk:$W\t_2faRLwN\u001c\u000b\u0004]\u0006=\u0002bBA\u0019\u0015\u0001\u0007\u00111G\u0001\u0002KB!\u0011QGA\u001d\u001b\t\t9DC\u0002B\u0003'IA!a\u000f\u00028\ta1+\u0015'Fq\u000e,\u0007\u000f^5p]\u0006yq-\u001a;DCR\fG._:u)f\u0004X\r\u0006\u0006\u0002B\u0005M\u0013QLA1\u0003K\u0002R\u0001WA\"\u0003\u000fJ1!!\u0012Z\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002N\u0001\u000bQ\u0001^=qKNLA!!\u0015\u0002L\tAA)\u0019;b)f\u0004X\rC\u0004\u0002V-\u0001\r!a\u0016\u0002\u000fM\fH\u000eV=qKB\u0019\u0001,!\u0017\n\u0007\u0005m\u0013LA\u0002J]RDa!a\u0018\f\u0001\u0004\u0019\u0018\u0001\u0003;za\u0016t\u0015-\\3\t\u000f\u0005\r4\u00021\u0001\u0002X\u0005!1/\u001b>f\u0011\u001d\t9g\u0003a\u0001\u0003S\n!!\u001c3\u0011\t\u0005%\u00131N\u0005\u0005\u0003[\nYEA\bNKR\fG-\u0019;b\u0005VLG\u000eZ3s\u00039!xnQ1uC2L8\u000f\u001e+za\u0016$\u0002\"!\u0011\u0002t\u0005U\u0014\u0011\u0010\u0005\u0007\u0003?b\u0001\u0019A:\t\u000f\u0005]D\u00021\u0001\u0002X\u0005I\u0001O]3dSNLwN\u001c\u0005\b\u0003Ob\u0001\u0019AA5\u0003\t\u001awN\u001c<feRT\u0015M^1US6,7\u000f^1naR{G+[7fgR\fW\u000e\u001d(U5R!\u0011qPAF!\u0011\t\t)a\"\u000e\u0005\u0005\r%\u0002BAC\u0003'\tA\u0001^5nK&!\u0011\u0011RAB\u00055aunY1m\t\u0006$X\rV5nK\"9\u0011QR\u0007A\u0002\u0005=\u0015!\u0001;\u0011\t\u0005U\u0012\u0011S\u0005\u0005\u0003'\u000b9DA\u0005US6,7\u000f^1na\u0006\u00113m\u001c8wKJ$H+[7fgR\fW\u000e\u001d(U5R{'*\u0019<b)&lWm\u001d;b[B$B!a$\u0002\u001a\"9\u00111\u0014\bA\u0002\u0005}\u0014a\u00017ei\u0006Yq-\u001a;K\t\n\u001bE+\u001f9f)\u0011\t\t+!+\u0011\u000ba\u000b\u0019%a)\u0011\u0007-\u000b)+C\u0002\u0002(z\u0012\u0001B\u00133cGRK\b/\u001a\u0005\b\u0003W{\u0001\u0019AA$\u0003\t!G/\u0001\rjg\u000e\u000b7oY1eS:<GK];oG\u0006$X\rV1cY\u0016$\"!!-\u0011\ta\u000b\u0019E\\\u0001\u0011O\u0016$HK];oG\u0006$X-U;fef$Ra]A\\\u0003wCa!!/\u0012\u0001\u0004\u0019\u0018!\u0002;bE2,\u0007\"CA_#A\u0005\t\u0019AAY\u0003\u001d\u0019\u0017m]2bI\u0016\f!dZ3u)J,hnY1uKF+XM]=%I\u00164\u0017-\u001e7uII*\"!a1+\t\u0005E\u0016QY\u0016\u0003\u0003\u000f\u0004B!!3\u0002T6\u0011\u00111\u001a\u0006\u0005\u0003\u001b\fy-A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011[-\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002V\u0006-'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Y!-\u001a4pe\u00164U\r^2i)\u0019\tY.!9\u0002lB\u0019\u0001,!8\n\u0007\u0005}\u0017L\u0001\u0003V]&$\bbBAr'\u0001\u0007\u0011Q]\u0001\u000bG>tg.Z2uS>t\u0007\u0003BA\u001b\u0003OLA!!;\u00028\tQ1i\u001c8oK\u000e$\u0018n\u001c8\t\u000f\u000558\u00031\u0001\u0002p\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\u000bQ\f\tp]:\n\u0007\u0005M(PA\u0002NCB\f\u0001dZ3u+B$\u0017\r^3D_2,XN\u001c+za\u0016\fV/\u001a:z)\u001d\u0019\u0018\u0011`A\u007f\u0005\u0003Aa!a?\u0015\u0001\u0004\u0019\u0018!\u0003;bE2,g*Y7f\u0011\u0019\ty\u0010\u0006a\u0001g\u0006Q1m\u001c7v[:t\u0015-\\3\t\r\t\rA\u00031\u0001t\u0003-qWm\u001e#bi\u0006$\u0016\u0010]3\u0002?\u001d,G/\u00169eCR,7i\u001c7v[:tU\u000f\u001c7bE&d\u0017\u000e^=Rk\u0016\u0014\u0018\u0010F\u0004t\u0005\u0013\u0011YA!\u0004\t\r\u0005mX\u00031\u0001t\u0011\u0019\ty0\u0006a\u0001g\"1!qB\u000bA\u00029\f!\"[:Ok2d\u0017M\u00197f\u0003-\u0019'/Z1uK&sG-\u001a=\u0015\u0017M\u0014)B!\u0007\u0003.\t\r#1\u000b\u0005\u0007\u0005/1\u0002\u0019A:\u0002\u0013%tG-\u001a=OC6,\u0007b\u0002B\u000e-\u0001\u0007!QD\u0001\u000bi\u0006\u0014G.Z%eK:$\b\u0003\u0002B\u0010\u0005Si!A!\t\u000b\t\t\r\"QE\u0001\bG\u0006$\u0018\r\\8h\u0015\r\u00119\u0003Q\u0001\nG>tg.Z2u_JLAAa\u000b\u0003\"\tQ\u0011\nZ3oi&4\u0017.\u001a:\t\u000f\t=b\u00031\u0001\u00032\u000591m\u001c7v[:\u001c\b#\u0002-\u00034\t]\u0012b\u0001B\u001b3\n)\u0011I\u001d:bsB!!\u0011\bB \u001b\t\u0011YD\u0003\u0003\u0003>\t\u0015\u0012aC3yaJ,7o]5p]NLAA!\u0011\u0003<\tqa*Y7fIJ+g-\u001a:f]\u000e,\u0007b\u0002B#-\u0001\u0007!qI\u0001\u0012G>dW/\u001c8t!J|\u0007/\u001a:uS\u0016\u001c\b\u0003\u0003B%\u0005\u001f\u00129D!\u0015\u000e\u0005\t-#\u0002\u0002B'\u0003'\tA!\u001e;jY&!\u00111\u001fB&!\u0019\u0011IEa\u0014tg\"9\u0011Q\u001e\fA\u0002\tE\u0013aF5t'ftG/\u0019=FeJ|'OQ3ti\u00163gm\u001c:u)\rq'\u0011\f\u0005\b\u00057:\u0002\u0019AA\u001a\u0003%)\u0007pY3qi&|g.A\u0006j]\u0012,\u00070\u0012=jgR\u001cH#\u00038\u0003b\t\u0015$q\rB5\u0011\u001d\u0011\u0019\u0007\u0007a\u0001\u0003K\fAaY8o]\"1!q\u0003\rA\u0002MDqAa\u0007\u0019\u0001\u0004\u0011i\u0002C\u0004\u0003la\u0001\rA!\u001c\u0002\u000f=\u0004H/[8ogB!!q\u000eB>\u001b\t\u0011\tHC\u0002@\u0005gRAA!\u001e\u0003x\u0005YA-\u0019;bg>,(oY3t\u0015\r\u0011I\bQ\u0001\nKb,7-\u001e;j_:LAA! \u0003r\tY!\n\u0012\"D\u001fB$\u0018n\u001c8t\u0003%!'o\u001c9J]\u0012,\u0007\u0010F\u0003t\u0005\u0007\u0013)\t\u0003\u0004\u0003\u0018e\u0001\ra\u001d\u0005\b\u00057I\u0002\u0019\u0001B\u000f\u0003Q\u0001x-\u00117sK\u0006$\u00170\u0012=jgR\u001c(+Z4fqV\u0011!1\u0012\t\u0005\u0005\u001b\u0013)*\u0004\u0002\u0003\u0010*!!\u0011\u0013BJ\u0003!i\u0017\r^2iS:<'b\u0001B'3&!!q\u0013BH\u0005\u0015\u0011VmZ3y\u0003U\u0001x-\u00117sK\u0006$\u00170\u0012=jgR\u001c(+Z4fq\u0002\n\u0011c\u00197bgNLg-_#yG\u0016\u0004H/[8o)1\u0011yJa-\u00036\ne&Q\u0018Ba%\u0019\u0011\tK!*\u0003,\u001a1!1\u0015\u0001\u0001\u0005?\u0013A\u0002\u0010:fM&tW-\\3oiz\u00022A\u0018BT\u0013\r\u0011I\u000b\u001b\u0002\n)\"\u0014xn^1cY\u0016\u0004BA!,\u000306\t!)C\u0002\u00032\n\u0013ab\u00159be.$\u0006N]8xC\ndW\rC\u0004\u00022q\u0001\rA!*\t\r\t]F\u00041\u0001t\u0003%\u0019wN\u001c3ji&|g\u000eC\u0004\u0003<r\u0001\r!a<\u0002#5,7o]1hKB\u000b'/Y7fi\u0016\u00148\u000f\u0003\u0004\u0003@r\u0001\ra]\u0001\fI\u0016\u001c8M]5qi&|g\u000e\u0003\u0004\u0003Dr\u0001\rA\\\u0001\nSN\u0014VO\u001c;j[\u0016\u0014!\u0003U8ti\u001e\u0014Xm]*R\u0019\n+\u0018\u000e\u001c3feN\u0019QD!3\u0011\t\t-'QZ\u0007\u0002\u0001%\u0019!q\u001a'\u0003\u001d)#%iQ*R\u0019\n+\u0018\u000e\u001c3feR\u0011!1\u001b\t\u0004\u0005\u0017l\u0012\u0001\u0004<jg&$X\t\u001f;sC\u000e$H#B:\u0003Z\nu\u0007B\u0002Bn?\u0001\u00071/A\u0003gS\u0016dG\r\u0003\u0004\u0003`~\u0001\ra]\u0001\u0007g>,(oY3\u0002+YL7/\u001b;CS:\f'/_!sSRDW.\u001a;jGR91O!:\u0003j\n5\bB\u0002BtA\u0001\u00071/\u0001\u0003oC6,\u0007B\u0002BvA\u0001\u00071/A\u0001m\u0011\u0019\u0011y\u000f\ta\u0001g\u0006\t!/A\td_6\u0004\u0018\u000e\\3FqB\u0014Xm]:j_:$BA!>\u0003xB!\u0001,a\u0011t\u0011\u001d\u0011I0\ta\u0001\u0005w\fA!\u001a=qeB!!\u0011\bB\u007f\u0013\u0011\u0011yPa\u000f\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0007d_6\u0004\u0018\u000e\\3WC2,X\r\u0006\u0003\u0004\u0006\r-\u0001c\u0001-\u0004\b%\u00191\u0011B-\u0003\u0007\u0005s\u0017\u0010C\u0004\u0004\u000e\t\u0002\ra!\u0002\u0002\u000bY\fG.^3\u0002\u001bM,\b\u000f]8siNd\u0015.\\5u+\u0005q\u0017AD:vaB|'\u000f^:PM\u001a\u001cX\r^\u0001\u0014gV\u0004\bo\u001c:ugR\u000b'\r\\3TC6\u0004H.Z\u0001\rgV\u0004\bo\u001c:ug*{\u0017N\\\u0001\u000fO\u0016$H+\u00192mKN\u000bW\u000e\u001d7f)\r\u00198Q\u0004\u0005\b\u0007?9\u0003\u0019AB\u0011\u0003\u0019\u0019\u0018-\u001c9mKB!11EB\u0015\u001b\t\u0019)C\u0003\u0003\u0004(\tM\u0014A\u0001<3\u0013\u0011\u0019Yc!\n\u0003\u001fQ\u000b'\r\\3TC6\u0004H.Z%oM>\f1B]3oC6,G+\u00192mKR)1o!\r\u00046!911\u0007\u0015A\u0002\tu\u0011\u0001C8mIR\u000b'\r\\3\t\u000f\r]\u0002\u00061\u0001\u0003\u001e\u0005Aa.Z<UC\ndW-A\u0010d_:4XM\u001d;KCZ\fG+[7fgR\fW\u000e\u001d+p)&lWm\u001d;b[B$B!a$\u0004>!9\u0011QR\u0015A\u0002\u0005=\u0015!F2p]Z,'\u000f\u001e&bm\u0006$\u0015\r^3U_\u0012\u000bG/\u001a\u000b\u0005\u0007\u0007\u001aI\u0005\u0005\u0003\u00026\r\u0015\u0013\u0002BB$\u0003o\u0011A\u0001R1uK\"911\n\u0016A\u0002\r\r\u0013!\u00013\u0002+U\u0004H-\u0019;f\u000bb$(/Y\"pYVlg.T3uCRQ\u00111\\B)\u0007'\u001aif!\u0019\t\u000f\t\r4\u00061\u0001\u0002f\"91QK\u0016A\u0002\r]\u0013\u0001\u0002:t[\u0012\u0004B!!\u000e\u0004Z%!11LA\u001c\u0005E\u0011Vm];miN+G/T3uC\u0012\u000bG/\u0019\u0005\b\u0007?Z\u0003\u0019AA,\u0003%\u0019w\u000e\\;n]&#\u0007\u0010C\u0004\u0004d-\u0002\r!!\u001b\u0002\u00115,G/\u00193bi\u0006\fAaY8qs\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0003\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005]\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0007\u000b\u0019\u0019\bC\u0005\u0004v=\n\t\u00111\u0001\u0002X\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"aa\u001f\u0011\r\ru4qPB\u0003\u001b\t\t\u0019!\u0003\u0003\u0004\u0002\u0006\r!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2A\\BD\u0011%\u0019)(MA\u0001\u0002\u0004\u0019)!\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u0006\u0007\u001bC\u0011b!\u001e3\u0003\u0003\u0005\r!a\u0016\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u0016\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0003\u0002\r\u0015\fX/\u00197t)\rq71\u0014\u0005\n\u0007k*\u0014\u0011!a\u0001\u0007\u000b\tq\u0002U8ti\u001e\u0014Xm\u001d#jC2,7\r\u001e\t\u0003\u0017^\u001aRaNBR\u0007_\u0003Ra!*\u0004,.l!aa*\u000b\u0007\r%\u0016,A\u0004sk:$\u0018.\\3\n\t\r56q\u0015\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0004\u0004\u0003BBY\u0007ok!aa-\u000b\t\rU\u00161C\u0001\u0003S>L1aZBZ)\t\u0019y*A\u0003baBd\u00170A\u0004v]\u0006\u0004\b\u000f\\=\u0015\u00079\u001c\t\r\u0003\u0005\u0004Dn\n\t\u00111\u0001l\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0007\u0013\u0004B!!\u0004\u0004L&!1QZA\b\u0005\u0019y%M[3di\u0002")
public class PostgresDialect
extends JdbcDialect
implements SQLConfHelper,
NoLegacyJDBCError,
Product {
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedStringFunctions;
    private final Set<String> supportedFunctions;
    private final Regex pgAlreadyExistsRegex;

    public static boolean unapply(PostgresDialect x$0) {
        return PostgresDialect$.MODULE$.unapply(x$0);
    }

    public static PostgresDialect apply() {
        return PostgresDialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:postgresql");
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedStringFunctions() {
        return this.supportedStringFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isObjectNotFoundException(SQLException e) {
        String string = e.getSQLState();
        String string2 = "42P01";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = e.getSQLState();
        String string4 = "3F000";
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = e.getSQLState();
        String string6 = "42704";
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        boolean bl = false;
        int n = 0;
        int n2 = sqlType;
        if (7 == n2) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if (5 == n2) {
            return new Some((Object)ShortType$.MODULE$);
        }
        if (-7 == n2) {
            String string = typeName;
            String string2 = "bit";
            if (!(string != null ? !string.equals(string2) : string2 != null) && size != 1) {
                return new Some((Object)BinaryType$.MODULE$);
            }
        }
        if (8 == n2) {
            String string = typeName;
            String string3 = "money";
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                return new Some((Object)StringType$.MODULE$);
            }
        }
        if (93 == n2 && "timestamptz".equalsIgnoreCase(typeName) && !this.conf().legacyPostgresDatetimeMappingEnabled()) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if (92 == n2 && "timetz".equalsIgnoreCase(typeName)) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if (1 == n2 && "bpchar".equalsIgnoreCase(typeName) && size == Integer.MAX_VALUE) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (1111 == n2) {
            bl = true;
            n = n2;
            if ("void".equalsIgnoreCase(typeName)) {
                return new Some((Object)NullType$.MODULE$);
            }
        }
        if (bl) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ("text".equalsIgnoreCase(typeName)) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (2003 == n2) {
            Option<DataType> elementType = this.toCatalystType(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(typeName), 1), size, md);
            return elementType.map((Function1 & Serializable)et -> {
                Metadata metadata = md.build();
                int dim = metadata.contains("arrayDimension") ? (int)metadata.getLong("arrayDimension") : 1;
                return (DataType)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), dim).foldLeft(et, (Function2 & Serializable)(acc, x$1) -> ArrayType$.MODULE$.apply(acc));
            });
        }
        return None$.MODULE$;
    }

    private Option<DataType> toCatalystType(String typeName, int precision, MetadataBuilder md) {
        boolean bl = false;
        String string = null;
        String string2 = typeName;
        if ("bool".equals(string2)) {
            return new Some((Object)BooleanType$.MODULE$);
        }
        if ("bit".equals(string2)) {
            bl = true;
            string = string2;
            if (precision == 1) {
                return new Some((Object)BooleanType$.MODULE$);
            }
        }
        if (bl) {
            md.putBoolean("pg_bit_array_type", true);
            return new Some((Object)BinaryType$.MODULE$);
        }
        if ("int2".equals(string2)) {
            return new Some((Object)ShortType$.MODULE$);
        }
        if ("int4".equals(string2)) {
            return new Some((Object)IntegerType$.MODULE$);
        }
        if ("int8".equals(string2) ? true : "oid".equals(string2)) {
            return new Some((Object)LongType$.MODULE$);
        }
        if ("float4".equals(string2)) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if ("float8".equals(string2)) {
            return new Some((Object)DoubleType$.MODULE$);
        }
        if ("varchar".equals(string2)) {
            return new Some((Object)new VarcharType(precision));
        }
        if ("bpchar".equals(string2) && precision == Integer.MAX_VALUE) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ("char".equals(string2) ? true : "bpchar".equals(string2)) {
            return new Some((Object)new CharType(precision));
        }
        if ("text".equals(string2) ? true : ("cidr".equals(string2) ? true : ("inet".equals(string2) ? true : ("json".equals(string2) ? true : ("jsonb".equals(string2) ? true : ("uuid".equals(string2) ? true : ("xml".equals(string2) ? true : ("tsvector".equals(string2) ? true : ("tsquery".equals(string2) ? true : ("macaddr".equals(string2) ? true : ("macaddr8".equals(string2) ? true : ("txid_snapshot".equals(string2) ? true : ("point".equals(string2) ? true : ("line".equals(string2) ? true : ("lseg".equals(string2) ? true : ("box".equals(string2) ? true : ("path".equals(string2) ? true : ("polygon".equals(string2) ? true : ("circle".equals(string2) ? true : ("pg_lsn".equals(string2) ? true : ("varbit".equals(string2) ? true : ("interval".equals(string2) ? true : "pg_snapshot".equals(string2))))))))))))))))))))))) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ("bytea".equals(string2)) {
            return new Some((Object)BinaryType$.MODULE$);
        }
        if ("timestamptz".equals(string2) ? true : "timetz".equals(string2)) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if ("timestamp".equals(string2) ? true : "time".equals(string2)) {
            return new Some((Object)this.getTimestampType(md.build()));
        }
        if ("date".equals(string2)) {
            return new Some((Object)DateType$.MODULE$);
        }
        if (("numeric".equals(string2) ? true : "decimal".equals(string2)) && precision > 0) {
            int scale = (int)md.build().getLong("scale");
            return new Some((Object)DecimalType$.MODULE$.bounded(precision, scale));
        }
        if ("numeric".equals(string2) ? true : "decimal".equals(string2)) {
            return new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT());
        }
        if ("money".equals(string2)) {
            return None$.MODULE$;
        }
        return new Some((Object)StringType$.MODULE$);
    }

    @Override
    public LocalDateTime convertJavaTimestampToTimestampNTZ(Timestamp t) {
        return t.toLocalDateTime();
    }

    @Override
    public Timestamp convertTimestampNTZToJavaTimestamp(LocalDateTime ldt) {
        return Timestamp.valueOf(ldt);
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        ArrayType arrayType;
        DataType et;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("TEXT", 12));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BYTEA", -2));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("FLOAT4", 6));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("FLOAT8", 8));
        }
        if (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        if (TimestampType$.MODULE$.equals(dataType) && !this.conf().legacyPostgresDatetimeMappingEnabled()) {
            return new Some((Object)new JdbcType("TIMESTAMP WITH TIME ZONE", 93));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return new Some((Object)new JdbcType("NUMERIC(" + decimalType.precision() + "," + decimalType.scale() + ")", 2));
        }
        if (dataType instanceof ArrayType && ((et = (arrayType = (ArrayType)dataType).elementType()) instanceof AtomicType || et instanceof ArrayType)) {
            return this.getJDBCType(et).map((Function1 & Serializable)x$2 -> x$2.databaseTypeDefinition()).orElse((Function0 & Serializable)() -> JdbcUtils$.MODULE$.getCommonJDBCType(et).map((Function1 & Serializable)x$3 -> x$3.databaseTypeDefinition())).map((Function1 & Serializable)typeName -> new JdbcType(typeName + "[]", 2003));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        Some some;
        boolean bl;
        Option<Object> option = cascade;
        if (option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value()))) {
            return "TRUNCATE TABLE ONLY " + table + " CASCADE";
        }
        return "TRUNCATE TABLE ONLY " + table;
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public void beforeFetch(Connection connection, scala.collection.immutable.Map<String, String> properties) {
        super.beforeFetch(connection, properties);
        if (StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)properties.getOrElse((Object)JDBCOptions$.MODULE$.JDBC_BATCH_FETCH_SIZE(), (Function0 & Serializable)() -> "0"))) > 0) {
            connection.setAutoCommit(false);
            return;
        }
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " TYPE " + newDataType;
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "DROP NOT NULL" : "SET NOT NULL";
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.quoteIdentifier(columnName) + " " + nullable;
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String indexType;
        Object indexProperties;
        String[] columnList;
        block1: {
            columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> this.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
            indexProperties = "";
            Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "postgresql");
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String indexType2 = (String)tuple2._1();
            String[] indexPropertyList = (String[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)indexType2, (Object)indexPropertyList);
            indexType = (String)tuple22._1();
            String[] indexPropertyList2 = (String[])tuple22._2();
            if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])indexPropertyList2))) break block1;
            indexProperties = "WITH (" + Predef$.MODULE$.wrapRefArray((Object[])indexPropertyList2).mkString(", ") + ")";
        }
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " ON " + this.quoteIdentifier(tableIdent.name()) + " " + indexType + " (" + Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ") + ") " + (String)indexProperties;
    }

    @Override
    public boolean isSyntaxErrorBestEffort(SQLException exception) {
        return Option$.MODULE$.apply((Object)exception.getSQLState()).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith("42")));
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = "SELECT * FROM pg_indexes WHERE tablename = '" + tableIdent.name() + "' AND indexname = '" + indexName + "'";
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return "DROP INDEX " + this.quoteIdentifier(indexName);
    }

    private final Regex pgAlreadyExistsRegex() {
        return this.pgAlreadyExistsRegex;
    }

    @Override
    public Throwable classifyException(Throwable e, String condition, scala.collection.immutable.Map<String, String> messageParameters, String description, boolean isRuntime) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            String string = sQLException.getSQLState();
            switch (string == null ? 0 : string.hashCode()) {
                case 48220673: {
                    if (!"2BP01".equals(string)) break;
                    throw new NonEmptyNamespaceException((String[])Option$.MODULE$.option2Iterable(messageParameters.get((Object)"namespace")).toArray(ClassTag$.MODULE$.apply(String.class)), sQLException.getMessage(), (Option)new Some((Object)e));
                }
                case 49567037: {
                    if (!"42704".equals(string)) break;
                    String string2 = condition;
                    String string3 = "FAILED_JDBC.DROP_INDEX";
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 49591065: {
                    if (!"42P07".equals(string)) break;
                    String string4 = condition;
                    String string5 = "FAILED_JDBC.CREATE_INDEX";
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        throw new IndexAlreadyExistsException((String)messageParameters.apply((Object)"indexName"), (String)messageParameters.apply((Object)"tableName"), (Option)new Some((Object)e));
                    }
                    String string6 = condition;
                    String string7 = "FAILED_JDBC.RENAME_TABLE";
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        String newTable = (String)messageParameters.apply((Object)"newName");
                        throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                    }
                    Option tblRegexp = this.pgAlreadyExistsRegex().findFirstMatchIn((CharSequence)sQLException.getMessage());
                    if (tblRegexp.nonEmpty()) {
                        throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(((Regex.MatchData)tblRegexp.get()).group(1));
                    }
                    return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
                }
            }
            return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
        }
        if (throwable instanceof UnsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
            throw unsupportedOperationException;
        }
        return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        PostgresSQLBuilder postgresSQLBuilder = new PostgresSQLBuilder(this);
        try {
            some = new Some((Object)postgresSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Object compileValue(Object value) {
        Object object = value;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(byArray), (Function1 & Serializable)x$6 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$6))})), ClassTag$.MODULE$.apply(String.class))).mkString("'\\x", "", "'::bytea");
        }
        return super.compileValue(object);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsTableSample() {
        return true;
    }

    @Override
    public boolean supportsJoin() {
        return true;
    }

    @Override
    public String getTableSample(TableSampleInfo sample) {
        return "TABLESAMPLE BERNOULLI (" + (sample.upperBound() - sample.lowerBound()) * (double)100 + ") REPEATABLE (" + sample.seed() + ")";
    }

    @Override
    public String renameTable(Identifier oldTable, Identifier newTable) {
        if (!Predef$.MODULE$.wrapRefArray((Object[])oldTable.namespace()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])newTable.namespace()))) {
            throw QueryCompilationErrors$.MODULE$.cannotRenameTableAcrossSchemaError();
        }
        return "ALTER TABLE " + this.getFullyQualifiedQuotedTableName(oldTable) + " RENAME TO " + newTable.name();
    }

    @Override
    public Timestamp convertJavaTimestampToTimestamp(Timestamp t) {
        long l = t.getTime();
        if (9223372036825200000L == l) {
            return new Timestamp(LocalDateTime.of(9999, 12, 31, 23, 59, 59, 999999999).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        if (-9223372036832400000L == l) {
            return new Timestamp(LocalDateTime.of(1, 1, 1, 0, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        return t;
    }

    @Override
    public Date convertJavaDateToDate(Date d) {
        long l = d.getTime();
        if (9223372036825200000L == l) {
            return new Date(LocalDateTime.of(9999, 12, 31, 0, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        if (-9223372036832400000L == l) {
            return new Date(LocalDateTime.of(1, 1, 1, 0, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        return d;
    }

    @Override
    public void updateExtraColumnMeta(Connection conn, ResultSetMetaData rsmd, int columnIdx, MetadataBuilder metadata) {
        int n = rsmd.getColumnType(columnIdx);
        switch (n) {
            case 2003: {
                String tableName = rsmd.getTableName(columnIdx);
                String columnName = rsmd.getColumnName(columnIdx);
                String query = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |SELECT pg_attribute.attndims\n             |FROM pg_attribute\n             |  JOIN pg_class ON pg_attribute.attrelid = pg_class.oid\n             |  JOIN pg_namespace ON pg_class.relnamespace = pg_namespace.oid\n             |WHERE pg_class.relname = '" + tableName + "' and pg_attribute.attname = '" + columnName + "'\n             |"));
                try {
                    Using$.MODULE$.resource((Object)conn.createStatement(), (Function1 & Serializable)stmt -> Using$.MODULE$.resource((Object)stmt.executeQuery(query), (Function1 & Serializable)rs -> {
                        if (rs.next()) {
                            return metadata.putLong("arrayDimension", Math.max(1L, rs.getLong(1)));
                        }
                        return BoxedUnit.UNIT;
                    }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                }
                catch (SQLException e) {
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get array dimension for column ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.COLUMN_NAME, columnName)}))), (Throwable)e);
                }
                return;
            }
        }
    }

    public PostgresDialect copy() {
        return new PostgresDialect();
    }

    public String productPrefix() {
        return "PostgresDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PostgresDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return 1154734157;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof PostgresDialect && ((PostgresDialect)x$1).canEqual(this);
    }

    public PostgresDialect() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.supportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP", "COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
        this.supportedStringFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"RPAD", "LPAD"}));
        this.supportedFunctions = (Set)this.supportedAggregateFunctions().$plus$plus(this.supportedStringFunctions());
        this.pgAlreadyExistsRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?:.*)relation \"(.*)\" already exists"));
    }

    public class PostgresSQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        public String visitExtract(String field, String source) {
            String string;
            block5: {
                String string2 = field;
                switch (string2 == null ? 0 : string2.hashCode()) {
                    case -1351979174: {
                        if (!"YEAR_OF_WEEK".equals(string2)) break;
                        string = "ISOYEAR";
                        break block5;
                    }
                    case 2074232729: {
                        if (!"DAY_OF_WEEK".equals(string2)) break;
                        string = "ISODOW";
                        break block5;
                    }
                    case 2074292194: {
                        if (!"DAY_OF_YEAR".equals(string2)) break;
                        string = "DOY";
                        break block5;
                    }
                }
                string = field;
            }
            String postgresField = string;
            return super.visitExtract(postgresField, source);
        }

        public String visitBinaryArithmetic(String name, String l, String r) {
            return l + " " + name.replace('^', '#') + " " + r;
        }

        public /* synthetic */ PostgresDialect org$apache$spark$sql$jdbc$PostgresDialect$PostgresSQLBuilder$$$outer() {
            return (PostgresDialect)this.$outer;
        }

        public PostgresSQLBuilder(PostgresDialect $outer) {
        }
    }
}

