/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.columnar.CachedBatchSerializer;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.columnar.CachedRDDBuilder;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.Utils$;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;

public final class InMemoryRelation$
implements Serializable {
    public static final InMemoryRelation$ MODULE$ = new InMemoryRelation$();
    private static Option<CachedBatchSerializer> ser = None$.MODULE$;

    private synchronized CachedBatchSerializer getSerializer(SQLConf sqlConf) {
        block0: {
            if (!ser.isEmpty()) break block0;
            String serName = (String)sqlConf.getConf(StaticSQLConf$.MODULE$.SPARK_CACHE_SERIALIZER());
            Class serClass = Utils$.MODULE$.classForName(serName, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
            CachedBatchSerializer instance = (CachedBatchSerializer)serClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            ser = new Some((Object)instance);
        }
        return (CachedBatchSerializer)ser.get();
    }

    public synchronized void clearSerializer() {
        ser = None$.MODULE$;
    }

    public SparkPlan convertToColumnarIfPossible(SparkPlan plan) {
        return this.getSerializer(plan.conf()).convertToColumnarPlanIfPossible(plan);
    }

    public InMemoryRelation apply(StorageLevel storageLevel, QueryExecution qe, Option<String> tableName) {
        LogicalPlan optimizedPlan = qe.optimizedPlan();
        CachedBatchSerializer serializer = this.getSerializer(optimizedPlan.conf());
        SparkPlan child = serializer.supportsColumnarInput((Seq<Attribute>)optimizedPlan.output()) ? serializer.convertToColumnarPlanIfPossible(qe.executedPlan()) : qe.executedPlan();
        CachedRDDBuilder cacheBuilder = new CachedRDDBuilder(serializer, storageLevel, child, tableName, qe.logical());
        InMemoryRelation relation = new InMemoryRelation((Seq<Attribute>)child.output(), cacheBuilder, (Seq<SortOrder>)optimizedPlan.outputOrdering());
        relation.statsOfPlanToCache_$eq(optimizedPlan.stats());
        return relation;
    }

    public InMemoryRelation apply(CachedBatchSerializer serializer, StorageLevel storageLevel, SparkPlan child, Option<String> tableName, LogicalPlan optimizedPlan) {
        CachedRDDBuilder cacheBuilder = new CachedRDDBuilder(serializer, storageLevel, child, tableName, optimizedPlan);
        InMemoryRelation relation = new InMemoryRelation((Seq<Attribute>)child.output(), cacheBuilder, (Seq<SortOrder>)optimizedPlan.outputOrdering());
        relation.statsOfPlanToCache_$eq(optimizedPlan.stats());
        return relation;
    }

    public InMemoryRelation apply(CachedRDDBuilder cacheBuilder, QueryExecution qe) {
        CachedRDDBuilder cachedRDDBuilder;
        LogicalPlan optimizedPlan = qe.optimizedPlan();
        CachedBatchSerializer serializer = cacheBuilder.serializer();
        if (serializer.supportsColumnarInput((Seq<Attribute>)optimizedPlan.output())) {
            SparkPlan x$1 = serializer.convertToColumnarPlanIfPossible(qe.executedPlan());
            CachedBatchSerializer x$2 = cacheBuilder.copy$default$1();
            StorageLevel x$3 = cacheBuilder.copy$default$2();
            Option<String> x$4 = cacheBuilder.copy$default$4();
            LogicalPlan x$5 = cacheBuilder.copy$default$5();
            cachedRDDBuilder = cacheBuilder.copy(x$2, x$3, x$1, x$4, x$5);
        } else {
            SparkPlan x$6 = qe.executedPlan();
            CachedBatchSerializer x$7 = cacheBuilder.copy$default$1();
            StorageLevel x$8 = cacheBuilder.copy$default$2();
            Option<String> x$9 = cacheBuilder.copy$default$4();
            LogicalPlan x$10 = cacheBuilder.copy$default$5();
            cachedRDDBuilder = cacheBuilder.copy(x$7, x$8, x$6, x$9, x$10);
        }
        CachedRDDBuilder newBuilder = cachedRDDBuilder;
        InMemoryRelation relation = new InMemoryRelation((Seq<Attribute>)newBuilder.cachedPlan().output(), newBuilder, (Seq<SortOrder>)optimizedPlan.outputOrdering());
        relation.statsOfPlanToCache_$eq(optimizedPlan.stats());
        return relation;
    }

    public InMemoryRelation apply(Seq<Attribute> output, CachedRDDBuilder cacheBuilder, Seq<SortOrder> outputOrdering, Statistics statsOfPlanToCache) {
        InMemoryRelation relation = new InMemoryRelation(output, cacheBuilder, outputOrdering);
        relation.statsOfPlanToCache_$eq(statsOfPlanToCache);
        return relation;
    }

    public InMemoryRelation apply(Seq<Attribute> output, CachedRDDBuilder cacheBuilder, Seq<SortOrder> outputOrdering) {
        return new InMemoryRelation(output, cacheBuilder, outputOrdering);
    }

    public Option<Tuple3<Seq<Attribute>, CachedRDDBuilder, Seq<SortOrder>>> unapply(InMemoryRelation x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3(x$0.output(), (Object)x$0.cacheBuilder(), x$0.outputOrdering()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(InMemoryRelation$.class);
    }

    private InMemoryRelation$() {
    }
}

