/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.H2Dialect$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.SparkStringUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\r-b!\u0002\u001b6\u0001^z\u0004\"\u0002.\u0001\t\u0003Y\u0006\"B/\u0001\t\u0003r\u0006b\u00027\u0001\u0005\u0004%I!\u001c\u0005\u0007{\u0002\u0001\u000b\u0011\u00028\t\u000fy\u0004!\u0019!C\u0005[\"1q\u0010\u0001Q\u0001\n9D\u0001\"!\u0001\u0001\u0005\u0004%I!\u001c\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003o\u0011\u001d\t)\u0001\u0001C!\u0003\u000fAq!!\u0004\u0001\t\u0003\ny\u0001C\u0004\u0002 \u0001!\t%!\t\t\u000f\u0005\u001d\u0002\u0001\"\u0011\u0002*!9\u0011\u0011\f\u0001\u0005B\u0005m\u0003\"CA5\u0001\t\u0007I\u0011BA6\u0011!\ti\t\u0001Q\u0001\n\u00055\u0004bBAH\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003\u007f\u0002A\u0011IAN\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!a-\u0001\t\u0003\n)\fC\u0004\u0002j\u0002!\t%a;\t\u000f\u0005E\b\u0001\"\u0011\u0002t\"9!\u0011\u0004\u0001\u0005B\tm\u0001b\u0002B\u0019\u0001\u0011%!1\u0007\u0005\b\u0005s\u0001A\u0011\u0002B\u001e\u0011\u001d\u0011\t\u0005\u0001C!\u0005\u0007BqAa\u001c\u0001\t\u0003\u0012\tH\u0002\u0004\u0003\u0000\u0001\u0001!\u0011\u0011\u0005\u00075n!\tAa#\t\u000f\t=5\u0004\"\u0011\u0003\u0012\"9!qT\u000e\u0005B\t\u0005\u0006b\u0002BV7\u0011\u0005#Q\u0016\u0005\b\u0005g\u0003A\u0011\tB[\u0011\u001d\u00119\f\u0001C!\u0005kCqA!/\u0001\t\u0003\u0012)\f\u0003\u0005\u0003<\u0002\t\t\u0011\"\u0001\\\u0011%\u0011i\fAA\u0001\n\u0003\u0012y\fC\u0005\u0003B\u0002\t\t\u0011\"\u0001\u0003D\"I!Q\u0019\u0001\u0002\u0002\u0013\u0005!q\u0019\u0005\n\u0005'\u0004\u0011\u0011!C!\u0005+D\u0011Ba8\u0001\u0003\u0003%\tA!9\t\u0013\t\u0015\b!!A\u0005B\t\u001d\b\"\u0003Bv\u0001\u0005\u0005I\u0011\tBw\u0011%\u0011y\u000fAA\u0001\n\u0003\u0012\t\u0010C\u0005\u0003t\u0002\t\t\u0011\"\u0011\u0003v\u001eQ!\u0011`\u001b\u0002\u0002#\u0005qGa?\u0007\u0013Q*\u0014\u0011!E\u0001o\tu\bB\u0002./\t\u0003\u0019)\u0002C\u0005\u0003p:\n\t\u0011\"\u0012\u0003r\"A1q\u0003\u0018\u0002\u0002\u0013\u00055\fC\u0005\u0004\u001a9\n\t\u0011\"!\u0004\u001c!I1\u0011\u0005\u0018\u0002\u0002\u0013%11\u0005\u0002\n\u0011J\"\u0015.\u00197fGRT!AN\u001c\u0002\t)$'m\u0019\u0006\u0003qe\n1a]9m\u0015\tQ4(A\u0003ta\u0006\u00148N\u0003\u0002={\u00051\u0011\r]1dQ\u0016T\u0011AP\u0001\u0004_J<7#\u0002\u0001A\t\u001ek\u0005CA!C\u001b\u0005)\u0014BA\"6\u0005-QEMY2ES\u0006dWm\u0019;\u0011\u0005\u0005+\u0015B\u0001$6\u0005Equ\u000eT3hC\u000eL(\n\u0012\"D\u000bJ\u0014xN\u001d\t\u0003\u0011.k\u0011!\u0013\u0006\u0002\u0015\u0006)1oY1mC&\u0011A*\u0013\u0002\b!J|G-^2u!\tquK\u0004\u0002P+:\u0011\u0001\u000bV\u0007\u0002#*\u0011!kU\u0001\u0007yI|w\u000e\u001e \u0004\u0001%\t!*\u0003\u0002W\u0013\u00069\u0001/Y2lC\u001e,\u0017B\u0001-Z\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t1\u0016*\u0001\u0004=S:LGO\u0010\u000b\u00029B\u0011\u0011\tA\u0001\nG\u0006t\u0007*\u00198eY\u0016$\"a\u00182\u0011\u0005!\u0003\u0017BA1J\u0005\u001d\u0011un\u001c7fC:DQa\u0019\u0002A\u0002\u0011\f1!\u001e:m!\t)\u0017N\u0004\u0002gOB\u0011\u0001+S\u0005\u0003Q&\u000ba\u0001\u0015:fI\u00164\u0017B\u00016l\u0005\u0019\u0019FO]5oO*\u0011\u0001.S\u0001&I&\u001cH/\u001b8diVs7/\u001e9q_J$X\rZ!hOJ,w-\u0019;f\rVt7\r^5p]N,\u0012A\u001c\t\u0004_R4X\"\u00019\u000b\u0005E\u0014\u0018!C5n[V$\u0018M\u00197f\u0015\t\u0019\u0018*\u0001\u0006d_2dWm\u0019;j_:L!!\u001e9\u0003\u0007M+G\u000f\u0005\u0002xy6\t\u0001P\u0003\u0002zu\u0006!A.\u00198h\u0015\u0005Y\u0018\u0001\u00026bm\u0006L!A\u001b=\u0002M\u0011L7\u000f^5oGR,fn];qa>\u0014H/\u001a3BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u001c\b%A\u000etkB\u0004xN\u001d;fI\u0006;wM]3hCR,g)\u001e8di&|gn]\u0001\u001dgV\u0004\bo\u001c:uK\u0012\fum\u001a:fO\u0006$XMR;oGRLwN\\:!\u0003I\u0019X\u000f\u001d9peR,GMR;oGRLwN\\:\u0002'M,\b\u000f]8si\u0016$g)\u001e8di&|gn\u001d\u0011\u0002'%\u001c8+\u001e9q_J$X\r\u001a$v]\u000e$\u0018n\u001c8\u0015\u0007}\u000bI\u0001\u0003\u0004\u0002\f%\u0001\r\u0001Z\u0001\tMVt7MT1nK\u0006I\u0012n](cU\u0016\u001cGOT8u\r>,h\u000eZ#yG\u0016\u0004H/[8o)\ry\u0016\u0011\u0003\u0005\b\u0003'Q\u0001\u0019AA\u000b\u0003\u0005)\u0007\u0003BA\f\u00037i!!!\u0007\u000b\u0005aR\u0018\u0002BA\u000f\u00033\u0011AbU)M\u000bb\u001cW\r\u001d;j_:\fq#[:Ts:$\u0018\r_#se>\u0014()Z:u\u000b\u001a4wN\u001d;\u0015\u0007}\u000b\u0019\u0003C\u0004\u0002&-\u0001\r!!\u0006\u0002\u0013\u0015D8-\u001a9uS>t\u0017aD4fi\u000e\u000bG/\u00197zgR$\u0016\u0010]3\u0015\u0015\u0005-\u0012QHA$\u0003\u0017\ny\u0005E\u0003I\u0003[\t\t$C\u0002\u00020%\u0013aa\u00149uS>t\u0007\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]r'A\u0003usB,7/\u0003\u0003\u0002<\u0005U\"\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\u0005}B\u00021\u0001\u0002B\u000591/\u001d7UsB,\u0007c\u0001%\u0002D%\u0019\u0011QI%\u0003\u0007%sG\u000f\u0003\u0004\u0002J1\u0001\r\u0001Z\u0001\tif\u0004XMT1nK\"9\u0011Q\n\u0007A\u0002\u0005\u0005\u0013\u0001B:ju\u0016Dq!!\u0015\r\u0001\u0004\t\u0019&\u0001\u0002nIB!\u00111GA+\u0013\u0011\t9&!\u000e\u0003\u001f5+G/\u00193bi\u0006\u0014U/\u001b7eKJ\f1bZ3u\u0015\u0012\u00135\tV=qKR!\u0011QLA3!\u0015A\u0015QFA0!\r\t\u0015\u0011M\u0005\u0004\u0003G*$\u0001\u0003&eE\u000e$\u0016\u0010]3\t\u000f\u0005\u001dT\u00021\u0001\u00022\u0005\u0011A\r^\u0001\fMVt7\r^5p]6\u000b\u0007/\u0006\u0002\u0002nA9\u0011qNA;I\u0006eTBAA9\u0015\r\t\u0019H_\u0001\u0005kRLG.\u0003\u0003\u0002x\u0005E$aA'baB!\u00111PAE\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0015!\u00034v]\u000e$\u0018n\u001c8t\u0015\u0011\t\u0019)!\"\u0002\u000f\r\fG/\u00197pO*\u0019\u0011qQ\u001c\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002BAF\u0003{\u0012q\"\u00168c_VtGMR;oGRLwN\\\u0001\rMVt7\r^5p]6\u000b\u0007\u000fI\u0001\u0011e\u0016<\u0017n\u001d;fe\u001a+hn\u0019;j_:$b!!\u001f\u0002\u0014\u0006]\u0005BBAK!\u0001\u0007A-\u0001\u0003oC6,\u0007bBAM!\u0001\u0007\u0011\u0011P\u0001\u0003M:,\"!!(\u0011\u000b9\u000by*a)\n\u0007\u0005\u0005\u0016LA\u0002TKF\u0004b\u0001SASI\u0006e\u0014bAAT\u0013\n1A+\u001e9mKJ\nab\u00197fCJ4UO\\2uS>t7\u000f\u0006\u0002\u0002.B\u0019\u0001*a,\n\u0007\u0005E\u0016J\u0001\u0003V]&$\u0018aC2sK\u0006$X-\u00138eKb$2\u0002ZA\\\u0003w\u000b9-!8\u0002f\"1\u0011\u0011X\nA\u0002\u0011\f\u0011\"\u001b8eKbt\u0015-\\3\t\u000f\u0005u6\u00031\u0001\u0002@\u0006QA/\u00192mK&#WM\u001c;\u0011\t\u0005\u0005\u00171Y\u0007\u0003\u0003\u0003KA!!2\u0002\u0002\nQ\u0011\nZ3oi&4\u0017.\u001a:\t\u000f\u0005%7\u00031\u0001\u0002L\u000691m\u001c7v[:\u001c\b#\u0002%\u0002N\u0006E\u0017bAAh\u0013\n)\u0011I\u001d:bsB!\u00111[Am\u001b\t\t)N\u0003\u0003\u0002X\u0006\u0015\u0015aC3yaJ,7o]5p]NLA!a7\u0002V\nqa*Y7fIJ+g-\u001a:f]\u000e,\u0007bBAp'\u0001\u0007\u0011\u0011]\u0001\u0012G>dW/\u001c8t!J|\u0007/\u001a:uS\u0016\u001c\b\u0003CA8\u0003k\n\t.a9\u0011\r\u0005=\u0014Q\u000f3e\u0011\u001d\t9o\u0005a\u0001\u0003G\f!\u0002\u001d:pa\u0016\u0014H/[3t\u0003%!'o\u001c9J]\u0012,\u0007\u0010F\u0003e\u0003[\fy\u000f\u0003\u0004\u0002:R\u0001\r\u0001\u001a\u0005\b\u0003{#\u0002\u0019AA`\u0003-Ig\u000eZ3y\u000bbL7\u000f^:\u0015\u0013}\u000b)0a@\u0003\u0002\t\r\u0001bBA|+\u0001\u0007\u0011\u0011`\u0001\u0005G>tg\u000e\u0005\u0003\u0002\u0018\u0005m\u0018\u0002BA\u007f\u00033\u0011!bQ8o]\u0016\u001cG/[8o\u0011\u0019\tI,\u0006a\u0001I\"9\u0011QX\u000bA\u0002\u0005}\u0006b\u0002B\u0003+\u0001\u0007!qA\u0001\b_B$\u0018n\u001c8t!\u0011\u0011IA!\u0006\u000e\u0005\t-!b\u0001\u001c\u0003\u000e)!!q\u0002B\t\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0007\tMq'A\u0005fq\u0016\u001cW\u000f^5p]&!!q\u0003B\u0006\u0005-QEIQ\"PaRLwN\\:\u0002\u00171L7\u000f^%oI\u0016DXm\u001d\u000b\t\u0005;\u0011YC!\f\u00030A)\u0001*!4\u0003 A!!\u0011\u0005B\u0014\u001b\t\u0011\u0019C\u0003\u0003\u0003&\u0005\u0005\u0015!B5oI\u0016D\u0018\u0002\u0002B\u0015\u0005G\u0011!\u0002V1cY\u0016Le\u000eZ3y\u0011\u001d\t9P\u0006a\u0001\u0003sDq!!0\u0017\u0001\u0004\ty\fC\u0004\u0003\u0006Y\u0001\rAa\u0002\u0002'Q\f'\r\\3OC6,w+\u001b;i'\u000eDW-\\1\u0015\u0007\u0011\u0014)\u0004C\u0004\u00038]\u0001\r!a0\u0002\u000b%$WM\u001c;\u0002'%tG-\u001a=OC6,w+\u001b;i'\u000eDW-\\1\u0015\u000b\u0011\u0014iDa\u0010\t\u000f\t]\u0002\u00041\u0001\u0002@\"1\u0011\u0011\u0018\rA\u0002\u0011\f\u0011c\u00197bgNLg-_#yG\u0016\u0004H/[8o)1\u0011)E!\u0017\u0003\\\t}#q\rB6%\u0019\u00119Ea\u0013\u0003R\u00191!\u0011\n\u0001\u0001\u0005\u000b\u0012A\u0002\u0010:fM&tW-\\3oiz\u00022A\u0014B'\u0013\r\u0011y%\u0017\u0002\n)\"\u0014xn^1cY\u0016\u0004BAa\u0015\u0003V5\t\u0011(C\u0002\u0003Xe\u0012ab\u00159be.$\u0006N]8xC\ndW\rC\u0004\u0002\u0014e\u0001\rAa\u0013\t\r\tu\u0013\u00041\u0001e\u0003%\u0019wN\u001c3ji&|g\u000eC\u0004\u0003be\u0001\rAa\u0019\u0002#5,7o]1hKB\u000b'/Y7fi\u0016\u00148\u000fE\u0003f\u0005K\"G-C\u0002\u0002x-DaA!\u001b\u001a\u0001\u0004!\u0017a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:DaA!\u001c\u001a\u0001\u0004y\u0016!C5t%VtG/[7f\u0003E\u0019w.\u001c9jY\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u000b\u0005\u0005g\u0012)\b\u0005\u0003I\u0003[!\u0007b\u0002B<5\u0001\u0007!\u0011P\u0001\u0005Kb\u0004(\u000f\u0005\u0003\u0002T\nm\u0014\u0002\u0002B?\u0003+\u0014!\"\u0012=qe\u0016\u001c8/[8o\u00051A%gU)M\u0005VLG\u000eZ3s'\rY\"1\u0011\t\u0005\u0005\u000b\u00139)D\u0001\u0001\u0013\r\u0011II\u0011\u0002\u000f\u0015\u0012\u00135iU)M\u0005VLG\u000eZ3s)\t\u0011i\tE\u0002\u0003\u0006n\taC^5tSR\fum\u001a:fO\u0006$XMR;oGRLwN\u001c\u000b\bI\nM%Q\u0013BM\u0011\u0019\tY!\ba\u0001I\"1!qS\u000fA\u0002}\u000b!\"[:ESN$\u0018N\\2u\u0011\u001d\u0011Y*\ba\u0001\u0005;\u000ba!\u001b8qkR\u001c\b\u0003\u0002%\u0002N\u0012\fAB^5tSR,\u0005\u0010\u001e:bGR$R\u0001\u001aBR\u0005OCaA!*\u001f\u0001\u0004!\u0017!\u00024jK2$\u0007B\u0002BU=\u0001\u0007A-\u0001\u0004t_V\u00148-Z\u0001\u0011m&\u001c\u0018\u000e^*R\u0019\u001a+hn\u0019;j_:$R\u0001\u001aBX\u0005cCa!a\u0003 \u0001\u0004!\u0007b\u0002BN?\u0001\u0007!QT\u0001\u000egV\u0004\bo\u001c:ug2KW.\u001b;\u0016\u0003}\u000bab];qa>\u0014Ho](gMN,G/\u0001\u0007tkB\u0004xN\u001d;t\u0015>Lg.\u0001\u0003d_BL\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001w\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t%\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t%'q\u001a\t\u0004\u0011\n-\u0017b\u0001Bg\u0013\n\u0019\u0011I\\=\t\u0013\tEg%!AA\u0002\u0005\u0005\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003XB1!\u0011\u001cBn\u0005\u0013l\u0011A]\u0005\u0004\u0005;\u0014(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2a\u0018Br\u0011%\u0011\t\u000eKA\u0001\u0002\u0004\u0011I-\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,Gc\u0001<\u0003j\"I!\u0011[\u0015\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011I\u0001\ti>\u001cFO]5oOR\ta/\u0001\u0004fcV\fGn\u001d\u000b\u0004?\n]\b\"\u0003BiY\u0005\u0005\t\u0019\u0001Be\u0003%A%\u0007R5bY\u0016\u001cG\u000f\u0005\u0002B]M)aFa@\u0004\fA)1\u0011AB\u000496\u001111\u0001\u0006\u0004\u0007\u000bI\u0015a\u0002:v]RLW.Z\u0005\u0005\u0007\u0013\u0019\u0019AA\tBEN$(/Y2u\rVt7\r^5p]B\u0002Ba!\u0004\u0004\u00145\u00111q\u0002\u0006\u0004\u0007#Q\u0018AA5p\u0013\rA6q\u0002\u000b\u0003\u0005w\fQ!\u00199qYf\fq!\u001e8baBd\u0017\u0010F\u0002`\u0007;A\u0001ba\b3\u0003\u0003\u0005\r\u0001X\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAB\u0013!\r98qE\u0005\u0004\u0007SA(AB(cU\u0016\u001cG\u000f")
public class H2Dialect
extends JdbcDialect
implements NoLegacyJDBCError,
Product {
    private final Set<String> org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;
    private final Map<String, UnboundFunction> functionMap;

    public static boolean unapply(H2Dialect x$0) {
        return H2Dialect$.MODULE$.unapply(x$0);
    }

    public static H2Dialect apply() {
        return H2Dialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:h2");
    }

    public Set<String> org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public boolean isObjectNotFoundException(SQLException e) {
        return ((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{42102, 42103, 42104, 90079}))).contains((Object)BoxesRunTime.boxToInteger((int)e.getErrorCode()));
    }

    @Override
    public boolean isSyntaxErrorBestEffort(SQLException exception) {
        return Option$.MODULE$.apply((Object)exception.getSQLState()).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("42")));
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case 2: {
                if (size <= 38) break;
                long scale = md != null ? md.build().getLong("scale") : 0L;
                int selectedScale = (int)((double)DecimalType$.MODULE$.MAX_PRECISION() * ((double)scale / (double)size));
                return Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), selectedScale));
            }
            case 2013: 
            case 2014: {
                return new Some((Object)TimestampType$.MODULE$);
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("CLOB", 2005));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return new Some((Object)new JdbcType("NUMERIC(" + decimalType.precision() + "," + decimalType.scale() + ")", 2));
        }
        return JdbcUtils$.MODULE$.getCommonJDBCType(dt);
    }

    private Map<String, UnboundFunction> functionMap() {
        return this.functionMap;
    }

    public UnboundFunction registerFunction(String name, UnboundFunction fn) {
        return this.functionMap().put(name, fn);
    }

    @Override
    public Seq<Tuple2<String, UnboundFunction>> functions() {
        return CollectionConverters$.MODULE$.MapHasAsScala(this.functionMap()).asScala().toSeq();
    }

    public void clearFunctions() {
        this.functionMap().clear();
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String[] columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> this.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
        Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "h2");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String indexType = (String)tuple2._1();
        String indexType2 = indexType;
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " " + indexType2 + " ON " + this.tableNameWithSchema(tableIdent) + " (" + Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ") + ")";
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return "DROP INDEX " + this.indexNameWithSchema(tableIdent, indexName);
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = "SELECT * FROM INFORMATION_SCHEMA.INDEXES WHERE TABLE_SCHEMA = '" + ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])tableIdent.namespace())) + "' AND TABLE_NAME = '" + tableIdent.name() + "' AND INDEX_NAME = '" + indexName + "'";
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        String sql = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         | SELECT\n         |   i.INDEX_CATALOG AS INDEX_CATALOG,\n         |   i.INDEX_SCHEMA AS INDEX_SCHEMA,\n         |   i.INDEX_NAME AS INDEX_NAME,\n         |   i.INDEX_TYPE_NAME AS INDEX_TYPE_NAME,\n         |   i.REMARKS as REMARKS,\n         |   ic.COLUMN_NAME AS COLUMN_NAME\n         | FROM INFORMATION_SCHEMA.INDEXES i, INFORMATION_SCHEMA.INDEX_COLUMNS ic\n         | WHERE i.TABLE_CATALOG = ic.TABLE_CATALOG\n         | AND i.TABLE_SCHEMA = ic.TABLE_SCHEMA\n         | AND i.TABLE_NAME = ic.TABLE_NAME\n         | AND i.INDEX_CATALOG = ic.INDEX_CATALOG\n         | AND i.INDEX_SCHEMA = ic.INDEX_SCHEMA\n         | AND i.INDEX_NAME = ic.INDEX_NAME\n         | AND i.TABLE_NAME = '" + tableIdent.name() + "'\n         | AND i.INDEX_SCHEMA = '" + ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])tableIdent.namespace())) + "'\n         |"));
        ObjectRef indexMap = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, sql, (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                H2Dialect.$anonfun$listIndexes$1(indexMap, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot retrieved index info.");
        }
        return (TableIndex[])((scala.collection.immutable.Map)indexMap.elem).values().toArray(ClassTag$.MODULE$.apply(TableIndex.class));
    }

    private String tableNameWithSchema(Identifier ident) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Object)ident.name(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)colName -> this.quoteIdentifier((String)colName), ClassTag$.MODULE$.apply(String.class))).mkString(".");
    }

    private String indexNameWithSchema(Identifier ident, String indexName) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Object)indexName, ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)colName -> this.quoteIdentifier((String)colName), ClassTag$.MODULE$.apply(String.class))).mkString(".");
    }

    @Override
    public Throwable classifyException(Throwable e, String condition, scala.collection.immutable.Map<String, String> messageParameters, String description, boolean isRuntime) {
        block7: {
            Throwable throwable = e;
            if (!(throwable instanceof SQLException)) break block7;
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 42101: {
                    Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"((?:[^\"\\\\]|\\\\[\\\\\"ntbrf])+)\""));
                    String name = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)e.getMessage()).get()).group(1);
                    String quotedName = package$.MODULE$.quoteIdentifier(name);
                    throw new TableAlreadyExistsException("TABLE_OR_VIEW_ALREADY_EXISTS", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)quotedName)})), (Option)new Some((Object)e));
                }
                case 42102: {
                    String relationName = (String)messageParameters.getOrElse((Object)"tableName", (Function0 & Serializable)() -> "");
                    throw new NoSuchTableException("TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)relationName)})), (Option)new Some((Object)e));
                }
                case 90079: {
                    Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"((?:[^\"\\\\]|\\\\[\\\\\"ntbrf])+)\""));
                    String name = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)e.getMessage()).get()).group(1);
                    String quotedName = package$.MODULE$.quoteIdentifier(name);
                    throw new NoSuchNamespaceException("SCHEMA_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)quotedName)})));
                }
                case 42111: {
                    String string = condition;
                    String string2 = "FAILED_JDBC.CREATE_INDEX";
                    if (string != null ? !string.equals(string2) : string2 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new IndexAlreadyExistsException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 42112: {
                    String string = condition;
                    String string3 = "FAILED_JDBC.DROP_INDEX";
                    if (string != null ? !string.equals(string3) : string3 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
            }
        }
        return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        H2SQLBuilder h2SQLBuilder = new H2SQLBuilder(this);
        try {
            some = new Some((Object)h2SQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsJoin() {
        return true;
    }

    public H2Dialect copy() {
        return new H2Dialect();
    }

    public String productPrefix() {
        return "H2Dialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof H2Dialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof H2Dialect && ((H2Dialect)x$1).canEqual(this);
    }

    public static final /* synthetic */ void $anonfun$listIndexes$1(ObjectRef indexMap$1, ResultSet rs) {
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            String colName = rs.getString("COLUMN_NAME");
            String indexType = rs.getString("INDEX_TYPE_NAME");
            String indexComment = rs.getString("REMARKS");
            if (((scala.collection.immutable.Map)indexMap$1.elem).contains((Object)indexName)) {
                TableIndex index = (TableIndex)((scala.collection.immutable.Map)indexMap$1.elem).apply((Object)indexName);
                TableIndex newIndex = new TableIndex(indexName, indexType, (NamedReference[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])index.columns()), (Object)FieldReference$.MODULE$.apply(colName), ClassTag$.MODULE$.apply(NamedReference.class)), index.columnProperties(), index.properties());
                indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)newIndex));
                continue;
            }
            Properties properties = new Properties();
            Object object = SparkStringUtils$.MODULE$.isNotEmpty(indexComment) ? properties.put("COMMENT", indexComment) : BoxedUnit.UNIT;
            TableIndex index = new TableIndex(indexName, indexType, (NamedReference[])((Object[])new NamedReference[]{FieldReference$.MODULE$.apply(colName)}), new HashMap(), properties);
            indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)index));
        }
    }

    public H2Dialect() {
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY", "MODE", "PERCENTILE_CONT", "PERCENTILE_DISC"}));
        this.supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}))).$plus$plus(this.org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = (Set)this.supportedAggregateFunctions().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ABS", "COALESCE", "GREATEST", "LEAST", "RAND", "LOG", "LOG10", "LN", "EXP", "POWER", "SQRT", "FLOOR", "CEIL", "ROUND", "SIN", "SINH", "COS", "COSH", "TAN", "TANH", "COT", "ASIN", "ACOS", "ATAN", "ATAN2", "DEGREES", "RADIANS", "SIGN", "PI", "SUBSTRING", "UPPER", "LOWER", "TRANSLATE", "TRIM", "MD5", "SHA1", "SHA2", "BIT_LENGTH", "CHAR_LENGTH", "CONCAT", "RPAD", "LPAD"})));
        this.functionMap = new ConcurrentHashMap<String, UnboundFunction>();
    }

    public class H2SQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        @Override
        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (isDistinct && this.org$apache$spark$sql$jdbc$H2Dialect$H2SQLBuilder$$$outer().org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions().contains((Object)funcName)) {
                throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3184", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.getClass().getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
            }
            return super.visitAggregateFunction(funcName, isDistinct, inputs);
        }

        public String visitExtract(String field, String source) {
            String string;
            block5: {
                String string2 = field;
                switch (string2 == null ? 0 : string2.hashCode()) {
                    case -1351979174: {
                        if (!"YEAR_OF_WEEK".equals(string2)) break;
                        string = "ISO_WEEK_YEAR";
                        break block5;
                    }
                    case 2660340: {
                        if (!"WEEK".equals(string2)) break;
                        string = "ISO_WEEK";
                        break block5;
                    }
                    case 2074232729: {
                        if (!"DAY_OF_WEEK".equals(string2)) break;
                        string = "ISO_DAY_OF_WEEK";
                        break block5;
                    }
                }
                string = field;
            }
            String newField = string;
            return "EXTRACT(" + newField + " FROM " + source + ")";
        }

        @Override
        public String visitSQLFunction(String funcName, String[] inputs) {
            String string = funcName;
            switch (string == null ? 0 : string.hashCode()) {
                case 76158: {
                    if (!"MD5".equals(string)) break;
                    return "RAWTOHEX(HASH('MD5', " + Predef$.MODULE$.wrapRefArray((Object[])inputs).mkString(",") + "))";
                }
                case 2543909: {
                    if (!"SHA1".equals(string)) break;
                    return "RAWTOHEX(HASH('SHA-1', " + Predef$.MODULE$.wrapRefArray((Object[])inputs).mkString(",") + "))";
                }
                case 2543910: {
                    if (!"SHA2".equals(string)) break;
                    return "RAWTOHEX(HASH('SHA-" + inputs[1] + "'," + inputs[0] + "))";
                }
            }
            return super.visitSQLFunction(funcName, inputs);
        }

        public /* synthetic */ H2Dialect org$apache$spark$sql$jdbc$H2Dialect$H2SQLBuilder$$$outer() {
            return (H2Dialect)this.$outer;
        }

        public H2SQLBuilder(H2Dialect $outer) {
            super($outer);
        }
    }
}

