/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.UnifiedMemoryManager$;
import org.apache.spark.memory.UnmanagedMemoryConsumer;
import org.apache.spark.memory.UnmanagedMemoryConsumerId;
import org.apache.spark.sql.execution.streaming.state.RocksDBConf;
import org.apache.spark.sql.execution.streaming.state.RocksDBMemoryManager;
import org.rocksdb.Cache;
import org.rocksdb.LRUCache;
import org.rocksdb.WriteBufferManager;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class RocksDBMemoryManager$
implements Logging,
UnmanagedMemoryConsumer {
    public static final RocksDBMemoryManager$ MODULE$ = new RocksDBMemoryManager$();
    private static WriteBufferManager writeBufferManager;
    private static Cache cache;
    private static final ConcurrentHashMap<String, RocksDBMemoryManager.InstanceMemoryInfo> instanceMemoryMap;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        writeBufferManager = null;
        cache = null;
        instanceMemoryMap = new ConcurrentHashMap();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private WriteBufferManager writeBufferManager() {
        return writeBufferManager;
    }

    private void writeBufferManager_$eq(WriteBufferManager x$1) {
        writeBufferManager = x$1;
    }

    private Cache cache() {
        return cache;
    }

    private void cache_$eq(Cache x$1) {
        cache = x$1;
    }

    private ConcurrentHashMap<String, RocksDBMemoryManager.InstanceMemoryInfo> instanceMemoryMap() {
        return instanceMemoryMap;
    }

    public UnmanagedMemoryConsumerId unmanagedMemoryConsumerId() {
        return new UnmanagedMemoryConsumerId("RocksDB", "RocksDB-Memory-Manager");
    }

    public MemoryMode memoryMode() {
        return MemoryMode.OFF_HEAP;
    }

    public long getMemBytesUsed() {
        Seq memoryInfos = CollectionConverters$.MODULE$.CollectionHasAsScala(this.instanceMemoryMap().values()).asScala().toSeq();
        if (memoryInfos.isEmpty()) {
            return 0L;
        }
        Tuple2 tuple2 = memoryInfos.partition((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isBoundedMemory()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq bounded = (Seq)tuple2._1();
        Seq unbounded = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)bounded, (Object)unbounded);
        Seq bounded2 = (Seq)tuple22._1();
        Seq unbounded2 = (Seq)tuple22._2();
        long boundedMemory = bounded2.nonEmpty() ? BoxesRunTime.unboxToLong((Object)((IterableOnceOps)bounded2.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.memoryUsage()))).max((Ordering)Ordering.Long$.MODULE$)) : 0L;
        long unboundedMemory = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)unbounded2.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.memoryUsage()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return boundedMemory + unboundedMemory;
    }

    public void updateMemoryUsage(String uniqueId, long memoryUsage, boolean isBoundedMemory) {
        this.instanceMemoryMap().put(uniqueId, new RocksDBMemoryManager.InstanceMemoryInfo(memoryUsage, isBoundedMemory));
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Updated memory usage for " + uniqueId + ": " + memoryUsage + " bytes (bounded=" + isBoundedMemory + ")");
    }

    public void unregisterInstance(String uniqueId) {
        this.instanceMemoryMap().remove(uniqueId);
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Unregistered instance " + uniqueId);
    }

    public long getNumRocksDBInstances(boolean boundedMemory) {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(this.instanceMemoryMap().values()).asScala().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)RocksDBMemoryManager$.$anonfun$getNumRocksDBInstances$1(boundedMemory, x$5)));
    }

    public long getInstanceMemoryUsage(String uniqueId, long totalMemoryUsage) {
        RocksDBMemoryManager.InstanceMemoryInfo instanceInfo = this.instanceMemoryMap().getOrDefault(uniqueId, new RocksDBMemoryManager.InstanceMemoryInfo(0L, false));
        if (instanceInfo.isBoundedMemory()) {
            long numBoundedInstances = this.getNumRocksDBInstances(true);
            return totalMemoryUsage / numBoundedInstances;
        }
        return totalMemoryUsage;
    }

    public synchronized Tuple2<WriteBufferManager, Cache> getOrCreateRocksDBMemoryManagerAndCache(RocksDBConf conf) {
        if (SparkEnv$.MODULE$.get() != null) {
            UnifiedMemoryManager$.MODULE$.registerUnmanagedMemoryConsumer((UnmanagedMemoryConsumer)this);
        }
        if (conf.boundedMemoryUsage()) {
            if (this.writeBufferManager() == null) {
                Predef$.MODULE$.assert(this.cache() == null);
                if (conf.writeBufferCacheRatio() + conf.highPriorityPoolRatio() >= 1.0) {
                    throw new IllegalArgumentException("Sum of writeBufferCacheRatio and highPriorityPoolRatio should be less than 1.0");
                }
                if (conf.totalMemoryUsageMB() <= 0L) {
                    throw new IllegalArgumentException("Total memory usage must be a positive integer");
                }
                long totalMemoryUsageInBytes = conf.totalMemoryUsageMB() * 1024L * 1024L;
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Creating RocksDB state store LRU cache with "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"total_size=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.NUM_BYTES, BoxesRunTime.boxToLong((long)totalMemoryUsageInBytes))})))));
                this.cache_$eq((Cache)new LRUCache(totalMemoryUsageInBytes, -1, false, conf.highPriorityPoolRatio()));
                this.writeBufferManager_$eq(new WriteBufferManager((long)((double)totalMemoryUsageInBytes * conf.writeBufferCacheRatio()), this.cache()));
            }
            return new Tuple2((Object)this.writeBufferManager(), (Object)this.cache());
        }
        return new Tuple2(null, (Object)new LRUCache(conf.blockCacheSizeMB() * 1024L * 1024L));
    }

    public synchronized void resetWriteBufferManagerAndCache() {
        this.writeBufferManager_$eq(null);
        this.cache_$eq(null);
        this.instanceMemoryMap().clear();
    }

    public static final /* synthetic */ boolean $anonfun$getNumRocksDBInstances$1(boolean boundedMemory$1, RocksDBMemoryManager.InstanceMemoryInfo x$5) {
        return x$5.isBoundedMemory() == boundedMemory$1;
    }

    private RocksDBMemoryManager$() {
    }
}

