/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.SparkException$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.SparkShreddingUtils$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.types.variant.Variant;
import org.apache.spark.types.variant.VariantSchema;
import org.apache.spark.unsafe.types.VariantVal;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t5f\u0001B\u001c9\u0001\u001dCQ!\u0018\u0001\u0005\u0002y+A!\u0019\u0001\u0005E\"IA\u000f\u0001a\u0001\u0002\u0004%I!\u001e\u0005\ny\u0002\u0001\r\u00111A\u0005\nuD!\"!\u0001\u0001\u0001\u0004\u0005\t\u0015)\u0003w\u0011)\t\u0019\u0001\u0001a\u0001\u0002\u0004%I!\u001e\u0005\f\u0003\u000b\u0001\u0001\u0019!a\u0001\n\u0013\t9\u0001\u0003\u0006\u0002\f\u0001\u0001\r\u0011!Q!\nYD1\"!\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0010!Y\u00111\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u000f\u0011-\t\t\u0003\u0001a\u0001\u0002\u0003\u0006K!!\u0005\t\u0017\u0005\r\u0002\u00011AA\u0002\u0013%\u0011Q\u0005\u0005\f\u0003k\u0001\u0001\u0019!a\u0001\n\u0013\t9\u0004C\u0006\u0002<\u0001\u0001\r\u0011!Q!\n\u0005\u001d\u0002bCA\u001f\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u007fA1\"a\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002J!Y\u0011Q\n\u0001A\u0002\u0003\u0005\u000b\u0015BA!\u0011-\ty\u0005\u0001a\u0001\u0002\u0004%I!!\u0015\t\u0017\u0005=\u0004\u00011AA\u0002\u0013%\u0011\u0011\u000f\u0005\f\u0003k\u0002\u0001\u0019!A!B\u0013\t\u0019\u0006C\u0005\u0002x\u0001\u0011\r\u0011\"\u0003\u0002z!A\u00111\u0011\u0001!\u0002\u0013\tY\bC\u0005\u0002\u0006\u0002\u0011\r\u0011\"\u0003\u0002z!A\u0011q\u0011\u0001!\u0002\u0013\tY\bC\u0005\u0002\n\u0002\u0011\r\u0011\"\u0003\u0002\f\"A\u0011Q\u0013\u0001!\u0002\u0013\ti\tC\u0005\u0002\u0018\u0002\u0011\r\u0011\"\u0003\u0002\u001a\"A\u0011\u0011\u0015\u0001!\u0002\u0013\tY\nC\u0005\u0002$\u0002\u0011\r\u0011\"\u0003\u0002&\"A\u0011q\u0016\u0001!\u0002\u0013\t9\u000bC\u0005\u00022\u0002\u0011\r\u0011\"\u0003\u0002\f\"A\u00111\u0017\u0001!\u0002\u0013\ti\tC\u0005\u00026\u0002\u0011\r\u0011\"\u0003\u0002&\"A\u0011q\u0017\u0001!\u0002\u0013\t9\u000bC\u0004\u0002:\u0002!\t%a/\t\u000f\u0005]\b\u0001\"\u0011\u0002z\"9\u0011Q \u0001\u0005B\u0005}\bb\u0002B\u0003\u0001\u0011%!q\u0001\u0005\b\u0005#\u0001A\u0011\u0002B\n\u0011\u001d\u0011\u0019\u0003\u0001C\u0005\u0005KAqAa\f\u0001\t\u0003\u0011\t\u0004C\u0004\u0003@\u0001!IA!\u0011\t\u000f\t=\u0003\u0001\"\u0003\u0003R!9!Q\f\u0001\u0005\n\t}\u0003b\u0002B2\u0001\u0011%!QM\u0004\b\u0005\u0007C\u0004\u0012\u0001BC\r\u00199\u0004\b#\u0001\u0003\b\"1Ql\fC\u0001\u0005\u001fC\u0011B!%0\u0005\u0004%\tAa%\t\u0011\tUu\u0006)A\u0005\u0005_B\u0011Ba&0\u0005\u0004%\tAa%\t\u0011\teu\u0006)A\u0005\u0005_BqAa'0\t\u0003\u0011i\nC\u0004\u0003$>\"\tA!*\u0003'A\u000b'/];fi^\u0013\u0018\u000e^3TkB\u0004xN\u001d;\u000b\u0005eR\u0014a\u00029beF,X\r\u001e\u0006\u0003wq\n1\u0002Z1uCN|WO]2fg*\u0011QHP\u0001\nKb,7-\u001e;j_:T!a\u0010!\u0002\u0007M\fHN\u0003\u0002B\u0005\u0006)1\u000f]1sW*\u00111\tR\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\u000b1a\u001c:h\u0007\u0001\u00192\u0001\u0001%X!\rIu*U\u0007\u0002\u0015*\u00111\nT\u0001\u0004CBL'BA'O\u0003\u0019A\u0017\rZ8pa*\u0011\u0011HQ\u0005\u0003!*\u0013Ab\u0016:ji\u0016\u001cV\u000f\u001d9peR\u0004\"AU+\u000e\u0003MS!\u0001\u0016 \u0002\u0011\r\fG/\u00197zgRL!AV*\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\t\u00031nk\u0011!\u0017\u0006\u00035\u0002\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00039f\u0013q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002?B\u0011\u0001\rA\u0007\u0002q\tYa+\u00197vK^\u0013\u0018\u000e^3s!\u0015\u0019g\r\u001b8r\u001b\u0005!'\"A3\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d$'!\u0003$v]\u000e$\u0018n\u001c83!\tIG.D\u0001k\u0015\tY7+A\u0006fqB\u0014Xm]:j_:\u001c\u0018BA7k\u0005I\u0019\u0006/Z2jC2L'0\u001a3HKR$XM]:\u0011\u0005\r|\u0017B\u00019e\u0005\rIe\u000e\u001e\t\u0003GJL!a\u001d3\u0003\tUs\u0017\u000e^\u0001\u0007g\u000eDW-\\1\u0016\u0003Y\u0004\"a\u001e>\u000e\u0003aT!!\u001f \u0002\u000bQL\b/Z:\n\u0005mD(AC*ueV\u001cG\u000fV=qK\u0006Q1o\u00195f[\u0006|F%Z9\u0015\u0005Et\bbB@\u0005\u0003\u0003\u0005\rA^\u0001\u0004q\u0012\n\u0014aB:dQ\u0016l\u0017\rI\u0001\u000fg\"\u0014X\r\u001a3fIN\u001b\u0007.Z7b\u0003I\u0019\bN]3eI\u0016$7k\u00195f[\u0006|F%Z9\u0015\u0007E\fI\u0001C\u0004\u0000\u000f\u0005\u0005\t\u0019\u0001<\u0002\u001fMD'/\u001a3eK\u0012\u001c6\r[3nC\u0002\n\u0001C]8pi\u001aKW\r\u001c3Xe&$XM]:\u0016\u0005\u0005E\u0001#B2\u0002\u0014\u0005]\u0011bAA\u000bI\n)\u0011I\u001d:bsB\u0019\u0011\u0011\u0004\u0002\u000e\u0003\u0001\tAC]8pi\u001aKW\r\u001c3Xe&$XM]:`I\u0015\fHcA9\u0002 !AqPCA\u0001\u0002\u0004\t\t\"A\ts_>$h)[3mI^\u0013\u0018\u000e^3sg\u0002\naB]3d_J$7i\u001c8tk6,'/\u0006\u0002\u0002(A!\u0011\u0011FA\u0019\u001b\t\tYCC\u0002L\u0003[Q1!a\fO\u0003\tIw.\u0003\u0003\u00024\u0005-\"A\u0004*fG>\u0014HmQ8ogVlWM]\u0001\u0013e\u0016\u001cwN\u001d3D_:\u001cX/\\3s?\u0012*\u0017\u000fF\u0002r\u0003sA\u0001b`\u0007\u0002\u0002\u0003\u0007\u0011qE\u0001\u0010e\u0016\u001cwN\u001d3D_:\u001cX/\\3sA\u0005ArO]5uK2+w-Y2z!\u0006\u0014\u0018/^3u\r>\u0014X.\u0019;\u0016\u0005\u0005\u0005\u0003cA2\u0002D%\u0019\u0011Q\t3\u0003\u000f\t{w\u000e\\3b]\u0006arO]5uK2+w-Y2z!\u0006\u0014\u0018/^3u\r>\u0014X.\u0019;`I\u0015\fHcA9\u0002L!Aq\u0010EA\u0001\u0002\u0004\t\t%A\rxe&$X\rT3hC\u000eL\b+\u0019:rk\u0016$hi\u001c:nCR\u0004\u0013aE8viB,H\u000fV5nKN$\u0018-\u001c9UsB,WCAA*!\u0011\t)&a\u001a\u000f\t\u0005]\u0013\u0011\r\b\u0005\u00033\ni&\u0004\u0002\u0002\\)\u0011!LP\u0005\u0005\u0003?\nY&A\u0004T#2\u001buN\u001c4\n\t\u0005\r\u0014QM\u0001\u001b!\u0006\u0014\u0018/^3u\u001fV$\b/\u001e;US6,7\u000f^1naRK\b/\u001a\u0006\u0005\u0003?\nY&\u0003\u0003\u0002j\u0005-$!\u0002,bYV,\u0017bAA7I\nYQI\\;nKJ\fG/[8o\u0003]yW\u000f\u001e9viRKW.Z:uC6\u0004H+\u001f9f?\u0012*\u0017\u000fF\u0002r\u0003gB\u0001b`\n\u0002\u0002\u0003\u0007\u00111K\u0001\u0015_V$\b/\u001e;US6,7\u000f^1naRK\b/\u001a\u0011\u0002\u001fQLW.Z:uC6\u0004()\u001e4gKJ,\"!a\u001f\u0011\u000b\r\f\u0019\"! \u0011\u0007\r\fy(C\u0002\u0002\u0002\u0012\u0014AAQ=uK\u0006\u0001B/[7fgR\fW\u000e\u001d\"vM\u001a,'\u000fI\u0001\u000eI\u0016\u001c\u0017.\\1m\u0005V4g-\u001a:\u0002\u001d\u0011,7-[7bY\n+hMZ3sA\u0005\u0011B-\u0019;fi&lWMU3cCN,Wj\u001c3f+\t\ti\t\u0005\u0003\u0002\u0010\u0006\u001dd\u0002BA-\u0003#KA!a%\u0002\\\u0005!B*Z4bGf\u0014U\r[1wS>\u0014\bk\u001c7jGf\f1\u0003Z1uKRLW.\u001a*fE\u0006\u001cX-T8eK\u0002\na\u0002Z1uKJ+'-Y:f\rVt7-\u0006\u0002\u0002\u001cB)1-!(o]&\u0019\u0011q\u00143\u0003\u0013\u0019+hn\u0019;j_:\f\u0014a\u00043bi\u0016\u0014VMY1tK\u001a+hn\u0019\u0011\u0002'QLW.Z:uC6\u0004(+\u001a2bg\u00164UO\\2\u0016\u0005\u0005\u001d\u0006cB2\u0002\u001e\u0006%\u0016\u0011\u0016\t\u0004G\u0006-\u0016bAAWI\n!Aj\u001c8h\u0003Q!\u0018.\\3ti\u0006l\u0007OU3cCN,g)\u001e8dA\u0005y\u0011N\u001c;:mI+'-Y:f\u001b>$W-\u0001\tj]RLdGU3cCN,Wj\u001c3fA\u0005y\u0011N\u001c;:mI+'-Y:f\rVt7-\u0001\tj]RLdGU3cCN,g)\u001e8dA\u0005!\u0011N\\5u)\u0011\ti,!:\u0011\t\u0005}\u0016q\u001c\b\u0005\u0003\u0003\fYN\u0004\u0003\u0002D\u0006eg\u0002BAc\u0003/tA!a2\u0002V:!\u0011\u0011ZAj\u001d\u0011\tY-!5\u000e\u0005\u00055'bAAh\r\u00061AH]8pizJ\u0011!R\u0005\u0003\u0007\u0012K!!\u000f\"\n\u00055s\u0015BA&M\u0013\r\tiNS\u0001\r/JLG/Z*vaB|'\u000f^\u0005\u0005\u0003C\f\u0019O\u0001\u0007Xe&$XmQ8oi\u0016DHOC\u0002\u0002^*Cq!a:$\u0001\u0004\tI/A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0005\u0003W\f\u00190\u0004\u0002\u0002n*!\u0011q^Ay\u0003\u0011\u0019wN\u001c4\u000b\u00055\u0013\u0015\u0002BA{\u0003[\u0014QbQ8oM&<WO]1uS>t\u0017a\u00049sKB\f'/\u001a$pe^\u0013\u0018\u000e^3\u0015\u0007E\fY\u0010C\u0004\u0002$\u0011\u0002\r!a\n\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0007E\u0014\t\u0001\u0003\u0004\u0003\u0004\u0015\u0002\r!U\u0001\u0004e><\u0018aC<sSR,g)[3mIN$r!\u001dB\u0005\u0005\u0017\u0011i\u0001\u0003\u0004\u0003\u0004\u0019\u0002\r!\u0015\u0005\u0006i\u001a\u0002\rA\u001e\u0005\b\u0005\u001f1\u0003\u0019AA\t\u000311\u0017.\u001a7e/JLG/\u001a:t\u0003)i\u0017m[3Xe&$XM\u001d\u000b\u0007\u0003/\u0011)Ba\b\t\u000f\t]q\u00051\u0001\u0003\u001a\u0005AA-\u0019;b)f\u0004X\rE\u0002x\u00057I1A!\by\u0005!!\u0015\r^1UsB,\u0007b\u0002B\u0011O\u0001\u0007\u0011\u0011I\u0001\u000bS:\u001c\u0006N]3eI\u0016$\u0017!E7bW\u0016$UmY5nC2<&/\u001b;feR1\u0011q\u0003B\u0014\u0005WAaA!\u000b)\u0001\u0004q\u0017!\u00039sK\u000eL7/[8o\u0011\u0019\u0011i\u0003\u000ba\u0001]\u0006)1oY1mK\u0006yQ.Y6f\u0003J\u0014\u0018-_,sSR,'\u000f\u0006\u0004\u0002\u0018\tM\"Q\b\u0005\b\u0005kI\u0003\u0019\u0001B\u001c\u0003%\t'O]1z)f\u0004X\rE\u0002x\u0005sI1Aa\u000fy\u0005%\t%O]1z)f\u0004X\rC\u0004\u0003\"%\u0002\r!!\u0011\u0002\u001b5\f7.Z'ba^\u0013\u0018\u000e^3s)\u0019\t9Ba\u0011\u0003N!9!Q\t\u0016A\u0002\t\u001d\u0013aB7baRK\b/\u001a\t\u0004o\n%\u0013b\u0001B&q\n9Q*\u00199UsB,\u0007b\u0002B\u0011U\u0001\u0007\u0011\u0011I\u0001\u000fG>t7/^7f\u001b\u0016\u001c8/Y4f)\r\t(1\u000b\u0005\t\u0005+ZC\u00111\u0001\u0003X\u0005\ta\r\u0005\u0003d\u00053\n\u0018b\u0001B.I\nAAHY=oC6,g(\u0001\u0007d_:\u001cX/\\3He>,\b\u000fF\u0002r\u0005CB\u0001B!\u0016-\t\u0003\u0007!qK\u0001\rG>t7/^7f\r&,G\u000e\u001a\u000b\u0007\u0005O\u0012YGa \u0015\u0007E\u0014I\u0007\u0003\u0005\u0003V5\"\t\u0019\u0001B,\u0011\u001d\u0011i'\fa\u0001\u0005_\nQAZ5fY\u0012\u0004BA!\u001d\u0003z9!!1\u000fB;!\r\tY\rZ\u0005\u0004\u0005o\"\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0003|\tu$AB*ue&twMC\u0002\u0003x\u0011DaA!!.\u0001\u0004q\u0017!B5oI\u0016D\u0018a\u0005)beF,X\r^,sSR,7+\u001e9q_J$\bC\u000110'\ry#\u0011\u0012\t\u0004G\n-\u0015b\u0001BGI\n1\u0011I\\=SK\u001a$\"A!\"\u0002!M\u0003\u0016IU&`%>;vlU\"I\u000b6\u000bUC\u0001B8\u0003E\u0019\u0006+\u0011*L?J{ukX*D\u0011\u0016k\u0015\tI\u0001\u001f'B\u000b%kS0W\u0003JK\u0015I\u0014+`'\"\u0013V\t\u0012#J\u001d\u001e{6k\u0011%F\u001b\u0006\u000bqd\u0015)B%.{f+\u0011*J\u0003:#vl\u0015%S\u000b\u0012#\u0015JT$`'\u000eCU)T!!\u0003%\u0019X\r^*dQ\u0016l\u0017\rF\u0003r\u0005?\u0013\t\u000bC\u0003uk\u0001\u0007a\u000fC\u0004\u0002hV\u0002\r!!;\u0002%M,Go\u00155sK\u0012$\u0017N\\4TG\",W.\u0019\u000b\u0006c\n\u001d&1\u0016\u0005\u0007\u0005S3\u0004\u0019\u0001<\u0002\u001fMD'/\u001a3eS:<7k\u00195f[\u0006Dq!a:7\u0001\u0004\tI\u000f")
public class ParquetWriteSupport
extends WriteSupport<InternalRow>
implements Logging {
    private StructType schema;
    private StructType shreddedSchema;
    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters;
    private RecordConsumer recordConsumer;
    private boolean writeLegacyParquetFormat;
    private Enumeration.Value outputTimestampType;
    private final byte[] timestampBuffer;
    private final byte[] decimalBuffer;
    private final Enumeration.Value datetimeRebaseMode;
    private final Function1<Object, Object> dateRebaseFunc;
    private final Function1<Object, Object> timestampRebaseFunc;
    private final Enumeration.Value int96RebaseMode;
    private final Function1<Object, Object> int96RebaseFunc;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void setShreddingSchema(StructType shreddingSchema, Configuration configuration) {
        ParquetWriteSupport$.MODULE$.setShreddingSchema(shreddingSchema, configuration);
    }

    public static void setSchema(StructType schema, Configuration configuration) {
        ParquetWriteSupport$.MODULE$.setSchema(schema, configuration);
    }

    public static String SPARK_VARIANT_SHREDDING_SCHEMA() {
        return ParquetWriteSupport$.MODULE$.SPARK_VARIANT_SHREDDING_SCHEMA();
    }

    public static String SPARK_ROW_SCHEMA() {
        return ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StructType schema() {
        return this.schema;
    }

    private void schema_$eq(StructType x$1) {
        this.schema = x$1;
    }

    private StructType shreddedSchema() {
        return this.shreddedSchema;
    }

    private void shreddedSchema_$eq(StructType x$1) {
        this.shreddedSchema = x$1;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters() {
        return this.rootFieldWriters;
    }

    private void rootFieldWriters_$eq(Function2<SpecializedGetters, Object, BoxedUnit>[] x$1) {
        this.rootFieldWriters = x$1;
    }

    private RecordConsumer recordConsumer() {
        return this.recordConsumer;
    }

    private void recordConsumer_$eq(RecordConsumer x$1) {
        this.recordConsumer = x$1;
    }

    private boolean writeLegacyParquetFormat() {
        return this.writeLegacyParquetFormat;
    }

    private void writeLegacyParquetFormat_$eq(boolean x$1) {
        this.writeLegacyParquetFormat = x$1;
    }

    private Enumeration.Value outputTimestampType() {
        return this.outputTimestampType;
    }

    private void outputTimestampType_$eq(Enumeration.Value x$1) {
        this.outputTimestampType = x$1;
    }

    private byte[] timestampBuffer() {
        return this.timestampBuffer;
    }

    private byte[] decimalBuffer() {
        return this.decimalBuffer;
    }

    private Enumeration.Value datetimeRebaseMode() {
        return this.datetimeRebaseMode;
    }

    private Function1<Object, Object> dateRebaseFunc() {
        return this.dateRebaseFunc;
    }

    private Function1<Object, Object> timestampRebaseFunc() {
        return this.timestampRebaseFunc;
    }

    private Enumeration.Value int96RebaseMode() {
        return this.int96RebaseMode;
    }

    private Function1<Object, Object> int96RebaseFunc() {
        return this.int96RebaseFunc;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        String schemaString = configuration.get(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA());
        String shreddedSchemaString = configuration.get(ParquetWriteSupport$.MODULE$.SPARK_VARIANT_SHREDDING_SCHEMA());
        this.schema_$eq(StructType$.MODULE$.fromString(schemaString));
        this.shreddedSchema_$eq(shreddedSchemaString == null ? this.schema() : StructType$.MODULE$.fromString(shreddedSchemaString));
        Predef$.MODULE$.assert(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()) != null);
        this.writeLegacyParquetFormat_$eq(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))));
        String key = SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key();
        Predef$.MODULE$.assert(configuration.get(key) != null);
        this.outputTimestampType_$eq(SQLConf.ParquetOutputTimestampType$.MODULE$.withName(configuration.get(key)));
        this.rootFieldWriters_$eq((Function2[])((IterableOnceOps)((IterableOps)this.shreddedSchema().map((Function1 & Serializable)x$7 -> x$7.dataType())).map((Function1 & Serializable)x$8 -> this.makeWriter((DataType)x$8, false))).toArray(ClassTag$.MODULE$.apply(Function2.class)));
        MessageType messageType = new SparkToParquetSchemaConverter(configuration).convert(this.shreddedSchema());
        Enumeration.Value value = this.datetimeRebaseMode();
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value3 = this.int96RebaseMode();
        Enumeration.Value value4 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)((MapOps)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY()), (Object)org.apache.spark.package$.MODULE$.SPARK_VERSION_SHORT()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY()), (Object)schemaString)}))).$plus$plus((IterableOnce)(!(value != null ? !value.equals(value2) : value2 != null) ? (IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.SPARK_LEGACY_DATETIME_METADATA_KEY()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.SPARK_TIMEZONE_METADATA_KEY()), (Object)SQLConf$.MODULE$.get().sessionLocalTimeZone())})) : Predef$.MODULE$.Map().empty()))).$plus$plus((IterableOnce)(!(value3 != null ? !value3.equals(value4) : value4 != null) ? (IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.SPARK_LEGACY_INT96_METADATA_KEY()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.SPARK_TIMEZONE_METADATA_KEY()), (Object)SQLConf$.MODULE$.get().sessionLocalTimeZone())})) : Predef$.MODULE$.Map().empty()));
        if (shreddedSchemaString == null) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Initialized Parquet WriteSupport with Catalyst schema:\n           |" + this.schema().prettyJson() + "\n           |and corresponding Parquet message type:\n           |" + messageType + "\n         ")));
        } else {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Initialized Parquet WriteSupport with Catalyst schema:\n           |" + this.schema().prettyJson() + "\n           |and shredding schema:\n           |" + this.shreddedSchema().prettyJson() + "\n           |and corresponding Parquet message type:\n           |" + messageType + "\n         ")));
        }
        return new WriteSupport.WriteContext(messageType, CollectionConverters$.MODULE$.MapHasAsJava((Map)metadata).asJava());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer_$eq(recordConsumer);
    }

    public void write(InternalRow row) {
        this.consumeMessage((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeFields(row, this.shreddedSchema(), this.rootFieldWriters()));
    }

    private void writeFields(InternalRow row, StructType schema, Function2<SpecializedGetters, Object, BoxedUnit>[] fieldWriters) {
        IntRef i = IntRef.create((int)0);
        while (i.elem < row.numFields()) {
            if (!row.isNullAt(i.elem)) {
                this.consumeField(schema.apply(i.elem).name(), i.elem, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> fieldWriters[i$1.elem].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i$1.elem)));
            }
            ++i.elem;
        }
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeWriter(DataType dataType, boolean inShredded) {
        while (true) {
            DecimalType decimalType;
            Option option;
            boolean bl = false;
            StructType structType = null;
            DataType dataType2 = dataType;
            if (BooleanType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (ByteType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (ShortType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (DateType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$4(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (IntegerType$.MODULE$.equals(dataType2) ? true : dataType2 instanceof YearMonthIntervalType) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$5(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (LongType$.MODULE$.equals(dataType2) ? true : dataType2 instanceof DayTimeIntervalType) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$6(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (FloatType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$7(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (DoubleType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$8(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType2 instanceof StringType) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$9(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (TimestampType$.MODULE$.equals(dataType2)) {
                if (inShredded) {
                    return (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$10(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                }
                Enumeration.Value value = this.outputTimestampType();
                Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    return (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$11(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                }
                Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    return (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$12(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                }
                Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    return (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$13(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                }
                throw new MatchError((Object)value);
            }
            if (TimestampNTZType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$14(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType2 instanceof TimeType) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$15(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (BinaryType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$16(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType2 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType2)).isEmpty()) {
                int precision = ((Tuple2)option.get())._1$mcI$sp();
                int scale = ((Tuple2)option.get())._2$mcI$sp();
                return this.makeDecimalWriter(precision, scale);
            }
            if (VariantType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$17(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType2 instanceof StructType) {
                bl = true;
                structType = (StructType)dataType2;
                if (SparkShreddingUtils$.MODULE$.isVariantShreddingStruct(structType)) {
                    Function2[] fieldWriters = (Function2[])((IterableOnceOps)((IterableOps)structType.map((Function1 & Serializable)x$10 -> x$10.dataType())).map((Function1 & Serializable)x$11 -> this.makeWriter((DataType)x$11, true))).toArray(ClassTag$.MODULE$.apply(Function2.class));
                    VariantSchema variantShreddingSchema = SparkShreddingUtils$.MODULE$.buildVariantSchema((DataType)structType);
                    return (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$23(this, variantShreddingSchema, structType, fieldWriters, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                }
            }
            if (bl) {
                Function2[] fieldWriters = (Function2[])((IterableOnceOps)((IterableOps)structType.map((Function1 & Serializable)x$12 -> x$12.dataType())).map((Function1 & Serializable)x$13 -> this.makeWriter((DataType)x$13, inShredded))).toArray(ClassTag$.MODULE$.apply(Function2.class));
                return (Function2 & Serializable)(row, ordinal) -> {
                    this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeFields(row.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), structType.length()), structType, fieldWriters));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                return this.makeArrayWriter(arrayType, inShredded);
            }
            if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                return this.makeMapWriter(mapType, inShredded);
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        throw SparkException$.MODULE$.internalError("Unsupported data type " + dataType + ".");
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeDecimalWriter(int precision, int scale) {
        Predef$.MODULE$.assert(precision <= DecimalType$.MODULE$.MAX_PRECISION(), (Function0 & Serializable)() -> "Decimal precision " + precision + " exceeds max precision " + DecimalType$.MODULE$.MAX_PRECISION());
        int numBytes = Decimal$.MODULE$.minBytesForPrecision()[precision];
        Function2 & Serializable int32Writer = (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$2(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable int64Writer = (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$3(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable binaryWriterUsingUnscaledLong = (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$4(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable binaryWriterUsingUnscaledBytes = (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$5(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.writeLegacyParquetFormat();
        if (!bl3) {
            bl = true;
            bl2 = bl3;
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
                return int32Writer;
            }
        }
        if (bl && precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return int64Writer;
        }
        if (bl3 && precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return binaryWriterUsingUnscaledLong;
        }
        return binaryWriterUsingUnscaledBytes;
    }

    public Function2<SpecializedGetters, Object, BoxedUnit> makeArrayWriter(ArrayType arrayType, boolean inShredded) {
        boolean bl;
        Function2<SpecializedGetters, Object, BoxedUnit> elementWriter = this.makeWriter(arrayType.elementType(), inShredded);
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(this.writeLegacyParquetFormat(), arrayType.containsNull());
        if (sp2 != null && !(bl = sp2._1$mcZ$sp())) {
            return this.threeLevelArrayWriter$1("list", "element", elementWriter);
        }
        if (sp2 != null) {
            boolean bl2 = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl2 && bl3) {
                return this.threeLevelArrayWriter$1("bag", "array", elementWriter);
            }
        }
        if (sp2 != null) {
            boolean bl4 = sp2._1$mcZ$sp();
            boolean bl5 = sp2._2$mcZ$sp();
            if (bl4 && !bl5) {
                return this.twoLevelArrayWriter$1("array", elementWriter);
            }
        }
        throw new MatchError((Object)sp2);
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeMapWriter(MapType mapType, boolean inShredded) {
        Function2<SpecializedGetters, Object, BoxedUnit> keyWriter = this.makeWriter(mapType.keyType(), inShredded);
        Function2<SpecializedGetters, Object, BoxedUnit> valueWriter = this.makeWriter(mapType.valueType(), inShredded);
        String repeatedGroupName = this.writeLegacyParquetFormat() ? "map" : "key_value";
        return (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeMapWriter$1(this, repeatedGroupName, keyWriter, valueWriter, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    private void consumeMessage(Function0<BoxedUnit> f) {
        this.recordConsumer().startMessage();
        f.apply$mcV$sp();
        this.recordConsumer().endMessage();
    }

    private void consumeGroup(Function0<BoxedUnit> f) {
        this.recordConsumer().startGroup();
        f.apply$mcV$sp();
        this.recordConsumer().endGroup();
    }

    private void consumeField(String field, int index, Function0<BoxedUnit> f) {
        this.recordConsumer().startField(field, index);
        f.apply$mcV$sp();
        this.recordConsumer().endField(field, index);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$1(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBoolean(row.getBoolean(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$2(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getByte(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$3(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getShort(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$4(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger($this.dateRebaseFunc().apply$mcII$sp(row.getInt(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$5(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger(row.getInt(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$6(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$7(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addFloat(row.getFloat(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$8(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addDouble(row.getDouble(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$9(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getUTF8String(ordinal).getBytes()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$10(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        $this.recordConsumer().addLong($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$11(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = $this.int96RebaseFunc().apply$mcJJ$sp(row.getLong(ordinal));
        Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(micros);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int julianDay = tuple2._1$mcI$sp();
        long timeOfDayNanos = tuple2._2$mcJ$sp();
        Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(julianDay, timeOfDayNanos);
        int julianDay2 = sp2._1$mcI$sp();
        long timeOfDayNanos2 = sp2._2$mcJ$sp();
        ByteBuffer buf = ByteBuffer.wrap($this.timestampBuffer());
        buf.order(ByteOrder.LITTLE_ENDIAN).putLong(timeOfDayNanos2).putInt(julianDay2);
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.timestampBuffer()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$12(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        $this.recordConsumer().addLong($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$13(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        long millis = DateTimeUtils$.MODULE$.microsToMillis($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
        $this.recordConsumer().addLong(millis);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$14(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$15(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(DateTimeUtils$.MODULE$.nanosToMicros(row.getLong(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$16(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getBinary(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$17(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        VariantVal v = row.getVariant(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.consumeField("value", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])v.getValue())));
            $this.consumeField("metadata", 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])v.getMetadata())));
        });
    }

    public static final /* synthetic */ void $anonfun$makeWriter$23(ParquetWriteSupport $this, VariantSchema variantShreddingSchema$1, StructType x20$1, Function2[] fieldWriters$2, SpecializedGetters row, int ordinal) {
        VariantVal v = row.getVariant(ordinal);
        Variant variant = new Variant(v.getValue(), v.getMetadata());
        InternalRow shreddedValues = SparkShreddingUtils$.MODULE$.castShredded(variant, variantShreddingSchema$1);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.writeFields(shreddedValues, x20$1, fieldWriters$2));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$2(ParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addInteger((int)unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$3(ParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addLong(unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$4(ParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        long unscaled = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        int i = 0;
        int shift = 8 * (numBytes$1 - 1);
        while (i < numBytes$1) {
            $this.decimalBuffer()[i] = (byte)(unscaled >> shift);
            ++i;
            shift -= 8;
        }
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.decimalBuffer(), (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$5(ParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        byte[] byArray;
        Decimal decimal = row.getDecimal(ordinal, precision$1, scale$1);
        byte[] bytes = decimal.toJavaBigDecimal().unscaledValue().toByteArray();
        if (bytes.length == numBytes$1) {
            byArray = bytes;
        } else {
            byte signByte = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(bytes))) < 0 ? (byte)-1 : 0;
            Arrays.fill($this.decimalBuffer(), 0, numBytes$1 - bytes.length, signByte);
            System.arraycopy(bytes, 0, $this.decimalBuffer(), numBytes$1 - bytes.length, bytes.length);
            byArray = $this.decimalBuffer();
        }
        byte[] fixedLengthBytes = byArray;
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])fixedLengthBytes, (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$1(ParquetWriteSupport $this, String repeatedGroupName$1, String elementFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (array.numElements() > 0) {
                $this.consumeField(repeatedGroupName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < array.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                            if (!array.isNullAt(i$2.elem)) {
                                $this.consumeField(elementFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i$2.elem)));
                                return;
                            }
                        });
                        ++i.elem;
                    }
                });
                return;
            }
        });
    }

    private final Function2 threeLevelArrayWriter$1(String repeatedGroupName, String elementFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeArrayWriter$1(this, repeatedGroupName, elementFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$6(ParquetWriteSupport $this, String repeatedFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (array.numElements() > 0) {
                $this.consumeField(repeatedFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    for (int i = 0; i < array.numElements(); ++i) {
                        elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i));
                    }
                });
                return;
            }
        });
    }

    private final Function2 twoLevelArrayWriter$1(String repeatedFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeArrayWriter$6(this, repeatedFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeMapWriter$1(ParquetWriteSupport $this, String repeatedGroupName$2, Function2 keyWriter$1, Function2 valueWriter$1, SpecializedGetters row, int ordinal) {
        MapData map = row.getMap(ordinal);
        ArrayData keyArray = map.keyArray();
        ArrayData valueArray = map.valueArray();
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (map.numElements() > 0) {
                $this.consumeField(repeatedGroupName$2, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < map.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                            $this.consumeField("key", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> keyWriter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                            if (!map.valueArray().isNullAt(i$3.elem)) {
                                $this.consumeField("value", 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> valueWriter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                                return;
                            }
                        });
                        ++i.elem;
                    }
                });
                return;
            }
        });
    }

    public ParquetWriteSupport() {
        Logging.$init$((Logging)this);
        this.timestampBuffer = new byte[12];
        this.decimalBuffer = new byte[Decimal$.MODULE$.minBytesForPrecision()[DecimalType$.MODULE$.MAX_PRECISION()]];
        this.datetimeRebaseMode = (Enumeration.Value)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_WRITE());
        this.dateRebaseFunc = DataSourceUtils$.MODULE$.createDateRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
        this.timestampRebaseFunc = DataSourceUtils$.MODULE$.createTimestampRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
        this.int96RebaseMode = (Enumeration.Value)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_WRITE());
        this.int96RebaseFunc = DataSourceUtils$.MODULE$.createTimestampRebaseFuncInWrite(this.int96RebaseMode(), "Parquet INT96");
    }
}

