/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.H2Dialect$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\r\u001db!B\u001a5\u0001Zr\u0004\"B-\u0001\t\u0003Q\u0006\"\u0002/\u0001\t\u0003j\u0006bB6\u0001\u0005\u0004%I\u0001\u001c\u0005\u0007y\u0002\u0001\u000b\u0011B7\t\u000fu\u0004!\u0019!C\u0005Y\"1a\u0010\u0001Q\u0001\n5Dqa \u0001C\u0002\u0013%A\u000eC\u0004\u0002\u0002\u0001\u0001\u000b\u0011B7\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u00111\u0002\u0001\u0005B\u00055\u0001bBA\u000f\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003K\u0001A\u0011IA\u0014\u0011\u001d\t9\u0006\u0001C!\u00033B\u0011\"a\u001a\u0001\u0005\u0004%I!!\u001b\t\u0011\u0005-\u0005\u0001)A\u0005\u0003WBq!!$\u0001\t\u0003\ty\tC\u0004\u0002~\u0001!\t%!'\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\"9\u0011\u0011\u0017\u0001\u0005B\u0005M\u0006bBAt\u0001\u0011\u0005\u0013\u0011\u001e\u0005\b\u0003_\u0004A\u0011IAy\u0011\u001d\u00119\u0002\u0001C!\u00053AqAa\f\u0001\t\u0013\u0011\t\u0004C\u0004\u00038\u0001!IA!\u000f\t\u000f\t}\u0002\u0001\"\u0011\u0003B!9!Q\u000e\u0001\u0005B\t=dA\u0002B?\u0001\u0001\u0011y\b\u0003\u0004Z7\u0011\u0005!\u0011\u0012\u0005\b\u0005\u001b[B\u0011\tBH\u0011\u001d\u0011ij\u0007C!\u0005?CqA!+\u001c\t\u0003\u0012Y\u000bC\u0004\u00032\u0002!\tEa-\t\u000f\tU\u0006\u0001\"\u0011\u00034\"A!q\u0017\u0001\u0002\u0002\u0013\u0005!\fC\u0005\u0003:\u0002\t\t\u0011\"\u0011\u0003<\"I!Q\u0018\u0001\u0002\u0002\u0013\u0005!q\u0018\u0005\n\u0005\u0003\u0004\u0011\u0011!C\u0001\u0005\u0007D\u0011Ba4\u0001\u0003\u0003%\tE!5\t\u0013\tm\u0007!!A\u0005\u0002\tu\u0007\"\u0003Bq\u0001\u0005\u0005I\u0011\tBr\u0011%\u00119\u000fAA\u0001\n\u0003\u0012I\u000fC\u0005\u0003l\u0002\t\t\u0011\"\u0011\u0003n\"I!q\u001e\u0001\u0002\u0002\u0013\u0005#\u0011_\u0004\u000b\u0005k$\u0014\u0011!E\u0001m\t]h!C\u001a5\u0003\u0003E\tA\u000eB}\u0011\u0019IV\u0006\"\u0001\u0004\u0012!I!1^\u0017\u0002\u0002\u0013\u0015#Q\u001e\u0005\t\u0007'i\u0013\u0011!CA5\"I1QC\u0017\u0002\u0002\u0013\u00055q\u0003\u0005\n\u0007;i\u0013\u0011!C\u0005\u0007?\u0011\u0011\u0002\u0013\u001aES\u0006dWm\u0019;\u000b\u0005U2\u0014\u0001\u00026eE\u000eT!a\u000e\u001d\u0002\u0007M\fHN\u0003\u0002:u\u0005)1\u000f]1sW*\u00111\bP\u0001\u0007CB\f7\r[3\u000b\u0003u\n1a\u001c:h'\u0015\u0001qh\u0011$M!\t\u0001\u0015)D\u00015\u0013\t\u0011EGA\u0006KI\n\u001cG)[1mK\u000e$\bC\u0001!E\u0013\t)EGA\tO_2+w-Y2z\u0015\u0012\u00135)\u0012:s_J\u0004\"a\u0012&\u000e\u0003!S\u0011!S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0017\"\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002N-:\u0011a\n\u0016\b\u0003\u001fNk\u0011\u0001\u0015\u0006\u0003#J\u000ba\u0001\u0010:p_Rt4\u0001A\u0005\u0002\u0013&\u0011Q\u000bS\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0006L\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002V\u0011\u00061A(\u001b8jiz\"\u0012a\u0017\t\u0003\u0001\u0002\t\u0011bY1o\u0011\u0006tG\r\\3\u0015\u0005y\u000b\u0007CA$`\u0013\t\u0001\u0007JA\u0004C_>dW-\u00198\t\u000b\t\u0014\u0001\u0019A2\u0002\u0007U\u0014H\u000e\u0005\u0002eQ:\u0011QM\u001a\t\u0003\u001f\"K!a\u001a%\u0002\rA\u0013X\rZ3g\u0013\tI'N\u0001\u0004TiJLgn\u001a\u0006\u0003O\"\u000bQ\u0005Z5ti&t7\r^+ogV\u0004\bo\u001c:uK\u0012\fum\u001a:fO\u0006$XMR;oGRLwN\\:\u0016\u00035\u00042A\\:v\u001b\u0005y'B\u00019r\u0003%IW.\\;uC\ndWM\u0003\u0002s\u0011\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Q|'aA*fiB\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\u0005Y\u0006twMC\u0001{\u0003\u0011Q\u0017M^1\n\u0005%<\u0018A\n3jgRLgn\u0019;V]N,\b\u000f]8si\u0016$\u0017iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8tA\u0005Y2/\u001e9q_J$X\rZ!hOJ,w-\u0019;f\rVt7\r^5p]N\fAd];qa>\u0014H/\u001a3BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u001c\b%\u0001\ntkB\u0004xN\u001d;fI\u001a+hn\u0019;j_:\u001c\u0018aE:vaB|'\u000f^3e\rVt7\r^5p]N\u0004\u0013aE5t'V\u0004\bo\u001c:uK\u00124UO\\2uS>tGc\u00010\u0002\b!1\u0011\u0011B\u0005A\u0002\r\f\u0001BZ;oG:\u000bW.Z\u0001\u001aSN|%M[3di:{GOR8v]\u0012,\u0005pY3qi&|g\u000eF\u0002_\u0003\u001fAq!!\u0005\u000b\u0001\u0004\t\u0019\"A\u0001f!\u0011\t)\"!\u0007\u000e\u0005\u0005]!BA\u001cz\u0013\u0011\tY\"a\u0006\u0003\u0019M\u000bF*\u0012=dKB$\u0018n\u001c8\u0002/%\u001c8+\u001f8uCb,%O]8s\u0005\u0016\u001cH/\u00124g_J$Hc\u00010\u0002\"!9\u00111E\u0006A\u0002\u0005M\u0011!C3yG\u0016\u0004H/[8o\u0003=9W\r^\"bi\u0006d\u0017p\u001d;UsB,GCCA\u0015\u0003w\t)%!\u0013\u0002NA)q)a\u000b\u00020%\u0019\u0011Q\u0006%\u0003\r=\u0003H/[8o!\u0011\t\t$a\u000e\u000e\u0005\u0005M\"bAA\u001bm\u0005)A/\u001f9fg&!\u0011\u0011HA\u001a\u0005!!\u0015\r^1UsB,\u0007bBA\u001f\u0019\u0001\u0007\u0011qH\u0001\bgFdG+\u001f9f!\r9\u0015\u0011I\u0005\u0004\u0003\u0007B%aA%oi\"1\u0011q\t\u0007A\u0002\r\f\u0001\u0002^=qK:\u000bW.\u001a\u0005\b\u0003\u0017b\u0001\u0019AA \u0003\u0011\u0019\u0018N_3\t\u000f\u0005=C\u00021\u0001\u0002R\u0005\u0011Q\u000e\u001a\t\u0005\u0003c\t\u0019&\u0003\u0003\u0002V\u0005M\"aD'fi\u0006$\u0017\r^1Ck&dG-\u001a:\u0002\u0017\u001d,GO\u0013#C\u0007RK\b/\u001a\u000b\u0005\u00037\n\u0019\u0007E\u0003H\u0003W\ti\u0006E\u0002A\u0003?J1!!\u00195\u0005!QEMY2UsB,\u0007bBA3\u001b\u0001\u0007\u0011qF\u0001\u0003IR\f1BZ;oGRLwN\\'baV\u0011\u00111\u000e\t\b\u0003[\n\u0019hYA<\u001b\t\tyGC\u0002\u0002re\fA!\u001e;jY&!\u0011QOA8\u0005\ri\u0015\r\u001d\t\u0005\u0003s\n9)\u0004\u0002\u0002|)!\u0011QPA@\u0003%1WO\\2uS>t7O\u0003\u0003\u0002\u0002\u0006\r\u0015aB2bi\u0006dwn\u001a\u0006\u0004\u0003\u000b3\u0014!C2p]:,7\r^8s\u0013\u0011\tI)a\u001f\u0003\u001fUs'm\\;oI\u001a+hn\u0019;j_:\fABZ;oGRLwN\\'ba\u0002\n\u0001C]3hSN$XM\u001d$v]\u000e$\u0018n\u001c8\u0015\r\u0005]\u0014\u0011SAK\u0011\u0019\t\u0019\n\u0005a\u0001G\u0006!a.Y7f\u0011\u001d\t9\n\u0005a\u0001\u0003o\n!A\u001a8\u0016\u0005\u0005m\u0005#B'\u0002\u001e\u0006\u0005\u0016bAAP1\n\u00191+Z9\u0011\r\u001d\u000b\u0019kYA<\u0013\r\t)\u000b\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u001d\rdW-\u0019:Gk:\u001cG/[8ogR\u0011\u00111\u0016\t\u0004\u000f\u00065\u0016bAAX\u0011\n!QK\\5u\u0003-\u0019'/Z1uK&sG-\u001a=\u0015\u0017\r\f),!/\u0002F\u0006m\u00171\u001d\u0005\u0007\u0003o\u001b\u0002\u0019A2\u0002\u0013%tG-\u001a=OC6,\u0007bBA^'\u0001\u0007\u0011QX\u0001\u000bi\u0006\u0014G.Z%eK:$\b\u0003BA`\u0003\u0003l!!a \n\t\u0005\r\u0017q\u0010\u0002\u000b\u0013\u0012,g\u000e^5gS\u0016\u0014\bbBAd'\u0001\u0007\u0011\u0011Z\u0001\bG>dW/\u001c8t!\u00159\u00151ZAh\u0013\r\ti\r\u0013\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003#\f9.\u0004\u0002\u0002T*!\u0011Q[AB\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u0005e\u00171\u001b\u0002\u000f\u001d\u0006lW\r\u001a*fM\u0016\u0014XM\\2f\u0011\u001d\tin\u0005a\u0001\u0003?\f\u0011cY8mk6t7\u000f\u0015:pa\u0016\u0014H/[3t!!\ti'a\u001d\u0002P\u0006\u0005\bCBA7\u0003g\u001a7\rC\u0004\u0002fN\u0001\r!!9\u0002\u0015A\u0014x\u000e]3si&,7/A\u0005ee>\u0004\u0018J\u001c3fqR)1-a;\u0002n\"1\u0011q\u0017\u000bA\u0002\rDq!a/\u0015\u0001\u0004\ti,A\u0006j]\u0012,\u00070\u0012=jgR\u001cH#\u00030\u0002t\u0006u\u0018q B\u0001\u0011\u001d\t)0\u0006a\u0001\u0003o\fAaY8o]B!\u0011QCA}\u0013\u0011\tY0a\u0006\u0003\u0015\r{gN\\3di&|g\u000e\u0003\u0004\u00028V\u0001\ra\u0019\u0005\b\u0003w+\u0002\u0019AA_\u0011\u001d\u0011\u0019!\u0006a\u0001\u0005\u000b\tqa\u001c9uS>t7\u000f\u0005\u0003\u0003\b\tMQB\u0001B\u0005\u0015\r)$1\u0002\u0006\u0005\u0005\u001b\u0011y!A\u0006eCR\f7o\\;sG\u0016\u001c(b\u0001B\tm\u0005IQ\r_3dkRLwN\\\u0005\u0005\u0005+\u0011IAA\u0006K\t\n\u001bu\n\u001d;j_:\u001c\u0018a\u00037jgRLe\u000eZ3yKN$\u0002Ba\u0007\u0003*\t-\"Q\u0006\t\u0006\u000f\u0006-'Q\u0004\t\u0005\u0005?\u0011)#\u0004\u0002\u0003\")!!1EA@\u0003\u0015Ig\u000eZ3y\u0013\u0011\u00119C!\t\u0003\u0015Q\u000b'\r\\3J]\u0012,\u0007\u0010C\u0004\u0002vZ\u0001\r!a>\t\u000f\u0005mf\u00031\u0001\u0002>\"9!1\u0001\fA\u0002\t\u0015\u0011a\u0005;bE2,g*Y7f/&$\bnU2iK6\fGcA2\u00034!9!QG\fA\u0002\u0005u\u0016!B5eK:$\u0018aE5oI\u0016Dh*Y7f/&$\bnU2iK6\fG#B2\u0003<\tu\u0002b\u0002B\u001b1\u0001\u0007\u0011Q\u0018\u0005\u0007\u0003oC\u0002\u0019A2\u0002#\rd\u0017m]:jMf,\u0005pY3qi&|g\u000e\u0006\u0007\u0003D\t]#\u0011\fB/\u0005K\u0012IG\u0005\u0004\u0003F\t%#q\n\u0004\u0007\u0005\u000f\u0002\u0001Aa\u0011\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u00075\u0013Y%C\u0002\u0003Na\u0013\u0011\u0002\u00165s_^\f'\r\\3\u0011\t\tE#1K\u0007\u0002q%\u0019!Q\u000b\u001d\u0003\u001dM\u0003\u0018M]6UQJ|w/\u00192mK\"9\u0011\u0011C\rA\u0002\t%\u0003B\u0002B.3\u0001\u00071-A\u0005d_:$\u0017\u000e^5p]\"9!qL\rA\u0002\t\u0005\u0014!E7fgN\fw-\u001a)be\u0006lW\r^3sgB)AMa\u0019dG&\u0019\u0011Q\u000f6\t\r\t\u001d\u0014\u00041\u0001d\u0003-!Wm]2sSB$\u0018n\u001c8\t\r\t-\u0014\u00041\u0001_\u0003%I7OU;oi&lW-A\td_6\u0004\u0018\u000e\\3FqB\u0014Xm]:j_:$BA!\u001d\u0003tA!q)a\u000bd\u0011\u001d\u0011)H\u0007a\u0001\u0005o\nA!\u001a=qeB!\u0011\u0011\u001bB=\u0013\u0011\u0011Y(a5\u0003\u0015\u0015C\bO]3tg&|gN\u0001\u0007IeM\u000bFJQ;jY\u0012,'oE\u0002\u001c\u0005\u0003\u0003BAa!\u0003\u00066\t\u0001!C\u0002\u0003\b\u0006\u0013aB\u0013#C\u0007N\u000bFJQ;jY\u0012,'\u000f\u0006\u0002\u0003\fB\u0019!1Q\u000e\u0002-YL7/\u001b;BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:$ra\u0019BI\u0005'\u00139\n\u0003\u0004\u0002\nu\u0001\ra\u0019\u0005\u0007\u0005+k\u0002\u0019\u00010\u0002\u0015%\u001cH)[:uS:\u001cG\u000fC\u0004\u0003\u001av\u0001\rAa'\u0002\r%t\u0007/\u001e;t!\u00119\u00151Z2\u0002\u0019YL7/\u001b;FqR\u0014\u0018m\u0019;\u0015\u000b\r\u0014\tK!*\t\r\t\rf\u00041\u0001d\u0003\u00151\u0017.\u001a7e\u0011\u0019\u00119K\ba\u0001G\u000611o\\;sG\u0016\f\u0001C^5tSR\u001c\u0016\u000b\u0014$v]\u000e$\u0018n\u001c8\u0015\u000b\r\u0014iKa,\t\r\u0005%q\u00041\u0001d\u0011\u001d\u0011Ij\ba\u0001\u00057\u000bQb];qa>\u0014Ho\u001d'j[&$X#\u00010\u0002\u001dM,\b\u000f]8siN|eMZ:fi\u0006!1m\u001c9z\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\tQ/\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002@\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002Bc\u0005\u0017\u00042a\u0012Bd\u0013\r\u0011I\r\u0013\u0002\u0004\u0003:L\b\"\u0003BgK\u0005\u0005\t\u0019AA \u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!1\u001b\t\u0007\u0005+\u00149N!2\u000e\u0003EL1A!7r\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007y\u0013y\u000eC\u0005\u0003N\u001e\n\t\u00111\u0001\u0003F\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\r)(Q\u001d\u0005\n\u0005\u001bD\u0013\u0011!a\u0001\u0003\u007f\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u007f\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002k\u00061Q-];bYN$2A\u0018Bz\u0011%\u0011imKA\u0001\u0002\u0004\u0011)-A\u0005Ie\u0011K\u0017\r\\3diB\u0011\u0001)L\n\u0006[\tm8q\u0001\t\u0006\u0005{\u001c\u0019aW\u0007\u0003\u0005\u007fT1a!\u0001I\u0003\u001d\u0011XO\u001c;j[\u0016LAa!\u0002\u0003\u0000\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u0019\u0011\t\r%1qB\u0007\u0003\u0007\u0017Q1a!\u0004z\u0003\tIw.C\u0002X\u0007\u0017!\"Aa>\u0002\u000b\u0005\u0004\b\u000f\\=\u0002\u000fUt\u0017\r\u001d9msR\u0019al!\u0007\t\u0011\rm\u0011'!AA\u0002m\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0019\t\u0003E\u0002w\u0007GI1a!\nx\u0005\u0019y%M[3di\u0002")
public class H2Dialect
extends JdbcDialect
implements NoLegacyJDBCError,
Product {
    private final Set<String> org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;
    private final Map<String, UnboundFunction> functionMap;

    public static boolean unapply(H2Dialect x$0) {
        return H2Dialect$.MODULE$.unapply(x$0);
    }

    public static H2Dialect apply() {
        return H2Dialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:h2");
    }

    public Set<String> org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public boolean isObjectNotFoundException(SQLException e) {
        return ((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{42102, 42103, 42104, 90079}))).contains((Object)BoxesRunTime.boxToInteger((int)e.getErrorCode()));
    }

    @Override
    public boolean isSyntaxErrorBestEffort(SQLException exception) {
        return Option$.MODULE$.apply((Object)exception.getSQLState()).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("42")));
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case 2: {
                if (size <= 38) break;
                long scale = md != null ? md.build().getLong("scale") : 0L;
                int selectedScale = (int)((double)DecimalType$.MODULE$.MAX_PRECISION() * ((double)scale / (double)size));
                return Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), selectedScale));
            }
            case 2013: 
            case 2014: {
                return new Some((Object)TimestampType$.MODULE$);
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("CLOB", 2005));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return new Some((Object)new JdbcType("NUMERIC(" + decimalType.precision() + "," + decimalType.scale() + ")", 2));
        }
        return JdbcUtils$.MODULE$.getCommonJDBCType(dt);
    }

    private Map<String, UnboundFunction> functionMap() {
        return this.functionMap;
    }

    public UnboundFunction registerFunction(String name, UnboundFunction fn) {
        return this.functionMap().put(name, fn);
    }

    @Override
    public Seq<Tuple2<String, UnboundFunction>> functions() {
        return CollectionConverters$.MODULE$.MapHasAsScala(this.functionMap()).asScala().toSeq();
    }

    public void clearFunctions() {
        this.functionMap().clear();
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String[] columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> this.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
        Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "h2");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String indexType = (String)tuple2._1();
        String indexType2 = indexType;
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " " + indexType2 + " ON " + this.tableNameWithSchema(tableIdent) + " (" + Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ") + ")";
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return "DROP INDEX " + this.indexNameWithSchema(tableIdent, indexName);
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = "SELECT * FROM INFORMATION_SCHEMA.INDEXES WHERE TABLE_SCHEMA = '" + ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])tableIdent.namespace())) + "' AND TABLE_NAME = '" + tableIdent.name() + "' AND INDEX_NAME = '" + indexName + "'";
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        String sql = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         | SELECT\n         |   i.INDEX_CATALOG AS INDEX_CATALOG,\n         |   i.INDEX_SCHEMA AS INDEX_SCHEMA,\n         |   i.INDEX_NAME AS INDEX_NAME,\n         |   i.INDEX_TYPE_NAME AS INDEX_TYPE_NAME,\n         |   i.REMARKS as REMARKS,\n         |   ic.COLUMN_NAME AS COLUMN_NAME\n         | FROM INFORMATION_SCHEMA.INDEXES i, INFORMATION_SCHEMA.INDEX_COLUMNS ic\n         | WHERE i.TABLE_CATALOG = ic.TABLE_CATALOG\n         | AND i.TABLE_SCHEMA = ic.TABLE_SCHEMA\n         | AND i.TABLE_NAME = ic.TABLE_NAME\n         | AND i.INDEX_CATALOG = ic.INDEX_CATALOG\n         | AND i.INDEX_SCHEMA = ic.INDEX_SCHEMA\n         | AND i.INDEX_NAME = ic.INDEX_NAME\n         | AND i.TABLE_NAME = '" + tableIdent.name() + "'\n         | AND i.INDEX_SCHEMA = '" + ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])tableIdent.namespace())) + "'\n         |"));
        ObjectRef indexMap = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, sql, (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                H2Dialect.$anonfun$listIndexes$1(indexMap, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot retrieved index info.");
        }
        return (TableIndex[])((scala.collection.immutable.Map)indexMap.elem).values().toArray(ClassTag$.MODULE$.apply(TableIndex.class));
    }

    private String tableNameWithSchema(Identifier ident) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Object)ident.name(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)colName -> this.quoteIdentifier((String)colName), ClassTag$.MODULE$.apply(String.class))).mkString(".");
    }

    private String indexNameWithSchema(Identifier ident, String indexName) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Object)indexName, ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)colName -> this.quoteIdentifier((String)colName), ClassTag$.MODULE$.apply(String.class))).mkString(".");
    }

    @Override
    public Throwable classifyException(Throwable e, String condition, scala.collection.immutable.Map<String, String> messageParameters, String description, boolean isRuntime) {
        block7: {
            Throwable throwable = e;
            if (!(throwable instanceof SQLException)) break block7;
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 42101: {
                    Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"((?:[^\"\\\\]|\\\\[\\\\\"ntbrf])+)\""));
                    String name = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)e.getMessage()).get()).group(1);
                    String quotedName = package$.MODULE$.quoteIdentifier(name);
                    throw new TableAlreadyExistsException("TABLE_OR_VIEW_ALREADY_EXISTS", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)quotedName)})), (Option)new Some((Object)e));
                }
                case 42102: {
                    String relationName = (String)messageParameters.getOrElse((Object)"tableName", (Function0 & Serializable)() -> "");
                    throw new NoSuchTableException("TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)relationName)})), (Option)new Some((Object)e));
                }
                case 90079: {
                    Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"((?:[^\"\\\\]|\\\\[\\\\\"ntbrf])+)\""));
                    String name = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)e.getMessage()).get()).group(1);
                    String quotedName = package$.MODULE$.quoteIdentifier(name);
                    throw new NoSuchNamespaceException("SCHEMA_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)quotedName)})));
                }
                case 42111: {
                    String string = condition;
                    String string2 = "FAILED_JDBC.CREATE_INDEX";
                    if (string != null ? !string.equals(string2) : string2 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new IndexAlreadyExistsException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 42112: {
                    String string = condition;
                    String string3 = "FAILED_JDBC.DROP_INDEX";
                    if (string != null ? !string.equals(string3) : string3 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
            }
        }
        return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        H2SQLBuilder h2SQLBuilder = new H2SQLBuilder(this);
        try {
            some = new Some((Object)h2SQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    public H2Dialect copy() {
        return new H2Dialect();
    }

    public String productPrefix() {
        return "H2Dialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof H2Dialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof H2Dialect && ((H2Dialect)x$1).canEqual(this);
    }

    public static final /* synthetic */ void $anonfun$listIndexes$1(ObjectRef indexMap$1, ResultSet rs) {
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            String colName = rs.getString("COLUMN_NAME");
            String indexType = rs.getString("INDEX_TYPE_NAME");
            String indexComment = rs.getString("REMARKS");
            if (((scala.collection.immutable.Map)indexMap$1.elem).contains((Object)indexName)) {
                TableIndex index = (TableIndex)((scala.collection.immutable.Map)indexMap$1.elem).apply((Object)indexName);
                TableIndex newIndex = new TableIndex(indexName, indexType, (NamedReference[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])index.columns()), (Object)FieldReference$.MODULE$.apply(colName), ClassTag$.MODULE$.apply(NamedReference.class)), index.columnProperties(), index.properties());
                indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)newIndex));
                continue;
            }
            Properties properties = new Properties();
            Object object = StringUtils.isNotEmpty((CharSequence)indexComment) ? properties.put("COMMENT", indexComment) : BoxedUnit.UNIT;
            TableIndex index = new TableIndex(indexName, indexType, (NamedReference[])((Object[])new NamedReference[]{FieldReference$.MODULE$.apply(colName)}), new HashMap(), properties);
            indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)index));
        }
    }

    public H2Dialect() {
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY", "MODE", "PERCENTILE_CONT", "PERCENTILE_DISC"}));
        this.supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}))).$plus$plus(this.org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = (Set)this.supportedAggregateFunctions().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ABS", "COALESCE", "GREATEST", "LEAST", "RAND", "LOG", "LOG10", "LN", "EXP", "POWER", "SQRT", "FLOOR", "CEIL", "ROUND", "SIN", "SINH", "COS", "COSH", "TAN", "TANH", "COT", "ASIN", "ACOS", "ATAN", "ATAN2", "DEGREES", "RADIANS", "SIGN", "PI", "SUBSTRING", "UPPER", "LOWER", "TRANSLATE", "TRIM", "MD5", "SHA1", "SHA2", "BIT_LENGTH", "CHAR_LENGTH", "CONCAT", "RPAD", "LPAD"})));
        this.functionMap = new ConcurrentHashMap<String, UnboundFunction>();
    }

    public class H2SQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        @Override
        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (isDistinct && this.org$apache$spark$sql$jdbc$H2Dialect$H2SQLBuilder$$$outer().org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions().contains((Object)funcName)) {
                throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3184", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.getClass().getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
            }
            return super.visitAggregateFunction(funcName, isDistinct, inputs);
        }

        public String visitExtract(String field, String source) {
            String string;
            block5: {
                String string2 = field;
                switch (string2 == null ? 0 : string2.hashCode()) {
                    case -1351979174: {
                        if (!"YEAR_OF_WEEK".equals(string2)) break;
                        string = "ISO_WEEK_YEAR";
                        break block5;
                    }
                    case 2660340: {
                        if (!"WEEK".equals(string2)) break;
                        string = "ISO_WEEK";
                        break block5;
                    }
                    case 2074232729: {
                        if (!"DAY_OF_WEEK".equals(string2)) break;
                        string = "ISO_DAY_OF_WEEK";
                        break block5;
                    }
                }
                string = field;
            }
            String newField = string;
            return "EXTRACT(" + newField + " FROM " + source + ")";
        }

        @Override
        public String visitSQLFunction(String funcName, String[] inputs) {
            String string = funcName;
            switch (string == null ? 0 : string.hashCode()) {
                case 76158: {
                    if (!"MD5".equals(string)) break;
                    return "RAWTOHEX(HASH('MD5', " + Predef$.MODULE$.wrapRefArray((Object[])inputs).mkString(",") + "))";
                }
                case 2543909: {
                    if (!"SHA1".equals(string)) break;
                    return "RAWTOHEX(HASH('SHA-1', " + Predef$.MODULE$.wrapRefArray((Object[])inputs).mkString(",") + "))";
                }
                case 2543910: {
                    if (!"SHA2".equals(string)) break;
                    return "RAWTOHEX(HASH('SHA-" + inputs[1] + "'," + inputs[0] + "))";
                }
            }
            return super.visitSQLFunction(funcName, inputs);
        }

        public /* synthetic */ H2Dialect org$apache$spark$sql$jdbc$H2Dialect$H2SQLBuilder$$$outer() {
            return (H2Dialect)this.$outer;
        }

        public H2SQLBuilder(H2Dialect $outer) {
            super($outer);
        }
    }
}

