/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.util.UUID;
import org.apache.spark.SparkEnv;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.sql.execution.streaming.state.DeactivateInstances;
import org.apache.spark.sql.execution.streaming.state.GetLaggingStoresForTesting;
import org.apache.spark.sql.execution.streaming.state.GetLatestSnapshotVersionForTesting;
import org.apache.spark.sql.execution.streaming.state.GetLocation;
import org.apache.spark.sql.execution.streaming.state.LogLaggingStateStores;
import org.apache.spark.sql.execution.streaming.state.ReportActiveInstance;
import org.apache.spark.sql.execution.streaming.state.ReportSnapshotUploaded;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.StopCoordinator$;
import org.apache.spark.sql.execution.streaming.state.VerifyIfInstanceActive;
import org.apache.spark.sql.internal.SQLConf;
import scala.Option;
import scala.StringContext;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015u!\u0002\u000b\u0016\u0011\u0003!c!\u0002\u0014\u0016\u0011\u00039\u0003\"\u0002\u001b\u0002\t\u0003)\u0004b\u0002\u001c\u0002\u0005\u0004%Ia\u000e\u0005\u0007\u0001\u0006\u0001\u000b\u0011\u0002\u001d\t\u000b\u0005\u000bA\u0011\u0001\"\t\u000f\u0005}\u0014\u0001\"\u0001\u0002\u0002\u001a!a%\u0006\u0001E\u0011!)uA!A!\u0002\u00131\u0005\"\u0002\u001b\b\t\u0013a\u0005B\u0002(\b\t\u0003Yr\n\u0003\u0004o\u000f\u0011\u00051d\u001c\u0005\u0007k\u001e!\ta\u0007<\t\rm<A\u0011A\u000e}\u0011!\t\tb\u0002C\u00017\u0005M\u0001\u0002CA\u0014\u000f\u0011\u00051$!\u000b\t\u0011\u0005]r\u0001\"\u0001\u0016\u0003sA\u0001\"a\u0010\b\t\u0003)\u0012\u0011\t\u0005\u000b\u0003\u0013:\u0011\u0013!C\u0001+\u0005-\u0003\u0002CA1\u000f\u0011\u0005Q#a\u0019\u00021M#\u0018\r^3Ti>\u0014XmQ8pe\u0012Lg.\u0019;peJ+gM\u0003\u0002\u0017/\u0005)1\u000f^1uK*\u0011\u0001$G\u0001\ngR\u0014X-Y7j]\u001eT!AG\u000e\u0002\u0013\u0015DXmY;uS>t'B\u0001\u000f\u001e\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003=}\tQa\u001d9be.T!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0013aA8sO\u000e\u0001\u0001CA\u0013\u0002\u001b\u0005)\"\u0001G*uCR,7\u000b^8sK\u000e{wN\u001d3j]\u0006$xN\u001d*fMN\u0019\u0011\u0001\u000b\u0018\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g!\ty#'D\u00011\u0015\t\tT$\u0001\u0005j]R,'O\\1m\u0013\t\u0019\u0004GA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005!\u0013\u0001D3oIB|\u0017N\u001c;OC6,W#\u0001\u001d\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014\u0001\u00027b]\u001eT\u0011!P\u0001\u0005U\u00064\u0018-\u0003\u0002@u\t11\u000b\u001e:j]\u001e\fQ\"\u001a8ea>Lg\u000e\u001e(b[\u0016\u0004\u0013!\u00034pe\u0012\u0013\u0018N^3s)\u0015\u0019\u0015QMA9!\t)sa\u0005\u0002\bQ\u0005q!\u000f]2F]\u0012\u0004x.\u001b8u%\u00164\u0007CA$K\u001b\u0005A%BA%\u001e\u0003\r\u0011\boY\u0005\u0003\u0017\"\u0013aB\u00159d\u000b:$\u0007o\\5oiJ+g\r\u0006\u0002D\u001b\")Q)\u0003a\u0001\r\u0006!\"/\u001a9peR\f5\r^5wK&s7\u000f^1oG\u0016$R\u0001U0bU2\u00042!U-]\u001d\t\u0011vK\u0004\u0002T-6\tAK\u0003\u0002VG\u00051AH]8pizJ\u0011aK\u0005\u00031*\nq\u0001]1dW\u0006<W-\u0003\u0002[7\n\u00191+Z9\u000b\u0005aS\u0003CA\u0013^\u0013\tqVC\u0001\u000bTi\u0006$Xm\u0015;pe\u0016\u0004&o\u001c<jI\u0016\u0014\u0018\n\u001a\u0005\u0006A*\u0001\r\u0001X\u0001\u0015gR\fG/Z*u_J,\u0007K]8wS\u0012,'/\u00133\t\u000b\tT\u0001\u0019A2\u0002\t!|7\u000f\u001e\t\u0003I\"t!!\u001a4\u0011\u0005MS\u0013BA4+\u0003\u0019\u0001&/\u001a3fM&\u0011q(\u001b\u0006\u0003O*BQa\u001b\u0006A\u0002\r\f!\"\u001a=fGV$xN]%e\u0011\u0015i'\u00021\u0001Q\u0003AyG\u000f[3s!J|g/\u001b3fe&#7/\u0001\fwKJLg-_%g\u0013:\u001cH/\u00198dK\u0006\u001bG/\u001b<f)\r\u00018\u000f\u001e\t\u0003SEL!A\u001d\u0016\u0003\u000f\t{w\u000e\\3b]\")\u0001m\u0003a\u00019\")1n\u0003a\u0001G\u0006Yq-\u001a;M_\u000e\fG/[8o)\t9(\u0010E\u0002*q\u000eL!!\u001f\u0016\u0003\r=\u0003H/[8o\u0011\u0015\u0001G\u00021\u0001]\u0003M!W-Y2uSZ\fG/Z%ogR\fgnY3t)\ri\u0018\u0011\u0001\t\u0003SyL!a \u0016\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0007i\u0001\u0019AA\u0003\u0003\u0015\u0011XO\\%e!\u0011\t9!!\u0004\u000e\u0005\u0005%!bAA\u0006y\u0005!Q\u000f^5m\u0013\u0011\ty!!\u0003\u0003\tU+\u0016\nR\u0001\u0011g:\f\u0007o\u001d5piV\u0003Hn\\1eK\u0012$r\u0001]A\u000b\u00033\t\u0019\u0003\u0003\u0004\u0002\u00189\u0001\r\u0001X\u0001\u000baJ|g/\u001b3fe&#\u0007bBA\u000e\u001d\u0001\u0007\u0011QD\u0001\bm\u0016\u00148/[8o!\rI\u0013qD\u0005\u0004\u0003CQ#\u0001\u0002'p]\u001eDq!!\n\u000f\u0001\u0004\ti\"A\u0005uS6,7\u000f^1na\u0006)Bn\\4MC\u001e<\u0017N\\4Ti\u0006$Xm\u0015;pe\u0016\u001cHc\u00029\u0002,\u0005=\u00121\u0007\u0005\b\u0003[y\u0001\u0019AA\u0003\u0003)\tX/\u001a:z%Vt\u0017\n\u001a\u0005\b\u0003cy\u0001\u0019AA\u000f\u00035a\u0017\r^3tiZ+'o]5p]\"1\u0011QG\bA\u0002A\fA#[:UKJl\u0017N\\1uS:<GK]5hO\u0016\u0014\u0018AI4fi2\u000bG/Z:u':\f\u0007o\u001d5piZ+'o]5p]\u001a{'\u000fV3ti&tw\r\u0006\u0003\u0002<\u0005u\u0002\u0003B\u0015y\u0003;Aa!a\u0006\u0011\u0001\u0004a\u0016AG4fi2\u000bwmZ5oON#xN]3t\r>\u0014H+Z:uS:<Gc\u0002)\u0002D\u0005\u0015\u0013q\t\u0005\b\u0003[\t\u0002\u0019AA\u0003\u0011\u001d\t\t$\u0005a\u0001\u0003;A\u0001\"!\u000e\u0012!\u0003\u0005\r\u0001]\u0001%O\u0016$H*Y4hS:<7\u000b^8sKN4uN\u001d+fgRLgn\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\n\u0016\u0004a\u0006=3FAA)!\u0011\t\u0019&!\u0018\u000e\u0005\u0005U#\u0002BA,\u00033\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m#&\u0001\u0006b]:|G/\u0019;j_:LA!a\u0018\u0002V\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\tM$x\u000e\u001d\u000b\u0002{\"9\u0011qM\u0003A\u0002\u0005%\u0014aA3omB!\u00111NA7\u001b\u0005i\u0012bAA8;\tA1\u000b]1sW\u0016sg\u000fC\u0004\u0002t\u0015\u0001\r!!\u001e\u0002\u000fM\fHnQ8oMB!\u0011qOA>\u001b\t\tIH\u0003\u000227%!\u0011QPA=\u0005\u001d\u0019\u0016\u000bT\"p]\u001a\f1BZ8s\u000bb,7-\u001e;peR\u00191)a!\t\u000f\u0005\u001dd\u00011\u0001\u0002j\u0001")
public class StateStoreCoordinatorRef {
    private final RpcEndpointRef rpcEndpointRef;

    public static StateStoreCoordinatorRef forExecutor(SparkEnv env) {
        return StateStoreCoordinatorRef$.MODULE$.forExecutor(env);
    }

    public static StateStoreCoordinatorRef forDriver(SparkEnv env, SQLConf sqlConf) {
        return StateStoreCoordinatorRef$.MODULE$.forDriver(env, sqlConf);
    }

    public static Logging.LogStringContext LogStringContext(StringContext sc) {
        return StateStoreCoordinatorRef$.MODULE$.LogStringContext(sc);
    }

    public Seq<StateStoreProviderId> reportActiveInstance(StateStoreProviderId stateStoreProviderId, String host, String executorId, Seq<StateStoreProviderId> otherProviderIds) {
        return (Seq)this.rpcEndpointRef.askSync((Object)new ReportActiveInstance(stateStoreProviderId, host, executorId, otherProviderIds), ClassTag$.MODULE$.apply(Seq.class));
    }

    public boolean verifyIfInstanceActive(StateStoreProviderId stateStoreProviderId, String executorId) {
        return BoxesRunTime.unboxToBoolean((Object)this.rpcEndpointRef.askSync((Object)new VerifyIfInstanceActive(stateStoreProviderId, executorId), (ClassTag)ClassTag$.MODULE$.Boolean()));
    }

    public Option<String> getLocation(StateStoreProviderId stateStoreProviderId) {
        return (Option)this.rpcEndpointRef.askSync((Object)new GetLocation(stateStoreProviderId), ClassTag$.MODULE$.apply(Option.class));
    }

    public void deactivateInstances(UUID runId) {
        this.rpcEndpointRef.askSync((Object)new DeactivateInstances(runId), (ClassTag)ClassTag$.MODULE$.Boolean());
    }

    public boolean snapshotUploaded(StateStoreProviderId providerId, long version, long timestamp) {
        return BoxesRunTime.unboxToBoolean((Object)this.rpcEndpointRef.askSync((Object)new ReportSnapshotUploaded(providerId, version, timestamp), (ClassTag)ClassTag$.MODULE$.Boolean()));
    }

    public boolean logLaggingStateStores(UUID queryRunId, long latestVersion, boolean isTerminatingTrigger) {
        return BoxesRunTime.unboxToBoolean((Object)this.rpcEndpointRef.askSync((Object)new LogLaggingStateStores(queryRunId, latestVersion, isTerminatingTrigger), (ClassTag)ClassTag$.MODULE$.Boolean()));
    }

    public Option<Object> getLatestSnapshotVersionForTesting(StateStoreProviderId providerId) {
        return (Option)this.rpcEndpointRef.askSync((Object)new GetLatestSnapshotVersionForTesting(providerId), ClassTag$.MODULE$.apply(Option.class));
    }

    public Seq<StateStoreProviderId> getLaggingStoresForTesting(UUID queryRunId, long latestVersion, boolean isTerminatingTrigger) {
        return (Seq)this.rpcEndpointRef.askSync((Object)new GetLaggingStoresForTesting(queryRunId, latestVersion, isTerminatingTrigger), ClassTag$.MODULE$.apply(Seq.class));
    }

    public boolean getLaggingStoresForTesting$default$3() {
        return false;
    }

    public void stop() {
        this.rpcEndpointRef.askSync((Object)StopCoordinator$.MODULE$, (ClassTag)ClassTag$.MODULE$.Boolean());
    }

    public StateStoreCoordinatorRef(RpcEndpointRef rpcEndpointRef) {
        this.rpcEndpointRef = rpcEndpointRef;
    }
}

