/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.util.UnsafeRowUtils$;
import org.apache.spark.sql.execution.streaming.StatefulOperatorStateInfo;
import org.apache.spark.sql.execution.streaming.state.SchemaHelper;
import org.apache.spark.sql.execution.streaming.state.SchemaHelper$SchemaReader$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker;
import org.apache.spark.sql.execution.streaming.state.StateSchemaValidationResult;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class StateSchemaCompatibilityChecker$
implements Logging {
    public static final StateSchemaCompatibilityChecker$ MODULE$ = new StateSchemaCompatibilityChecker$();
    private static final int SCHEMA_FORMAT_V3;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        SCHEMA_FORMAT_V3 = 3;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public List<Path> $lessinit$greater$default$3() {
        return package$.MODULE$.List().empty();
    }

    public Option<Path> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public int SCHEMA_FORMAT_V3() {
        return SCHEMA_FORMAT_V3;
    }

    private void disallowBinaryInequalityColumn(StructType schema) {
        if (!UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)schema)) {
            throw new SparkUnsupportedOperationException("STATE_STORE_UNSUPPORTED_OPERATION_BINARY_INEQUALITY", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)schema.json())})));
        }
    }

    public List<StateStoreColFamilySchema> readSchemaFile(FSDataInputStream inStream) {
        List<StateStoreColFamilySchema> list;
        try {
            try {
                String versionStr = inStream.readUTF();
                SchemaHelper.SchemaReader schemaReader = SchemaHelper$SchemaReader$.MODULE$.createSchemaReader(versionStr);
                list = schemaReader.read(inStream);
            }
            catch (Throwable e) {
                this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to read schema file"}))).log((Seq)Nil$.MODULE$)), e);
                throw e;
            }
        }
        finally {
            inStream.close();
        }
        return list;
    }

    public StateSchemaValidationResult validateAndMaybeEvolveStateSchema(StatefulOperatorStateInfo stateInfo, Configuration hadoopConf, List<StateStoreColFamilySchema> newStateSchema, SessionState sessionState, int stateSchemaVersion, scala.collection.immutable.Map<String, String> extraOptions, String storeName, List<Path> oldSchemaFilePaths, Option<Path> newSchemaFilePath, boolean schemaEvolutionEnabled) {
        newStateSchema.foreach((Function1 & Serializable)schema -> {
            StateSchemaCompatibilityChecker$.MODULE$.disallowBinaryInequalityColumn(schema.keySchema());
            return BoxedUnit.UNIT;
        });
        StateStoreConf storeConf = new StateStoreConf(sessionState.conf(), extraOptions);
        StateStoreProviderId providerId = new StateStoreProviderId(new StateStoreId(stateInfo.checkpointLocation(), stateInfo.operatorId(), 0, storeName), stateInfo.queryRunId());
        StateSchemaCompatibilityChecker checker = new StateSchemaCompatibilityChecker(providerId, hadoopConf, oldSchemaFilePaths, newSchemaFilePath);
        BooleanRef evolvedSchema = BooleanRef.create((boolean)false);
        Option result = (Option)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> checker.validateAndMaybeEvolveStateSchema(newStateSchema, !storeConf.formatValidationCheckValue(), stateSchemaVersion, schemaEvolutionEnabled)).toEither().fold((Function1 & Serializable)x$11 -> new Some(x$11), (Function1 & Serializable)hasEvolvedSchema -> StateSchemaCompatibilityChecker$.$anonfun$validateAndMaybeEvolveStateSchema$10(evolvedSchema, BoxesRunTime.unboxToBoolean((Object)hasEvolvedSchema)));
        if (storeConf.stateSchemaCheckEnabled() && result.isDefined()) {
            throw (Throwable)result.get();
        }
        String schemaFileLocation = evolvedSchema.elem ? (stateSchemaVersion == this.SCHEMA_FORMAT_V3() ? ((Path)newSchemaFilePath.get()).toString() : checker.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation().toString()) : (stateSchemaVersion == this.SCHEMA_FORMAT_V3() ? ((Path)oldSchemaFilePaths.last()).toString() : checker.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation().toString());
        return new StateSchemaValidationResult(evolvedSchema.elem, schemaFileLocation);
    }

    public scala.collection.immutable.Map<String, String> validateAndMaybeEvolveStateSchema$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    public String validateAndMaybeEvolveStateSchema$default$7() {
        return StateStoreId$.MODULE$.DEFAULT_STORE_NAME();
    }

    public List<Path> validateAndMaybeEvolveStateSchema$default$8() {
        return package$.MODULE$.List().empty();
    }

    public Option<Path> validateAndMaybeEvolveStateSchema$default$9() {
        return None$.MODULE$;
    }

    public boolean validateAndMaybeEvolveStateSchema$default$10() {
        return false;
    }

    public static final /* synthetic */ None$ $anonfun$validateAndMaybeEvolveStateSchema$10(BooleanRef evolvedSchema$1, boolean hasEvolvedSchema) {
        evolvedSchema$1.elem = hasEvolvedSchema;
        return None$.MODULE$;
    }

    private StateSchemaCompatibilityChecker$() {
    }
}

