/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.UUID;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001\u0002\u000f\u001e\u0001)B\u0001b\u000e\u0001\u0003\u0006\u0004%I\u0001\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005s!A\u0001\t\u0001BC\u0002\u0013%\u0011\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003C\u0011!I\u0005A!b\u0001\n\u0003Q\u0005\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u000be\u0003A\u0011\u0001.\t\u000f\u0001\u0004\u0001\u0019!C\u0001C\"9Q\r\u0001a\u0001\n\u00031\u0007B\u00027\u0001A\u0003&!\rC\u0004n\u0001\t\u0007I\u0011\u00028\t\rq\u0004\u0001\u0015!\u0003p\u0011\u001di\bA1A\u0005\u0002\u0005DaA \u0001!\u0002\u0013\u0011\u0007\u0002C@\u0001\u0005\u0004%\t!!\u0001\t\u0011\u0005%\u0001\u0001)A\u0005\u0003\u0007A\u0011\"a\u0003\u0001\u0005\u0004%\t!!\u0004\t\u0011\u0005m\u0001\u0001)A\u0005\u0003\u001fA\u0011\"!\b\u0001\u0005\u0004%I!a\b\t\u0011\u0005U\u0002\u0001)A\u0005\u0003CAq!a\u000e\u0001\t\u0003\tI\u0004C\u0004\u0002B\u0001!\t!a\u0011\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H!9\u0011Q\n\u0001\u0005\n\u0005=\u0003bBA*\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0003_\u0002A\u0011BA9\u0011\u001d\t)\t\u0001C\u0001\u0003\u000f\u0013\u0001\u0003\u0015:pOJ,7o\u001d*fa>\u0014H/\u001a:\u000b\u0005yy\u0012!C:ue\u0016\fW.\u001b8h\u0015\t\u0001\u0013%A\u0005fq\u0016\u001cW\u000f^5p]*\u0011!eI\u0001\u0004gFd'B\u0001\u0013&\u0003\u0015\u0019\b/\u0019:l\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aK\u0019\u0011\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\r\u0005s\u0017PU3g!\t\u0011T'D\u00014\u0015\t!4%\u0001\u0005j]R,'O\\1m\u0013\t14GA\u0004M_\u001e<\u0017N\\4\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0016\u0003e\u0002\"AO\u001f\u000e\u0003mR!\u0001P\u0011\u0002\u000f\rd\u0017m]:jG&\u0011ah\u000f\u0002\r'B\f'o[*fgNLwN\\\u0001\u000egB\f'o[*fgNLwN\u001c\u0011\u0002\u0019Q\u0014\u0018nZ4fe\u000ecwnY6\u0016\u0003\t\u0003\"a\u0011$\u000e\u0003\u0011S!!R\u0012\u0002\tU$\u0018\u000e\\\u0005\u0003\u000f\u0012\u0013Qa\u00117pG.\fQ\u0002\u001e:jO\u001e,'o\u00117pG.\u0004\u0013a\u00037pO&\u001c\u0017\r\u001c)mC:,\u0012a\u0013\t\u0004Y1s\u0015BA'.\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002P-6\t\u0001K\u0003\u0002R%\u00069An\\4jG\u0006d'BA*U\u0003\u0015\u0001H.\u00198t\u0015\t)\u0016%\u0001\u0005dCR\fG._:u\u0013\t9\u0006KA\u0006M_\u001eL7-\u00197QY\u0006t\u0017\u0001\u00047pO&\u001c\u0017\r\u001c)mC:\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003\\;z{\u0006C\u0001/\u0001\u001b\u0005i\u0002\"B\u001c\b\u0001\u0004I\u0004\"\u0002!\b\u0001\u0004\u0011\u0005\"B%\b\u0001\u0004Y\u0015\u0001\t7bgRtu.\u0012=fGV$\u0018n\u001c8Qe><'/Z:t\u000bZ,g\u000e\u001e+j[\u0016,\u0012A\u0019\t\u0003Y\rL!\u0001Z\u0017\u0003\t1{gnZ\u0001%Y\u0006\u001cHOT8Fq\u0016\u001cW\u000f^5p]B\u0013xn\u001a:fgN,e/\u001a8u)&lWm\u0018\u0013fcR\u0011qM\u001b\t\u0003Y!L!![\u0017\u0003\tUs\u0017\u000e\u001e\u0005\bW&\t\t\u00111\u0001c\u0003\rAH%M\u0001\"Y\u0006\u001cHOT8Fq\u0016\u001cW\u000f^5p]B\u0013xn\u001a:fgN,e/\u001a8u)&lW\rI\u0001\u000faJ|wM]3tg\n+hMZ3s+\u0005y\u0007c\u00019vo6\t\u0011O\u0003\u0002sg\u00069Q.\u001e;bE2,'B\u0001;.\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003mF\u0014Q!U;fk\u0016\u0004\"\u0001\u001f>\u000e\u0003eT!AH\u0011\n\u0005mL(AF*ue\u0016\fW.\u001b8h#V,'/\u001f)s_\u001e\u0014Xm]:\u0002\u001fA\u0014xn\u001a:fgN\u0014UO\u001a4fe\u0002\n1D\\8ECR\f\u0007K]8he\u0016\u001c8/\u0012<f]RLe\u000e^3sm\u0006d\u0017\u0001\b8p\t\u0006$\u0018\r\u0015:pOJ,7o]#wK:$\u0018J\u001c;feZ\fG\u000eI\u0001#G>|'\u000fZ5oCR|'OU3q_J$8K\\1qg\"|G/\u00169m_\u0006$G*Y4\u0016\u0005\u0005\r\u0001c\u0001\u0017\u0002\u0006%\u0019\u0011qA\u0017\u0003\u000f\t{w\u000e\\3b]\u0006\u00193m\\8sI&t\u0017\r^8s%\u0016\u0004xN\u001d;T]\u0006\u00048\u000f[8u+Bdw.\u00193MC\u001e\u0004\u0013!F:uCR,7\u000b^8sK\u000e{wN\u001d3j]\u0006$xN]\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+i\u0012!B:uCR,\u0017\u0002BA\r\u0003'\u0011\u0001d\u0015;bi\u0016\u001cFo\u001c:f\u0007>|'\u000fZ5oCR|'OU3g\u0003Y\u0019H/\u0019;f'R|'/Z\"p_J$\u0017N\\1u_J\u0004\u0013a\u0004;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003ci!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0007M>\u0014X.\u0019;\u000b\t\u0005-\u0012QF\u0001\u0005i&lWM\u0003\u0002\u00020\u0005!!.\u0019<b\u0013\u0011\t\u0019$!\n\u0003#\u0011\u000bG/\u001a+j[\u00164uN]7biR,'/\u0001\tuS6,7\u000f^1na\u001a{'/\\1uA\u0005q!/Z2f]R\u0004&o\\4sKN\u001cXCAA\u001e!\u0011a\u0013QH<\n\u0007\u0005}RFA\u0003BeJ\f\u00170\u0001\u0007mCN$\bK]8he\u0016\u001c8/F\u0001x\u00039)\b\u000fZ1uKB\u0013xn\u001a:fgN$2aZA%\u0011\u0019\tYe\u0006a\u0001o\u0006Ya.Z<Qe><'/Z:t\u00039\tG\r\u001a(foB\u0013xn\u001a:fgN$2aZA)\u0011\u0019\tY\u0005\u0007a\u0001o\u0006qQ\u000f\u001d3bi\u0016LE\r\\3oKN\u001cH#C4\u0002X\u0005\u0015\u0014\u0011NA7\u0011\u001d\tI&\u0007a\u0001\u00037\n!!\u001b3\u0011\t\u0005u\u0013\u0011M\u0007\u0003\u0003?R1!RA\u0017\u0013\u0011\t\u0019'a\u0018\u0003\tU+\u0016\n\u0012\u0005\b\u0003OJ\u0002\u0019AA.\u0003\u0015\u0011XO\\%e\u0011\u0019\tY'\u0007a\u0001E\u0006a2-\u001e:sK:$HK]5hO\u0016\u00148\u000b^1siRKW.Z:uC6\u0004\bBBA&3\u0001\u0007q/A\u0005q_N$XI^3oiR\u0019q-a\u001d\t\u000f\u0005U$\u00041\u0001\u0002x\u0005)QM^3oiB!\u0011\u0011PA@\u001d\rA\u00181P\u0005\u0004\u0003{J\u0018AF*ue\u0016\fW.\u001b8h#V,'/\u001f'jgR,g.\u001a:\n\t\u0005\u0005\u00151\u0011\u0002\u0006\u000bZ,g\u000e\u001e\u0006\u0004\u0003{J\u0018a\u00044pe6\fG\u000fV5nKN$\u0018-\u001c9\u0015\t\u0005%\u0015q\u0014\t\u0005\u0003\u0017\u000bIJ\u0004\u0003\u0002\u000e\u0006U\u0005cAAH[5\u0011\u0011\u0011\u0013\u0006\u0004\u0003'K\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u00186\na\u0001\u0015:fI\u00164\u0017\u0002BAN\u0003;\u0013aa\u0015;sS:<'bAAL[!1\u0011\u0011U\u000eA\u0002\t\fa!\\5mY&\u001c\b")
public class ProgressReporter
implements Logging {
    private final SparkSession sparkSession;
    private final Clock triggerClock;
    private final Function0<LogicalPlan> logicalPlan;
    private long lastNoExecutionProgressEventTime;
    private final Queue<StreamingQueryProgress> progressBuffer;
    private final long noDataProgressEventInterval;
    private final boolean coordinatorReportSnapshotUploadLag;
    private final StateStoreCoordinatorRef stateStoreCoordinator;
    private final DateTimeFormatter timestampFormat;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkSession sparkSession() {
        return this.sparkSession;
    }

    private Clock triggerClock() {
        return this.triggerClock;
    }

    public Function0<LogicalPlan> logicalPlan() {
        return this.logicalPlan;
    }

    public long lastNoExecutionProgressEventTime() {
        return this.lastNoExecutionProgressEventTime;
    }

    public void lastNoExecutionProgressEventTime_$eq(long x$1) {
        this.lastNoExecutionProgressEventTime = x$1;
    }

    private Queue<StreamingQueryProgress> progressBuffer() {
        return this.progressBuffer;
    }

    public long noDataProgressEventInterval() {
        return this.noDataProgressEventInterval;
    }

    public boolean coordinatorReportSnapshotUploadLag() {
        return this.coordinatorReportSnapshotUploadLag;
    }

    public StateStoreCoordinatorRef stateStoreCoordinator() {
        return this.stateStoreCoordinator;
    }

    private DateTimeFormatter timestampFormat() {
        return this.timestampFormat;
    }

    public StreamingQueryProgress[] recentProgress() {
        StreamingQueryProgress[] streamingQueryProgressArray;
        Queue<StreamingQueryProgress> queue = this.progressBuffer();
        synchronized (queue) {
            streamingQueryProgressArray = (StreamingQueryProgress[])this.progressBuffer().toArray(ClassTag$.MODULE$.apply(StreamingQueryProgress.class));
        }
        return streamingQueryProgressArray;
    }

    public StreamingQueryProgress lastProgress() {
        StreamingQueryProgress streamingQueryProgress;
        Queue<StreamingQueryProgress> queue = this.progressBuffer();
        synchronized (queue) {
            streamingQueryProgress = (StreamingQueryProgress)this.progressBuffer().lastOption().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return streamingQueryProgress;
    }

    public void updateProgress(StreamingQueryProgress newProgress) {
        this.lastNoExecutionProgressEventTime_$eq(this.triggerClock().getTimeMillis());
        this.addNewProgress(newProgress);
        this.postEvent((StreamingQueryListener.Event)new StreamingQueryListener.QueryProgressEvent(newProgress));
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Streaming query made progress: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STREAMING_QUERY_PROGRESS$.MODULE$, (Object)newProgress)}))));
    }

    private void addNewProgress(StreamingQueryProgress newProgress) {
        Queue<StreamingQueryProgress> queue = this.progressBuffer();
        synchronized (queue) {
            this.progressBuffer().$plus$eq((Object)newProgress);
            while (this.progressBuffer().length() >= this.sparkSession().sessionState().conf().streamingProgressRetention()) {
                this.progressBuffer().dequeue();
            }
        }
    }

    public void updateIdleness(UUID id, UUID runId, long currentTriggerStartTimestamp, StreamingQueryProgress newProgress) {
        long now = this.triggerClock().getTimeMillis();
        if (now - this.noDataProgressEventInterval() >= this.lastNoExecutionProgressEventTime()) {
            this.addNewProgress(newProgress);
            if (this.lastNoExecutionProgressEventTime() > Long.MIN_VALUE) {
                this.postEvent((StreamingQueryListener.Event)new StreamingQueryListener.QueryIdleEvent(id, runId, this.formatTimestamp(currentTriggerStartTimestamp)));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Streaming query has been idle and waiting for new data more than "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TIME_UNITS$.MODULE$, (Object)BoxesRunTime.boxToLong((long)this.noDataProgressEventInterval()))})))));
            }
            this.lastNoExecutionProgressEventTime_$eq(now);
            return;
        }
    }

    private void postEvent(StreamingQueryListener.Event event) {
        this.sparkSession().streams().postListenerEvent(event);
    }

    public String formatTimestamp(long millis) {
        return Instant.ofEpochMilli(millis).atZone(ZoneId.of("Z")).format(this.timestampFormat());
    }

    public ProgressReporter(SparkSession sparkSession, Clock triggerClock, Function0<LogicalPlan> logicalPlan2) {
        this.sparkSession = sparkSession;
        this.triggerClock = triggerClock;
        this.logicalPlan = logicalPlan2;
        Logging.$init$((Logging)this);
        this.lastNoExecutionProgressEventTime = Long.MIN_VALUE;
        this.progressBuffer = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        this.noDataProgressEventInterval = sparkSession.sessionState().conf().streamingNoDataProgressEventInterval();
        this.coordinatorReportSnapshotUploadLag = sparkSession.sessionState().conf().stateStoreCoordinatorReportSnapshotUploadLag();
        this.stateStoreCoordinator = sparkSession.sessionState().streamingQueryManager().stateStoreCoordinator();
        this.timestampFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(DateTimeUtils$.MODULE$.getZoneId("UTC"));
    }
}

