/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.streaming.ListStateImplWithTTL$;
import org.apache.spark.sql.execution.streaming.OneToManyTTLState;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder$;
import org.apache.spark.sql.execution.streaming.TTLState;
import org.apache.spark.sql.execution.streaming.TransformWithStateKeyValueRowSchemaUtils$;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.streaming.ListState;
import org.apache.spark.sql.streaming.TTLConfig;
import org.apache.spark.util.NextIterator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001B\f\u0019\u0001\u0015B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003S\u0011!Y\u0006A!A!\u0002\u0013a\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u0011\r\u0004!\u0011!Q\u0001\n\u0011DQ!\u001c\u0001\u0005\u00029D\u0001b\u001e\u0001\t\u0006\u0004%I\u0001\u001f\u0005\u0006y\u0002!I! \u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\ti\u0001\u0001C!\u0003\u001fAq!a\t\u0001\t\u0003\n)\u0003C\u0004\u00022\u0001!\t%a\r\t\u000f\u0005]\u0002\u0001\"\u0011\u0002:!1\u0011Q\b\u0001\u0005BuDq!a\u0010\u0001\t\u0013\t\t\u0005C\u0004\u0002F\u0001!\t%a\u0012\t\u0011\u0005\u0005\u0004\u0001\"\u0001\u001d\u0003\u001fA\u0001\"a\u0019\u0001\t\u0003a\u0012Q\r\u0005\t\u0003_\u0002A\u0011\u0001\u000f\u0002r!A\u0011Q\u000f\u0001\u0005\u0002q\t9H\u0001\u000bMSN$8\u000b^1uK&k\u0007\u000f\\,ji\"$F\u000b\u0014\u0006\u00033i\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005ma\u0012!C3yK\u000e,H/[8o\u0015\tib$A\u0002tc2T!a\b\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0005\u0012\u0013AB1qC\u000eDWMC\u0001$\u0003\ry'oZ\u0002\u0001+\t1#gE\u0002\u0001O-\u0002\"\u0001K\u0015\u000e\u0003aI!A\u000b\r\u0003#=sW\rV8NC:LH\u000b\u0016'Ti\u0006$X\rE\u0002-]Aj\u0011!\f\u0006\u00033qI!aL\u0017\u0003\u00131K7\u000f^*uCR,\u0007CA\u00193\u0019\u0001!Qa\r\u0001C\u0002Q\u0012\u0011aU\t\u0003km\u0002\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012qAT8uQ&tw\r\u0005\u00027y%\u0011Qh\u000e\u0002\u0004\u0003:L\u0018!B:u_J,\u0007C\u0001!D\u001b\u0005\t%B\u0001\"\u0019\u0003\u0015\u0019H/\u0019;f\u0013\t!\u0015I\u0001\u0006Ti\u0006$Xm\u0015;pe\u0016\f\u0011b\u001d;bi\u0016t\u0015-\\3\u0011\u0005\u001dseB\u0001%M!\tIu'D\u0001K\u0015\tYE%\u0001\u0004=e>|GOP\u0005\u0003\u001b^\na\u0001\u0015:fI\u00164\u0017BA(Q\u0005\u0019\u0019FO]5oO*\u0011QjN\u0001\u000bW\u0016LX\t\u001f9s\u000b:\u001c\u0007cA*Yw5\tAK\u0003\u0002V-\u0006AQM\\2pI\u0016\u00148O\u0003\u0002X9\u0005A1-\u0019;bYf\u001cH/\u0003\u0002Z)\n\tR\t\u001f9sKN\u001c\u0018n\u001c8F]\u000e|G-\u001a:\u0002\u0015Y\fG.\u00128d_\u0012,'/A\u0005ui2\u001cuN\u001c4jOB\u0011A&X\u0005\u0003=6\u0012\u0011\u0002\u0016+M\u0007>tg-[4\u0002!\t\fGo\u00195US6,7\u000f^1na6\u001b\bC\u0001\u001cb\u0013\t\u0011wG\u0001\u0003M_:<\u0017aB7fiJL7m\u001d\t\u0005\u000f\u00164u-\u0003\u0002g!\n\u0019Q*\u00199\u0011\u0005!\\W\"A5\u000b\u0005)T\u0012AB7fiJL7-\u0003\u0002mS\nI1+\u0015'NKR\u0014\u0018nY\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011=\u0004\u0018O]:ukZ\u00042\u0001\u000b\u00011\u0011\u0015q\u0004\u00021\u0001@\u0011\u0015)\u0005\u00021\u0001G\u0011\u0015\t\u0006\u00021\u0001S\u0011\u0015Q\u0006\u00021\u0001S\u0011\u0015Y\u0006\u00021\u0001]\u0011\u0015y\u0006\u00021\u0001a\u0011\u0015\u0019\u0007\u00021\u0001e\u0003E\u0019H/\u0019;f)f\u0004Xm]#oG>$WM]\u000b\u0002sB\u0019\u0001F_\u001e\n\u0005mD\"!E*uCR,G+\u001f9fg\u0016s7m\u001c3fe\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0003y\u0004\"AN@\n\u0007\u0005\u0005qG\u0001\u0003V]&$\u0018AB3ySN$8\u000f\u0006\u0002\u0002\bA\u0019a'!\u0003\n\u0007\u0005-qGA\u0004C_>dW-\u00198\u0002\u0007\u001d,G\u000f\u0006\u0002\u0002\u0012A)\u00111CA\u000fa9!\u0011QCA\r\u001d\rI\u0015qC\u0005\u0002q%\u0019\u00111D\u001c\u0002\u000fA\f7m[1hK&!\u0011qDA\u0011\u0005!IE/\u001a:bi>\u0014(bAA\u000eo\u0005\u0019\u0001/\u001e;\u0015\u0007y\f9\u0003C\u0004\u0002*5\u0001\r!a\u000b\u0002\u00119,wo\u0015;bi\u0016\u0004BANA\u0017a%\u0019\u0011qF\u001c\u0003\u000b\u0005\u0013(/Y=\u0002\u0017\u0005\u0004\b/\u001a8e-\u0006dW/\u001a\u000b\u0004}\u0006U\u0002BBA\u0015\u001d\u0001\u0007\u0001'\u0001\u0006baB,g\u000e\u001a'jgR$2A`A\u001e\u0011\u001d\tIc\u0004a\u0001\u0003W\tQa\u00197fCJ\f\u0001C^1mS\u0012\fG/\u001a(foN#\u0018\r^3\u0015\u0007y\f\u0019\u0005C\u0004\u0002*E\u0001\r!a\u000b\u0002%\rdW-\u0019:FqBL'/\u001a3WC2,Xm\u001d\u000b\u0005\u0003\u0013\n\t\u0006\u0005\u0003\u0002L\u00055S\"\u0001\u0001\n\u0007\u0005=\u0013FA\u000bWC2,X-\u0012=qSJ\fG/[8o%\u0016\u001cX\u000f\u001c;\t\u000f\u0005M#\u00031\u0001\u0002V\u0005QQ\r\\3nK:$8*Z=\u0011\t\u0005]\u0013QL\u0007\u0003\u00033R1!a\u0017W\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u0005}\u0013\u0011\f\u0002\n+:\u001c\u0018MZ3S_^\facZ3u/&$\bn\\;u\u000b:4wN]2j]\u001e$F\u000bT\u0001\rO\u0016$H\u000b\u0016'WC2,Xm\u001d\u000b\u0003\u0003O\u0002b!a\u0005\u0002\u001e\u0005%\u0004#\u0002\u001c\u0002lA\u0002\u0017bAA7o\t1A+\u001e9mKJ\nAbZ3u\u001b&tg+\u00197vKN$\"!a\u001d\u0011\u000b\u0005M\u0011Q\u00041\u0002%\u001d,GOV1mk\u0016Le\u000e\u0016+M'R\fG/\u001a\u000b\u0003\u0003s\u0002BANA>A&\u0019\u0011QP\u001c\u0003\r=\u0003H/[8o\u0001")
public class ListStateImplWithTTL<S>
extends OneToManyTTLState
implements ListState<S> {
    private StateTypesEncoder<Object> org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder;
    private final StateStore store;
    private final String stateName;
    private final ExpressionEncoder<Object> keyExprEnc;
    private final ExpressionEncoder<Object> valEncoder;
    public final long org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$batchTimestampMs;
    private volatile boolean bitmap$0;

    private StateTypesEncoder<Object> stateTypesEncoder$lzycompute() {
        ListStateImplWithTTL listStateImplWithTTL = this;
        synchronized (listStateImplWithTTL) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder = StateTypesEncoder$.MODULE$.apply(this.keyExprEnc, this.valEncoder, this.stateName, true);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder;
    }

    public StateTypesEncoder<Object> org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder() {
        if (!this.bitmap$0) {
            return this.stateTypesEncoder$lzycompute();
        }
        return this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder;
    }

    private void initialize() {
        this.store.createColFamilyIfAbsent(this.stateName, this.keyExprEnc.schema(), TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getValueSchemaWithTTL(this.valEncoder.schema(), true), new NoPrefixKeyStateEncoderSpec(this.keyExprEnc.schema()), true, this.store.createColFamilyIfAbsent$default$6());
    }

    public boolean exists() {
        return this.get().nonEmpty();
    }

    public Iterator<S> get() {
        UnsafeRow encodedKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        Iterator<UnsafeRow> unsafeRowValuesIterator = this.store.valuesIterator(encodedKey, this.stateName);
        return new NextIterator<S>(this, unsafeRowValuesIterator){
            private final /* synthetic */ ListStateImplWithTTL $outer;
            private final Iterator unsafeRowValuesIterator$1;

            public S getNext() {
                Iterator iter = this.unsafeRowValuesIterator$1.dropWhile((Function1 & Serializable)row -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$getNext$1(this, row)));
                if (iter.hasNext()) {
                    UnsafeRow currentRow = (UnsafeRow)iter.next();
                    return (S)this.$outer.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().decodeValue(currentRow);
                }
                this.finished_$eq(true);
                return null;
            }

            public void close() {
            }

            public static final /* synthetic */ boolean $anonfun$getNext$1($anon$1 $this, UnsafeRow row) {
                return $this.$outer.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().isExpired(row, $this.$outer.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$batchTimestampMs);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.unsafeRowValuesIterator$1 = unsafeRowValuesIterator$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getNext$1$adapted(org.apache.spark.sql.execution.streaming.ListStateImplWithTTL$$anon$1 org.apache.spark.sql.catalyst.expressions.UnsafeRow )}, serializedLambda);
            }
        };
    }

    public void put(Object newState) {
        this.validateNewState(newState);
        UnsafeRow encodedKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        Iterator newStateUnsafeRows = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.genericArrayOps(newState)).map((Function1 & Serializable)v -> this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeValue(v, this.ttlExpirationMs()));
        this.updatePrimaryAndSecondaryIndices(true, encodedKey, (Iterator<UnsafeRow>)newStateUnsafeRows, this.ttlExpirationMs());
    }

    public void appendValue(S newState) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(newState, this.stateName);
        UnsafeRow encodedKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        UnsafeRow newStateUnsafeRow = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeValue(newState, this.ttlExpirationMs());
        this.updatePrimaryAndSecondaryIndices(false, encodedKey, (Iterator<UnsafeRow>)scala.package$.MODULE$.Iterator().single((Object)newStateUnsafeRow), this.ttlExpirationMs());
    }

    public void appendList(Object newState) {
        this.validateNewState(newState);
        UnsafeRow encodedKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        Iterator newStateUnsafeRows = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.genericArrayOps(newState)).map((Function1 & Serializable)v -> this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeValue(v, this.ttlExpirationMs()));
        this.updatePrimaryAndSecondaryIndices(false, encodedKey, (Iterator<UnsafeRow>)newStateUnsafeRows, this.ttlExpirationMs());
    }

    public void clear() {
        UnsafeRow groupingKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        this.clearAllStateForElementKey(groupingKey);
    }

    private void validateNewState(Object newState) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(newState, this.stateName);
        StateStoreErrors$.MODULE$.requireNonEmptyListStateValue(newState, this.stateName);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps(newState), (Function1 & Serializable)v -> {
            StateStoreErrors$.MODULE$.requireNonNullStateValue(v, this.stateName);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public OneToManyTTLState.ValueExpirationResult clearExpiredValues(UnsafeRow elementKey) {
        LongRef numValuesExpired = LongRef.create((long)0L);
        Iterator<UnsafeRow> unsafeRowValuesIterator = this.store.valuesIterator(elementKey, this.stateName);
        this.store.remove(elementKey, this.stateName);
        ObjectRef newMinExpirationMsOpt = ObjectRef.create((Object)None$.MODULE$);
        BooleanRef isFirst = BooleanRef.create((boolean)true);
        unsafeRowValuesIterator.foreach((Function1 & Serializable)encodedValue -> {
            ListStateImplWithTTL.$anonfun$clearExpiredValues$1(this, isFirst, elementKey, newMinExpirationMsOpt, numValuesExpired, encodedValue);
            return BoxedUnit.UNIT;
        });
        return new OneToManyTTLState.ValueExpirationResult(this, numValuesExpired.elem, (Option<Object>)((Option)newMinExpirationMsOpt.elem));
    }

    public Iterator<S> getWithoutEnforcingTTL() {
        UnsafeRow encodedGroupingKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        Iterator<UnsafeRow> unsafeRowValuesIterator = this.store.valuesIterator(encodedGroupingKey, this.stateName);
        return unsafeRowValuesIterator.map((Function1 & Serializable)valueUnsafeRow -> this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().decodeValue((UnsafeRow)valueUnsafeRow));
    }

    public Iterator<Tuple2<S, Object>> getTTLValues() {
        UnsafeRow encodedGroupingKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        Iterator<UnsafeRow> unsafeRowValuesIterator = this.store.valuesIterator(encodedGroupingKey, this.stateName);
        return unsafeRowValuesIterator.map((Function1 & Serializable)valueUnsafeRow -> new Tuple2(this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().decodeValue((UnsafeRow)valueUnsafeRow), this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().decodeTtlExpirationMs((UnsafeRow)valueUnsafeRow).get()));
    }

    public Iterator<Object> getMinValues() {
        UnsafeRow groupingKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        return this.minIndexIterator().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ListStateImplWithTTL.$anonfun$getMinValues$1(groupingKey, x$1))).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2._2$mcJ$sp()));
    }

    public Option<Object> getValueInTTLState() {
        UnsafeRow groupingKey = this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        Seq ttlRowsForGroupingKey = this.getTTLRows().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ListStateImplWithTTL.$anonfun$getValueInTTLState$1(groupingKey, x$3))).toSeq();
        Predef$.MODULE$.assert(ttlRowsForGroupingKey.size() <= 1, (Function0 & Serializable)() -> "Multiple TTLRows found for grouping key " + groupingKey + ". Expected at most 1. Found: " + ttlRowsForGroupingKey.mkString(", ") + ".");
        return ttlRowsForGroupingKey.headOption().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.expirationMs()));
    }

    public static final /* synthetic */ void $anonfun$clearExpiredValues$1(ListStateImplWithTTL $this, BooleanRef isFirst$1, UnsafeRow elementKey$1, ObjectRef newMinExpirationMsOpt$1, LongRef numValuesExpired$1, UnsafeRow encodedValue) {
        if (!$this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().isExpired(encodedValue, $this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$batchTimestampMs)) {
            Some some;
            if (isFirst$1.elem) {
                isFirst$1.elem = false;
                $this.store.put(elementKey$1, encodedValue, $this.stateName);
            } else {
                $this.store.merge(elementKey$1, encodedValue, $this.stateName);
            }
            Option<Object> currentExpirationMs = $this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$stateTypesEncoder().decodeTtlExpirationMs(encodedValue);
            Option option = (Option)newMinExpirationMsOpt$1.elem;
            if (option instanceof Some) {
                Some some2 = (Some)option;
                long minExpirationMs = BoxesRunTime.unboxToLong((Object)some2.value());
                some = new Some((Object)BoxesRunTime.boxToLong((long)package$.MODULE$.min(minExpirationMs, BoxesRunTime.unboxToLong((Object)currentExpirationMs.get()))));
            } else if (None$.MODULE$.equals(option)) {
                some = new Some(currentExpirationMs.get());
            } else {
                throw new MatchError((Object)option);
            }
            newMinExpirationMsOpt$1.elem = some;
            return;
        }
        ++numValuesExpired$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$getMinValues$1(UnsafeRow groupingKey$1, Tuple2 x$1) {
        Object object = x$1._1();
        UnsafeRow unsafeRow = groupingKey$1;
        return !(object != null ? !object.equals(unsafeRow) : unsafeRow != null);
    }

    public static final /* synthetic */ boolean $anonfun$getValueInTTLState$1(UnsafeRow groupingKey$2, TTLState.TTLRow x$3) {
        UnsafeRow unsafeRow = x$3.elementKey();
        UnsafeRow unsafeRow2 = groupingKey$2;
        return !(unsafeRow != null ? !unsafeRow.equals(unsafeRow2) : unsafeRow2 != null);
    }

    public ListStateImplWithTTL(StateStore store, String stateName, ExpressionEncoder<Object> keyExprEnc, ExpressionEncoder<Object> valEncoder, TTLConfig ttlConfig, long batchTimestampMs, Map<String, SQLMetric> metrics) {
        this.store = store;
        this.stateName = stateName;
        this.keyExprEnc = keyExprEnc;
        this.valEncoder = valEncoder;
        this.org$apache$spark$sql$execution$streaming$ListStateImplWithTTL$$batchTimestampMs = batchTimestampMs;
        super(stateName, store, keyExprEnc.schema(), ttlConfig, batchTimestampMs, metrics);
        this.initialize();
    }
}

