/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.CompactibleFileStreamLog$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.util.Utils$;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t5d!B\u0017/\u0003\u0003Y\u0004\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u0011Y\u0003!\u0011!Q\u0001\n]C\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tO\u0002\u0011\u0019\u0011)A\u0006Q\")a\u000e\u0001C\u0001_\"9a\u000f\u0001b\u0001\n\u00179\bB\u0002@\u0001A\u0003%\u0001\u0010\u0003\u0005\u0000\u0001\t\u0007I1BA\u0001\u0011!\tI\u0001\u0001Q\u0001\n\u0005\r\u0001\"CA\u0006\u0001\t\u0007I\u0011CA\u0007\u0011\u001d\ty\u0001\u0001Q\u0001\nMCq!!\u0005\u0001\r#\t\u0019\u0002C\u0004\u0002\u001c\u00011\t\"!\b\t\u000f\u0005\u0015\u0002A\"\u0005\u0002\u000e!Q\u0011q\u0005\u0001\t\u0006\u0004%)\"!\u0004\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,!9\u0011Q\u0007\u0001\u0005B\u0005]\u0002bBA'\u0001\u0011\u0005\u0013q\n\u0005\b\u0003'\u0002A\u0011IA+\u0011\u001d\tI\u0006\u0001C\u0005\u00037Bq!a\u001f\u0001\t\u0013\ti\bC\u0004\u0002\u0004\u0002!\t%!\"\t\u000f\u00055\u0005\u0001\"\u0011\u0002\u0010\"9\u00111\u0014\u0001\u0005B\u0005u\u0005bBAS\u0001\u0011\u0005\u0013q\u0015\u0005\b\u0003[\u0003A\u0011AAX\u0011\u001d\ty\f\u0001C\u0001\u0003\u0003Dq!a5\u0001\t\u0013\t)\u000eC\u0004\u0003\u0002\u0001!IAa\u0001\t\u000f\t%\u0001\u0001\"\u0001\u0003\f!9!Q\u0002\u0001\u0005\n\t=qa\u0002B\u000b]!\u0005!q\u0003\u0004\u0007[9B\tA!\u0007\t\r9\fC\u0011\u0001B\u000e\u0011%\u0011i\"\tb\u0001\n\u0003\u0011y\u0002\u0003\u0005\u0003,\u0005\u0002\u000b\u0011\u0002B\u0011\u0011%\u0011i#\tb\u0001\n\u0003\ti\u0001C\u0004\u00030\u0005\u0002\u000b\u0011B*\t\u000f\tE\u0012\u0005\"\u0001\u00034!9!\u0011H\u0011\u0005\u0002\tm\u0002b\u0002B!C\u0011\u0005!1\t\u0005\b\u0005#\nC\u0011\u0001B*\u0011\u001d\u0011I&\tC\u0001\u00057BqA!\u0019\"\t\u0003\u0011\u0019G\u0001\rD_6\u0004\u0018m\u0019;jE2,g)\u001b7f'R\u0014X-Y7M_\u001eT!a\f\u0019\u0002\u0013M$(/Z1nS:<'BA\u00193\u0003%)\u00070Z2vi&|gN\u0003\u00024i\u0005\u00191/\u001d7\u000b\u0005U2\u0014!B:qCJ\\'BA\u001c9\u0003\u0019\t\u0007/Y2iK*\t\u0011(A\u0002pe\u001e\u001c\u0001!\u0006\u0002=\u0013N\u0011\u0001!\u0010\t\u0004}}\nU\"\u0001\u0018\n\u0005\u0001s#a\u0004%E\rNkU\r^1eCR\fGj\\4\u0011\u0007\t+u)D\u0001D\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0005\u0015\t%O]1z!\tA\u0015\n\u0004\u0001\u0005\u000b)\u0003!\u0019A&\u0003\u0003Q\u000b\"\u0001T(\u0011\u0005\tk\u0015B\u0001(D\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0011)\n\u0005E\u001b%AB!osJ+g-\u0001\nnKR\fG-\u0019;b\u0019><g+\u001a:tS>t\u0007C\u0001\"U\u0013\t)6IA\u0002J]R\fAb\u001d9be.\u001cVm]:j_:\u0004\"\u0001W-\u000e\u0003IJ!A\u0017\u001a\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\tA\fG\u000f\u001b\t\u0003;\u0012t!A\u00182\u0011\u0005}\u001bU\"\u00011\u000b\u0005\u0005T\u0014A\u0002\u001fs_>$h(\u0003\u0002d\u0007\u00061\u0001K]3eK\u001aL!!\u001a4\u0003\rM#(/\u001b8h\u0015\t\u00197)\u0001\u0006fm&$WM\\2fIE\u00022!\u001b7H\u001b\u0005Q'BA6D\u0003\u001d\u0011XM\u001a7fGRL!!\u001c6\u0003\u0011\rc\u0017m]:UC\u001e\fa\u0001P5oSRtD\u0003\u00029tiV$\"!\u001d:\u0011\u0007y\u0002q\tC\u0003h\u000b\u0001\u000f\u0001\u000eC\u0003S\u000b\u0001\u00071\u000bC\u0003W\u000b\u0001\u0007q\u000bC\u0003\\\u000b\u0001\u0007A,A\u0004g_Jl\u0017\r^:\u0016\u0003a\u0004\"!\u001f?\u000e\u0003iT!a\u001f\u001d\u0002\r)\u001cxN\u001c\u001bt\u0013\ti(PA\u0004G_Jl\u0017\r^:\u0002\u0011\u0019|'/\\1ug\u0002\n\u0001\"\\1oS\u001a,7\u000f^\u000b\u0003\u0003\u0007\u0001B![A\u0003\u000f&\u0019\u0011q\u00016\u0003\u00115\u000bg.\u001b4fgR\f\u0011\"\\1oS\u001a,7\u000f\u001e\u0011\u0002%5LgNQ1uG\",7\u000fV8SKR\f\u0017N\\\u000b\u0002'\u0006\u0019R.\u001b8CCR\u001c\u0007.Z:U_J+G/Y5oA\u0005\u0011b-\u001b7f\u00072,\u0017M\\;q\t\u0016d\u0017-_'t+\t\t)\u0002E\u0002C\u0003/I1!!\u0007D\u0005\u0011auN\\4\u0002)%\u001cH)\u001a7fi&tw-\u0012=qSJ,G\rT8h+\t\ty\u0002E\u0002C\u0003CI1!a\tD\u0005\u001d\u0011un\u001c7fC:\fa\u0003Z3gCVdGoQ8na\u0006\u001cG/\u00138uKJ4\u0018\r\\\u0001\u0010G>l\u0007/Y2u\u0013:$XM\u001d<bY\u0006a1\u000f[8vY\u0012\u0014V\r^1j]R1\u0011qDA\u0017\u0003cAa!a\f\u0011\u0001\u00049\u0015a\u00017pO\"9\u00111\u0007\tA\u0002\u0005U\u0011aC2veJ,g\u000e\u001e+j[\u0016\fQBY1uG\"LE\rV8QCRDG\u0003BA\u001d\u0003\u0013\u0002B!a\u000f\u0002F5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%\u0001\u0002gg*\u0019\u00111\t\u001c\u0002\r!\fGm\\8q\u0013\u0011\t9%!\u0010\u0003\tA\u000bG\u000f\u001b\u0005\b\u0003\u0017\n\u0002\u0019AA\u000b\u0003\u001d\u0011\u0017\r^2i\u0013\u0012\fQ\u0002]1uQR{')\u0019;dQ&#G\u0003BA\u000b\u0003#Baa\u0017\nA\u0002\u0005e\u0012aC5t\u0005\u0006$8\r\u001b$jY\u0016$B!a\b\u0002X!11l\u0005a\u0001\u0003s\tab]3sS\u0006d\u0017N_3F]R\u0014\u0018\u0010\u0006\u0004\u0002^\u0005\r\u0014q\r\t\u0004\u0005\u0006}\u0013bAA1\u0007\n!QK\\5u\u0011\u0019\t)\u0007\u0006a\u0001\u000f\u0006)QM\u001c;ss\"9\u0011\u0011\u000e\u000bA\u0002\u0005-\u0014aA8viB!\u0011QNA<\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014AA5p\u0015\t\t)(\u0001\u0003kCZ\f\u0017\u0002BA=\u0003_\u0012AbT;uaV$8\u000b\u001e:fC6\f\u0001\u0003Z3tKJL\u0017\r\\5{K\u0016sGO]=\u0015\u0007\u001d\u000by\b\u0003\u0004\u0002\u0002V\u0001\r\u0001X\u0001\u0005Y&tW-A\u0005tKJL\u0017\r\\5{KR1\u0011QLAD\u0003\u0017Ca!!#\u0017\u0001\u0004\t\u0015a\u00027pO\u0012\u000bG/\u0019\u0005\b\u0003S2\u0002\u0019AA6\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0007\u0005\u000b\t\nC\u0004\u0002\u0014^\u0001\r!!&\u0002\u0005%t\u0007\u0003BA7\u0003/KA!!'\u0002p\tY\u0011J\u001c9viN#(/Z1n\u0003\r\tG\r\u001a\u000b\u0007\u0003?\ty*!)\t\u000f\u0005-\u0003\u00041\u0001\u0002\u0016!1\u00111\u0015\rA\u0002\u0005\u000bA\u0001\\8hg\u0006)\u0001/\u001e:hKR!\u0011QLAU\u0011\u001d\tY+\u0007a\u0001\u0003+\t\u0001\u0003\u001e5sKNDw\u000e\u001c3CCR\u001c\u0007.\u00133\u0002\u001d\u0019|'/Z1dQ&s')\u0019;dQR!\u0011\u0011WA_)\u0011\ti&a-\t\u000f\u0005U&\u00041\u0001\u00028\u0006\u0011aM\u001c\t\u0007\u0005\u0006ev)!\u0018\n\u0007\u0005m6IA\u0005Gk:\u001cG/[8oc!9\u00111\n\u000eA\u0002\u0005U\u0011!\u00044jYR,'/\u00138CCR\u001c\u0007\u000e\u0006\u0003\u0002D\u0006EG\u0003BAc\u0003\u0017\u0004BAQAd\u0003&\u0019\u0011\u0011Z\"\u0003\r=\u0003H/[8o\u0011\u001d\tim\u0007a\u0001\u0003\u001f\f\u0011\u0002\u001d:fI&\u001c\u0017\r^3\u0011\r\t\u000bIlRA\u0010\u0011\u001d\tYe\u0007a\u0001\u0003+\ta\"\u00199qYf4e.\u00138CCR\u001c\u0007.\u0006\u0003\u0002X\u0006uG\u0003BAm\u0003\u007f$B!a7\u0002jB\u0019\u0001*!8\u0005\u000f\u0005}GD1\u0001\u0002b\n\u0019!+\u0012+\u0012\u00071\u000b\u0019\u000fE\u0002C\u0003KL1!a:D\u0005\r\te.\u001f\u0005\b\u0003kc\u0002\u0019AAv!\u001d\u0011\u0015\u0011XAw\u00037\u0004R!a<\u0002z\u001esA!!=\u0002v:\u0019q,a=\n\u0003\u0011K1!a>D\u0003\u001d\u0001\u0018mY6bO\u0016LA!a?\u0002~\nA\u0011\n^3sCR|'OC\u0002\u0002x\u000eCq!a\u0013\u001d\u0001\u0004\t)\"A\u0004d_6\u0004\u0018m\u0019;\u0015\r\u0005}!Q\u0001B\u0004\u0011\u001d\tY%\ba\u0001\u0003+Aa!a)\u001e\u0001\u0004\t\u0015\u0001C1mY\u001aKG.Z:\u0015\u0003\u0005\u000b\u0001\u0003Z3mKR,W\t\u001f9je\u0016$Gj\\4\u0015\t\u0005u#\u0011\u0003\u0005\b\u0005'y\u0002\u0019AA\u000b\u00039\u0019WO\u001d:f]R\u0014\u0015\r^2i\u0013\u0012\f\u0001dQ8na\u0006\u001cG/\u001b2mK\u001aKG.Z*ue\u0016\fW\u000eT8h!\tq\u0014e\u0005\u0002\"\u001fR\u0011!qC\u0001\u0014\u0007>k\u0005+Q\"U?\u001aKE*R0T+\u001a3\u0015\nW\u000b\u0003\u0005C\u0001BAa\t\u0003*5\u0011!Q\u0005\u0006\u0005\u0005O\t\u0019(\u0001\u0003mC:<\u0017bA3\u0003&\u0005!2iT'Q\u0003\u000e#vLR%M\u000b~\u001bVK\u0012$J1\u0002\n\u0011eQ(N!\u0006\u001bEk\u0018'B)\u0016s5)W0X\u0003Jsu\f\u0016%S\u000bNCu\n\u0014#`\u001bN\u000b!eQ(N!\u0006\u001bEk\u0018'B)\u0016s5)W0X\u0003Jsu\f\u0016%S\u000bNCu\n\u0014#`\u001bN\u0003\u0013AF4fi\n\u000bGo\u00195JI\u001a\u0013x.\u001c$jY\u0016t\u0015-\\3\u0015\t\u0005U!Q\u0007\u0005\u0007\u0005o9\u0003\u0019\u0001/\u0002\u0011\u0019LG.\u001a(b[\u0016\f\u0011#[:D_6\u0004\u0018m\u0019;j_:\u0014\u0015\r^2i)\u0019\tyB!\u0010\u0003@!9\u00111\n\u0015A\u0002\u0005U\u0001BBA\u0014Q\u0001\u00071+\u0001\u0013hKR4\u0016\r\\5e\u0005\u0006$8\r[3t\u0005\u00164wN]3D_6\u0004\u0018m\u0019;j_:\u0014\u0015\r^2i)\u0019\u0011)Ea\u0013\u0003PA1\u0011q\u001eB$\u0003+IAA!\u0013\u0002~\n\u00191+Z9\t\u000f\t5\u0013\u00061\u0001\u0002\u0016\u0005\t2m\\7qC\u000e$\u0018n\u001c8CCR\u001c\u0007.\u00133\t\r\u0005\u001d\u0012\u00061\u0001T\u0003I9W\r^!mYZ\u000bG.\u001b3CCR\u001c\u0007.Z:\u0015\r\t\u0015#Q\u000bB,\u0011\u001d\tYE\u000ba\u0001\u0003+Aq!a\n+\u0001\u0004\t)\"A\u000boKb$8i\\7qC\u000e$\u0018n\u001c8CCR\u001c\u0007.\u00133\u0015\r\u0005U!Q\fB0\u0011\u001d\tYe\u000ba\u0001\u0003+Aq!a\n,\u0001\u0004\t)\"A\u000beKJLg/Z\"p[B\f7\r^%oi\u0016\u0014h/\u00197\u0015\u000bM\u0013)G!\u001b\t\r\t\u001dD\u00061\u0001T\u0003=!WMZ1vYRLe\u000e^3sm\u0006d\u0007B\u0002B6Y\u0001\u00071+\u0001\u000bmCR,7\u000f^\"p[B\f7\r\u001e\"bi\u000eD\u0017\n\u001a")
public abstract class CompactibleFileStreamLog<T>
extends HDFSMetadataLog<T[]> {
    private int compactInterval;
    private final int metadataLogVersion;
    private final Formats formats;
    private final Manifest<T> manifest;
    private final int minBatchesToRetain;
    private volatile boolean bitmap$0;

    public static int deriveCompactInterval(int defaultInterval, int latestCompactBatchId) {
        return CompactibleFileStreamLog$.MODULE$.deriveCompactInterval(defaultInterval, latestCompactBatchId);
    }

    public static long nextCompactionBatchId(long batchId, long compactInterval) {
        return CompactibleFileStreamLog$.MODULE$.nextCompactionBatchId(batchId, compactInterval);
    }

    public static Seq<Object> getAllValidBatches(long batchId, long compactInterval) {
        return CompactibleFileStreamLog$.MODULE$.getAllValidBatches(batchId, compactInterval);
    }

    public static Seq<Object> getValidBatchesBeforeCompactionBatch(long compactionBatchId, int compactInterval) {
        return CompactibleFileStreamLog$.MODULE$.getValidBatchesBeforeCompactionBatch(compactionBatchId, compactInterval);
    }

    public static boolean isCompactionBatch(long batchId, int compactInterval) {
        return CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, compactInterval);
    }

    public static long getBatchIdFromFileName(String fileName) {
        return CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(fileName);
    }

    public static int COMPACT_LATENCY_WARN_THRESHOLD_MS() {
        return CompactibleFileStreamLog$.MODULE$.COMPACT_LATENCY_WARN_THRESHOLD_MS();
    }

    public static String COMPACT_FILE_SUFFIX() {
        return CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX();
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public int minBatchesToRetain() {
        return this.minBatchesToRetain;
    }

    public abstract long fileCleanupDelayMs();

    public abstract boolean isDeletingExpiredLog();

    public abstract int defaultCompactInterval();

    private int compactInterval$lzycompute() {
        CompactibleFileStreamLog compactibleFileStreamLog = this;
        synchronized (compactibleFileStreamLog) {
            if (!this.bitmap$0) {
                long[] compactibleBatchIds = (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CompactibleFileStreamLog.$anonfun$compactInterval$1(f)))), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (ClassTag)ClassTag$.MODULE$.Long())), Ordering.Long$.MODULE$.reverse());
                IntRef interval = IntRef.create((int)this.defaultCompactInterval());
                if (compactibleBatchIds.length >= 2) {
                    long latestCompactBatchId = compactibleBatchIds[0];
                    long previousCompactBatchId = compactibleBatchIds[1];
                    interval.elem = (int)(latestCompactBatchId - previousCompactBatchId);
                } else if (compactibleBatchIds.length == 1) {
                    interval.elem = CompactibleFileStreamLog$.MODULE$.deriveCompactInterval(this.defaultCompactInterval(), (int)compactibleBatchIds[0]);
                }
                Predef$.MODULE$.assert(interval.elem > 0, (Function0 & Serializable)() -> "intervalValue = " + interval$1.elem + " not positive value.");
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Set the compact interval to ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.COMPACT_INTERVAL$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)interval$1.elem))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[defaultCompactInterval: "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "]"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DEFAULT_COMPACT_INTERVAL$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)this.defaultCompactInterval()))})))));
                this.compactInterval = interval.elem;
                this.bitmap$0 = true;
            }
        }
        return this.compactInterval;
    }

    public final int compactInterval() {
        if (!this.bitmap$0) {
            return this.compactInterval$lzycompute();
        }
        return this.compactInterval;
    }

    public boolean shouldRetain(T log, long currentTime) {
        return true;
    }

    @Override
    public Path batchIdToPath(long batchId) {
        if (CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, this.compactInterval())) {
            return new Path(this.metadataPath(), batchId + CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX());
        }
        return new Path(this.metadataPath(), Long.toString(batchId));
    }

    @Override
    public long pathToBatchId(Path path) {
        return CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
    }

    @Override
    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    private void serializeEntry(T entry, OutputStream out) {
        out.write(Serialization$.MODULE$.write(entry, this.formats()).getBytes(StandardCharsets.UTF_8));
    }

    private T deserializeEntry(String line) {
        return (T)Serialization$.MODULE$.read(line, this.formats(), this.manifest());
    }

    @Override
    public void serialize(T[] logData, OutputStream out) {
        out.write(("v" + this.metadataLogVersion).getBytes(StandardCharsets.UTF_8));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])logData), (Function1 & Serializable)data -> {
            CompactibleFileStreamLog.$anonfun$serialize$1(this, out, data);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public T[] deserialize(InputStream in) {
        Iterator lines = Source$.MODULE$.fromInputStream(in, StandardCharsets.UTF_8.name()).getLines();
        if (!lines.hasNext()) {
            throw new IllegalStateException("Incomplete log file");
        }
        this.validateVersion((String)lines.next(), this.metadataLogVersion);
        return (Object[])lines.map((Function1 & Serializable)line -> this.deserializeEntry((String)line)).toArray(this.manifest());
    }

    @Override
    public boolean add(long batchId, T[] logs) {
        boolean batchAdded;
        block0: {
            boolean bl = batchAdded = CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, this.compactInterval()) ? this.compact(batchId, logs) : super.add(batchId, logs);
            if (!batchAdded || !this.isDeletingExpiredLog()) break block0;
            this.deleteExpiredLog(batchId);
        }
        return batchAdded;
    }

    @Override
    public void purge(long thresholdBatchId) {
        throw QueryExecutionErrors$.MODULE$.cannotPurgeAsBreakInternalStateError();
    }

    public void foreachInBatch(long batchId, Function1<T, BoxedUnit> fn) {
        this.applyFnInBatch(batchId, (Function1 & Serializable)x$1 -> {
            x$1.foreach(fn);
            return BoxedUnit.UNIT;
        });
    }

    public Option<T[]> filterInBatch(long batchId, Function1<T, Object> predicate) {
        Some some;
        try {
            some = new Some(this.applyFnInBatch(batchId, (Function1 & Serializable)x$2 -> (Object[])x$2.filter(predicate).toArray(this.manifest())));
        }
        catch (FileNotFoundException fileNotFoundException) {
            some = None$.MODULE$;
        }
        return some;
    }

    private <RET> RET applyFnInBatch(long batchId, Function1<Iterator<T>, RET> fn) {
        return this.applyFnToBatchByStream(batchId, this.applyFnToBatchByStream$default$2(), (Function1 & Serializable)input -> {
            Iterator lines = Source$.MODULE$.fromInputStream(input, StandardCharsets.UTF_8.name()).getLines();
            if (!lines.hasNext()) {
                throw new IllegalStateException("Incomplete log file");
            }
            this.validateVersion((String)lines.next(), $this.metadataLogVersion);
            return fn.apply((Object)lines.map((Function1 & Serializable)line -> this.deserializeEntry((String)line)));
        });
    }

    private boolean compact(long batchId, T[] logs) {
        long curTime = System.currentTimeMillis();
        Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0)(JFunction0.mcZ.sp & Serializable)() -> this.addNewBatchByStream(batchId, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable)output -> {
            CompactibleFileStreamLog.$anonfun$compact$2(this, batchId, logs, curTime, output);
            return BoxedUnit.UNIT;
        }));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean writeSucceed = tuple2._1$mcZ$sp();
        long elapsedMs = tuple2._2$mcJ$sp();
        Tuple2.mcZJ.sp sp2 = new Tuple2.mcZJ.sp(writeSucceed, elapsedMs);
        boolean writeSucceed2 = sp2._1$mcZ$sp();
        long elapsedMs2 = sp2._2$mcJ$sp();
        if (elapsedMs2 >= (long)CompactibleFileStreamLog$.MODULE$.COMPACT_LATENCY_WARN_THRESHOLD_MS()) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Compacting took ", " ms for "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.ELAPSED_TIME$.MODULE$, (Object)BoxesRunTime.boxToLong((long)elapsedMs2))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"compact batch ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BATCH_ID$.MODULE$, (Object)BoxesRunTime.boxToLong((long)batchId))})))));
        } else {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Compacting took " + elapsedMs2 + " ms for compact batch " + batchId);
        }
        return writeSucceed2;
    }

    public T[] allFiles() {
        long curTime = System.currentTimeMillis();
        LongRef latestId = LongRef.create((long)BoxesRunTime.unboxToLong((Object)this.getLatestBatchId().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
        while (latestId.elem >= 0L) {
            try {
                Seq logs = (Seq)CompactibleFileStreamLog$.MODULE$.getAllValidBatches(latestId.elem, this.compactInterval()).flatMap((Function1 & Serializable)id -> Predef$.MODULE$.wrapRefArray((Object[])this.filterInBatch(BoxesRunTime.unboxToLong((Object)id), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)$this.shouldRetain(x$4, curTime$2))).getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalStateException($this.batchIdToPath(id) + " doesn't exist (latestId: " + latestId$1.elem + ", compactInterval: " + $this.compactInterval() + ")");
                })));
                return (Object[])logs.toArray(this.manifest());
            }
            catch (IOException e) {
                long expectedMinLatestId = CompactibleFileStreamLog$.MODULE$.nextCompactionBatchId(latestId.elem, this.compactInterval());
                latestId.elem = BoxesRunTime.unboxToLong((Object)super.getLatestBatchId().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
                if (latestId.elem >= expectedMinLatestId) continue;
                throw e;
            }
        }
        return (Object[])Array$.MODULE$.empty(this.manifest());
    }

    private void deleteExpiredLog(long currentBatchId) {
        if ((long)this.compactInterval() <= currentBatchId + 1L - (long)this.minBatchesToRetain()) {
            long minBatchId = currentBatchId + 1L - (long)this.minBatchesToRetain();
            long minCompactionBatchId = minBatchId - minBatchId % (long)this.compactInterval() - 1L;
            Predef$.MODULE$.assert(CompactibleFileStreamLog$.MODULE$.isCompactionBatch(minCompactionBatchId, this.compactInterval()), (Function0 & Serializable)() -> minCompactionBatchId + " is not a compaction batch");
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Current compact batch id = ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CURRENT_BATCH_ID$.MODULE$, (Object)BoxesRunTime.boxToLong((long)currentBatchId))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"min compaction batch id to delete = "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MIN_COMPACTION_BATCH_ID$.MODULE$, (Object)BoxesRunTime.boxToLong((long)minCompactionBatchId))})))));
            long expiredTime = System.currentTimeMillis() - this.fileCleanupDelayMs();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), path -> {
                boolean bl;
                block3: {
                    try {
                        long batchId = CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
                        if (batchId < minCompactionBatchId) {
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                }
                return bl;
            })), (Function1 & Serializable)f -> {
                CompactibleFileStreamLog.$anonfun$deleteExpiredLog$4(this, expiredTime, f);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$compactInterval$1(FileStatus f) {
        return f.getPath().toString().endsWith(CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX());
    }

    public static final /* synthetic */ void $anonfun$serialize$1(CompactibleFileStreamLog $this, OutputStream out$1, Object data) {
        out$1.write(10);
        $this.serializeEntry(data, out$1);
    }

    private final void writeEntry$1(Object entry, OutputStream output, long curTime$1) {
        if (this.shouldRetain(entry, curTime$1)) {
            output.write(10);
            this.serializeEntry(entry, output);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$compact$2(CompactibleFileStreamLog $this, long batchId$1, Object[] logs$1, long curTime$1, OutputStream output) {
        output.write(("v" + $this.metadataLogVersion).getBytes(StandardCharsets.UTF_8));
        Seq<Object> validBatches = CompactibleFileStreamLog$.MODULE$.getValidBatchesBeforeCompactionBatch(batchId$1, $this.compactInterval());
        validBatches.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)id -> $this.foreachInBatch(id, (Function1 & Serializable)entry -> {
            $this.writeEntry$1(entry, output, curTime$1);
            return BoxedUnit.UNIT;
        }));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(logs$1), (Function1 & Serializable)entry -> {
            $this.writeEntry$1(entry, output, curTime$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$deleteExpiredLog$4(CompactibleFileStreamLog $this, long expiredTime$1, FileStatus f) {
        if (f.getModificationTime() <= expiredTime$1) {
            $this.fileManager().delete(f.getPath());
            return;
        }
    }

    public CompactibleFileStreamLog(int metadataLogVersion, SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.metadataLogVersion = metadataLogVersion;
        super(sparkSession, path, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$1.runtimeClass())));
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        this.minBatchesToRetain = sparkSession.sessionState().conf().minBatchesToRetain();
    }
}

