/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.StreamingSymmetricHashJoinHelper;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker$;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.SymmetricHashJoinStateManager$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class StreamStreamJoinStateHelper$ {
    public static final StreamStreamJoinStateHelper$ MODULE$ = new StreamStreamJoinStateHelper$();

    public StructType readSchema(SparkSession session, String stateCheckpointLocation, int operatorId, StreamingSymmetricHashJoinHelper.JoinSide side, boolean excludeAuxColumns) {
        Tuple2<StructType, StructType> tuple2 = this.readKeyValueSchema(session, stateCheckpointLocation, operatorId, side, excludeAuxColumns);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        StructType keySchema = (StructType)tuple2._1();
        StructType valueSchema = (StructType)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)keySchema, (Object)valueSchema);
        StructType keySchema2 = (StructType)tuple22._1();
        StructType valueSchema2 = (StructType)tuple22._2();
        return new StructType().add("key", (DataType)keySchema2).add("value", (DataType)valueSchema2);
    }

    public boolean readSchema$default$5() {
        return true;
    }

    public Tuple2<StructType, StructType> readKeyValueSchema(SparkSession session, String stateCheckpointLocation, int operatorId, StreamingSymmetricHashJoinHelper.JoinSide side, boolean excludeAuxColumns) {
        List storeNames = SymmetricHashJoinStateManager$.MODULE$.allStateStoreNames((Seq<StreamingSymmetricHashJoinHelper.JoinSide>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamingSymmetricHashJoinHelper.JoinSide[]{side})).toList();
        int partitionId = StateStore$.MODULE$.PARTITION_ID_TO_CHECK_SCHEMA();
        StateStoreId storeIdForKeyToNumValues = new StateStoreId(stateCheckpointLocation, operatorId, partitionId, (String)storeNames.apply(0));
        StateStoreProviderId providerIdForKeyToNumValues = new StateStoreProviderId(storeIdForKeyToNumValues, UUID.randomUUID());
        StateStoreId storeIdForKeyWithIndexToValue = new StateStoreId(stateCheckpointLocation, operatorId, partitionId, (String)storeNames.apply(1));
        StateStoreProviderId providerIdForKeyWithIndexToValue = new StateStoreProviderId(storeIdForKeyWithIndexToValue, UUID.randomUUID());
        Configuration newHadoopConf = session.sessionState().newHadoopConf();
        StateSchemaCompatibilityChecker manager = new StateSchemaCompatibilityChecker(providerIdForKeyToNumValues, newHadoopConf, StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$3(), StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$4());
        StructType keySchema = ((StateStoreColFamilySchema)manager.readSchemaFile().head()).keySchema();
        StateSchemaCompatibilityChecker manager2 = new StateSchemaCompatibilityChecker(providerIdForKeyWithIndexToValue, newHadoopConf, StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$3(), StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$4());
        StructType valueSchema = ((StateStoreColFamilySchema)manager2.readSchemaFile().head()).valueSchema();
        StructField maybeMatchedColumn = (StructField)valueSchema.last();
        if (excludeAuxColumns) {
            String string = maybeMatchedColumn.name();
            String string2 = "matched";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                DataType dataType = maybeMatchedColumn.dataType();
                BooleanType$ booleanType$ = BooleanType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null)) {
                    return new Tuple2((Object)keySchema, (Object)StructType$.MODULE$.apply((Seq)valueSchema.dropRight(1)));
                }
            }
        }
        return new Tuple2((Object)keySchema, (Object)valueSchema);
    }

    public boolean readKeyValueSchema$default$5() {
        return true;
    }

    private StreamStreamJoinStateHelper$() {
    }
}

