/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.QualifiedTableName;
import org.apache.spark.sql.catalyst.QualifiedTableName$;
import org.apache.spark.sql.catalyst.analysis.AnalysisContext$;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.catalog.UnresolvedCatalogRelation;
import org.apache.spark.sql.catalyst.catalog.UnresolvedCatalogRelation$;
import org.apache.spark.sql.catalyst.plans.logical.AppendData;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.streaming.StreamingRelationV2;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.classic.SparkSession$;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelation$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005e3Aa\u0002\u0005\u0001+!Aa\u0005\u0001B\u0001B\u0003%q\u0005C\u0003.\u0001\u0011\u0005a\u0006C\u00033\u0001\u0011%1\u0007C\u0003E\u0001\u0011%Q\tC\u0003O\u0001\u0011\u0005s\nC\u0003S\u0001\u0011\u00051KA\nGS:$G)\u0019;b'>,(oY3UC\ndWM\u0003\u0002\n\u0015\u0005YA-\u0019;bg>,(oY3t\u0015\tYA\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QBD\u0001\u0004gFd'BA\b\u0011\u0003\u0015\u0019\b/\u0019:l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0006\t\u0004/qqR\"\u0001\r\u000b\u0005eQ\u0012!\u0002:vY\u0016\u001c(BA\u000e\r\u0003!\u0019\u0017\r^1msN$\u0018BA\u000f\u0019\u0005\u0011\u0011V\u000f\\3\u0011\u0005}!S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003Gi\tQ\u0001\u001d7b]NL!!\n\u0011\u0003\u00171{w-[2bYBc\u0017M\\\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003Q-j\u0011!\u000b\u0006\u0003U1\tqa\u00197bgNL7-\u0003\u0002-S\ta1\u000b]1sWN+7o]5p]\u00061A(\u001b8jiz\"\"aL\u0019\u0011\u0005A\u0002Q\"\u0001\u0005\t\u000b\u0019\u0012\u0001\u0019A\u0014\u0002'I,\u0017\r\u001a#bi\u0006\u001cv.\u001e:dKR\u000b'\r\\3\u0015\u0007y!D\bC\u00036\u0007\u0001\u0007a'A\u0003uC\ndW\r\u0005\u00028u5\t\u0001H\u0003\u0002:5\u000591-\u0019;bY><\u0017BA\u001e9\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u0011\u0015i4\u00011\u0001?\u00031)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8t!\ty$)D\u0001A\u0015\t\tE\"\u0001\u0003vi&d\u0017BA\"A\u0005a\u0019\u0015m]3J]N,gn]5uSZ,7\u000b\u001e:j]\u001el\u0015\r]\u0001\u0015O\u0016$8\u000b\u001e:fC6Lgn\u001a*fY\u0006$\u0018n\u001c8\u0015\u0007\u0019cU\n\u0005\u0002H\u00156\t\u0001J\u0003\u0002J\u0015\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0003\u0017\"\u0013\u0011c\u0015;sK\u0006l\u0017N\\4SK2\fG/[8o\u0011\u0015)D\u00011\u00017\u0011\u0015iD\u00011\u0001?\u0003\u0015\t\u0007\u000f\u001d7z)\tq\u0002\u000bC\u0003R\u000b\u0001\u0007a$\u0001\u0003qY\u0006t\u0017\u0001\t:fg>dg/Z+oe\u0016\u001cx\u000e\u001c<fI\u000e\u000bG/\u00197pOJ+G.\u0019;j_:$\"A\b+\t\u000bU3\u0001\u0019\u0001,\u00023Ut'/Z:pYZ,GmQ1uC2|wMU3mCRLwN\u001c\t\u0003o]K!\u0001\u0017\u001d\u00033Us'/Z:pYZ,GmQ1uC2|wMU3mCRLwN\u001c")
public class FindDataSourceTable
extends Rule<LogicalPlan> {
    private final SparkSession sparkSession;

    public LogicalPlan org$apache$spark$sql$execution$datasources$FindDataSourceTable$$readDataSourceTable(CatalogTable table, CaseInsensitiveStringMap extraOptions) {
        LogicalRelation logicalRelation;
        BaseRelation fsRelation;
        QualifiedTableName qualifiedTableName = QualifiedTableName$.MODULE$.apply((String)table.identifier().catalog().get(), table.database(), table.identifier().table());
        SessionCatalog catalog = this.sparkSession.sessionState().catalog();
        Map<String, String> dsOptions = DataSourceUtils$.MODULE$.generateDatasourceOptions(extraOptions, table);
        boolean readFileSourceTableCacheIgnoreOptions = BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.READ_FILE_SOURCE_TABLE_CACHE_IGNORE_OPTIONS()));
        LogicalPlan logicalPlan2 = catalog.getCachedTable(qualifiedTableName);
        if (logicalPlan2 == null) {
            SparkSession x$1 = this.sparkSession;
            None$ x$2 = table.schema().isEmpty() ? None$.MODULE$ : new Some((Object)table.schema());
            Seq x$3 = table.partitionColumnNames();
            Option x$4 = table.bucketSpec();
            String x$5 = (String)table.provider().get();
            Map<String, String> x$6 = dsOptions;
            Some x$7 = new Some((Object)table);
            Seq<String> x$8 = DataSource$.MODULE$.apply$default$3();
            DataSource dataSource = new DataSource(x$1, x$5, x$8, (Option<StructType>)x$2, (Seq<String>)x$3, (Option<BucketSpec>)x$4, x$6, (Option<CatalogTable>)x$7);
            LogicalRelation plan = LogicalRelation$.MODULE$.apply(dataSource.resolveRelation(false, dataSource.resolveRelation$default$2()), table);
            catalog.cacheTable(qualifiedTableName, (LogicalPlan)plan);
            return plan;
        }
        if (logicalPlan2 instanceof LogicalRelation && (fsRelation = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) instanceof HadoopFsRelation) {
            HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)fsRelation;
            if (!readFileSourceTableCacheIgnoreOptions) {
                CaseInsensitiveStringMap caseInsensitiveStringMap = new CaseInsensitiveStringMap(CollectionConverters$.MODULE$.MapHasAsJava(hadoopFsRelation.options()).asJava());
                CaseInsensitiveStringMap caseInsensitiveStringMap2 = new CaseInsensitiveStringMap(CollectionConverters$.MODULE$.MapHasAsJava(dsOptions).asJava());
                if (caseInsensitiveStringMap == null ? caseInsensitiveStringMap2 != null : !caseInsensitiveStringMap.equals(caseInsensitiveStringMap2)) {
                    Map<String, String> x$9 = dsOptions;
                    FileIndex x$10 = hadoopFsRelation.copy$default$1();
                    StructType x$11 = hadoopFsRelation.copy$default$2();
                    StructType x$12 = hadoopFsRelation.copy$default$3();
                    Option<BucketSpec> x$13 = hadoopFsRelation.copy$default$4();
                    FileFormat x$14 = hadoopFsRelation.copy$default$5();
                    SparkSession x$15 = this.sparkSession;
                    HadoopFsRelation newFsRelation = hadoopFsRelation.copy(x$10, x$11, x$12, x$13, x$14, x$9, x$15);
                    return logicalRelation.copy(newFsRelation, logicalRelation.copy$default$2(), logicalRelation.copy$default$3(), logicalRelation.copy$default$4(), logicalRelation.copy$default$5());
                }
            }
        }
        return logicalPlan2;
    }

    public StreamingRelation org$apache$spark$sql$execution$datasources$FindDataSourceTable$$getStreamingRelation(CatalogTable table, CaseInsensitiveStringMap extraOptions) {
        Map<String, String> dsOptions = DataSourceUtils$.MODULE$.generateDatasourceOptions(extraOptions, table);
        SparkSession x$1 = SparkSession$.MODULE$.active();
        String x$2 = (String)table.provider().get();
        Some x$3 = new Some((Object)table.schema());
        Map<String, String> x$4 = dsOptions;
        Some x$5 = new Some((Object)table);
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$3();
        Seq<String> x$7 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$8 = DataSource$.MODULE$.apply$default$6();
        DataSource dataSource = new DataSource(x$1, x$2, x$6, (Option<StructType>)x$3, x$7, x$8, x$4, (Option<CatalogTable>)x$5);
        return StreamingRelation$.MODULE$.apply(dataSource);
    }

    public LogicalPlan apply(LogicalPlan plan) {
        return plan.resolveOperators((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ FindDataSourceTable $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                V1Table v1Table;
                CatalogTable table;
                DataSourceV2Relation dataSourceV2Relation;
                Table table2;
                AppendData appendData;
                NamedRelation namedRelation;
                LogicalPlan logicalPlan2;
                boolean bl = false;
                InsertIntoStatement insertIntoStatement = null;
                A1 A1 = x1;
                if (A1 instanceof InsertIntoStatement) {
                    bl = true;
                    insertIntoStatement = (InsertIntoStatement)A1;
                    LogicalPlan logicalPlan3 = insertIntoStatement.table();
                    if (logicalPlan3 instanceof UnresolvedCatalogRelation) {
                        UnresolvedCatalogRelation unresolvedCatalogRelation = (UnresolvedCatalogRelation)logicalPlan3;
                        CatalogTable tableMeta = unresolvedCatalogRelation.tableMeta();
                        CaseInsensitiveStringMap options = unresolvedCatalogRelation.options();
                        boolean bl2 = unresolvedCatalogRelation.isStreaming();
                        if (!bl2 && DDLUtils$.MODULE$.isDatasourceTable(tableMeta)) {
                            return (B1)insertIntoStatement.copy(this.$outer.org$apache$spark$sql$execution$datasources$FindDataSourceTable$$readDataSourceTable(tableMeta, options), insertIntoStatement.copy$default$2(), insertIntoStatement.copy$default$3(), insertIntoStatement.copy$default$4(), insertIntoStatement.copy$default$5(), insertIntoStatement.copy$default$6(), insertIntoStatement.copy$default$7());
                        }
                    }
                }
                if (bl && (logicalPlan2 = insertIntoStatement.table()) instanceof UnresolvedCatalogRelation) {
                    UnresolvedCatalogRelation unresolvedCatalogRelation = (UnresolvedCatalogRelation)logicalPlan2;
                    CatalogTable tableMeta = unresolvedCatalogRelation.tableMeta();
                    boolean bl3 = unresolvedCatalogRelation.isStreaming();
                    if (!bl3) {
                        return (B1)insertIntoStatement.copy((LogicalPlan)DDLUtils$.MODULE$.readHiveTable(tableMeta), insertIntoStatement.copy$default$2(), insertIntoStatement.copy$default$3(), insertIntoStatement.copy$default$4(), insertIntoStatement.copy$default$5(), insertIntoStatement.copy$default$6(), insertIntoStatement.copy$default$7());
                    }
                }
                if (A1 instanceof AppendData && (namedRelation = (appendData = (AppendData)A1).table()) instanceof DataSourceV2Relation && (table2 = (dataSourceV2Relation = (DataSourceV2Relation)namedRelation).table()) instanceof V1Table && (table = (v1Table = (V1Table)table2).v1Table()) != null) {
                    CatalogTable catalogTable = table;
                    if (!appendData.isByName()) {
                        return (B1)new InsertIntoStatement((LogicalPlan)new UnresolvedCatalogRelation(catalogTable, UnresolvedCatalogRelation$.MODULE$.apply$default$2(), UnresolvedCatalogRelation$.MODULE$.apply$default$3()), ((IterableOnceOps)catalogTable.partitionColumnNames().map((Function1 & Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)None$.MODULE$))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Seq)package$.MODULE$.Seq().empty(), appendData.query(), false, appendData.isByName(), InsertIntoStatement$.MODULE$.apply$default$7());
                    }
                }
                if (A1 instanceof UnresolvedCatalogRelation) {
                    UnresolvedCatalogRelation unresolvedCatalogRelation = (UnresolvedCatalogRelation)A1;
                    LogicalPlan result = this.$outer.resolveUnresolvedCatalogRelation(unresolvedCatalogRelation);
                    AnalysisContext$.MODULE$.get().getSinglePassResolverBridgeState().map((Function1 & Serializable)bridgeState -> bridgeState.catalogRelationsWithResolvedMetadata().put(unresolvedCatalogRelation, result));
                    return (B1)result;
                }
                if (A1 instanceof StreamingRelationV2) {
                    Some some;
                    LogicalPlan logicalPlan4;
                    StreamingRelationV2 streamingRelationV2 = (StreamingRelationV2)A1;
                    Table table3 = streamingRelationV2.table();
                    CaseInsensitiveStringMap extraOptions = streamingRelationV2.extraOptions();
                    Option option = streamingRelationV2.v1Relation();
                    if (option instanceof Some && (logicalPlan4 = (LogicalPlan)(some = (Some)option).value()) instanceof UnresolvedCatalogRelation) {
                        UnresolvedCatalogRelation unresolvedCatalogRelation = (UnresolvedCatalogRelation)logicalPlan4;
                        CatalogTable tableMeta = unresolvedCatalogRelation.tableMeta();
                        boolean bl4 = unresolvedCatalogRelation.isStreaming();
                        if (bl4) {
                            StreamingRelation v1Relation = this.$outer.org$apache$spark$sql$execution$datasources$FindDataSourceTable$$getStreamingRelation(tableMeta, extraOptions);
                            if (table3 instanceof SupportsRead && DataSourceV2Implicits$.MODULE$.TableHelper(table3).supportsAny((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableCapability[]{TableCapability.MICRO_BATCH_READ, TableCapability.CONTINUOUS_READ}))) {
                                Some x$1 = new Some((Object)v1Relation);
                                Option x$2 = streamingRelationV2.copy$default$1();
                                String x$3 = streamingRelationV2.copy$default$2();
                                Table x$4 = streamingRelationV2.copy$default$3();
                                CaseInsensitiveStringMap x$5 = streamingRelationV2.copy$default$4();
                                Seq x$6 = streamingRelationV2.copy$default$5();
                                Option x$7 = streamingRelationV2.copy$default$6();
                                Option x$8 = streamingRelationV2.copy$default$7();
                                return (B1)streamingRelationV2.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, (Option)x$1);
                            }
                            return (B1)v1Relation;
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                UnresolvedCatalogRelation unresolvedCatalogRelation;
                boolean bl;
                Some some;
                LogicalPlan logicalPlan2;
                StreamingRelationV2 streamingRelationV2;
                Option option;
                V1Table v1Table;
                CatalogTable table;
                DataSourceV2Relation dataSourceV2Relation;
                Table table2;
                AppendData appendData;
                NamedRelation namedRelation;
                UnresolvedCatalogRelation unresolvedCatalogRelation2;
                boolean bl2;
                LogicalPlan logicalPlan3;
                boolean bl3 = false;
                InsertIntoStatement insertIntoStatement = null;
                LogicalPlan logicalPlan4 = x1;
                if (logicalPlan4 instanceof InsertIntoStatement) {
                    bl3 = true;
                    insertIntoStatement = (InsertIntoStatement)logicalPlan4;
                    LogicalPlan logicalPlan5 = insertIntoStatement.table();
                    if (logicalPlan5 instanceof UnresolvedCatalogRelation) {
                        UnresolvedCatalogRelation unresolvedCatalogRelation3 = (UnresolvedCatalogRelation)logicalPlan5;
                        CatalogTable tableMeta = unresolvedCatalogRelation3.tableMeta();
                        boolean bl4 = unresolvedCatalogRelation3.isStreaming();
                        if (!bl4 && DDLUtils$.MODULE$.isDatasourceTable(tableMeta)) {
                            return true;
                        }
                    }
                }
                if (bl3 && (logicalPlan3 = insertIntoStatement.table()) instanceof UnresolvedCatalogRelation && !(bl2 = (unresolvedCatalogRelation2 = (UnresolvedCatalogRelation)logicalPlan3).isStreaming())) {
                    return true;
                }
                if (logicalPlan4 instanceof AppendData && (namedRelation = (appendData = (AppendData)logicalPlan4).table()) instanceof DataSourceV2Relation && (table2 = (dataSourceV2Relation = (DataSourceV2Relation)namedRelation).table()) instanceof V1Table && (table = (v1Table = (V1Table)table2).v1Table()) != null && !appendData.isByName()) {
                    return true;
                }
                if (logicalPlan4 instanceof UnresolvedCatalogRelation) {
                    return true;
                }
                return logicalPlan4 instanceof StreamingRelationV2 && (option = (streamingRelationV2 = (StreamingRelationV2)logicalPlan4).v1Relation()) instanceof Some && (logicalPlan2 = (LogicalPlan)(some = (Some)option).value()) instanceof UnresolvedCatalogRelation && true == (bl = (unresolvedCatalogRelation = (UnresolvedCatalogRelation)logicalPlan2).isStreaming());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$6(java.lang.String ), $anonfun$applyOrElse$7(org.apache.spark.sql.catalyst.catalog.UnresolvedCatalogRelation org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.catalyst.analysis.resolver.AnalyzerBridgeState )}, serializedLambda);
            }
        });
    }

    public LogicalPlan resolveUnresolvedCatalogRelation(UnresolvedCatalogRelation unresolvedCatalogRelation) {
        UnresolvedCatalogRelation unresolvedCatalogRelation2 = unresolvedCatalogRelation;
        if (unresolvedCatalogRelation2 != null) {
            CatalogTable tableMeta = unresolvedCatalogRelation2.tableMeta();
            CaseInsensitiveStringMap options = unresolvedCatalogRelation2.options();
            boolean bl = unresolvedCatalogRelation2.isStreaming();
            if (!bl && DDLUtils$.MODULE$.isDatasourceTable(tableMeta)) {
                return this.org$apache$spark$sql$execution$datasources$FindDataSourceTable$$readDataSourceTable(tableMeta, options);
            }
        }
        if (unresolvedCatalogRelation2 != null) {
            CatalogTable tableMeta = unresolvedCatalogRelation2.tableMeta();
            boolean bl = unresolvedCatalogRelation2.isStreaming();
            if (!bl) {
                return DDLUtils$.MODULE$.readHiveTable(tableMeta);
            }
        }
        if (unresolvedCatalogRelation2 != null) {
            CatalogTable tableMeta = unresolvedCatalogRelation2.tableMeta();
            CaseInsensitiveStringMap extraOptions = unresolvedCatalogRelation2.options();
            boolean bl = unresolvedCatalogRelation2.isStreaming();
            if (bl) {
                return this.org$apache$spark$sql$execution$datasources$FindDataSourceTable$$getStreamingRelation(tableMeta, extraOptions);
            }
        }
        throw new MatchError((Object)unresolvedCatalogRelation2);
    }

    public FindDataSourceTable(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
    }
}

