/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.ErrorMessageFormat$;
import org.apache.spark.JobArtifactSet$;
import org.apache.spark.JobArtifactState;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException$;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkThrowableHelper$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.classic.SparkSession$;
import org.apache.spark.sql.execution.DoNotCleanup$;
import org.apache.spark.sql.execution.ExplainMode;
import org.apache.spark.sql.execution.ExplainMode$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.RemoveShuffleFiles$;
import org.apache.spark.sql.execution.ShuffleCleanupMode;
import org.apache.spark.sql.execution.SkipMigration$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkPlanInfo;
import org.apache.spark.sql.execution.SparkPlanInfo$;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanExec;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.CallSite;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class SQLExecution$
implements Logging {
    public static final SQLExecution$ MODULE$ = new SQLExecution$();
    private static final String EXECUTION_ID_KEY;
    private static final String EXECUTION_ROOT_ID_KEY;
    private static final AtomicLong _nextExecutionId;
    private static final ConcurrentHashMap<Object, QueryExecution> executionIdToQueryExecution;
    private static final boolean testing;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        EXECUTION_ID_KEY = "spark.sql.execution.id";
        EXECUTION_ROOT_ID_KEY = "spark.sql.execution.root.id";
        _nextExecutionId = new AtomicLong(0L);
        executionIdToQueryExecution = new ConcurrentHashMap();
        testing = scala.sys.package$.MODULE$.props().contains(Tests$.MODULE$.IS_TESTING().key());
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String EXECUTION_ID_KEY() {
        return EXECUTION_ID_KEY;
    }

    public String EXECUTION_ROOT_ID_KEY() {
        return EXECUTION_ROOT_ID_KEY;
    }

    private AtomicLong _nextExecutionId() {
        return _nextExecutionId;
    }

    private long nextExecutionId() {
        return this._nextExecutionId().getAndIncrement();
    }

    public ConcurrentHashMap<Object, QueryExecution> executionIdToQueryExecution() {
        return executionIdToQueryExecution;
    }

    public QueryExecution getQueryExecution(long executionId) {
        return this.executionIdToQueryExecution().get(BoxesRunTime.boxToLong((long)executionId));
    }

    private boolean testing() {
        return testing;
    }

    public String executionIdJobTag(org.apache.spark.sql.classic.SparkSession session, long id) {
        return session.sessionJobTag() + "-execution-root-id-" + id;
    }

    public void checkSQLExecutionId(org.apache.spark.sql.classic.SparkSession sparkSession) {
        SparkContext sc = sparkSession.sparkContext();
        if (this.testing() && sc.getLocalProperty(this.EXECUTION_ID_KEY()) == null) {
            throw SparkException$.MODULE$.internalError("Execution ID should be set");
        }
    }

    private <T> T withNewExecutionId0(QueryExecution queryExecution, Option<String> name, Either<Throwable, Function0<T>> body2) {
        return (T)queryExecution.sparkSession().withActive((Function0 & Serializable)() -> {
            Object t;
            org.apache.spark.sql.classic.SparkSession sparkSession = queryExecution.sparkSession();
            SparkContext sc = sparkSession.sparkContext();
            String oldExecutionId = sc.getLocalProperty(MODULE$.EXECUTION_ID_KEY());
            long executionId = MODULE$.nextExecutionId();
            sc.setLocalProperty(MODULE$.EXECUTION_ID_KEY(), Long.toString(executionId));
            if (sc.getLocalProperty(MODULE$.EXECUTION_ROOT_ID_KEY()) == null) {
                sc.setLocalProperty(MODULE$.EXECUTION_ROOT_ID_KEY(), Long.toString(executionId));
                sc.addJobTag(MODULE$.executionIdJobTag(sparkSession, executionId));
            }
            long rootExecutionId = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(sc.getLocalProperty(MODULE$.EXECUTION_ROOT_ID_KEY())));
            MODULE$.executionIdToQueryExecution().put(BoxesRunTime.boxToLong((long)executionId), queryExecution);
            String originalInterruptOnCancel = sc.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_INTERRUPT_ON_CANCEL());
            if (originalInterruptOnCancel == null) {
                boolean interruptOnCancel = BoxesRunTime.unboxToBoolean((Object)sparkSession.sessionState().conf().getConf(SQLConf$.MODULE$.INTERRUPT_ON_CANCEL()));
                sc.setInterruptOnCancel(interruptOnCancel);
            }
            try {
                CallSite callSite = sc.getCallSite();
                int truncateLength = BoxesRunTime.unboxToInt((Object)sc.conf().get(StaticSQLConf$.MODULE$.SQL_EVENT_TRUNCATE_LENGTH()));
                String desc = (String)Option$.MODULE$.apply((Object)sc.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_DESCRIPTION())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SQLExecution$.$anonfun$withNewExecutionId0$2(truncateLength, x$1))).map((Function1 & Serializable)sqlStr -> {
                    String redactedStr = Utils$.MODULE$.redact(sparkSession.sessionState().conf().stringRedactionPattern(), sqlStr);
                    return redactedStr.substring(0, Math.min(truncateLength, redactedStr.length()));
                }).getOrElse((Function0 & Serializable)() -> callSite.shortForm());
                scala.collection.immutable.Map globalConfigs = Predef$.MODULE$.wrapRefArray((Object[])sparkSession.sharedState().conf().getAll()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                scala.collection.immutable.Map modifiedConfigs = (scala.collection.immutable.Map)sparkSession.sessionState().conf().getAllConfs().filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SQLExecution$.$anonfun$withNewExecutionId0$5(globalConfigs, x0$1)));
                scala.collection.immutable.Map redactedConfigs = sparkSession.sessionState().conf().redactOptions(modifiedConfigs);
                t = MODULE$.withSQLConfPropagated(sparkSession, (Function0 & Serializable)() -> sparkSession.artifactManager().withResources((Function0 & Serializable)() -> MODULE$.withSessionTagsApplied(sparkSession, (Function0 & Serializable)() -> {
                    Object object;
                    None$ ex = None$.MODULE$;
                    boolean isExecutedPlanAvailable = false;
                    long startTime = System.nanoTime();
                    SparkListenerSQLExecutionStart startEvent = new SparkListenerSQLExecutionStart(executionId, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)rootExecutionId)), desc, callSite.longForm(), "", SparkPlanInfo$.MODULE$.EMPTY(), System.currentTimeMillis(), (scala.collection.immutable.Map<String, String>)redactedConfigs, (Set<String>)sc.getJobTags(), (Option<String>)Option$.MODULE$.apply((Object)sc.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_GROUP_ID())));
                    try {
                        try {
                            SparkPlanInfo sparkPlanInfo;
                            String planDesc;
                            Function0 f;
                            Either either = body2;
                            if (either instanceof Left) {
                                Left left = (Left)either;
                                Throwable e = (Throwable)left.value();
                                sc.listenerBus().post((SparkListenerEvent)startEvent);
                                throw e;
                            }
                            if (either instanceof Right) {
                                Right right = (Right)either;
                                f = (Function0)right.value();
                                ExplainMode planDescriptionMode = ExplainMode$.MODULE$.fromString(sparkSession.sessionState().conf().uiExplainMode());
                                planDesc = queryExecution.explainString(planDescriptionMode);
                                try {
                                    sparkPlanInfo = SparkPlanInfo$.MODULE$.fromSparkPlan(queryExecution.executedPlan());
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable2;
                                    Throwable throwable3 = throwable;
                                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                                        MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Failed to generate SparkPlanInfo", throwable2);
                                        sparkPlanInfo = SparkPlanInfo$.MODULE$.EMPTY();
                                    }
                                    throw throwable;
                                }
                            } else {
                                throw new MatchError((Object)either);
                            }
                            SparkPlanInfo planInfo = sparkPlanInfo;
                            String x$1 = planDesc;
                            SparkPlanInfo x$2 = planInfo;
                            long x$3 = startEvent.copy$default$1();
                            Option<Object> x$4 = startEvent.copy$default$2();
                            String x$5 = startEvent.copy$default$3();
                            String x$6 = startEvent.copy$default$4();
                            long x$7 = startEvent.copy$default$7();
                            scala.collection.immutable.Map<String, String> x$8 = startEvent.copy$default$8();
                            Set<String> x$9 = startEvent.copy$default$9();
                            Option<String> x$10 = startEvent.copy$default$10();
                            sc.listenerBus().post((SparkListenerEvent)startEvent.copy(x$3, x$4, x$5, x$6, x$1, x$2, x$7, x$8, x$9, x$10));
                            isExecutedPlanAvailable = true;
                            object = f.apply();
                        }
                        catch (Throwable e) {
                            ex = new Some((Object)e);
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        long endTime = System.nanoTime();
                        Option errorMessage = ex.map((Function1 & Serializable)x0$2 -> {
                            Throwable throwable = x0$2;
                            if (throwable instanceof SparkThrowable) {
                                Throwable throwable2 = throwable;
                                return SparkThrowableHelper$.MODULE$.getMessage(throwable2, ErrorMessageFormat$.MODULE$.PRETTY());
                            }
                            return Utils$.MODULE$.exceptionString(throwable);
                        });
                        ShuffleCleanupMode shuffleCleanupMode = queryExecution.shuffleCleanupMode();
                        DoNotCleanup$ doNotCleanup$ = DoNotCleanup$.MODULE$;
                        if ((shuffleCleanupMode == null ? doNotCleanup$ != null : !shuffleCleanupMode.equals(doNotCleanup$)) && isExecutedPlanAvailable) {
                            Iterable iterable;
                            SparkPlan sparkPlan = queryExecution.executedPlan();
                            if (sparkPlan instanceof AdaptiveSparkPlanExec) {
                                AdaptiveSparkPlanExec adaptiveSparkPlanExec = (AdaptiveSparkPlanExec)sparkPlan;
                                iterable = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(adaptiveSparkPlanExec.context().shuffleIds()).asScala().keys();
                            } else {
                                iterable = (Iterable)package$.MODULE$.Iterable().empty();
                            }
                            Iterable shuffleIds = iterable;
                            shuffleIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)shuffleId -> {
                                ShuffleCleanupMode shuffleCleanupMode = queryExecution.shuffleCleanupMode();
                                if (RemoveShuffleFiles$.MODULE$.equals(shuffleCleanupMode)) {
                                    sc.shuffleDriverComponents().removeShuffle(shuffleId, Utils$.MODULE$.isTesting());
                                    return;
                                }
                                if (SkipMigration$.MODULE$.equals(shuffleCleanupMode)) {
                                    SparkEnv$.MODULE$.get().blockManager().migratableResolver().addShuffleToSkip(shuffleId);
                                    return;
                                }
                            });
                        }
                        SparkListenerSQLExecutionEnd event = new SparkListenerSQLExecutionEnd(executionId, System.currentTimeMillis(), (Option<String>)errorMessage.orElse((Function0 & Serializable)() -> new Some((Object)"")));
                        event.executionName_$eq(name);
                        event.duration_$eq(endTime - startTime);
                        event.qe_$eq(queryExecution);
                        event.executionFailure_$eq((Option<Throwable>)ex);
                        sc.listenerBus().post((SparkListenerEvent)event);
                        throw throwable;
                    }
                    long endTime = System.nanoTime();
                    Option errorMessage = ex.map((Function1 & Serializable)x0$2 -> {
                        Throwable throwable = x0$2;
                        if (throwable instanceof SparkThrowable) {
                            Throwable throwable2 = throwable;
                            return SparkThrowableHelper$.MODULE$.getMessage(throwable2, ErrorMessageFormat$.MODULE$.PRETTY());
                        }
                        return Utils$.MODULE$.exceptionString(throwable);
                    });
                    ShuffleCleanupMode shuffleCleanupMode = queryExecution.shuffleCleanupMode();
                    DoNotCleanup$ doNotCleanup$ = DoNotCleanup$.MODULE$;
                    if ((shuffleCleanupMode == null ? doNotCleanup$ != null : !shuffleCleanupMode.equals(doNotCleanup$)) && isExecutedPlanAvailable) {
                        Iterable iterable;
                        SparkPlan sparkPlan = queryExecution.executedPlan();
                        if (sparkPlan instanceof AdaptiveSparkPlanExec) {
                            AdaptiveSparkPlanExec adaptiveSparkPlanExec = (AdaptiveSparkPlanExec)sparkPlan;
                            iterable = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(adaptiveSparkPlanExec.context().shuffleIds()).asScala().keys();
                        } else {
                            iterable = (Iterable)package$.MODULE$.Iterable().empty();
                        }
                        Iterable shuffleIds = iterable;
                        shuffleIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)shuffleId -> {
                            ShuffleCleanupMode shuffleCleanupMode = queryExecution.shuffleCleanupMode();
                            if (RemoveShuffleFiles$.MODULE$.equals(shuffleCleanupMode)) {
                                sc.shuffleDriverComponents().removeShuffle(shuffleId, Utils$.MODULE$.isTesting());
                                return;
                            }
                            if (SkipMigration$.MODULE$.equals(shuffleCleanupMode)) {
                                SparkEnv$.MODULE$.get().blockManager().migratableResolver().addShuffleToSkip(shuffleId);
                                return;
                            }
                        });
                    }
                    SparkListenerSQLExecutionEnd event = new SparkListenerSQLExecutionEnd(executionId, System.currentTimeMillis(), (Option<String>)errorMessage.orElse((Function0 & Serializable)() -> new Some((Object)"")));
                    event.executionName_$eq(name);
                    event.duration_$eq(endTime - startTime);
                    event.qe_$eq(queryExecution);
                    event.executionFailure_$eq((Option<Throwable>)ex);
                    sc.listenerBus().post((SparkListenerEvent)event);
                    return object;
                })));
            }
            finally {
                MODULE$.executionIdToQueryExecution().remove(BoxesRunTime.boxToLong((long)executionId));
                sc.setLocalProperty(MODULE$.EXECUTION_ID_KEY(), oldExecutionId);
                String string = sc.getLocalProperty(MODULE$.EXECUTION_ROOT_ID_KEY());
                String string2 = Long.toString(executionId);
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    sc.setLocalProperty(MODULE$.EXECUTION_ROOT_ID_KEY(), null);
                    sc.removeJobTag(MODULE$.executionIdJobTag(sparkSession, executionId));
                }
                sc.setLocalProperty(SparkContext$.MODULE$.SPARK_JOB_INTERRUPT_ON_CANCEL(), originalInterruptOnCancel);
            }
            return t;
        });
    }

    public <T> T withNewExecutionId(QueryExecution queryExecution, Option<String> name, Function0<T> body2) {
        return this.withNewExecutionId0(queryExecution, name, (Either<Throwable, Function0<T>>)new Right(body2));
    }

    private <T> Option<String> withNewExecutionId0$default$2() {
        return None$.MODULE$;
    }

    public <T> Option<String> withNewExecutionId$default$2() {
        return None$.MODULE$;
    }

    public void withNewExecutionIdOnError(QueryExecution queryExecution, Option<String> name, Throwable t) {
        this.withNewExecutionId0(queryExecution, name, (Either)new Left((Object)t));
    }

    public Option<String> withNewExecutionIdOnError$default$2() {
        return None$.MODULE$;
    }

    public <T> T withExecutionId(org.apache.spark.sql.classic.SparkSession sparkSession, String executionId, Function0<T> body2) {
        SparkContext sc = sparkSession.sparkContext();
        String oldExecutionId = sc.getLocalProperty(this.EXECUTION_ID_KEY());
        return this.withSQLConfPropagated(sparkSession, (Function0 & Serializable)() -> MODULE$.withSessionTagsApplied(sparkSession, (Function0 & Serializable)() -> {
            Object object;
            try {
                sc.setLocalProperty(MODULE$.EXECUTION_ID_KEY(), executionId);
                object = body2.apply();
            }
            finally {
                sc.setLocalProperty(MODULE$.EXECUTION_ID_KEY(), oldExecutionId);
            }
            return object;
        }));
    }

    public <T> T withSessionTagsApplied(org.apache.spark.sql.classic.SparkSession sparkSession, Function0<T> block) {
        Object object;
        Set allTags = (Set)((MapOps)sparkSession.managedJobTags().get()).values().toSet().$plus((Object)sparkSession.sessionJobTag());
        sparkSession.sparkContext().addJobTags(allTags);
        try {
            object = block.apply();
        }
        finally {
            sparkSession.sparkContext().removeJobTags(allTags);
        }
        return (T)object;
    }

    public <T> T withSQLConfPropagated(org.apache.spark.sql.classic.SparkSession sparkSession, Function0<T> body2) {
        Object object;
        SparkContext sc = sparkSession.sparkContext();
        scala.collection.immutable.Map allConfigs = sparkSession.sessionState().conf().getAllConfs();
        scala.collection.immutable.Map originalLocalProps = (scala.collection.immutable.Map)allConfigs.collect((PartialFunction)new Serializable(sc){
            private static final long serialVersionUID = 0L;
            private final SparkContext sc$3;

            public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String key = (String)A1._1();
                    String value = (String)A1._2();
                    if (key.startsWith("spark")) {
                        String originalValue = this.sc$3.getLocalProperty(key);
                        this.sc$3.setLocalProperty(key, value);
                        return (B1)new Tuple2((Object)key, (Object)originalValue);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, String> x1) {
                String key;
                Tuple2<String, String> tuple2 = x1;
                return tuple2 != null && (key = (String)tuple2._1()).startsWith("spark");
            }
            {
                this.sc$3 = sc$3;
            }
        });
        try {
            object = body2.apply();
        }
        finally {
            originalLocalProps.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SQLExecution$.$anonfun$withSQLConfPropagated$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$2 -> {
                SQLExecution$.$anonfun$withSQLConfPropagated$2(sc, x$2);
                return BoxedUnit.UNIT;
            });
        }
        return (T)object;
    }

    public <T> CompletableFuture<T> withThreadLocalCaptured(org.apache.spark.sql.classic.SparkSession sparkSession, ExecutorService exec, Function0<T> body2) {
        org.apache.spark.sql.classic.SparkSession activeSession = sparkSession;
        SparkContext sc = sparkSession.sparkContext();
        Properties localProps = Utils$.MODULE$.cloneProperties(sc.getLocalProperties());
        JobArtifactState artifactState = (JobArtifactState)JobArtifactSet$.MODULE$.getCurrentJobArtifactState().getOrElse((Function0 & Serializable)() -> activeSession.artifactManager().state());
        return CompletableFuture.supplyAsync(() -> JobArtifactSet$.MODULE$.withActiveJobArtifactState(artifactState, (Function0 & Serializable)() -> {
            Option<org.apache.spark.sql.classic.SparkSession> originalSession = SparkSession$.MODULE$.getActiveSession();
            Properties originalLocalProps = sc.getLocalProperties();
            SparkSession$.MODULE$.setActiveSession(activeSession);
            Object res = MODULE$.withSessionTagsApplied(activeSession, (Function0 & Serializable)() -> {
                sc.setLocalProperties(localProps);
                Object res = body2.apply();
                sc.setLocalProperties(originalLocalProps);
                return res;
            });
            if (originalSession.nonEmpty()) {
                SparkSession$.MODULE$.setActiveSession((SparkSession)originalSession.get());
            } else {
                SparkSession$.MODULE$.clearActiveSession();
            }
            return res;
        }), exec);
    }

    public static final /* synthetic */ boolean $anonfun$withNewExecutionId0$2(int truncateLength$1, String x$1) {
        return truncateLength$1 > 0;
    }

    public static final /* synthetic */ boolean $anonfun$withNewExecutionId0$5(scala.collection.immutable.Map globalConfigs$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            return key.startsWith(org.apache.spark.internal.config.package$.MODULE$.SPARK_DRIVER_PREFIX()) || key.startsWith(org.apache.spark.internal.config.package$.MODULE$.SPARK_EXECUTOR_PREFIX()) || globalConfigs$1.get((Object)key).contains((Object)value);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$withSQLConfPropagated$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$withSQLConfPropagated$2(SparkContext sc$3, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            sc$3.setLocalProperty(key, value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private SQLExecution$() {
    }
}

