/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog$;
import org.apache.spark.sql.execution.streaming.MetadataLog;
import org.apache.spark.sql.execution.streaming.MetadataVersionUtil$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.ArrayImplicits$;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\rg\u0001B\u00193\u0001}B\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\t=\u0002\u0011\t\u0011)A\u0005?\"A!\u000e\u0001B\u0002B\u0003-1\u000eC\u0003r\u0001\u0011\u0005!\u000fC\u0004y\u0001\t\u0007I1B=\t\u000f\u0005\u0005\u0001\u0001)A\u0005u\"I\u00111\u0001\u0001C\u0002\u0013-\u0011Q\u0001\u0005\t\u0003\u001b\u0001\u0001\u0015!\u0003\u0002\b!I\u0011q\u0002\u0001C\u0002\u0013\u0005\u0011\u0011\u0003\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u0014!I\u0011Q\u0005\u0001C\u0002\u0013E\u0011q\u0005\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002*!I\u0011\u0011\u0007\u0001C\u0002\u0013E\u00111\u0007\u0005\t\u0003w\u0001\u0001\u0015!\u0003\u00026!Q\u0011Q\b\u0001C\u0002\u0013Ea'a\u0010\t\u0011\u0005]\u0003\u0001)A\u0005\u0003\u0003B\u0011\"!\u0017\u0001\u0005\u0004%\t\"a\u0017\t\u0011\u0005\r\u0004\u0001)A\u0005\u0003;Bq!a\u001e\u0001\t#\tI\bC\u0004\u0002\u0000\u0001!\t\"!!\t\u000f\u0005\u0015\u0005\u0001\"\u0005\u0002\b\"9\u00111\u0012\u0001\u0005\u0012\u00055\u0005bBAU\u0001\u0011E\u00111\u0016\u0005\b\u0003o\u0003A\u0011IA]\u0011\u001d\ty\f\u0001C!\u0003\u0003Dq!a3\u0001\t\u0003\ti\rC\u0004\u0002T\u0002!\t!!6\t\u0013\u0005e\b!%A\u0005\u0002\u0005m\bb\u0002B\u000b\u0001\u0011E!q\u0003\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u0011\u001d\u0011Y\u0003\u0001C\u0005\u0005[Aq!a0\u0001\t\u0003\u0012\t\u0004C\u0004\u0003H\u0001!\tA!\u0013\t\u000f\t-\u0003\u0001\"\u0011\u0003N!9!\u0011\u000b\u0001\u0005\u0002\tM\u0003\"\u0003B/\u0001\u0001\u0007I\u0011\u0002B0\u0011%\u0011\t\u0007\u0001a\u0001\n\u0013\u0011\u0019\u0007\u0003\u0005\u0003j\u0001\u0001\u000b\u0015BA)\u0011\u001d\u0011Y\u0007\u0001C!\u0005[BqAa\u001d\u0001\t\u0003\u0011)\bC\u0004\u0003z\u0001!\tBa\u001f\t\u000f\t}\u0004\u0001\"\u0001\u0003|!A!\u0011\u0011\u0001\u0005\u0002Y\u0012\u0019\t\u0003\u0005\u0003\u0014\u0002!\tA\u000eBK\u000f\u001d\u0011iJ\rE\u0001\u0005?3a!\r\u001a\t\u0002\t\u0005\u0006BB9/\t\u0003\u0011\u0019\u000bC\u0004\u0003&:\"\tAa*\u0003\u001f!#eiU'fi\u0006$\u0017\r^1M_\u001eT!a\r\u001b\u0002\u0013M$(/Z1nS:<'BA\u001b7\u0003%)\u00070Z2vi&|gN\u0003\u00028q\u0005\u00191/\u001d7\u000b\u0005eR\u0014!B:qCJ\\'BA\u001e=\u0003\u0019\t\u0007/Y2iK*\tQ(A\u0002pe\u001e\u001c\u0001!\u0006\u0002A\u001bN!\u0001!Q$T!\t\u0011U)D\u0001D\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0005\u0019\te.\u001f*fMB\u0019\u0001*S&\u000e\u0003IJ!A\u0013\u001a\u0003\u00175+G/\u00193bi\u0006dun\u001a\t\u0003\u00196c\u0001\u0001B\u0003O\u0001\t\u0007qJA\u0001U#\t\u0001\u0016\t\u0005\u0002C#&\u0011!k\u0011\u0002\b\u001d>$\b.\u001b8h!\t!v+D\u0001V\u0015\t1\u0006(\u0001\u0005j]R,'O\\1m\u0013\tAVKA\u0004M_\u001e<\u0017N\\4\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005mcV\"\u0001\u001c\n\u0005u3$\u0001D*qCJ\\7+Z:tS>t\u0017\u0001\u00029bi\"\u0004\"\u0001Y4\u000f\u0005\u0005,\u0007C\u00012D\u001b\u0005\u0019'B\u00013?\u0003\u0019a$o\\8u}%\u0011amQ\u0001\u0007!J,G-\u001a4\n\u0005!L'AB*ue&twM\u0003\u0002g\u0007\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u00071|7*D\u0001n\u0015\tq7)A\u0004sK\u001adWm\u0019;\n\u0005Al'\u0001C\"mCN\u001cH+Y4\u0002\rqJg.\u001b;?)\r\u0019ho\u001e\u000b\u0003iV\u00042\u0001\u0013\u0001L\u0011\u0015QG\u0001q\u0001l\u0011\u0015IF\u00011\u0001[\u0011\u0015qF\u00011\u0001`\u0003\u001d1wN]7biN,\u0012A\u001f\t\u0003wzl\u0011\u0001 \u0006\u0003{r\naA[:p]R\u001a\u0018BA@}\u0005\u001d1uN]7biN\f\u0001BZ8s[\u0006$8\u000fI\u0001\t[\u0006t\u0017NZ3tiV\u0011\u0011q\u0001\t\u0005Y\u0006%1*C\u0002\u0002\f5\u0014\u0001\"T1oS\u001a,7\u000f^\u0001\n[\u0006t\u0017NZ3ti\u0002\nA\"\\3uC\u0012\fG/\u0019)bi\",\"!a\u0005\u0011\t\u0005U\u0011qD\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u0005\u0011am\u001d\u0006\u0004\u0003;Q\u0014A\u00025bI>|\u0007/\u0003\u0003\u0002\"\u0005]!\u0001\u0002)bi\"\fQ\"\\3uC\u0012\fG/\u0019)bi\"\u0004\u0013a\u00034jY\u0016l\u0015M\\1hKJ,\"!!\u000b\u0011\u0007!\u000bY#C\u0002\u0002.I\u0012Qc\u00115fG.\u0004x.\u001b8u\r&dW-T1oC\u001e,'/\u0001\u0007gS2,W*\u00198bO\u0016\u0014\b%\u0001\u000bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z#oC\ndW\rZ\u000b\u0003\u0003k\u00012AQA\u001c\u0013\r\tId\u0011\u0002\b\u0005>|G.Z1o\u0003UiW\r^1eCR\f7)Y2iK\u0016s\u0017M\u00197fI\u0002\n!BY1uG\"\u001c\u0015m\u00195f+\t\t\t\u0005E\u0004\u0002D\u00055\u0013\u0011K&\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\nA!\u001e;jY*\u0011\u00111J\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002P\u0005\u0015#aA'baB\u0019!)a\u0015\n\u0007\u0005U3I\u0001\u0003M_:<\u0017a\u00032bi\u000eD7)Y2iK\u0002\n\u0001CY1uG\"4\u0015\u000e\\3t\r&dG/\u001a:\u0016\u0005\u0005u#CBA0\u0003K\n\tH\u0002\u0004\u0002bI\u0001\u0011Q\f\u0002\ryI,g-\u001b8f[\u0016tGOP\u0001\u0012E\u0006$8\r\u001b$jY\u0016\u001ch)\u001b7uKJ\u0004\u0003\u0003BA4\u0003[j!!!\u001b\u000b\t\u0005-\u0014\u0011J\u0001\u0005Y\u0006tw-\u0003\u0003\u0002p\u0005%$AB(cU\u0016\u001cG\u000f\u0005\u0003\u0002\u0016\u0005M\u0014\u0002BA;\u0003/\u0011!\u0002U1uQ\u001aKG\u000e^3s\u00035\u0011\u0017\r^2i\u0013\u0012$v\u000eU1uQR!\u00111CA>\u0011\u001d\tih\u0005a\u0001\u0003#\nqAY1uG\"LE-A\u0007qCRDGk\u001c\"bi\u000eD\u0017\n\u001a\u000b\u0005\u0003#\n\u0019\t\u0003\u0004_)\u0001\u0007\u00111C\u0001\fSN\u0014\u0015\r^2i\r&dW\r\u0006\u0003\u00026\u0005%\u0005B\u00020\u0016\u0001\u0004\t\u0019\"A\u0005tKJL\u0017\r\\5{KR1\u0011qRAK\u00033\u00032AQAI\u0013\r\t\u0019j\u0011\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u0018Z\u0001\raS\u0001\t[\u0016$\u0018\rZ1uC\"9\u00111\u0014\fA\u0002\u0005u\u0015aA8viB!\u0011qTAS\u001b\t\t\tK\u0003\u0003\u0002$\u0006%\u0013AA5p\u0013\u0011\t9+!)\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0004\u0017\u00065\u0006bBAX/\u0001\u0007\u0011\u0011W\u0001\u0003S:\u0004B!a(\u00024&!\u0011QWAQ\u0005-Ie\u000e];u'R\u0014X-Y7\u0002\u0007\u0005$G\r\u0006\u0004\u00026\u0005m\u0016Q\u0018\u0005\b\u0003{B\u0002\u0019AA)\u0011\u0019\t9\n\u0007a\u0001\u0017\u0006\u0019q-\u001a;\u0015\t\u0005\r\u0017\u0011\u001a\t\u0005\u0005\u0006\u00157*C\u0002\u0002H\u000e\u0013aa\u00149uS>t\u0007bBA?3\u0001\u0007\u0011\u0011K\u0001\u0018O\u0016$\bK]3w\u0005\u0006$8\r\u001b$s_6\u001cFo\u001c:bO\u0016$B!a4\u0002RB)!)!2\u0002R!9\u0011Q\u0010\u000eA\u0002\u0005E\u0013AF1qa2LhI\u001c+p\u0005\u0006$8\r\u001b\"z'R\u0014X-Y7\u0016\t\u0005]\u0017Q\u001c\u000b\u0007\u00033\f\u00190!>\u0015\t\u0005m\u0017\u0011\u001e\t\u0004\u0019\u0006uGaBAp7\t\u0007\u0011\u0011\u001d\u0002\u0004%\u0016#\u0016c\u0001)\u0002dB\u0019!)!:\n\u0007\u0005\u001d8IA\u0002B]fDq!a;\u001c\u0001\u0004\ti/\u0001\u0002g]B9!)a<\u00022\u0006m\u0017bAAy\u0007\nIa)\u001e8di&|g.\r\u0005\b\u0003{Z\u0002\u0019AA)\u0011%\t9p\u0007I\u0001\u0002\u0004\t)$A\ttW&\u0004X\t_5ti&twm\u00115fG.\f\u0001%\u00199qYf4e\u000eV8CCR\u001c\u0007NQ=TiJ,\u0017-\u001c\u0013eK\u001a\fW\u000f\u001c;%eU!\u0011Q B\n+\t\tyP\u000b\u0003\u00026\t\u00051F\u0001B\u0002!\u0011\u0011)Aa\u0004\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0005\u0017\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t51)\u0001\u0006b]:|G/\u0019;j_:LAA!\u0005\u0003\b\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\u0005}GD1\u0001\u0002b\u0006)qO]5uKR1\u0011q\u0012B\r\u0005;AqAa\u0007\u001e\u0001\u0004\t\u0019\"A\tcCR\u001c\u0007.T3uC\u0012\fG/\u0019$jY\u0016Dq!a;\u001e\u0001\u0004\u0011y\u0002E\u0004C\u0003_\fi*a$\u0002'\u0005$GMT3x\u0005\u0006$8\r\u001b\"z'R\u0014X-Y7\u0015\t\t\u0015\"\u0011\u0006\u000b\u0005\u0003k\u00119\u0003C\u0004\u0002lz\u0001\rAa\b\t\u000f\u0005ud\u00041\u0001\u0002R\u0005\u0001r-\u001a;Fq&\u001cH/\u001b8h\u0005\u0006$8\r\u001b\u000b\u0004\u0017\n=\u0002bBA??\u0001\u0007\u0011\u0011\u000b\u000b\u0007\u0005g\u0011yDa\u0011\u0011\u000b\t\u0013)D!\u000f\n\u0007\t]2IA\u0003BeJ\f\u0017\u0010\u0005\u0004C\u0005w\t\tfS\u0005\u0004\u0005{\u0019%A\u0002+va2,'\u0007C\u0004\u0003B\u0001\u0002\r!a4\u0002\u000fM$\u0018M\u001d;JI\"9!Q\t\u0011A\u0002\u0005=\u0017!B3oI&#\u0017\u0001E4fi2\u000bG/Z:u\u0005\u0006$8\r[%e)\t\ty-A\u0005hKRd\u0015\r^3tiR\u0011!q\n\t\u0006\u0005\u0006\u0015'\u0011H\u0001\u0015O\u0016$xJ\u001d3fe\u0016$')\u0019;dQ\u001aKG.Z:\u0015\u0005\tU\u0003#\u0002\"\u00036\t]\u0003\u0003BA\u000b\u00053JAAa\u0017\u0002\u0018\tQa)\u001b7f'R\fG/^:\u0002#1\f7\u000f\u001e)ve\u001e,GMQ1uG\"LE-\u0006\u0002\u0002R\u0005)B.Y:u!V\u0014x-\u001a3CCR\u001c\u0007.\u00133`I\u0015\fH\u0003BAH\u0005KB\u0011Ba\u001a&\u0003\u0003\u0005\r!!\u0015\u0002\u0007a$\u0013'\u0001\nmCN$\b+\u001e:hK\u0012\u0014\u0015\r^2i\u0013\u0012\u0004\u0013!\u00029ve\u001e,G\u0003BAH\u0005_BqA!\u001d(\u0001\u0004\t\t&\u0001\tuQJ,7\u000f[8mI\n\u000bGo\u00195JI\u0006Q\u0001/\u001e:hK\u00063G/\u001a:\u0015\t\u0005=%q\u000f\u0005\b\u0005cB\u0003\u0019AA)\u0003-a\u0017n\u001d;CCR\u001c\u0007.Z:\u0016\u0005\tu\u0004#\u0002\"\u00036\u0005E\u0013!\u00057jgR\u0014\u0015\r^2iKN|e\u000eR5tW\u0006ya/\u00197jI\u0006$XMV3sg&|g\u000e\u0006\u0004\u0003\u0006\n-%q\u0012\t\u0004\u0005\n\u001d\u0015b\u0001BE\u0007\n\u0019\u0011J\u001c;\t\r\t55\u00061\u0001`\u0003\u0011!X\r\u001f;\t\u000f\tE5\u00061\u0001\u0003\u0006\u0006\u0019R.\u0019=TkB\u0004xN\u001d;fIZ+'o]5p]\u0006Ib/\u00197jI\u0006$XMV3sg&|g.\u0012=bGRl\u0015\r^2i)\u0019\u0011)Ia&\u0003\u001a\"1!Q\u0012\u0017A\u0002}CqAa'-\u0001\u0004\u0011))\u0001\u0007nCR\u001c\u0007NV3sg&|g.A\bI\t\u001a\u001bV*\u001a;bI\u0006$\u0018\rT8h!\tAef\u0005\u0002/\u0003R\u0011!qT\u0001\u000fm\u0016\u0014\u0018NZ=CCR\u001c\u0007.\u00133t)!\tyI!+\u0003@\n\u0005\u0007b\u0002BVa\u0001\u0007!QV\u0001\tE\u0006$8\r[%egB1!q\u0016B]\u0003#rAA!-\u00036:\u0019!Ma-\n\u0003\u0011K1Aa.D\u0003\u001d\u0001\u0018mY6bO\u0016LAAa/\u0003>\n\u00191+Z9\u000b\u0007\t]6\tC\u0004\u0003BA\u0002\r!a4\t\u000f\t\u0015\u0003\u00071\u0001\u0002P\u0002")
public class HDFSMetadataLog<T>
implements MetadataLog<T>,
Logging {
    private final String path;
    private final Formats formats;
    private final Manifest<T> manifest;
    private final Path metadataPath;
    private final CheckpointFileManager fileManager;
    private final boolean metadataCacheEnabled;
    private final Map<Object, T> batchCache;
    private final PathFilter batchFilesFilter;
    private long lastPurgedBatchId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void verifyBatchIds(Seq<Object> batchIds, Option<Object> startId, Option<Object> endId) {
        HDFSMetadataLog$.MODULE$.verifyBatchIds(batchIds, startId, endId);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public Path metadataPath() {
        return this.metadataPath;
    }

    public CheckpointFileManager fileManager() {
        return this.fileManager;
    }

    public boolean metadataCacheEnabled() {
        return this.metadataCacheEnabled;
    }

    public Map<Object, T> batchCache() {
        return this.batchCache;
    }

    public PathFilter batchFilesFilter() {
        return this.batchFilesFilter;
    }

    public Path batchIdToPath(long batchId) {
        return new Path(this.metadataPath(), Long.toString(batchId));
    }

    public long pathToBatchId(Path path) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(path.getName()));
    }

    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(path.getName()));
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void serialize(T metadata, OutputStream out) {
        Serialization$.MODULE$.write(metadata, out, this.formats());
    }

    public T deserialize(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return (T)Serialization$.MODULE$.read((Reader)reader, this.formats(), this.manifest());
    }

    @Override
    public boolean add(long batchId, T metadata) {
        Predef$.MODULE$.require(metadata != null, (Function0 & Serializable)() -> "'null' metadata cannot written to a metadata log");
        boolean res = this.addNewBatchByStream(batchId, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable)output -> {
            this.serialize(metadata, output);
            return BoxedUnit.UNIT;
        });
        Object object = this.metadataCacheEnabled() && res ? this.batchCache().put(BoxesRunTime.boxToLong((long)batchId), metadata) : BoxedUnit.UNIT;
        return res;
    }

    @Override
    public Option<T> get(long batchId) {
        None$ none$;
        if (this.metadataCacheEnabled() && this.batchCache().containsKey(BoxesRunTime.boxToLong((long)batchId))) {
            T metadata = this.batchCache().get(BoxesRunTime.boxToLong((long)batchId));
            Predef$.MODULE$.assert(metadata != null);
            return new Some(metadata);
        }
        try {
            none$ = (Option)this.applyFnToBatchByStream(batchId, this.applyFnToBatchByStream$default$2(), (Function1 & Serializable)input -> new Some(this.deserialize((InputStream)input)));
        }
        catch (FileNotFoundException fne) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> fne.getMessage());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Object> getPrevBatchFromStorage(long batchId) {
        Option option;
        Object object = new Object();
        try {
            long[] batchFiles = this.listBatchesOnDisk();
            ObjectRef prev = ObjectRef.create((Object)None$.MODULE$);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(batchFiles), (Ordering)Ordering.Long$.MODULE$)), (Function1)(JFunction1.mcVJ.sp & Serializable)file -> {
                if (file >= batchId) {
                    throw new NonLocalReturnControl(object, (Object)((Option)prev$1.elem));
                }
                prev$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)file));
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public <RET> RET applyFnToBatchByStream(long batchId, boolean skipExistingCheck, Function1<InputStream, RET> fn) {
        Path batchMetadataFile = this.batchIdToPath(batchId);
        if (skipExistingCheck || this.fileManager().exists(batchMetadataFile)) {
            Object object;
            FSDataInputStream input = this.fileManager().open(batchMetadataFile);
            try {
                try {
                    object = fn.apply((Object)input);
                }
                catch (IllegalStateException ise) {
                    throw new IllegalStateException("Failed to read log file " + batchMetadataFile + ". " + ise.getMessage(), ise);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
            return (RET)object;
        }
        throw QueryExecutionErrors$.MODULE$.batchMetadataFileNotFoundError(batchMetadataFile);
    }

    public <RET> boolean applyFnToBatchByStream$default$2() {
        return false;
    }

    public void write(Path batchMetadataFile, Function1<OutputStream, BoxedUnit> fn) {
        CheckpointFileManager.CancellableFSDataOutputStream output = this.fileManager().createAtomic(batchMetadataFile, false);
        try {
            fn.apply((Object)output);
            output.close();
        }
        catch (FileAlreadyExistsException e) {
            throw QueryExecutionErrors$.MODULE$.multiStreamingQueriesUsingPathConcurrentlyError(this.path, e);
        }
        finally {
            output.cancel();
        }
    }

    public boolean addNewBatchByStream(long batchId, Function1<OutputStream, BoxedUnit> fn) {
        Path batchMetadataFile = this.batchIdToPath(batchId);
        if (this.metadataCacheEnabled() && this.batchCache().containsKey(BoxesRunTime.boxToLong((long)batchId)) || this.fileManager().exists(batchMetadataFile)) {
            return false;
        }
        this.write(batchMetadataFile, fn);
        return true;
    }

    private T getExistingBatch(long batchId) {
        T metadata = this.batchCache().get(BoxesRunTime.boxToLong((long)batchId));
        if (metadata == null) {
            return (T)this.applyFnToBatchByStream(batchId, true, (Function1 & Serializable)input -> this.deserialize((InputStream)input));
        }
        return metadata;
    }

    @Override
    public Tuple2<Object, T>[] get(Option<Object> startId, Option<Object> endId) {
        Predef$.MODULE$.assert(startId.isEmpty() || endId.isEmpty() || BoxesRunTime.unboxToLong((Object)startId.get()) <= BoxesRunTime.unboxToLong((Object)endId.get()));
        long[] batchIds = (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps(this.listBatches()), (Function1)(JFunction1.mcZJ.sp & Serializable)batchId -> !(!endId.isEmpty() && batchId > BoxesRunTime.unboxToLong((Object)endId.get()) || !startId.isEmpty() && batchId < BoxesRunTime.unboxToLong((Object)startId.get())))), (Ordering)Ordering.Long$.MODULE$);
        HDFSMetadataLog$.MODULE$.verifyBatchIds((Seq<Object>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)batchIds).toImmutableArraySeq(), startId, endId);
        return (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps(batchIds), (Function1 & Serializable)batchId -> HDFSMetadataLog.$anonfun$get$4(this, BoxesRunTime.unboxToLong((Object)batchId)), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Option<Object> getLatestBatchId() {
        return ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(this.listBatches()), (Ordering)Ordering.Long$.MODULE$)));
    }

    @Override
    public Option<Tuple2<Object, T>> getLatest() {
        return ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(this.listBatches()), (Ordering)Ordering.Long$.MODULE$))).map((Function1 & Serializable)batchId -> HDFSMetadataLog.$anonfun$getLatest$1(this, BoxesRunTime.unboxToLong((Object)batchId)));
    }

    public FileStatus[] getOrderedBatchFiles() {
        return (FileStatus[])ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (Ordering)Ordering.Long$.MODULE$)));
    }

    private long lastPurgedBatchId() {
        return this.lastPurgedBatchId;
    }

    private void lastPurgedBatchId_$eq(long x$1) {
        this.lastPurgedBatchId = x$1;
    }

    @Override
    public void purge(long thresholdBatchId) {
        NumericRange.Exclusive possibleTargetBatchIds = new RichLong(Predef$.MODULE$.longWrapper(this.lastPurgedBatchId() + 1L)).until((Object)BoxesRunTime.boxToLong((long)thresholdBatchId));
        if (possibleTargetBatchIds.length() <= 3) {
            possibleTargetBatchIds.foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)batchId -> {
                Path path = this.batchIdToPath(batchId);
                this.fileManager().delete(path);
                Object object = this.metadataCacheEnabled() ? this.batchCache().remove(BoxesRunTime.boxToLong((long)batchId)) : BoxedUnit.UNIT;
                this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Removed metadata log file: " + path);
            });
        } else {
            ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.longArrayOps(this.listBatches()), (Function1)(JFunction1.mcZJ.sp & Serializable)batchId -> batchId < thresholdBatchId).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)batchId -> {
                Path path = this.batchIdToPath(batchId);
                this.fileManager().delete(path);
                Object object = this.metadataCacheEnabled() ? this.batchCache().remove(BoxesRunTime.boxToLong((long)batchId)) : BoxedUnit.UNIT;
                this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Removed metadata log file: " + path);
            });
        }
        this.lastPurgedBatchId_$eq(thresholdBatchId - 1L);
    }

    public void purgeAfter(long thresholdBatchId) {
        long[] batchIds = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (ClassTag)ClassTag$.MODULE$.Long());
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.longArrayOps(batchIds), (Function1)(JFunction1.mcZJ.sp & Serializable)batchId -> batchId > thresholdBatchId).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)batchId -> {
            Path path = this.batchIdToPath(batchId);
            this.fileManager().delete(path);
            Object object = this.metadataCacheEnabled() ? this.batchCache().remove(BoxesRunTime.boxToLong((long)batchId)) : BoxedUnit.UNIT;
            this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Removed metadata log file: " + path);
        });
    }

    public long[] listBatches() {
        long[] lArray;
        Map<Object, T> map = this.batchCache();
        synchronized (map) {
            lArray = (long[])CollectionConverters$.MODULE$.SetHasAsScala(this.batchCache().keySet()).asScala().toArray((ClassTag)ClassTag$.MODULE$.Long());
        }
        long[] batchIds = (long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.isFile()))), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (ClassTag)ClassTag$.MODULE$.Long())), (Object)lArray, (ClassTag)ClassTag$.MODULE$.Long());
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"BatchIds found from listing: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BATCH_ID$.MODULE$, (Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(batchIds), (Ordering)Ordering.Long$.MODULE$)).mkString(", "))}))));
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.longArrayOps(batchIds))) {
            return (long[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Long());
        }
        return (long[])new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray(batchIds).min((Ordering)Ordering.Long$.MODULE$)))).to(Predef$.MODULE$.wrapLongArray(batchIds).max((Ordering)Ordering.Long$.MODULE$)).toArray((ClassTag)ClassTag$.MODULE$.Long());
    }

    public long[] listBatchesOnDisk() {
        return (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (ClassTag)ClassTag$.MODULE$.Long())), (Ordering)Ordering.Long$.MODULE$);
    }

    public int validateVersion(String text, int maxSupportedVersion) {
        return MetadataVersionUtil$.MODULE$.validateVersion(text, maxSupportedVersion);
    }

    public int validateVersionExactMatch(String text, int matchVersion) {
        return MetadataVersionUtil$.MODULE$.validateVersionExactMatch(text, matchVersion);
    }

    public static final /* synthetic */ Tuple2 $anonfun$get$4(HDFSMetadataLog $this, long batchId) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), $this.getExistingBatch(batchId));
    }

    public static final /* synthetic */ Tuple2 $anonfun$getLatest$1(HDFSMetadataLog $this, long batchId) {
        $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Getting latest batch ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BATCH_ID$.MODULE$, (Object)BoxesRunTime.boxToLong((long)batchId))}))));
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), $this.getExistingBatch(batchId));
    }

    public HDFSMetadataLog(SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.path = path;
        Logging.$init$((Logging)this);
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        Class clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.manifest())).runtimeClass();
        Class<Seq> clazz2 = Seq.class;
        Predef$.MODULE$.require(clazz == null ? clazz2 != null : !clazz.equals(clazz2), (Function0 & Serializable)() -> "Should not create a log with type Seq, use Arrays instead - see SPARK-17372");
        this.metadataPath = new Path(path);
        this.fileManager = CheckpointFileManager$.MODULE$.create(this.metadataPath(), sparkSession.sessionState().newHadoopConf());
        if (!this.fileManager().exists(this.metadataPath())) {
            this.fileManager().mkdirs(this.metadataPath());
        }
        this.metadataCacheEnabled = BoxesRunTime.unboxToBoolean((Object)sparkSession.sessionState().conf().getConf(SQLConf$.MODULE$.STREAMING_METADATA_CACHE_ENABLED()));
        this.batchCache = Collections.synchronizedMap(new LinkedHashMap<Object, T>(null){

            public boolean removeEldestEntry(Map.Entry<Object, T> e) {
                return this.size() > 2;
            }
        });
        this.batchFilesFilter = new PathFilter(this){
            private final /* synthetic */ HDFSMetadataLog $outer;

            public boolean accept(Path path) {
                return this.$outer.isBatchFile(path);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.lastPurgedBatchId = -1L;
    }
}

