/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.SparkShreddingUtils$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001\u0002\t\u0012\u0001\u0001B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!A1\b\u0001B\u0001B\u0003%\u0001\u0006C\u0003=\u0001\u0011\u0005Q\bC\u0003=\u0001\u0011\u00051\tC\u0003=\u0001\u0011\u0005\u0011\nC\u0003S\u0001\u0011\u00051\u000bC\u0003d\u0001\u0011\u0005A\rC\u0003d\u0001\u0011%qnB\u0004|#\u0005\u0005\t\u0012\u0001?\u0007\u000fA\t\u0012\u0011!E\u0001{\")Ah\u0003C\u0001}\"AqpCI\u0001\n\u0003\t\t\u0001C\u0005\u0002\u0018-\t\n\u0011\"\u0001\u0002\u001a!I\u0011QD\u0006\u0012\u0002\u0013\u0005\u0011\u0011\u0001\u0002\u001e'B\f'o\u001b+p!\u0006\u0014\u0018/^3u'\u000eDW-\\1D_:4XM\u001d;fe*\u0011!cE\u0001\ba\u0006\u0014\u0018/^3u\u0015\t!R#A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\f\u0018\u0003%)\u00070Z2vi&|gN\u0003\u0002\u00193\u0005\u00191/\u001d7\u000b\u0005iY\u0012!B:qCJ\\'B\u0001\u000f\u001e\u0003\u0019\t\u0007/Y2iK*\ta$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001CA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\f\u0001d\u001e:ji\u0016dUmZ1dsB\u000b'/];fi\u001a{'/\\1u!\t\u0011\u0013&\u0003\u0002+G\t9!i\\8mK\u0006t\u0017aE8viB,H\u000fV5nKN$\u0018-\u001c9UsB,\u0007CA\u00178\u001d\tqCG\u0004\u00020e5\t\u0001G\u0003\u00022/\u0005A\u0011N\u001c;fe:\fG.\u0003\u00024a\u000591+\u0015'D_:4\u0017BA\u001b7\u0003i\u0001\u0016M]9vKR|U\u000f\u001e9viRKW.Z:uC6\u0004H+\u001f9f\u0015\t\u0019\u0004'\u0003\u00029s\t)a+\u00197vK&\u0011!h\t\u0002\f\u000b:,X.\u001a:bi&|g.\u0001\u0006vg\u00164\u0015.\u001a7e\u0013\u0012\fa\u0001P5oSRtD\u0003\u0002 A\u0003\n\u0003\"a\u0010\u0001\u000e\u0003EAqa\n\u0003\u0011\u0002\u0003\u0007\u0001\u0006C\u0004,\tA\u0005\t\u0019\u0001\u0017\t\u000fm\"\u0001\u0013!a\u0001QQ\u0011a\b\u0012\u0005\u0006\u000b\u0016\u0001\rAR\u0001\u0005G>tg\r\u0005\u00020\u000f&\u0011\u0001\n\r\u0002\b'Fc5i\u001c8g)\tq$\nC\u0003F\r\u0001\u00071\n\u0005\u0002M!6\tQJ\u0003\u0002F\u001d*\u0011qjG\u0001\u0007Q\u0006$wn\u001c9\n\u0005Ek%!D\"p]\u001aLw-\u001e:bi&|g.A\u0004d_:4XM\u001d;\u0015\u0005Q[\u0006CA+Z\u001b\u00051&BA,Y\u0003\u0019\u00198\r[3nC*\u0011!cG\u0005\u00035Z\u00131\"T3tg\u0006<W\rV=qK\")Al\u0002a\u0001;\u0006q1-\u0019;bYf\u001cHoU2iK6\f\u0007C\u00010b\u001b\u0005y&B\u00011\u0018\u0003\u0015!\u0018\u0010]3t\u0013\t\u0011wL\u0001\u0006TiJ,8\r\u001e+za\u0016\fAbY8om\u0016\u0014HOR5fY\u0012$2!\u001a5n!\t)f-\u0003\u0002h-\n!A+\u001f9f\u0011\u0015I\u0007\u00021\u0001k\u0003\u00151\u0017.\u001a7e!\tq6.\u0003\u0002m?\nY1\u000b\u001e:vGR4\u0015.\u001a7e\u0011\u0015q\u0007\u00021\u0001)\u0003)Ign\u00155sK\u0012$W\r\u001a\u000b\u0005KB\f(\u0010C\u0003j\u0013\u0001\u0007!\u000eC\u0003s\u0013\u0001\u00071/\u0001\u0006sKB,G/\u001b;j_:\u0004\"\u0001^<\u000f\u0005U+\u0018B\u0001<W\u0003\u0011!\u0016\u0010]3\n\u0005aL(A\u0003*fa\u0016$\u0018\u000e^5p]*\u0011aO\u0016\u0005\u0006]&\u0001\r\u0001K\u0001\u001e'B\f'o\u001b+p!\u0006\u0014\u0018/^3u'\u000eDW-\\1D_:4XM\u001d;feB\u0011qhC\n\u0003\u0017\u0005\"\u0012\u0001`\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\r!f\u0001\u0015\u0002\u0006-\u0012\u0011q\u0001\t\u0005\u0003\u0013\t\u0019\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0012\r\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)\"a\u0003\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u00037Q3\u0001LA\u0003\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0001")
public class SparkToParquetSchemaConverter {
    private final boolean writeLegacyParquetFormat;
    private final Enumeration.Value outputTimestampType;
    private final boolean useFieldId;

    public static boolean $lessinit$greater$default$3() {
        return SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$3();
    }

    public static Enumeration.Value $lessinit$greater$default$2() {
        return SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public MessageType convert(StructType catalystSchema) {
        return (MessageType)Types.buildMessage().addFields((Type[])((IterableOnceOps)catalystSchema.map((Function1 & Serializable)f -> this.convertField((StructField)f, false))).toArray(ClassTag$.MODULE$.apply(Type.class))).named(ParquetSchemaConverter$.MODULE$.SPARK_PARQUET_SCHEMA_NAME());
    }

    public Type convertField(StructField field, boolean inShredded) {
        Type converted = this.convertField(field, field.nullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED, inShredded);
        if (this.useFieldId && ParquetUtils$.MODULE$.hasFieldId(field)) {
            return converted.withId(ParquetUtils$.MODULE$.getFieldId(field));
        }
        return converted;
    }

    private Type convertField(StructField field2, Type.Repetition repetition, boolean inShredded) {
        Option option;
        Option option2;
        Option option3;
        boolean bl = false;
        DecimalType decimalType = null;
        boolean bl2 = false;
        ArrayType arrayType = null;
        boolean bl3 = false;
        MapType mapType = null;
        boolean bl4 = false;
        StructType structType = null;
        DataType dataType = field2.dataType();
        if (BooleanType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(field2.name());
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true)).named(field2.name());
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true)).named(field2.name());
        }
        if (IntegerType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(field2.name());
        }
        if (LongType$.MODULE$.equals(dataType) ? true : dataType instanceof DayTimeIntervalType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(field2.name());
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(field2.name());
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(field2.name());
        }
        if (dataType instanceof StringType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType()).named(field2.name());
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType()).named(field2.name());
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            if (inShredded) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS)).named(field2.name());
            }
            Enumeration.Value value = this.outputTimestampType;
            Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96, (Type.Repetition)repetition).named(field2.name());
            }
            Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS)).named(field2.name());
            }
            Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS)).named(field2.name());
            }
            throw new MatchError((Object)value);
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS)).named(field2.name());
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(field2.name());
        }
        if (dataType instanceof DecimalType) {
            bl = true;
            decimalType = (DecimalType)dataType;
            Option option4 = DecimalType.Fixed$.MODULE$.unapply(decimalType);
            if (!option4.isEmpty()) {
                int precision = ((Tuple2)option4.get())._1$mcI$sp();
                int scale = ((Tuple2)option4.get())._2$mcI$sp();
                if (this.writeLegacyParquetFormat) {
                    return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision))).length(Decimal$.MODULE$.minBytesForPrecision()[precision]).named(field2.name());
                }
            }
        }
        if (bl && !(option3 = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option3.get())._1$mcI$sp();
            int scale = ((Tuple2)option3.get())._2$mcI$sp();
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS() && !this.writeLegacyParquetFormat) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision)).named(field2.name());
            }
        }
        if (bl && !(option2 = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option2.get())._1$mcI$sp();
            int scale = ((Tuple2)option2.get())._2$mcI$sp();
            if (precision <= Decimal$.MODULE$.MAX_LONG_DIGITS() && !this.writeLegacyParquetFormat) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision)).named(field2.name());
            }
        }
        if (bl && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            if (!this.writeLegacyParquetFormat) {
                return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision))).length(Decimal$.MODULE$.minBytesForPrecision()[precision]).named(field2.name());
            }
        }
        if (dataType instanceof ArrayType) {
            bl2 = true;
            arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean bl5 = arrayType.containsNull();
            if (bl5 && this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)Types.buildGroup((Type.Repetition)Type.Repetition.REPEATED).addField(this.convertField(new StructField("array", elementType, true, StructField$.MODULE$.apply$default$4()), inShredded)).named("bag")).named(field2.name());
            }
        }
        if (bl2) {
            DataType elementType = arrayType.elementType();
            boolean bl6 = arrayType.containsNull();
            if (!bl6 && this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField(this.convertField(new StructField("array", elementType, false, StructField$.MODULE$.apply$default$4()), Type.Repetition.REPEATED, inShredded)).named(field2.name());
            }
        }
        if (dataType instanceof MapType) {
            bl3 = true;
            mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            if (this.writeLegacyParquetFormat) {
                return ConversionPatterns.mapType((Type.Repetition)repetition, (String)field2.name(), (Type)this.convertField(new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4()), inShredded), (Type)this.convertField(new StructField("value", valueType, valueContainsNull, StructField$.MODULE$.apply$default$4()), inShredded));
            }
        }
        if (bl2) {
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            if (!this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)Types.repeatedGroup().addField(this.convertField(new StructField("element", elementType, containsNull, StructField$.MODULE$.apply$default$4()), inShredded)).named("list")).named(field2.name());
            }
        }
        if (bl3) {
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.mapType())).addField((Type)Types.repeatedGroup().addField(this.convertField(new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4()), inShredded)).addField(this.convertField(new StructField("value", valueType, valueContainsNull, StructField$.MODULE$.apply$default$4()), inShredded)).named("key_value")).named(field2.name());
        }
        if (VariantType$.MODULE$.equals(dataType)) {
            return (Type)Types.buildGroup((Type.Repetition)repetition).addField(this.convertField(new StructField("value", (DataType)BinaryType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), inShredded)).addField(this.convertField(new StructField("metadata", (DataType)BinaryType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), inShredded)).named(field2.name());
        }
        if (dataType instanceof StructType) {
            bl4 = true;
            structType = (StructType)dataType;
            if (SparkShreddingUtils$.MODULE$.isVariantShreddingStruct(structType)) {
                Types.GroupBuilder group = Types.buildGroup((Type.Repetition)repetition);
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)f -> (Types.GroupBuilder)group.addField(this.convertField((StructField)f, true)));
                return (Type)group.named(field2.name());
            }
        }
        if (bl4) {
            StructField[] fields = structType.fields();
            return (Type)((Types.Builder)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Object)Types.buildGroup((Type.Repetition)repetition), (Function2 & Serializable)(builder, field) -> (Types.GroupBuilder)builder.addField(this.convertField((StructField)field, inShredded)))).named(field2.name());
        }
        if (dataType instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            DataType x$1 = userDefinedType.sqlType();
            String x$2 = field2.copy$default$1();
            boolean x$3 = field2.copy$default$3();
            Metadata x$4 = field2.copy$default$4();
            return this.convertField(field2.copy(x$2, x$1, x$3, x$4), inShredded);
        }
        throw QueryCompilationErrors$.MODULE$.cannotConvertDataTypeToParquetTypeError(field2);
    }

    public SparkToParquetSchemaConverter(boolean writeLegacyParquetFormat, Enumeration.Value outputTimestampType, boolean useFieldId) {
        this.writeLegacyParquetFormat = writeLegacyParquetFormat;
        this.outputTimestampType = outputTimestampType;
        this.useFieldId = useFieldId;
    }

    public SparkToParquetSchemaConverter(SQLConf conf) {
        this(conf.writeLegacyParquetFormat(), conf.parquetOutputTimestampType(), conf.parquetFieldIdWriteEnabled());
    }

    public SparkToParquetSchemaConverter(Configuration conf) {
        this(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))), SQLConf.ParquetOutputTimestampType$.MODULE$.withName(conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key())), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_FIELD_ID_WRITE_ENABLED().key()))));
    }
}

