/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.classic;

import java.io.Serializable;
import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.annotation.Stable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.DataSourceOptions$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.json.JacksonParser$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedDataSource;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.xml.StaxXmlParser;
import org.apache.spark.sql.catalyst.xml.XmlOptions;
import org.apache.spark.sql.catalyst.xml.XmlOptions$;
import org.apache.spark.sql.classic.ClassicConversions$;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.classic.Dataset$;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.TextInputCSVDataSource$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation$;
import org.apache.spark.sql.execution.datasources.json.JsonUtils$;
import org.apache.spark.sql.execution.datasources.json.TextInputJsonDataSource$;
import org.apache.spark.sql.execution.datasources.xml.TextInputXmlDataSource$;
import org.apache.spark.sql.execution.datasources.xml.XmlUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Stable
@ScalaSignature(bytes="\u0006\u0005\tmc\u0001B\u0015+\u0001UB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0007}\u0001!\t\u0001L \t\u000b\t\u0003A\u0011I\"\t\u000bQ\u0003A\u0011I+\t\u000bQ\u0003A\u0011I/\t\u000b\u0001\u0004A\u0011I1\t\u000b\u0001\u0004A\u0011\t4\t\u000b\u0001\u0004A\u0011I7\t\u000b\u0001\u0004A\u0011I:\t\u000be\u0004A\u0011\t>\t\re\u0004A\u0011IA\u0003\u0011\u001d\t9\u0002\u0001C!\u00033Aq!a\u0006\u0001\t\u0003\tI\u0003C\u0004\u0002\u0018\u0001!\t!a\f\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!9\u0011\u0011\n\u0001\u0005B\u0005}\u0003bBA%\u0001\u0011\u0005\u0011q\u0010\u0005\b\u0003#\u0003A\u0011IAJ\u0011\u001d\t\t\n\u0001C!\u0003/Cq!!%\u0001\t\u0003\ti\nC\u0004\u0002\u0012\u0002!\t!!2\t\u000f\u0005E\u0005\u0001\"\u0001\u0002X\"9\u00111\u001d\u0001\u0005B\u0005\u0015\bbBAr\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0003G\u0004A\u0011IAx\u0011\u001d\t)\u0010\u0001C!\u0003oDq!!>\u0001\t\u0003\nY\u0010C\u0004\u0002v\u0002!\tA!\u0001\t\u000f\t\u001d\u0001\u0001\"\u0011\u0003\n!9!q\u0001\u0001\u0005B\t5\u0001b\u0002B\n\u0001\u0011\u0005#Q\u0003\u0005\b\u0005'\u0001A\u0011\tB\r\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0005?AqA!\n\u0001\t\u0003\u00129\u0003C\u0004\u0003&\u0001!\tEa\u000b\t\u000f\tE\u0002\u0001\"\u0011\u00034!9!\u0011\u0007\u0001\u0005B\tm\u0002b\u0002B!\u0001\u0011E#1\t\u0005\b\u0005\u0017\u0002A\u0011\u000bB\"\u0011\u001d\u0011i\u0005\u0001C)\u0005\u0007\u0012q\u0002R1uC\u001a\u0013\u0018-\\3SK\u0006$WM\u001d\u0006\u0003W1\nqa\u00197bgNL7M\u0003\u0002.]\u0005\u00191/\u001d7\u000b\u0005=\u0002\u0014!B:qCJ\\'BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001mA\u0011q\u0007O\u0007\u0002Y%\u0011\u0011\u0006L\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003wqj\u0011AK\u0005\u0003{)\u0012Ab\u00159be.\u001cVm]:j_:\fa\u0001P5oSRtDC\u0001!B!\tY\u0004\u0001C\u0003:\u0005\u0001\u0007!(\u0001\u0004g_Jl\u0017\r\u001e\u000b\u0003\t\u0016k\u0011\u0001\u0001\u0005\u0006\r\u000e\u0001\raR\u0001\u0007g>,(oY3\u0011\u0005!\u000bfBA%P!\tQU*D\u0001L\u0015\taE'\u0001\u0004=e>|GO\u0010\u0006\u0002\u001d\u0006)1oY1mC&\u0011\u0001+T\u0001\u0007!J,G-\u001a4\n\u0005I\u001b&AB*ue&twM\u0003\u0002Q\u001b\u000611o\u00195f[\u0006$\"\u0001\u0012,\t\u000bQ#\u0001\u0019A,\u0011\u0005a[V\"A-\u000b\u0005ic\u0013!\u0002;za\u0016\u001c\u0018B\u0001/Z\u0005)\u0019FO];diRK\b/\u001a\u000b\u0003\tzCQaX\u0003A\u0002\u001d\u000bAb]2iK6\f7\u000b\u001e:j]\u001e\faa\u001c9uS>tGc\u0001#cI\")1M\u0002a\u0001\u000f\u0006\u00191.Z=\t\u000b\u00154\u0001\u0019A$\u0002\u000bY\fG.^3\u0015\u0007\u0011;\u0007\u000eC\u0003d\u000f\u0001\u0007q\tC\u0003f\u000f\u0001\u0007\u0011\u000e\u0005\u0002kW6\tQ*\u0003\u0002m\u001b\n9!i\\8mK\u0006tGc\u0001#o_\")1\r\u0003a\u0001\u000f\")Q\r\u0003a\u0001aB\u0011!.]\u0005\u0003e6\u0013A\u0001T8oOR\u0019A\t^;\t\u000b\rL\u0001\u0019A$\t\u000b\u0015L\u0001\u0019\u0001<\u0011\u0005)<\u0018B\u0001=N\u0005\u0019!u.\u001e2mK\u00069q\u000e\u001d;j_:\u001cHC\u0001#|\u0011\u0015I(\u00021\u0001}!\u0015i\u0018\u0011A$H\u001b\u0005q(BA@N\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004\u0003\u0007q(aA'baR\u0019A)a\u0002\t\re\\\u0001\u0019AA\u0005!\u0019\tY!!\u0006H\u000f6\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"\u0001\u0003vi&d'BAA\n\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0011QB\u0001\u0005Y>\fG\r\u0006\u0002\u0002\u001cA!\u0011QDA\u0012\u001d\rY\u0014qD\u0005\u0004\u0003CQ\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003K\t9CA\u0005ECR\fgI]1nK*\u0019\u0011\u0011\u0005\u0016\u0015\t\u0005m\u00111\u0006\u0005\u0007\u0003[i\u0001\u0019A$\u0002\tA\fG\u000f\u001b\u000b\u0005\u00037\t\t\u0004C\u0004\u000249\u0001\r!!\u000e\u0002\u000bA\fG\u000f[:\u0011\t)\f9dR\u0005\u0004\u0003si%A\u0003\u001fsKB,\u0017\r^3e}!\u001aa\"!\u0010\u0011\t\u0005}\u0012QI\u0007\u0003\u0003\u0003R1!a\u0011N\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000f\n\tEA\u0004wCJ\f'oZ:\u0002\t)$'m\u0019\u000b\t\u00037\ti%!\u0015\u0002V!1\u0011qJ\bA\u0002\u001d\u000b1!\u001e:m\u0011\u0019\t\u0019f\u0004a\u0001\u000f\u0006)A/\u00192mK\"9\u0011qK\bA\u0002\u0005e\u0013A\u00039s_B,'\u000f^5fgB!\u00111BA.\u0013\u0011\ti&!\u0004\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0006\t\u0002\u001c\u0005\u0005\u00141MA3\u0003S\ni'!\u001d\u0002|!1\u0011q\n\tA\u0002\u001dCa!a\u0015\u0011\u0001\u00049\u0005BBA4!\u0001\u0007q)\u0001\u0006d_2,XN\u001c(b[\u0016Da!a\u001b\u0011\u0001\u0004\u0001\u0018A\u00037po\u0016\u0014(i\\;oI\"1\u0011q\u000e\tA\u0002A\f!\"\u001e9qKJ\u0014u.\u001e8e\u0011\u001d\t\u0019\b\u0005a\u0001\u0003k\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bc\u00016\u0002x%\u0019\u0011\u0011P'\u0003\u0007%sG\u000fC\u0004\u0002~A\u0001\r!!\u0017\u0002)\r|gN\\3di&|g\u000e\u0015:pa\u0016\u0014H/[3t))\tY\"!!\u0002\u0004\u0006\u0015\u0015q\u0012\u0005\u0007\u0003\u001f\n\u0002\u0019A$\t\r\u0005M\u0013\u00031\u0001H\u0011\u001d\t9)\u0005a\u0001\u0003\u0013\u000b!\u0002\u001d:fI&\u001c\u0017\r^3t!\u0011Q\u00171R$\n\u0007\u00055UJA\u0003BeJ\f\u0017\u0010C\u0004\u0002~E\u0001\r!!\u0017\u0002\t)\u001cxN\u001c\u000b\u0005\u00037\t)\n\u0003\u0004\u0002.I\u0001\ra\u0012\u000b\u0005\u00037\tI\nC\u0004\u00024M\u0001\r!!\u000e)\u0007M\ti\u0004\u0006\u0003\u0002\u001c\u0005}\u0005bBAQ)\u0001\u0007\u00111U\u0001\bUN|gN\u0015#E!\u0015\t)+!,H\u001b\t\t9K\u0003\u0003\u0002\u0014\u0005%&bAAV]\u0005\u0019\u0011\r]5\n\t\u0005=\u0016q\u0015\u0002\b\u0015\u00064\u0018M\u0015#EQ-!\u00121WA]\u0003w\u000by,!1\u0011\u0007)\f),C\u0002\u000286\u0013!\u0002Z3qe\u0016\u001c\u0017\r^3e\u0003\u001diWm]:bO\u0016\f#!!0\u0002EU\u001bX\r\t6t_:DC)\u0019;bg\u0016$8l\u0015;sS:<W,\u000b\u0011j]N$X-\u00193/\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019-A\u00033]Ir\u0003\u0007\u0006\u0003\u0002\u001c\u0005\u001d\u0007bBAQ+\u0001\u0007\u0011\u0011\u001a\t\u0006\u0003\u0017\f\tnR\u0007\u0003\u0003\u001bT1!a4/\u0003\r\u0011H\rZ\u0005\u0005\u0003'\fiMA\u0002S\t\u0012C3\"FAZ\u0003s\u000bY,a0\u0002BR!\u00111DAm\u0011\u001d\tYN\u0006a\u0001\u0003;\f1B[:p]\u0012\u000bG/Y:fiB!q'a8H\u0013\r\t\t\u000f\f\u0002\b\t\u0006$\u0018m]3u\u0003\r\u00197O\u001e\u000b\u0005\u00037\t9\u000f\u0003\u0004\u0002.]\u0001\ra\u0012\u000b\u0005\u00037\tY\u000fC\u0004\u0002nb\u0001\r!!8\u0002\u0015\r\u001ch\u000fR1uCN,G\u000f\u0006\u0003\u0002\u001c\u0005E\bbBA\u001a3\u0001\u0007\u0011Q\u0007\u0015\u00043\u0005u\u0012a\u0001=nYR!\u00111DA}\u0011\u0019\tiC\u0007a\u0001\u000fR!\u00111DA\u007f\u0011\u001d\t\u0019d\u0007a\u0001\u0003kA3aGA\u001f)\u0011\tYBa\u0001\t\u000f\t\u0015A\u00041\u0001\u0002^\u0006Q\u00010\u001c7ECR\f7/\u001a;\u0002\u000fA\f'/];fiR!\u00111\u0004B\u0006\u0011\u0019\ti#\ba\u0001\u000fR!\u00111\u0004B\b\u0011\u001d\t\u0019D\ba\u0001\u0003kA3AHA\u001f\u0003\ry'o\u0019\u000b\u0005\u00037\u00119\u0002\u0003\u0004\u0002.}\u0001\ra\u0012\u000b\u0005\u00037\u0011Y\u0002C\u0004\u00024\u0001\u0002\r!!\u000e)\u0007\u0001\ni\u0004\u0006\u0003\u0002\u001c\t\u0005\u0002B\u0002B\u0012C\u0001\u0007q)A\u0005uC\ndWMT1nK\u0006!A/\u001a=u)\u0011\tYB!\u000b\t\r\u00055\"\u00051\u0001H)\u0011\tYB!\f\t\u000f\u0005M2\u00051\u0001\u00026!\u001a1%!\u0010\u0002\u0011Q,\u0007\u0010\u001e$jY\u0016$BA!\u000e\u0003:A!1Ha\u000eH\u0013\r\t\tO\u000b\u0005\u0007\u0003[!\u0003\u0019A$\u0015\t\tU\"Q\b\u0005\b\u0003g)\u0003\u0019AA\u001bQ\r)\u0013QH\u0001\u001cm\u0006d\u0017\u000eZ1uKNKgn\u001a7f-\u0006\u0014\u0018.\u00198u\u0007>dW/\u001c8\u0015\u0005\t\u0015\u0003c\u00016\u0003H%\u0019!\u0011J'\u0003\tUs\u0017\u000e^\u0001\u0013m\u0006d\u0017\u000eZ1uK*\u001bxN\\*dQ\u0016l\u0017-A\twC2LG-\u0019;f16d7k\u00195f[\u0006D3\u0001\u0001B)!\u0011\u0011\u0019Fa\u0016\u000e\u0005\tU#bAA\"]%!!\u0011\fB+\u0005\u0019\u0019F/\u00192mK\u0002")
public class DataFrameReader
extends org.apache.spark.sql.DataFrameReader {
    private final SparkSession sparkSession;

    public Dataset<Row> load(String ... paths) {
        return this.load((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> json(String ... paths) {
        return this.json((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> csv(String ... paths) {
        return this.csv((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> xml(String ... paths) {
        return this.xml((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> parquet(String ... paths) {
        return this.parquet((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> orc(String ... paths) {
        return this.orc((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> text(String ... paths) {
        return this.text((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<String> textFile(String ... paths) {
        return this.textFile((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrameReader format(String source) {
        return (DataFrameReader)super.format(source);
    }

    public DataFrameReader schema(StructType schema) {
        return (DataFrameReader)super.schema(schema);
    }

    public DataFrameReader schema(String schemaString) {
        return (DataFrameReader)super.schema(schemaString);
    }

    public DataFrameReader option(String key, String value) {
        return (DataFrameReader)super.option(key, value);
    }

    public DataFrameReader option(String key, boolean value) {
        return (DataFrameReader)super.option(key, value);
    }

    public DataFrameReader option(String key, long value) {
        return (DataFrameReader)super.option(key, value);
    }

    public DataFrameReader option(String key, double value) {
        return (DataFrameReader)super.option(key, value);
    }

    public DataFrameReader options(Map<String, String> options) {
        return (DataFrameReader)super.options(options);
    }

    public DataFrameReader options(java.util.Map<String, String> options) {
        return (DataFrameReader)super.options(options);
    }

    public Dataset<Row> load() {
        return this.load((Seq)Nil$.MODULE$);
    }

    public Dataset<Row> load(String path) {
        if (this.sparkSession.sessionState().conf().legacyPathOptionBehavior()) {
            return this.option("path", path).load((Seq)package$.MODULE$.Seq().empty());
        }
        return this.load((Seq)new .colon.colon((Object)path, (List)Nil$.MODULE$));
    }

    public Dataset<Row> load(Seq<String> paths) {
        return Dataset$.MODULE$.ofRows(this.sparkSession, new UnresolvedDataSource(this.source(), (Option<StructType>)this.userSpecifiedSchema(), (CaseInsensitiveMap<String>)this.extraOptions(), false, paths));
    }

    public Dataset<Row> jdbc(String url, String table, Properties properties) {
        return ClassicConversions$.MODULE$.castToImpl(super.jdbc(url, table, properties));
    }

    public Dataset<Row> jdbc(String url, String table, String columnName, long lowerBound, long upperBound, int numPartitions, Properties connectionProperties) {
        return ClassicConversions$.MODULE$.castToImpl(super.jdbc(url, table, columnName, lowerBound, upperBound, numPartitions, connectionProperties));
    }

    public Dataset<Row> jdbc(String url, String table, String[] predicates, Properties connectionProperties) {
        this.assertNoSpecifiedSchema("jdbc");
        CaseInsensitiveMap params = this.extraOptions().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.PropertiesHasAsScala(connectionProperties).asScala());
        JDBCOptions options = new JDBCOptions(url, table, (scala.collection.immutable.Map<String, String>)params);
        Partition[] parts = (Partition[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])predicates))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String part = (String)tuple2._1();
                int i = tuple2._2$mcI$sp();
                return new JDBCPartition(part, i);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Partition.class));
        JDBCRelation relation = JDBCRelation$.MODULE$.apply(parts, options, this.sparkSession);
        return this.sparkSession.baseRelationToDataFrame(relation);
    }

    public Dataset<Row> json(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.json(path));
    }

    public Dataset<Row> json(Seq<String> paths) {
        return ClassicConversions$.MODULE$.castToImpl(super.json(paths));
    }

    public Dataset<Row> json(JavaRDD<String> jsonRDD) {
        return this.json(jsonRDD.rdd());
    }

    public Dataset<Row> json(RDD<String> jsonRDD) {
        return this.json(this.sparkSession.createDataset((RDD)jsonRDD, Encoders$.MODULE$.STRING()));
    }

    public Dataset<Row> json(org.apache.spark.sql.Dataset<String> jsonDataset) {
        JSONOptions parsedOptions = new JSONOptions(this.extraOptions().toMap(), this.sparkSession.sessionState().conf().sessionLocalTimeZone(), this.sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            JsonUtils$.MODULE$.checkJsonSchema(schema);
            return BoxedUnit.UNIT;
        });
        StructType schema2 = (StructType)this.userSpecifiedSchema().map((Function1 & Serializable)x0$1 -> {
            StructType structType = x0$1;
            if (!BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_RESPECT_NULLABILITY_IN_TEXT_DATASET_CONVERSION()))) {
                return structType.asNullable();
            }
            return structType;
        }).getOrElse((Function0 & Serializable)() -> TextInputJsonDataSource$.MODULE$.inferFromDataset(jsonDataset, parsedOptions));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(schema2, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema2.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$json$4(parsedOptions, x$1))));
        Function2 & Serializable createParser = (Function2 & Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.string(jsonFactory, record);
        RDD qual$1 = jsonDataset.rdd();
        Function1 & Serializable x$12 = (Function1 & Serializable)iter -> {
            JacksonParser rawParser = new JacksonParser((DataType)actualSchema, parsedOptions, true, JacksonParser$.MODULE$.$lessinit$greater$default$4());
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable)x$1 -> UTF8String.fromString((String)x$1)), parsedOptions.parseMode(), schema2, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable)input -> parser.parse(input));
        };
        boolean x$2 = qual$1.mapPartitions$default$2();
        RDD parsed = qual$1.mapPartitions((Function1)x$12, x$2, ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema2, jsonDataset.isStreaming());
    }

    public Dataset<Row> csv(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.csv(path));
    }

    public Dataset<Row> csv(org.apache.spark.sql.Dataset<String> csvDataset) {
        CSVOptions parsedOptions = new CSVOptions(this.extraOptions().toMap(), this.sparkSession.sessionState().conf().csvColumnPruning(), this.sparkSession.sessionState().conf().sessionLocalTimeZone());
        Dataset<String> filteredLines = ClassicConversions$.MODULE$.castToImpl(CSVUtils$.MODULE$.filterCommentAndEmpty(csvDataset, parsedOptions));
        None$ maybeFirstLine = this.userSpecifiedSchema().isEmpty() || parsedOptions.headerFlag() ? ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])filteredLines.take(1))) : None$.MODULE$;
        StructType schema = (StructType)this.userSpecifiedSchema().map((Function1 & Serializable)x0$1 -> {
            StructType structType = x0$1;
            if (!BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_RESPECT_NULLABILITY_IN_TEXT_DATASET_CONVERSION()))) {
                return structType.asNullable();
            }
            return structType;
        }).getOrElse(() -> DataFrameReader.$anonfun$csv$2(this, csvDataset, (Option)maybeFirstLine, parsedOptions));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$csv$3(parsedOptions, x$2))));
        RDD linesWithoutHeader = (RDD)maybeFirstLine.map((Function1 & Serializable)firstLine -> {
            CSVHeaderChecker headerChecker = new CSVHeaderChecker(actualSchema, parsedOptions, "CSV source: " + csvDataset, CSVHeaderChecker$.MODULE$.$lessinit$greater$default$4());
            headerChecker.checkHeaderColumnNames(firstLine);
            return filteredLines.rdd().mapPartitions((Function1 & Serializable)x$3 -> CSVUtils$.MODULE$.filterHeaderLine((Iterator<String>)x$3, (String)firstLine, parsedOptions), filteredLines.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(String.class));
        }).getOrElse((Function0 & Serializable)() -> filteredLines.rdd());
        RDD parsed = linesWithoutHeader.mapPartitions((Function1 & Serializable)iter -> {
            UnivocityParser rawParser = new UnivocityParser(actualSchema, parsedOptions);
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable)input -> Option$.MODULE$.option2Iterable((Option)rawParser.parse().apply(input)), parsedOptions.parseMode(), schema, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable)input -> parser.parse(input));
        }, linesWithoutHeader.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema, csvDataset.isStreaming());
    }

    public Dataset<Row> csv(Seq<String> paths) {
        return ClassicConversions$.MODULE$.castToImpl(super.csv(paths));
    }

    public Dataset<Row> xml(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.xml(path));
    }

    public Dataset<Row> xml(Seq<String> paths) {
        return ClassicConversions$.MODULE$.castToImpl(super.xml(paths));
    }

    public Dataset<Row> xml(org.apache.spark.sql.Dataset<String> xmlDataset) {
        XmlOptions parsedOptions = new XmlOptions(this.extraOptions().toMap(), this.sparkSession.sessionState().conf().sessionLocalTimeZone(), this.sparkSession.sessionState().conf().columnNameOfCorruptRecord(), XmlOptions$.MODULE$.$lessinit$greater$default$4());
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            XmlUtils$.MODULE$.checkXmlSchema(schema);
            return BoxedUnit.UNIT;
        });
        StructType schema2 = (StructType)this.userSpecifiedSchema().map((Function1 & Serializable)x0$1 -> {
            StructType structType = x0$1;
            if (!BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_RESPECT_NULLABILITY_IN_TEXT_DATASET_CONVERSION()))) {
                return structType.asNullable();
            }
            return structType;
        }).getOrElse((Function0 & Serializable)() -> TextInputXmlDataSource$.MODULE$.inferFromDataset(xmlDataset, parsedOptions));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(schema2, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema2.filterNot((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$xml$4(parsedOptions, x$4))));
        RDD qual$1 = xmlDataset.rdd();
        Function1 & Serializable x$1 = (Function1 & Serializable)iter -> {
            StaxXmlParser rawParser = new StaxXmlParser(actualSchema, parsedOptions);
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable)input -> Option$.MODULE$.option2Iterable((Option)rawParser.parse().apply(input)), parsedOptions.parseMode(), schema2, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable)input -> parser.parse(input));
        };
        boolean x$2 = qual$1.mapPartitions$default$2();
        RDD parsed = qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema2, xmlDataset.isStreaming());
    }

    public Dataset<Row> parquet(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.parquet(path));
    }

    public Dataset<Row> parquet(Seq<String> paths) {
        return ClassicConversions$.MODULE$.castToImpl(super.parquet(paths));
    }

    public Dataset<Row> orc(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.orc(path));
    }

    public Dataset<Row> orc(Seq<String> paths) {
        return ClassicConversions$.MODULE$.castToImpl(super.orc(paths));
    }

    public Dataset<Row> table(String tableName) {
        this.assertNoSpecifiedSchema("table");
        Seq multipartIdentifier = this.sparkSession.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new UnresolvedRelation(multipartIdentifier, new CaseInsensitiveStringMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)this.extraOptions().toMap()).asJava()), UnresolvedRelation$.MODULE$.apply$default$3()));
    }

    public Dataset<Row> text(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.text(path));
    }

    public Dataset<Row> text(Seq<String> paths) {
        return ClassicConversions$.MODULE$.castToImpl(super.text(paths));
    }

    public Dataset<String> textFile(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.textFile(path));
    }

    public Dataset<String> textFile(Seq<String> paths) {
        return ClassicConversions$.MODULE$.castToImpl(super.textFile(paths));
    }

    public void validateSingleVariantColumn() {
        if (this.extraOptions().get(DataSourceOptions$.MODULE$.SINGLE_VARIANT_COLUMN()).isDefined() && this.userSpecifiedSchema().isDefined()) {
            throw QueryCompilationErrors$.MODULE$.invalidSingleVariantColumn();
        }
    }

    public void validateJsonSchema() {
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            JsonUtils$.MODULE$.checkJsonSchema(schema);
            return BoxedUnit.UNIT;
        });
    }

    public void validateXmlSchema() {
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            XmlUtils$.MODULE$.checkXmlSchema(schema);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$json$4(JSONOptions parsedOptions$1, StructField x$1) {
        String string = x$1.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ StructType $anonfun$csv$2(DataFrameReader $this, org.apache.spark.sql.Dataset csvDataset$1, Option maybeFirstLine$1, CSVOptions parsedOptions$2) {
        return TextInputCSVDataSource$.MODULE$.inferFromDataset($this.sparkSession, (org.apache.spark.sql.Dataset<String>)csvDataset$1, (Option<String>)maybeFirstLine$1, parsedOptions$2);
    }

    public static final /* synthetic */ boolean $anonfun$csv$3(CSVOptions parsedOptions$2, StructField x$2) {
        String string = x$2.name();
        String string2 = parsedOptions$2.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$xml$4(XmlOptions parsedOptions$3, StructField x$4) {
        String string = x$4.name();
        String string2 = parsedOptions$3.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public DataFrameReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        this.format(sparkSession.sessionState().conf().defaultDataSourceName());
    }
}

