/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.ImplicitGroupingKeyTracker$;
import org.apache.spark.sql.execution.streaming.TimerKeyEncoder;
import org.apache.spark.sql.execution.streaming.TimerStateUtils$;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.RangeKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.streaming.TimeMode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.NextIterator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001B\u000f\u001f\u0001-B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"AQ\t\u0001B\u0001B\u0003%a\tC\u0003R\u0001\u0011\u0005!\u000bC\u0004Y\u0001\t\u0007I\u0011B-\t\r\u0001\u0004\u0001\u0015!\u0003[\u0011\u001d\t\u0007A1A\u0005\n\tDa!\u001b\u0001!\u0002\u0013\u0019\u0007b\u00026\u0001\u0005\u0004%Ia\u001b\u0005\u0007i\u0002\u0001\u000b\u0011\u00027\t\u000fU\u0004!\u0019!C\u0005m\"1!\u0010\u0001Q\u0001\n]Dqa\u001f\u0001C\u0002\u0013%!\r\u0003\u0004}\u0001\u0001\u0006Ia\u0019\u0005\b{\u0002\u0011\r\u0011\"\u0003l\u0011\u0019q\b\u0001)A\u0005Y\"9q\u0010\u0001b\u0001\n\u0013\u0011\u0007bBA\u0001\u0001\u0001\u0006Ia\u0019\u0005\t\u0003\u0007\u0001!\u0019!C\u0005W\"9\u0011Q\u0001\u0001!\u0002\u0013a\u0007bBA\u0004\u0001\u0011%\u0011\u0011\u0002\u0005\b\u0003G\u0001A\u0011BA\u0013\u0011\u001d\tY\u0004\u0001C\u0005\u0003{Aq!a\u0011\u0001\t\u0003\t)\u0005C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u00111\u000e\u0001\u0005\n\u00055\u0004bBA=\u0001\u0011\u0005\u00111\u0010\u0002\u000f)&lWM]*uCR,\u0017*\u001c9m\u0015\ty\u0002%A\u0005tiJ,\u0017-\\5oO*\u0011\u0011EI\u0001\nKb,7-\u001e;j_:T!a\t\u0013\u0002\u0007M\fHN\u0003\u0002&M\u0005)1\u000f]1sW*\u0011q\u0005K\u0001\u0007CB\f7\r[3\u000b\u0003%\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u00173!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0019\te.\u001f*fMB\u00111GN\u0007\u0002i)\u0011Q\u0007J\u0001\tS:$XM\u001d8bY&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h\u0003\u0015\u0019Ho\u001c:f!\tQT(D\u0001<\u0015\tad$A\u0003ti\u0006$X-\u0003\u0002?w\tQ1\u000b^1uKN#xN]3\u0002\u0011QLW.Z'pI\u0016\u0004\"!Q\"\u000e\u0003\tS!a\b\u0012\n\u0005\u0011\u0013%\u0001\u0003+j[\u0016lu\u000eZ3\u0002\u0015-,\u00170\u0012=qe\u0016s7\rE\u0002H\u0019:k\u0011\u0001\u0013\u0006\u0003\u0013*\u000b\u0001\"\u001a8d_\u0012,'o\u001d\u0006\u0003\u0017\n\n\u0001bY1uC2L8\u000f^\u0005\u0003\u001b\"\u0013\u0011#\u0012=qe\u0016\u001c8/[8o\u000b:\u001cw\u000eZ3s!\tis*\u0003\u0002Q]\t\u0019\u0011I\\=\u0002\rqJg.\u001b;?)\u0011\u0019VKV,\u0011\u0005Q\u0003Q\"\u0001\u0010\t\u000ba\"\u0001\u0019A\u001d\t\u000b}\"\u0001\u0019\u0001!\t\u000b\u0015#\u0001\u0019\u0001$\u0002\u0013\u0015k\u0005\u000bV-`%>;V#\u0001.\u0011\u0005msV\"\u0001/\u000b\u0005uS\u0015aC3yaJ,7o]5p]NL!a\u0018/\u0003\u0013Us7/\u00194f%><\u0018AC#N!RKvLU(XA\u0005\t2o\u00195f[\u00064uN\u001d,bYV,'k\\<\u0016\u0003\r\u0004\"\u0001Z4\u000e\u0003\u0015T!A\u001a\u0012\u0002\u000bQL\b/Z:\n\u0005!,'AC*ueV\u001cG\u000fV=qK\u0006\u00112o\u00195f[\u00064uN\u001d,bYV,'k\\<!\u0003-!\u0018.\\3s\u0007\u001as\u0015-\\3\u0016\u00031\u0004\"!\u001c:\u000e\u00039T!a\u001c9\u0002\t1\fgn\u001a\u0006\u0002c\u0006!!.\u0019<b\u0013\t\u0019hN\u0001\u0004TiJLgnZ\u0001\ri&lWM]\"G\u001d\u0006lW\rI\u0001\u000be><XI\\2pI\u0016\u0014X#A<\u0011\u0005QC\u0018BA=\u001f\u0005=!\u0016.\\3s\u0017\u0016LXI\\2pI\u0016\u0014\u0018a\u0003:po\u0016s7m\u001c3fe\u0002\nqb]2iK6\fgi\u001c:LKf\u0014vn^\u0001\u0011g\u000eDW-\\1G_J\\U-\u001f*po\u0002\nQb[3z)>$6o\u0011$OC6,\u0017AD6fsR{Gk]\"G\u001d\u0006lW\rI\u0001\u0015W\u0016L8k\u00195f[\u00064uN]*fG&sG-\u001a=\u0002+-,\u0017pU2iK6\fgi\u001c:TK\u000eLe\u000eZ3yA\u0005iAo\u001d+p\u0017\u0016L8I\u0012(b[\u0016\fa\u0002^:U_.+\u0017p\u0011$OC6,\u0007%\u0001\bhKR<%o\\;qS:<7*Z=\u0015\u00079\u000bY\u0001C\u0004\u0002\u000eU\u0001\r!a\u0004\u0002\r\r4g*Y7f!\u0011\t\t\"a\b\u000f\t\u0005M\u00111\u0004\t\u0004\u0003+qSBAA\f\u0015\r\tIBK\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005ua&\u0001\u0004Qe\u0016$WMZ\u0005\u0004g\u0006\u0005\"bAA\u000f]\u00051Q\r_5tiN$b!a\n\u0002.\u0005E\u0002cA\u0017\u0002*%\u0019\u00111\u0006\u0018\u0003\u000f\t{w\u000e\\3b]\"1\u0011q\u0006\fA\u00029\u000b1b\u001a:pkBLgnZ&fs\"9\u00111\u0007\fA\u0002\u0005U\u0012!E3ya&\u0014\u0018\u0010V5nKN$\u0018-\u001c9NgB\u0019Q&a\u000e\n\u0007\u0005ebF\u0001\u0003M_:<\u0017aB4fi&k\u0007\u000f\u001c\u000b\u00065\u0006}\u0012\u0011\t\u0005\u0007\u0003_9\u0002\u0019\u0001(\t\u000f\u0005Mr\u00031\u0001\u00026\u0005i!/Z4jgR,'\u000fV5nKJ$B!a\u0012\u0002NA\u0019Q&!\u0013\n\u0007\u0005-cF\u0001\u0003V]&$\bbBA\u001a1\u0001\u0007\u0011QG\u0001\fI\u0016dW\r^3US6,'\u000f\u0006\u0003\u0002H\u0005M\u0003bBA\u001a3\u0001\u0007\u0011QG\u0001\u000bY&\u001cH\u000fV5nKJ\u001cHCAA-!\u0019\tY&!\u001a\u000269!\u0011QLA1\u001d\u0011\t)\"a\u0018\n\u0003=J1!a\u0019/\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001a\u0002j\tA\u0011\n^3sCR|'OC\u0002\u0002d9\nqcZ3u)&lWM\u001d*po\u001a\u0013x.\\*fG&sG-\u001a=\u0015\t\u0005=\u0014Q\u000f\t\u0007[\u0005Ed*!\u000e\n\u0007\u0005MdF\u0001\u0004UkBdWM\r\u0005\u0007\u0003oZ\u0002\u0019\u0001.\u0002\r-,\u0017PU8x\u0003A9W\r^#ya&\u0014X\r\u001a+j[\u0016\u00148\u000f\u0006\u0003\u0002~\u0005}\u0004CBA.\u0003K\ny\u0007C\u0004\u00024q\u0001\r!!\u000e")
public class TimerStateImpl
implements Logging {
    private final StateStore store;
    private final ExpressionEncoder<Object> keyExprEnc;
    private final UnsafeRow EMPTY_ROW;
    private final StructType schemaForValueRow;
    private final String timerCFName;
    private final TimerKeyEncoder rowEncoder;
    private final StructType schemaForKeyRow;
    private final String keyToTsCFName;
    private final StructType keySchemaForSecIndex;
    private final String tsToKeyCFName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private UnsafeRow EMPTY_ROW() {
        return this.EMPTY_ROW;
    }

    private StructType schemaForValueRow() {
        return this.schemaForValueRow;
    }

    private String timerCFName() {
        return this.timerCFName;
    }

    private TimerKeyEncoder rowEncoder() {
        return this.rowEncoder;
    }

    private StructType schemaForKeyRow() {
        return this.schemaForKeyRow;
    }

    private String keyToTsCFName() {
        return this.keyToTsCFName;
    }

    private StructType keySchemaForSecIndex() {
        return this.keySchemaForSecIndex;
    }

    private String tsToKeyCFName() {
        return this.tsToKeyCFName;
    }

    private Object getGroupingKey(String cfName) {
        Option<Object> keyOption = ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption();
        if (keyOption.isEmpty()) {
            throw StateStoreErrors$.MODULE$.implicitKeyNotFound(cfName);
        }
        return keyOption.get();
    }

    private boolean exists(Object groupingKey, long expiryTimestampMs) {
        return this.getImpl(groupingKey, expiryTimestampMs) != null;
    }

    private UnsafeRow getImpl(Object groupingKey, long expiryTimestampMs) {
        return this.store.get(this.rowEncoder().encodedKey(groupingKey, expiryTimestampMs), this.keyToTsCFName());
    }

    public void registerTimer(long expiryTimestampMs) {
        Object groupingKey = this.getGroupingKey(this.keyToTsCFName());
        if (this.exists(groupingKey, expiryTimestampMs)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to register timer for key=", " and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.KEY$.MODULE$, groupingKey)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp=", " ms since it already exists"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXPIRY_TIMESTAMP$.MODULE$, (Object)BoxesRunTime.boxToLong((long)expiryTimestampMs))})))));
            return;
        }
        this.store.put(this.rowEncoder().encodedKey(groupingKey, expiryTimestampMs), this.EMPTY_ROW(), this.keyToTsCFName());
        this.store.put(this.rowEncoder().encodeSecIndexKey(groupingKey, expiryTimestampMs), this.EMPTY_ROW(), this.tsToKeyCFName());
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Registered timer for key=" + groupingKey + " and timestamp=" + expiryTimestampMs);
    }

    public void deleteTimer(long expiryTimestampMs) {
        Object groupingKey = this.getGroupingKey(this.keyToTsCFName());
        if (!this.exists(groupingKey, expiryTimestampMs)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete timer for key=", " and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.KEY$.MODULE$, groupingKey)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp=", " ms since it does not exist"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXPIRY_TIMESTAMP$.MODULE$, (Object)BoxesRunTime.boxToLong((long)expiryTimestampMs))})))));
            return;
        }
        this.store.remove(this.rowEncoder().encodedKey(groupingKey, expiryTimestampMs), this.keyToTsCFName());
        this.store.remove(this.rowEncoder().encodeSecIndexKey(groupingKey, expiryTimestampMs), this.tsToKeyCFName());
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Deleted timer for key=" + groupingKey + " and timestamp=" + expiryTimestampMs);
    }

    public Iterator<Object> listTimers() {
        Object groupingKey = this.getGroupingKey(this.keyToTsCFName());
        UnsafeRow encodedGroupingKey = this.rowEncoder().encodePrefixKey(groupingKey);
        Iterator<UnsafeRowPair> iter = this.store.prefixScan(encodedGroupingKey, this.keyToTsCFName());
        return iter.map((Function1 & Serializable)kv -> BoxesRunTime.boxToLong((long)TimerStateImpl.$anonfun$listTimers$1(kv)));
    }

    public Tuple2<Object, Object> org$apache$spark$sql$execution$streaming$TimerStateImpl$$getTimerRowFromSecIndex(UnsafeRow keyRow) {
        UnsafeRow retUnsafeRow = keyRow.getStruct(1, this.keyExprEnc.schema().length());
        Object keyObj = this.rowEncoder().decodePrefixKey(retUnsafeRow);
        long expiryTimestampMs = keyRow.getLong(0);
        return new Tuple2(keyObj, (Object)BoxesRunTime.boxToLong((long)expiryTimestampMs));
    }

    public Iterator<Tuple2<Object, Object>> getExpiredTimers(long expiryTimestampMs) {
        Iterator<UnsafeRowPair> iter = this.store.iterator(this.tsToKeyCFName());
        return new NextIterator<Tuple2<Object, Object>>(this, iter, expiryTimestampMs){
            private final /* synthetic */ TimerStateImpl $outer;
            private final Iterator iter$1;
            private final long expiryTimestampMs$3;

            public Tuple2<Object, Object> getNext() {
                if (this.iter$1.hasNext()) {
                    UnsafeRowPair rowPair = (UnsafeRowPair)this.iter$1.next();
                    UnsafeRow keyRow = rowPair.key();
                    Tuple2<Object, Object> result = this.$outer.org$apache$spark$sql$execution$streaming$TimerStateImpl$$getTimerRowFromSecIndex(keyRow);
                    if (result._2$mcJ$sp() <= this.expiryTimestampMs$3) {
                        return result;
                    }
                    this.finished_$eq(true);
                    return null;
                }
                this.finished_$eq(true);
                return null;
            }

            public void close() {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.iter$1 = iter$1;
                this.expiryTimestampMs$3 = expiryTimestampMs$3;
            }
        };
    }

    public static final /* synthetic */ long $anonfun$listTimers$1(UnsafeRowPair kv) {
        UnsafeRow keyRow = kv.key();
        return keyRow.getLong(1);
    }

    public TimerStateImpl(StateStore store, TimeMode timeMode, ExpressionEncoder<Object> keyExprEnc) {
        this.store = store;
        this.keyExprEnc = keyExprEnc;
        Logging.$init$((Logging)this);
        this.EMPTY_ROW = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{NullType$.MODULE$})).apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
        this.schemaForValueRow = new StructType((StructField[])((Object[])new StructField[]{new StructField("__dummy__", (DataType)NullType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
        TimeMode timeMode2 = timeMode;
        TimeMode timeMode3 = TimeMode.ProcessingTime();
        this.timerCFName = !(timeMode2 != null ? !timeMode2.equals(timeMode3) : timeMode3 != null) ? TimerStateUtils$.MODULE$.PROC_TIMERS_STATE_NAME() : TimerStateUtils$.MODULE$.EVENT_TIMERS_STATE_NAME();
        this.rowEncoder = new TimerKeyEncoder(keyExprEnc);
        this.schemaForKeyRow = this.rowEncoder().schemaForKeyRow();
        this.keyToTsCFName = this.timerCFName() + TimerStateUtils$.MODULE$.KEY_TO_TIMESTAMP_CF();
        store.createColFamilyIfAbsent(this.keyToTsCFName(), this.schemaForKeyRow(), this.schemaForValueRow(), new PrefixKeyScanStateEncoderSpec(this.schemaForKeyRow(), 1), false, true);
        this.keySchemaForSecIndex = this.rowEncoder().keySchemaForSecIndex();
        this.tsToKeyCFName = this.timerCFName() + TimerStateUtils$.MODULE$.TIMESTAMP_TO_KEY_CF();
        store.createColFamilyIfAbsent(this.tsToKeyCFName(), this.keySchemaForSecIndex(), this.schemaForValueRow(), new RangeKeyScanStateEncoderSpec(this.keySchemaForSecIndex(), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))), false, true);
    }
}

