/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.streaming.CompositeKeyStateEncoder;
import org.apache.spark.sql.execution.streaming.MapStateImplWithTTL$;
import org.apache.spark.sql.execution.streaming.OneToOneTTLState;
import org.apache.spark.sql.execution.streaming.StateTTL$;
import org.apache.spark.sql.execution.streaming.TTLState;
import org.apache.spark.sql.execution.streaming.TWSMetricsUtils$;
import org.apache.spark.sql.execution.streaming.TransformWithStateKeyValueRowSchemaUtils$;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.streaming.MapState;
import org.apache.spark.sql.streaming.TTLConfig;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.NextIterator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001B\r\u001b\u0001\u001dB\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t!\u0002\u0011\t\u0011)A\u0005#\"AA\f\u0001B\u0001B\u0003%Q\f\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003^\u0011!1\u0007A!A!\u0002\u0013i\u0006\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u0011-\u0004!\u0011!Q\u0001\n1D\u0001b\u001c\u0001\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\u0006s\u0002!\tA\u001f\u0005\n\u0003\u0013\u0001!\u0019!C\u0005\u0003\u0017A\u0001\"a\u0005\u0001A\u0003%\u0011Q\u0002\u0005\b\u0003+\u0001A\u0011BA\f\u0011\u001d\ty\u0002\u0001C!\u0003CAq!!\u000b\u0001\t\u0003\nY\u0003C\u0004\u00022\u0001!\t%a\r\t\u000f\u0005]\u0002\u0001\"\u0011\u0002:!9\u0011\u0011\t\u0001\u0005B\u0005\r\u0003bBA/\u0001\u0011\u0005\u0013q\f\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\tI\u0007\u0001C!\u0003WBq!a\u001c\u0001\t\u0003\n9\u0002\u0003\u0005\u0002r\u0001!\tAHA:\u0011!\ty\b\u0001C\u0001=\u0005\u0005\u0005\u0002CAE\u0001\u0011\u0005a$a#\u0003'5\u000b\u0007o\u0015;bi\u0016LU\u000e\u001d7XSRDG\u000b\u0016'\u000b\u0005ma\u0012!C:ue\u0016\fW.\u001b8h\u0015\tib$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0004I\u0001\u0004gFd'BA\u0011#\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\u0004\u0001U\u0019\u0001\u0006N!\u0014\t\u0001ISf\u0011\t\u0003U-j\u0011AG\u0005\u0003Yi\u0011\u0001c\u00148f)>|e.\u001a+U\u0019N#\u0018\r^3\u0011\t9\u0002$\u0007Q\u0007\u0002_)\u00111DH\u0005\u0003c=\u0012\u0001\"T1q'R\fG/\u001a\t\u0003gQb\u0001\u0001B\u00036\u0001\t\u0007aGA\u0001L#\t9T\b\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014HA\u0004O_RD\u0017N\\4\u0011\u0005ar\u0014BA :\u0005\r\te.\u001f\t\u0003g\u0005#QA\u0011\u0001C\u0002Y\u0012\u0011A\u0016\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r\u0002\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0011\u0016\u0013q\u0001T8hO&tw-A\u0003ti>\u0014X\r\u0005\u0002L\u001d6\tAJ\u0003\u0002N5\u0005)1\u000f^1uK&\u0011q\n\u0014\u0002\u000b'R\fG/Z*u_J,\u0017!C:uCR,g*Y7f!\t\u0011\u0016L\u0004\u0002T/B\u0011A+O\u0007\u0002+*\u0011aKJ\u0001\u0007yI|w\u000e\u001e \n\u0005aK\u0014A\u0002)sK\u0012,g-\u0003\u0002[7\n11\u000b\u001e:j]\u001eT!\u0001W\u001d\u0002\u0015-,\u00170\u0012=qe\u0016s7\rE\u0002_Gvj\u0011a\u0018\u0006\u0003A\u0006\f\u0001\"\u001a8d_\u0012,'o\u001d\u0006\u0003Ez\t\u0001bY1uC2L8\u000f^\u0005\u0003I~\u0013\u0011#\u0012=qe\u0016\u001c8/[8o\u000b:\u001cw\u000eZ3s\u0003))8/\u001a:LKf,enY\u0001\u000bm\u0006dWI\\2pI\u0016\u0014\u0018!\u0003;uY\u000e{gNZ5h!\tq\u0013.\u0003\u0002k_\tIA\u000b\u0016'D_:4\u0017nZ\u0001\u0011E\u0006$8\r\u001b+j[\u0016\u001cH/Y7q\u001bN\u0004\"\u0001O7\n\u00059L$\u0001\u0002'p]\u001e\fq!\\3ue&\u001c7\u000f\u0005\u0003ScF\u001b\u0018B\u0001:\\\u0005\ri\u0015\r\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003mr\ta!\\3ue&\u001c\u0017B\u0001=v\u0005%\u0019\u0016\u000bT'fiJL7-\u0001\u0004=S:LGO\u0010\u000b\u000ewrlhp`A\u0001\u0003\u0007\t)!a\u0002\u0011\t)\u0002!\u0007\u0011\u0005\u0006\u0013&\u0001\rA\u0013\u0005\u0006!&\u0001\r!\u0015\u0005\u00069&\u0001\r!\u0018\u0005\u0006K&\u0001\r!\u0018\u0005\u0006M&\u0001\r!\u0018\u0005\u0006O&\u0001\r\u0001\u001b\u0005\u0006W&\u0001\r\u0001\u001c\u0005\u0006_&\u0001\r\u0001]\u0001\u0012gR\fG/\u001a+za\u0016\u001cXI\\2pI\u0016\u0014XCAA\u0007!\u0015Q\u0013qB\u001f>\u0013\r\t\tB\u0007\u0002\u0019\u0007>l\u0007o\\:ji\u0016\\U-_*uCR,WI\\2pI\u0016\u0014\u0018AE:uCR,G+\u001f9fg\u0016s7m\u001c3fe\u0002\n!\"\u001b8ji&\fG.\u001b>f)\t\tI\u0002E\u00029\u00037I1!!\b:\u0005\u0011)f.\u001b;\u0002\r\u0015D\u0018n\u001d;t)\t\t\u0019\u0003E\u00029\u0003KI1!a\n:\u0005\u001d\u0011un\u001c7fC:\f\u0001bZ3u-\u0006dW/\u001a\u000b\u0004\u0001\u00065\u0002BBA\u0018\u001d\u0001\u0007!'A\u0002lKf\f1bY8oi\u0006Lgn]&fsR!\u00111EA\u001b\u0011\u0019\tyc\u0004a\u0001e\u0005YQ\u000f\u001d3bi\u00164\u0016\r\\;f)\u0019\tI\"a\u000f\u0002>!1\u0011q\u0006\tA\u0002IBa!a\u0010\u0011\u0001\u0004\u0001\u0015!\u0002<bYV,\u0017\u0001C5uKJ\fGo\u001c:\u0015\u0005\u0005\u0015\u0003CBA$\u0003#\n9F\u0004\u0003\u0002J\u00055cb\u0001+\u0002L%\t!(C\u0002\u0002Pe\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002T\u0005U#\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005=\u0013\bE\u00039\u00033\u0012\u0004)C\u0002\u0002\\e\u0012a\u0001V;qY\u0016\u0014\u0014\u0001B6fsN$\"!!\u0019\u0011\u000b\u0005\u001d\u0013\u0011\u000b\u001a\u0002\rY\fG.^3t)\t\t9\u0007E\u0003\u0002H\u0005E\u0003)A\u0005sK6|g/Z&fsR!\u0011\u0011DA7\u0011\u0019\ty\u0003\u0006a\u0001e\u0005)1\r\\3be\u00061r-\u001a;XSRDw.\u001e;F]\u001a|'oY5oOR#F\n\u0006\u0003\u0002v\u0005m\u0004\u0003\u0002\u001d\u0002x\u0001K1!!\u001f:\u0005\u0019y\u0005\u000f^5p]\"1\u0011Q\u0010\fA\u0002I\nq!^:fe.+\u00170A\u0006hKR$F\u000b\u0014,bYV,G\u0003BAB\u0003\u000f\u0003R\u0001OA<\u0003\u000b\u0003R\u0001OA-\u00012Da!! \u0018\u0001\u0004\u0011\u0014AF4fi.+\u0017PV1mk\u0016\u001c\u0018J\u001c+U\u0019N#\u0018\r^3\u0015\u0005\u00055\u0005CBA$\u0003#\ny\tE\u00039\u00033\u0012D\u000e")
public class MapStateImplWithTTL<K, V>
extends OneToOneTTLState
implements MapState<K, V>,
Logging {
    private final StateStore store;
    private final String stateName;
    private final ExpressionEncoder<Object> keyExprEnc;
    private final ExpressionEncoder<Object> userKeyEnc;
    private final ExpressionEncoder<Object> valEncoder;
    private final TTLConfig ttlConfig;
    public final long org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$batchTimestampMs;
    private final Map<String, SQLMetric> metrics;
    private final CompositeKeyStateEncoder<Object, Object> org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public CompositeKeyStateEncoder<Object, Object> org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder() {
        return this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder;
    }

    private void initialize() {
        StructType schemaForCompositeKeyRow = TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getCompositeKeySchema(this.keyExprEnc.schema(), this.userKeyEnc.schema());
        this.store.createColFamilyIfAbsent(this.stateName, schemaForCompositeKeyRow, TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getValueSchemaWithTTL(this.valEncoder.schema(), true), new PrefixKeyScanStateEncoderSpec(schemaForCompositeKeyRow, 1), this.store.createColFamilyIfAbsent$default$5(), this.store.createColFamilyIfAbsent$default$6());
    }

    public boolean exists() {
        return this.iterator().nonEmpty();
    }

    public V getValue(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        UnsafeRow encodedCompositeKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeCompositeKey(key);
        UnsafeRow retRow = this.store.get(encodedCompositeKey, this.stateName);
        if (retRow != null) {
            if (!this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().isExpired(retRow, this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$batchTimestampMs)) {
                return this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeValue(retRow);
            }
            return null;
        }
        return null;
    }

    public boolean containsKey(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        return this.getValue(key) != null;
    }

    public void updateValue(K key, V value) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        StateStoreErrors$.MODULE$.requireNonNullStateValue(value, this.stateName);
        UnsafeRow encodedCompositeKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeCompositeKey(key);
        long ttlExpirationMs = StateTTL$.MODULE$.calculateExpirationTimeForDuration(this.ttlConfig.ttlDuration(), this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$batchTimestampMs);
        UnsafeRow encodedValue = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeValue(value, ttlExpirationMs);
        this.updatePrimaryAndSecondaryIndices(encodedCompositeKey, encodedValue, ttlExpirationMs);
    }

    public Iterator<Tuple2<K, V>> iterator() {
        UnsafeRow encodedGroupingKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        Iterator<UnsafeRowPair> unsafeRowPairIterator = this.store.prefixScan(encodedGroupingKey, this.stateName);
        return new NextIterator<Tuple2<K, V>>(this, unsafeRowPairIterator){
            private final /* synthetic */ MapStateImplWithTTL $outer;
            private final Iterator unsafeRowPairIterator$1;

            public Tuple2<K, V> getNext() {
                Iterator iter = this.unsafeRowPairIterator$1.dropWhile((Function1 & Serializable)rowPair -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$getNext$1(this, rowPair)));
                if (iter.hasNext()) {
                    UnsafeRowPair currentRowPair = (UnsafeRowPair)iter.next();
                    Object key = this.$outer.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeCompositeKey(currentRowPair.key());
                    V value = this.$outer.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeValue(currentRowPair.value());
                    return new Tuple2(key, value);
                }
                this.finished_$eq(true);
                return null;
            }

            public void close() {
            }

            public static final /* synthetic */ boolean $anonfun$getNext$1($anon$1 $this, UnsafeRowPair rowPair) {
                return $this.$outer.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().isExpired(rowPair.value(), $this.$outer.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$batchTimestampMs);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.unsafeRowPairIterator$1 = unsafeRowPairIterator$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getNext$1$adapted(org.apache.spark.sql.execution.streaming.MapStateImplWithTTL$$anon$1 org.apache.spark.sql.execution.streaming.state.UnsafeRowPair )}, serializedLambda);
            }
        };
    }

    public Iterator<K> keys() {
        return this.iterator().map((Function1 & Serializable)x$1 -> x$1._1());
    }

    public Iterator<V> values() {
        return this.iterator().map((Function1 & Serializable)x$2 -> x$2._2());
    }

    public void removeKey(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        UnsafeRow compositeKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeCompositeKey(key);
        this.store.remove(compositeKey, this.stateName);
        TWSMetricsUtils$.MODULE$.incrementMetric(this.metrics, "numRemovedStateRows", TWSMetricsUtils$.MODULE$.incrementMetric$default$3());
    }

    public void clear() {
        UnsafeRow encodedGroupingKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey();
        Iterator<UnsafeRowPair> unsafeRowPairIterator = this.store.prefixScan(encodedGroupingKey, this.stateName);
        unsafeRowPairIterator.foreach((Function1 & Serializable)rowPair -> {
            this.clearAllStateForElementKey(rowPair.key());
            return BoxedUnit.UNIT;
        });
    }

    public Option<V> getWithoutEnforcingTTL(K userKey) {
        UnsafeRow encodedCompositeKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeCompositeKey(userKey);
        UnsafeRow retRow = this.store.get(encodedCompositeKey, this.stateName);
        if (retRow != null) {
            Object resState = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeValue(retRow);
            return new Some(resState);
        }
        return None$.MODULE$;
    }

    public Option<Tuple2<V, Object>> getTTLValue(K userKey) {
        UnsafeRow encodedCompositeKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeCompositeKey(userKey);
        UnsafeRow retRow = this.store.get(encodedCompositeKey, this.stateName);
        return Option$.MODULE$.apply((Object)retRow).flatMap((Function1 & Serializable)row -> {
            Option<Object> ttlExpiration = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeTtlExpirationMs((UnsafeRow)row);
            return ttlExpiration.map((Function1 & Serializable)expiration -> MapStateImplWithTTL.$anonfun$getTTLValue$2(this, row, BoxesRunTime.unboxToLong((Object)expiration)));
        });
    }

    public Iterator<Tuple2<K, Object>> getKeyValuesInTTLState() {
        UnsafeRow implicitGroupingKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().encodeGroupingKey().getStruct(0, this.keyExprEnc.schema().length());
        return this.getTTLRows().filter((Function1 & Serializable)ttlRow -> BoxesRunTime.boxToBoolean((boolean)MapStateImplWithTTL.$anonfun$getKeyValuesInTTLState$1(this, implicitGroupingKey, ttlRow))).map((Function1 & Serializable)ttlRow -> {
            UnsafeRow compositeKey = ttlRow.elementKey();
            Object userKey = this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeCompositeKey(compositeKey);
            return new Tuple2(userKey, (Object)BoxesRunTime.boxToLong((long)ttlRow.expirationMs()));
        });
    }

    public static final /* synthetic */ Tuple2 $anonfun$getTTLValue$2(MapStateImplWithTTL $this, UnsafeRow row$1, long expiration) {
        return new Tuple2($this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder().decodeValue(row$1), (Object)BoxesRunTime.boxToLong((long)expiration));
    }

    public static final /* synthetic */ boolean $anonfun$getKeyValuesInTTLState$1(MapStateImplWithTTL $this, UnsafeRow implicitGroupingKey$1, TTLState.TTLRow ttlRow) {
        UnsafeRow groupingKey;
        UnsafeRow compositeKey = ttlRow.elementKey();
        UnsafeRow unsafeRow = groupingKey = compositeKey.getStruct(0, $this.keyExprEnc.schema().length());
        UnsafeRow unsafeRow2 = implicitGroupingKey$1;
        return !(unsafeRow != null ? !unsafeRow.equals(unsafeRow2) : unsafeRow2 != null);
    }

    public MapStateImplWithTTL(StateStore store, String stateName, ExpressionEncoder<Object> keyExprEnc, ExpressionEncoder<Object> userKeyEnc, ExpressionEncoder<Object> valEncoder, TTLConfig ttlConfig, long batchTimestampMs, Map<String, SQLMetric> metrics) {
        this.store = store;
        this.stateName = stateName;
        this.keyExprEnc = keyExprEnc;
        this.userKeyEnc = userKeyEnc;
        this.valEncoder = valEncoder;
        this.ttlConfig = ttlConfig;
        this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$batchTimestampMs = batchTimestampMs;
        this.metrics = metrics;
        super(stateName, store, TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getCompositeKeySchema(keyExprEnc.schema(), userKeyEnc.schema()), ttlConfig, batchTimestampMs, metrics);
        Logging.$init$((Logging)this);
        this.org$apache$spark$sql$execution$streaming$MapStateImplWithTTL$$stateTypesEncoder = new CompositeKeyStateEncoder<Object, Object>(keyExprEnc, (Encoder<Object>)userKeyEnc, (Encoder<Object>)valEncoder, stateName, true);
        this.initialize();
    }
}

