/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.QueryContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.util.V2ExpressionSQLBuilder;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcOptionsInWrite;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.jdbc.connection.ConnectionProvider$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MetadataBuilder;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0005\u0011\rg!B A\u0003\u0003Y\u0005\"\u00023\u0001\t\u0003)\u0007\"\u00025\u0001\r\u0003I\u0007\"B<\u0001\t\u0003A\bbBA\u0011\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011\u001d\tI\u0006\u0001C\u0001\u00037Bq!!\u001c\u0001\t\u0003\ty\u0007C\u0004\u0002x\u0001!\t!!\u001f\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\"9\u00111\u0016\u0001\u0005\u0002\u00055\u0006bBAh\u0001\u0011\u0005\u0011\u0011\u001b\u0005\b\u0003/\u0004A\u0011AAm\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003KDq!a9\u0001\t\u0003\ty\u000fC\u0005\u0002\u0000\u0002\t\n\u0011\"\u0001\u0003\u0002!9!Q\u0003\u0001\u0005\u0002\t]\u0001\u0002\u0003B\u0014\u0001\u0011E\u0001I!\u000b\t\u000f\tE\u0002\u0001\"\u0001\u00034\u00199!q\b\u0001\u0001\u0001\n\u0005\u0003B\u00023\u0014\t\u0003\u0011\u0019\u0006C\u0004\u0003ZM!\tEa\u0017\t\u000f\t}4\u0003\"\u0011\u0003\u0002\"9!QR\n\u0005B\t=\u0005b\u0002BM'\u0011\u0005#1\u0014\u0005\b\u0005W\u001bB\u0011\tBW\u0011\u001d\u00119l\u0005C\t\u0005sCqA!0\u0014\t\u0003\u0012y\fC\u0004\u0003DN!\tE!2\t\u001d\t57\u0003%A\u0002\u0002\u0003%IAa4\u0003r\"9!1\u001f\u0001\u0005\u0002\tU\bb\u0002B~\u0001\u0011\u0005!Q \u0005\b\u0007\u001b\u0001A\u0011AB\b\u0011\u001d\u00199\u0004\u0001C\u0001\u0007sAqa!\u0016\u0001\t\u0003\u00199\u0006C\u0004\u0004d\u0001!\ta!\u001a\t\u000f\r=\u0004\u0001\"\u0001\u0004r!91\u0011\u0010\u0001\u0005\u0002\rm\u0004bBB?\u0001\u0011\u00051q\u0010\u0005\b\u0007{\u0002A\u0011ABH\u0011\u001d\u0019y\n\u0001C\u0001\u0007CCqa!.\u0001\t\u0003\u00199\fC\u0004\u0004B\u0002!\taa1\t\u000f\r=\u0007\u0001\"\u0001\u0004R\"91q\u001b\u0001\u0005\u0002\re\u0007bBBr\u0001\u0011\u00051Q\u001d\u0005\b\u0007_\u0004A\u0011ABy\u0011\u001d\u00199\u0010\u0001C\u0001\u0007sDqaa@\u0001\t\u0003!\t\u0001C\u0004\u0005\u0006\u0001!\t\u0001b\u0002\t\u000f\u00115\u0001\u0001\"\u0001\u0005\u0010!9Aq\u0006\u0001\u0005\u0002\u0011E\u0002b\u0002C\u001e\u0001\u0011\u0005AQ\b\u0005\b\t\u0007\u0002A\u0011\u0001C#\u0011\u001d!Y\u0006\u0001C\u0001\t;Bq\u0001b\u001d\u0001\t\u0003!)\bC\u0004\u0005\u0002\u0002!\t\u0001b!\t\u000f\u0011%\u0005\u0001\"\u0001\u0005\f\"9AQ\u0013\u0001\u0005\u0002\u0011]\u0005b\u0002CM\u0001\u0011\u0005Aq\u0013\u0005\b\t7\u0003A\u0011\u0001CL\u0011\u001d!i\n\u0001C\u0001\t?Cq\u0001\"-\u0001\t\u0003!\u0019LA\u0006KI\n\u001cG)[1mK\u000e$(BA!C\u0003\u0011QGMY2\u000b\u0005\r#\u0015aA:rY*\u0011QIR\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f\"\u000ba!\u00199bG\",'\"A%\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001a%K\u0018\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M[fB\u0001+Z\u001d\t)\u0006,D\u0001W\u0015\t9&*\u0001\u0004=e>|GOP\u0005\u0002\u001f&\u0011!LT\u0001\ba\u0006\u001c7.Y4f\u0013\taVL\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002[\u001dB\u0011qLY\u0007\u0002A*\u0011\u0011\rR\u0001\tS:$XM\u001d8bY&\u00111\r\u0019\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\ta\r\u0005\u0002h\u00015\t\u0001)A\u0005dC:D\u0015M\u001c3mKR\u0011!.\u001c\t\u0003\u001b.L!\u0001\u001c(\u0003\u000f\t{w\u000e\\3b]\")aN\u0001a\u0001_\u0006\u0019QO\u001d7\u0011\u0005A$hBA9s!\t)f*\u0003\u0002t\u001d\u00061\u0001K]3eK\u001aL!!\u001e<\u0003\rM#(/\u001b8h\u0015\t\u0019h*A\bhKR\u001c\u0015\r^1msN$H+\u001f9f)%I\u0018QAA\b\u0003'\t9\u0002E\u0002NurL!a\u001f(\u0003\r=\u0003H/[8o!\ri\u0018\u0011A\u0007\u0002}*\u0011qPQ\u0001\u0006if\u0004Xm]\u0005\u0004\u0003\u0007q(\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\u0005\u001d1\u00011\u0001\u0002\n\u000591/\u001d7UsB,\u0007cA'\u0002\f%\u0019\u0011Q\u0002(\u0003\u0007%sG\u000f\u0003\u0004\u0002\u0012\r\u0001\ra\\\u0001\tif\u0004XMT1nK\"9\u0011QC\u0002A\u0002\u0005%\u0011\u0001B:ju\u0016Dq!!\u0007\u0004\u0001\u0004\tY\"\u0001\u0002nIB\u0019Q0!\b\n\u0007\u0005}aPA\bNKR\fG-\u0019;b\u0005VLG\u000eZ3s\u0003-9W\r\u001e&E\u0005\u000e#\u0016\u0010]3\u0015\t\u0005\u0015\u0012Q\u0006\t\u0005\u001bj\f9\u0003E\u0002h\u0003SI1!a\u000bA\u0005!QEMY2UsB,\u0007BBA\u0018\t\u0001\u0007A0\u0001\u0002ei\u0006y2m\u001c8wKJ$(*\u0019<b)&lWm\u001d;b[B$v\u000eV5nKN$\u0018-\u001c9\u0015\t\u0005U\u00121\t\t\u0005\u0003o\ty$\u0004\u0002\u0002:)\u00191)a\u000f\u000b\u0005\u0005u\u0012\u0001\u00026bm\u0006LA!!\u0011\u0002:\tIA+[7fgR\fW\u000e\u001d\u0005\b\u0003\u000b*\u0001\u0019AA\u001b\u0003\u0005!\b&B\u0003\u0002J\u0005U\u0003\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=C)\u0001\u0006b]:|G/\u0019;j_:LA!a\u0015\u0002N\t)1+\u001b8dK\u0006\u0012\u0011qK\u0001\u0006g9*d\u0006M\u0001#G>tg/\u001a:u\u0015\u00064\u0018\rV5nKN$\u0018-\u001c9U_RKW.Z:uC6\u0004h\n\u0016.\u0015\t\u0005u\u0013\u0011\u000e\t\u0005\u0003?\n)'\u0004\u0002\u0002b)!\u00111MA\u001e\u0003\u0011!\u0018.\\3\n\t\u0005\u001d\u0014\u0011\r\u0002\u000e\u0019>\u001c\u0017\r\u001c#bi\u0016$\u0016.\\3\t\u000f\u0005\u0015c\u00011\u0001\u00026!*a!!\u0013\u0002V\u0005\u00113m\u001c8wKJ$H+[7fgR\fW\u000e\u001d(U5R{'*\u0019<b)&lWm\u001d;b[B$B!!\u000e\u0002r!9\u00111O\u0004A\u0002\u0005u\u0013a\u00017ei\"*q!!\u0013\u0002V\u000592M]3bi\u0016\u001cuN\u001c8fGRLwN\u001c$bGR|'/\u001f\u000b\u0005\u0003w\n9\tE\u0004N\u0003{\nI!!!\n\u0007\u0005}dJA\u0005Gk:\u001cG/[8ocA!\u0011qGAB\u0013\u0011\t))!\u000f\u0003\u0015\r{gN\\3di&|g\u000eC\u0004\u0002\n\"\u0001\r!a#\u0002\u000f=\u0004H/[8ogB!\u0011QRAM\u001b\t\tyIC\u0002B\u0003#SA!a%\u0002\u0016\u0006YA-\u0019;bg>,(oY3t\u0015\r\t9JQ\u0001\nKb,7-\u001e;j_:LA!a'\u0002\u0010\nY!\n\u0012\"D\u001fB$\u0018n\u001c8tQ\u0015A\u0011\u0011JAPC\t\t\t+A\u00034]Mr\u0003'A\brk>$X-\u00133f]RLg-[3s)\ry\u0017q\u0015\u0005\u0007\u0003SK\u0001\u0019A8\u0002\u000f\r|GNT1nK\u0006Y1M]3bi\u0016$\u0016M\u00197f))\ty+!.\u0002@\u0006\r\u0017q\u0019\t\u0004\u001b\u0006E\u0016bAAZ\u001d\n!QK\\5u\u0011\u001d\t9L\u0003a\u0001\u0003s\u000b\u0011b\u001d;bi\u0016lWM\u001c;\u0011\t\u0005]\u00121X\u0005\u0005\u0003{\u000bIDA\u0005Ti\u0006$X-\\3oi\"1\u0011\u0011\u0019\u0006A\u0002=\f\u0011\u0002^1cY\u0016t\u0015-\\3\t\r\u0005\u0015'\u00021\u0001p\u0003%\u0019HO]*dQ\u0016l\u0017\rC\u0004\u0002\n*\u0001\r!!3\u0011\t\u00055\u00151Z\u0005\u0005\u0003\u001b\fyI\u0001\nKI\n\u001cw\n\u001d;j_:\u001c\u0018J\\,sSR,\u0017aE4fiR\u000b'\r\\3Fq&\u001cHo])vKJLHcA8\u0002T\"1\u0011Q[\u0006A\u0002=\fQ\u0001^1cY\u0016\fabZ3u'\u000eDW-\\1Rk\u0016\u0014\u0018\u0010F\u0002p\u00037Da!!6\r\u0001\u0004y\u0007&\u0002\u0007\u0002J\u0005}\u0017EAAq\u0003\u0015\u0011d&\r\u00181\u0003A9W\r\u001e+sk:\u001c\u0017\r^3Rk\u0016\u0014\u0018\u0010F\u0002p\u0003ODa!!6\u000e\u0001\u0004y\u0007&B\u0007\u0002J\u0005-\u0018EAAw\u0003\u0015\u0011df\r\u00181)\u0015y\u0017\u0011_Az\u0011\u0019\t)N\u0004a\u0001_\"I\u0011Q\u001f\b\u0011\u0002\u0003\u0007\u0011q_\u0001\bG\u0006\u001c8-\u00193f!\ri%P\u001b\u0015\u0006\u001d\u0005%\u00131`\u0011\u0003\u0003{\fQA\r\u00185]A\n!dZ3u)J,hnY1uKF+XM]=%I\u00164\u0017-\u001e7uII*\"Aa\u0001+\t\u0005](QA\u0016\u0003\u0005\u000f\u0001BA!\u0003\u0003\u00125\u0011!1\u0002\u0006\u0005\u0005\u001b\u0011y!A\u0005v]\u000eDWmY6fI*\u0019\u0011q\n(\n\t\tM!1\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u00032fM>\u0014XMR3uG\"$b!a,\u0003\u001a\tu\u0001b\u0002B\u000e!\u0001\u0007\u0011\u0011Q\u0001\u000bG>tg.Z2uS>t\u0007b\u0002B\u0010!\u0001\u0007!\u0011E\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\b#\u00029\u0003$=|\u0017b\u0001B\u0013m\n\u0019Q*\u00199\u0002\u0013\u0015\u001c8-\u00199f'FdGcA8\u0003,!1!QF\tA\u0002=\fQA^1mk\u0016DS!EA%\u0003W\fAbY8na&dWMV1mk\u0016$BA!\u000e\u0003<A\u0019QJa\u000e\n\u0007\tebJA\u0002B]fDqA!\f\u0013\u0001\u0004\u0011)\u0004K\u0003\u0013\u0003\u0013\nYO\u0001\bK\t\n\u001b5+\u0015'Ck&dG-\u001a:\u0014\u0007M\u0011\u0019\u0005\u0005\u0003\u0003F\t=SB\u0001B$\u0015\u0011\u0011IEa\u0013\u0002\tU$\u0018\u000e\u001c\u0006\u0004\u0005\u001b\u0012\u0015!C2p]:,7\r^8s\u0013\u0011\u0011\tFa\u0012\u0003-Y\u0013T\t\u001f9sKN\u001c\u0018n\u001c8T#2\u0013U/\u001b7eKJ$\"A!\u0016\u0011\u0007\t]3#D\u0001\u0001\u000311\u0018n]5u\u0019&$XM]1m)\ry'Q\f\u0005\b\u0005?*\u0002\u0019\u0001B1\u0003\u001da\u0017\u000e^3sC2\u0004DAa\u0019\u0003tA1!Q\rB6\u0005_j!Aa\u001a\u000b\t\t%$1J\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0003n\t\u001d$a\u0002'ji\u0016\u0014\u0018\r\u001c\t\u0005\u0005c\u0012\u0019\b\u0004\u0001\u0005\u0019\tU$QLA\u0001\u0002\u0003\u0015\tAa\u001e\u0003\u0007}#\u0013'\u0005\u0003\u0003z\tU\u0002cA'\u0003|%\u0019!Q\u0010(\u0003\u000f9{G\u000f[5oO\u0006\u0019b/[:ji:\u000bW.\u001a3SK\u001a,'/\u001a8dKR\u0019qNa!\t\u000f\t\u0015e\u00031\u0001\u0003\b\u0006Aa.Y7fIJ+g\r\u0005\u0003\u0003f\t%\u0015\u0002\u0002BF\u0005O\u0012aBT1nK\u0012\u0014VMZ3sK:\u001cW-A\u0005wSNLGoQ1tiR)qN!%\u0003\u0016\"1!1S\fA\u0002=\f\u0011\u0001\u001c\u0005\u0007\u0005/;\u0002\u0019\u0001?\u0002\u0011\u0011\fG/\u0019+za\u0016\f\u0001C^5tSR\u001c\u0016\u000b\u0014$v]\u000e$\u0018n\u001c8\u0015\u000b=\u0014iJ!)\t\r\t}\u0005\u00041\u0001p\u0003!1WO\\2OC6,\u0007b\u0002BR1\u0001\u0007!QU\u0001\u0007S:\u0004X\u000f^:\u0011\t5\u00139k\\\u0005\u0004\u0005Ss%!B!se\u0006L\u0018A\u0006<jg&$\u0018iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8\u0015\u000f=\u0014yK!-\u00036\"1!qT\rA\u0002=DaAa-\u001a\u0001\u0004Q\u0017AC5t\t&\u001cH/\u001b8di\"9!1U\rA\u0002\t\u0015\u0016a\u00053jC2,7\r\u001e$v]\u000e$\u0018n\u001c8OC6,GcA8\u0003<\"1!q\u0014\u000eA\u0002=\fAB^5tSR|e/\u001a:mCf$2a\u001cBa\u0011\u001d\u0011\u0019k\u0007a\u0001\u0005K\u000b\u0011B^5tSR$&/[7\u0015\u000b=\u00149Ma3\t\r\t%G\u00041\u0001p\u0003%!\u0017N]3di&|g\u000eC\u0004\u0003$r\u0001\rA!*\u0002%M,\b/\u001a:%m&\u001c\u0018\u000e\u001e'ji\u0016\u0014\u0018\r\u001c\u000b\u0005\u0005#\u0014Y\u000e\u0005\u0003\u0003T\neWB\u0001Bk\u0015\u0011\u00119.a\u000f\u0002\t1\fgnZ\u0005\u0004k\nU\u0007\"\u0003Bo;\u0005\u0005\t\u0019\u0001Bp\u0003\rAH%\r\u0019\u0005\u0005C\u0014)\u000f\u0005\u0004\u0003f\t-$1\u001d\t\u0005\u0005c\u0012)\u000f\u0002\u0007\u0003h\nm\u0017\u0011!A\u0001\u0006\u0003\u0011IO\u0001\u0002@aE!!\u0011\u0010Bv!\u0011\u0011\u0019N!<\n\t\t=(Q\u001b\u0002\u0007\u001f\nTWm\u0019;\n\t\te#qJ\u0001\u0014SN\u001cV\u000f\u001d9peR,GMR;oGRLwN\u001c\u000b\u0004U\n]\bB\u0002BP=\u0001\u0007q\u000eK\u0003\u001f\u0003\u0013\ny*A\td_6\u0004\u0018\u000e\\3FqB\u0014Xm]:j_:$BAa@\u0004\u0002A\u0019QJ_8\t\u000f\r\rq\u00041\u0001\u0004\u0006\u0005!Q\r\u001f9s!\u0011\u0011)ga\u0002\n\t\r%!q\r\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007&B\u0010\u0002J\u0005}\u0015\u0001E2p[BLG.Z!hOJ,w-\u0019;f)\u0011\u0011yp!\u0005\t\u000f\rM\u0001\u00051\u0001\u0004\u0016\u0005Y\u0011mZ4Gk:\u001cG/[8o!\u0011\u00199b!\b\u000e\u0005\re!\u0002BB\u000e\u0005O\n\u0011\"Y4he\u0016<\u0017\r^3\n\t\r}1\u0011\u0004\u0002\u000e\u0003\u001e<'/Z4bi\u00164UO\\2)\u0017\u0001\u001a\u0019c!\u000b\u0004,\r=2\u0011\u0007\t\u0004\u001b\u000e\u0015\u0012bAB\u0014\u001d\nQA-\u001a9sK\u000e\fG/\u001a3\u0002\u000f5,7o]1hK\u0006\u00121QF\u0001EkN,\u0007e\u001c:h]\u0005\u0004\u0018m\u00195f]M\u0004\u0018M]6/gFdgF\u001b3cG:REMY2ES\u0006dWm\u0019;/G>l\u0007/\u001b7f\u000bb\u0004(/Z:tS>t\u0007%\u001b8ti\u0016\fGML\u0001\u0006g&t7-Z\u0011\u0003\u0007g\tQa\r\u00185]ABS\u0001IA%\u0003?\u000b\u0011BZ;oGRLwN\\:\u0016\u0005\rm\u0002#B*\u0004>\r\u0005\u0013bAB ;\n\u00191+Z9\u0011\r5\u001b\u0019e\\B$\u0013\r\u0019)E\u0014\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\r%3\u0011K\u0007\u0003\u0007\u0017RAaa\u000e\u0004N)!1q\nB&\u0003\u001d\u0019\u0017\r^1m_\u001eLAaa\u0015\u0004L\tyQK\u001c2pk:$g)\u001e8di&|g.\u0001\u0007de\u0016\fG/Z*dQ\u0016l\u0017\r\u0006\u0005\u00020\u000ee31LB0\u0011\u001d\t9L\ta\u0001\u0003sCaa!\u0018#\u0001\u0004y\u0017AB:dQ\u0016l\u0017\r\u0003\u0004\u0004b\t\u0002\ra\\\u0001\bG>lW.\u001a8u\u00035\u00198\r[3nCN,\u00050[:ugR9!na\u001a\u0004l\r5\u0004bBB5G\u0001\u0007\u0011\u0011Q\u0001\u0005G>tg\u000eC\u0004\u0002\n\u000e\u0002\r!a#\t\r\ru3\u00051\u0001p\u0003-a\u0017n\u001d;TG\",W.Y:\u0015\r\rM4QOB<!\u0015i%q\u0015BS\u0011\u001d\u0019I\u0007\na\u0001\u0003\u0003Cq!!#%\u0001\u0004\tY)\u0001\rjg\u000e\u000b7oY1eS:<GK];oG\u0006$X\rV1cY\u0016$\"!a>\u0002\u0017I,g.Y7f)\u0006\u0014G.\u001a\u000b\u0006_\u000e\u00055Q\u0011\u0005\u0007\u0007\u00073\u0003\u0019A8\u0002\u0011=dG\rV1cY\u0016Daaa\"'\u0001\u0004y\u0017\u0001\u00038foR\u000b'\r\\3)\u0017\u0019\u001a\u0019c!\u000b\u0004\f\u000e=\u0012QK\u0011\u0003\u0007\u001b\u000b1\u0007\u00157fCN,\u0007e\u001c<feJLG-\u001a\u0011sK:\fW.\u001a+bE2,\u0007%\\3uQ>$\u0007e^5uQ\u0002JG-\u001a8uS\u001aLWM]:\u0015\u000b=\u001c\tja'\t\u000f\r\ru\u00051\u0001\u0004\u0014B!1QSBL\u001b\t\u0019i%\u0003\u0003\u0004\u001a\u000e5#AC%eK:$\u0018NZ5fe\"91qQ\u0014A\u0002\rM\u0005&B\u0014\u0002J\u0005U\u0013AC1mi\u0016\u0014H+\u00192mKRA!QUBR\u0007K\u001b\t\f\u0003\u0004\u0002B\"\u0002\ra\u001c\u0005\b\u0007OC\u0003\u0019ABU\u0003\u001d\u0019\u0007.\u00198hKN\u0004RaUB\u001f\u0007W\u0003Ba!&\u0004.&!1qVB'\u0005-!\u0016M\u00197f\u0007\"\fgnZ3\t\u000f\rM\u0006\u00061\u0001\u0002\n\u0005qAMY'bU>\u0014h+\u001a:tS>t\u0017!E4fi\u0006#GmQ8mk6t\u0017+^3ssR9qn!/\u0004<\u000e}\u0006BBAaS\u0001\u0007q\u000e\u0003\u0004\u0004>&\u0002\ra\\\u0001\u000bG>dW/\u001c8OC6,\u0007B\u0002BLS\u0001\u0007q.\u0001\u000bhKR\u0014VM\\1nK\u000e{G.^7o#V,'/\u001f\u000b\n_\u000e\u00157qYBe\u0007\u001bDa!!1+\u0001\u0004y\u0007BBB_U\u0001\u0007q\u000e\u0003\u0004\u0004L*\u0002\ra\\\u0001\b]\u0016<h*Y7f\u0011\u001d\u0019\u0019L\u000ba\u0001\u0003\u0013\tAcZ3u\t\u0016dW\r^3D_2,XN\\)vKJLH#B8\u0004T\u000eU\u0007BBAaW\u0001\u0007q\u000e\u0003\u0004\u0004>.\u0002\ra\\\u0001\u0019O\u0016$X\u000b\u001d3bi\u0016\u001cu\u000e\\;n]RK\b/Z)vKJLHcB8\u0004\\\u000eu7q\u001c\u0005\u0007\u0003\u0003d\u0003\u0019A8\t\r\ruF\u00061\u0001p\u0011\u0019\u0019\t\u000f\fa\u0001_\u0006Ya.Z<ECR\fG+\u001f9f\u0003}9W\r^+qI\u0006$XmQ8mk6tg*\u001e7mC\nLG.\u001b;z#V,'/\u001f\u000b\b_\u000e\u001d8\u0011^Bv\u0011\u0019\t\t-\fa\u0001_\"11QX\u0017A\u0002=Daa!<.\u0001\u0004Q\u0017AC5t\u001dVdG.\u00192mK\u0006!r-\u001a;UC\ndWmQ8n[\u0016tG/U;fef$Ra\\Bz\u0007kDa!!6/\u0001\u0004y\u0007BBB1]\u0001\u0007q.A\u000bhKR\u001c6\r[3nC\u000e{W.\\3oiF+XM]=\u0015\u000b=\u001cYp!@\t\r\rus\u00061\u0001p\u0011\u0019\u0019\tg\fa\u0001_\u0006A\"/Z7pm\u0016\u001c6\r[3nC\u000e{W.\\3oiF+XM]=\u0015\u0007=$\u0019\u0001\u0003\u0004\u0004^A\u0002\ra\\\u0001\u000bIJ|\u0007oU2iK6\fG#B8\u0005\n\u0011-\u0001BBB/c\u0001\u0007q\u000e\u0003\u0004\u0002vF\u0002\rA[\u0001\fGJ,\u0017\r^3J]\u0012,\u0007\u0010F\u0006p\t#!)\u0002\"\u0007\u0005 \u00115\u0002B\u0002C\ne\u0001\u0007q.A\u0005j]\u0012,\u0007PT1nK\"9Aq\u0003\u001aA\u0002\rM\u0015A\u0003;bE2,\u0017\nZ3oi\"9A1\u0004\u001aA\u0002\u0011u\u0011aB2pYVlgn\u001d\t\u0006\u001b\n\u001d&q\u0011\u0005\b\tC\u0011\u0004\u0019\u0001C\u0012\u0003E\u0019w\u000e\\;n]N\u0004&o\u001c9feRLWm\u001d\t\t\tK!ICa\"\u0005,5\u0011Aq\u0005\u0006\u0005\u0005\u0013\nY$\u0003\u0003\u0003&\u0011\u001d\u0002C\u0002C\u0013\tSyw\u000eC\u0004\u0003 I\u0002\r\u0001b\u000b\u0002\u0017%tG-\u001a=Fq&\u001cHo\u001d\u000b\nU\u0012MBQ\u0007C\u001c\tsAqa!\u001b4\u0001\u0004\t\t\t\u0003\u0004\u0005\u0014M\u0002\ra\u001c\u0005\b\t/\u0019\u0004\u0019ABJ\u0011\u001d\tIi\ra\u0001\u0003\u0017\u000b\u0011\u0002\u001a:pa&sG-\u001a=\u0015\u000b=$y\u0004\"\u0011\t\r\u0011MA\u00071\u0001p\u0011\u001d!9\u0002\u000ea\u0001\u0007'\u000b1\u0002\\5ti&sG-\u001a=fgRAAq\tC+\t/\"I\u0006E\u0003N\u0005O#I\u0005\u0005\u0003\u0005L\u0011ESB\u0001C'\u0015\u0011!ye!\u0014\u0002\u000b%tG-\u001a=\n\t\u0011MCQ\n\u0002\u000b)\u0006\u0014G.Z%oI\u0016D\bbBB5k\u0001\u0007\u0011\u0011\u0011\u0005\b\t/)\u0004\u0019ABJ\u0011\u001d\tI)\u000ea\u0001\u0003\u0017\u000b\u0011c\u00197bgNLg-_#yG\u0016\u0004H/[8o)\u0019!y\u0006b\u001a\u0005jA!A\u0011\rC2\u001b\u0005\u0011\u0015b\u0001C3\u0005\n\t\u0012I\\1msNL7/\u0012=dKB$\u0018n\u001c8\t\r\r%b\u00071\u0001p\u0011\u001d!YG\u000ea\u0001\t[\n\u0011!\u001a\t\u0004'\u0012=\u0014b\u0001C9;\nIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u000fO\u0016$H*[7ji\u000ec\u0017-^:f)\ryGq\u000f\u0005\b\ts:\u0004\u0019\u0001C>\u0003\u0015a\u0017.\\5u!\u0011\u0011\u0019\u000e\" \n\t\u0011}$Q\u001b\u0002\b\u0013:$XmZ3s\u0003=9W\r^(gMN,Go\u00117bkN,GcA8\u0005\u0006\"9Aq\u0011\u001dA\u0002\u0011m\u0014AB8gMN,G/\u0001\fhKRTEMY2T#2\u000bV/\u001a:z\u0005VLG\u000eZ3s)\u0011!i\tb%\u0011\u0007\u001d$y)C\u0002\u0005\u0012\u0002\u00131C\u00133cGN\u000bF*U;fef\u0014U/\u001b7eKJDq!!#:\u0001\u0004\tY)A\u0007tkB\u0004xN\u001d;t\u0019&l\u0017\u000e^\u000b\u0002U\u0006q1/\u001e9q_J$8o\u00144gg\u0016$\u0018aE:vaB|'\u000f^:UC\ndWmU1na2,\u0017AD4fiR\u000b'\r\\3TC6\u0004H.\u001a\u000b\u0004_\u0012\u0005\u0006b\u0002CR{\u0001\u0007AQU\u0001\u0007g\u0006l\u0007\u000f\\3\u0011\t\u0011\u001dFQV\u0007\u0003\tSSA\u0001b+\u0002\u0012\u0006\u0011aOM\u0005\u0005\t_#IKA\bUC\ndWmU1na2,\u0017J\u001c4p\u0003\u0001:W\r\u001e$vY2L\u0018+^1mS\u001aLW\rZ)v_R,G\rV1cY\u0016t\u0015-\\3\u0015\u0007=$)\fC\u0004\u00058z\u0002\raa%\u0002\u000b%$WM\u001c;)\u000by\nI%!\u0016)\u0007\u0001!i\f\u0005\u0003\u0002L\u0011}\u0016\u0002\u0002Ca\u0003\u001b\u0012A\u0002R3wK2|\u0007/\u001a:Ba&\u0004")
public abstract class JdbcDialect
implements Serializable,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract boolean canHandle(String var1);

    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        return None$.MODULE$;
    }

    public Option<JdbcType> getJDBCType(DataType dt) {
        return None$.MODULE$;
    }

    public Timestamp convertJavaTimestampToTimestamp(Timestamp t) {
        return t;
    }

    public LocalDateTime convertJavaTimestampToTimestampNTZ(Timestamp t) {
        return DateTimeUtils$.MODULE$.microsToLocalDateTime(DateTimeUtils$.MODULE$.fromJavaTimestampNoRebase(t));
    }

    public Timestamp convertTimestampNTZToJavaTimestamp(LocalDateTime ldt) {
        long micros = DateTimeUtils$.MODULE$.localDateTimeToMicros(ldt);
        return DateTimeUtils$.MODULE$.toJavaTimestampNoRebase(micros);
    }

    public Function1<Object, Connection> createConnectionFactory(JDBCOptions options) {
        String driverClass = options.driverClass();
        return (Function1 & Serializable)partitionId -> JdbcDialect.$anonfun$createConnectionFactory$1(driverClass, options, BoxesRunTime.unboxToInt((Object)partitionId));
    }

    public String quoteIdentifier(String colName) {
        return new StringBuilder(2).append("\"").append(colName).append("\"").toString();
    }

    public void createTable(Statement statement, String tableName, String strSchema, JdbcOptionsInWrite options) {
        String createTableOptions = options.createTableOptions();
        statement.executeUpdate(new StringBuilder(17).append("CREATE TABLE ").append(tableName).append(" (").append(strSchema).append(") ").append(createTableOptions).toString());
    }

    public String getTableExistsQuery(String table) {
        return new StringBuilder(24).append("SELECT 1 FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getSchemaQuery(String table) {
        return new StringBuilder(24).append("SELECT * FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getTruncateQuery(String table) {
        return this.getTruncateQuery(table, this.isCascadingTruncateTable());
    }

    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(15).append("TRUNCATE TABLE ").append(table).toString();
    }

    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    public void beforeFetch(Connection connection, scala.collection.immutable.Map<String, String> properties) {
    }

    public String escapeSql(String value) {
        return value == null ? null : StringUtils.replace((String)value, (String)"'", (String)"''");
    }

    public Object compileValue(Object value2) {
        Object object;
        Object object2 = value2;
        if (object2 instanceof String) {
            String string = (String)object2;
            object = new StringBuilder(2).append("'").append(this.escapeSql(string)).append("'").toString();
        } else if (object2 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object2;
            object = new StringBuilder(2).append("'").append(timestamp).append("'").toString();
        } else if (object2 instanceof Instant) {
            Instant instant = (Instant)object2;
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.getFractionFormatter(DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
            object = new StringBuilder(2).append("'").append(timestampFormatter.format(instant)).append("'").toString();
        } else if (object2 instanceof Date) {
            Date date = (Date)object2;
            object = new StringBuilder(2).append("'").append(date).append("'").toString();
        } else if (object2 instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object2;
            object = new StringBuilder(2).append("'").append(DateFormatter$.MODULE$.apply().format(localDate)).append("'").toString();
        } else if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            object = Predef$.MODULE$.genericWrapArray(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)objectArray), (Function1 & Serializable)value -> this.compileValue(value), ClassTag$.MODULE$.Any())).mkString(", ");
        } else {
            object = value2;
        }
        return object;
    }

    public boolean isSupportedFunction(String funcName) {
        return false;
    }

    public Option<String> compileExpression(Expression expr) {
        Some some;
        JDBCSQLBuilder jdbcSQLBuilder = new JDBCSQLBuilder();
        try {
            some = new Some((Object)jdbcSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", e);
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public Option<String> compileAggregate(AggregateFunc aggFunction) {
        return this.compileExpression((Expression)aggFunction);
    }

    public Seq<Tuple2<String, UnboundFunction>> functions() {
        return package$.MODULE$.Nil();
    }

    public void createSchema(Statement statement, String schema, String comment) {
        block0: {
            String schemaCommentQuery = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(comment)) ? this.getSchemaCommentQuery(schema, comment) : comment;
            statement.executeUpdate(new StringBuilder(14).append("CREATE SCHEMA ").append(this.quoteIdentifier(schema)).toString());
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(comment))) break block0;
            statement.executeUpdate(schemaCommentQuery);
        }
    }

    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        ResultSet rs = conn.getMetaData().getSchemas(null, schema);
        while (rs.next()) {
            String string = rs.getString(1);
            String string2 = schema;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            return true;
        }
        return false;
    }

    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        ResultSet rs = conn.getMetaData().getSchemas();
        while (rs.next()) {
            schemaBuilder.$plus$eq((Object)new String[]{rs.getString(1)});
        }
        return (String[][])schemaBuilder.result();
    }

    public Option<Object> isCascadingTruncateTable() {
        return None$.MODULE$;
    }

    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(23).append("ALTER TABLE ").append(oldTable).append(" RENAME TO ").append(newTable).toString();
    }

    public String renameTable(Identifier oldTable, Identifier newTable) {
        return new StringBuilder(0).append(new StringBuilder(23).append("ALTER TABLE ").append(this.getFullyQualifiedQuotedTableName(oldTable)).append(" RENAME TO ").toString()).append(String.valueOf(this.getFullyQualifiedQuotedTableName(newTable))).toString();
    }

    public String[] alterTable(String tableName, Seq<TableChange> changes, int dbMajorVersion) {
        ArrayBuilder updateClause = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(String.class));
        changes.foreach((Function1 & Serializable)change -> {
            TableChange.UpdateColumnNullability updateColumnNullability;
            TableChange.UpdateColumnType updateColumnType;
            TableChange.DeleteColumn deleteColumn;
            TableChange.RenameColumn renameColumn;
            ArrayBuilder arrayBuilder;
            TableChange.AddColumn addColumn;
            TableChange tableChange = change;
            if (tableChange instanceof TableChange.AddColumn && (addColumn = (TableChange.AddColumn)tableChange).fieldNames().length == 1) {
                String dataType = JdbcUtils$.MODULE$.getJdbcType(addColumn.dataType(), this).databaseTypeDefinition();
                String[] name = addColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getAddColumnQuery(tableName, name[0], dataType));
            } else if (tableChange instanceof TableChange.RenameColumn && (renameColumn = (TableChange.RenameColumn)tableChange).fieldNames().length == 1) {
                String[] name = renameColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getRenameColumnQuery(tableName, name[0], renameColumn.newName(), dbMajorVersion));
            } else if (tableChange instanceof TableChange.DeleteColumn && (deleteColumn = (TableChange.DeleteColumn)tableChange).fieldNames().length == 1) {
                String[] name = deleteColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getDeleteColumnQuery(tableName, name[0]));
            } else if (tableChange instanceof TableChange.UpdateColumnType && (updateColumnType = (TableChange.UpdateColumnType)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnType.fieldNames();
                String dataType = JdbcUtils$.MODULE$.getJdbcType(updateColumnType.newDataType(), this).databaseTypeDefinition();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnTypeQuery(tableName, name[0], dataType));
            } else if (tableChange instanceof TableChange.UpdateColumnNullability && (updateColumnNullability = (TableChange.UpdateColumnNullability)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnNullability.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnNullabilityQuery(tableName, name[0], updateColumnNullability.nullable()));
            } else {
                throw QueryCompilationErrors$.MODULE$.unsupportedTableChangeInJDBCCatalogError(change);
            }
            return arrayBuilder;
        });
        return (String[])updateClause.result();
    }

    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" ADD COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(dataType).toString();
    }

    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        return new StringBuilder(0).append(new StringBuilder(30).append("ALTER TABLE ").append(tableName).append(" RENAME COLUMN ").append(this.quoteIdentifier(columnName)).append(" TO").toString()).append(new StringBuilder(1).append(" ").append(this.quoteIdentifier(newName)).toString()).toString();
    }

    public String getDeleteColumnQuery(String tableName, String columnName) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" DROP COLUMN ").append(this.quoteIdentifier(columnName)).toString();
    }

    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(newDataType).toString();
    }

    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return new StringBuilder(31).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" SET ").append(nullable).toString();
    }

    public String getTableCommentQuery(String table, String comment) {
        return new StringBuilder(23).append("COMMENT ON TABLE ").append(table).append(" IS '").append(comment).append("'").toString();
    }

    public String getSchemaCommentQuery(String schema, String comment) {
        return new StringBuilder(24).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS '").append(comment).append("'").toString();
    }

    public String removeSchemaCommentQuery(String schema) {
        return new StringBuilder(26).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS NULL").toString();
    }

    public String dropSchema(String schema, boolean cascade) {
        return cascade ? new StringBuilder(20).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).append(" CASCADE").toString() : new StringBuilder(12).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).toString();
    }

    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        throw new UnsupportedOperationException("createIndex is not supported");
    }

    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        throw new UnsupportedOperationException("indexExists is not supported");
    }

    public String dropIndex(String indexName, Identifier tableIdent) {
        throw new UnsupportedOperationException("dropIndex is not supported");
    }

    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        throw new UnsupportedOperationException("listIndexes is not supported");
    }

    public AnalysisException classifyException(String message, Throwable e) {
        String x$1 = message;
        Some x$2 = new Some((Object)e);
        Option x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$5();
        scala.collection.immutable.Map x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$6();
        QueryContext[] x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$7();
        return new AnalysisException(x$1, x$3, x$4, (Option)x$2, x$5, x$6, x$7);
    }

    public String getLimitClause(Integer limit) {
        return Predef$.MODULE$.Integer2int(limit) > 0 ? new StringBuilder(6).append("LIMIT ").append(limit).toString() : "";
    }

    public String getOffsetClause(Integer offset) {
        return Predef$.MODULE$.Integer2int(offset) > 0 ? new StringBuilder(7).append("OFFSET ").append(offset).toString() : "";
    }

    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new JdbcSQLQueryBuilder(this, options);
    }

    public boolean supportsLimit() {
        return false;
    }

    public boolean supportsOffset() {
        return false;
    }

    public boolean supportsTableSample() {
        return false;
    }

    public String getTableSample(TableSampleInfo sample) {
        throw new UnsupportedOperationException("TableSample is not supported by this data source");
    }

    public String getFullyQualifiedQuotedTableName(Identifier ident) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Object)ident.name(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)colName -> this.quoteIdentifier((String)colName), ClassTag$.MODULE$.apply(String.class))).mkString(".");
    }

    public static final /* synthetic */ Connection $anonfun$createConnectionFactory$1(String driverClass$1, JDBCOptions options$1, int partitionId) {
        DriverRegistry$.MODULE$.register(driverClass$1);
        Driver driver = DriverRegistry$.MODULE$.get(driverClass$1);
        Connection connection = ConnectionProvider$.MODULE$.create(driver, (scala.collection.immutable.Map<String, String>)options$1.parameters(), options$1.connectionProviderName());
        Predef$.MODULE$.require(connection != null, (Function0 & Serializable)() -> new StringBuilder(60).append("The driver could not open a JDBC connection. Check the URL: ").append(options$1.url()).toString());
        return connection;
    }

    public JdbcDialect() {
        Logging.$init$((Logging)this);
    }

    public class JDBCSQLBuilder
    extends V2ExpressionSQLBuilder {
        private /* synthetic */ String super$visitLiteral(Literal x$1) {
            return super.visitLiteral(x$1);
        }

        public String visitLiteral(Literal<?> literal) {
            return (String)Option$.MODULE$.apply(literal.value()).map((Function1 & Serializable)v -> this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().compileValue(CatalystTypeConverters$.MODULE$.convertToScala(v, literal.dataType())).toString()).getOrElse((Function0 & Serializable)() -> this.super$visitLiteral(literal));
        }

        public String visitNamedReference(NamedReference namedRef) {
            if (namedRef.fieldNames().length > 1) {
                throw QueryCompilationErrors$.MODULE$.commandNotSupportNestedColumnError("Filter push down", namedRef.toString());
            }
            return this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])namedRef.fieldNames())));
        }

        public String visitCast(String l, DataType dataType) {
            String databaseTypeDefinition = (String)this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().getJDBCType(dataType).map((Function1 & Serializable)x$1 -> x$1.databaseTypeDefinition()).getOrElse((Function0 & Serializable)() -> dataType.typeName());
            return new StringBuilder(10).append("CAST(").append(l).append(" AS ").append(databaseTypeDefinition).append(")").toString();
        }

        public String visitSQLFunction(String funcName, String[] inputs) {
            if (!this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction(funcName)) {
                throw new UnsupportedOperationException(new StringBuilder(28).append(this.getClass().getSimpleName()).append(" does not support function: ").append(funcName).toString());
            }
            return new StringBuilder(2).append(this.dialectFunctionName(funcName)).append("(").append(Predef$.MODULE$.wrapRefArray((Object[])inputs).mkString(", ")).append(")").toString();
        }

        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (!this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction(funcName)) {
                throw new UnsupportedOperationException(new StringBuilder(38).append(this.getClass().getSimpleName()).append(" does not support aggregate function: ").append(funcName).toString());
            }
            return super.visitAggregateFunction(this.dialectFunctionName(funcName), isDistinct, inputs);
        }

        public String dialectFunctionName(String funcName) {
            return funcName;
        }

        public String visitOverlay(String[] inputs) {
            if (!this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction("OVERLAY")) {
                throw new UnsupportedOperationException(new StringBuilder(35).append(this.getClass().getSimpleName()).append(" does not support function: OVERLAY").toString());
            }
            return super.visitOverlay(inputs);
        }

        public String visitTrim(String direction, String[] inputs) {
            if (!this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction("TRIM")) {
                throw new UnsupportedOperationException(new StringBuilder(32).append(this.getClass().getSimpleName()).append(" does not support function: TRIM").toString());
            }
            return super.visitTrim(direction, inputs);
        }

        public /* synthetic */ JdbcDialect org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer() {
            return JdbcDialect.this;
        }

        public JDBCSQLBuilder() {
            if (JdbcDialect.this == null) {
                throw null;
            }
        }
    }
}

