/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog;
import org.apache.spark.sql.execution.streaming.SinkFileStatus;
import org.apache.spark.sql.execution.streaming.SinkFileStatus$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ef\u0001\u0002\u000e\u001c\u0001!B\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\t\")Q\n\u0001C\u0001\u001d\"I1\u000b\u0001a\u0001\u0002\u0004%I\u0001\u0016\u0005\n;\u0002\u0001\r\u00111A\u0005\nyC\u0011\"\u001a\u0001A\u0002\u0003\u0005\u000b\u0015B+\t\u0013)\u0004\u0001\u0019!a\u0001\n\u0013Y\u0007\"C8\u0001\u0001\u0004\u0005\r\u0011\"\u0003q\u0011%\u0011\b\u00011A\u0001B\u0003&A\u000eC\u0005u\u0001\u0001\u0007\t\u0019!C\u0005k\"I\u0011\u0010\u0001a\u0001\u0002\u0004%IA\u001f\u0005\ny\u0002\u0001\r\u0011!Q!\nYD\u0011\" \u0001A\u0002\u0003\u0007I\u0011\u0002@\t\u0017\u0005E\u0001\u00011AA\u0002\u0013%\u00111\u0003\u0005\u000b\u0003/\u0001\u0001\u0019!A!B\u0013y\bbBA\u000e\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u0003G\u0001A\u0011IA\u0013\u0011\u001d\t9\u0004\u0001C!\u0003sAq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002p\u0001!\t%!\u001d\t\u000f\u0005]\u0004\u0001\"\u0011\u0002z!9\u0011Q\u0011\u0001\u0005B\u0005\u001d\u0005bBAM\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003K\u0003A\u0011IAT\u0011\u001d\tY\u000b\u0001C!\u0003[\u0013!$T1oS\u001a,7\u000f\u001e$jY\u0016\u001cu.\\7jiB\u0013x\u000e^8d_2T!\u0001H\u000f\u0002\u0013M$(/Z1nS:<'B\u0001\u0010 \u0003%)\u00070Z2vi&|gN\u0003\u0002!C\u0005\u00191/\u001d7\u000b\u0005\t\u001a\u0013!B:qCJ\\'B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001SEz\u0004C\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\tIwN\u0003\u0002/C\u0005A\u0011N\u001c;fe:\fG.\u0003\u00021W\t\u0011b)\u001b7f\u0007>lW.\u001b;Qe>$xnY8m!\t\u0011DH\u0004\u00024s9\u0011AgN\u0007\u0002k)\u0011agJ\u0001\u0007yI|w\u000e\u001e \n\u0003a\nQa]2bY\u0006L!AO\u001e\u0002\u000fA\f7m[1hK*\t\u0001(\u0003\u0002>}\ta1+\u001a:jC2L'0\u00192mK*\u0011!h\u000f\t\u0003\u0001\u0006k\u0011!L\u0005\u0003\u00056\u0012q\u0001T8hO&tw-A\u0003k_\nLE\r\u0005\u0002F\u0013:\u0011ai\u0012\t\u0003imJ!\u0001S\u001e\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011n\nA\u0001]1uQ\u00061A(\u001b8jiz\"2aT)S!\t\u0001\u0006!D\u0001\u001c\u0011\u0015\u00195\u00011\u0001E\u0011\u0015a5\u00011\u0001E\u0003)\tG\rZ3e\r&dWm]\u000b\u0002+B\u0019ak\u0017#\u000e\u0003]S!\u0001W-\u0002\u000f5,H/\u00192mK*\u0011!lO\u0001\u000bG>dG.Z2uS>t\u0017B\u0001/X\u0005-\t%O]1z\u0005V4g-\u001a:\u0002\u001d\u0005$G-\u001a3GS2,7o\u0018\u0013fcR\u0011ql\u0019\t\u0003A\u0006l\u0011aO\u0005\u0003En\u0012A!\u00168ji\"9A-BA\u0001\u0002\u0004)\u0016a\u0001=%c\u0005Y\u0011\r\u001a3fI\u001aKG.Z:!Q\t1q\r\u0005\u0002aQ&\u0011\u0011n\u000f\u0002\niJ\fgn]5f]R\fqAZ5mK2{w-F\u0001m!\t\u0001V.\u0003\u0002o7\t\tb)\u001b7f'R\u0014X-Y7TS:\\Gj\\4\u0002\u0017\u0019LG.\u001a'pO~#S-\u001d\u000b\u0003?FDq\u0001\u001a\u0005\u0002\u0002\u0003\u0007A.\u0001\u0005gS2,Gj\\4!Q\tIq-A\u0004cCR\u001c\u0007.\u00133\u0016\u0003Y\u0004\"\u0001Y<\n\u0005a\\$\u0001\u0002'p]\u001e\f1BY1uG\"LEm\u0018\u0013fcR\u0011ql\u001f\u0005\bI.\t\t\u00111\u0001w\u0003!\u0011\u0017\r^2i\u0013\u0012\u0004\u0013A\u00059f]\u0012LgnZ\"p[6LGOR5mKN,\u0012a \t\u0005-n\u000b\t\u0001\u0005\u0003\u0002\u0004\u00055QBAA\u0003\u0015\u0011\t9!!\u0003\u0002\u0005\u0019\u001c(bAA\u0006G\u00051\u0001.\u00193p_BLA!a\u0004\u0002\u0006\t!\u0001+\u0019;i\u0003Y\u0001XM\u001c3j]\u001e\u001cu.\\7ji\u001aKG.Z:`I\u0015\fHcA0\u0002\u0016!9AMDA\u0001\u0002\u0004y\u0018a\u00059f]\u0012LgnZ\"p[6LGOR5mKN\u0004\u0003FA\bh\u0003Q\u0019X\r^;q\u001b\u0006t\u0017NZ3ti>\u0003H/[8ogR)q,a\b\u0002\"!)!\u000e\u0005a\u0001Y\")A\u000f\u0005a\u0001m\u0006A1/\u001a;va*{'\rF\u0002`\u0003OAq!!\u000b\u0012\u0001\u0004\tY#\u0001\u0006k_\n\u001cuN\u001c;fqR\u0004B!!\f\u000245\u0011\u0011q\u0006\u0006\u0005\u0003c\tI!A\u0005nCB\u0014X\rZ;dK&!\u0011QGA\u0018\u0005)QuNY\"p]R,\u0007\u0010^\u0001\nG>lW.\u001b;K_\n$RaXA\u001e\u0003{Aq!!\u000b\u0013\u0001\u0004\tY\u0003C\u0004\u0002@I\u0001\r!!\u0011\u0002\u0017Q\f7o[\"p[6LGo\u001d\t\u0006e\u0005\r\u0013qI\u0005\u0004\u0003\u000br$aA*fcB!\u0011\u0011JA2\u001d\u0011\tY%a\u0018\u000f\t\u00055\u0013Q\f\b\u0005\u0003\u001f\nYF\u0004\u0003\u0002R\u0005ec\u0002BA*\u0003/r1\u0001NA+\u0013\u00051\u0013B\u0001\u0013&\u0013\t\u00113%\u0003\u0002/C%\u0011A&L\u0005\u0004\u0003CZ\u0013A\u0005$jY\u0016\u001cu.\\7jiB\u0013x\u000e^8d_2LA!!\u001a\u0002h\t\tB+Y:l\u0007>lW.\u001b;NKN\u001c\u0018mZ3\u000b\u0007\u0005\u00054&\u0001\u0005bE>\u0014HOS8c)\ry\u0016Q\u000e\u0005\b\u0003S\u0019\u0002\u0019AA\u0016\u00031yg\u000eV1tW\u000e{W.\\5u)\ry\u00161\u000f\u0005\b\u0003k\"\u0002\u0019AA$\u0003)!\u0018m]6D_6l\u0017\u000e^\u0001\ng\u0016$X\u000f\u001d+bg.$2aXA>\u0011\u001d\ti(\u0006a\u0001\u0003\u007f\n1\u0002^1tW\u000e{g\u000e^3yiB!\u0011QFAA\u0013\u0011\t\u0019)a\f\u0003%Q\u000b7o[!ui\u0016l\u0007\u000f^\"p]R,\u0007\u0010^\u0001\u0010]\u0016<H+Y:l)\u0016l\u0007OR5mKR9A)!#\u0002\f\u0006U\u0005bBA?-\u0001\u0007\u0011q\u0010\u0005\b\u0003\u001b3\u0002\u0019AAH\u0003\r!\u0017N\u001d\t\u0005A\u0006EE)C\u0002\u0002\u0014n\u0012aa\u00149uS>t\u0007BBAL-\u0001\u0007A)A\u0002fqR\faC\\3x)\u0006\u001c8\u000eV3na\u001aKG.Z!cgB\u000bG\u000f\u001b\u000b\b\t\u0006u\u0015qTAR\u0011\u001d\tih\u0006a\u0001\u0003\u007fBa!!)\u0018\u0001\u0004!\u0015aC1cg>dW\u000f^3ESJDa!a&\u0018\u0001\u0004!\u0015AC2p[6LG\u000fV1tWR!\u0011qIAU\u0011\u001d\ti\b\u0007a\u0001\u0003\u007f\n\u0011\"\u00192peR$\u0016m]6\u0015\u0007}\u000by\u000bC\u0004\u0002~e\u0001\r!a ")
public class ManifestFileCommitProtocol
extends FileCommitProtocol
implements Serializable {
    private final String path;
    private transient ArrayBuffer<String> addedFiles;
    private transient FileStreamSinkLog fileLog;
    private long batchId;
    private transient ArrayBuffer<Path> pendingCommitFiles;

    private ArrayBuffer<String> addedFiles() {
        return this.addedFiles;
    }

    private void addedFiles_$eq(ArrayBuffer<String> x$1) {
        this.addedFiles = x$1;
    }

    private FileStreamSinkLog fileLog() {
        return this.fileLog;
    }

    private void fileLog_$eq(FileStreamSinkLog x$1) {
        this.fileLog = x$1;
    }

    private long batchId() {
        return this.batchId;
    }

    private void batchId_$eq(long x$1) {
        this.batchId = x$1;
    }

    private ArrayBuffer<Path> pendingCommitFiles() {
        return this.pendingCommitFiles;
    }

    private void pendingCommitFiles_$eq(ArrayBuffer<Path> x$1) {
        this.pendingCommitFiles = x$1;
    }

    public void setupManifestOptions(FileStreamSinkLog fileLog, long batchId) {
        this.fileLog_$eq(fileLog);
        this.batchId_$eq(batchId);
    }

    public void setupJob(JobContext jobContext) {
        Predef$.MODULE$.require(this.fileLog() != null, (Function0 & Serializable)() -> "setupManifestOptions must be called before this function");
        this.pendingCommitFiles_$eq((ArrayBuffer<Path>)new ArrayBuffer());
    }

    public void commitJob(JobContext jobContext, Seq<FileCommitProtocol.TaskCommitMessage> taskCommits) {
        Predef$.MODULE$.require(this.fileLog() != null, (Function0 & Serializable)() -> "setupManifestOptions must be called before this function");
        SinkFileStatus[] fileStatuses = (SinkFileStatus[])((IterableOnceOps)taskCommits.flatMap((Function1 & Serializable)x$5 -> (Seq)x$5.obj())).toArray(ClassTag$.MODULE$.apply(SinkFileStatus.class));
        this.pendingCommitFiles().clear();
        if (!this.fileLog().add(this.batchId(), (Object[])fileStatuses)) {
            throw new IllegalStateException(new StringBuilder(25).append("Race while writing batch ").append(this.batchId()).toString());
        }
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(16).append("Committed batch ").append(this.batchId()).toString());
    }

    public void abortJob(JobContext jobContext) {
        block0: {
            Predef$.MODULE$.require(this.fileLog() != null, (Function0 & Serializable)() -> "setupManifestOptions must be called before this function");
            if (!this.pendingCommitFiles().nonEmpty()) break block0;
            this.pendingCommitFiles().foreach((Function1 & Serializable)path -> {
                Object object;
                block3: {
                    try {
                        FileSystem fs = path.getFileSystem(jobContext.getConfiguration());
                        if (fs.exists(path)) {
                            object = BoxesRunTime.boxToBoolean((boolean)fs.delete(path, false));
                            break block3;
                        }
                        object = BoxedUnit.UNIT;
                    }
                    catch (IOException e) {
                        this.logWarning((Function0 & Serializable)() -> new StringBuilder(55).append("Fail to remove temporary file ").append(path).append(", continue removing next.").toString(), e);
                        object = BoxedUnit.UNIT;
                    }
                }
                return object;
            });
            this.pendingCommitFiles().clear();
        }
    }

    public void onTaskCommit(FileCommitProtocol.TaskCommitMessage taskCommit) {
        this.pendingCommitFiles().$plus$plus$eq((IterableOnce)((Seq)taskCommit.obj()).map((Function1 & Serializable)x$6 -> x$6.toFileStatus().getPath()));
    }

    public void setupTask(TaskAttemptContext taskContext) {
        this.addedFiles_$eq((ArrayBuffer<String>)new ArrayBuffer());
    }

    public String newTaskTempFile(TaskAttemptContext taskContext, Option<String> dir, String ext) {
        int split = taskContext.getTaskAttemptID().getTaskID().getId();
        String uuid = UUID.randomUUID().toString();
        int arg$macro$1 = split;
        String arg$macro$2 = uuid;
        String arg$macro$3 = ext;
        String filename = StringOps$.MODULE$.format$extension("part-%05d-%s%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1), arg$macro$2, arg$macro$3}));
        String file = (String)dir.map((Function1 & Serializable)d -> new Path(new Path($this.path, d), filename).toString()).getOrElse((Function0 & Serializable)() -> new Path($this.path, filename).toString());
        this.addedFiles().$plus$eq((Object)file);
        return file;
    }

    public String newTaskTempFileAbsPath(TaskAttemptContext taskContext, String absoluteDir, String ext) {
        throw QueryExecutionErrors$.MODULE$.addFilesWithAbsolutePathUnsupportedError(this.toString());
    }

    public FileCommitProtocol.TaskCommitMessage commitTask(TaskAttemptContext taskContext) {
        FileCommitProtocol.TaskCommitMessage taskCommitMessage;
        if (this.addedFiles().nonEmpty()) {
            FileSystem fs = new Path((String)this.addedFiles().head()).getFileSystem(taskContext.getConfiguration());
            Seq statuses = ((IterableOnceOps)this.addedFiles().map((Function1 & Serializable)f -> SinkFileStatus$.MODULE$.apply(fs.getFileStatus(new Path(f))))).toSeq();
            taskCommitMessage = new FileCommitProtocol.TaskCommitMessage((Object)statuses);
        } else {
            taskCommitMessage = new FileCommitProtocol.TaskCommitMessage((Object)package$.MODULE$.Seq().empty());
        }
        return taskCommitMessage;
    }

    public void abortTask(TaskAttemptContext taskContext) {
        block0: {
            if (!this.addedFiles().nonEmpty()) break block0;
            FileSystem fs = new Path((String)this.addedFiles().head()).getFileSystem(taskContext.getConfiguration());
            this.addedFiles().foreach((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)fs.delete(new Path(file), false)));
        }
    }

    public ManifestFileCommitProtocol(String jobId, String path) {
        this.path = path;
    }
}

