/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.catalog.CatalogColumnStat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.DescribeColumnCommand$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t\u001da\u0001\u0002\u0011\"\u0001:B\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t+\u0002\u0011\t\u0012)A\u0005#\"Aa\u000b\u0001BK\u0002\u0013\u0005q\u000b\u0003\u0005d\u0001\tE\t\u0015!\u0003Y\u0011!!\u0007A!f\u0001\n\u0003)\u0007\u0002C5\u0001\u0005#\u0005\u000b\u0011\u00024\t\u0011)\u0004!Q3A\u0005B-D\u0001b\u001d\u0001\u0003\u0012\u0003\u0006I\u0001\u001c\u0005\u0006i\u0002!\t!\u001e\u0005\u0006w\u0002!\t\u0005 \u0005\b\u0003\u001f\u0001A\u0011BA\t\u0011\u001d\tY\u0003\u0001C\u0005\u0003[A\u0011\"!\u000f\u0001\u0003\u0003%\t!a\u000f\t\u0013\u0005\u0015\u0003!%A\u0005\u0002\u0005\u001d\u0003\"CA/\u0001E\u0005I\u0011AA0\u0011%\t\u0019\u0007AI\u0001\n\u0003\t)\u0007C\u0005\u0002j\u0001\t\n\u0011\"\u0001\u0002l!I\u0011q\u000e\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u000f\u0005\n\u0003\u0003\u0003\u0011\u0011!C\u0001\u0003\u0007C\u0011\"a#\u0001\u0003\u0003%\t!!$\t\u0013\u0005e\u0005!!A\u0005B\u0005m\u0005\"CAU\u0001\u0005\u0005I\u0011AAV\u0011%\ty\u000bAA\u0001\n\u0003\n\t\fC\u0005\u00026\u0002\t\t\u0011\"\u0011\u00028\u001eI\u00111X\u0011\u0002\u0002#\u0005\u0011Q\u0018\u0004\tA\u0005\n\t\u0011#\u0001\u0002@\"1AO\u0007C\u0001\u0003/D\u0011\"!7\u001b\u0003\u0003%)%a7\t\u0013\u0005u'$!A\u0005\u0002\u0006}\u0007\"CAu5\u0005\u0005I\u0011QAv\u0011%\tiPGA\u0001\n\u0013\tyPA\u000bEKN\u001c'/\u001b2f\u0007>dW/\u001c8D_6l\u0017M\u001c3\u000b\u0005\t\u001a\u0013aB2p[6\fg\u000e\u001a\u0006\u0003I\u0015\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u0019:\u0013aA:rY*\u0011\u0001&K\u0001\u0006gB\f'o\u001b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001y\u0013(P\"\u0011\u0005A:T\"A\u0019\u000b\u0005I\u001a\u0014a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003iU\nQ\u0001\u001d7b]NT!AN\u0013\u0002\u0011\r\fG/\u00197zgRL!\u0001O\u0019\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u0003umj\u0011!I\u0005\u0003y\u0005\u00121\u0003T3bMJ+hN\\1cY\u0016\u001cu.\\7b]\u0012\u0004\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002E\u0019:\u0011QI\u0013\b\u0003\r&k\u0011a\u0012\u0006\u0003\u00116\na\u0001\u0010:p_Rt\u0014\"\u0001!\n\u0005-{\u0014a\u00029bG.\fw-Z\u0005\u0003\u001b:\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aS \u0002\u000bQ\f'\r\\3\u0016\u0003E\u0003\"AU*\u000e\u0003UJ!\u0001V\u001b\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJ\fa\u0001^1cY\u0016\u0004\u0013\u0001D2pY:\u000bW.\u001a)beR\u001cX#\u0001-\u0011\u0007\u0011K6,\u0003\u0002[\u001d\n\u00191+Z9\u0011\u0005q\u0003gBA/_!\t1u(\u0003\u0002`\u007f\u00051\u0001K]3eK\u001aL!!\u00192\u0003\rM#(/\u001b8h\u0015\tyv(A\u0007d_2t\u0015-\\3QCJ$8\u000fI\u0001\u000bSN,\u0005\u0010^3oI\u0016$W#\u00014\u0011\u0005y:\u0017B\u00015@\u0005\u001d\u0011un\u001c7fC:\f1\"[:FqR,g\u000eZ3eA\u00051q.\u001e;qkR,\u0012\u0001\u001c\t\u0004\tfk\u0007C\u00018r\u001b\u0005y'B\u000196\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005I|'!C!uiJL'-\u001e;f\u0003\u001dyW\u000f\u001e9vi\u0002\na\u0001P5oSRtD#\u0002<xqfT\bC\u0001\u001e\u0001\u0011\u0015y\u0015\u00021\u0001R\u0011\u00151\u0016\u00021\u0001Y\u0011\u0015!\u0017\u00021\u0001g\u0011\u0015Q\u0017\u00021\u0001m\u0003\r\u0011XO\u001c\u000b\u0004{\u0006\u0015\u0001c\u0001#Z}B\u0019q0!\u0001\u000e\u0003\u0015J1!a\u0001&\u0005\r\u0011vn\u001e\u0005\b\u0003\u000fQ\u0001\u0019AA\u0005\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\ry\u00181B\u0005\u0004\u0003\u001b)#\u0001D*qCJ\\7+Z:tS>t\u0017!\u0007;p5>tW-Q<be\u0016,\u0005\u0010^3s]\u0006d7\u000b\u001e:j]\u001e$raWA\n\u0003/\tY\u0002\u0003\u0004\u0002\u0016-\u0001\raW\u0001\tm\u0006dW/Z*ue\"1\u0011\u0011D\u0006A\u0002m\u000bAA\\1nK\"9\u0011QD\u0006A\u0002\u0005}\u0011\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\n&\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tI#a\t\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fA\u0003[5ti><'/Y7EKN\u001c'/\u001b9uS>tGcA?\u00020!9\u0011\u0011\u0007\u0007A\u0002\u0005M\u0012!\u00035jgR|wM]1n!\r\u0001\u0014QG\u0005\u0004\u0003o\t$!\u0003%jgR|wM]1n\u0003\u0011\u0019w\u000e]=\u0015\u0013Y\fi$a\u0010\u0002B\u0005\r\u0003bB(\u000e!\u0003\u0005\r!\u0015\u0005\b-6\u0001\n\u00111\u0001Y\u0011\u001d!W\u0002%AA\u0002\u0019DqA[\u0007\u0011\u0002\u0003\u0007A.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005%#fA)\u0002L-\u0012\u0011Q\n\t\u0005\u0003\u001f\nI&\u0004\u0002\u0002R)!\u00111KA+\u0003%)hn\u00195fG.,GMC\u0002\u0002X}\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY&!\u0015\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0005$f\u0001-\u0002L\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA4U\r1\u00171J\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\tiGK\u0002m\u0003\u0017\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA:!\u0011\t)(a \u000e\u0005\u0005]$\u0002BA=\u0003w\nA\u0001\\1oO*\u0011\u0011QP\u0001\u0005U\u00064\u0018-C\u0002b\u0003o\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\"\u0011\u0007y\n9)C\u0002\u0002\n~\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a$\u0002\u0016B\u0019a(!%\n\u0007\u0005MuHA\u0002B]fD\u0011\"a&\u0015\u0003\u0003\u0005\r!!\"\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\n\u0005\u0004\u0002 \u0006\u0015\u0016qR\u0007\u0003\u0003CS1!a)@\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003O\u000b\tK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00014\u0002.\"I\u0011q\u0013\f\u0002\u0002\u0003\u0007\u0011qR\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002t\u0005M\u0006\"CAL/\u0005\u0005\t\u0019AAC\u0003\u0019)\u0017/^1mgR\u0019a-!/\t\u0013\u0005]\u0005$!AA\u0002\u0005=\u0015!\u0006#fg\u000e\u0014\u0018NY3D_2,XN\\\"p[6\fg\u000e\u001a\t\u0003ui\u0019RAGAa\u0003\u001b\u0004\u0012\"a1\u0002JFCf\r\u001c<\u000e\u0005\u0005\u0015'bAAd\u007f\u00059!/\u001e8uS6,\u0017\u0002BAf\u0003\u000b\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85!\u0011\ty-!6\u000e\u0005\u0005E'\u0002BAj\u0003w\n!![8\n\u00075\u000b\t\u000e\u0006\u0002\u0002>\u0006AAo\\*ue&tw\r\u0006\u0002\u0002t\u0005)\u0011\r\u001d9msRIa/!9\u0002d\u0006\u0015\u0018q\u001d\u0005\u0006\u001fv\u0001\r!\u0015\u0005\u0006-v\u0001\r\u0001\u0017\u0005\u0006Iv\u0001\rA\u001a\u0005\u0006Uv\u0001\r\u0001\\\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti/!?\u0011\u000by\ny/a=\n\u0007\u0005ExH\u0001\u0004PaRLwN\u001c\t\b}\u0005U\u0018\u000b\u00174m\u0013\r\t9p\u0010\u0002\u0007)V\u0004H.\u001a\u001b\t\u0011\u0005mh$!AA\u0002Y\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\t\u0001\u0005\u0003\u0002v\t\r\u0011\u0002\u0002B\u0003\u0003o\u0012aa\u00142kK\u000e$\b")
public class DescribeColumnCommand
extends LogicalPlan
implements LeafRunnableCommand,
Serializable {
    private final TableIdentifier table;
    private final Seq<String> colNameParts;
    private final boolean isExtended;
    private final Seq<Attribute> output;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<TableIdentifier, Seq<String>, Object, Seq<Attribute>>> unapply(DescribeColumnCommand x$0) {
        return DescribeColumnCommand$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<TableIdentifier, Seq<String>, Object, Seq<Attribute>>, DescribeColumnCommand> tupled() {
        return DescribeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Seq<String>, Function1<Object, Function1<Seq<Attribute>, DescribeColumnCommand>>>> curried() {
        return DescribeColumnCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        DescribeColumnCommand describeColumnCommand = this;
        synchronized (describeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier table() {
        return this.table;
    }

    public Seq<String> colNameParts() {
        return this.colNameParts;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        BoxedUnit boxedUnit;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        Function2 resolver = sparkSession.sessionState().conf().resolver();
        LogicalPlan relation = sparkSession.table(this.table()).queryExecution().analyzed();
        String colName = new UnresolvedAttribute(this.colNameParts()).name();
        NamedExpression field = (NamedExpression)relation.resolve(this.colNameParts(), resolver).getOrElse((Function0 & Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.columnDoesNotExistError(colName);
        });
        if (!(field instanceof Attribute)) {
            throw QueryCompilationErrors$.MODULE$.commandNotSupportNestedColumnError("DESC TABLE COLUMN", colName);
        }
        CatalogTable catalogTable = catalog.getTempViewOrPermanentTableMetadata(this.table());
        Map colStatsMap = (Map)catalogTable.stats().map((Function1 & Serializable)x$6 -> x$6.colStats()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
        Map colStats = this.conf().caseSensitiveAnalysis() ? colStatsMap : CaseInsensitiveMap$.MODULE$.apply(colStatsMap);
        Option cs = colStats.get((Object)field.name());
        None$ comment = field.metadata().contains("comment") ? Option$.MODULE$.apply((Object)field.metadata().getString("comment")) : None$.MODULE$;
        String dataType = ((DataType)CharVarcharUtils$.MODULE$.getRawType(field.metadata()).getOrElse((Function0 & Serializable)() -> ((Expression)field).dataType())).catalogString();
        ArrayBuffer buffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", field.name()})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", dataType})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"comment", comment.getOrElse((Function0 & Serializable)() -> "NULL")}))}));
        if (this.isExtended()) {
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"min", cs.flatMap((Function1 & Serializable)x$7 -> x$7.min().map((Function1 & Serializable)x$8 -> this.toZoneAwareExternalString((String)x$8, field.name(), ((Expression)field).dataType()))).getOrElse((Function0 & Serializable)() -> "NULL")})));
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"max", cs.flatMap((Function1 & Serializable)x$9 -> x$9.max().map((Function1 & Serializable)x$10 -> this.toZoneAwareExternalString((String)x$10, field.name(), ((Expression)field).dataType()))).getOrElse((Function0 & Serializable)() -> "NULL")})));
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"num_nulls", cs.flatMap((Function1 & Serializable)x$11 -> x$11.nullCount().map((Function1 & Serializable)x$12 -> x$12.toString())).getOrElse((Function0 & Serializable)() -> "NULL")})));
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"distinct_count", cs.flatMap((Function1 & Serializable)x$13 -> x$13.distinctCount().map((Function1 & Serializable)x$14 -> x$14.toString())).getOrElse((Function0 & Serializable)() -> "NULL")})));
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"avg_col_len", cs.flatMap((Function1 & Serializable)x$15 -> x$15.avgLen().map((Function1 & Serializable)x$16 -> DescribeColumnCommand.$anonfun$run$32(BoxesRunTime.unboxToLong((Object)x$16)))).getOrElse((Function0 & Serializable)() -> "NULL")})));
            buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"max_col_len", cs.flatMap((Function1 & Serializable)x$17 -> x$17.maxLen().map((Function1 & Serializable)x$18 -> DescribeColumnCommand.$anonfun$run$35(BoxesRunTime.unboxToLong((Object)x$18)))).getOrElse((Function0 & Serializable)() -> "NULL")})));
            Option histDesc = cs.flatMap((Function1 & Serializable)c -> c.histogram().map((Function1 & Serializable)hist -> this.histogramDescription((Histogram)hist)));
            boxedUnit = buffer.$plus$plus$eq((IterableOnce)histDesc.getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"histogram", "NULL"}))}))));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return buffer.toSeq();
    }

    private String toZoneAwareExternalString(String valueStr, String name, DataType dataType) {
        String string;
        DataType dataType2 = dataType;
        if (TimestampType$.MODULE$.equals(dataType2)) {
            Object internalValue = CatalogColumnStat$.MODULE$.fromExternalString(valueStr, name, dataType, CatalogColumnStat$.MODULE$.VERSION());
            ZoneId curZoneId = DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone());
            string = CatalogColumnStat$.MODULE$.getTimestampFormatter(false, "yyyy-MM-dd HH:mm:ss.SSSSSS Z", curZoneId).format(BoxesRunTime.unboxToLong((Object)internalValue));
        } else {
            string = valueStr;
        }
        return string;
    }

    private Seq<Row> histogramDescription(Histogram histogram) {
        Row header = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"histogram", new StringBuilder(23).append("height: ").append(histogram.height()).append(", num_of_bins: ").append(histogram.bins().length).toString()}));
        Row[] bins = (Row[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])histogram.bins()))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            HistogramBin bin = (HistogramBin)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(4).append("bin_").append(index).toString(), new StringBuilder(46).append("lower_bound: ").append(bin.lo()).append(", upper_bound: ").append(bin.hi()).append(", distinct_count: ").append(bin.ndv()).toString()}));
            return row;
        }, ClassTag$.MODULE$.apply(Row.class));
        Row row = header;
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])bins), (Object)row, ClassTag$.MODULE$.apply(Row.class)));
    }

    public DescribeColumnCommand copy(TableIdentifier table, Seq<String> colNameParts, boolean isExtended, Seq<Attribute> output) {
        return new DescribeColumnCommand(table, colNameParts, isExtended, output);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public Seq<String> copy$default$2() {
        return this.colNameParts();
    }

    public boolean copy$default$3() {
        return this.isExtended();
    }

    public Seq<Attribute> copy$default$4() {
        return this.output();
    }

    public String productPrefix() {
        return "DescribeColumnCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.table();
                break;
            }
            case 1: {
                object = this.colNameParts();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isExtended());
                break;
            }
            case 3: {
                object = this.output();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DescribeColumnCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "table";
                break;
            }
            case 1: {
                string = "colNameParts";
                break;
            }
            case 2: {
                string = "isExtended";
                break;
            }
            case 3: {
                string = "output";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DescribeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DescribeColumnCommand describeColumnCommand = (DescribeColumnCommand)x$1;
        if (this.isExtended() != describeColumnCommand.isExtended()) return false;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = describeColumnCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<String> seq = this.colNameParts();
        Seq<String> seq2 = describeColumnCommand.colNameParts();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<Attribute> seq3 = this.output();
        Seq<Attribute> seq4 = describeColumnCommand.output();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        if (!describeColumnCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ String $anonfun$run$32(long x$16) {
        return Long.toString(x$16);
    }

    public static final /* synthetic */ String $anonfun$run$35(long x$18) {
        return Long.toString(x$18);
    }

    public DescribeColumnCommand(TableIdentifier table, Seq<String> colNameParts, boolean isExtended, Seq<Attribute> output) {
        this.table = table;
        this.colNameParts = colNameParts;
        this.isExtended = isExtended;
        this.output = output;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
        Statics.releaseFence();
    }
}

