/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MetadataBuilder;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0005\tMb!\u0002\u000e\u001c\u0003\u00031\u0003\"B \u0001\t\u0003\u0001\u0005\"B\"\u0001\r\u0003!\u0005\"\u0002*\u0001\t\u0003\u0019\u0006\"B6\u0001\t\u0003a\u0007\"B:\u0001\t\u0003!\b\"B<\u0001\t\u0003A\b\"B>\u0001\t\u0003a\bbBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003\u001f\u0001A\u0011AA\u000e\u0011%\tY\u0003AI\u0001\n\u0003\ti\u0003C\u0004\u0002B\u0001!\t!a\u0011\t\u0011\u0005\u001d\u0004\u0001\"\u0005\u001c\u0003SBq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002\u0000\u0001!\t!!!\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\"9\u0011q\u0012\u0001\u0005\u0002\u0005E\u0005bBA^\u0001\u0011\u0005\u0011Q\u0018\u0005\b\u0003\u0013\u0004A\u0011AAf\u0011\u001d\t9\u000e\u0001C\u0001\u00033Dq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002l\u0002!\t!!<\t\u000f\u0005]\b\u0001\"\u0001\u0002z\"9!\u0011\u0001\u0001\u0005\u0002\t\r\u0001b\u0002B\u0006\u0001\u0011\u0005!Q\u0002\u0005\b\u0005#\u0001A\u0011\u0001B\n\u0005-QEMY2ES\u0006dWm\u0019;\u000b\u0005qi\u0012\u0001\u00026eE\u000eT!AH\u0010\u0002\u0007M\fHN\u0003\u0002!C\u0005)1\u000f]1sW*\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u0014.sA\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\u0004\"A\f\u001c\u000f\u0005=\"dB\u0001\u00194\u001b\u0005\t$B\u0001\u001a&\u0003\u0019a$o\\8u}%\t!&\u0003\u00026S\u00059\u0001/Y2lC\u001e,\u0017BA\u001c9\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t)\u0014\u0006\u0005\u0002;{5\t1H\u0003\u0002=?\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002?w\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001B!\t\u0011\u0005!D\u0001\u001c\u0003%\u0019\u0017M\u001c%b]\u0012dW\r\u0006\u0002F\u0011B\u0011\u0001FR\u0005\u0003\u000f&\u0012qAQ8pY\u0016\fg\u000eC\u0003J\u0005\u0001\u0007!*A\u0002ve2\u0004\"aS(\u000f\u00051k\u0005C\u0001\u0019*\u0013\tq\u0015&\u0001\u0004Qe\u0016$WMZ\u0005\u0003!F\u0013aa\u0015;sS:<'B\u0001(*\u0003=9W\r^\"bi\u0006d\u0017p\u001d;UsB,G#\u0002+^E\u00124\u0007c\u0001\u0015V/&\u0011a+\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005a[V\"A-\u000b\u0005ik\u0012!\u0002;za\u0016\u001c\u0018B\u0001/Z\u0005!!\u0015\r^1UsB,\u0007\"\u00020\u0004\u0001\u0004y\u0016aB:rYRK\b/\u001a\t\u0003Q\u0001L!!Y\u0015\u0003\u0007%sG\u000fC\u0003d\u0007\u0001\u0007!*\u0001\u0005usB,g*Y7f\u0011\u0015)7\u00011\u0001`\u0003\u0011\u0019\u0018N_3\t\u000b\u001d\u001c\u0001\u0019\u00015\u0002\u00055$\u0007C\u0001-j\u0013\tQ\u0017LA\bNKR\fG-\u0019;b\u0005VLG\u000eZ3s\u0003-9W\r\u001e&E\u0005\u000e#\u0016\u0010]3\u0015\u00055\f\bc\u0001\u0015V]B\u0011!i\\\u0005\u0003an\u0011\u0001B\u00133cGRK\b/\u001a\u0005\u0006e\u0012\u0001\raV\u0001\u0003IR\fq\"];pi\u0016LE-\u001a8uS\u001aLWM\u001d\u000b\u0003\u0015VDQA^\u0003A\u0002)\u000bqaY8m\u001d\u0006lW-A\nhKR$\u0016M\u00197f\u000bbL7\u000f^:Rk\u0016\u0014\u0018\u0010\u0006\u0002Ks\")!P\u0002a\u0001\u0015\u0006)A/\u00192mK\u0006qq-\u001a;TG\",W.Y)vKJLHC\u0001&~\u0011\u0015Qx\u00011\u0001KQ\u00119q0a\u0003\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002 \u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0013\t\u0019AA\u0003TS:\u001cW-\t\u0002\u0002\u000e\u0005)!GL\u0019/a\u0005\u0001r-\u001a;UeVt7-\u0019;f#V,'/\u001f\u000b\u0004\u0015\u0006M\u0001\"\u0002>\t\u0001\u0004Q\u0005\u0006\u0002\u0005\u0000\u0003/\t#!!\u0007\u0002\u000bIr3G\f\u0019\u0015\u000b)\u000bi\"a\b\t\u000biL\u0001\u0019\u0001&\t\u0013\u0005\u0005\u0012\u0002%AA\u0002\u0005\r\u0012aB2bg\u000e\fG-\u001a\t\u0004QU+\u0005\u0006B\u0005\u0000\u0003O\t#!!\u000b\u0002\u000bIrCG\f\u0019\u00025\u001d,G\u000f\u0016:v]\u000e\fG/Z)vKJLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005=\"\u0006BA\u0012\u0003cY#!a\r\u0011\t\u0005U\u0012QH\u0007\u0003\u0003oQA!!\u000f\u0002<\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000bI\u0013\u0002BA \u0003o\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003-\u0011WMZ8sK\u001a+Go\u00195\u0015\r\u0005\u0015\u00131JA/!\rA\u0013qI\u0005\u0004\u0003\u0013J#\u0001B+oSRDq!!\u0014\f\u0001\u0004\ty%\u0001\u0006d_:tWm\u0019;j_:\u0004B!!\u0015\u0002Z5\u0011\u00111\u000b\u0006\u0004=\u0005U#BAA,\u0003\u0011Q\u0017M^1\n\t\u0005m\u00131\u000b\u0002\u000b\u0007>tg.Z2uS>t\u0007bBA0\u0017\u0001\u0007\u0011\u0011M\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\b#B&\u0002d)S\u0015bAA3#\n\u0019Q*\u00199\u0002\u0013\u0015\u001c8-\u00199f'FdGc\u0001&\u0002l!1\u0011Q\u000e\u0007A\u0002)\u000bQA^1mk\u0016DC\u0001D@\u0002\u0018\u0005a1m\\7qS2,g+\u00197vKR!\u0011QOA>!\rA\u0013qO\u0005\u0004\u0003sJ#aA!os\"9\u0011QN\u0007A\u0002\u0005U\u0004\u0006B\u0007\u0000\u0003/\t\u0001$[:DCN\u001c\u0017\rZ5oOR\u0013XO\\2bi\u0016$\u0016M\u00197f)\t\t\u0019#A\u0006sK:\fW.\u001a+bE2,G#\u0002&\u0002\b\u0006-\u0005BBAE\u001f\u0001\u0007!*\u0001\u0005pY\u0012$\u0016M\u00197f\u0011\u0019\tii\u0004a\u0001\u0015\u0006Aa.Z<UC\ndW-\u0001\u0006bYR,'\u000fV1cY\u0016$\u0002\"a%\u0002\u001a\u0006u\u0015q\u0017\t\u0005Q\u0005U%*C\u0002\u0002\u0018&\u0012Q!\u0011:sCfDa!a'\u0011\u0001\u0004Q\u0015!\u0003;bE2,g*Y7f\u0011\u001d\ty\n\u0005a\u0001\u0003C\u000bqa\u00195b]\u001e,7\u000fE\u0003/\u0003G\u000b9+C\u0002\u0002&b\u00121aU3r!\u0011\tI+a-\u000e\u0005\u0005-&\u0002BAW\u0003_\u000bqaY1uC2|wMC\u0002\u00022v\t\u0011bY8o]\u0016\u001cGo\u001c:\n\t\u0005U\u00161\u0016\u0002\f)\u0006\u0014G.Z\"iC:<W\r\u0003\u0004\u0002:B\u0001\raX\u0001\u000fI\nl\u0015M[8s-\u0016\u00148/[8o\u0003E9W\r^!eI\u000e{G.^7o#V,'/\u001f\u000b\b\u0015\u0006}\u0016\u0011YAc\u0011\u0019\tY*\u0005a\u0001\u0015\"1\u00111Y\tA\u0002)\u000b!bY8mk6tg*Y7f\u0011\u0019\t9-\u0005a\u0001\u0015\u0006AA-\u0019;b)f\u0004X-\u0001\u000bhKR\u0014VM\\1nK\u000e{G.^7o#V,'/\u001f\u000b\n\u0015\u00065\u0017qZAi\u0003+Da!a'\u0013\u0001\u0004Q\u0005BBAb%\u0001\u0007!\n\u0003\u0004\u0002TJ\u0001\rAS\u0001\b]\u0016<h*Y7f\u0011\u0019\tIL\u0005a\u0001?\u0006!r-\u001a;EK2,G/Z\"pYVlg.U;fef$RASAn\u0003;Da!a'\u0014\u0001\u0004Q\u0005BBAb'\u0001\u0007!*\u0001\rhKR,\u0006\u000fZ1uK\u000e{G.^7o)f\u0004X-U;fef$rASAr\u0003K\f9\u000f\u0003\u0004\u0002\u001cR\u0001\rA\u0013\u0005\u0007\u0003\u0007$\u0002\u0019\u0001&\t\r\u0005%H\u00031\u0001K\u0003-qWm\u001e#bi\u0006$\u0016\u0010]3\u0002?\u001d,G/\u00169eCR,7i\u001c7v[:tU\u000f\u001c7bE&d\u0017\u000e^=Rk\u0016\u0014\u0018\u0010F\u0004K\u0003_\f\t0a=\t\r\u0005mU\u00031\u0001K\u0011\u0019\t\u0019-\u0006a\u0001\u0015\"1\u0011Q_\u000bA\u0002\u0015\u000b!\"[:Ok2d\u0017M\u00197f\u0003Q9W\r\u001e+bE2,7i\\7nK:$\u0018+^3ssR)!*a?\u0002~\")!P\u0006a\u0001\u0015\"1\u0011q \fA\u0002)\u000bqaY8n[\u0016tG/A\u000bhKR\u001c6\r[3nC\u000e{W.\\3oiF+XM]=\u0015\u000b)\u0013)A!\u0003\t\r\t\u001dq\u00031\u0001K\u0003\u0019\u00198\r[3nC\"1\u0011q`\fA\u0002)\u000b\u0001D]3n_Z,7k\u00195f[\u0006\u001cu.\\7f]R\fV/\u001a:z)\rQ%q\u0002\u0005\u0007\u0005\u000fA\u0002\u0019\u0001&\u0002#\rd\u0017m]:jMf,\u0005pY3qi&|g\u000e\u0006\u0004\u0003\u0016\tu!\u0011\u0005\t\u0005\u0005/\u0011I\"D\u0001\u001e\u0013\r\u0011Y\"\b\u0002\u0012\u0003:\fG._:jg\u0016C8-\u001a9uS>t\u0007B\u0002B\u00103\u0001\u0007!*A\u0004nKN\u001c\u0018mZ3\t\u000f\t\r\u0012\u00041\u0001\u0003&\u0005\tQ\rE\u0002/\u0005OI1A!\u000b9\u0005%!\u0006N]8xC\ndW\rK\u0002\u0001\u0005[\u0001B!!\u0001\u00030%!!\u0011GA\u0002\u00051!UM^3m_B,'/\u00119j\u0001")
public abstract class JdbcDialect
implements Serializable,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract boolean canHandle(String var1);

    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        return None$.MODULE$;
    }

    public Option<JdbcType> getJDBCType(DataType dt) {
        return None$.MODULE$;
    }

    public String quoteIdentifier(String colName) {
        return new StringBuilder(2).append("\"").append(colName).append("\"").toString();
    }

    public String getTableExistsQuery(String table) {
        return new StringBuilder(24).append("SELECT * FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getSchemaQuery(String table) {
        return new StringBuilder(24).append("SELECT * FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getTruncateQuery(String table) {
        return this.getTruncateQuery(table, this.isCascadingTruncateTable());
    }

    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(15).append("TRUNCATE TABLE ").append(table).toString();
    }

    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    public void beforeFetch(Connection connection, Map<String, String> properties) {
    }

    public String escapeSql(String value) {
        return value == null ? null : StringUtils.replace((String)value, (String)"'", (String)"''");
    }

    public Object compileValue(Object value2) {
        Object object;
        Object object2 = value2;
        if (object2 instanceof String) {
            String string = (String)object2;
            object = new StringBuilder(2).append("'").append(this.escapeSql(string)).append("'").toString();
        } else if (object2 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object2;
            object = new StringBuilder(2).append("'").append(timestamp).append("'").toString();
        } else if (object2 instanceof Instant) {
            Instant instant = (Instant)object2;
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.getFractionFormatter(DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
            object = new StringBuilder(2).append("'").append(timestampFormatter.format(instant)).append("'").toString();
        } else if (object2 instanceof Date) {
            Date date = (Date)object2;
            object = new StringBuilder(2).append("'").append(date).append("'").toString();
        } else if (object2 instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object2;
            object = new StringBuilder(2).append("'").append(DateFormatter$.MODULE$.apply().format(localDate)).append("'").toString();
        } else if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            object = Predef$.MODULE$.genericWrapArray(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)objectArray), (Function1 & Serializable)value -> this.compileValue(value), ClassTag$.MODULE$.Any())).mkString(", ");
        } else {
            object = value2;
        }
        return object;
    }

    public Option<Object> isCascadingTruncateTable() {
        return None$.MODULE$;
    }

    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(23).append("ALTER TABLE ").append(oldTable).append(" RENAME TO ").append(newTable).toString();
    }

    public String[] alterTable(String tableName, Seq<TableChange> changes, int dbMajorVersion) {
        ArrayBuilder updateClause = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(String.class));
        changes.foreach((Function1 & Serializable)change -> {
            TableChange.UpdateColumnNullability updateColumnNullability;
            TableChange.UpdateColumnType updateColumnType;
            TableChange.DeleteColumn deleteColumn;
            TableChange.RenameColumn renameColumn;
            ArrayBuilder arrayBuilder;
            TableChange.AddColumn addColumn;
            TableChange tableChange = change;
            if (tableChange instanceof TableChange.AddColumn && (addColumn = (TableChange.AddColumn)tableChange).fieldNames().length == 1) {
                String dataType = JdbcUtils$.MODULE$.getJdbcType(addColumn.dataType(), this).databaseTypeDefinition();
                String[] name = addColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getAddColumnQuery(tableName, name[0], dataType));
            } else if (tableChange instanceof TableChange.RenameColumn && (renameColumn = (TableChange.RenameColumn)tableChange).fieldNames().length == 1) {
                String[] name = renameColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getRenameColumnQuery(tableName, name[0], renameColumn.newName(), dbMajorVersion));
            } else if (tableChange instanceof TableChange.DeleteColumn && (deleteColumn = (TableChange.DeleteColumn)tableChange).fieldNames().length == 1) {
                String[] name = deleteColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getDeleteColumnQuery(tableName, name[0]));
            } else if (tableChange instanceof TableChange.UpdateColumnType && (updateColumnType = (TableChange.UpdateColumnType)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnType.fieldNames();
                String dataType = JdbcUtils$.MODULE$.getJdbcType(updateColumnType.newDataType(), this).databaseTypeDefinition();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnTypeQuery(tableName, name[0], dataType));
            } else if (tableChange instanceof TableChange.UpdateColumnNullability && (updateColumnNullability = (TableChange.UpdateColumnNullability)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnNullability.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnNullabilityQuery(tableName, name[0], updateColumnNullability.nullable()));
            } else {
                throw QueryCompilationErrors$.MODULE$.unsupportedTableChangeInJDBCCatalogError(change);
            }
            return arrayBuilder;
        });
        return (String[])updateClause.result();
    }

    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" ADD COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(dataType).toString();
    }

    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        return new StringBuilder(0).append(new StringBuilder(30).append("ALTER TABLE ").append(tableName).append(" RENAME COLUMN ").append(this.quoteIdentifier(columnName)).append(" TO").toString()).append(new StringBuilder(1).append(" ").append(this.quoteIdentifier(newName)).toString()).toString();
    }

    public String getDeleteColumnQuery(String tableName, String columnName) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" DROP COLUMN ").append(this.quoteIdentifier(columnName)).toString();
    }

    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(newDataType).toString();
    }

    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return new StringBuilder(31).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" SET ").append(nullable).toString();
    }

    public String getTableCommentQuery(String table, String comment) {
        return new StringBuilder(23).append("COMMENT ON TABLE ").append(table).append(" IS '").append(comment).append("'").toString();
    }

    public String getSchemaCommentQuery(String schema, String comment) {
        return new StringBuilder(24).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS '").append(comment).append("'").toString();
    }

    public String removeSchemaCommentQuery(String schema) {
        return new StringBuilder(26).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS NULL").toString();
    }

    public AnalysisException classifyException(String message, Throwable e) {
        String x$1 = message;
        Some x$2 = new Some((Object)e);
        Option x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
        Option x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$6();
        String[] x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$7();
        return new AnalysisException(x$1, x$3, x$4, x$5, (Option)x$2, x$6, x$7);
    }

    public JdbcDialect() {
        Logging.$init$((Logging)this);
    }
}

