/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcOutputFormat;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapreduce.OrcInputFormat;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.WholeStageCodegenExec$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnarBatchReader;
import org.apache.spark.sql.execution.datasources.orc.OrcDeserializer;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat$;
import org.apache.spark.sql.execution.datasources.orc.OrcFilters$;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.execution.datasources.orc.OrcOutputWriter;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005MwAB\n\u0015\u0011\u0003Q\"E\u0002\u0004%)!\u0005!$\n\u0005\u0006i\u0005!\tA\u000e\u0005\u0006o\u0005!\t\u0001\u000f\u0005\b\u0019\u0006\t\t\u0011\"\u0003N\r\u0011!C\u0003\u0001+\t\u000bQ*A\u0011A0\t\u000b\u0005,A\u0011\t2\t\u000b\r,A\u0011\t2\t\u000b\u0011,A\u0011I3\t\u000b%,A\u0011\t6\t\u000bM,A\u0011\t;\t\u000f\u0005MR\u0001\"\u0011\u00026!9\u0011QK\u0003\u0005\n\u0005]\u0003bBA0\u000b\u0011\u0005\u0013\u0011\r\u0005\b\u0003O*A\u0011IA5\u0011\u001d\tI(\u0002C!\u0003wBq!!2\u0006\t\u0003\n9\rC\u0004\u0002L\u0016!\t%!4\u0002\u001b=\u00138MR5mK\u001a{'/\\1u\u0015\t)b#A\u0002pe\u000eT!a\u0006\r\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u00033i\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005ma\u0012aA:rY*\u0011QDH\u0001\u0006gB\f'o\u001b\u0006\u0003?\u0001\na!\u00199bG\",'\"A\u0011\u0002\u0007=\u0014x\r\u0005\u0002$\u00035\tACA\u0007Pe\u000e4\u0015\u000e\\3G_Jl\u0017\r^\n\u0004\u0003\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g\r\u0005\u0002.e5\taF\u0003\u00020a\u0005\u0011\u0011n\u001c\u0006\u0002c\u0005!!.\u0019<b\u0013\t\u0019dF\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0011\u0013!F4fiF+x\u000e^3e'\u000eDW-\\1TiJLgn\u001a\u000b\u0003s\u0011\u0003\"AO!\u000f\u0005mz\u0004C\u0001\u001f)\u001b\u0005i$B\u0001 6\u0003\u0019a$o\\8u}%\u0011\u0001\tK\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%AB*ue&twM\u0003\u0002AQ!)Qi\u0001a\u0001\r\u0006AA-\u0019;b)f\u0004X\r\u0005\u0002H\u00156\t\u0001J\u0003\u0002J5\u0005)A/\u001f9fg&\u00111\n\u0013\u0002\t\t\u0006$\u0018\rV=qK\u0006aqO]5uKJ+\u0007\u000f\\1dKR\ta\n\u0005\u0002P%6\t\u0001K\u0003\u0002Ra\u0005!A.\u00198h\u0013\t\u0019\u0006K\u0001\u0004PE*,7\r^\n\u0006\u000b\u0019*\u0016\f\f\t\u0003-^k\u0011AF\u0005\u00031Z\u0011!BR5mK\u001a{'/\\1u!\tQV,D\u0001\\\u0015\ta&$A\u0004t_V\u00148-Z:\n\u0005y[&A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ$\u0012\u0001\u0019\t\u0003G\u0015\t\u0011b\u001d5peRt\u0015-\\3\u0015\u0003e\n\u0001\u0002^8TiJLgnZ\u0001\tQ\u0006\u001c\bnQ8eKR\ta\r\u0005\u0002(O&\u0011\u0001\u000e\u000b\u0002\u0004\u0013:$\u0018AB3rk\u0006d7\u000f\u0006\u0002l]B\u0011q\u0005\\\u0005\u0003[\"\u0012qAQ8pY\u0016\fg\u000eC\u0003p\u0015\u0001\u0007\u0001/A\u0003pi\",'\u000f\u0005\u0002(c&\u0011!\u000f\u000b\u0002\u0004\u0003:L\u0018aC5oM\u0016\u00148k\u00195f[\u0006$b!^>\u0002\u0004\u00055\u0001cA\u0014wq&\u0011q\u000f\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u001dK\u0018B\u0001>I\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006y.\u0001\r!`\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003}~l\u0011AG\u0005\u0004\u0003\u0003Q\"\u0001D*qCJ\\7+Z:tS>t\u0007bBA\u0003\u0017\u0001\u0007\u0011qA\u0001\b_B$\u0018n\u001c8t!\u0015Q\u0014\u0011B\u001d:\u0013\r\tYa\u0011\u0002\u0004\u001b\u0006\u0004\bbBA\b\u0017\u0001\u0007\u0011\u0011C\u0001\u0006M&dWm\u001d\t\u0007\u0003'\ti\"a\t\u000f\t\u0005U\u0011\u0011\u0004\b\u0004y\u0005]\u0011\"A\u0015\n\u0007\u0005m\u0001&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0011\u0011\u0005\u0002\u0004'\u0016\f(bAA\u000eQA!\u0011QEA\u0018\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012A\u00014t\u0015\r\tiCH\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005E\u0012q\u0005\u0002\u000b\r&dWm\u0015;biV\u001c\u0018\u0001\u00049sKB\f'/Z,sSR,GCCA\u001c\u0003{\ty$a\u0014\u0002RA\u0019a+!\u000f\n\u0007\u0005mbCA\nPkR\u0004X\u000f^,sSR,'OR1di>\u0014\u0018\u0010C\u0003}\u0019\u0001\u0007Q\u0010C\u0004\u0002B1\u0001\r!a\u0011\u0002\u0007)|'\r\u0005\u0003\u0002F\u0005-SBAA$\u0015\u0011\tI%a\u000b\u0002\u00135\f\u0007O]3ek\u000e,\u0017\u0002BA'\u0003\u000f\u00121AS8c\u0011\u001d\t)\u0001\u0004a\u0001\u0003\u000fAa!a\u0015\r\u0001\u0004A\u0018A\u00033bi\u0006\u001c6\r[3nC\u0006Y2/\u001e9q_J$()\u0019;dQ\u001a{'OT3ti\u0016$7i\u001c7v[:$Ra[A-\u00037BQ\u0001`\u0007A\u0002uDa!!\u0018\u000e\u0001\u0004A\u0018AB:dQ\u0016l\u0017-\u0001\u0007tkB\u0004xN\u001d;CCR\u001c\u0007\u000eF\u0003l\u0003G\n)\u0007C\u0003}\u001d\u0001\u0007Q\u0010\u0003\u0004\u0002^9\u0001\r\u0001_\u0001\fSN\u001c\u0006\u000f\\5uC\ndW\rF\u0004l\u0003W\ni'a\u001c\t\u000bq|\u0001\u0019A?\t\u000f\u0005\u0015q\u00021\u0001\u0002\b!9\u0011\u0011O\bA\u0002\u0005M\u0014\u0001\u00029bi\"\u0004B!!\n\u0002v%!\u0011qOA\u0014\u0005\u0011\u0001\u0016\r\u001e5\u0002=\t,\u0018\u000e\u001c3SK\u0006$WM],ji\"\u0004\u0016M\u001d;ji&|gNV1mk\u0016\u001cH\u0003EA?\u00037\u000bi*a(\u0002$\u0006\u001d\u00161WA[!\u001d9\u0013qPAB\u0003\u0013K1!!!)\u0005%1UO\\2uS>t\u0017\u0007E\u0002W\u0003\u000bK1!a\"\u0017\u0005=\u0001\u0016M\u001d;ji&|g.\u001a3GS2,\u0007CBA\n\u0003\u0017\u000by)\u0003\u0003\u0002\u000e\u0006\u0005\"\u0001C%uKJ\fGo\u001c:\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'S1!!&\u001b\u0003!\u0019\u0017\r^1msN$\u0018\u0002BAM\u0003'\u00131\"\u00138uKJt\u0017\r\u001c*po\")A\u0010\u0005a\u0001{\"1\u00111\u000b\tA\u0002aDa!!)\u0011\u0001\u0004A\u0018a\u00049beRLG/[8o'\u000eDW-\\1\t\r\u0005\u0015\u0006\u00031\u0001y\u00039\u0011X-];je\u0016$7k\u00195f[\u0006Dq!!+\u0011\u0001\u0004\tY+A\u0004gS2$XM]:\u0011\r\u0005M\u0011QDAW!\rQ\u0016qV\u0005\u0004\u0003c[&A\u0002$jYR,'\u000fC\u0004\u0002\u0006A\u0001\r!a\u0002\t\u000f\u0005]\u0006\u00031\u0001\u0002:\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u0005m\u0016\u0011Y\u0007\u0003\u0003{SA!a0\u0002,\u0005!1m\u001c8g\u0013\u0011\t\u0019-!0\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003=\u0019X\u000f\u001d9peR$\u0015\r^1UsB,GcA6\u0002J\")Q)\u0005a\u0001\r\u0006\u00012/\u001e9q_J$h)[3mI:\u000bW.\u001a\u000b\u0004W\u0006=\u0007BBAi%\u0001\u0007\u0011(\u0001\u0003oC6,\u0007")
public class OrcFileFormat
implements FileFormat,
DataSourceRegister,
Serializable {
    public static String getQuotedSchemaString(DataType dataType) {
        return OrcFileFormat$.MODULE$.getQuotedSchemaString(dataType);
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$(this, requiredSchema, partitionSchema, sqlConf);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public String shortName() {
        return "orc";
    }

    public String toString() {
        return "ORC";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof OrcFileFormat;
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return OrcUtils$.MODULE$.inferSchema(sparkSession, files, options);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        OrcOptions orcOptions = new OrcOptions(options, sparkSession.sessionState().conf());
        Configuration conf = job.getConfiguration();
        conf.set(OrcConf.MAPRED_OUTPUT_SCHEMA.getAttribute(), OrcFileFormat$.MODULE$.getQuotedSchemaString((DataType)dataSchema));
        conf.set(OrcConf.COMPRESS.getAttribute(), orcOptions.compressionCodec());
        ((JobConf)conf).setOutputFormat(OrcOutputFormat.class);
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new OrcOutputWriter(path, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                String name = context.getConfiguration().get(OrcConf.COMPRESS.getAttribute());
                String compressionExtension = (String)OrcUtils$.MODULE$.extensionsForCompressionCodecNames().getOrElse((Object)name, (Function0 & Serializable)() -> "");
                return new StringBuilder(4).append(compressionExtension).append(".orc").toString();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getFileExtension$1()}, serializedLambda);
            }
        };
    }

    private boolean supportBatchForNestedColumn(SparkSession sparkSession, StructType schema) {
        boolean hasNestedColumn = ((IterableOnceOps)schema.map((Function1 & Serializable)x$1 -> x$1.dataType())).exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)OrcFileFormat.$anonfun$supportBatchForNestedColumn$2(x0$1)));
        return hasNestedColumn ? sparkSession.sessionState().conf().orcVectorizedReaderNestedColumnEnabled() : true;
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return conf.orcVectorizedReaderEnabled() && conf.wholeStageEnabled() && !WholeStageCodegenExec$.MODULE$.isTooManyFields(conf, (DataType)schema) && schema.forall((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)OrcFileFormat.$anonfun$supportBatch$1(this, s))) && this.supportBatchForNestedColumn(sparkSession, schema);
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        StructType resultSchema = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields()), (Object)partitionSchema.fields(), ClassTag$.MODULE$.apply(StructField.class)));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableVectorizedReader = this.supportBatch(sparkSession, resultSchema);
        int capacity = sqlConf.orcVectorizedReaderBatchSize();
        OrcConf.IS_SCHEMA_EVOLUTION_CASE_SENSITIVE.setBoolean(hadoopConf, sqlConf.caseSensitiveAnalysis());
        Broadcast broadcastedConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        boolean isCaseSensitive = sparkSession.sessionState().conf().caseSensitiveAnalysis();
        boolean orcFilterPushDown = sparkSession.sessionState().conf().orcFilterPushDown();
        boolean ignoreCorruptFiles = sparkSession.sessionState().conf().ignoreCorruptFiles();
        return (Function1 & Serializable)file -> {
            Iterator iterator;
            Configuration conf = ((SerializableConfiguration)broadcastedConf.value()).value();
            Path filePath = new Path(new URI(file.filePath()));
            FileSystem fs = filePath.getFileSystem(conf);
            OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)conf).filesystem(fs);
            Option resultedColPruneInfo = (Option)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)readerOptions), (Function1 & Serializable)reader -> OrcUtils$.MODULE$.requestedColumnIds(isCaseSensitive, dataSchema, requiredSchema, (Reader)reader, conf));
            if (resultedColPruneInfo.isEmpty()) {
                iterator = package$.MODULE$.Iterator().empty();
            } else {
                Tuple2 tuple2;
                if (orcFilterPushDown && filters.nonEmpty()) {
                    OrcUtils$.MODULE$.readCatalystSchema(filePath, conf, ignoreCorruptFiles).foreach((Function1 & Serializable)fileSchema -> {
                        OrcFileFormat.$anonfun$buildReaderWithPartitionValues$4(filters, conf, fileSchema);
                        return BoxedUnit.UNIT;
                    });
                }
                if ((tuple2 = (Tuple2)resultedColPruneInfo.get()) == null) {
                    throw new MatchError((Object)tuple2);
                }
                int[] requestedColIds = (int[])tuple2._1();
                boolean canPruneCols = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = new Tuple2((Object)requestedColIds, (Object)BoxesRunTime.boxToBoolean((boolean)canPruneCols));
                Tuple2 tuple23 = tuple22;
                int[] requestedColIds2 = (int[])tuple23._1();
                boolean canPruneCols2 = tuple23._2$mcZ$sp();
                String resultSchemaString = OrcUtils$.MODULE$.orcResultSchemaString(canPruneCols2, dataSchema, resultSchema, partitionSchema, conf);
                Predef$.MODULE$.assert(requestedColIds2.length == requiredSchema.length(), (Function0 & Serializable)() -> "[BUG] requested column IDs do not match required schema");
                Configuration taskConf = new Configuration(conf);
                String includeColumns = Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.intArrayOps(requestedColIds2), (Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> x$3 != -1)), (Ordering)Ordering.Int$.MODULE$)).mkString(",");
                taskConf.set(OrcConf.INCLUDE_COLUMNS.getAttribute(), includeColumns);
                FileSplit fileSplit = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(taskConf, attemptId);
                if (enableVectorizedReader) {
                    OrcColumnarBatchReader batchReader = new OrcColumnarBatchReader(capacity);
                    RecordReaderIterator<ColumnarBatch> iter = new RecordReaderIterator<ColumnarBatch>(batchReader);
                    Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable)x$4 -> x$4.addTaskCompletionListener((Function1 & Serializable)x$5 -> {
                        iter.close();
                        return BoxedUnit.UNIT;
                    }));
                    int[] requestedDataColIds = (int[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.intArrayOps(requestedColIds2), Array$.MODULE$.fill(partitionSchema.length(), (Function0)(JFunction0.mcI.sp & Serializable)() -> -1, (ClassTag)ClassTag$.MODULE$.Int()), (ClassTag)ClassTag$.MODULE$.Int());
                    int[] requestedPartitionColIds = (int[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.intArrayOps((int[])Array$.MODULE$.fill(requiredSchema.length(), (Function0)(JFunction0.mcI.sp & Serializable)() -> -1, (ClassTag)ClassTag$.MODULE$.Int())), (IterableOnce)package$.MODULE$.Range().apply(0, partitionSchema.length()), (ClassTag)ClassTag$.MODULE$.Int());
                    batchReader.initialize((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
                    batchReader.initBatch(TypeDescription.fromString((String)resultSchemaString), resultSchema.fields(), requestedDataColIds, requestedPartitionColIds, file.partitionValues());
                    iterator = iter;
                } else {
                    RecordReader orcRecordReader = new OrcInputFormat().createRecordReader((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
                    RecordReaderIterator iter = new RecordReaderIterator(orcRecordReader);
                    Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable)x$6 -> x$6.addTaskCompletionListener((Function1 & Serializable)x$7 -> {
                        iter.close();
                        return BoxedUnit.UNIT;
                    }));
                    Seq fullSchema = (Seq)requiredSchema.toAttributes().$plus$plus((IterableOnce)partitionSchema.toAttributes());
                    UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                    OrcDeserializer deserializer = new OrcDeserializer(requiredSchema, requestedColIds2);
                    if (partitionSchema.length() == 0) {
                        iterator = iter.map((Function1 & Serializable)value -> unsafeProjection.apply(deserializer.deserialize((OrcStruct)value)));
                    } else {
                        JoinedRow joinedRow = new JoinedRow();
                        iterator = iter.map((Function1 & Serializable)value -> unsafeProjection.apply((InternalRow)joinedRow.apply(deserializer.deserialize((OrcStruct)value), file.partitionValues())));
                    }
                }
            }
            return iterator;
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AnsiIntervalType) {
            bl = false;
        } else if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType) && this.supportDataType(valueType);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType());
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean supportFieldName(String name) {
        boolean bl;
        try {
            TypeDescription.fromString((String)new StringBuilder(14).append("struct<`").append(name).append("`:int>").toString());
            bl = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$supportBatchForNestedColumn$2(DataType x0$1) {
        DataType dataType = x0$1;
        boolean bl = dataType instanceof ArrayType ? true : (dataType instanceof MapType ? true : dataType instanceof StructType);
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$supportBatch$1(OrcFileFormat $this, StructField s) {
        return $this.supportDataType(s.dataType()) && !(s.dataType() instanceof UserDefinedType);
    }

    public static final /* synthetic */ void $anonfun$buildReaderWithPartitionValues$5(Configuration conf$1, StructType fileSchema$1, SearchArgument f) {
        OrcInputFormat.setSearchArgument((Configuration)conf$1, (SearchArgument)f, (String[])fileSchema$1.fieldNames());
    }

    public static final /* synthetic */ void $anonfun$buildReaderWithPartitionValues$4(Seq filters$1, Configuration conf$1, StructType fileSchema) {
        OrcFilters$.MODULE$.createFilter(fileSchema, (Seq<Filter>)filters$1).foreach((Function1 & Serializable)f -> {
            OrcFileFormat.$anonfun$buildReaderWithPartitionValues$5(conf$1, fileSchema, f);
            return BoxedUnit.UNIT;
        });
    }

    public OrcFileFormat() {
        FileFormat.$init$(this);
    }
}

