/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.connector;

import java.io.IOException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.TestingV2Source;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import test.org.apache.spark.sql.connector.JavaRangeInputPartition;
import test.org.apache.spark.sql.connector.JavaSimpleBatchTable;
import test.org.apache.spark.sql.connector.JavaSimpleScanBuilder;

public class JavaColumnarDataSourceV2
implements TestingV2Source {
    @Override
    public Table getTable(CaseInsensitiveStringMap options) {
        return new JavaSimpleBatchTable(){

            public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
                return new MyScanBuilder();
            }
        };
    }

    static class ColumnarReaderFactory
    implements PartitionReaderFactory {
        private static final int BATCH_SIZE = 20;

        ColumnarReaderFactory() {
        }

        public boolean supportColumnarReads(InputPartition partition) {
            return true;
        }

        public PartitionReader<InternalRow> createReader(InputPartition partition) {
            throw new UnsupportedOperationException("");
        }

        public PartitionReader<ColumnarBatch> createColumnarReader(InputPartition partition) {
            final JavaRangeInputPartition p = (JavaRangeInputPartition)partition;
            final OnHeapColumnVector i = new OnHeapColumnVector(20, DataTypes.IntegerType);
            final OnHeapColumnVector j = new OnHeapColumnVector(20, DataTypes.IntegerType);
            ColumnVector[] vectors = new ColumnVector[]{i, j};
            final ColumnarBatch batch = new ColumnarBatch(vectors);
            return new PartitionReader<ColumnarBatch>(){
                private int current;
                {
                    this.current = p.start;
                }

                public boolean next() throws IOException {
                    int count;
                    i.reset();
                    j.reset();
                    for (count = 0; this.current < p.end && count < 20; ++count) {
                        i.putInt(count, this.current);
                        j.putInt(count, -this.current);
                        ++this.current;
                    }
                    if (count == 0) {
                        return false;
                    }
                    batch.setNumRows(count);
                    return true;
                }

                public ColumnarBatch get() {
                    return batch;
                }

                public void close() throws IOException {
                    batch.close();
                }
            };
        }
    }

    static class MyScanBuilder
    extends JavaSimpleScanBuilder {
        MyScanBuilder() {
        }

        public InputPartition[] planInputPartitions() {
            InputPartition[] partitions = new InputPartition[]{new JavaRangeInputPartition(0, 50), new JavaRangeInputPartition(50, 90)};
            return partitions;
        }

        @Override
        public PartitionReaderFactory createReaderFactory() {
            return new ColumnarReaderFactory();
        }
    }
}

