/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.sql.LocalSparkSession$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.StatefulOperatorStateInfo;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.StateStoreRDD;
import org.apache.spark.sql.execution.streaming.state.StateStoreTestsHelper$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.execution.streaming.state.package$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.tags.ExtendedSQLTest;
import org.apache.spark.util.CompletionIterator$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ExtendedSQLTest
@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\t\u0013\u0001\u0005BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013%\u0011\u0007\u0003\u00046\u0001\u0001\u0006IA\r\u0005\bm\u0001\u0011\r\u0011\"\u00038\u0011\u0019\u0001\u0005\u0001)A\u0005q!9\u0011\t\u0001b\u0001\n\u0013\u0011\u0005BB%\u0001A\u0003%1\tC\u0004K\u0001\t\u0007I\u0011\u0002\"\t\r-\u0003\u0001\u0015!\u0003D\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015!\u0006\u0001\"\u0003V\u0011\u0015a\b\u0001\"\u0003~\u0011%\ti\u0002AI\u0001\n\u0013\ty\u0002C\u0005\u00026\u0001\t\n\u0011\"\u0003\u00028!I\u00111\b\u0001C\u0002\u0013%\u0011Q\b\u0005\t\u0003;\u0002\u0001\u0015!\u0003\u0002@\t\u00112\u000b^1uKN#xN]3S\t\u0012\u001bV/\u001b;f\u0015\t\u0019B#A\u0003ti\u0006$XM\u0003\u0002\u0016-\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003/a\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005eQ\u0012aA:rY*\u00111\u0004H\u0001\u0006gB\f'o\u001b\u0006\u0003;y\ta!\u00199bG\",'\"A\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011c\u0005\u0005\u0002$I5\t!$\u0003\u0002&5\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\n\u0016\u000e\u0003!R!!\u000b\u0010\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\u0016)\u00059\u0011UMZ8sK\u0006sG-\u00114uKJ\fa\u0001P5oSRtD#\u0001\u0018\u0011\u0005=\u0002Q\"\u0001\n\u0002\u0013M\u0004\u0018M]6D_:4W#\u0001\u001a\u0011\u0005\r\u001a\u0014B\u0001\u001b\u001b\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0006ta\u0006\u00148nQ8oM\u0002\nq\u0001^3na\u0012K'/F\u00019!\tId(D\u0001;\u0015\tYD(\u0001\u0003mC:<'\"A\u001f\u0002\t)\fg/Y\u0005\u0003\u007fi\u0012aa\u0015;sS:<\u0017\u0001\u0003;f[B$\u0015N\u001d\u0011\u0002\u0013-,\u0017pU2iK6\fW#A\"\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019C\u0012!\u0002;za\u0016\u001c\u0018B\u0001%F\u0005)\u0019FO];diRK\b/Z\u0001\u000bW\u0016L8k\u00195f[\u0006\u0004\u0013a\u0003<bYV,7k\u00195f[\u0006\fAB^1mk\u0016\u001c6\r[3nC\u0002\n\u0001\"\u00194uKJ\fE\u000e\u001c\u000b\u0002\u001dB\u0011qJU\u0007\u0002!*\t\u0011+A\u0003tG\u0006d\u0017-\u0003\u0002T!\n!QK\\5u\u0003\u001di\u0017m[3S\t\u0012#2A\u00167r!\r9&\fX\u0007\u00021*\u0011\u0011LG\u0001\u0004e\u0012$\u0017BA.Y\u0005\r\u0011F\t\u0012\t\u0005\u001fv{\u0016.\u0003\u0002_!\n1A+\u001e9mKJ\u0002\"\u0001Y4\u000f\u0005\u0005,\u0007C\u00012Q\u001b\u0005\u0019'B\u00013!\u0003\u0019a$o\\8u}%\u0011a\rU\u0001\u0007!J,G-\u001a4\n\u0005}B'B\u00014Q!\ty%.\u0003\u0002l!\n\u0019\u0011J\u001c;\t\u000b5\\\u0001\u0019\u00018\u0002\u0005M\u001c\u0007CA\u0012p\u0013\t\u0001(D\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0003s\u0017\u0001\u00071/A\u0002tKF\u00042\u0001^=]\u001d\t)xO\u0004\u0002cm&\t\u0011+\u0003\u0002y!\u00069\u0001/Y2lC\u001e,\u0017B\u0001>|\u0005\r\u0019V-\u001d\u0006\u0003qB\u000b\u0011c\u001c9fe\u0006$xN]*uCR,\u0017J\u001c4p)\u001dq\u0018QAA\u0005\u00033\u00012a`A\u0001\u001b\u0005!\u0012bAA\u0002)\tI2\u000b^1uK\u001a,Hn\u00149fe\u0006$xN]*uCR,\u0017J\u001c4p\u0011\u0019\t9\u0001\u0004a\u0001?\u0006!\u0001/\u0019;i\u0011%\tY\u0001\u0004I\u0001\u0002\u0004\ti!\u0001\u0006rk\u0016\u0014\u0018PU;o\u0013\u0012\u0004B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'a\u0014\u0001B;uS2LA!a\u0006\u0002\u0012\t!Q+V%E\u0011!\tY\u0002\u0004I\u0001\u0002\u0004I\u0017a\u0002<feNLwN\\\u0001\u001c_B,'/\u0019;peN#\u0018\r^3J]\u001a|G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0005\"\u0006BA\u0007\u0003GY#!!\n\u0011\t\u0005\u001d\u0012\u0011G\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003_\u0001\u0016AC1o]>$\u0018\r^5p]&!\u00111GA\u0015\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001c_B,'/\u0019;peN#\u0018\r^3J]\u001a|G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005e\"fA5\u0002$\u0005I\u0011N\\2sK6,g\u000e^\u000b\u0003\u0003\u007f\u0001\u0012bTA!\u0003\u000b\nY%!\u0015\n\u0007\u0005\r\u0003KA\u0005Gk:\u001cG/[8oeA\u0019q&a\u0012\n\u0007\u0005%#C\u0001\u0006Ti\u0006$Xm\u0015;pe\u0016\u0004B\u0001^A'9&\u0019\u0011qJ>\u0003\u0011%#XM]1u_J\u0004b!a\u0015\u0002Z\u0005mSBAA+\u0015\r\t9\u0006U\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA(\u0003+\u0002BaT/]S\u0006Q\u0011N\\2sK6,g\u000e\u001e\u0011)\u0007\u0001\t\t\u0007\u0005\u0003\u0002d\u0005%TBAA3\u0015\r\t9GG\u0001\u0005i\u0006<7/\u0003\u0003\u0002l\u0005\u0015$aD#yi\u0016tG-\u001a3T#2#Vm\u001d;")
public class StateStoreRDDSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final SparkConf sparkConf;
    private final String tempDir;
    private final StructType keySchema;
    private final StructType valueSchema;
    private final Function2<StateStore, Iterator<Tuple2<String, Object>>, Iterator<Tuple2<Tuple2<String, Object>, Object>>> increment;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private String tempDir() {
        return this.tempDir;
    }

    private StructType keySchema() {
        return this.keySchema;
    }

    private StructType valueSchema() {
        return this.valueSchema;
    }

    public void afterAll() {
        try {
            super.afterAll();
        }
        finally {
            Utils$.MODULE$.deleteRecursively(new File(this.tempDir()));
        }
    }

    private RDD<Tuple2<String, Object>> makeRDD(SparkContext sc, Seq<Tuple2<String, Object>> seq) {
        return sc.makeRDD(seq, 2, ClassTag$.MODULE$.apply(Tuple2.class)).groupBy((Function1 & Serializable & scala.Serializable)x -> x, ClassTag$.MODULE$.apply(Tuple2.class)).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Iterable)x$1._2(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private StatefulOperatorStateInfo operatorStateInfo(String path, UUID queryRunId, int version) {
        return new StatefulOperatorStateInfo(path, queryRunId, 0L, (long)version, 5);
    }

    private UUID operatorStateInfo$default$2() {
        return UUID.randomUUID();
    }

    private int operatorStateInfo$default$3() {
        return 0;
    }

    private Function2<StateStore, Iterator<Tuple2<String, Object>>, Iterator<Tuple2<Tuple2<String, Object>, Object>>> increment() {
        return this.increment;
    }

    private final RDD makeStoreRDD$1(SparkSession spark, Seq seq, int storeVersion, String path$1) {
        SQLContext sqlContext = spark.sqlContext();
        String x$1 = path$1;
        int x$2 = storeVersion;
        UUID x$3 = this.operatorStateInfo$default$2();
        return package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$1, x$3, x$2), this.keySchema(), this.valueSchema(), 0, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static final /* synthetic */ void $anonfun$new$5(StateStoreRDDSuite $this, String path$1, SparkSession spark) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Predef$.MODULE$.require($this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.makeStoreRDD$1(spark, (Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$), i - 1, path$1).collect())).toSet()).$eq$eq$eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)i))})), Equality$.MODULE$.default())));
    }

    private static final Iterator iteratorOfPuts$1(StateStore store, Iterator iter) {
        Iterator resIterator = iter.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String s = (String)tuple2._1();
                int i = tuple2._2$mcI$sp();
                UnsafeRow key = StateStoreTestsHelper$.MODULE$.dataToKeyRow(s, i);
                int oldValue = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)store.get(key)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.valueRowToData(row))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
                int newValue = oldValue + 1;
                store.put(key, StateStoreTestsHelper$.MODULE$.dataToValueRow(newValue));
                return new Tuple2((Object)new Tuple2((Object)s, (Object)BoxesRunTime.boxToInteger((int)i)), (Object)BoxesRunTime.boxToInteger((int)newValue));
            }
            throw new MatchError((Object)tuple2);
        });
        return CompletionIterator$.MODULE$.apply(resIterator, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> store.commit());
    }

    private static final Iterator iteratorOfGets$1(StateStore store, Iterator iter) {
        return iter.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String s = (String)tuple2._1();
                int i = tuple2._2$mcI$sp();
                UnsafeRow key = StateStoreTestsHelper$.MODULE$.dataToKeyRow(s, i);
                Option value = Option$.MODULE$.apply((Object)store.get(key)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.valueRowToData(row)));
                return new Tuple2((Object)new Tuple2((Object)s, (Object)BoxesRunTime.boxToInteger((int)i)), (Object)value);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ void $anonfun$increment$2(StateStore store$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String s = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            UnsafeRow key = StateStoreTestsHelper$.MODULE$.dataToKeyRow(s, i);
            int oldValue = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)store$3.get(key)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.valueRowToData(row))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            store$3.put(key, StateStoreTestsHelper$.MODULE$.dataToValueRow(oldValue + 1));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public StateStoreRDDSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.sparkConf = new SparkConf().setMaster("local").setAppName(this.getClass().getSimpleName());
        this.tempDir = ((Object)Files.createTempDirectory("StateStoreRDDSuite", new FileAttribute[0])).toString();
        this.keySchema = StateStoreTestsHelper$.MODULE$.keySchema();
        this.valueSchema = StateStoreTestsHelper$.MODULE$.valueSchema();
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> StateStore$.MODULE$.stop(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("versioning and immutability", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
            String path;
            String x$1 = path = Utils$.MODULE$.createDirectory(this.tempDir(), Float.toString(Random$.MODULE$.nextFloat())).toString();
            int x$2 = 0;
            UUID x$3 = this.operatorStateInfo$default$2();
            StateStoreRDD rdd1 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$))))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(spark.sqlContext(), this.operatorStateInfo(x$1, x$3, x$2), this.keySchema(), this.valueSchema(), 0, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd1.collect())).toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            String x$4 = path;
            int x$5 = 1;
            UUID x$6 = this.operatorStateInfo$default$2();
            StateStoreRDD rdd2 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$)))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(spark.sqlContext(), this.operatorStateInfo(x$4, x$6, x$5), this.keySchema(), this.valueSchema(), 0, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd2.collect())).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd1.collect())).toSet());
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        }), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("recovering from files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), Float.toString(Random$.MODULE$.nextFloat())).toString();
            LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
                StateStoreRDDSuite.$anonfun$new$5(this, path, spark);
                return BoxedUnit.UNIT;
            });
            return (Assertion)LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.makeStoreRDD$1((SparkSession)spark, (Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$), 20, path).collect())).toSet());
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)21))}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            });
        }, new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("usage with iterators - only gets and only puts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
            SQLContext sqlContext = spark.sqlContext();
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), Float.toString(Random$.MODULE$.nextFloat())).toString();
            boolean opId = false;
            String x$7 = path;
            int x$8 = 0;
            UUID x$9 = this.operatorStateInfo$default$2();
            StateStoreRDD rddOfGets1 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$))))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(spark.sqlContext(), this.operatorStateInfo(x$7, x$9, x$8), this.keySchema(), this.valueSchema(), 0, (Function2 & Serializable & scala.Serializable)(store, iter) -> StateStoreRDDSuite.iteratorOfGets$1(store, iter), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddOfGets1.collect())).toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)None$.MODULE$)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            String x$10 = path;
            int x$11 = 0;
            UUID x$12 = this.operatorStateInfo$default$2();
            StateStoreRDD rddOfPuts = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$))))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$10, x$12, x$11), this.keySchema(), this.valueSchema(), 0, (Function2 & Serializable & scala.Serializable)(store, iter) -> StateStoreRDDSuite.iteratorOfPuts$1(store, iter), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddOfPuts.collect())).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            String x$13 = path;
            int x$14 = 1;
            UUID x$15 = this.operatorStateInfo$default$2();
            StateStoreRDD rddOfGets2 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$))))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$13, x$15, x$14), this.keySchema(), this.valueSchema(), 0, (Function2 & Serializable & scala.Serializable)(store, iter) -> StateStoreRDDSuite.iteratorOfGets$1(store, iter), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddOfGets2.collect())).toSet());
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)None$.MODULE$)}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        }), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("preferred locations using StateStoreCoordinator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Tuple2[])org.apache.spark.sql.catalyst.util.package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> {
            UUID queryRunId = UUID.randomUUID();
            int opId = 0;
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), Float.toString(Random$.MODULE$.nextFloat())).toString();
            return (Tuple2[])LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
                SQLContext sqlContext = spark.sqlContext();
                StateStoreCoordinatorRef coordinatorRef = sqlContext.streams().stateStoreCoordinator();
                StateStoreProviderId storeProviderId1 = new StateStoreProviderId(new StateStoreId(path, (long)opId, 0, StateStoreId$.MODULE$.apply$default$4()), queryRunId);
                StateStoreProviderId storeProviderId2 = new StateStoreProviderId(new StateStoreId(path, (long)opId, 1, StateStoreId$.MODULE$.apply$default$4()), queryRunId);
                coordinatorRef.reportActiveInstance(storeProviderId1, "host1", "exec1", (Seq)Nil$.MODULE$);
                coordinatorRef.reportActiveInstance(storeProviderId2, "host2", "exec2", (Seq)Nil$.MODULE$);
                Predef$.MODULE$.require(this.convertToEqualizer(coordinatorRef.getLocation(storeProviderId1)).$eq$eq$eq((Object)new Some((Object)new ExecutorCacheTaskLocation("host1", "exec1").toString()), Equality$.MODULE$.default()));
                StateStoreRDD rdd = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$))))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(path, queryRunId, this.operatorStateInfo$default$3()), this.keySchema(), this.valueSchema(), 0, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
                Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rdd.partitions().length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rdd.preferredLocations(rdd.partitions()[0]));
                Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)new ExecutorCacheTaskLocation("host1", "exec1").toString(), (List)Nil$.MODULE$);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(rdd.preferredLocations(rdd.partitions()[1]));
                Seq $org_scalatest_assert_macro_right2 = (Seq)new .colon.colon((Object)new ExecutorCacheTaskLocation("host2", "exec2").toString(), (List)Nil$.MODULE$);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
                return (Tuple2[])rdd.collect();
            });
        }), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        this.test("distributed test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)org.apache.spark.sql.catalyst.util.package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> (Assertion)LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf().setMaster("local-cluster[2, 1, 1024]")).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
            SQLContext sqlContext = spark.sqlContext();
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), Float.toString(Random$.MODULE$.nextFloat())).toString();
            boolean opId = false;
            String x$16 = path;
            int x$17 = 0;
            UUID x$18 = this.operatorStateInfo$default$2();
            StateStoreRDD rdd1 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$))))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$16, x$18, x$17), this.keySchema(), this.valueSchema(), 0, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd1.collect())).toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            String x$19 = path;
            int x$20 = 1;
            UUID x$21 = this.operatorStateInfo$default$2();
            StateStoreRDD rdd2 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$)))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$19, x$21, x$20), this.keySchema(), this.valueSchema(), 0, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd2.collect())).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd1.collect())).toSet());
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
        })), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        this.increment = (Function2 & Serializable & scala.Serializable)(store, iter) -> {
            iter.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                StateStoreRDDSuite.$anonfun$increment$2(store, x0$1);
                return BoxedUnit.UNIT;
            });
            store.commit();
            return store.iterator().map((Function1 & Serializable & scala.Serializable)row -> StateStoreTestsHelper$.MODULE$.rowPairToDataPair((UnsafeRowPair)row));
        };
    }
}

