/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.debug;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.execution.adaptive.DisableAdaptiveExecutionSuite;
import org.apache.spark.sql.execution.debug.DebuggingSuiteBase;
import org.apache.spark.sql.execution.debug.package$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001y1AAA\u0002\u0001!!)1\u0004\u0001C\u00019\tqA)\u001a2vO\u001eLgnZ*vSR,'B\u0001\u0003\u0006\u0003\u0015!WMY;h\u0015\t1q!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0001\"C\u0001\u0004gFd'B\u0001\u0006\f\u0003\u0015\u0019\b/\u0019:l\u0015\taQ\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!E\u000b\u0011\u0005I\u0019R\"A\u0002\n\u0005Q\u0019!A\u0005#fEV<w-\u001b8h'VLG/\u001a\"bg\u0016\u0004\"AF\r\u000e\u0003]Q!\u0001G\u0003\u0002\u0011\u0005$\u0017\r\u001d;jm\u0016L!AG\f\u0003;\u0011K7/\u00192mK\u0006#\u0017\r\u001d;jm\u0016,\u00050Z2vi&|gnU;ji\u0016\fa\u0001P5oSRtD#A\u000f\u0011\u0005I\u0001\u0001")
public class DebuggingSuite
extends DebuggingSuiteBase
implements DisableAdaptiveExecutionSuite {
    @Override
    public /* synthetic */ void org$apache$spark$sql$execution$adaptive$DisableAdaptiveExecutionSuite$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        SQLTestUtils.test$(this, testName, testTags, testFun, pos);
    }

    @Override
    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        DisableAdaptiveExecutionSuite.test$(this, testName, testTags, testFun, pos);
    }

    public static final /* synthetic */ void $anonfun$new$13(DebuggingSuite $this, File workDir) {
        String output;
        String workDirPath = workDir.getAbsolutePath();
        Dataset input = $this.spark().range(5L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
        input.write().parquet(workDirPath);
        Dataset df = $this.spark().read().parquet(workDirPath);
        ByteArrayOutputStream captured = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)captured, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.DebugQuery(df).debug());
        String $org_scalatest_assert_macro_left = output = captured.toString().replaceAll("== FileScan parquet \\[id#\\d+L] .* ==", "== FileScan parquet [id#xL] ==");
        String $org_scalatest_assert_macro_right = new StringOps(Predef$.MODULE$.augmentString("== FileScan parquet [id#xL] ==\n          |Tuples output: 0\n          | id LongType: {}\n          |")).stripMargin();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DebuggingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
    }

    public DebuggingSuite() {
        DisableAdaptiveExecutionSuite.$init$(this);
        this.test("SPARK-28537: DebugExec cannot debug broadcast related queries", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Dataset rightDF = this.spark().range(10L);
            Dataset leftDF = this.spark().range(10L);
            Dataset joinedDF = leftDF.join(rightDF, leftDF.apply("id").$eq$eq$eq((Object)rightDF.apply("id")));
            ByteArrayOutputStream captured = new ByteArrayOutputStream();
            Console$.MODULE$.withOut((OutputStream)captured, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.DebugQuery(joinedDF).debug());
            String output = captured.toString();
            String hashedModeString = "HashedRelationBroadcastMode(List(input[0, bigint, false]),false)";
            String $org_scalatest_assert_macro_left = output.replaceAll("\\[plan_id=\\d+\\]", "[plan_id=x]");
            String $org_scalatest_assert_macro_right = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(300).append("== BroadcastExchange ").append(hashedModeString).append(", [plan_id=x] ==\n         |Tuples output: 0\n         | id LongType: {}\n         |== WholeStageCodegen (1) ==\n         |Tuples output: 10\n         | id LongType: {java.lang.Long}\n         |== Range (0, 10, step=1, splits=2) ==\n         |Tuples output: 0\n         | id LongType: {}").toString())).stripMargin();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DebuggingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        }, new Position("DebuggingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("SPARK-28537: DebugExec cannot debug columnar related queries", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)workDir -> {
            DebuggingSuite.$anonfun$new$13(this, workDir);
            return BoxedUnit.UNIT;
        }), new Position("DebuggingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
    }
}

