/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Period;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.types.PhysicalArrayType;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalMapType;
import org.apache.spark.sql.catalyst.types.PhysicalStructType;
import org.apache.spark.sql.execution.columnar.ARRAY;
import org.apache.spark.sql.execution.columnar.BINARY$;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.CALENDAR_INTERVAL$;
import org.apache.spark.sql.execution.columnar.COMPACT_DECIMAL;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.ColumnType$;
import org.apache.spark.sql.execution.columnar.ColumnarDataTypeUtils$;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.DAY_TIME_INTERVAL$;
import org.apache.spark.sql.execution.columnar.DOUBLE$;
import org.apache.spark.sql.execution.columnar.FLOAT$;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.LARGE_DECIMAL;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.MAP;
import org.apache.spark.sql.execution.columnar.NULL$;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.STRUCT;
import org.apache.spark.sql.execution.columnar.YEAR_MONTH_INTERVAL$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0004\b\u00017!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001b\u0001\n\u0013)\u0003B\u0002\u0017\u0001A\u0003%a\u0005C\u0004.\u0001\t\u0007I\u0011\u0002\u0018\t\rI\u0002\u0001\u0015!\u00030\u0011\u001d\u0019\u0004A1A\u0005\nQBa\u0001\u000f\u0001!\u0002\u0013)\u0004bB\u001d\u0001\u0005\u0004%IA\u000f\u0005\u0007}\u0001\u0001\u000b\u0011B\u001e\t\u000b}\u0002A\u0011\u0001!\t\u000bi\u0003A\u0011A.\t\u000b!\u0004A\u0011B5\u0003\u001f\r{G.^7o)f\u0004XmU;ji\u0016T!a\u0004\t\u0002\u0011\r|G.^7oCJT!!\u0005\n\u0002\u0013\u0015DXmY;uS>t'BA\n\u0015\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003+Y\tQa\u001d9be.T!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sO\u000e\u00011C\u0001\u0001\u001d!\tib$D\u0001\u0015\u0013\tyBCA\u0007Ta\u0006\u00148NR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"a\t\u0001\u000e\u00039\t1\u0003R#G\u0003VcEk\u0018\"V\r\u001a+%kX*J5\u0016+\u0012A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0004\u0013:$\u0018\u0001\u0006#F\r\u0006+F\nV0C+\u001a3UIU0T\u0013j+\u0005%\u0001\u0005N\u0003B{F+\u0017)F+\u0005y\u0003CA\u00121\u0013\t\tdBA\u0002N\u0003B\u000b\u0011\"T!Q?RK\u0006+\u0012\u0011\u0002\u0015\u0005\u0013&+Q-`)f\u0003V)F\u00016!\t\u0019c'\u0003\u00028\u001d\t)\u0011I\u0015*B3\u0006Y\u0011I\u0015*B3~#\u0016\fU#!\u0003-\u0019FKU+D)~#\u0016\fU#\u0016\u0003m\u0002\"a\t\u001f\n\u0005ur!AB*U%V\u001bE+\u0001\u0007T)J+6\tV0U3B+\u0005%\u0001\u000buKN$h*\u0019;jm\u0016\u001cu\u000e\\;n]RK\b/Z\u000b\u0003\u00032#\"AQ#\u0011\u0005\u001d\u001a\u0015B\u0001#)\u0005\u0011)f.\u001b;\t\u000b\u0019S\u0001\u0019A$\u0002\u0015\r|G.^7o)f\u0004X\rE\u0002$\u0011*K!!\u0013\b\u0003!9\u000bG/\u001b<f\u0007>dW/\u001c8UsB,\u0007CA&M\u0019\u0001!Q!\u0014\u0006C\u00029\u0013\u0011\u0001V\t\u0003\u001fJ\u0003\"a\n)\n\u0005EC#a\u0002(pi\"Lgn\u001a\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000bQ\u0001^=qKNT!a\u0016\n\u0002\u0011\r\fG/\u00197zgRL!!\u0017+\u0003!AC\u0017p]5dC2$\u0015\r^1UsB,\u0017A\u0004;fgR\u001cu\u000e\\;n]RK\b/Z\u000b\u00039\n$\"AQ/\t\u000b\u0019[\u0001\u0019\u00010\u0011\u0007\rz\u0016-\u0003\u0002a\u001d\tQ1i\u001c7v[:$\u0016\u0010]3\u0011\u0005-\u0013G!B2\f\u0005\u0004!'a\u0002&w[RK\b/Z\t\u0003\u001f\u0016\u0004\"a\n4\n\u0005\u001dD#aA!os\u0006QA-^7q\u0005V4g-\u001a:\u0015\u0005\u0015T\u0007\"B6\r\u0001\u0004a\u0017\u0001\u00022vM\u001a\u0004\"!\u001c:\u000e\u00039T!a\u001c9\u0002\u00079LwNC\u0001r\u0003\u0011Q\u0017M^1\n\u0005Mt'A\u0003\"zi\u0016\u0014UO\u001a4fe\u0002")
public class ColumnTypeSuite
extends SparkFunSuite {
    private final int DEFAULT_BUFFER_SIZE;
    private final MAP MAP_TYPE = new MAP(new PhysicalMapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true));
    private final ARRAY ARRAY_TYPE = new ARRAY(new PhysicalArrayType((DataType)IntegerType$.MODULE$, true));
    private final STRUCT STRUCT_TYPE = new STRUCT(new PhysicalStructType((StructField[])((Object[])new StructField[]{new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));

    private int DEFAULT_BUFFER_SIZE() {
        return this.DEFAULT_BUFFER_SIZE;
    }

    private MAP MAP_TYPE() {
        return this.MAP_TYPE;
    }

    private ARRAY ARRAY_TYPE() {
        return this.ARRAY_TYPE;
    }

    private STRUCT STRUCT_TYPE() {
        return this.STRUCT_TYPE;
    }

    public <T extends PhysicalDataType> void testNativeColumnType(NativeColumnType<T> columnType) {
        this.testColumnType((ColumnType)columnType);
    }

    public <JvmType> void testColumnType(ColumnType<JvmType> columnType) {
        UnsafeProjection proj = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{ColumnarDataTypeUtils$.MODULE$.toLogicalDataType(columnType.dataType())}));
        Function1 converter = CatalystTypeConverters$.MODULE$.createToScalaConverter(ColumnarDataTypeUtils$.MODULE$.toLogicalDataType(columnType.dataType()));
        IndexedSeq seq = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)x$1 -> ColumnTypeSuite.$anonfun$testColumnType$1(proj, columnType, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        int totalSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.getSizeInBytes()), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int bufferSize = Math.max(this.DEFAULT_BUFFER_SIZE(), totalSize);
        this.test(new java.lang.StringBuilder(15).append(columnType).append(" append/extract").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ByteBuffer buffer = ByteBuffer.allocate(bufferSize).order(ByteOrder.nativeOrder());
            seq.foreach((Function1 & Serializable & scala.Serializable)r -> {
                columnType.append(columnType.getField((InternalRow)r, 0), buffer);
                return BoxedUnit.UNIT;
            });
            buffer.rewind();
            seq.foreach((Function1 & Serializable & scala.Serializable)row -> {
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(22).append("buffer = ").append(buffer).append(", expected = ").append(row).toString());
                Object expected = converter.apply(row.get(0, ColumnarDataTypeUtils$.MODULE$.toLogicalDataType(columnType.dataType())));
                Object extracted = converter.apply(columnType.extract(buffer));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expected);
                Object $org_scalatest_assert_macro_right = extracted;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new java.lang.StringBuilder(64).append("Extracted value didn't equal to the original one. ").append(expected).append(" != ").append(extracted).append(", buffer =").append(this.dumpBuffer((ByteBuffer)buffer.duplicate().rewind())).toString(), Prettifier$.MODULE$.default(), new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            });
        }, new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
    }

    private Object dumpBuffer(ByteBuffer buff) {
        StringBuilder sb;
        block1: {
            sb = new StringBuilder();
            while (buff.hasRemaining()) {
                byte b = buff.get();
                sb.append(Integer.toHexString(b & 0xFF)).append(' ');
            }
            if (!sb.nonEmpty()) break block1;
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private final void checkActualSize$1(ColumnType columnType, Object value, int expected) {
        Integer n = BoxesRunTime.boxToInteger((int)expected);
        String string = new java.lang.StringBuilder(21).append("Wrong actualSize for ").append(columnType).toString();
        GenericInternalRow row = new GenericInternalRow(1);
        row.update(0, CatalystTypeConverters$.MODULE$.convertToCatalyst(value));
        UnsafeProjection proj = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{ColumnarDataTypeUtils$.MODULE$.toLogicalDataType(columnType.dataType())}));
        this.assertResult(n, string, BoxesRunTime.boxToInteger((int)columnType.actualSize((InternalRow)proj.apply((InternalRow)row), 0)), Prettifier$.MODULE$.default(), new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
    }

    public static final /* synthetic */ UnsafeRow $anonfun$testColumnType$1(UnsafeProjection proj$1, ColumnType columnType$1, int x$1) {
        return proj$1.apply(ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)columnType$1, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0]))).copy();
    }

    public ColumnTypeSuite() {
        this.DEFAULT_BUFFER_SIZE = 512;
        this.test("defaultSize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map checks = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NULL$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BOOLEAN$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BYTE$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SHORT$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)INT$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LONG$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FLOAT$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DOUBLE$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new COMPACT_DECIMAL(15, 10)), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new LARGE_DECIMAL(20, 10)), (Object)BoxesRunTime.boxToInteger((int)12)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)STRING$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BINARY$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)16)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.STRUCT_TYPE()), (Object)BoxesRunTime.boxToInteger((int)20)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ARRAY_TYPE()), (Object)BoxesRunTime.boxToInteger((int)28)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MAP_TYPE()), (Object)BoxesRunTime.boxToInteger((int)68)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CALENDAR_INTERVAL$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)16))}));
            checks.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    ColumnType columnType = (ColumnType)tuple2._1();
                    int expectedSize = tuple2._2$mcI$sp();
                    return this.assertResult(BoxesRunTime.boxToInteger((int)expectedSize), new java.lang.StringBuilder(22).append("Wrong defaultSize for ").append(columnType).toString(), BoxesRunTime.boxToInteger((int)columnType.defaultSize()), Prettifier$.MODULE$.default(), new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("actualSize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkActualSize$1((ColumnType)NULL$.MODULE$, null, 0);
            this.checkActualSize$1((ColumnType)BOOLEAN$.MODULE$, BoxesRunTime.boxToBoolean((boolean)true), 1);
            this.checkActualSize$1((ColumnType)BYTE$.MODULE$, BoxesRunTime.boxToByte((byte)127), 1);
            this.checkActualSize$1((ColumnType)SHORT$.MODULE$, BoxesRunTime.boxToShort((short)Short.MAX_VALUE), 2);
            this.checkActualSize$1((ColumnType)INT$.MODULE$, BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), 4);
            this.checkActualSize$1((ColumnType)LONG$.MODULE$, BoxesRunTime.boxToLong((long)Long.MAX_VALUE), 8);
            this.checkActualSize$1((ColumnType)FLOAT$.MODULE$, BoxesRunTime.boxToFloat((float)Float.MAX_VALUE), 4);
            this.checkActualSize$1((ColumnType)DOUBLE$.MODULE$, BoxesRunTime.boxToDouble((double)Double.MAX_VALUE), 8);
            this.checkActualSize$1((ColumnType)STRING$.MODULE$, "hello", 4 + "hello".getBytes(StandardCharsets.UTF_8).length);
            this.checkActualSize$1((ColumnType)BINARY$.MODULE$, Array$.MODULE$.fill(4, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> (byte)0, ClassTag$.MODULE$.Byte()), 8);
            this.checkActualSize$1((ColumnType)new COMPACT_DECIMAL(15, 10), Decimal$.MODULE$.apply(0L, 15, 10), 8);
            this.checkActualSize$1((ColumnType)new LARGE_DECIMAL(20, 10), Decimal$.MODULE$.apply(0L, 20, 10), 5);
            this.checkActualSize$1((ColumnType)this.ARRAY_TYPE(), new Object[]{BoxesRunTime.boxToInteger((int)1)}, 28);
            this.checkActualSize$1((ColumnType)this.MAP_TYPE(), Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a")})), 68);
            this.checkActualSize$1((ColumnType)this.STRUCT_TYPE(), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hello"})), 28);
            this.checkActualSize$1((ColumnType)CALENDAR_INTERVAL$.MODULE$, new CalendarInterval(0, 0, 0L), 16);
            this.checkActualSize$1((ColumnType)YEAR_MONTH_INTERVAL$.MODULE$, Period.ofMonths(Integer.MAX_VALUE).normalized(), 4);
            this.checkActualSize$1((ColumnType)DAY_TIME_INTERVAL$.MODULE$, Duration.ofDays(106751991L), 8);
        }, new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.testNativeColumnType((NativeColumnType)BOOLEAN$.MODULE$);
        this.testNativeColumnType((NativeColumnType)BYTE$.MODULE$);
        this.testNativeColumnType((NativeColumnType)SHORT$.MODULE$);
        this.testNativeColumnType((NativeColumnType)INT$.MODULE$);
        this.testNativeColumnType((NativeColumnType)LONG$.MODULE$);
        this.testNativeColumnType((NativeColumnType)FLOAT$.MODULE$);
        this.testNativeColumnType((NativeColumnType)DOUBLE$.MODULE$);
        this.testNativeColumnType((NativeColumnType)new COMPACT_DECIMAL(15, 10));
        this.testNativeColumnType((NativeColumnType)STRING$.MODULE$);
        this.testColumnType((ColumnType)NULL$.MODULE$);
        this.testColumnType((ColumnType)BINARY$.MODULE$);
        this.testColumnType((ColumnType)new LARGE_DECIMAL(20, 10));
        this.testColumnType((ColumnType)this.STRUCT_TYPE());
        this.testColumnType((ColumnType)this.ARRAY_TYPE());
        this.testColumnType((ColumnType)this.MAP_TYPE());
        this.testColumnType((ColumnType)CALENDAR_INTERVAL$.MODULE$);
        this.test("column type for decimal types with different precision", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 18).foreach((Function1 & Serializable & scala.Serializable)i -> this.assertResult(new COMPACT_DECIMAL(BoxesRunTime.unboxToInt((Object)i), 0), ColumnType$.MODULE$.apply((DataType)new DecimalType(BoxesRunTime.unboxToInt((Object)i), 0)), Prettifier$.MODULE$.default(), new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149)));
            return this.assertResult(new LARGE_DECIMAL(19, 0), ColumnType$.MODULE$.apply((DataType)new DecimalType(19, 0)), Prettifier$.MODULE$.default(), new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        }, new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        this.test("show type name in type mismatch error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String message;
            DataType invalidType = new DataType(null){

                public int defaultSize() {
                    return 1;
                }

                public DataType asNullable() {
                    return this;
                }

                public String typeName() {
                    return "invalid type name";
                }
            };
            String $org_scalatest_assert_macro_left = message = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> ColumnType$.MODULE$.apply(invalidType), ClassTag$.MODULE$.apply(Exception.class), new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166))).getMessage();
            String $org_scalatest_assert_macro_right = "Unsupported type: invalid type name";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        }, new Position("ColumnTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
    }
}

