/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.connector.RowLevelOperationSuiteBase;
import org.apache.spark.sql.connector.UpdateTableSuiteBase$;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.ColumnDefaultValue;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.LiteralValue;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y1QAA\u0002\u0002\u00029AQa\u0005\u0001\u0005\u0002Q\u0011A#\u00169eCR,G+\u00192mKN+\u0018\u000e^3CCN,'B\u0001\u0003\u0006\u0003%\u0019wN\u001c8fGR|'O\u0003\u0002\u0007\u000f\u0005\u00191/\u001d7\u000b\u0005!I\u0011!B:qCJ\\'B\u0001\u0006\f\u0003\u0019\t\u0007/Y2iK*\tA\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001fA\u0011\u0001#E\u0007\u0002\u0007%\u0011!c\u0001\u0002\u001b%><H*\u001a<fY>\u0003XM]1uS>t7+^5uK\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"\u0001\u0005\u0001")
public abstract class UpdateTableSuiteBase
extends RowLevelOperationSuiteBase {
    public UpdateTableSuiteBase() {
        this.test("EXPLAIN only update", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, dep STRING", "{ \"pk\": 1, \"dep\": \"hr\" }");
            this.sql().apply((Object)new StringBuilder(48).append("EXPLAIN UPDATE ").append(this.tableNameAsString()).append(" SET dep = 'invalid' WHERE pk = 1").toString());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row));
        }, new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("update empty tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createTable("pk INT NOT NULL, salary INT, dep STRING");
            this.sql().apply((Object)new StringBuilder(45).append("UPDATE ").append(this.tableNameAsString()).append(" SET dep = 'invalid' WHERE salary <= 1").toString());
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$);
        }, new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        this.test("update with basic filters", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n        |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n        |")).stripMargin());
            this.sql().apply((Object)new StringBuilder(47).append("UPDATE ").append(this.tableNameAsString()).append(" SET dep = 'invalid' WHERE salary <= 100").toString());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)100), "invalid"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "software"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)300), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("update with aliases", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n        |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n        |")).stripMargin());
            this.sql().apply((Object)new StringBuilder(68).append("UPDATE ").append(this.tableNameAsString()).append(" AS t SET t.salary = -1 WHERE t.salary <= 100 OR t.dep = 'hr'").toString());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)-1), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "software"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)-1), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("update aligns assignments", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, c1 INT, c2 INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"c1\": 11, \"c2\": 111, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"c1\": 22, \"c2\": 222, \"dep\": \"hr\" }\n        |")).stripMargin());
            this.sql().apply((Object)new StringBuilder(55).append("UPDATE ").append(this.tableNameAsString()).append(" SET `c2` = c2 - 2, c1 = `c1` - 1 WHERE pk <=> 1").toString());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)109), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToInteger((int)222), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("update non-existing records", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"salary\": 200, \"dep\": \"hardware\" }\n        |{ \"pk\": 3, \"salary\": null, \"dep\": \"hr\" }\n        |")).stripMargin());
            this.sql().apply((Object)new StringBuilder(43).append("UPDATE ").append(this.tableNameAsString()).append(" SET salary = -1 WHERE salary > 1000").toString());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)100), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "hardware"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("update without condition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"salary\": 200, \"dep\": \"hardware\" }\n        |{ \"pk\": 3, \"salary\": null, \"dep\": \"hr\" }\n        |")).stripMargin());
            this.sql().apply((Object)new StringBuilder(23).append("UPDATE ").append(this.tableNameAsString()).append(" SET salary = -1").toString());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)-1), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)-1), "hardware"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)-1), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("update with NULL conditions on partition columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": null }\n        |{ \"pk\": 2, \"salary\": 200, \"dep\": \"hr\" }\n        |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hardware\" }\n        |")).stripMargin());
            this.sql().apply((Object)new StringBuilder(40).append("UPDATE ").append(this.tableNameAsString()).append(" SET salary = -1 WHERE dep = NULL").toString());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)100), null}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "hr"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)300), "hardware"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)new StringBuilder(42).append("UPDATE ").append(this.tableNameAsString()).append(" SET salary = -1 WHERE dep <=> NULL").toString());
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)-1), null}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "hr"}));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)300), "hardware"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row6).$colon$colon((Object)row5).$colon$colon((Object)row4));
        }, new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("update with NULL conditions on data columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": null, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"salary\": 200, \"dep\": \"hr\" }\n        |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hardware\" }\n        |")).stripMargin());
            this.sql().apply((Object)new StringBuilder(47).append("UPDATE ").append(this.tableNameAsString()).append(" SET dep = 'invalid' WHERE salary = NULL").toString());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null, "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "hr"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)300), "hardware"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)new StringBuilder(49).append("UPDATE ").append(this.tableNameAsString()).append(" SET dep = 'invalid' WHERE salary <=> NULL").toString());
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null, "invalid"}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "hr"}));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)300), "hardware"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row6).$colon$colon((Object)row5).$colon$colon((Object)row4));
        }, new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("update with IN and NOT IN predicates", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"salary\": 200, \"dep\": \"hardware\" }\n        |{ \"pk\": 3, \"salary\": null, \"dep\": \"hr\" }\n        |")).stripMargin());
            this.sql().apply((Object)new StringBuilder(51).append("UPDATE ").append(this.tableNameAsString()).append(" SET salary = -1 WHERE salary IN (100, null)").toString());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)-1), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "hardware"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)new StringBuilder(53).append("UPDATE ").append(this.tableNameAsString()).append(" SET salary = -1 WHERE salary NOT IN (null, 1)").toString());
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)-1), "hr"}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "hardware"}));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row6).$colon$colon((Object)row5).$colon$colon((Object)row4));
            this.sql().apply((Object)new StringBuilder(52).append("UPDATE ").append(this.tableNameAsString()).append(" SET salary = 100 WHERE salary NOT IN (1, 10)").toString());
            Row row7 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)100), "hr"}));
            Row row8 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)100), "hardware"}));
            Row row9 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row9).$colon$colon((Object)row8).$colon$colon((Object)row7));
        }, new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        this.test("update nested struct fields", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable(new StringOps(Predef$.MODULE$.augmentString("pk INT NOT NULL,\n         |s STRUCT<c1: INT, c2: STRUCT<a: ARRAY<INT>, m: MAP<STRING, STRING>>>,\n         |dep STRING")).stripMargin(), "{ \"pk\": 1, \"s\": { \"c1\": 2, \"c2\": { \"a\": [1,2], \"m\": { \"a\": \"b\" } } }, \"dep\": \"hr\" }");
            this.sql().apply((Object)new StringBuilder(65).append("UPDATE ").append(this.tableNameAsString()).append(" SET s.c1 = -1, s.c2.m = map('k', 'v'), s.c2.a = array(-1)").toString());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)-1), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1})), Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)"v")}))}))})), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row));
            this.sql().apply((Object)new StringBuilder(49).append("UPDATE ").append(this.tableNameAsString()).append(" SET s.c1 = NULL, s.c2 = NULL WHERE pk = 1").toString());
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2));
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(104).append("UPDATE ").append(this.tableNameAsString()).append("\n         |SET s = named_struct('c1', 1, 'c2', named_struct('a', array(1), 'm', null))\n         |").toString())).stripMargin());
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), null}))})), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3));
        }, new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        this.test("update fields inside NULL structs", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, s STRUCT<n1: INT, n2: INT>, dep STRING", "{ \"pk\": 1, \"s\": null, \"dep\": \"hr\" }");
            this.sql().apply((Object)new StringBuilder(34).append("UPDATE ").append(this.tableNameAsString()).append(" SET s.n1 = -1 WHERE pk = 1").toString());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)-1), null})), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row));
        }, new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        this.test("update refreshes relation cache", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"temp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withCache((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"temp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n            |{ \"pk\": 2, \"salary\": 100, \"dep\": \"hr\" }\n            |{ \"pk\": 3, \"salary\": 200, \"dep\": \"hardware\" }\n            |{ \"pk\": 4, \"salary\": 300, \"dep\": \"hr\" }\n            |")).stripMargin());
            Dataset query = (Dataset)this.sql().apply((Object)new StringBuilder(33).append("SELECT * FROM ").append(this.tableNameAsString()).append(" WHERE salary = 100").toString());
            query.createOrReplaceTempView("temp");
            this.sql().apply((Object)"CACHE TABLE temp");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)100), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)100), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM temp"), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)new StringBuilder(52).append("UPDATE ").append(this.tableNameAsString()).append(" SET salary = salary + 10 WHERE salary <= 100").toString());
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)110), "hr"}));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)110), "hr"}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)200), "hardware"}));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)300), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row6).$colon$colon((Object)row5).$colon$colon((Object)row4).$colon$colon((Object)row3));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM temp"), (Seq<Row>)Nil$.MODULE$);
        })), new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        this.test("update with conditions on nested columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, complex STRUCT<c1:INT,c2:STRING>, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"complex\": { \"c1\": 300, \"c2\": \"v1\" }, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"salary\": 200, \"complex\": { \"c1\": 200, \"c2\": \"v2\" }, \"dep\": \"software\" }\n        |")).stripMargin());
            this.sql().apply((Object)new StringBuilder(55).append("UPDATE ").append(this.tableNameAsString()).append(" SET salary = -1 WHERE complex.c1 = salary + 200").toString());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)-1), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)300), "v1"})), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)200), "v2"})), "software"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("update with IN subqueries", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"updated_id", "updated_dep"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"id\": 2, \"dep\": \"hardware\" }\n          |{ \"pk\": 3, \"id\": null, \"dep\": \"hr\" }\n          |")).stripMargin());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(UpdateTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator6$1(UpdateTableSuiteBase $outer) {
                }
            }
            Dataset updatedIdDF = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator6$1(null)))).toDF();
            updatedIdDF.createOrReplaceTempView("updated_id");
            Dataset updatedDepDF = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"software", (List)new .colon.colon((Object)"hr", (List)Nil$.MODULE$)), this.testImplicits().newStringEncoder()).toDF();
            updatedDepDF.createOrReplaceTempView("updated_dep");
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(181).append("UPDATE ").append(this.tableNameAsString()).append("\n           |SET dep = 'invalid'\n           |WHERE\n           | id IN (SELECT * FROM updated_id)\n           | AND\n           | dep IN (SELECT * FROM updated_dep)\n           |").toString())).stripMargin());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "invalid"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(164).append("UPDATE ").append(this.tableNameAsString()).append("\n           |SET dep = 'invalid'\n           |WHERE\n           | id IS NULL\n           | OR\n           | id IN (SELECT value + 2 FROM updated_id)\n           |").toString())).stripMargin());
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "invalid"}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "invalid"}));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "invalid"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row6).$colon$colon((Object)row5).$colon$colon((Object)row4));
        }), new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        this.test("update with multi-column IN subqueries", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"updated_employee"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"id\": 2, \"dep\": \"hardware\" }\n          |{ \"pk\": 3, \"id\": null, \"dep\": \"hr\" }\n          |")).stripMargin());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(UpdateTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator26$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator26$1(UpdateTableSuiteBase $outer) {
                }
            }
            Dataset updatedEmployeeDF = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)None$.MODULE$, (Object)"hr"), (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"hr"), (List)Nil$.MODULE$)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator26$1(null)))).toDF();
            updatedEmployeeDF.createOrReplaceTempView("updated_employee");
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(129).append("UPDATE ").append(this.tableNameAsString()).append("\n           |SET dep = 'invalid'\n           |WHERE\n           | (id, dep) IN (SELECT * FROM updated_employee)\n           |").toString())).stripMargin());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "invalid"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
        }), new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
        this.test("update with NOT IN subqueries", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"updated_id", "updated_dep"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"id\": 2, \"dep\": \"hardware\" }\n          |{ \"pk\": 3, \"id\": null, \"dep\": \"hr\" }\n          |")).stripMargin());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(UpdateTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator36$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator36$1(UpdateTableSuiteBase $outer) {
                }
            }
            Dataset updatedIdDF = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToInteger((int)-1)), (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToInteger((int)-2)), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator36$1(null)))).toDF();
            updatedIdDF.createOrReplaceTempView("updated_id");
            Dataset updatedDepDF = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"software", (List)new .colon.colon((Object)"hr", (List)Nil$.MODULE$)), this.testImplicits().newStringEncoder()).toDF();
            updatedDepDF.createOrReplaceTempView("updated_dep");
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(120).append("UPDATE ").append(this.tableNameAsString()).append("\n           |SET dep = 'invalid'\n           |WHERE\n           | id NOT IN (SELECT * FROM updated_id)\n           |").toString())).stripMargin());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(144).append("UPDATE ").append(this.tableNameAsString()).append("\n           |SET dep = 'invalid'\n           |WHERE\n           | id NOT IN (SELECT * FROM updated_id WHERE value IS NOT NULL)\n           |").toString())).stripMargin());
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "invalid"}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "invalid"}));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row6).$colon$colon((Object)row5).$colon$colon((Object)row4));
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(175).append("UPDATE ").append(this.tableNameAsString()).append("\n           |SET dep = 'hr'\n           |WHERE\n           | id NOT IN (SELECT * FROM updated_id)\n           | OR\n           | dep IN ('software', 'invalid')\n           |").toString())).stripMargin());
            Row row7 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "hr"}));
            Row row8 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hr"}));
            Row row9 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row9).$colon$colon((Object)row8).$colon$colon((Object)row7));
        }), new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        this.test("update with EXISTS subquery", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"updated_id", "updated_dep"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"id\": 2, \"dep\": \"hardware\" }\n          |{ \"pk\": 3, \"id\": null, \"dep\": \"hr\" }\n          |")).stripMargin());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(UpdateTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator56$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator56$1(UpdateTableSuiteBase $outer) {
                }
            }
            Dataset updatedIdDF = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToInteger((int)-1)), (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToInteger((int)-2)), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator56$1(null)))).toDF();
            updatedIdDF.createOrReplaceTempView("updated_id");
            Dataset updatedDepDF = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"software", (List)new .colon.colon((Object)"hr", (List)Nil$.MODULE$)), this.testImplicits().newStringEncoder()).toDF();
            updatedDepDF.createOrReplaceTempView("updated_dep");
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(142).append("UPDATE ").append(this.tableNameAsString()).append(" t\n           |SET dep = 'invalid'\n           |WHERE\n           | EXISTS (SELECT 1 FROM updated_id d WHERE t.id = d.value)\n           |").toString())).stripMargin());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(146).append("UPDATE ").append(this.tableNameAsString()).append(" t\n           |SET dep = 'invalid'\n           |WHERE\n           | EXISTS (SELECT 1 FROM updated_id d WHERE t.id = d.value + 2)\n           |").toString())).stripMargin());
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "invalid"}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row6).$colon$colon((Object)row5).$colon$colon((Object)row4));
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(158).append("UPDATE ").append(this.tableNameAsString()).append(" t\n           |SET dep = 'invalid'\n           |WHERE\n           | EXISTS (SELECT 1 FROM updated_id d WHERE t.id = d.value) OR t.id IS NULL\n           |").toString())).stripMargin());
            Row row7 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "invalid"}));
            Row row8 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            Row row9 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "invalid"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row9).$colon$colon((Object)row8).$colon$colon((Object)row7));
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(235).append("UPDATE ").append(this.tableNameAsString()).append(" t\n           |SET dep = 'invalid'\n           |WHERE\n           | EXISTS (SELECT 1 FROM updated_id di WHERE t.id = di.value)\n           | AND\n           | EXISTS (SELECT 1 FROM updated_dep dd WHERE t.dep = dd.value)\n           |").toString())).stripMargin());
            Row row10 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "invalid"}));
            Row row11 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            Row row12 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "invalid"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row12).$colon$colon((Object)row11).$colon$colon((Object)row10));
        }), new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
        this.test("update with NOT EXISTS subquery", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"updated_id", "updated_dep"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"id\": 2, \"dep\": \"hardware\" }\n          |{ \"pk\": 3, \"id\": null, \"dep\": \"hr\" }\n          |")).stripMargin());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(UpdateTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator76$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator76$1(UpdateTableSuiteBase $outer) {
                }
            }
            Dataset updatedIdDF = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToInteger((int)-1)), (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToInteger((int)-2)), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator76$1(null)))).toDF();
            updatedIdDF.createOrReplaceTempView("updated_id");
            Dataset updatedDepDF = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)"software", (List)new .colon.colon((Object)"hr", (List)Nil$.MODULE$)), this.testImplicits().newStringEncoder()).toDF();
            updatedDepDF.createOrReplaceTempView("updated_dep");
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(247).append("UPDATE ").append(this.tableNameAsString()).append(" t\n           |SET dep = 'invalid'\n           |WHERE\n           | NOT EXISTS (SELECT 1 FROM updated_id di WHERE t.id = di.value + 2)\n           | AND\n           | NOT EXISTS (SELECT 1 FROM updated_dep dd WHERE t.dep = dd.value)\n           |").toString())).stripMargin());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "invalid"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(150).append("UPDATE ").append(this.tableNameAsString()).append(" t\n           |SET dep = 'invalid'\n           |WHERE\n           | NOT EXISTS (SELECT 1 FROM updated_id d WHERE t.id = d.value + 2)\n           |").toString())).stripMargin());
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "hr"}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "invalid"}));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "invalid"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row6).$colon$colon((Object)row5).$colon$colon((Object)row4));
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(188).append("UPDATE ").append(this.tableNameAsString()).append(" t\n           |SET dep = 'invalid'\n           |WHERE\n           | NOT EXISTS (SELECT 1 FROM updated_id d WHERE t.id = d.value + 2)\n           | OR\n           | t.id = 1\n           |").toString())).stripMargin());
            Row row7 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "invalid"}));
            Row row8 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "invalid"}));
            Row row9 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "invalid"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row9).$colon$colon((Object)row8).$colon$colon((Object)row7));
        }), new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
        this.test("update with a scalar subquery", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"updated_id"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"id\": 2, \"dep\": \"hardware\" }\n          |{ \"pk\": 3, \"id\": null, \"dep\": \"hr\" }\n          |")).stripMargin());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(UpdateTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator96$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator96$1(UpdateTableSuiteBase $outer) {
                }
            }
            Dataset updatedIdDF = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToInteger((int)100)), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_UpdateTableSuiteBase$$typecreator96$1(null)))).toDF();
            updatedIdDF.createOrReplaceTempView("updated_id");
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(127).append("UPDATE ").append(this.tableNameAsString()).append(" t\n           |SET dep = 'invalid'\n           |WHERE\n           | id <= (SELECT min(value) FROM updated_id)\n           |").toString())).stripMargin());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "invalid"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
        }), new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
        this.test("update with nondeterministic assignments", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, value DOUBLE, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"value\": 2.0, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"id\": 2, \"value\": 2.0,  \"dep\": \"software\" }\n        |{ \"pk\": 3, \"id\": 3, \"value\": 2.0, \"dep\": \"hr\" }\n        |")).stripMargin());
            this.sql().apply((Object)new StringBuilder(40).append("UPDATE ").append(this.tableNameAsString()).append(" SET value = rand() WHERE id <= 2").toString());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(39).append("SELECT count(*) FROM ").append(this.tableNameAsString()).append(" WHERE value < 2.0").toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row));
        }, new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        this.test("update with default values", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ColumnDefaultValue idDefault = new ColumnDefaultValue("42", (Literal)new LiteralValue((Object)BoxesRunTime.boxToInteger((int)42), (DataType)IntegerType$.MODULE$));
            Column[] columns = (Column[])((Object[])new Column[]{Column.create((String)"pk", (DataType)IntegerType$.MODULE$, (boolean)false, null, null), Column.create((String)"id", (DataType)IntegerType$.MODULE$, (boolean)true, null, (ColumnDefaultValue)idDefault, null), Column.create((String)"dep", (DataType)StringType$.MODULE$, (boolean)true, null, null)});
            this.createTable(columns);
            this.append("pk INT NOT NULL, id INT, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"id\": 2, \"dep\": \"software\" }\n        |{ \"pk\": 3, \"id\": 3, \"dep\": \"hr\" }\n        |")).stripMargin());
            this.sql().apply((Object)new StringBuilder(41).append("UPDATE ").append(this.tableNameAsString()).append(" SET id = DEFAULT WHERE dep = 'hr'").toString());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)42), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "software"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)42), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
        this.test("update char/varchar columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.createTable("pk INT NOT NULL, s STRUCT<n_c: CHAR(3), n_vc: VARCHAR(5)>, dep STRING");
            this.append("pk INT NOT NULL, s STRUCT<n_c: STRING, n_vc: STRING>, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"s\": { \"n_c\": \"aaa\", \"n_vc\": \"aaa\" }, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"s\": { \"n_c\": \"bbb\", \"n_vc\": \"bbb\" }, \"dep\": \"software\" }\n        |{ \"pk\": 3, \"s\": { \"n_c\": \"ccc\", \"n_vc\": \"ccc\" }, \"dep\": \"hr\" }\n        |")).stripMargin());
            this.sql().apply((Object)new StringBuilder(54).append("UPDATE ").append(this.tableNameAsString()).append(" SET s.n_c = 'x', s.n_vc = 'y' WHERE dep = 'hr'").toString());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x  ", "y"})), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"bbb", "bbb"})), "software"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"x  ", "y"})), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553));
        this.test("update with NOT NULL checks", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, s STRUCT<n_i: INT NOT NULL, n_l: LONG>, dep STRING", new StringOps(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"s\": { \"n_i\": 1, \"n_l\": 11 }, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"s\": { \"n_i\": 2, \"n_l\": 22 }, \"dep\": \"software\" }\n        |{ \"pk\": 3, \"s\": { \"n_i\": 3, \"n_l\": 33 }, \"dep\": \"hr\" }\n        |")).stripMargin());
            SparkException e = (SparkException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(66).append("UPDATE ").append(this.tableNameAsString()).append(" SET s = named_struct('n_i', null, 'n_l', -1L) WHERE pk = 1").toString()), ClassTag$.MODULE$.apply(SparkException.class), new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578))));
            String $org_scalatest_assert_macro_left = e.getCause().getMessage();
            String $org_scalatest_assert_macro_right = "Null value appeared in non-nullable field";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 581));
        }, new Position("UpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
    }
}

