/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.H2Dialect;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MapLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class H2Dialect$
extends JdbcDialect {
    public static H2Dialect$ MODULE$;
    private final Set<String> org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;
    private final Map<String, UnboundFunction> functionMap;

    static {
        new H2Dialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:h2");
    }

    public Set<String> org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("CLOB", 2005));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return new Some((Object)new JdbcType(new StringBuilder(10).append("NUMERIC(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString(), 2));
        }
        return JdbcUtils$.MODULE$.getCommonJDBCType(dt);
    }

    private Map<String, UnboundFunction> functionMap() {
        return this.functionMap;
    }

    public UnboundFunction registerFunction(String name, UnboundFunction fn) {
        return this.functionMap().put(name, fn);
    }

    @Override
    public Seq<Tuple2<String, UnboundFunction>> functions() {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.functionMap()).asScala()).toSeq();
    }

    public void clearFunctions() {
        this.functionMap().clear();
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String[] columnList = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).map((Function1 & Serializable & scala.Serializable)col -> MODULE$.quoteIdentifier((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames())).head()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "h2");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String indexType = (String)tuple2._1();
        String indexType2 = indexType;
        return new StringBuilder(21).append("CREATE INDEX ").append(this.quoteIdentifier(indexName)).append(" ").append(indexType2).append(" ON ").append(this.tableNameWithSchema(tableIdent)).append(" (").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnList)).mkString(", ")).append(")").toString();
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return new StringBuilder(11).append("DROP INDEX ").append(this.indexNameWithSchema(tableIdent, indexName)).toString();
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = new StringBuilder(104).append("SELECT * FROM INFORMATION_SCHEMA.INDEXES WHERE ").append("TABLE_SCHEMA = '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableIdent.namespace())).last()).append("' AND ").append("TABLE_NAME = '").append(tableIdent.name()).append("' AND INDEX_NAME = '").append(indexName).append("'").toString();
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(727).append("\n         | SELECT\n         |   i.INDEX_CATALOG AS INDEX_CATALOG,\n         |   i.INDEX_SCHEMA AS INDEX_SCHEMA,\n         |   i.INDEX_NAME AS INDEX_NAME,\n         |   i.INDEX_TYPE_NAME AS INDEX_TYPE_NAME,\n         |   i.REMARKS as REMARKS,\n         |   ic.COLUMN_NAME AS COLUMN_NAME\n         | FROM INFORMATION_SCHEMA.INDEXES i, INFORMATION_SCHEMA.INDEX_COLUMNS ic\n         | WHERE i.TABLE_CATALOG = ic.TABLE_CATALOG\n         | AND i.TABLE_SCHEMA = ic.TABLE_SCHEMA\n         | AND i.TABLE_NAME = ic.TABLE_NAME\n         | AND i.INDEX_CATALOG = ic.INDEX_CATALOG\n         | AND i.INDEX_SCHEMA = ic.INDEX_SCHEMA\n         | AND i.INDEX_NAME = ic.INDEX_NAME\n         | AND i.TABLE_NAME = '").append(tableIdent.name()).append("'\n         | AND i.INDEX_SCHEMA = '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableIdent.namespace())).last()).append("'\n         |").toString())).stripMargin();
        ObjectRef indexMap = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, sql, (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
                H2Dialect$.$anonfun$listIndexes$1(indexMap, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot retrieved index info.");
        }
        return (TableIndex[])((scala.collection.immutable.Map)indexMap.elem).values().toArray(ClassTag$.MODULE$.apply(TableIndex.class));
    }

    private String tableNameWithSchema(Identifier ident) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).$colon$plus((Object)ident.name(), ClassTag$.MODULE$.apply(String.class)))).map((Function1 & Serializable & scala.Serializable)colName -> MODULE$.quoteIdentifier((String)colName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
    }

    private String indexNameWithSchema(Identifier ident, String indexName) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).$colon$plus((Object)indexName, ClassTag$.MODULE$.apply(String.class)))).map((Function1 & Serializable & scala.Serializable)colName -> MODULE$.quoteIdentifier((String)colName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
    }

    @Override
    public AnalysisException classifyException(String message, Throwable e) {
        block7: {
            Throwable throwable = e;
            if (!(throwable instanceof SQLException)) break block7;
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 42101: {
                    Regex regex = new StringOps(Predef$.MODULE$.augmentString("\"((?:[^\"\\\\]|\\\\[\\\\\"ntbrf])+)\"")).r();
                    String name = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)e.getMessage()).get()).group(1);
                    String quotedName = package$.MODULE$.quoteIdentifier(name);
                    throw new TableAlreadyExistsException("TABLE_OR_VIEW_ALREADY_EXISTS", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)quotedName)})), (Option)new Some((Object)e));
                }
                case 42102: {
                    String quotedName = package$.MODULE$.quoteNameParts(UnresolvedAttribute$.MODULE$.parseAttributeName(message));
                    throw new NoSuchTableException("TABLE_OR_VIEW_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)quotedName)})));
                }
                case 90079: {
                    Regex regex = new StringOps(Predef$.MODULE$.augmentString("\"((?:[^\"\\\\]|\\\\[\\\\\"ntbrf])+)\"")).r();
                    String name = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)e.getMessage()).get()).group(1);
                    String quotedName = package$.MODULE$.quoteIdentifier(name);
                    throw new NoSuchNamespaceException("SCHEMA_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)quotedName)})));
                }
                case 42111: {
                    Regex regex = new StringOps(Predef$.MODULE$.augmentString("(?s)Failed to create index (.*) in (.*)")).r();
                    String indexName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(1);
                    String tableName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(2);
                    throw new IndexAlreadyExistsException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 42112: {
                    Regex regex = new StringOps(Predef$.MODULE$.augmentString("(?s)Failed to drop index (.*) in (.*)")).r();
                    String indexName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(1);
                    String tableName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(2);
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
            }
        }
        return super.classifyException(message, e);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        H2Dialect.H2SQLBuilder h2SQLBuilder = new H2Dialect.H2SQLBuilder();
        try {
            some = new Some((Object)h2SQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurs while compiling V2 expression", e);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$listIndexes$1(ObjectRef indexMap$1, ResultSet rs) {
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            String colName = rs.getString("COLUMN_NAME");
            String indexType = rs.getString("INDEX_TYPE_NAME");
            String indexComment = rs.getString("REMARKS");
            if (((scala.collection.immutable.Map)indexMap$1.elem).contains((Object)indexName)) {
                TableIndex index = (TableIndex)((scala.collection.immutable.Map)indexMap$1.elem).apply((Object)indexName);
                TableIndex newIndex = new TableIndex(indexName, indexType, (NamedReference[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])index.columns())).$colon$plus((Object)FieldReference$.MODULE$.apply(colName), ClassTag$.MODULE$.apply(NamedReference.class)), index.columnProperties(), index.properties());
                indexMap$1.elem = ((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)newIndex));
                continue;
            }
            Properties properties = new Properties();
            Object object = StringUtils.isNotEmpty((CharSequence)indexComment) ? properties.put("COMMENT", indexComment) : BoxedUnit.UNIT;
            TableIndex index = new TableIndex(indexName, indexType, (NamedReference[])((Object[])new NamedReference[]{FieldReference$.MODULE$.apply(colName)}), new HashMap(), properties);
            indexMap$1.elem = ((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)index));
        }
    }

    private H2Dialect$() {
        MODULE$ = this;
        this.org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
        this.supportedAggregateFunctions = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}))).$plus$plus(this.org$apache$spark$sql$jdbc$H2Dialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = (Set)this.supportedAggregateFunctions().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ABS", "COALESCE", "GREATEST", "LEAST", "RAND", "LOG", "LOG10", "LN", "EXP", "POWER", "SQRT", "FLOOR", "CEIL", "ROUND", "SIN", "SINH", "COS", "COSH", "TAN", "TANH", "COT", "ASIN", "ACOS", "ATAN", "ATAN2", "DEGREES", "RADIANS", "SIGN", "PI", "SUBSTRING", "UPPER", "LOWER", "TRANSLATE", "TRIM", "MD5", "SHA1", "SHA2", "BIT_LENGTH", "CHAR_LENGTH", "CONCAT"})));
        this.functionMap = new ConcurrentHashMap<String, UnboundFunction>();
    }
}

