/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.arrow;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.TaskContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.arrow.ArrowConverters$;
import org.apache.spark.sql.execution.arrow.ArrowWriter;
import org.apache.spark.sql.execution.arrow.ArrowWriter$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.ArrowUtils$;
import org.apache.spark.util.SizeEstimator$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\ruqA\u0002(P\u0011\u0003\u00196L\u0002\u0004^\u001f\"\u00051K\u0018\u0005\u0006W\u0006!\t!\u001c\u0004\u0006]\u0006\u00011k\u001c\u0005\u000b\u0003\u000b\u0019!\u0011!Q\u0001\n\u0005\u001d\u0001BCA\u000b\u0007\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u00111E\u0002\u0003\u0002\u0003\u0006I!!\n\t\u0015\u0005-2A!A!\u0002\u0013\ti\u0003\u0003\u0006\u0002>\r\u0011\t\u0011)A\u0005\u0003\u007fA!\"!\u0012\u0004\u0005\u0003\u0005\u000b\u0011BA$\u0011\u0019Y7\u0001\"\u0001\u0002P!I\u0011\u0011M\u0002C\u0002\u0013E\u00111\r\u0005\t\u0003s\u001a\u0001\u0015!\u0003\u0002f!I\u00111P\u0002C\u0002\u0013%\u0011Q\u0010\u0005\t\u0003\u0017\u001b\u0001\u0015!\u0003\u0002\u0000!I\u0011QR\u0002C\u0002\u0013%\u0011q\u0012\u0005\t\u00033\u001b\u0001\u0015!\u0003\u0002\u0012\"I\u00111T\u0002C\u0002\u0013E\u0011Q\u0014\u0005\t\u0003K\u001b\u0001\u0015!\u0003\u0002 \"I\u0011qU\u0002C\u0002\u0013E\u0011\u0011\u0016\u0005\t\u0003c\u001b\u0001\u0015!\u0003\u0002,\"9\u00111W\u0002\u0005B\u0005U\u0006bBA\\\u0007\u0011\u0005\u0013\u0011\u0018\u0004\b\u0003w\u000b\u0001aUA_\u0011)\t)a\u0006B\u0001B\u0003%\u0011q\u0001\u0005\u000b\u0003+9\"\u0011!Q\u0001\n\u0005]\u0001BCA\u0012/\t\u0005\t\u0015!\u0003\u0002&!Q\u0011qX\f\u0003\u0002\u0003\u0006I!!\n\t\u0015\u0005-rC!A!\u0002\u0013\ti\u0003\u0003\u0006\u0002>]\u0011\t\u0011)A\u0005\u0003\u007fA!\"!\u0012\u0018\u0005\u0003\u0005\u000b\u0011BA$\u0011\u0019Yw\u0003\"\u0001\u0002B\"I\u00111[\fC\u0002\u0013%\u0011Q\u001b\u0005\t\u0003/<\u0002\u0015!\u0003\u0002&!I\u0011\u0011\\\fA\u0002\u0013\u0005\u0011Q\u001b\u0005\n\u00037<\u0002\u0019!C\u0001\u0003;D\u0001\"!;\u0018A\u0003&\u0011Q\u0005\u0005\b\u0003o;B\u0011IA]\u0011!\tY/\u0001C\u0001'\u00065\b\u0002CA~\u0003\u0011\u00051+!@\t\u0011\t-\u0011\u0001\"\u0001T\u0005\u001b1\u0001B!\u0006\u0002\u0003\u0003\u0019&q\u0003\u0005\n\u00053I#\u0011!Q\u0001\nAD!\"!\u0012*\u0005\u0003\u0005\u000b\u0011BA$\u0011\u0019Y\u0017\u0006\"\u0001\u0003\u001c!I!1E\u0015C\u0002\u0013\u0005!Q\u0005\u0005\t\u0005\u000fJ\u0003\u0015!\u0003\u0003(!I\u00111P\u0015C\u0002\u0013E\u0011Q\u0010\u0005\t\u0003\u0017K\u0003\u0015!\u0003\u0002\u0000!I!\u0011J\u0015A\u0002\u0013%!1\n\u0005\n\u0005'J\u0003\u0019!C\u0005\u0005+B\u0001B!\u0017*A\u0003&!Q\n\u0005\n\u0003+I#\u0019!C\u0001\u00057B\u0001B!\u0018*A\u0003%\u0011q\u0003\u0005\b\u0003gKC\u0011IA[\u0011\u001d\t9,\u000bC!\u0005?BqA!\u0019*\r\u0003\u0011\u0019GB\u0004\u0003f\u0005\u00011Ka\u001a\t\u0013\te\u0011H!A!\u0002\u0013\u0001\bBCA\u000bs\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u00111F\u001d\u0003\u0002\u0003\u0006I!!\f\t\u0015\u0005u\u0012H!A!\u0002\u0013\ty\u0004\u0003\u0006\u0002Fe\u0012\t\u0011)A\u0005\u0003\u000fBaa[\u001d\u0005\u0002\t%\u0004b\u0002B1s\u0011\u0005#1\r\u0004\b\u0005o\n\u0001a\u0015B=\u0011%\u0011I\"\u0011B\u0001B\u0003%\u0001\u000f\u0003\u0006\u0002F\u0005\u0013\t\u0011)A\u0005\u0003\u000fBaa[!\u0005\u0002\tm\u0004b\u0002B1\u0003\u0012\u0005#1\r\u0005\t\u0005\u0007\u000bA\u0011A*\u0003\u0006\"A!\u0011S\u0001\u0005\u0002M\u0013\u0019\nC\u0004\u0003\u001a\u0006!IAa'\t\u0011\t}\u0015\u0001\"\u0001P\u0005CCqA!/\u0002\t\u0003\u0011Y\f\u0003\u0005\u0003n\u0006!\ta\u0015Bx\u0011!\u001190\u0001C\u0001'\ne\bbBB\b\u0003\u0011%1\u0011C\u0001\u0010\u0003J\u0014xn^\"p]Z,'\u000f^3sg*\u0011\u0001+U\u0001\u0006CJ\u0014xn\u001e\u0006\u0003%N\u000b\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005Q+\u0016aA:rY*\u0011akV\u0001\u0006gB\f'o\u001b\u0006\u00031f\u000ba!\u00199bG\",'\"\u0001.\u0002\u0007=\u0014x\r\u0005\u0002]\u00035\tqJA\bBeJ|woQ8om\u0016\u0014H/\u001a:t'\r\tq,\u001a\t\u0003A\u000el\u0011!\u0019\u0006\u0002E\u0006)1oY1mC&\u0011A-\u0019\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019LW\"A4\u000b\u0005!,\u0016\u0001C5oi\u0016\u0014h.\u00197\n\u0005)<'a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t1L\u0001\nBeJ|wOQ1uG\"LE/\u001a:bi>\u00148cA\u0002`aB\u0019\u0011/\u001f?\u000f\u0005I<hBA:w\u001b\u0005!(BA;m\u0003\u0019a$o\\8u}%\t!-\u0003\u0002yC\u00069\u0001/Y2lC\u001e,\u0017B\u0001>|\u0005!IE/\u001a:bi>\u0014(B\u0001=b!\r\u0001Wp`\u0005\u0003}\u0006\u0014Q!\u0011:sCf\u00042\u0001YA\u0001\u0013\r\t\u0019!\u0019\u0002\u0005\u0005f$X-A\u0004s_^LE/\u001a:\u0011\tEL\u0018\u0011\u0002\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011qB*\u0002\u0011\r\fG/\u00197zgRLA!a\u0005\u0002\u000e\tY\u0011J\u001c;fe:\fGNU8x\u0003\u0019\u00198\r[3nCB!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001eM\u000bQ\u0001^=qKNLA!!\t\u0002\u001c\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002%5\f\u0007PU3d_J$7\u000fU3s\u0005\u0006$8\r\u001b\t\u0004A\u0006\u001d\u0012bAA\u0015C\n!Aj\u001c8h\u0003)!\u0018.\\3[_:,\u0017\n\u001a\t\u0005\u0003_\t9D\u0004\u0003\u00022\u0005M\u0002CA:b\u0013\r\t)$Y\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00121\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005U\u0012-A\u000efeJ|'o\u00148EkBd\u0017nY1uK\u00124\u0015.\u001a7e\u001d\u0006lWm\u001d\t\u0004A\u0006\u0005\u0013bAA\"C\n9!i\\8mK\u0006t\u0017aB2p]R,\u0007\u0010\u001e\t\u0005\u0003\u0013\nY%D\u0001V\u0013\r\ti%\u0016\u0002\f)\u0006\u001c8nQ8oi\u0016DH\u000f\u0006\b\u0002R\u0005U\u0013qKA-\u00037\ni&a\u0018\u0011\u0007\u0005M3!D\u0001\u0002\u0011\u001d\t)A\u0003a\u0001\u0003\u000fAq!!\u0006\u000b\u0001\u0004\t9\u0002C\u0004\u0002$)\u0001\r!!\n\t\u000f\u0005-\"\u00021\u0001\u0002.!9\u0011Q\b\u0006A\u0002\u0005}\u0002bBA#\u0015\u0001\u0007\u0011qI\u0001\fCJ\u0014xn^*dQ\u0016l\u0017-\u0006\u0002\u0002fA!\u0011qMA;\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014\u0001\u00029pU>TA!!\b\u0002p)!\u0011\u0011OA:\u0003\u00191Xm\u0019;pe*\u0011\u0001kV\u0005\u0005\u0003o\nIG\u0001\u0004TG\",W.Y\u0001\rCJ\u0014xn^*dQ\u0016l\u0017\rI\u0001\nC2dwnY1u_J,\"!a \u0011\t\u0005\u0005\u0015qQ\u0007\u0003\u0003\u0007SA!!\"\u0002t\u00051Q.Z7pefLA!!#\u0002\u0004\ny!)\u001e4gKJ\fE\u000e\\8dCR|'/\u0001\u0006bY2|7-\u0019;pe\u0002\nAA]8piV\u0011\u0011\u0011\u0013\t\u0005\u0003'\u000b)*\u0004\u0002\u0002p%!\u0011qSA8\u0005A1Vm\u0019;peN\u001b\u0007.Z7b%>|G/A\u0003s_>$\b%\u0001\u0005v]2|\u0017\rZ3s+\t\ty\n\u0005\u0003\u0002\u0014\u0006\u0005\u0016\u0002BAR\u0003_\u0012aBV3di>\u0014XK\u001c7pC\u0012,'/A\u0005v]2|\u0017\rZ3sA\u0005Y\u0011M\u001d:po^\u0013\u0018\u000e^3s+\t\tY\u000bE\u0002]\u0003[K1!a,P\u0005-\t%O]8x/JLG/\u001a:\u0002\u0019\u0005\u0014(o\\<Xe&$XM\u001d\u0011\u0002\u000f!\f7OT3yiV\u0011\u0011qH\u0001\u0005]\u0016DH\u000fF\u0001}\u0005q\t%O]8x\u0005\u0006$8\r[,ji\"\u001c6\r[3nC&#XM]1u_J\u001c2aFA)\u0003Ui\u0017\r_#ti&l\u0017\r^3e\u0005\u0006$8\r[*ju\u0016$\u0002#a1\u0002F\u0006\u001d\u0017\u0011ZAf\u0003\u001b\fy-!5\u0011\u0007\u0005Ms\u0003C\u0004\u0002\u0006}\u0001\r!a\u0002\t\u000f\u0005Uq\u00041\u0001\u0002\u0018!9\u00111E\u0010A\u0002\u0005\u0015\u0002bBA`?\u0001\u0007\u0011Q\u0005\u0005\b\u0003Wy\u0002\u0019AA\u0017\u0011\u001d\tid\ba\u0001\u0003\u007fAq!!\u0012 \u0001\u0004\t9%A\bbeJ|woU2iK6\f7+\u001b>f+\t\t)#\u0001\tbeJ|woU2iK6\f7+\u001b>fA\u0005\u0019\"o\\<D_VtG/\u00138MCN$()\u0019;dQ\u00069\"o\\<D_VtG/\u00138MCN$()\u0019;dQ~#S-\u001d\u000b\u0005\u0003?\f)\u000fE\u0002a\u0003CL1!a9b\u0005\u0011)f.\u001b;\t\u0013\u0005\u001d8%!AA\u0002\u0005\u0015\u0012a\u0001=%c\u0005!\"o\\<D_VtG/\u00138MCN$()\u0019;dQ\u0002\nq\u0002^8CCR\u001c\u0007.\u0013;fe\u0006$xN\u001d\u000b\u000f\u0003#\ny/!=\u0002t\u0006U\u0018q_A}\u0011\u001d\t)A\na\u0001\u0003\u000fAq!!\u0006'\u0001\u0004\t9\u0002C\u0004\u0002$\u0019\u0002\r!!\n\t\u000f\u0005-b\u00051\u0001\u0002.!9\u0011Q\b\u0014A\u0002\u0005}\u0002bBA#M\u0001\u0007\u0011qI\u0001\u001ai>\u0014\u0015\r^2i/&$\bnU2iK6\f\u0017\n^3sCR|'\u000f\u0006\b\u0002D\u0006}(\u0011\u0001B\u0002\u0005\u000b\u00119A!\u0003\t\u000f\u0005\u0015q\u00051\u0001\u0002\b!9\u0011QC\u0014A\u0002\u0005]\u0001bBA\u0012O\u0001\u0007\u0011Q\u0005\u0005\b\u0003\u007f;\u0003\u0019AA\u0013\u0011\u001d\tYc\na\u0001\u0003[Aq!!\u0010(\u0001\u0004\ty$A\u000bde\u0016\fG/Z#naRL\u0018I\u001d:po\n\u000bGo\u00195\u0015\u000fq\u0014yA!\u0005\u0003\u0014!9\u0011Q\u0003\u0015A\u0002\u0005]\u0001bBA\u0016Q\u0001\u0007\u0011Q\u0006\u0005\b\u0003{A\u0003\u0019AA \u0005MIe\u000e^3s]\u0006d'k\\<Ji\u0016\u0014\u0018\r^8s'\u0011Is,a\u0002\u0002\u001d\u0005\u0014(o\\<CCR\u001c\u0007.\u0013;feR1!Q\u0004B\u0010\u0005C\u00012!a\u0015*\u0011\u0019\u0011I\u0002\fa\u0001a\"9\u0011Q\t\u0017A\u0002\u0005\u001d\u0013!\u0003:fg>,(oY3t+\t\u00119\u0003\u0005\u0004\u0003*\tM\"qG\u0007\u0003\u0005WQAA!\f\u00030\u00059Q.\u001e;bE2,'b\u0001B\u0019C\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tU\"1\u0006\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0003\u0003:\t\rSB\u0001B\u001e\u0015\u0011\u0011iDa\u0010\u0002\t1\fgn\u001a\u0006\u0003\u0005\u0003\nAA[1wC&!!Q\tB\u001e\u00055\tU\u000f^8DY>\u001cX-\u00192mK\u0006Q!/Z:pkJ\u001cWm\u001d\u0011\u0002!I|w/\u0013;fe\u0006sGmU2iK6\fWC\u0001B'!\u001d\u0001'qJA\u0004\u0003/I1A!\u0015b\u0005\u0019!V\u000f\u001d7fe\u0005!\"o\\<Ji\u0016\u0014\u0018I\u001c3TG\",W.Y0%KF$B!a8\u0003X!I\u0011q\u001d\u001a\u0002\u0002\u0003\u0007!QJ\u0001\u0012e><\u0018\n^3s\u0003:$7k\u00195f[\u0006\u0004SCAA\f\u0003\u001d\u00198\r[3nC\u0002\"\"!!\u0003\u0002\u00139,\u0007\u0010\u001e\"bi\u000eDGC\u0001B'\u0005\u0001Je\u000e^3s]\u0006d'k\\<Ji\u0016\u0014\u0018\r^8s/&$\bn\\;u'\u000eDW-\\1\u0014\u0007e\u0012i\u0002\u0006\u0007\u0003l\t5$q\u000eB9\u0005g\u0012)\bE\u0002\u0002TeBaA!\u0007@\u0001\u0004\u0001\bbBA\u000b\u007f\u0001\u0007\u0011q\u0003\u0005\b\u0003Wy\u0004\u0019AA\u0017\u0011\u001d\tid\u0010a\u0001\u0003\u007fAq!!\u0012@\u0001\u0004\t9EA\u000fJ]R,'O\\1m%><\u0018\n^3sCR|'oV5uQN\u001b\u0007.Z7b'\r\t%Q\u0004\u000b\u0007\u0005{\u0012yH!!\u0011\u0007\u0005M\u0013\t\u0003\u0004\u0003\u001a\u0011\u0003\r\u0001\u001d\u0005\b\u0003\u000b\"\u0005\u0019AA$\u0003E1'o\\7CCR\u001c\u0007.\u0013;fe\u0006$xN\u001d\u000b\r\u0003\u000f\u00119I!#\u0003\f\n5%q\u0012\u0005\u0007\u000531\u0005\u0019\u00019\t\u000f\u0005Ua\t1\u0001\u0002\u0018!9\u00111\u0006$A\u0002\u00055\u0002bBA\u001f\r\u0002\u0007\u0011q\b\u0005\b\u0003\u000b2\u0005\u0019AA$\u0003m1'o\\7CCR\u001c\u0007nV5uQN\u001b\u0007.Z7b\u0013R,'/\u0019;peR1!Q\nBK\u0005/CaA!\u0007H\u0001\u0004\u0001\bbBA#\u000f\u0002\u0007\u0011qI\u0001\u0017m\u0016\u001cGo\u001c:TG\",W.\u0019*p_R$v.\u0013;feR!\u0011q\u0001BO\u0011\u001d\ti\t\u0013a\u0001\u0003#\u000b\u0011\u0002\\8bI\n\u000bGo\u00195\u0015\r\t\r&1\u0017B\\!\u0011\u0011)Ka,\u000e\u0005\t\u001d&\u0002\u0002BU\u0005W\u000bq!\\3tg\u0006<WM\u0003\u0003\u0003.\u0006=\u0014aA5qG&!!\u0011\u0017BT\u0005A\t%O]8x%\u0016\u001cwN\u001d3CCR\u001c\u0007\u000e\u0003\u0004\u00036&\u0003\r\u0001`\u0001\u000bE\u0006$8\r\u001b\"zi\u0016\u001c\bbBA>\u0013\u0002\u0007\u0011qP\u0001\fi>$\u0015\r^1Ge\u0006lW\r\u0006\u0005\u0003>\ne'Q\u001cBq!\u0011\u0011yLa5\u000f\t\t\u0005'\u0011\u001b\b\u0005\u0005\u0007\u0014yM\u0004\u0003\u0003F\n5g\u0002\u0002Bd\u0005\u0017t1a\u001dBe\u0013\u0005Q\u0016B\u0001-Z\u0013\t1v+\u0003\u0002U+&\u0011\u0001pU\u0005\u0005\u0005+\u00149NA\u0005ECR\fgI]1nK*\u0011\u0001p\u0015\u0005\u0007\u00057T\u0005\u0019\u00019\u0002\u0019\u0005\u0014(o\\<CCR\u001c\u0007.Z:\t\u000f\t}'\n1\u0001\u0002.\u0005a1o\u00195f[\u0006\u001cFO]5oO\"9!1\u001d&A\u0002\t\u0015\u0018aB:fgNLwN\u001c\t\u0005\u0005O\u0014I/D\u0001T\u0013\r\u0011Yo\u0015\u0002\r'B\f'o[*fgNLwN\\\u0001\u0018e\u0016\fG-\u0011:s_^\u001cFO]3b[\u001a\u0013x.\u001c$jY\u0016$BA!=\u0003tB\u0019\u0001- ?\t\u000f\tU8\n1\u0001\u0002.\u0005Aa-\u001b7f]\u0006lW-\u0001\u000bhKR\u0014\u0015\r^2iKN4%o\\7TiJ,\u0017-\u001c\u000b\u0004a\nm\bb\u0002B\u007f\u0019\u0002\u0007!q`\u0001\u0003S:\u0004Ba!\u0001\u0004\f5\u001111\u0001\u0006\u0005\u0007\u000b\u00199!\u0001\u0005dQ\u0006tg.\u001a7t\u0015\u0011\u0019IAa\u0010\u0002\u00079Lw.\u0003\u0003\u0004\u000e\r\r!a\u0005*fC\u0012\f'\r\\3CsR,7\t[1o]\u0016d\u0017\u0001C2m_N,\u0017\t\u001c7\u0015\t\u0005}71\u0003\u0005\b\u0007+i\u0005\u0019AB\f\u0003)\u0019Gn\\:fC\ndWm\u001d\t\u0006A\u000ee!qG\u0005\u0004\u00077\t'A\u0003\u001fsKB,\u0017\r^3e}\u0001")
public final class ArrowConverters {
    public static Dataset<Row> toDataFrame(Iterator<byte[]> iterator, String string, SparkSession sparkSession) {
        return ArrowConverters$.MODULE$.toDataFrame(iterator, string, sparkSession);
    }

    public static class ArrowBatchIterator
    implements Iterator<byte[]> {
        private final Iterator<InternalRow> rowIter;
        private final long maxRecordsPerBatch;
        private final Schema arrowSchema;
        private final BufferAllocator allocator;
        private final VectorSchemaRoot root;
        private final VectorUnloader unloader;
        private final ArrowWriter arrowWriter;

        public Iterator<byte[]> seq() {
            return Iterator.seq$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public boolean isTraversableAgain() {
            return Iterator.isTraversableAgain$((Iterator)this);
        }

        public boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public Iterator<byte[]> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<byte[]> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<byte[]> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<byte[]> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<B> map(Function1<byte[], B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            return Iterator.$plus$plus$((Iterator)this, that);
        }

        public <B> Iterator<B> flatMap(Function1<byte[], GenTraversableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public Iterator<byte[]> filter(Function1<byte[], Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<byte[], B, Object> p) {
            return Iterator.corresponds$((Iterator)this, that, p);
        }

        public Iterator<byte[]> withFilter(Function1<byte[], Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public Iterator<byte[]> filterNot(Function1<byte[], Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<byte[], B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, byte[], B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<byte[], B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public Iterator<byte[]> takeWhile(Function1<byte[], Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<byte[]>, Iterator<byte[]>> partition(Function1<byte[], Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public Tuple2<Iterator<byte[]>, Iterator<byte[]>> span(Function1<byte[], Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<byte[]> dropWhile(Function1<byte[], Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public <B> Iterator<Tuple2<byte[], B>> zip(Iterator<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1> Iterator<A1> padTo(int len, A1 elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Iterator<Tuple2<byte[], Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public <U> void foreach(Function1<byte[], U> f) {
            Iterator.foreach$((Iterator)this, f);
        }

        public boolean forall(Function1<byte[], Object> p) {
            return Iterator.forall$((Iterator)this, p);
        }

        public boolean exists(Function1<byte[], Object> p) {
            return Iterator.exists$((Iterator)this, p);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public Option<byte[]> find(Function1<byte[], Object> p) {
            return Iterator.find$((Iterator)this, p);
        }

        public int indexWhere(Function1<byte[], Object> p) {
            return Iterator.indexWhere$((Iterator)this, p);
        }

        public int indexWhere(Function1<byte[], Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public BufferedIterator<byte[]> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public int length() {
            return Iterator.length$((Iterator)this);
        }

        public Tuple2<Iterator<byte[]>, Iterator<byte[]>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
        }

        public boolean sameElements(Iterator<?> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Traversable<byte[]> toTraversable() {
            return Iterator.toTraversable$((Iterator)this);
        }

        public Iterator<byte[]> toIterator() {
            return Iterator.toIterator$((Iterator)this);
        }

        public Stream<byte[]> toStream() {
            return Iterator.toStream$((Iterator)this);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public List<byte[]> reversed() {
            return TraversableOnce.reversed$((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.size$((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.nonEmpty$((TraversableOnce)this);
        }

        public int count(Function1<byte[], Object> p) {
            return TraversableOnce.count$((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<byte[], B> pf) {
            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, byte[], B> op) {
            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<byte[], B, B> op) {
            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, byte[], B> op) {
            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
        }

        public <B> B foldRight(B z, Function2<byte[], B, B> op) {
            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, byte[], B> op) {
            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
        }

        public <B> B reduceRight(Function2<byte[], B, B> op) {
            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, byte[], B> op) {
            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<byte[], B, B> op) {
            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, byte[], B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.product$((TraversableOnce)this, num);
        }

        public Object min(Ordering cmp) {
            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object max(Ordering cmp) {
            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
        }

        public List<byte[]> toList() {
            return TraversableOnce.toList$((TraversableOnce)this);
        }

        public Iterable<byte[]> toIterable() {
            return TraversableOnce.toIterable$((TraversableOnce)this);
        }

        public Seq<byte[]> toSeq() {
            return TraversableOnce.toSeq$((TraversableOnce)this);
        }

        public IndexedSeq<byte[]> toIndexedSeq() {
            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.toBuffer$((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.toSet$((TraversableOnce)this);
        }

        public Vector<byte[]> toVector() {
            return TraversableOnce.toVector$((TraversableOnce)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, byte[], Col> cbf) {
            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
        }

        public <T, U> Map<T, U> toMap(Predef.$less$colon$less<byte[], Tuple2<T, U>> ev) {
            return TraversableOnce.toMap$((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.mkString$((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
        }

        public int sizeHintIfCheap() {
            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
        }

        public Schema arrowSchema() {
            return this.arrowSchema;
        }

        private BufferAllocator allocator() {
            return this.allocator;
        }

        private VectorSchemaRoot root() {
            return this.root;
        }

        public VectorUnloader unloader() {
            return this.unloader;
        }

        public ArrowWriter arrowWriter() {
            return this.arrowWriter;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean hasNext() {
            if (this.rowIter.hasNext()) return true;
            this.root().close();
            this.allocator().close();
            if (!false) return false;
            return true;
        }

        public byte[] next() {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            WriteChannel writeChannel = new WriteChannel(Channels.newChannel(out));
            Utils$.MODULE$.tryWithSafeFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                for (long rowCount = 0L; $this.rowIter.hasNext() && ($this.maxRecordsPerBatch <= 0L || rowCount < $this.maxRecordsPerBatch); ++rowCount) {
                    InternalRow row = (InternalRow)$this.rowIter.next();
                    this.arrowWriter().write(row);
                }
                this.arrowWriter().finish();
                ArrowRecordBatch batch = this.unloader().getRecordBatch();
                MessageSerializer.serialize((WriteChannel)writeChannel, (ArrowRecordBatch)batch);
                batch.close();
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.arrowWriter().reset());
            return out.toByteArray();
        }

        public static final /* synthetic */ void $anonfun$new$2(ArrowBatchIterator $this, TaskContext x$2) {
            $this.root().close();
            $this.allocator().close();
        }

        public ArrowBatchIterator(Iterator<InternalRow> rowIter, StructType schema, long maxRecordsPerBatch, String timeZoneId, boolean errorOnDuplicatedFieldNames, TaskContext context) {
            this.rowIter = rowIter;
            this.maxRecordsPerBatch = maxRecordsPerBatch;
            GenTraversableOnce.$init$((GenTraversableOnce)this);
            TraversableOnce.$init$((TraversableOnce)this);
            Iterator.$init$((Iterator)this);
            this.arrowSchema = ArrowUtils$.MODULE$.toArrowSchema(schema, timeZoneId, errorOnDuplicatedFieldNames, ArrowUtils$.MODULE$.toArrowSchema$default$4());
            this.allocator = ArrowUtils$.MODULE$.rootAllocator().newChildAllocator(new java.lang.StringBuilder(2).append("to").append(this.getClass().getSimpleName()).toString(), 0L, Long.MAX_VALUE);
            this.root = VectorSchemaRoot.create((Schema)this.arrowSchema(), (BufferAllocator)this.allocator());
            this.unloader = new VectorUnloader(this.root());
            this.arrowWriter = ArrowWriter$.MODULE$.create(this.root());
            Option$.MODULE$.apply((Object)context).foreach((Function1 & Serializable & scala.Serializable)x$1 -> x$1.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$2 -> {
                ArrowBatchIterator.$anonfun$new$2(this, x$2);
                return BoxedUnit.UNIT;
            }));
        }
    }

    public static class ArrowBatchWithSchemaIterator
    extends ArrowBatchIterator {
        private final Iterator<InternalRow> rowIter;
        private final long maxRecordsPerBatch;
        private final long maxEstimatedBatchSize;
        private final long arrowSchemaSize;
        private long rowCountInLastBatch;

        private long arrowSchemaSize() {
            return this.arrowSchemaSize;
        }

        public long rowCountInLastBatch() {
            return this.rowCountInLastBatch;
        }

        public void rowCountInLastBatch_$eq(long x$1) {
            this.rowCountInLastBatch = x$1;
        }

        @Override
        public byte[] next() {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            WriteChannel writeChannel = new WriteChannel(Channels.newChannel(out));
            this.rowCountInLastBatch_$eq(0L);
            LongRef estimatedBatchSize = LongRef.create((long)this.arrowSchemaSize());
            Utils$.MODULE$.tryWithSafeFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                MessageSerializer.serialize((WriteChannel)writeChannel, (Schema)this.arrowSchema());
                while ($this.rowIter.hasNext() && (this.rowCountInLastBatch() == 0L && $this.maxEstimatedBatchSize > 0L || !this.isBatchSizeLimitExceeded$1(estimatedBatchSize) && !this.isRecordLimitExceeded$1())) {
                    long l;
                    InternalRow row = (InternalRow)$this.rowIter.next();
                    this.arrowWriter().write(row);
                    long l2 = estimatedBatchSize$1.elem;
                    InternalRow internalRow = row;
                    if (internalRow instanceof UnsafeRow) {
                        UnsafeRow unsafeRow = (UnsafeRow)internalRow;
                        l = unsafeRow.getSizeInBytes();
                    } else if (internalRow != null) {
                        InternalRow internalRow2 = internalRow;
                        l = internalRow2.numFields() * 16;
                    } else {
                        throw new MatchError((Object)internalRow);
                    }
                    estimatedBatchSize$1.elem = l2 + l;
                    this.rowCountInLastBatch_$eq(this.rowCountInLastBatch() + 1L);
                }
                this.arrowWriter().finish();
                ArrowRecordBatch batch = this.unloader().getRecordBatch();
                MessageSerializer.serialize((WriteChannel)writeChannel, (ArrowRecordBatch)batch);
                ArrowStreamWriter.writeEndOfStream((WriteChannel)writeChannel, (IpcOption)IpcOption.DEFAULT);
                batch.close();
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.arrowWriter().reset());
            return out.toByteArray();
        }

        private final boolean isBatchSizeLimitExceeded$1(LongRef estimatedBatchSize$1) {
            return this.maxEstimatedBatchSize > 0L && estimatedBatchSize$1.elem >= this.maxEstimatedBatchSize;
        }

        private final boolean isRecordLimitExceeded$1() {
            return this.maxRecordsPerBatch > 0L && this.rowCountInLastBatch() >= this.maxRecordsPerBatch;
        }

        public ArrowBatchWithSchemaIterator(Iterator<InternalRow> rowIter, StructType schema, long maxRecordsPerBatch, long maxEstimatedBatchSize, String timeZoneId, boolean errorOnDuplicatedFieldNames, TaskContext context) {
            this.rowIter = rowIter;
            this.maxRecordsPerBatch = maxRecordsPerBatch;
            this.maxEstimatedBatchSize = maxEstimatedBatchSize;
            super(rowIter, schema, maxRecordsPerBatch, timeZoneId, errorOnDuplicatedFieldNames, context);
            this.arrowSchemaSize = SizeEstimator$.MODULE$.estimate((Object)this.arrowSchema());
            this.rowCountInLastBatch = 0L;
        }
    }

    public static abstract class InternalRowIterator
    implements Iterator<InternalRow> {
        private final Iterator<byte[]> arrowBatchIter;
        private final ArrayBuffer<AutoCloseable> resources;
        private final BufferAllocator allocator;
        private Tuple2<Iterator<InternalRow>, StructType> rowIterAndSchema;
        private final StructType schema;

        public Iterator<InternalRow> seq() {
            return Iterator.seq$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public boolean isTraversableAgain() {
            return Iterator.isTraversableAgain$((Iterator)this);
        }

        public boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public Iterator<InternalRow> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<InternalRow> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<InternalRow> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<InternalRow> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<B> map(Function1<InternalRow, B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            return Iterator.$plus$plus$((Iterator)this, that);
        }

        public <B> Iterator<B> flatMap(Function1<InternalRow, GenTraversableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public Iterator<InternalRow> filter(Function1<InternalRow, Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<InternalRow, B, Object> p) {
            return Iterator.corresponds$((Iterator)this, that, p);
        }

        public Iterator<InternalRow> withFilter(Function1<InternalRow, Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public Iterator<InternalRow> filterNot(Function1<InternalRow, Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<InternalRow, B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, InternalRow, B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<InternalRow, B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public Iterator<InternalRow> takeWhile(Function1<InternalRow, Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> partition(Function1<InternalRow, Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> span(Function1<InternalRow, Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<InternalRow> dropWhile(Function1<InternalRow, Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public <B> Iterator<Tuple2<InternalRow, B>> zip(Iterator<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1> Iterator<A1> padTo(int len, A1 elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Iterator<Tuple2<InternalRow, Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public <U> void foreach(Function1<InternalRow, U> f) {
            Iterator.foreach$((Iterator)this, f);
        }

        public boolean forall(Function1<InternalRow, Object> p) {
            return Iterator.forall$((Iterator)this, p);
        }

        public boolean exists(Function1<InternalRow, Object> p) {
            return Iterator.exists$((Iterator)this, p);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public Option<InternalRow> find(Function1<InternalRow, Object> p) {
            return Iterator.find$((Iterator)this, p);
        }

        public int indexWhere(Function1<InternalRow, Object> p) {
            return Iterator.indexWhere$((Iterator)this, p);
        }

        public int indexWhere(Function1<InternalRow, Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public BufferedIterator<InternalRow> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public int length() {
            return Iterator.length$((Iterator)this);
        }

        public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
        }

        public boolean sameElements(Iterator<?> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Traversable<InternalRow> toTraversable() {
            return Iterator.toTraversable$((Iterator)this);
        }

        public Iterator<InternalRow> toIterator() {
            return Iterator.toIterator$((Iterator)this);
        }

        public Stream<InternalRow> toStream() {
            return Iterator.toStream$((Iterator)this);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public List<InternalRow> reversed() {
            return TraversableOnce.reversed$((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.size$((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.nonEmpty$((TraversableOnce)this);
        }

        public int count(Function1<InternalRow, Object> p) {
            return TraversableOnce.count$((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<InternalRow, B> pf) {
            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, InternalRow, B> op) {
            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<InternalRow, B, B> op) {
            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, InternalRow, B> op) {
            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
        }

        public <B> B foldRight(B z, Function2<InternalRow, B, B> op) {
            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, InternalRow, B> op) {
            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
        }

        public <B> B reduceRight(Function2<InternalRow, B, B> op) {
            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, InternalRow, B> op) {
            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<InternalRow, B, B> op) {
            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, InternalRow, B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.product$((TraversableOnce)this, num);
        }

        public Object min(Ordering cmp) {
            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object max(Ordering cmp) {
            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
        }

        public List<InternalRow> toList() {
            return TraversableOnce.toList$((TraversableOnce)this);
        }

        public Iterable<InternalRow> toIterable() {
            return TraversableOnce.toIterable$((TraversableOnce)this);
        }

        public Seq<InternalRow> toSeq() {
            return TraversableOnce.toSeq$((TraversableOnce)this);
        }

        public IndexedSeq<InternalRow> toIndexedSeq() {
            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.toBuffer$((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.toSet$((TraversableOnce)this);
        }

        public Vector<InternalRow> toVector() {
            return TraversableOnce.toVector$((TraversableOnce)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, InternalRow, Col> cbf) {
            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
        }

        public <T, U> Map<T, U> toMap(Predef.$less$colon$less<InternalRow, Tuple2<T, U>> ev) {
            return TraversableOnce.toMap$((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.mkString$((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
        }

        public int sizeHintIfCheap() {
            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
        }

        public ArrayBuffer<AutoCloseable> resources() {
            return this.resources;
        }

        public BufferAllocator allocator() {
            return this.allocator;
        }

        private Tuple2<Iterator<InternalRow>, StructType> rowIterAndSchema() {
            return this.rowIterAndSchema;
        }

        private void rowIterAndSchema_$eq(Tuple2<Iterator<InternalRow>, StructType> x$1) {
            this.rowIterAndSchema = x$1;
        }

        public StructType schema() {
            return this.schema;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean hasNext() {
            if (((Iterator)this.rowIterAndSchema()._1()).hasNext()) return true;
            if (this.arrowBatchIter.hasNext()) {
                this.rowIterAndSchema_$eq(this.nextBatch());
                StructType structType = this.schema();
                Object object = this.rowIterAndSchema()._2();
                if (structType == null ? object != null : !structType.equals(object)) {
                    throw new IllegalArgumentException(new java.lang.StringBuilder(66).append("ArrowBatch iterator contain 2 batches with").append(" different schema: ").append(this.schema()).append(" and ").append(this.rowIterAndSchema()._2()).toString());
                }
            } else {
                ArrowConverters$.MODULE$.org$apache$spark$sql$execution$arrow$ArrowConverters$$closeAll((Seq<AutoCloseable>)((Seq)this.resources().toSeq().reverse()));
                if (!false) return false;
                return true;
            }
            if (((Iterator)this.rowIterAndSchema()._1()).hasNext()) return true;
            return false;
        }

        public InternalRow next() {
            return (InternalRow)((Iterator)this.rowIterAndSchema()._1()).next();
        }

        public abstract Tuple2<Iterator<InternalRow>, StructType> nextBatch();

        public InternalRowIterator(Iterator<byte[]> arrowBatchIter, TaskContext context) {
            this.arrowBatchIter = arrowBatchIter;
            GenTraversableOnce.$init$((GenTraversableOnce)this);
            TraversableOnce.$init$((TraversableOnce)this);
            Iterator.$init$((Iterator)this);
            this.resources = new ArrayBuffer();
            this.allocator = ArrowUtils$.MODULE$.rootAllocator().newChildAllocator(new java.lang.StringBuilder(2).append("to").append(this.getClass().getSimpleName()).toString(), 0L, Long.MAX_VALUE);
            this.resources().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{this.allocator()}));
            this.rowIterAndSchema = arrowBatchIter.hasNext() ? this.nextBatch() : new Tuple2((Object)package$.MODULE$.Iterator().empty(), null);
            this.schema = (StructType)this.rowIterAndSchema()._2();
            Object object = context != null ? context.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$3 -> {
                ArrowConverters$.MODULE$.org$apache$spark$sql$execution$arrow$ArrowConverters$$closeAll((Seq<AutoCloseable>)((Seq)this.resources().toSeq().reverse()));
                return BoxedUnit.UNIT;
            }) : BoxedUnit.UNIT;
        }
    }

    public static class InternalRowIteratorWithSchema
    extends InternalRowIterator {
        private final Iterator<byte[]> arrowBatchIter;

        @Override
        public Tuple2<Iterator<InternalRow>, StructType> nextBatch() {
            ArrowStreamReader reader = new ArrowStreamReader((InputStream)new ByteArrayInputStream((byte[])this.arrowBatchIter.next()), this.allocator());
            VectorSchemaRoot root = reader.loadNextBatch() ? reader.getVectorSchemaRoot() : null;
            this.resources().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{reader, root}));
            if (root == null) {
                return new Tuple2((Object)package$.MODULE$.Iterator().empty(), null);
            }
            return new Tuple2(ArrowConverters$.MODULE$.org$apache$spark$sql$execution$arrow$ArrowConverters$$vectorSchemaRootToIter(root), (Object)ArrowUtils$.MODULE$.fromArrowSchema(root.getSchema()));
        }

        public InternalRowIteratorWithSchema(Iterator<byte[]> arrowBatchIter, TaskContext context) {
            this.arrowBatchIter = arrowBatchIter;
            super(arrowBatchIter, context);
        }
    }

    public static class InternalRowIteratorWithoutSchema
    extends InternalRowIterator {
        private final Iterator<byte[]> arrowBatchIter;
        private final StructType schema;
        private final String timeZoneId;
        private final boolean errorOnDuplicatedFieldNames;

        @Override
        public Tuple2<Iterator<InternalRow>, StructType> nextBatch() {
            Schema arrowSchema = ArrowUtils$.MODULE$.toArrowSchema(this.schema, this.timeZoneId, this.errorOnDuplicatedFieldNames, ArrowUtils$.MODULE$.toArrowSchema$default$4());
            VectorSchemaRoot root = VectorSchemaRoot.create((Schema)arrowSchema, (BufferAllocator)this.allocator());
            this.resources().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{root}));
            ArrowRecordBatch arrowRecordBatch = ArrowConverters$.MODULE$.loadBatch((byte[])this.arrowBatchIter.next(), this.allocator());
            VectorLoader vectorLoader = new VectorLoader(root);
            vectorLoader.load(arrowRecordBatch);
            arrowRecordBatch.close();
            return new Tuple2(ArrowConverters$.MODULE$.org$apache$spark$sql$execution$arrow$ArrowConverters$$vectorSchemaRootToIter(root), (Object)this.schema);
        }

        public InternalRowIteratorWithoutSchema(Iterator<byte[]> arrowBatchIter, StructType schema, String timeZoneId, boolean errorOnDuplicatedFieldNames, TaskContext context) {
            this.arrowBatchIter = arrowBatchIter;
            this.schema = schema;
            this.timeZoneId = timeZoneId;
            this.errorOnDuplicatedFieldNames = errorOnDuplicatedFieldNames;
            super(arrowBatchIter, context);
        }
    }
}

