/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.RunLengthEncoding$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5wAB\u001f?\u0011\u0003\u0003EJ\u0002\u0004O}!\u0005\u0005i\u0014\u0005\u0006?\u0006!\t!\u0019\u0005\bE\u0006\u0011\r\u0011\"\u0011d\u0011\u00199\u0017\u0001)A\u0005I\")\u0001.\u0001C!S\"9\u0011\u0011R\u0001\u0005B\u0005-\u0005b\u0002B9\u0003\u0011\u0005#1\u000f\u0004\u0005[\u0006\u0001a\u000e\u0003\u0006\u0002\u0002!\u0011\t\u0011)A\u0005\u0003\u0007Aaa\u0018\u0005\u0005\u0002\u0005-\u0001\u0002CA\t\u0011\u0001\u0007I\u0011B2\t\u0013\u0005M\u0001\u00021A\u0005\n\u0005U\u0001bBA\u0011\u0011\u0001\u0006K\u0001\u001a\u0005\t\u0003GA\u0001\u0019!C\u0005G\"I\u0011Q\u0005\u0005A\u0002\u0013%\u0011q\u0005\u0005\b\u0003WA\u0001\u0015)\u0003e\u0011-\ti\u0003\u0003a\u0001\u0002\u0004%I!a\f\t\u0017\u0005]\u0002\u00021AA\u0002\u0013%\u0011\u0011\b\u0005\f\u0003{A\u0001\u0019!A!B\u0013\t\t\u0004\u0003\u0005\u0002@!\u0001\r\u0011\"\u0003d\u0011%\t\t\u0005\u0003a\u0001\n\u0013\t\u0019\u0005C\u0004\u0002H!\u0001\u000b\u0015\u00023\t\r\u0005%\u0003\u0002\"\u0011d\u0011\u0019\tY\u0005\u0003C!G\"9\u0011Q\n\u0005\u0005B\u0005=\u0003bBA3\u0011\u0011\u0005\u0013q\r\u0004\u0007\u0003#\u000b\u0001!a%\t\u0015\u0005}5D!A!\u0002\u0013\tI\u0007\u0003\u0006\u0002\u0002m\u0011\t\u0011)A\u0005\u0003CCaaX\u000e\u0005\u0002\u0005\r\u0006\u0002CAV7\u0001\u0007I\u0011B2\t\u0013\u000556\u00041A\u0005\n\u0005=\u0006bBAZ7\u0001\u0006K\u0001\u001a\u0005\t\u0003k[\u0002\u0019!C\u0005G\"I\u0011qW\u000eA\u0002\u0013%\u0011\u0011\u0018\u0005\b\u0003{[\u0002\u0015)\u0003e\u0011-\tyl\u0007a\u0001\u0002\u0004%I!!1\t\u0017\u0005\u00157\u00041AA\u0002\u0013%\u0011q\u0019\u0005\f\u0003\u0017\\\u0002\u0019!A!B\u0013\t\u0019\rC\u0004\u0002Nn!\t%a4\t\u000f\u0005U7\u0004\"\u0011\u0002X\"9\u0011q\\\u000e\u0005\n\u0005\u0005\bb\u0002B\u00017\u0011%!1\u0001\u0005\b\u0005\u000fYB\u0011\u0002B\u0005\u0011\u001d\u0011\tb\u0007C\u0005\u0005'AqAa\u0006\u001c\t\u0013\u0011I\u0002C\u0004\u0003\"m!IAa\t\t\u000f\t\u001d2\u0004\"\u0003\u0003*!9!\u0011G\u000e\u0005\n\tM\u0002b\u0002B\u001c7\u0011%!\u0011\b\u0005\b\u0005\u0003ZB\u0011\u0002B\"\u0011\u001d\u0011yf\u0007C!\u0005CB\u0011B!$\u0002\u0003\u0003%\tEa$\t\u0011\tu\u0015!!A\u0005\u0002\rD\u0011Ba(\u0002\u0003\u0003%\tA!)\t\u0013\t\u0015\u0016!!A\u0005B\t\u001d\u0006\"\u0003B[\u0003\u0005\u0005I\u0011\u0001B\\\u0011%\u0011Y,AA\u0001\n\u0003\u0012i\fC\u0005\u0003@\u0006\t\t\u0011\"\u0011\u0003B\"I!1Y\u0001\u0002\u0002\u0013%!QY\u0001\u0012%VtG*\u001a8hi\",enY8eS:<'BA A\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8\u000b\u0005\u0005\u0013\u0015\u0001C2pYVlg.\u0019:\u000b\u0005\r#\u0015!C3yK\u000e,H/[8o\u0015\t)e)A\u0002tc2T!a\u0012%\u0002\u000bM\u0004\u0018M]6\u000b\u0005%S\u0015AB1qC\u000eDWMC\u0001L\u0003\ry'o\u001a\t\u0003\u001b\u0006i\u0011A\u0010\u0002\u0012%VtG*\u001a8hi\",enY8eS:<7#B\u0001Q-fc\u0006CA)U\u001b\u0005\u0011&\"A*\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0013&AB!osJ+g\r\u0005\u0002N/&\u0011\u0001L\u0010\u0002\u0012\u0007>l\u0007O]3tg&|gnU2iK6,\u0007CA)[\u0013\tY&KA\u0004Qe>$Wo\u0019;\u0011\u0005Ek\u0016B\u00010S\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001'\u0002\rQL\b/Z%e+\u0005!\u0007CA)f\u0013\t1'KA\u0002J]R\fq\u0001^=qK&#\u0007%A\u0004f]\u000e|G-\u001a:\u0016\u0007)\f\u0019\tF\u0002l\u0003\u000b\u0003B\u0001\u001c\u0005\u0002\u00026\t\u0011AA\u0004F]\u000e|G-\u001a:\u0016\u0005=$8c\u0001\u0005QaB\u0019Q*\u001d:\n\u00055t\u0004CA:u\u0019\u0001!Q!\u001e\u0005C\u0002Y\u0014\u0011\u0001V\t\u0003oj\u0004\"!\u0015=\n\u0005e\u0014&a\u0002(pi\"Lgn\u001a\t\u0003wzl\u0011\u0001 \u0006\u0003{\u0012\u000bQ\u0001^=qKNL!a ?\u0003\u0015\u0005#x.\\5d)f\u0004X-\u0001\u0006d_2,XN\u001c+za\u0016\u0004R!!\u0002\u0002\bIl\u0011\u0001Q\u0005\u0004\u0003\u0013\u0001%\u0001\u0005(bi&4XmQ8mk6tG+\u001f9f)\u0011\ti!a\u0004\u0011\u00071D!\u000fC\u0004\u0002\u0002)\u0001\r!a\u0001\u0002#}+hnY8naJ,7o]3e'&TX-A\u000b`k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016|F%Z9\u0015\t\u0005]\u0011Q\u0004\t\u0004#\u0006e\u0011bAA\u000e%\n!QK\\5u\u0011!\ty\u0002DA\u0001\u0002\u0004!\u0017a\u0001=%c\u0005\u0011r,\u001e8d_6\u0004(/Z:tK\u0012\u001c\u0016N_3!\u0003=y6m\\7qe\u0016\u001c8/\u001a3TSj,\u0017aE0d_6\u0004(/Z:tK\u0012\u001c\u0016N_3`I\u0015\fH\u0003BA\f\u0003SA\u0001\"a\b\u0010\u0003\u0003\u0005\r\u0001Z\u0001\u0011?\u000e|W\u000e\u001d:fgN,GmU5{K\u0002\n\u0011\u0002\\1tiZ\u000bG.^3\u0016\u0005\u0005E\u0002c\u0001:\u00024%\u0019\u0011Q\u0007@\u0003\u0019%sG/\u001a:oC2$\u0016\u0010]3\u0002\u001b1\f7\u000f\u001e,bYV,w\fJ3r)\u0011\t9\"a\u000f\t\u0013\u0005}!#!AA\u0002\u0005E\u0012A\u00037bgR4\u0016\r\\;fA\u00059A.Y:u%Vt\u0017a\u00037bgR\u0014VO\\0%KF$B!a\u0006\u0002F!A\u0011qD\u000b\u0002\u0002\u0003\u0007A-\u0001\u0005mCN$(+\u001e8!\u0003A)hnY8naJ,7o]3e'&TX-\u0001\bd_6\u0004(/Z:tK\u0012\u001c\u0016N_3\u00025\u001d\fG\u000f[3s\u0007>l\u0007O]3tg&\u0014\u0017\u000e\\5usN#\u0018\r^:\u0015\r\u0005]\u0011\u0011KA1\u0011\u001d\t\u0019&\u0007a\u0001\u0003+\n1A]8x!\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.\t\u0006A1-\u0019;bYf\u001cH/\u0003\u0003\u0002`\u0005e#aC%oi\u0016\u0014h.\u00197S_^Da!a\u0019\u001a\u0001\u0004!\u0017aB8sI&t\u0017\r\\\u0001\tG>l\u0007O]3tgR1\u0011\u0011NA=\u0003{\u0002B!a\u001b\u0002v5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(A\u0002oS>T!!a\u001d\u0002\t)\fg/Y\u0005\u0005\u0003o\niG\u0001\u0006CsR,')\u001e4gKJDq!a\u001f\u001b\u0001\u0004\tI'\u0001\u0003ge>l\u0007bBA@5\u0001\u0007\u0011\u0011N\u0001\u0003i>\u00042a]AB\t\u0015)XA1\u0001w\u0011\u001d\t\t!\u0002a\u0001\u0003\u000f\u0003b!!\u0002\u0002\b\u0005\u0005\u0015a\u00023fG>$WM]\u000b\u0005\u0003\u001b\u0013I\u0007\u0006\u0004\u0002\u0010\n-$Q\u000e\t\u0005Yn\u00119GA\u0004EK\u000e|G-\u001a:\u0016\t\u0005U\u0015QT\n\u00057A\u000b9\nE\u0003N\u00033\u000bY*C\u0002\u0002\u0012z\u00022a]AO\t\u0015)8D1\u0001w\u0003\u0019\u0011WO\u001a4feB1\u0011QAA\u0004\u00037#b!!*\u0002(\u0006%\u0006\u0003\u00027\u001c\u00037Cq!a(\u001f\u0001\u0004\tI\u0007C\u0004\u0002\u0002y\u0001\r!!)\u0002\u0007I,h.A\u0004sk:|F%Z9\u0015\t\u0005]\u0011\u0011\u0017\u0005\t\u0003?\u0001\u0013\u0011!a\u0001I\u0006!!/\u001e8!\u0003)1\u0018\r\\;f\u0007>,h\u000e^\u0001\u000fm\u0006dW/Z\"pk:$x\fJ3r)\u0011\t9\"a/\t\u0011\u0005}1%!AA\u0002\u0011\f1B^1mk\u0016\u001cu.\u001e8uA\u0005a1-\u001e:sK:$h+\u00197vKV\u0011\u00111\u0019\t\u0005\u00037\u000b\u0019$\u0001\tdkJ\u0014XM\u001c;WC2,Xm\u0018\u0013fcR!\u0011qCAe\u0011%\tyBJA\u0001\u0002\u0004\t\u0019-A\u0007dkJ\u0014XM\u001c;WC2,X\rI\u0001\u0005]\u0016DH\u000f\u0006\u0004\u0002\u0018\u0005E\u00171\u001b\u0005\b\u0003'B\u0003\u0019AA+\u0011\u0019\t\u0019\u0007\u000ba\u0001I\u00069\u0001.Y:OKb$XCAAm!\r\t\u00161\\\u0005\u0004\u0003;\u0014&a\u0002\"p_2,\u0017M\\\u0001\u000baV$(i\\8mK\u0006tG\u0003CA\f\u0003G\f\u00190a>\t\u000f\u0005\u0015(\u00061\u0001\u0002h\u0006a1m\u001c7v[:4Vm\u0019;peB!\u0011\u0011^Ax\u001b\t\tYOC\u0002\u0002n\n\u000b!B^3di>\u0014\u0018N_3e\u0013\u0011\t\t0a;\u0003)]\u0013\u0018\u000e^1cY\u0016\u001cu\u000e\\;n]Z+7\r^8s\u0011\u0019\t)P\u000ba\u0001I\u0006\u0019\u0001o\\:\t\u000f\u0005e(\u00061\u0001\u0002|\u0006)a/\u00197vKB\u0019\u0011+!@\n\u0007\u0005}(K\u0001\u0003M_:<\u0017aB4fi\nKH/\u001a\u000b\u0005\u0003w\u0014)\u0001C\u0004\u0002 .\u0002\r!!\u001b\u0002\u000fA,HOQ=uKRA\u0011q\u0003B\u0006\u0005\u001b\u0011y\u0001C\u0004\u0002f2\u0002\r!a:\t\r\u0005UH\u00061\u0001e\u0011\u001d\tI\u0010\fa\u0001\u0003w\f\u0001bZ3u'\"|'\u000f\u001e\u000b\u0005\u0003w\u0014)\u0002C\u0004\u0002 6\u0002\r!!\u001b\u0002\u0011A,Ho\u00155peR$\u0002\"a\u0006\u0003\u001c\tu!q\u0004\u0005\b\u0003Kt\u0003\u0019AAt\u0011\u0019\t)P\fa\u0001I\"9\u0011\u0011 \u0018A\u0002\u0005m\u0018AB4fi&sG\u000f\u0006\u0003\u0002|\n\u0015\u0002bBAP_\u0001\u0007\u0011\u0011N\u0001\u0007aV$\u0018J\u001c;\u0015\u0011\u0005]!1\u0006B\u0017\u0005_Aq!!:1\u0001\u0004\t9\u000f\u0003\u0004\u0002vB\u0002\r\u0001\u001a\u0005\b\u0003s\u0004\u0004\u0019AA~\u0003\u001d9W\r\u001e'p]\u001e$B!a?\u00036!9\u0011qT\u0019A\u0002\u0005%\u0014a\u00029vi2{gn\u001a\u000b\t\u0003/\u0011YD!\u0010\u0003@!9\u0011Q\u001d\u001aA\u0002\u0005\u001d\bBBA{e\u0001\u0007A\rC\u0004\u0002zJ\u0002\r!a?\u0002\u0017\u0011,7m\\7qe\u0016\u001c8\u000f\r\u000b\u000b\u0003/\u0011)Ea\u0012\u0003L\tU\u0003bBAsg\u0001\u0007\u0011q\u001d\u0005\u0007\u0005\u0013\u001a\u0004\u0019\u00013\u0002\u0011\r\f\u0007/Y2jifDqA!\u00144\u0001\u0004\u0011y%A\u0006hKR4UO\\2uS>t\u0007cB)\u0003R\u0005%\u00141`\u0005\u0004\u0005'\u0012&!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\u00119f\ra\u0001\u00053\n1\u0002];u\rVt7\r^5p]BQ\u0011Ka\u0017\u0002h\u0012\fY0a\u0006\n\u0007\tu#KA\u0005Gk:\u001cG/[8og\u0005QA-Z2p[B\u0014Xm]:\u0015\r\u0005]!1\rB3\u0011\u001d\t)\u000f\u000ea\u0001\u0003ODaA!\u00135\u0001\u0004!\u0007cA:\u0003j\u0011)QO\u0002b\u0001m\"9\u0011q\u0014\u0004A\u0002\u0005%\u0004bBA\u0001\r\u0001\u0007!q\u000e\t\u0007\u0003\u000b\t9Aa\u001a\u0002\u0011M,\b\u000f]8siN$B!!7\u0003v!9\u0011\u0011A\u0004A\u0002\t]\u0004\u0007\u0002B=\u0005\u0003\u0003b!!\u0002\u0003|\t}\u0014b\u0001B?\u0001\nQ1i\u001c7v[:$\u0016\u0010]3\u0011\u0007M\u0014\t\t\u0002\u0007\u0003\u0004\nU\u0014\u0011!A\u0001\u0006\u0003\u0011)IA\u0002`II\n2a\u001eBD!\r\t&\u0011R\u0005\u0004\u0005\u0017\u0013&aA!os\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"A!%\u0011\t\tM%\u0011T\u0007\u0003\u0005+SAAa&\u0002r\u0005!A.\u00198h\u0013\u0011\u0011YJ!&\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\"\u0003$\"A\u0011qD\u001c\u0002\u0002\u0003\u0007A-A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\u000b\u0005\u0004\u0003,\nE&qQ\u0007\u0003\u0005[S1Aa,S\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005g\u0013iK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAm\u0005sC\u0011\"a\b:\u0003\u0003\u0005\rAa\"\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001Z\u0001\ti>\u001cFO]5oOR\u0011!\u0011S\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003HB!!1\u0013Be\u0013\u0011\u0011YM!&\u0003\r=\u0013'.Z2u\u0001")
public final class RunLengthEncoding {
    public static String toString() {
        return RunLengthEncoding$.MODULE$.toString();
    }

    public static int hashCode() {
        return RunLengthEncoding$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return RunLengthEncoding$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return RunLengthEncoding$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return RunLengthEncoding$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return RunLengthEncoding$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return RunLengthEncoding$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return RunLengthEncoding$.MODULE$.supports(columnType);
    }

    public static <T extends AtomicType> Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return RunLengthEncoding$.MODULE$.decoder(byteBuffer, (NativeColumnType)nativeColumnType);
    }

    public static <T extends AtomicType> Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return RunLengthEncoding$.MODULE$.encoder((NativeColumnType)nativeColumnType);
    }

    public static int typeId() {
        return RunLengthEncoding$.MODULE$.typeId();
    }

    public static class Decoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<T> {
        private final ByteBuffer buffer;
        private final NativeColumnType<T> columnType;
        private int run;
        private int valueCount;
        private Object currentValue;

        private int run() {
            return this.run;
        }

        private void run_$eq(int x$1) {
            this.run = x$1;
        }

        private int valueCount() {
            return this.valueCount;
        }

        private void valueCount_$eq(int x$1) {
            this.valueCount = x$1;
        }

        private Object currentValue() {
            return this.currentValue;
        }

        private void currentValue_$eq(Object x$1) {
            this.currentValue = x$1;
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            if (this.valueCount() == this.run()) {
                this.currentValue_$eq(this.columnType.extract(this.buffer));
                this.run_$eq(ByteBufferHelper$.MODULE$.getInt(this.buffer));
                this.valueCount_$eq(1);
            } else {
                this.valueCount_$eq(this.valueCount() + 1);
            }
            this.columnType.setField(row, ordinal, this.currentValue());
        }

        @Override
        public boolean hasNext() {
            return this.valueCount() < this.run() || this.buffer.hasRemaining();
        }

        private void putBoolean(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putBoolean(pos, value == 1L);
        }

        private long getByte(ByteBuffer buffer) {
            return buffer.get();
        }

        private void putByte(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putByte(pos, (byte)value);
        }

        private long getShort(ByteBuffer buffer) {
            return buffer.getShort();
        }

        private void putShort(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putShort(pos, (short)value);
        }

        private long getInt(ByteBuffer buffer) {
            return buffer.getInt();
        }

        private void putInt(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putInt(pos, (int)value);
        }

        private long getLong(ByteBuffer buffer) {
            return buffer.getLong();
        }

        private void putLong(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putLong(pos, value);
        }

        private void decompress0(WritableColumnVector columnVector, int capacity, Function1<ByteBuffer, Object> getFunction, Function3<WritableColumnVector, Object, Object, BoxedUnit> putFunction) {
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            int runLocal = 0;
            int valueCountLocal = 0;
            long currentValueLocal = 0L;
            for (int pos = 0; pos < capacity; ++pos) {
                Object object;
                Predef$.MODULE$.assert(valueCountLocal <= runLocal);
                if (pos != nextNullIndex) {
                    if (valueCountLocal == runLocal) {
                        currentValueLocal = BoxesRunTime.unboxToLong((Object)getFunction.apply((Object)this.buffer));
                        runLocal = ByteBufferHelper$.MODULE$.getInt(this.buffer);
                        valueCountLocal = 1;
                    } else {
                        ++valueCountLocal;
                    }
                    object = putFunction.apply((Object)columnVector, (Object)BoxesRunTime.boxToInteger((int)pos), (Object)BoxesRunTime.boxToLong((long)currentValueLocal));
                    continue;
                }
                if (++seenNulls < nullCount) {
                    nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                }
                columnVector.putNull(pos);
                object = BoxedUnit.UNIT;
            }
        }

        @Override
        public void decompress(WritableColumnVector columnVector2, int capacity) {
            T t = this.columnType.dataType();
            if (t instanceof BooleanType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getByte(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putBoolean(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (t instanceof ByteType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getByte(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putByte(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (t instanceof ShortType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getShort(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putShort(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (t instanceof IntegerType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getInt(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putInt(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (t instanceof LongType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getLong(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putLong(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new IllegalStateException("Not supported type in RunLengthEncoding.");
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<T> columnType) {
            this.buffer = buffer;
            this.columnType = columnType;
            this.run = 0;
            this.valueCount = 0;
        }
    }

    public static class Encoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<T> {
        private final NativeColumnType<T> columnType;
        private int _uncompressedSize;
        private int _compressedSize;
        private Object lastValue;
        private int lastRun;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        private int _uncompressedSize() {
            return this._uncompressedSize;
        }

        private void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        private int _compressedSize() {
            return this._compressedSize;
        }

        private void _compressedSize_$eq(int x$1) {
            this._compressedSize = x$1;
        }

        private Object lastValue() {
            return this.lastValue;
        }

        private void lastValue_$eq(Object x$1) {
            this.lastValue = x$1;
        }

        private int lastRun() {
            return this.lastRun;
        }

        private void lastRun_$eq(int x$1) {
            this.lastRun = x$1;
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        @Override
        public int compressedSize() {
            return this._compressedSize();
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            Object value = this.columnType.getField(row, ordinal);
            int actualSize = this.columnType.actualSize(row, ordinal);
            this._uncompressedSize_$eq(this._uncompressedSize() + actualSize);
            if (this.lastValue() == null) {
                this.lastValue_$eq(this.columnType.clone(value));
                this.lastRun_$eq(1);
                this._compressedSize_$eq(this._compressedSize() + (actualSize + 4));
                return;
            }
            if (BoxesRunTime.equals((Object)this.lastValue(), value)) {
                this.lastRun_$eq(this.lastRun() + 1);
                return;
            }
            this._compressedSize_$eq(this._compressedSize() + (actualSize + 4));
            this.lastValue_$eq(this.columnType.clone(value));
            this.lastRun_$eq(1);
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            Object object;
            to.putInt(RunLengthEncoding$.MODULE$.typeId());
            if (from.hasRemaining()) {
                int currentRun = 1;
                Object currentValue = this.columnType.extract(from);
                while (from.hasRemaining()) {
                    Object value = this.columnType.extract(from);
                    if (BoxesRunTime.equals(value, currentValue)) {
                        ++currentRun;
                        continue;
                    }
                    this.columnType.append(currentValue, to);
                    to.putInt(currentRun);
                    currentValue = value;
                    currentRun = 1;
                }
                this.columnType.append(currentValue, to);
                object = to.putInt(currentRun);
            } else {
                object = BoxedUnit.UNIT;
            }
            to.rewind();
            return to;
        }

        public Encoder(NativeColumnType<T> columnType) {
            this.columnType = columnType;
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._uncompressedSize = 0;
            this._compressedSize = 0;
            this.lastRun = 0;
        }
    }
}

