/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.annotation.Stable;
import org.apache.spark.api.python.PythonEvalType$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.KeyValueGroupedDataset;
import org.apache.spark.sql.RelationalGroupedDataset$;
import org.apache.spark.sql.RelationalGroupedDataset$CubeType$;
import org.apache.spark.sql.RelationalGroupedDataset$GroupByType$;
import org.apache.spark.sql.RelationalGroupedDataset$RollupType$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.sql.catalyst.analysis.Star;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cube$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PythonUDF;
import org.apache.spark.sql.catalyst.expressions.Rollup$;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapCoGroupsInPandas;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapGroupsInPandas;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapGroupsInPandasWithState;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapGroupsInR$;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Pivot;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.streaming.InternalOutputModes$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.aggregate.TypedAggregateExpression;
import org.apache.spark.sql.execution.streaming.GroupStateImpl$;
import org.apache.spark.sql.streaming.GroupStateTimeout;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Stable
@ScalaSignature(bytes="\u0006\u0001\r=f\u0001\u0002%J\u0001IC\u0011\"\u0017\u0001\u0003\u0006\u0004%\t!\u0013.\t\u0011\r\u0004!\u0011!Q\u0001\nmC\u0011\u0002\u001a\u0001\u0003\u0006\u0004%\t!S3\t\u0011e\u0004!\u0011!Q\u0001\n\u0019D\u0001B\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001f\u0005\t\u0003\u0003\u0001A\u0011C%\u0003(!A!q\u0006\u0001!\n\u0013\u0011\t\u0004\u0003\u0005\u00038\u0001\u0001K\u0011\u0002B\u001d\u0011!\u0011)\u0005\u0001Q\u0005\n\t\u001d\u0003\u0002\u0003B6\u0001\u0001&IA!\u001c\t\u000f\tM\u0004\u0001\"\u0001\u0003v!9!Q\u0015\u0001\u0005\u0002\t\u001d\u0006b\u0002BS\u0001\u0011\u0005!1\u0017\u0005\b\u0005K\u0003A\u0011\u0001B`\u0011\u001d\u0011)\u000b\u0001C\u0001\u0005\u001bDqA!:\u0001\t\u0003\u00119\u000fC\u0004\u0003j\u0002!\tAa;\t\u000f\tE\b\u0001\"\u0001\u0003t\"9!\u0011 \u0001\u0005\u0002\tm\bbBB\u0001\u0001\u0011\u000511\u0001\u0005\b\u0007\u0013\u0001A\u0011AB\u0006\u0011\u001d\u0019\t\u0002\u0001C\u0001\u0007'Aqa!\u0005\u0001\t\u0003\u0019I\u0002C\u0004\u0004\u0012\u0001!\ta!\t\t\u000f\rE\u0001\u0001\"\u0001\u0004.!91\u0011\u0003\u0001\u0005\u0002\rE\u0002bBB\t\u0001\u0011\u00051q\u0007\u0005\t\u0007{\u0001A\u0011A%\u0004@!A1Q\u000f\u0001\u0005\u0002%\u001b9\b\u0003\u0005\u0004\u0002\u0002!\t!SBB\u0011!\u0019Y\t\u0001C\u0001\u0013\u000e5\u0005bBA\u0012\u0001\u0011\u0005\u0013QE\u0004\u0007{&C\t!\u0013@\u0007\r!K\u0005\u0012A%\u0000\u0011\u001d\t\tA\tC\u0001\u0003\u0007Aq!!\u0002#\t\u0003\t9A\u0002\u0006\u0002\u0016\t\u0002\n1!\u0001J\u0003/Aq!!\u0007&\t\u0003\tY\u0002C\u0004\u0002$\u0015\"\t%!\n\b\u0011\u0005]\"\u0005#\u0001J\u0003s1\u0001\"a\u000f#\u0011\u0003I\u0015Q\b\u0005\b\u0003\u0003IC\u0011AA \u000f!\t\tE\tE\u0001\u0013\u0006\rc\u0001CA#E!\u0005\u0011*a\u0012\t\u000f\u0005\u0005A\u0006\"\u0001\u0002J\u001dA\u00111\n\u0012\t\u0002%\u000biE\u0002\u0005\u0002P\tB\t!SA)\u0011\u001d\t\ta\fC\u0001\u0003'2q!!\u0016#\u0001&\u000b9\u0006\u0003\u0006\u0002fE\u0012)\u001a!C\u0001\u0003OB\u0011\"!\u001b2\u0005#\u0005\u000b\u0011B9\t\u0013\u0005-\u0014G!f\u0001\n\u0003)\u0007\"CA7c\tE\t\u0015!\u0003g\u0011\u001d\t\t!\rC\u0001\u0003_B\u0011\"a\u001e2\u0003\u0003%\t!!\u001f\t\u0013\u0005}\u0014'%A\u0005\u0002\u0005\u0005\u0005\"CALcE\u0005I\u0011AAM\u0011%\ti*MA\u0001\n\u0003\ny\nC\u0005\u00020F\n\t\u0011\"\u0001\u00022\"I\u0011\u0011X\u0019\u0002\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003\u000f\f\u0014\u0011!C!\u0003\u0013D\u0011\"a62\u0003\u0003%\t!!7\t\u0013\u0005\r\u0018'!A\u0005B\u0005\u0015\b\"CAtc\u0005\u0005I\u0011IAu\u000f)\tiOIA\u0001\u0012\u0003I\u0015q\u001e\u0004\u000b\u0003+\u0012\u0013\u0011!E\u0001\u0013\u0006E\bbBA\u0001\u0005\u0012\u0005\u0011q \u0005\n\u0003G\u0011\u0015\u0011!C#\u0005\u0003A\u0011\"!\u0002C\u0003\u0003%\tIa\u0001\t\u0013\t%!)!A\u0005\u0002\n-\u0001\"\u0003B\u000f\u0005\u0006\u0005I\u0011\u0002B\u0010\u0005a\u0011V\r\\1uS>t\u0017\r\\$s_V\u0004X\r\u001a#bi\u0006\u001cX\r\u001e\u0006\u0003\u0015.\u000b1a]9m\u0015\taU*A\u0003ta\u0006\u00148N\u0003\u0002O\u001f\u00061\u0011\r]1dQ\u0016T\u0011\u0001U\u0001\u0004_J<7\u0001A\n\u0003\u0001M\u0003\"\u0001V,\u000e\u0003US\u0011AV\u0001\u0006g\u000e\fG.Y\u0005\u00031V\u0013a!\u00118z%\u00164\u0017A\u00013g+\u0005Y\u0006C\u0001/a\u001d\tif,D\u0001J\u0013\ty\u0016*A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0005\u0014'!\u0003#bi\u00064%/Y7f\u0015\ty\u0016*A\u0002eM\u0002\nQb\u001a:pkBLgnZ#yaJ\u001cX#\u00014\u0011\u0007\u001dt\u0017O\u0004\u0002i[:\u0011\u0011\u000e\\\u0007\u0002U*\u00111.U\u0001\u0007yI|w\u000e\u001e \n\u0003YK!aX+\n\u0005=\u0004(aA*fc*\u0011q,\u0016\t\u0003e^l\u0011a\u001d\u0006\u0003iV\f1\"\u001a=qe\u0016\u001c8/[8og*\u0011a/S\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0001p\u001d\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AD4s_V\u0004\u0018N\\4FqB\u00148\u000fI\u0001\nOJ|W\u000f\u001d+za\u0016\u0004\"\u0001`\u0013\u000f\u0005u\u000b\u0013\u0001\u0007*fY\u0006$\u0018n\u001c8bY\u001e\u0013x.\u001e9fI\u0012\u000bG/Y:fiB\u0011QLI\n\u0003EM\u000ba\u0001P5oSRtD#\u0001@\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\u0005%\u00111BA\u0007\u0003\u001f\u0001\"!\u0018\u0001\t\u000be#\u0003\u0019A.\t\u000b\u0011$\u0003\u0019\u00014\t\ri$\u0003\u0019AA\t!\r\t\u0019\"J\u0007\u0002E\tIqI]8vaRK\b/Z\n\u0003KM\u000ba\u0001J5oSR$CCAA\u000f!\r!\u0016qD\u0005\u0004\u0003C)&\u0001B+oSR\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003O\u0001B!!\u000b\u000229!\u00111FA\u0017!\tIW+C\u0002\u00020U\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u001a\u0003k\u0011aa\u0015;sS:<'bAA\u0018+\u0006YqI]8va\nKH+\u001f9f!\r\t\u0019\"\u000b\u0002\f\u000fJ|W\u000f\u001d\"z)f\u0004Xm\u0005\u0003*'\u0006EACAA\u001d\u0003!\u0019UOY3UsB,\u0007cAA\nY\tA1)\u001e2f)f\u0004Xm\u0005\u0003-'\u0006EACAA\"\u0003)\u0011v\u000e\u001c7vaRK\b/\u001a\t\u0004\u0003'y#A\u0003*pY2,\b\u000fV=qKN!qfUA\t)\t\tiEA\u0005QSZ|G\u000fV=qKNA\u0011gUA\t\u00033\ny\u0006E\u0002U\u00037J1!!\u0018V\u0005\u001d\u0001&o\u001c3vGR\u00042\u0001VA1\u0013\r\t\u0019'\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\ta&4x\u000e^\"pYV\t\u0011/A\u0005qSZ|GoQ8mA\u00051a/\u00197vKN\fqA^1mk\u0016\u001c\b\u0005\u0006\u0004\u0002r\u0005M\u0014Q\u000f\t\u0004\u0003'\t\u0004BBA3m\u0001\u0007\u0011\u000f\u0003\u0004\u0002lY\u0002\rAZ\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002r\u0005m\u0014Q\u0010\u0005\t\u0003K:\u0004\u0013!a\u0001c\"A\u00111N\u001c\u0011\u0002\u0003\u0007a-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\r%fA9\u0002\u0006.\u0012\u0011q\u0011\t\u0005\u0003\u0013\u000b\u0019*\u0004\u0002\u0002\f*!\u0011QRAH\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0012V\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t)*a#\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m%f\u00014\u0002\u0006\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!)\u0011\t\u0005\r\u0016QV\u0007\u0003\u0003KSA!a*\u0002*\u0006!A.\u00198h\u0015\t\tY+\u0001\u0003kCZ\f\u0017\u0002BA\u001a\u0003K\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a-\u0011\u0007Q\u000b),C\u0002\u00028V\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!0\u0002DB\u0019A+a0\n\u0007\u0005\u0005WKA\u0002B]fD\u0011\"!2=\u0003\u0003\u0005\r!a-\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\r\u0005\u0004\u0002N\u0006M\u0017QX\u0007\u0003\u0003\u001fT1!!5V\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003+\fyM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAn\u0003C\u00042\u0001VAo\u0013\r\ty.\u0016\u0002\b\u0005>|G.Z1o\u0011%\t)MPA\u0001\u0002\u0004\ti,\u0001\u0005iCND7i\u001c3f)\t\t\u0019,\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00037\fY\u000fC\u0005\u0002F\u0002\u000b\t\u00111\u0001\u0002>\u0006I\u0001+\u001b<piRK\b/\u001a\t\u0004\u0003'\u00115#\u0002\"\u0002t\u0006}\u0003\u0003CA{\u0003w\fh-!\u001d\u000e\u0005\u0005](bAA}+\u00069!/\u001e8uS6,\u0017\u0002BA\u007f\u0003o\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\ty\u000f\u0006\u0002\u0002\"R1\u0011\u0011\u000fB\u0003\u0005\u000fAa!!\u001aF\u0001\u0004\t\bBBA6\u000b\u0002\u0007a-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t5!\u0011\u0004\t\u0006)\n=!1C\u0005\u0004\u0005#)&AB(qi&|g\u000eE\u0003U\u0005+\th-C\u0002\u0003\u0018U\u0013a\u0001V;qY\u0016\u0014\u0004\"\u0003B\u000e\r\u0006\u0005\t\u0019AA9\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\"A!\u00111\u0015B\u0012\u0013\u0011\u0011)#!*\u0003\r=\u0013'.Z2u)!\tIA!\u000b\u0003,\t5\u0002\"B-\u0007\u0001\u0004Y\u0006\"\u00023\u0007\u0001\u00041\u0007\"\u0002>\u0007\u0001\u0004Y\u0018\u0001\u0002;p\t\u001a#2a\u0017B\u001a\u0011\u0019\u0011)d\u0002a\u0001M\u0006A\u0011mZ4FqB\u00148/A\u0003bY&\f7\u000f\u0006\u0003\u0003<\t\u0005\u0003c\u0001:\u0003>%\u0019!qH:\u0003\u001f9\u000bW.\u001a3FqB\u0014Xm]:j_:DaAa\u0011\t\u0001\u0004\t\u0018\u0001B3yaJ\fq#Y4he\u0016<\u0017\r^3Ok6,'/[2D_2,XN\\:\u0015\t\t%#\u0011\r\u000b\u00047\n-\u0003b\u0002B'\u0013\u0001\u0007!qJ\u0001\u0002MB1AK!\u0015r\u0005+J1Aa\u0015V\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0003X\tuSB\u0001B-\u0015\r\u0011Yf]\u0001\nC\u001e<'/Z4bi\u0016LAAa\u0018\u0003Z\t\t\u0012iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8\t\u000f\t\r\u0014\u00021\u0001\u0003f\u0005A1m\u001c7OC6,7\u000fE\u0003U\u0005O\n9#C\u0002\u0003jU\u0013!\u0002\u0010:fa\u0016\fG/\u001a3?\u0003%\u0019HO\u001d+p\u000bb\u0004(\u000f\u0006\u0003\u0003p\tE\u0004#\u0002+\u0003RE\f\bb\u0002B\"\u0015\u0001\u0007\u0011qE\u0001\u0003CN,bAa\u001e\u0003\u0004\nEEC\u0002B=\u0005+\u0013y\nE\u0004^\u0005w\u0012yHa$\n\u0007\tu\u0014J\u0001\fLKf4\u0016\r\\;f\u000fJ|W\u000f]3e\t\u0006$\u0018m]3u!\u0011\u0011\tIa!\r\u0001\u00119!QQ\u0006C\u0002\t\u001d%!A&\u0012\t\t%\u0015Q\u0018\t\u0004)\n-\u0015b\u0001BG+\n9aj\u001c;iS:<\u0007\u0003\u0002BA\u0005##qAa%\f\u0005\u0004\u00119IA\u0001U\u0011%\u00119jCA\u0001\u0002\b\u0011I*\u0001\u0006fm&$WM\\2fIE\u0002R!\u0018BN\u0005\u007fJ1A!(J\u0005\u001d)enY8eKJD\u0011B!)\f\u0003\u0003\u0005\u001dAa)\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007E\u0003^\u00057\u0013y)A\u0002bO\u001e$Ra\u0017BU\u0005_CqAa+\r\u0001\u0004\u0011i+A\u0004bO\u001e,\u0005\u0010\u001d:\u0011\u000fQ\u0013)\"a\n\u0002(!9!Q\u0007\u0007A\u0002\tE\u0006#\u0002+\u0003h\t5FcA.\u00036\"9!qW\u0007A\u0002\te\u0016!B3yaJ\u001c\b\u0003CA\u0015\u0005w\u000b9#a\n\n\t\tu\u0016Q\u0007\u0002\u0004\u001b\u0006\u0004HcA.\u0003B\"9!q\u0017\bA\u0002\t\r\u0007\u0003\u0003Bc\u0005\u0017\f9#a\n\u000e\u0005\t\u001d'\u0002\u0002Be\u0003S\u000bA!\u001e;jY&!!Q\u0018Bd)\u0015Y&q\u001aBl\u0011\u001d\u0011\u0019e\u0004a\u0001\u0005#\u00042!\u0018Bj\u0013\r\u0011).\u0013\u0002\u0007\u0007>dW/\u001c8\t\u000f\t]v\u00021\u0001\u0003ZB)AKa\u001a\u0003R\"\u001aqB!8\u0011\t\t}'\u0011]\u0007\u0003\u0003\u001fKAAa9\u0002\u0010\n9a/\u0019:be\u001e\u001c\u0018!B2pk:$H#A.\u0002\t5,\u0017M\u001c\u000b\u00047\n5\bb\u0002B2#\u0001\u0007!Q\r\u0015\u0004#\tu\u0017aA7bqR\u00191L!>\t\u000f\t\r$\u00031\u0001\u0003f!\u001a!C!8\u0002\u0007\u00054x\rF\u0002\\\u0005{DqAa\u0019\u0014\u0001\u0004\u0011)\u0007K\u0002\u0014\u0005;\f1!\\5o)\rY6Q\u0001\u0005\b\u0005G\"\u0002\u0019\u0001B3Q\r!\"Q\\\u0001\u0004gVlGcA.\u0004\u000e!9!1M\u000bA\u0002\t\u0015\u0004fA\u000b\u0003^\u0006)\u0001/\u001b<piR!\u0011\u0011BB\u000b\u0011\u001d\u00199B\u0006a\u0001\u0003O\t1\u0002]5w_R\u001cu\u000e\\;n]R1\u0011\u0011BB\u000e\u0007;Aqaa\u0006\u0018\u0001\u0004\t9\u0003C\u0004\u0002l]\u0001\raa\b\u0011\t\u001dt\u0017Q\u0018\u000b\u0007\u0003\u0013\u0019\u0019c!\n\t\u000f\r]\u0001\u00041\u0001\u0002(!9\u00111\u000e\rA\u0002\r\u001d\u0002C\u0002Bc\u0007S\ti,\u0003\u0003\u0004,\t\u001d'\u0001\u0002'jgR$B!!\u0003\u00040!91qC\rA\u0002\tEGCBA\u0005\u0007g\u0019)\u0004C\u0004\u0004\u0018i\u0001\rA!5\t\u000f\u0005-$\u00041\u0001\u0004 Q1\u0011\u0011BB\u001d\u0007wAqaa\u0006\u001c\u0001\u0004\u0011\t\u000eC\u0004\u0002lm\u0001\raa\n\u0002!\u0019d\u0017\r^'ba\u001e\u0013x.\u001e9t\u0013:\u0014F#C.\u0004B\r=31KB3\u0011\u001d\u0011i\u0005\ba\u0001\u0007\u0007\u0002R\u0001VB#\u0007\u0013J1aa\u0012V\u0005\u0015\t%O]1z!\r!61J\u0005\u0004\u0007\u001b*&\u0001\u0002\"zi\u0016Dqa!\u0015\u001d\u0001\u0004\u0019\u0019%\u0001\u0007qC\u000e\\\u0017mZ3OC6,7\u000fC\u0004\u0004Vq\u0001\raa\u0016\u0002\u001b\t\u0014x.\u00193dCN$h+\u0019:t!\u0015!6QIB-!\u0019\u0019Yf!\u0019\u0003\"5\u00111Q\f\u0006\u0004\u0007?Z\u0015!\u00032s_\u0006$7-Y:u\u0013\u0011\u0019\u0019g!\u0018\u0003\u0013\t\u0013x.\u00193dCN$\bbBB49\u0001\u00071\u0011N\u0001\r_V$\b/\u001e;TG\",W.\u0019\t\u0005\u0007W\u001a\t(\u0004\u0002\u0004n)\u00191qN%\u0002\u000bQL\b/Z:\n\t\rM4Q\u000e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017!\u00064mCRl\u0015\r]$s_V\u00048/\u00138QC:$\u0017m\u001d\u000b\u00047\u000ee\u0004b\u0002B\";\u0001\u000711\u0010\t\u0004e\u000eu\u0014bAB@g\nI\u0001+\u001f;i_:,FIR\u0001\u0018M2\fG/T1q\u0007><%o\\;qg&s\u0007+\u00198eCN$RaWBC\u0007\u0013Cqaa\"\u001f\u0001\u0004\tI!A\u0001s\u0011\u001d\u0011\u0019E\ba\u0001\u0007w\na#\u00199qYfLe\u000eU1oI\u0006\u001cx+\u001b;i'R\fG/\u001a\u000b\f7\u000e=51SBL\u00077\u001by\nC\u0004\u0004\u0012~\u0001\raa\u001f\u0002\t\u0019,hn\u0019\u0005\b\u0007+{\u0002\u0019AB5\u0003AyW\u000f\u001e9viN#(/^2u)f\u0004X\rC\u0004\u0004\u001a~\u0001\ra!\u001b\u0002\u001fM$\u0018\r^3TiJ,8\r\u001e+za\u0016Dqa!( \u0001\u0004\t9#A\u0007pkR\u0004X\u000f^'pI\u0016\u001cFO\u001d\u0005\b\u0007C{\u0002\u0019AA\u0014\u00039!\u0018.\\3pkR\u001cuN\u001c4TiJD3\u0001ABS!\u0011\u00199ka+\u000e\u0005\r%&bAAI\u0017&!1QVBU\u0005\u0019\u0019F/\u00192mK\u0002")
public class RelationalGroupedDataset {
    private final Dataset<Row> df;
    private final Seq<Expression> groupingExprs;
    private final GroupType groupType;

    public static RelationalGroupedDataset apply(Dataset<Row> dataset, Seq<Expression> seq, GroupType groupType) {
        return RelationalGroupedDataset$.MODULE$.apply(dataset, seq, groupType);
    }

    public Dataset<Row> agg(Column expr, Column ... exprs) {
        return this.agg(expr, (Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])exprs));
    }

    public Dataset<Row> mean(String ... colNames) {
        return this.mean((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> max(String ... colNames) {
        return this.max((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> avg(String ... colNames) {
        return this.avg((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> min(String ... colNames) {
        return this.min((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> sum(String ... colNames) {
        return this.sum((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> df() {
        return this.df;
    }

    public Seq<Expression> groupingExprs() {
        return this.groupingExprs;
    }

    private Dataset<Row> toDF(Seq<Expression> aggExprs) {
        Seq seq;
        if (this.df().sparkSession().sessionState().conf().dataFrameRetainGroupColumns()) {
            Seq<Expression> seq2 = this.groupingExprs();
            if (seq2 instanceof Stream) {
                Stream stream = (Stream)seq2;
                seq = (Seq)stream.toList().$plus$plus((GenTraversableOnce)aggExprs, List$.MODULE$.canBuildFrom());
            } else {
                seq = (Seq)seq2.$plus$plus(aggExprs, Seq$.MODULE$.canBuildFrom());
            }
        } else {
            seq = aggExprs;
        }
        Seq aggregates = seq;
        Seq aliasedAgg = (Seq)aggregates.map((Function1 & Serializable & scala.Serializable)expr -> this.alias((Expression)expr), Seq$.MODULE$.canBuildFrom());
        GroupType groupType = this.groupType;
        if (RelationalGroupedDataset$GroupByType$.MODULE$.equals(groupType)) {
            return Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)new Aggregate(this.groupingExprs(), aliasedAgg, this.df().logicalPlan()));
        }
        if (RelationalGroupedDataset$RollupType$.MODULE$.equals(groupType)) {
            return Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)new Aggregate((Seq)new .colon.colon((Object)Rollup$.MODULE$.apply((Seq)this.groupingExprs().map((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)new .colon.colon(x$1, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$), aliasedAgg, this.df().logicalPlan()));
        }
        if (RelationalGroupedDataset$CubeType$.MODULE$.equals(groupType)) {
            return Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)new Aggregate((Seq)new .colon.colon((Object)Cube$.MODULE$.apply((Seq)this.groupingExprs().map((Function1 & Serializable & scala.Serializable)x$2 -> (Seq)new .colon.colon(x$2, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$), aliasedAgg, this.df().logicalPlan()));
        }
        if (groupType instanceof PivotType) {
            PivotType pivotType = (PivotType)groupType;
            Expression pivotCol = pivotType.pivotCol();
            Seq<Expression> values = pivotType.values();
            Seq aliasedGrps = (Seq)this.groupingExprs().map((Function1 & Serializable & scala.Serializable)expr -> this.alias((Expression)expr), Seq$.MODULE$.canBuildFrom());
            return Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)new Pivot((Option)new Some((Object)aliasedGrps), pivotCol, values, aggExprs, this.df().logicalPlan()));
        }
        throw new MatchError((Object)groupType);
    }

    private NamedExpression alias(Expression expr) {
        AggregateExpression aggregateExpression;
        Expression expression = expr;
        if (expression instanceof NamedExpression) {
            NamedExpression namedExpression = (NamedExpression)expression;
            return namedExpression;
        }
        if (expression instanceof AggregateExpression && (aggregateExpression = (AggregateExpression)expression).aggregateFunction() instanceof TypedAggregateExpression) {
            return new UnresolvedAlias((Expression)aggregateExpression, (Option)new Some((Function1 & Serializable & scala.Serializable)e -> Column$.MODULE$.generateAlias((Expression)e)));
        }
        if (expression != null) {
            Expression expression2;
            Expression x$1 = expression2 = expression;
            String x$2 = package$.MODULE$.toPrettySQL(expression2);
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            Seq x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            return new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
        }
        throw new MatchError((Object)expression);
    }

    private Dataset<Row> aggregateNumericColumns(Seq<String> colNames, Function1<Expression, AggregateFunction> f) {
        Seq columnExprs = colNames.isEmpty() ? this.df().numericColumns() : (Seq)colNames.map((Function1 & Serializable & scala.Serializable)colName -> {
            NamedExpression namedExpr = this.df().resolve((String)colName);
            if (!(((Expression)namedExpr).dataType() instanceof NumericType)) {
                throw QueryCompilationErrors$.MODULE$.aggregationFunctionAppliedOnNonNumericColumnError(colName);
            }
            return namedExpr;
        }, Seq$.MODULE$.canBuildFrom());
        return this.toDF((Seq<Expression>)((Seq)columnExprs.map((Function1 & Serializable & scala.Serializable)expr -> ((AggregateFunction)f.apply(expr)).toAggregateExpression(), Seq$.MODULE$.canBuildFrom())));
    }

    private Function1<Expression, Expression> strToExpr(String expr) {
        Function1 & Serializable & scala.Serializable exprToFunc = (Function1 & Serializable & scala.Serializable)inputExpr -> {
            String string = expr.toLowerCase(Locale.ROOT);
            if ("avg".equals(string) ? true : ("average".equals(string) ? true : "mean".equals(string))) {
                Expression expression = inputExpr;
                return UnresolvedFunction$.MODULE$.apply("avg", (Seq)Nil$.MODULE$.$colon$colon((Object)expression), false);
            }
            if ("stddev".equals(string) ? true : "std".equals(string)) {
                Expression expression = inputExpr;
                return UnresolvedFunction$.MODULE$.apply("stddev", (Seq)Nil$.MODULE$.$colon$colon((Object)expression), false);
            }
            if ("count".equals(string) ? true : "size".equals(string)) {
                Expression expression = inputExpr;
                if (expression instanceof Star) {
                    return Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).toAggregateExpression();
                }
                return Count$.MODULE$.apply(inputExpr).toAggregateExpression();
            }
            Expression expression = inputExpr;
            return UnresolvedFunction$.MODULE$.apply(string, (Seq)Nil$.MODULE$.$colon$colon((Object)expression), false);
        };
        return (Function1 & Serializable & scala.Serializable)inputExpr -> (Expression)exprToFunc.apply(inputExpr);
    }

    public <K, T> KeyValueGroupedDataset<K, T> as(Encoder<K> evidence$1, Encoder<T> evidence$2) {
        ExpressionEncoder keyEncoder = org.apache.spark.sql.catalyst.encoders.package$.MODULE$.encoderFor(evidence$1);
        ExpressionEncoder valueEncoder = org.apache.spark.sql.catalyst.encoders.package$.MODULE$.encoderFor(evidence$2);
        Project dummyPlan = new Project((Seq)this.groupingExprs().map((Function1 & Serializable & scala.Serializable)expr -> this.alias((Expression)expr), Seq$.MODULE$.canBuildFrom()), (LogicalPlan)new LocalRelation(this.df().logicalPlan().output(), LocalRelation$.MODULE$.apply$default$2(), LocalRelation$.MODULE$.apply$default$3()));
        Project analyzedPlan = (Project)this.df().sparkSession().sessionState().analyzer().execute((LogicalPlan)dummyPlan);
        this.df().sparkSession().sessionState().analyzer().checkAnalysis((LogicalPlan)analyzedPlan);
        Seq aliasedGroupings = analyzedPlan.projectList();
        Seq addedCols = (Seq)aliasedGroupings.filter((Function1 & Serializable & scala.Serializable)g -> BoxesRunTime.boxToBoolean((boolean)RelationalGroupedDataset.$anonfun$as$2(this, g)));
        QueryExecution qe = Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)new Project((Seq)this.df().logicalPlan().output().$plus$plus((GenTraversableOnce)addedCols, Seq$.MODULE$.canBuildFrom()), this.df().logicalPlan())).queryExecution();
        return new KeyValueGroupedDataset(keyEncoder, valueEncoder, qe, (Seq<Attribute>)this.df().logicalPlan().output(), (Seq<Attribute>)((Seq)aliasedGroupings.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toAttribute(), Seq$.MODULE$.canBuildFrom())));
    }

    public Dataset<Row> agg(Tuple2<String, String> aggExpr, Seq<Tuple2<String, String>> aggExprs) {
        Tuple2<String, String> tuple2 = aggExpr;
        return this.toDF((Seq<Expression>)((Seq)((TraversableLike)aggExprs.$plus$colon(tuple2, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String colName = (String)tuple2._1();
                String expr = (String)tuple2._2();
                return (Expression)this.strToExpr(expr).apply((Object)this.df().apply(colName).expr());
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public Dataset<Row> agg(scala.collection.immutable.Map<String, String> exprs) {
        return this.toDF((Seq<Expression>)((TraversableOnce)exprs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String colName = (String)tuple2._1();
                String expr = (String)tuple2._2();
                return (Expression)this.strToExpr(expr).apply((Object)this.df().apply(colName).expr());
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq());
    }

    public Dataset<Row> agg(Map<String, String> exprs) {
        return this.agg((scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(exprs).asScala()).toMap(Predef$.MODULE$.$conforms()));
    }

    public Dataset<Row> agg(Column expr, Seq<Column> exprs) {
        Column column = expr;
        return this.toDF((Seq<Expression>)((Seq)((TraversableLike)exprs.$plus$colon((Object)column, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Column column = x0$1;
            if (column instanceof TypedColumn) {
                TypedColumn typedColumn = (TypedColumn)column;
                return typedColumn.withInputType(this.df().exprEnc(), (Seq<Attribute>)this.df().logicalPlan().output()).expr();
            }
            return column.expr();
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public Dataset<Row> count() {
        AggregateExpression x$1 = Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).toAggregateExpression();
        String x$2 = "count";
        ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
        Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
        Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
        Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
        return this.toDF((Seq<Expression>)((Seq)new .colon.colon((Object)new Alias((Expression)x$1, x$2, x$3, x$4, x$5, x$6), (List)Nil$.MODULE$)));
    }

    public Dataset<Row> mean(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)(Function1 & Serializable & scala.Serializable)x$9 -> new Average(x$9, Average$.MODULE$.apply$default$2()));
    }

    public Dataset<Row> max(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Max$.MODULE$);
    }

    public Dataset<Row> avg(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)(Function1 & Serializable & scala.Serializable)x$10 -> new Average(x$10, Average$.MODULE$.apply$default$2()));
    }

    public Dataset<Row> min(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Min$.MODULE$);
    }

    public Dataset<Row> sum(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)(Function1 & Serializable & scala.Serializable)x$11 -> new Sum(x$11, Sum$.MODULE$.apply$default$2()));
    }

    public RelationalGroupedDataset pivot(String pivotColumn) {
        return this.pivot(Column$.MODULE$.apply(pivotColumn));
    }

    public RelationalGroupedDataset pivot(String pivotColumn, Seq<Object> values) {
        return this.pivot(Column$.MODULE$.apply(pivotColumn), values);
    }

    public RelationalGroupedDataset pivot(String pivotColumn, java.util.List<Object> values) {
        return this.pivot(Column$.MODULE$.apply(pivotColumn), values);
    }

    public RelationalGroupedDataset pivot(Column pivotColumn) {
        int maxValues = this.df().sparkSession().sessionState().conf().dataFramePivotMaxValues();
        Seq values = Predef$.MODULE$.genericArrayOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.df().select((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{pivotColumn})).distinct().limit(maxValues + 1).sort((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{pivotColumn})).collect())).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.get(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSeq();
        if (values.length() > maxValues) {
            throw QueryCompilationErrors$.MODULE$.aggregationFunctionAppliedOnNonNumericColumnError(pivotColumn.toString(), maxValues);
        }
        return this.pivot(pivotColumn, (Seq<Object>)values);
    }

    public RelationalGroupedDataset pivot(Column pivotColumn, Seq<Object> values) {
        GroupType groupType = this.groupType;
        if (RelationalGroupedDataset$GroupByType$.MODULE$.equals(groupType)) {
            Seq valueExprs = (Seq)values.map((Function1 & Serializable & scala.Serializable)x$13 -> {
                Literal literal;
                Object object = x$13;
                if (object instanceof Column) {
                    Column column = (Column)object;
                    return column.expr();
                }
                try {
                    literal = Literal$.MODULE$.apply(object);
                }
                catch (SparkRuntimeException sparkRuntimeException) {
                    throw QueryExecutionErrors$.MODULE$.pivotColumnUnsupportedError(object, pivotColumn.expr().dataType());
                }
                return literal;
            }, Seq$.MODULE$.canBuildFrom());
            return new RelationalGroupedDataset(this.df(), this.groupingExprs(), new PivotType(pivotColumn.expr(), (Seq<Expression>)valueExprs));
        }
        if (groupType instanceof PivotType) {
            throw QueryExecutionErrors$.MODULE$.repeatedPivotsUnsupportedError("PIVOT", "SUBQUERY");
        }
        throw QueryExecutionErrors$.MODULE$.pivotNotAfterGroupByUnsupportedError();
    }

    public RelationalGroupedDataset pivot(Column pivotColumn, java.util.List<Object> values) {
        return this.pivot(pivotColumn, (Seq<Object>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(values).asScala()).toSeq());
    }

    public Dataset<Row> flatMapGroupsInR(byte[] f, byte[] packageNames, Broadcast<Object>[] broadcastVars, StructType outputSchema) {
        Seq groupingNamedExpressions = (Seq)this.groupingExprs().map((Function1 & Serializable & scala.Serializable)expr -> this.alias((Expression)expr), Seq$.MODULE$.canBuildFrom());
        Seq groupingCols = (Seq)groupingNamedExpressions.map((Function1 & Serializable & scala.Serializable)x$14 -> Column$.MODULE$.apply((Expression)x$14), Seq$.MODULE$.canBuildFrom());
        Dataset<Row> groupingDataFrame = this.df().select((Seq<Column>)groupingCols);
        Seq groupingAttributes = (Seq)groupingNamedExpressions.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.toAttribute(), Seq$.MODULE$.canBuildFrom());
        return Dataset$.MODULE$.ofRows(this.df().sparkSession(), FlatMapGroupsInR$.MODULE$.apply(f, packageNames, broadcastVars, outputSchema, groupingDataFrame.exprEnc().deserializer(), this.df().exprEnc().deserializer(), this.df().exprEnc().schema(), groupingAttributes, this.df().logicalPlan().output(), this.df().logicalPlan()));
    }

    public Dataset<Row> flatMapGroupsInPandas(PythonUDF expr) {
        Predef$.MODULE$.require(expr.evalType() == PythonEvalType$.MODULE$.SQL_GROUPED_MAP_PANDAS_UDF(), (Function0 & Serializable & scala.Serializable)() -> "Must pass a grouped map udf");
        Predef$.MODULE$.require(expr.dataType() instanceof StructType, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(36).append("The returnType of the udf must be a ").append(StructType$.MODULE$.simpleString()).toString());
        Seq groupingNamedExpressions = (Seq)this.groupingExprs().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Expression expression = x0$1;
            if (expression instanceof NamedExpression) {
                NamedExpression namedExpression = (NamedExpression)expression;
                return namedExpression;
            }
            Expression x$1 = expression;
            String x$2 = expression.toString();
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            Seq x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            return new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
        }, Seq$.MODULE$.canBuildFrom());
        LogicalPlan child = this.df().logicalPlan();
        LogicalPlan project = this.df().sparkSession().sessionState().executePlan((LogicalPlan)new Project((Seq)groupingNamedExpressions.$plus$plus((GenTraversableOnce)child.output(), Seq$.MODULE$.canBuildFrom()), child), this.df().sparkSession().sessionState().executePlan$default$2()).analyzed();
        Seq groupingAttributes = (Seq)project.output().take(groupingNamedExpressions.length());
        Seq output = ((StructType)expr.dataType()).toAttributes();
        FlatMapGroupsInPandas plan = new FlatMapGroupsInPandas(groupingAttributes, (Expression)expr, output, project);
        return Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)plan);
    }

    public Dataset<Row> flatMapCoGroupsInPandas(RelationalGroupedDataset r, PythonUDF expr) {
        Predef$.MODULE$.require(expr.evalType() == PythonEvalType$.MODULE$.SQL_COGROUPED_MAP_PANDAS_UDF(), (Function0 & Serializable & scala.Serializable)() -> "Must pass a cogrouped map udf");
        Predef$.MODULE$.require(this.groupingExprs().length() == r.groupingExprs().length(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(38).append("Cogroup keys must have same size: ").append(this.groupingExprs().length()).append(" != ").append(r.groupingExprs().length()).toString());
        Predef$.MODULE$.require(expr.dataType() instanceof StructType, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(36).append("The returnType of the udf must be a ").append(StructType$.MODULE$.simpleString()).toString());
        Seq leftGroupingNamedExpressions = (Seq)this.groupingExprs().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Expression expression = x0$1;
            if (expression instanceof NamedExpression) {
                NamedExpression namedExpression = (NamedExpression)expression;
                return namedExpression;
            }
            Expression x$1 = expression;
            String x$2 = expression.toString();
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            Seq x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            return new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
        }, Seq$.MODULE$.canBuildFrom());
        Seq rightGroupingNamedExpressions = (Seq)r.groupingExprs().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Expression expression = x0$2;
            if (expression instanceof NamedExpression) {
                NamedExpression namedExpression = (NamedExpression)expression;
                return namedExpression;
            }
            Expression x$7 = expression;
            String x$8 = expression.toString();
            ExprId x$9 = Alias$.MODULE$.apply$default$3(x$7, x$8);
            Seq x$10 = Alias$.MODULE$.apply$default$4(x$7, x$8);
            Option x$11 = Alias$.MODULE$.apply$default$5(x$7, x$8);
            Seq x$12 = Alias$.MODULE$.apply$default$6(x$7, x$8);
            return new Alias(x$7, x$8, x$9, x$10, x$11, x$12);
        }, Seq$.MODULE$.canBuildFrom());
        LogicalPlan leftChild = this.df().logicalPlan();
        LogicalPlan rightChild = r.df().logicalPlan();
        LogicalPlan left = this.df().sparkSession().sessionState().executePlan((LogicalPlan)new Project((Seq)leftGroupingNamedExpressions.$plus$plus((GenTraversableOnce)leftChild.output(), Seq$.MODULE$.canBuildFrom()), leftChild), this.df().sparkSession().sessionState().executePlan$default$2()).analyzed();
        LogicalPlan right = r.df().sparkSession().sessionState().executePlan((LogicalPlan)new Project((Seq)rightGroupingNamedExpressions.$plus$plus((GenTraversableOnce)rightChild.output(), Seq$.MODULE$.canBuildFrom()), rightChild), r.df().sparkSession().sessionState().executePlan$default$2()).analyzed();
        Seq output = ((StructType)expr.dataType()).toAttributes();
        FlatMapCoGroupsInPandas plan = new FlatMapCoGroupsInPandas(leftGroupingNamedExpressions.length(), rightGroupingNamedExpressions.length(), (Expression)expr, output, left, right);
        return Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)plan);
    }

    public Dataset<Row> applyInPandasWithState(PythonUDF func, StructType outputStructType, StructType stateStructType, String outputModeStr, String timeoutConfStr) {
        OutputMode outputMode;
        GroupStateTimeout timeoutConf = GroupStateImpl$.MODULE$.groupStateTimeoutFromString(timeoutConfStr);
        OutputMode outputMode2 = outputMode = InternalOutputModes$.MODULE$.apply(outputModeStr);
        OutputMode outputMode3 = OutputMode.Append();
        if (outputMode2 == null ? outputMode3 != null : !outputMode2.equals(outputMode3)) {
            OutputMode outputMode4 = outputMode;
            OutputMode outputMode5 = OutputMode.Update();
            if (outputMode4 == null ? outputMode5 != null : !outputMode4.equals(outputMode5)) {
                throw new IllegalArgumentException("The output mode of function should be append or update");
            }
        }
        Seq groupingNamedExpressions = (Seq)this.groupingExprs().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Expression expression = x0$1;
            if (expression instanceof NamedExpression) {
                NamedExpression namedExpression = (NamedExpression)expression;
                return namedExpression;
            }
            Expression x$1 = expression;
            String x$2 = expression.toString();
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            Seq x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            return new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
        }, Seq$.MODULE$.canBuildFrom());
        Seq groupingAttrs = (Seq)groupingNamedExpressions.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq outputAttrs = outputStructType.toAttributes();
        FlatMapGroupsInPandasWithState plan = new FlatMapGroupsInPandasWithState((Expression)func, groupingAttrs, outputAttrs, stateStructType, outputMode, timeoutConf, this.df().logicalPlan());
        return Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)plan);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RelationalGroupedDataset: [grouping expressions: [");
        Seq kFields = (Seq)this.groupingExprs().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl = false;
                NamedExpression namedExpression = null;
                A1 A1 = x1;
                if (A1 instanceof NamedExpression) {
                    bl = true;
                    namedExpression = (NamedExpression)A1;
                    if (((Expression)namedExpression).resolved()) {
                        return (B1)new java.lang.StringBuilder(2).append(namedExpression.name()).append(": ").append(((Expression)namedExpression).dataType().simpleString(2)).toString();
                    }
                }
                if (bl) {
                    return (B1)namedExpression.name();
                }
                return (B1)A1.toString();
            }

            public final boolean isDefinedAt(Expression x1) {
                boolean bl = false;
                NamedExpression namedExpression = null;
                Expression expression = x1;
                if (expression instanceof NamedExpression) {
                    bl = true;
                    namedExpression = (NamedExpression)expression;
                    if (((Expression)namedExpression).resolved()) {
                        return true;
                    }
                }
                if (bl) {
                    return true;
                }
                return true;
            }
        }, Seq$.MODULE$.canBuildFrom());
        builder.append(((TraversableOnce)kFields.take(2)).mkString(", "));
        Object object = kFields.length() > 2 ? builder.append(new java.lang.StringBuilder(19).append(" ... ").append(kFields.length() - 2).append(" more field(s)").toString()) : BoxedUnit.UNIT;
        return builder.append(new java.lang.StringBuilder(19).append("], value: ").append(this.df().toString()).append(", type: ").append(this.groupType).append("]").toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$as$2(RelationalGroupedDataset $this, NamedExpression g) {
        return !$this.df().logicalPlan().outputSet().contains((NamedExpression)g.toAttribute());
    }

    public RelationalGroupedDataset(Dataset<Row> df, Seq<Expression> groupingExprs, GroupType groupType) {
        this.df = df;
        this.groupingExprs = groupingExprs;
        this.groupType = groupType;
    }

    public static interface GroupType {
        default public String toString() {
            return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(this.getClass().getSimpleName())).stripSuffix("$"))).stripSuffix("Type");
        }

        public static void $init$(GroupType $this) {
        }
    }

    public static class PivotType
    implements GroupType,
    Product,
    scala.Serializable {
        private final Expression pivotCol;
        private final Seq<Expression> values;

        @Override
        public String toString() {
            return ((GroupType)this).toString();
        }

        public Expression pivotCol() {
            return this.pivotCol;
        }

        public Seq<Expression> values() {
            return this.values;
        }

        public PivotType copy(Expression pivotCol, Seq<Expression> values) {
            return new PivotType(pivotCol, values);
        }

        public Expression copy$default$1() {
            return this.pivotCol();
        }

        public Seq<Expression> copy$default$2() {
            return this.values();
        }

        public String productPrefix() {
            return "PivotType";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.pivotCol();
                }
                case 1: {
                    return this.values();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PivotType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PivotType)) return false;
            boolean bl = true;
            if (!bl) return false;
            PivotType pivotType = (PivotType)x$1;
            Expression expression = this.pivotCol();
            Expression expression2 = pivotType.pivotCol();
            if (expression == null) {
                if (expression2 != null) {
                    return false;
                }
            } else if (!expression.equals(expression2)) return false;
            Seq<Expression> seq = this.values();
            Seq<Expression> seq2 = pivotType.values();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!pivotType.canEqual(this)) return false;
            return true;
        }

        public PivotType(Expression pivotCol, Seq<Expression> values) {
            this.pivotCol = pivotCol;
            this.values = values;
            GroupType.$init$(this);
            Product.$init$((Product)this);
        }
    }
}

