/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.jdbc.DB2Dialect;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class DB2Dialect$
extends JdbcDialect {
    public static DB2Dialect$ MODULE$;
    private final Set<String> org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    static {
        new DB2Dialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:db2");
    }

    public Set<String> org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        DB2Dialect.DB2SQLBuilder db2SQLBuilder = new DB2Dialect.DB2SQLBuilder();
        try {
            some = new Some((Object)db2SQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurs while compiling V2 expression", e);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case 7: {
                return Option$.MODULE$.apply((Object)FloatType$.MODULE$);
            }
            case 1111: {
                String string = typeName;
                if ("DECFLOAT".equals(string)) {
                    return Option$.MODULE$.apply((Object)new DecimalType(38, 18));
                }
                if ("XML".equals(string)) {
                    return Option$.MODULE$.apply((Object)StringType$.MODULE$);
                }
                if (string.startsWith("TIMESTAMP")) {
                    return Option$.MODULE$.apply((Object)TimestampType$.MODULE$);
                }
                return None$.MODULE$;
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("CLOB", 2005));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("CHAR(1)", 1));
        }
        if (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(25).append("TRUNCATE TABLE ").append(table).append(" IMMEDIATE").toString();
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(17).append("RENAME TABLE ").append(oldTable).append(" TO ").append(newTable).toString();
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(41).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" SET DATA TYPE ").append(newDataType).toString();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "DROP NOT NULL" : "SET NOT NULL";
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(nullable).toString();
    }

    @Override
    public String removeSchemaCommentQuery(String schema) {
        return new StringBuilder(24).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS ''").toString();
    }

    @Override
    public AnalysisException classifyException(String message, Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            String string = sQLException.getSQLState();
            if ("42893".equals(string)) {
                throw new NonEmptyNamespaceException(message, (Option)new Some((Object)e));
            }
            return super.classifyException(message, e);
        }
        return super.classifyException(message, e);
    }

    @Override
    public String dropSchema(String schema, boolean cascade) {
        if (cascade) {
            return new StringBuilder(20).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).append(" CASCADE").toString();
        }
        return new StringBuilder(21).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).append(" RESTRICT").toString();
    }

    @Override
    public String getLimitClause(Integer limit) {
        if (Predef$.MODULE$.Integer2int(limit) > 0) {
            return new StringBuilder(22).append("FETCH FIRST ").append(limit).append(" ROWS ONLY").toString();
        }
        return "";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DB2Dialect$() {
        MODULE$ = this;
        this.org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COVAR_POP", "COVAR_SAMP", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
        this.supportedAggregateFunctions = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}))).$plus$plus(this.org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = this.supportedAggregateFunctions();
    }
}

