/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SchemaPruning$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.read.SupportsPushDownLimit;
import org.apache.spark.sql.connector.read.SupportsPushDownOffset;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.connector.read.SupportsPushDownTableSample;
import org.apache.spark.sql.connector.read.SupportsPushDownTopN;
import org.apache.spark.sql.connector.read.SupportsPushDownV2Filters;
import org.apache.spark.sql.execution.datasources.DataSourceStrategy$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Strategy$;
import org.apache.spark.sql.execution.datasources.v2.FileScanBuilder;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.collection.Utils$;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class PushDownUtils$ {
    public static PushDownUtils$ MODULE$;

    static {
        new PushDownUtils$();
    }

    public Tuple2<Either<Seq<Filter>, Seq<Predicate>>, Seq<Expression>> pushFilters(ScanBuilder scanBuilder, Seq<Expression> filters) {
        ScanBuilder scanBuilder2 = scanBuilder;
        if (scanBuilder2 instanceof SupportsPushDownFilters) {
            SupportsPushDownFilters supportsPushDownFilters = (SupportsPushDownFilters)scanBuilder2;
            HashMap translatedFilterToExpr = HashMap$.MODULE$.empty();
            ArrayBuffer translatedFilters = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            ArrayBuffer untranslatableExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            filters.foreach((Function1 & Serializable & scala.Serializable)filterExpr -> {
                Option<Filter> translated = DataSourceStrategy$.MODULE$.translateFilterWithMapping((Expression)filterExpr, (Option<HashMap<Filter, Expression>>)new Some((Object)translatedFilterToExpr), true);
                if (translated.isEmpty()) {
                    return untranslatableExprs.$plus$eq(filterExpr);
                }
                return translatedFilters.$plus$eq(translated.get());
            });
            Expression[] postScanFilters = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])supportsPushDownFilters.pushFilters((Filter[])translatedFilters.toArray(ClassTag$.MODULE$.apply(Filter.class))))).map((Function1 & Serializable & scala.Serializable)filter -> DataSourceStrategy$.MODULE$.rebuildExpressionFromFilter((Filter)filter, (HashMap<Filter, Expression>)translatedFilterToExpr), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class)));
            return new Tuple2((Object)package$.MODULE$.Left().apply((Object)Predef$.MODULE$.wrapRefArray((Object[])supportsPushDownFilters.pushedFilters())), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])postScanFilters)).$plus$plus((GenTraversableOnce)untranslatableExprs, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class))))).toSeq());
        }
        if (scanBuilder2 instanceof SupportsPushDownV2Filters) {
            SupportsPushDownV2Filters supportsPushDownV2Filters = (SupportsPushDownV2Filters)scanBuilder2;
            HashMap translatedFilterToExpr = HashMap$.MODULE$.empty();
            ArrayBuffer translatedFilters = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            ArrayBuffer untranslatableExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            filters.foreach((Function1 & Serializable & scala.Serializable)filterExpr -> {
                Option<Predicate> translated = DataSourceV2Strategy$.MODULE$.translateFilterV2WithMapping((Expression)filterExpr, (Option<HashMap<Predicate, Expression>>)new Some((Object)translatedFilterToExpr));
                if (translated.isEmpty()) {
                    return untranslatableExprs.$plus$eq(filterExpr);
                }
                return translatedFilters.$plus$eq(translated.get());
            });
            Expression[] postScanFilters = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])supportsPushDownV2Filters.pushPredicates((Predicate[])translatedFilters.toArray(ClassTag$.MODULE$.apply(Predicate.class))))).map((Function1 & Serializable & scala.Serializable)predicate -> DataSourceV2Strategy$.MODULE$.rebuildExpressionFromFilter((Predicate)predicate, (HashMap<Predicate, Expression>)translatedFilterToExpr), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class)));
            return new Tuple2((Object)package$.MODULE$.Right().apply((Object)Predef$.MODULE$.wrapRefArray((Object[])supportsPushDownV2Filters.pushedPredicates())), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])postScanFilters)).$plus$plus((GenTraversableOnce)untranslatableExprs, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class))))).toSeq());
        }
        if (scanBuilder2 instanceof FileScanBuilder) {
            FileScanBuilder fileScanBuilder = (FileScanBuilder)scanBuilder2;
            Seq<Expression> postScanFilters = fileScanBuilder.pushFilters(filters);
            return new Tuple2((Object)package$.MODULE$.Right().apply((Object)Predef$.MODULE$.wrapRefArray((Object[])fileScanBuilder.pushedFilters())), postScanFilters);
        }
        return new Tuple2((Object)package$.MODULE$.Left().apply((Object)Nil$.MODULE$), filters);
    }

    public boolean pushTableSample(ScanBuilder scanBuilder, TableSampleInfo sample) {
        ScanBuilder scanBuilder2 = scanBuilder;
        if (scanBuilder2 instanceof SupportsPushDownTableSample) {
            SupportsPushDownTableSample supportsPushDownTableSample = (SupportsPushDownTableSample)scanBuilder2;
            return supportsPushDownTableSample.pushTableSample(sample.lowerBound(), sample.upperBound(), sample.withReplacement(), sample.seed());
        }
        return false;
    }

    public Tuple2<Object, Object> pushLimit(ScanBuilder scanBuilder, int limit) {
        SupportsPushDownLimit supportsPushDownLimit;
        ScanBuilder scanBuilder2 = scanBuilder;
        if (scanBuilder2 instanceof SupportsPushDownLimit && (supportsPushDownLimit = (SupportsPushDownLimit)scanBuilder2).pushLimit(limit)) {
            return new Tuple2.mcZZ.sp(true, supportsPushDownLimit.isPartiallyPushed());
        }
        return new Tuple2.mcZZ.sp(false, false);
    }

    public boolean pushOffset(ScanBuilder scanBuilder, int offset) {
        ScanBuilder scanBuilder2 = scanBuilder;
        if (scanBuilder2 instanceof SupportsPushDownOffset) {
            SupportsPushDownOffset supportsPushDownOffset = (SupportsPushDownOffset)scanBuilder2;
            return supportsPushDownOffset.pushOffset(offset);
        }
        return false;
    }

    public Tuple2<Object, Object> pushTopN(ScanBuilder scanBuilder, SortOrder[] order, int limit) {
        SupportsPushDownTopN supportsPushDownTopN;
        ScanBuilder scanBuilder2 = scanBuilder;
        if (scanBuilder2 instanceof SupportsPushDownTopN && (supportsPushDownTopN = (SupportsPushDownTopN)scanBuilder2).pushTopN(order, limit)) {
            return new Tuple2.mcZZ.sp(true, supportsPushDownTopN.isPartiallyPushed());
        }
        return new Tuple2.mcZZ.sp(false, false);
    }

    public Tuple2<Scan, Seq<AttributeReference>> pruneColumns(ScanBuilder scanBuilder, DataSourceV2Relation relation, Seq<NamedExpression> projects, Seq<Expression> filters) {
        Seq exprs = (Seq)projects.$plus$plus(filters, Seq$.MODULE$.canBuildFrom());
        AttributeSet requiredColumns = AttributeSet$.MODULE$.apply((Iterable)exprs.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.references(), Seq$.MODULE$.canBuildFrom()));
        Seq neededOutput = (Seq)relation.output().filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)requiredColumns.contains(elem)));
        boolean bl = false;
        SupportsPushDownRequiredColumns supportsPushDownRequiredColumns = null;
        ScanBuilder scanBuilder2 = scanBuilder;
        if (scanBuilder2 instanceof SupportsPushDownRequiredColumns) {
            bl = true;
            supportsPushDownRequiredColumns = (SupportsPushDownRequiredColumns)scanBuilder2;
            if (SQLConf$.MODULE$.get().nestedSchemaPruningEnabled()) {
                Seq rootFields = SchemaPruning$.MODULE$.identifyRootFields(projects, filters);
                StructType prunedSchema = rootFields.nonEmpty() ? SchemaPruning$.MODULE$.pruneSchema(relation.schema(), rootFields) : new StructType();
                Set neededFieldNames = ((TraversableOnce)neededOutput.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Seq$.MODULE$.canBuildFrom())).toSet();
                supportsPushDownRequiredColumns.pruneColumns(StructType$.MODULE$.apply((Seq)prunedSchema.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)neededFieldNames.contains((Object)f.name())))));
                Scan scan = supportsPushDownRequiredColumns.build();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scan), this.toOutputAttrs(scan.readSchema(), relation));
            }
        }
        if (bl) {
            supportsPushDownRequiredColumns.pruneColumns(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.AttributeSeq(neededOutput).toStructType());
            Scan scan = supportsPushDownRequiredColumns.build();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scan), this.toOutputAttrs(scan.readSchema(), relation));
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scanBuilder.build()), (Object)relation.output());
    }

    public Seq<AttributeReference> toOutputAttrs(StructType schema, DataSourceV2Relation relation) {
        Map nameToAttr = Utils$.MODULE$.toMap((Iterable)relation.output().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom()), (Iterable)relation.output());
        StructType cleaned = CharVarcharUtils$.MODULE$.replaceCharVarcharWithStringInSchema(schema);
        return (Seq)cleaned.toAttributes().map((Function1 & Serializable & scala.Serializable)a -> a.withExprId(((AttributeReference)nameToAttr.apply((Object)a.name())).exprId()), Seq$.MODULE$.canBuildFrom());
    }

    private PushDownUtils$() {
        MODULE$ = this;
    }
}

