/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.AliasIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.optimizer.EliminateResolvedHint$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.IgnoreCachedData;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryRelation$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.FileTable;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\tMe\u0001B\u0010!\u0001-BQA\u0010\u0001\u0005\u0002}BqA\u0011\u0001A\u0002\u0013%1\tC\u0004P\u0001\u0001\u0007I\u0011\u0002)\t\rY\u0003\u0001\u0015)\u0003E\u0011\u001dy\u0006A1A\u0005\n\u0001DaA\u001e\u0001!\u0002\u0013\t\u0007\"B<\u0001\t\u0003A\b\"B=\u0001\t\u0003Q\b\"B>\u0001\t\u0003a\b\"CA%\u0001E\u0005I\u0011AA&\u0011%\t\t\u0007AI\u0001\n\u0003\t\u0019\u0007\u0003\u0004|\u0001\u0011\u0005\u0011q\r\u0005\u0007w\u0002!\t!a#\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\"9\u0011Q\u0013\u0001\u0005\u0002\u0005%\u0006\"CA\\\u0001E\u0005I\u0011AA]\u0011\u001d\ti\f\u0001C\u0001\u0003\u007fCq!a3\u0001\t\u0013\ti\rC\u0004\u0002\u0016\u0002!\t!!9\t\u0011\u0005M\b\u0001\"\u0001#\u0003kDqAa\u0004\u0001\t\u0003\u0011\t\u0002C\u0004\u0003\u0018\u0001!IA!\u0007\t\u000f\t\r\u0002\u0001\"\u0001\u0003&!9!1\u0005\u0001\u0005\u0002\tU\u0002b\u0002B\u001d\u0001\u0011\u0005!1\b\u0005\b\u0005\u007f\u0001A\u0011\u0001B!\u0011\u001d\u0011y\u0004\u0001C\u0001\u0005\u0013BqAa\u001a\u0001\t\u0013\u0011I\u0007C\u0004\u0003t\u0001!IA!\u001e\t\u000f\t-\u0005\u0001\"\u0003\u0003\u000e\na1)Y2iK6\u000bg.Y4fe*\u0011\u0011EI\u0001\nKb,7-\u001e;j_:T!a\t\u0013\u0002\u0007M\fHN\u0003\u0002&M\u0005)1\u000f]1sW*\u0011q\u0005K\u0001\u0007CB\f7\r[3\u000b\u0003%\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u00173qA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t1\u0011I\\=SK\u001a\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\u0013\u0002\u0011%tG/\u001a:oC2L!a\u000e\u001b\u0003\u000f1{wmZ5oOB\u0011\u0011\bP\u0007\u0002u)\u00111\bI\u0001\tC\u0012\f\u0007\u000f^5wK&\u0011QH\u000f\u0002\u0018\u0003\u0012\f\u0007\u000f^5wKN\u0003\u0018M]6QY\u0006t\u0007*\u001a7qKJ\fa\u0001P5oSRtD#\u0001!\u0011\u0005\u0005\u0003Q\"\u0001\u0011\u0002\u0015\r\f7\r[3e\t\u0006$\u0018-F\u0001E!\r)%\nT\u0007\u0002\r*\u0011q\tS\u0001\nS6lW\u000f^1cY\u0016T!!\u0013\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002L\r\nQ\u0011J\u001c3fq\u0016$7+Z9\u0011\u0005\u0005k\u0015B\u0001(!\u0005)\u0019\u0015m\u00195fI\u0012\u000bG/Y\u0001\u000fG\u0006\u001c\u0007.\u001a3ECR\fw\fJ3r)\t\tF\u000b\u0005\u0002.%&\u00111K\f\u0002\u0005+:LG\u000fC\u0004V\u0007\u0005\u0005\t\u0019\u0001#\u0002\u0007a$\u0013'A\u0006dC\u000eDW\r\u001a#bi\u0006\u0004\u0003F\u0001\u0003Y!\ti\u0013,\u0003\u0002[]\tAao\u001c7bi&dW\r\u000b\u0002\u00059B\u0011Q&X\u0005\u0003=:\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002'\u0019|'oY3ESN\f'\r\\3D_:4\u0017nZ:\u0016\u0003\u0005\u00042A\u00196n\u001d\t\u0019\u0007N\u0004\u0002eO6\tQM\u0003\u0002gU\u00051AH]8pizJ\u0011aL\u0005\u0003S:\nq\u0001]1dW\u0006<W-\u0003\u0002lY\n\u00191+Z9\u000b\u0005%t\u0003c\u00018rg6\tqN\u0003\u0002qi\u000511m\u001c8gS\u001eL!A]8\u0003\u0017\r{gNZ5h\u000b:$(/\u001f\t\u0003[QL!!\u001e\u0018\u0003\u000f\t{w\u000e\\3b]\u0006!bm\u001c:dK\u0012K7/\u00192mK\u000e{gNZ5hg\u0002\n!b\u00197fCJ\u001c\u0015m\u00195f)\u0005\t\u0016aB5t\u000b6\u0004H/_\u000b\u0002g\u0006Q1-Y2iKF+XM]=\u0015\rEk\u0018qDA\u001d\u0011\u0015q\u0018\u00021\u0001\u0000\u0003\u0015\tX/\u001a:za\u0011\t\t!!\u0004\u0011\r\u0005\r\u0011QAA\u0005\u001b\u0005\u0011\u0013bAA\u0004E\t9A)\u0019;bg\u0016$\b\u0003BA\u0006\u0003\u001ba\u0001\u0001B\u0006\u0002\u0010u\f\t\u0011!A\u0003\u0002\u0005E!aA0%cE!\u00111CA\r!\ri\u0013QC\u0005\u0004\u0003/q#a\u0002(pi\"Lgn\u001a\t\u0004[\u0005m\u0011bAA\u000f]\t\u0019\u0011I\\=\t\u0013\u0005\u0005\u0012\u0002%AA\u0002\u0005\r\u0012!\u0003;bE2,g*Y7f!\u0015i\u0013QEA\u0015\u0013\r\t9C\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-\u00121\u0007\b\u0005\u0003[\ty\u0003\u0005\u0002e]%\u0019\u0011\u0011\u0007\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\t)$a\u000e\u0003\rM#(/\u001b8h\u0015\r\t\tD\f\u0005\n\u0003wI\u0001\u0013!a\u0001\u0003{\tAb\u001d;pe\u0006<W\rT3wK2\u0004B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007\"\u0013aB:u_J\fw-Z\u0005\u0005\u0003\u000f\n\tE\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G.\u0001\u000bdC\u000eDW-U;fef$C-\u001a4bk2$HEM\u000b\u0003\u0003\u001bRC!a\t\u0002P-\u0012\u0011\u0011\u000b\t\u0005\u0003'\ni&\u0004\u0002\u0002V)!\u0011qKA-\u0003%)hn\u00195fG.,GMC\u0002\u0002\\9\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty&!\u0016\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000bdC\u000eDW-U;fef$C-\u001a4bk2$HeM\u000b\u0003\u0003KRC!!\u0010\u0002PQ9\u0011+!\u001b\u0002r\u0005%\u0005BB\u0013\r\u0001\u0004\tY\u0007\u0005\u0003\u0002\u0004\u00055\u0014bAA8E\ta1\u000b]1sWN+7o]5p]\"9\u00111\u000f\u0007A\u0002\u0005U\u0014a\u00039mC:$vnQ1dQ\u0016\u0004B!a\u001e\u0002\u00066\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(A\u0004m_\u001eL7-\u00197\u000b\t\u0005}\u0014\u0011Q\u0001\u0006a2\fgn\u001d\u0006\u0004\u0003\u0007\u0013\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005\u001d\u0015\u0011\u0010\u0002\f\u0019><\u0017nY1m!2\fg\u000eC\u0004\u0002\"1\u0001\r!a\t\u0015\u0013E\u000bi)a$\u0002\u0012\u0006M\u0005BB\u0013\u000e\u0001\u0004\tY\u0007C\u0004\u0002t5\u0001\r!!\u001e\t\u000f\u0005\u0005R\u00021\u0001\u0002$!9\u00111H\u0007A\u0002\u0005u\u0012\u0001D;oG\u0006\u001c\u0007.Z)vKJLH#B)\u0002\u001a\u0006\u0015\u0006B\u0002@\u000f\u0001\u0004\tY\n\r\u0003\u0002\u001e\u0006\u0005\u0006CBA\u0002\u0003\u000b\ty\n\u0005\u0003\u0002\f\u0005\u0005F\u0001DAR\u00033\u000b\t\u0011!A\u0003\u0002\u0005E!aA0%e!1\u0011q\u0015\bA\u0002M\fqaY1tG\u0006$W\rF\u0005R\u0003W\u000bi+!-\u00024\"1Qe\u0004a\u0001\u0003WBq!a,\u0010\u0001\u0004\t)(\u0001\u0003qY\u0006t\u0007BBAT\u001f\u0001\u00071\u000f\u0003\u0005\u00026>\u0001\n\u00111\u0001t\u0003!\u0011Gn\\2lS:<\u0017AF;oG\u0006\u001c\u0007.Z)vKJLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005m&fA:\u0002P\u0005\u0011RO\\2bG\",G+\u00192mK>\u0013h+[3x)\u001d\t\u0016\u0011YAb\u0003\u0013Da!J\tA\u0002\u0005-\u0004bBAc#\u0001\u0007\u0011qY\u0001\u0005]\u0006lW\r\u0005\u0003cU\u0006%\u0002BBAT#\u0001\u00071/\u0001\u000bjg6\u000bGo\u00195fIR\u000b'\r\\3PeZKWm\u001e\u000b\bg\u0006=\u0017\u0011[Aj\u0011\u001d\tyK\u0005a\u0001\u0003kBq!!2\u0013\u0001\u0004\t9\rC\u0004\u0002VJ\u0001\r!a6\u0002\t\r|gN\u001a\t\u0005\u00033\fi.\u0004\u0002\u0002\\*\u0011QGI\u0005\u0005\u0003?\fYNA\u0004T#2\u001buN\u001c4\u0015\u0013E\u000b\u0019/!:\u0002p\u0006E\bBB\u0013\u0014\u0001\u0004\tY\u0007C\u0004\u0002hN\u0001\r!!;\u0002\u001b%\u001cX*\u0019;dQ\u0016$\u0007\u000b\\1o!\u0019i\u00131^A;g&\u0019\u0011Q\u001e\u0018\u0003\u0013\u0019+hn\u0019;j_:\f\u0004BBAT'\u0001\u00071\u000f\u0003\u0004\u00026N\u0001\ra]\u0001\u0018C:\fG.\u001f>f\u0007>dW/\u001c8DC\u000eDW-U;fef$r!UA|\u0003w\fi\u0010C\u0004\u0002zR\u0001\r!a\u001b\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\t\u000b\t#\u0002\u0019\u0001'\t\u000f\u0005}H\u00031\u0001\u0003\u0002\u000511m\u001c7v[:\u0004BA\u00196\u0003\u0004A!!Q\u0001B\u0006\u001b\t\u00119A\u0003\u0003\u0003\n\u0005\u0005\u0015aC3yaJ,7o]5p]NLAA!\u0004\u0003\b\tI\u0011\t\u001e;sS\n,H/Z\u0001\u000ee\u0016\u001c\u0017m\u00195f\u0005f\u0004F.\u00198\u0015\u000bE\u0013\u0019B!\u0006\t\r\u0015*\u0002\u0019AA6\u0011\u001d\ty+\u0006a\u0001\u0003k\n!C]3dC\u000eDWMQ=D_:$\u0017\u000e^5p]R)\u0011Ka\u0007\u0003\u001e!1QE\u0006a\u0001\u0003WBqAa\b\u0017\u0001\u0004\u0011\t#A\u0005d_:$\u0017\u000e^5p]B)Q&a;Mg\u0006\u0001Bn\\8lkB\u001c\u0015m\u00195fI\u0012\u000bG/\u0019\u000b\u0005\u0005O\u0011I\u0003\u0005\u0003.\u0003Ka\u0005B\u0002@\u0018\u0001\u0004\u0011Y\u0003\r\u0003\u0003.\tE\u0002CBA\u0002\u0003\u000b\u0011y\u0003\u0005\u0003\u0002\f\tEB\u0001\u0004B\u001a\u0005S\t\t\u0011!A\u0003\u0002\u0005E!aA0%gQ!!q\u0005B\u001c\u0011\u001d\ty\u000b\u0007a\u0001\u0003k\nQ\"^:f\u0007\u0006\u001c\u0007.\u001a3ECR\fG\u0003BA;\u0005{Aq!a,\u001a\u0001\u0004\t)(A\u0007sK\u000e\f7\r[3CsB\u000bG\u000f\u001b\u000b\u0006#\n\r#Q\t\u0005\u0007Ki\u0001\r!a\u001b\t\u000f\t\u001d#\u00041\u0001\u0002*\u0005a!/Z:pkJ\u001cW\rU1uQR9\u0011Ka\u0013\u0003N\t}\u0003BB\u0013\u001c\u0001\u0004\tY\u0007C\u0004\u0003Hm\u0001\rAa\u0014\u0011\t\tE#1L\u0007\u0003\u0005'RAA!\u0016\u0003X\u0005\u0011am\u001d\u0006\u0004\u000532\u0013A\u00025bI>|\u0007/\u0003\u0003\u0003^\tM#\u0001\u0002)bi\"DqA!\u0016\u001c\u0001\u0004\u0011\t\u0007\u0005\u0003\u0003R\t\r\u0014\u0002\u0002B3\u0005'\u0012!BR5mKNK8\u000f^3n\u0003Aawn\\6va\u0006sGMU3ge\u0016\u001c\b\u000eF\u0004t\u0005W\u0012iGa\u001c\t\u000f\u0005=F\u00041\u0001\u0002v!9!Q\u000b\u000fA\u0002\t\u0005\u0004b\u0002B99\u0001\u0007!qJ\u0001\u000ecV\fG.\u001b4jK\u0012\u0004\u0016\r\u001e5\u00027I,gM]3tQ\u001aKG.Z%oI\u0016D\u0018J\u001a(fG\u0016\u001c8/\u0019:z)\u001d\u0019(q\u000fBD\u0005\u0013CqA!\u001f\u001e\u0001\u0004\u0011Y(A\u0005gS2,\u0017J\u001c3fqB!!Q\u0010BB\u001b\t\u0011yHC\u0002\u0003\u0002\u0002\n1\u0002Z1uCN|WO]2fg&!!Q\u0011B@\u0005%1\u0015\u000e\\3J]\u0012,\u0007\u0010C\u0004\u0003Vu\u0001\rA!\u0019\t\u000f\tET\u00041\u0001\u0003P\u0005yr-\u001a;Pe\u000ecwN\\3TKN\u001c\u0018n\u001c8XSRD7i\u001c8gS\u001e\u001cxJ\u001a4\u0015\t\u0005-$q\u0012\u0005\b\u0005#s\u0002\u0019AA6\u0003\u001d\u0019Xm]:j_:\u0004")
public class CacheManager
implements Logging,
AdaptiveSparkPlanHelper {
    private volatile transient IndexedSeq<CachedData> cachedData;
    private final Seq<ConfigEntry<Object>> forceDisableConfigs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Option<SparkPlan> find(SparkPlan p, Function1<SparkPlan, Object> f) {
        return AdaptiveSparkPlanHelper.find$(this, p, f);
    }

    @Override
    public void foreach(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreach$(this, p, f);
    }

    @Override
    public void foreachUp(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreachUp$(this, p, f);
    }

    @Override
    public <A> Seq<A> mapPlans(SparkPlan p, Function1<SparkPlan, A> f) {
        return AdaptiveSparkPlanHelper.mapPlans$(this, p, f);
    }

    @Override
    public <A> Seq<A> flatMap(SparkPlan p, Function1<SparkPlan, TraversableOnce<A>> f) {
        return AdaptiveSparkPlanHelper.flatMap$(this, p, f);
    }

    @Override
    public <B> Seq<B> collect(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collect$(this, p, pf);
    }

    @Override
    public Seq<SparkPlan> collectLeaves(SparkPlan p) {
        return AdaptiveSparkPlanHelper.collectLeaves$(this, p);
    }

    @Override
    public <B> Option<B> collectFirst(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collectFirst$(this, p, pf);
    }

    @Override
    public <B> Seq<B> collectWithSubqueries(SparkPlan p, PartialFunction<SparkPlan, B> f) {
        return AdaptiveSparkPlanHelper.collectWithSubqueries$(this, p, f);
    }

    @Override
    public Seq<SparkPlan> subqueriesAll(SparkPlan p) {
        return AdaptiveSparkPlanHelper.subqueriesAll$(this, p);
    }

    @Override
    public SparkPlan stripAQEPlan(SparkPlan p) {
        return AdaptiveSparkPlanHelper.stripAQEPlan$(this, p);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private IndexedSeq<CachedData> cachedData() {
        return this.cachedData;
    }

    private void cachedData_$eq(IndexedSeq<CachedData> x$1) {
        this.cachedData = x$1;
    }

    private Seq<ConfigEntry<Object>> forceDisableConfigs() {
        return this.forceDisableConfigs;
    }

    public synchronized void clearCache() {
        this.cachedData().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            CacheManager.$anonfun$clearCache$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)IndexedSeq$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    public boolean isEmpty() {
        return this.cachedData().isEmpty();
    }

    public void cacheQuery(Dataset<?> query, Option<String> tableName, StorageLevel storageLevel) {
        this.cacheQuery(query.sparkSession(), query.queryExecution().normalized(), tableName, storageLevel);
    }

    public void cacheQuery(SparkSession spark, LogicalPlan planToCache, Option<String> tableName) {
        this.cacheQuery(spark, planToCache, tableName, StorageLevel$.MODULE$.MEMORY_AND_DISK());
    }

    public void cacheQuery(SparkSession spark, LogicalPlan planToCache, Option<String> tableName, StorageLevel storageLevel) {
        if (this.lookupCachedData(planToCache).nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Asked to cache already cached data.");
            return;
        }
        SparkSession sessionWithConfigsOff = this.getOrCloneSessionWithConfigsOff(spark);
        InMemoryRelation inMemoryRelation = (InMemoryRelation)((Object)sessionWithConfigsOff.withActive((Function0 & Serializable & scala.Serializable)() -> {
            QueryExecution qe = sessionWithConfigsOff.sessionState().executePlan(planToCache, sessionWithConfigsOff.sessionState().executePlan$default$2());
            return InMemoryRelation$.MODULE$.apply(storageLevel, qe, tableName);
        }));
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            if (this.lookupCachedData(planToCache).nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Data has already been cached.");
            } else {
                CachedData cachedData = new CachedData(planToCache, inMemoryRelation);
                this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().$plus$colon((Object)cachedData, IndexedSeq$.MODULE$.canBuildFrom())));
            }
        }
    }

    public Option<String> cacheQuery$default$2() {
        return None$.MODULE$;
    }

    public StorageLevel cacheQuery$default$3() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade) {
        this.uncacheQuery(query.sparkSession(), query.queryExecution().normalized(), cascade, this.uncacheQuery$default$4());
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        this.uncacheQuery(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.sameResult((QueryPlan)plan)), cascade, blocking);
    }

    public void uncacheTableOrView(SparkSession spark, Seq<String> name, boolean cascade) {
        this.uncacheQuery(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)this.isMatchedTableOrView(x$4, (Seq<String>)name, spark.sessionState().conf())), cascade, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMatchedTableOrView(LogicalPlan plan, Seq<String> name, SQLConf conf) {
        boolean bl = false;
        SubqueryAlias subqueryAlias = null;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof SubqueryAlias) {
            LogicalRelation logicalRelation;
            Option<CatalogTable> option;
            bl = true;
            subqueryAlias = (SubqueryAlias)logicalPlan2;
            AliasIdentifier ident = subqueryAlias.identifier();
            LogicalPlan logicalPlan3 = subqueryAlias.child();
            if (logicalPlan3 instanceof LogicalRelation && (option = (logicalRelation = (LogicalRelation)logicalPlan3).catalogTable()) instanceof Some) {
                Some some = (Some)option;
                CatalogTable catalogTable = (CatalogTable)some.value();
                TableIdentifier v1Ident = catalogTable.identifier();
                if (!CacheManager.isSameName$1((Seq)ident.qualifier().$colon$plus((Object)ident.name(), Seq$.MODULE$.canBuildFrom()), name, conf)) return false;
                if (!CacheManager.isSameName$1((Seq)((SeqLike)Option$.MODULE$.option2Iterable(v1Ident.catalog()).toSeq().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(v1Ident.database()), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)v1Ident.table(), Seq$.MODULE$.canBuildFrom()), name, conf)) return false;
                return true;
            }
        }
        if (bl) {
            AliasIdentifier ident = subqueryAlias.identifier();
            LogicalPlan logicalPlan4 = subqueryAlias.child();
            if (logicalPlan4 instanceof DataSourceV2Relation) {
                DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)logicalPlan4;
                Option option = dataSourceV2Relation.catalog();
                Option option2 = dataSourceV2Relation.identifier();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    CatalogPlugin catalog = (CatalogPlugin)some.value();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        Identifier v2Ident = (Identifier)some2.value();
                        if (!CacheManager.isSameName$1((Seq)ident.qualifier().$colon$plus((Object)ident.name(), Seq$.MODULE$.canBuildFrom()), name, conf)) return false;
                        String string = catalog.name();
                        if (!CacheManager.isSameName$1((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])v2Ident.namespace())).$plus$colon((Object)string, ClassTag$.MODULE$.apply(String.class)))).$colon$plus((Object)v2Ident.name(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())), name, conf)) return false;
                        return true;
                    }
                }
            }
        }
        if (!bl) return false;
        AliasIdentifier ident = subqueryAlias.identifier();
        LogicalPlan logicalPlan5 = subqueryAlias.child();
        if (!(logicalPlan5 instanceof View)) return false;
        View view = (View)logicalPlan5;
        CatalogTable catalogTable = view.desc();
        TableIdentifier v1Ident = catalogTable.identifier();
        if (!CacheManager.isSameName$1((Seq)ident.qualifier().$colon$plus((Object)ident.name(), Seq$.MODULE$.canBuildFrom()), name, conf)) return false;
        if (!CacheManager.isSameName$1((Seq)((SeqLike)Option$.MODULE$.option2Iterable(v1Ident.catalog()).toSeq().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(v1Ident.database()), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)v1Ident.table(), Seq$.MODULE$.canBuildFrom()), name, conf)) return false;
        return true;
    }

    public void uncacheQuery(SparkSession spark, Function1<LogicalPlan, Object> isMatchedPlan, boolean cascade, boolean blocking) {
        Function1 & Serializable & scala.Serializable shouldRemove = cascade ? (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.exists(isMatchedPlan)) : isMatchedPlan;
        IndexedSeq plansToUncache = (IndexedSeq)this.cachedData().filter((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$3(shouldRemove, cd)));
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plansToUncache.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$5(cd, x$7)))))));
        }
        plansToUncache.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            CacheManager.$anonfun$uncacheQuery$6(blocking, x$8);
            return BoxedUnit.UNIT;
        });
        if (!cascade) {
            this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$7(isMatchedPlan, cd)));
            return;
        }
    }

    public boolean uncacheQuery$default$4() {
        return false;
    }

    public void analyzeColumnCacheQuery(SparkSession sparkSession, CachedData cachedData, Seq<Attribute> column) {
        InMemoryRelation relation = cachedData.cachedRepresentation();
        Tuple2<Object, Map<Attribute, ColumnStat>> tuple2 = CommandUtils$.MODULE$.computeColumnStats(sparkSession, relation, column);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long rowCount = tuple2._1$mcJ$sp();
        Map newColStats = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)newColStats);
        long rowCount2 = tuple22._1$mcJ$sp();
        Map newColStats2 = (Map)tuple22._2();
        relation.updateStats(rowCount2, (Map<Attribute, ColumnStat>)newColStats2);
    }

    public void recacheByPlan(SparkSession spark, LogicalPlan plan) {
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPlan$1(plan, x$10)));
    }

    private void recacheByCondition(SparkSession spark, Function1<CachedData, Object> condition) {
        IndexedSeq needToRecache = (IndexedSeq)this.cachedData().filter(condition);
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)needToRecache.exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByCondition$2(cd, x$12)))))));
        }
        needToRecache.foreach((Function1 & Serializable & scala.Serializable)cd -> {
            CacheManager.$anonfun$recacheByCondition$3(this, spark, cd);
            return BoxedUnit.UNIT;
        });
    }

    public Option<CachedData> lookupCachedData(Dataset<?> query) {
        return this.lookupCachedData(query.queryExecution().normalized());
    }

    public Option<CachedData> lookupCachedData(LogicalPlan plan) {
        return this.cachedData().find((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plan.sameResult((QueryPlan)cd.plan())));
    }

    public LogicalPlan useCachedData(LogicalPlan plan) {
        LogicalPlan newPlan = (LogicalPlan)plan.transformDown((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof IgnoreCachedData) {
                    IgnoreCachedData ignoreCachedData = (IgnoreCachedData)A1;
                    return (B1)ignoreCachedData;
                }
                return (B1)this.$outer.lookupCachedData(A1).map((Function1 & Serializable & scala.Serializable)cached -> {
                    Seq hints = (Seq)EliminateResolvedHint$.MODULE$.extractHintsFromPlan(A1)._2();
                    InMemoryRelation cachedPlan = cached.cachedRepresentation().withOutput((Seq<Attribute>)A1.output());
                    return (LogicalPlan)hints.foldRight((Object)((Object)cachedPlan), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 != null) {
                            HintInfo hint = (HintInfo)tuple2._1();
                            LogicalPlan p = (LogicalPlan)tuple2._2();
                            return new ResolvedHint(p, hint);
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> A1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                if (logicalPlan2 instanceof IgnoreCachedData) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.execution.CachedData ), $anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.HintInfo org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
        return newPlan.transformAllExpressionsWithPruning((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION())), newPlan.transformAllExpressionsWithPruning$default$2(), (PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    return (B1)subqueryExpression.withNewPlan(this.$outer.useCachedData((LogicalPlan)subqueryExpression.plan()));
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                return expression instanceof SubqueryExpression;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void recacheByPath(SparkSession spark, String resourcePath) {
        Path path = new Path(resourcePath);
        FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConf());
        this.recacheByPath(spark, path, fs);
    }

    public void recacheByPath(SparkSession spark, Path resourcePath, FileSystem fs) {
        Path qualifiedPath = fs.makeQualified(resourcePath);
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPath$1(this, fs, qualifiedPath, x$15)));
    }

    private boolean lookupAndRefresh(LogicalPlan plan, FileSystem fs, Path qualifiedPath) {
        DataSourceV2Relation dataSourceV2Relation;
        Table fileTable;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalRelation) {
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan2;
            BaseRelation baseRelation = logicalRelation.relation();
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                return this.refreshFileIndexIfNecessary(hadoopFsRelation.location(), fs, qualifiedPath);
            }
            return false;
        }
        if (logicalPlan2 instanceof DataSourceV2Relation && (fileTable = (dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2).table()) instanceof FileTable) {
            FileTable fileTable2 = (FileTable)fileTable;
            return this.refreshFileIndexIfNecessary(fileTable2.fileIndex(), fs, qualifiedPath);
        }
        return false;
    }

    private boolean refreshFileIndexIfNecessary(FileIndex fileIndex, FileSystem fs, Path qualifiedPath) {
        boolean needToRefresh;
        block0: {
            String prefixToInvalidate = qualifiedPath.toString();
            needToRefresh = ((IterableLike)fileIndex.rootPaths().map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString(), Seq$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.startsWith(prefixToInvalidate)));
            if (!needToRefresh) break block0;
            fileIndex.refresh();
        }
        return needToRefresh;
    }

    private SparkSession getOrCloneSessionWithConfigsOff(SparkSession session) {
        if (BoxesRunTime.unboxToBoolean(session.conf().get(SQLConf$.MODULE$.CAN_CHANGE_CACHED_PLAN_OUTPUT_PARTITIONING()))) {
            return session;
        }
        return SparkSession$.MODULE$.getOrCloneSessionWithConfigsOff(session, this.forceDisableConfigs());
    }

    public static final /* synthetic */ void $anonfun$clearCache$1(CachedData x$1) {
        x$1.cachedRepresentation().cacheBuilder().clearCache(x$1.cachedRepresentation().cacheBuilder().clearCache$default$1());
    }

    private static final boolean isSameName$1(Seq nameInCache, Seq name$2, SQLConf conf$1) {
        return nameInCache.length() == name$2.length() && ((IterableLike)nameInCache.zip((GenIterable)name$2, Seq$.MODULE$.canBuildFrom())).forall(conf$1.resolver().tupled());
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$3(Function1 shouldRemove$1, CachedData cd) {
        return BoxesRunTime.unboxToBoolean((Object)shouldRemove$1.apply((Object)cd.plan()));
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$5(CachedData cd$1, CachedData x$7) {
        return x$7 == cd$1;
    }

    public static final /* synthetic */ void $anonfun$uncacheQuery$6(boolean blocking$1, CachedData x$8) {
        x$8.cachedRepresentation().cacheBuilder().clearCache(blocking$1);
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$7(Function1 isMatchedPlan$1, CachedData cd) {
        boolean cacheAlreadyLoaded = cd.cachedRepresentation().cacheBuilder().isCachedColumnBuffersLoaded();
        return cd.plan().exists(isMatchedPlan$1) && !cacheAlreadyLoaded;
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPlan$1(LogicalPlan plan$2, CachedData x$10) {
        return x$10.plan().exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.sameResult((QueryPlan)plan$2)));
    }

    public static final /* synthetic */ boolean $anonfun$recacheByCondition$2(CachedData cd$2, CachedData x$12) {
        return x$12 == cd$2;
    }

    public static final /* synthetic */ void $anonfun$recacheByCondition$3(CacheManager $this, SparkSession spark$2, CachedData cd) {
        InMemoryRelation newCache;
        cd.cachedRepresentation().cacheBuilder().clearCache(cd.cachedRepresentation().cacheBuilder().clearCache$default$1());
        SparkSession sessionWithConfigsOff = $this.getOrCloneSessionWithConfigsOff(spark$2);
        InMemoryRelation x$1 = newCache = (InMemoryRelation)((Object)sessionWithConfigsOff.withActive((Function0 & Serializable & scala.Serializable)() -> {
            QueryExecution qe = sessionWithConfigsOff.sessionState().executePlan(cd.plan(), sessionWithConfigsOff.sessionState().executePlan$default$2());
            return InMemoryRelation$.MODULE$.apply(cd.cachedRepresentation().cacheBuilder(), qe);
        }));
        LogicalPlan x$2 = cd.copy$default$1();
        CachedData recomputedPlan = cd.copy(x$2, x$1);
        CacheManager cacheManager = $this;
        synchronized (cacheManager) {
            if ($this.lookupCachedData(recomputedPlan.plan()).nonEmpty()) {
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "While recaching, data was already added to cache.");
            } else {
                CachedData cachedData = recomputedPlan;
                $this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)$this.cachedData().$plus$colon((Object)cachedData, IndexedSeq$.MODULE$.canBuildFrom())));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPath$1(CacheManager $this, FileSystem fs$1, Path qualifiedPath$1, CachedData x$15) {
        return x$15.plan().exists((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)$this.lookupAndRefresh(x$16, fs$1, qualifiedPath$1)));
    }

    public CacheManager() {
        Logging.$init$((Logging)this);
        AdaptiveSparkPlanHelper.$init$(this);
        this.cachedData = (IndexedSeq)IndexedSeq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.forceDisableConfigs = (Seq)new .colon.colon((Object)SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED(), (List)new .colon.colon((Object)SQLConf$.MODULE$.AUTO_BUCKETED_SCAN_ENABLED(), (List)Nil$.MODULE$));
    }
}

