/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SchemaPruning$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.read.SupportsPushDownLimit;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.connector.read.SupportsPushDownTableSample;
import org.apache.spark.sql.connector.read.SupportsPushDownTopN;
import org.apache.spark.sql.connector.read.SupportsPushDownV2Filters;
import org.apache.spark.sql.execution.datasources.DataSourceStrategy$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Strategy$;
import org.apache.spark.sql.execution.datasources.v2.FileScanBuilder;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class PushDownUtils$
implements PredicateHelper {
    public static PushDownUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new PushDownUtils$();
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap2) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap2);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap2) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap2);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Tuple2<Either<Seq<Filter>, Seq<Predicate>>, Seq<Expression>> pushFilters(ScanBuilder scanBuilder, Seq<Expression> filters) {
        Tuple2 tuple2;
        ScanBuilder scanBuilder2 = scanBuilder;
        if (scanBuilder2 instanceof SupportsPushDownFilters) {
            SupportsPushDownFilters supportsPushDownFilters = (SupportsPushDownFilters)scanBuilder2;
            HashMap translatedFilterToExpr = HashMap$.MODULE$.empty();
            ArrayBuffer translatedFilters = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            ArrayBuffer untranslatableExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            filters.foreach((Function1 & Serializable & scala.Serializable)filterExpr -> {
                Option<Filter> translated = DataSourceStrategy$.MODULE$.translateFilterWithMapping((Expression)filterExpr, (Option<HashMap<Filter, Expression>>)new Some((Object)translatedFilterToExpr), true);
                return translated.isEmpty() ? untranslatableExprs.$plus$eq(filterExpr) : translatedFilters.$plus$eq(translated.get());
            });
            Expression[] postScanFilters = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])supportsPushDownFilters.pushFilters((Filter[])translatedFilters.toArray(ClassTag$.MODULE$.apply(Filter.class))))).map((Function1 & Serializable & scala.Serializable)filter -> DataSourceStrategy$.MODULE$.rebuildExpressionFromFilter((Filter)filter, (HashMap<Filter, Expression>)translatedFilterToExpr), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class)));
            tuple2 = new Tuple2((Object)package$.MODULE$.Left().apply((Object)Predef$.MODULE$.wrapRefArray((Object[])supportsPushDownFilters.pushedFilters())), (Object)untranslatableExprs.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])postScanFilters))).toSeq());
        } else if (scanBuilder2 instanceof SupportsPushDownV2Filters) {
            SupportsPushDownV2Filters supportsPushDownV2Filters = (SupportsPushDownV2Filters)scanBuilder2;
            HashMap translatedFilterToExpr = HashMap$.MODULE$.empty();
            ArrayBuffer translatedFilters = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            ArrayBuffer untranslatableExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            filters.foreach((Function1 & Serializable & scala.Serializable)filterExpr -> {
                Option<Predicate> translated = DataSourceV2Strategy$.MODULE$.translateFilterV2WithMapping((Expression)filterExpr, (Option<HashMap<Predicate, Expression>>)new Some((Object)translatedFilterToExpr), true);
                return translated.isEmpty() ? untranslatableExprs.$plus$eq(filterExpr) : translatedFilters.$plus$eq(translated.get());
            });
            Expression[] postScanFilters = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])supportsPushDownV2Filters.pushPredicates((Predicate[])translatedFilters.toArray(ClassTag$.MODULE$.apply(Predicate.class))))).map((Function1 & Serializable & scala.Serializable)predicate -> DataSourceV2Strategy$.MODULE$.rebuildExpressionFromFilter((Predicate)predicate, (HashMap<Predicate, Expression>)translatedFilterToExpr), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class)));
            tuple2 = new Tuple2((Object)package$.MODULE$.Right().apply((Object)Predef$.MODULE$.wrapRefArray((Object[])supportsPushDownV2Filters.pushedPredicates())), (Object)untranslatableExprs.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])postScanFilters))).toSeq());
        } else if (scanBuilder2 instanceof FileScanBuilder) {
            FileScanBuilder fileScanBuilder = (FileScanBuilder)scanBuilder2;
            Seq<Expression> postScanFilters = fileScanBuilder.pushFilters(filters);
            tuple2 = new Tuple2((Object)package$.MODULE$.Right().apply((Object)Predef$.MODULE$.wrapRefArray((Object[])fileScanBuilder.pushedFilters())), postScanFilters);
        } else {
            tuple2 = new Tuple2((Object)package$.MODULE$.Left().apply((Object)Nil$.MODULE$), filters);
        }
        return tuple2;
    }

    public boolean pushTableSample(ScanBuilder scanBuilder, TableSampleInfo sample) {
        boolean bl;
        ScanBuilder scanBuilder2 = scanBuilder;
        if (scanBuilder2 instanceof SupportsPushDownTableSample) {
            SupportsPushDownTableSample supportsPushDownTableSample = (SupportsPushDownTableSample)scanBuilder2;
            bl = supportsPushDownTableSample.pushTableSample(sample.lowerBound(), sample.upperBound(), sample.withReplacement(), sample.seed());
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean pushLimit(ScanBuilder scanBuilder, int limit) {
        boolean bl;
        ScanBuilder scanBuilder2 = scanBuilder;
        if (scanBuilder2 instanceof SupportsPushDownLimit) {
            SupportsPushDownLimit supportsPushDownLimit = (SupportsPushDownLimit)scanBuilder2;
            bl = supportsPushDownLimit.pushLimit(limit);
        } else {
            bl = false;
        }
        return bl;
    }

    public Tuple2<Object, Object> pushTopN(ScanBuilder scanBuilder, SortOrder[] order, int limit) {
        SupportsPushDownTopN supportsPushDownTopN;
        ScanBuilder scanBuilder2 = scanBuilder;
        Tuple2.mcZZ.sp sp2 = scanBuilder2 instanceof SupportsPushDownTopN && (supportsPushDownTopN = (SupportsPushDownTopN)scanBuilder2).pushTopN(order, limit) ? new Tuple2.mcZZ.sp(true, supportsPushDownTopN.isPartiallyPushed()) : new Tuple2.mcZZ.sp(false, false);
        return sp2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Scan, Seq<AttributeReference>> pruneColumns(ScanBuilder scanBuilder, DataSourceV2Relation relation, Seq<NamedExpression> projects, Seq<Expression> filters) {
        Seq exprs = (Seq)projects.$plus$plus(filters, Seq$.MODULE$.canBuildFrom());
        AttributeSet requiredColumns = AttributeSet$.MODULE$.apply((Iterable)exprs.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.references(), Seq$.MODULE$.canBuildFrom()));
        Seq neededOutput = (Seq)relation.output().filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)requiredColumns.contains(elem)));
        boolean bl = false;
        SupportsPushDownRequiredColumns supportsPushDownRequiredColumns = null;
        ScanBuilder scanBuilder2 = scanBuilder;
        if (scanBuilder2 instanceof SupportsPushDownRequiredColumns) {
            bl = true;
            supportsPushDownRequiredColumns = (SupportsPushDownRequiredColumns)scanBuilder2;
            if (SQLConf$.MODULE$.get().nestedSchemaPruningEnabled()) {
                Seq rootFields = SchemaPruning$.MODULE$.identifyRootFields(projects, filters);
                StructType prunedSchema = rootFields.nonEmpty() ? SchemaPruning$.MODULE$.pruneSchema(relation.schema(), rootFields) : new StructType();
                Set neededFieldNames = ((TraversableOnce)neededOutput.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Seq$.MODULE$.canBuildFrom())).toSet();
                supportsPushDownRequiredColumns.pruneColumns(StructType$.MODULE$.apply((Seq)prunedSchema.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)neededFieldNames.contains((Object)f.name())))));
                Scan scan = supportsPushDownRequiredColumns.build();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scan), this.toOutputAttrs(scan.readSchema(), relation));
            }
        }
        if (!bl) return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scanBuilder.build()), (Object)relation.output());
        supportsPushDownRequiredColumns.pruneColumns(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.AttributeSeq(neededOutput).toStructType());
        Scan scan = supportsPushDownRequiredColumns.build();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scan), this.toOutputAttrs(scan.readSchema(), relation));
    }

    public Seq<AttributeReference> toOutputAttrs(StructType schema, DataSourceV2Relation relation) {
        Map nameToAttr = ((TraversableOnce)((IterableLike)relation.output().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom())).zip((GenIterable)relation.output(), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        StructType cleaned = CharVarcharUtils$.MODULE$.replaceCharVarcharWithStringInSchema(schema);
        return (Seq)cleaned.toAttributes().map((Function1 & Serializable & scala.Serializable)a -> a.withExprId(((AttributeReference)nameToAttr.apply((Object)a.name())).exprId()), Seq$.MODULE$.canBuildFrom());
    }

    private PushDownUtils$() {
        MODULE$ = this;
        AliasHelper.$init$((AliasHelper)this);
        Logging.$init$((Logging)this);
        PredicateHelper.$init$((PredicateHelper)this);
    }
}

