/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.net.URI;
import java.time.ZoneOffset;
import java.util.Locale;
import java.util.TimeZone;
import javax.ws.rs.core.UriBuilder;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.parser.AstBuilder;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.ParserUtils$;
import org.apache.spark.sql.catalyst.parser.SqlBaseParser;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression;
import org.apache.spark.sql.catalyst.plans.logical.ScriptInputOutputSchema;
import org.apache.spark.sql.catalyst.plans.logical.SerdeInfo;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.execution.CodegenMode$;
import org.apache.spark.sql.execution.CostMode$;
import org.apache.spark.sql.execution.ExtendedMode$;
import org.apache.spark.sql.execution.FormattedMode$;
import org.apache.spark.sql.execution.SimpleMode$;
import org.apache.spark.sql.execution.command.AddFileCommand;
import org.apache.spark.sql.execution.command.AddJarCommand;
import org.apache.spark.sql.execution.command.CacheTableCommand;
import org.apache.spark.sql.execution.command.ClearCacheCommand$;
import org.apache.spark.sql.execution.command.CreateTableLikeCommand;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.DescribeQueryCommand;
import org.apache.spark.sql.execution.command.ExplainCommand;
import org.apache.spark.sql.execution.command.ListFilesCommand;
import org.apache.spark.sql.execution.command.ListFilesCommand$;
import org.apache.spark.sql.execution.command.ListJarsCommand;
import org.apache.spark.sql.execution.command.ListJarsCommand$;
import org.apache.spark.sql.execution.command.ResetCommand;
import org.apache.spark.sql.execution.command.SetCommand;
import org.apache.spark.sql.execution.command.UncacheTableCommand;
import org.apache.spark.sql.execution.datasources.CreateTempViewUsing;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.RefreshResource;
import org.apache.spark.sql.internal.HiveSerDe;
import org.apache.spark.sql.internal.HiveSerDe$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple8;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t\u0005f\u0001\u0002\u0012$\u00019BQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004H\u0001\u0001\u0006I!\u0010\u0005\b\u0011\u0002\u0011\r\u0011\"\u0003=\u0011\u0019I\u0005\u0001)A\u0005{!9!\n\u0001b\u0001\n\u0013a\u0004BB&\u0001A\u0003%Q\bC\u0003M\u0001\u0011\u0005S\nC\u0003o\u0001\u0011\u0005s\u000eC\u0003u\u0001\u0011\u0005S\u000fC\u0003{\u0001\u0011\u00053\u0010C\u0004\u0002\u0002\u0001!\t%a\u0001\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!9\u0011\u0011\u0004\u0001\u0005\n\u0005m\u0001bBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011\u001d\t9\u0005\u0001C!\u0003\u0013Bq!a\u0015\u0001\t\u0003\n)\u0006C\u0004\u0002`\u0001!\t%!\u0019\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n!9\u0011q\u0015\u0001\u0005B\u0005%\u0006bBAZ\u0001\u0011\u0005\u0013Q\u0017\u0005\b\u0003\u007f\u0003A\u0011IAa\u0011\u001d\ti\r\u0001C!\u0003\u001fDq!!7\u0001\t\u0003\nY\u000eC\u0004\u0002f\u0002!\t%a:\t\u000f\u0005E\b\u0001\"\u0003\u0002t\"9!1\u0004\u0001\u0005B\tu\u0001b\u0002B\u0014\u0001\u0011E#\u0011\u0006\u0005\b\u00053\u0002A\u0011\u000bB.\u0011\u001d\u0011I\b\u0001C!\u0005wBqA!$\u0001\t\u0003\u0012y\t\u0003\b\u0003\u001a\u0002\u0001\n1!A\u0001\n\u0013\u0011YJa(\u0003%M\u0003\u0018M]6Tc2\f5\u000f\u001e\"vS2$WM\u001d\u0006\u0003I\u0015\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u0019:\u0013aA:rY*\u0011\u0001&K\u0001\u0006gB\f'o\u001b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001y\u0003C\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0019\u0001\u0018M]:fe*\u0011A'J\u0001\tG\u0006$\u0018\r\\=ti&\u0011a'\r\u0002\u000b\u0003N$()^5mI\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001:!\tQ\u0004!D\u0001$\u0003E\u0019wN\u001c4jO.+\u0017PV1mk\u0016$UMZ\u000b\u0002{A\u0011a(R\u0007\u0002\u007f)\u0011\u0001)Q\u0001\t[\u0006$8\r[5oO*\u0011!iQ\u0001\u0005kRLGNC\u0001E\u0003\u0015\u00198-\u00197b\u0013\t1uHA\u0003SK\u001e,\u00070\u0001\nd_:4\u0017nZ&fsZ\u000bG.^3EK\u001a\u0004\u0013\u0001D2p]\u001aLwmS3z\t\u00164\u0017!D2p]\u001aLwmS3z\t\u00164\u0007%\u0001\bd_:4\u0017n\u001a,bYV,G)\u001a4\u0002\u001f\r|gNZ5h-\u0006dW/\u001a#fM\u0002\nQC^5tSR\u001cV\r^\"p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0002O-B\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\bY><\u0017nY1m\u0015\t\u00196'A\u0003qY\u0006t7/\u0003\u0002V!\nYAj\\4jG\u0006d\u0007\u000b\\1o\u0011\u00159\u0006\u00021\u0001Y\u0003\r\u0019G\u000f\u001f\t\u00033.t!AW5\u000f\u0005mCgB\u0001/h\u001d\tifM\u0004\u0002_K:\u0011q\f\u001a\b\u0003A\u000el\u0011!\u0019\u0006\u0003E6\na\u0001\u0010:p_Rt\u0014\"\u0001\u0017\n\u0005)Z\u0013B\u0001\u0015*\u0013\t1s%\u0003\u00025K%\u0011!gM\u0005\u0003UF\nQbU9m\u0005\u0006\u001cX\rU1sg\u0016\u0014\u0018B\u00017n\u0005]\u0019V\r^\"p]\u001aLw-\u001e:bi&|gnQ8oi\u0016DHO\u0003\u0002kc\u0005Yb/[:jiN+G/U;pi\u0016$7i\u001c8gS\u001e,(/\u0019;j_:$\"A\u00149\t\u000b]K\u0001\u0019A9\u0011\u0005e\u0013\u0018BA:n\u0005u\u0019V\r^)v_R,GmQ8oM&<WO]1uS>t7i\u001c8uKb$\u0018a\u0006<jg&$(+Z:fi\u000e{gNZ5hkJ\fG/[8o)\tqe\u000fC\u0003X\u0015\u0001\u0007q\u000f\u0005\u0002Zq&\u0011\u00110\u001c\u0002\u001a%\u0016\u001cX\r^\"p]\u001aLw-\u001e:bi&|gnQ8oi\u0016DH/A\u000fwSNLGOU3tKR\fVo\u001c;fI\u000e{gNZ5hkJ\fG/[8o)\tqE\u0010C\u0003X\u0017\u0001\u0007Q\u0010\u0005\u0002Z}&\u0011q0\u001c\u0002 %\u0016\u001cX\r^)v_R,GmQ8oM&<WO]1uS>t7i\u001c8uKb$\u0018\u0001\u0005<jg&$8+\u001a;US6,'l\u001c8f)\rq\u0015Q\u0001\u0005\u0007/2\u0001\r!a\u0002\u0011\u0007e\u000bI!C\u0002\u0002\f5\u0014!cU3u)&lWMW8oK\u000e{g\u000e^3yi\u0006!b/[:jiJ+gM]3tQJ+7o\\;sG\u0016$2ATA\t\u0011\u00199V\u00021\u0001\u0002\u0014A\u0019\u0011,!\u0006\n\u0007\u0005]QN\u0001\fSK\u001a\u0014Xm\u001d5SKN|WO]2f\u0007>tG/\u001a=u\u0003m)\u0007\u0010\u001e:bGR,f.];pi\u0016$'+Z:pkJ\u001cW\rU1uQR!\u0011QDA\u0017!\u0011\ty\"a\n\u000f\t\u0005\u0005\u00121\u0005\t\u0003A\u000eK1!!\nD\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011FA\u0016\u0005\u0019\u0019FO]5oO*\u0019\u0011QE\"\t\r]s\u0001\u0019AA\n\u0003=1\u0018n]5u\u0007\u0006\u001c\u0007.\u001a+bE2,Gc\u0001(\u00024!1qk\u0004a\u0001\u0003k\u00012!WA\u001c\u0013\r\tI$\u001c\u0002\u0012\u0007\u0006\u001c\u0007.\u001a+bE2,7i\u001c8uKb$\u0018!\u0005<jg&$XK\\2bG\",G+\u00192mKR\u0019a*a\u0010\t\r]\u0003\u0002\u0019AA!!\rI\u00161I\u0005\u0004\u0003\u000bj'aE+oG\u0006\u001c\u0007.\u001a+bE2,7i\u001c8uKb$\u0018a\u0004<jg&$8\t\\3be\u000e\u000b7\r[3\u0015\u00079\u000bY\u0005\u0003\u0004X#\u0001\u0007\u0011Q\n\t\u00043\u0006=\u0013bAA)[\n\t2\t\\3be\u000e\u000b7\r[3D_:$X\r\u001f;\u0002\u0019YL7/\u001b;FqBd\u0017-\u001b8\u0015\u00079\u000b9\u0006\u0003\u0004X%\u0001\u0007\u0011\u0011\f\t\u00043\u0006m\u0013bAA/[\nqQ\t\u001f9mC&t7i\u001c8uKb$\u0018A\u0005<jg&$H)Z:de&\u0014W-U;fef$2ATA2\u0011\u001996\u00031\u0001\u0002fA\u0019\u0011,a\u001a\n\u0007\u0005%TN\u0001\u000bEKN\u001c'/\u001b2f#V,'/_\"p]R,\u0007\u0010^\u0001\u0010i\u0006\u0014G.Z%eK:$\u0018NZ5feRA\u0011qNA<\u0003\u001b\u000b\t\n\u0005\u0003\u0002r\u0005MT\"A\u001a\n\u0007\u0005U4GA\bUC\ndW-\u00133f]RLg-[3s\u0011\u001d\tI\b\u0006a\u0001\u0003w\n\u0011\"\\;mi&\u0004\u0018M\u001d;\u0011\r\u0005u\u0014qQA\u000f\u001d\u0011\ty(a!\u000f\u0007\u0001\f\t)C\u0001E\u0013\r\t)iQ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI)a#\u0003\u0007M+\u0017OC\u0002\u0002\u0006\u000eCq!a$\u0015\u0001\u0004\ti\"A\u0004d_6l\u0017M\u001c3\t\r]#\u0002\u0019AAJ!\u0011\t)*a)\u000e\u0005\u0005]%\u0002BAM\u00037\u000bqA];oi&lWM\u0003\u0003\u0002\u001e\u0006}\u0015A\u0001<5\u0015\r\t\tkK\u0001\u0006C:$HN]\u0005\u0005\u0003K\u000b9JA\tQCJ\u001cXM\u001d*vY\u0016\u001cuN\u001c;fqR\f\u0001C^5tSR\u001c%/Z1uKR\u000b'\r\\3\u0015\u00079\u000bY\u000b\u0003\u0004X+\u0001\u0007\u0011Q\u0016\t\u00043\u0006=\u0016bAAY[\n\u00112I]3bi\u0016$\u0016M\u00197f\u0007>tG/\u001a=u\u0003a1\u0018n]5u\u0007J,\u0017\r^3UK6\u0004h+[3x+NLgn\u001a\u000b\u0004\u001d\u0006]\u0006BB,\u0017\u0001\u0004\tI\fE\u0002Z\u0003wK1!!0n\u0005i\u0019%/Z1uKR+W\u000e\u001d,jK^,6/\u001b8h\u0007>tG/\u001a=u\u0003]1\u0018n]5u\u001d\u0016\u001cH/\u001a3D_:\u001cH/\u00198u\u0019&\u001cH\u000f\u0006\u0003\u0002D\u0006\u0015\u0007CBA?\u0003\u000f\u000bY\b\u0003\u0004X/\u0001\u0007\u0011q\u0019\t\u00043\u0006%\u0017bAAf[\nIb*Z:uK\u0012\u001cuN\\:uC:$H*[:u\u0007>tG/\u001a=u\u0003E1\u0018n]5u\u0007>t7\u000f^1oi2K7\u000f\u001e\u000b\u0005\u0003w\n\t\u000e\u0003\u0004X1\u0001\u0007\u00111\u001b\t\u00043\u0006U\u0017bAAl[\n\u00192i\u001c8ti\u0006tG\u000fT5ti\u000e{g\u000e^3yi\u00061b/[:ji\u001a\u000b\u0017\u000e\u001c(bi&4XmQ8n[\u0006tG\rF\u0002O\u0003;DaaV\rA\u0002\u0005}\u0007cA-\u0002b&\u0019\u00111]7\u00031\u0019\u000b\u0017\u000e\u001c(bi&4XmQ8n[\u0006tGmQ8oi\u0016DH/A\nwSNLG/T1oC\u001e,'+Z:pkJ\u001cW\rF\u0002O\u0003SDaa\u0016\u000eA\u0002\u0005-\bcA-\u0002n&\u0019\u0011q^7\u0003+5\u000bg.Y4f%\u0016\u001cx.\u001e:dK\u000e{g\u000e^3yi\u0006yAo\\*u_J\fw-\u001a$pe6\fG\u000f\u0006\u0005\u0002v\n\u0005!Q\u0002B\r!\u0011\t90!@\u000e\u0005\u0005e(bAA~g\u000591-\u0019;bY><\u0017\u0002BA\u0000\u0003s\u0014AcQ1uC2|wm\u0015;pe\u0006<WMR8s[\u0006$\bb\u0002B\u00027\u0001\u0007!QA\u0001\tY>\u001c\u0017\r^5p]B1!q\u0001B\u0005\u0003;i\u0011aQ\u0005\u0004\u0005\u0017\u0019%AB(qi&|g\u000eC\u0004\u0003\u0010m\u0001\rA!\u0005\u0002\u001d5\f\u0017PY3TKJ$W-\u00138g_B1!q\u0001B\u0005\u0005'\u00012a\u0014B\u000b\u0013\r\u00119\u0002\u0015\u0002\n'\u0016\u0014H-Z%oM>DaaV\u000eA\u0002\u0005M\u0015\u0001\u0006<jg&$8I]3bi\u0016$\u0016M\u00197f\u0019&\\W\rF\u0002O\u0005?Aaa\u0016\u000fA\u0002\t\u0005\u0002cA-\u0003$%\u0019!QE7\u0003-\r\u0013X-\u0019;f)\u0006\u0014G.\u001a'jW\u0016\u001cuN\u001c;fqR\f!c^5uQN\u001b'/\u001b9u\u0013>\u001b6\r[3nCRq!1\u0006B\u0019\u0005g\u0011iDa\u0012\u0003L\t=\u0003cA(\u0003.%\u0019!q\u0006)\u0003/M\u001b'/\u001b9u\u0013:\u0004X\u000f^(viB,HoU2iK6\f\u0007BB,\u001e\u0001\u0004\t\u0019\nC\u0004\u00036u\u0001\rAa\u000e\u0002\u0017%t'k\\<G_Jl\u0017\r\u001e\t\u00043\ne\u0012b\u0001B\u001e[\n\u0001\"k\\<G_Jl\u0017\r^\"p]R,\u0007\u0010\u001e\u0005\b\u0005\u007fi\u0002\u0019\u0001B!\u00031\u0011XmY8sI^\u0013\u0018\u000e^3s!\u0011\t)Ja\u0011\n\t\t\u0015\u0013q\u0013\u0002\u0006)>\\WM\u001c\u0005\b\u0005\u0013j\u0002\u0019\u0001B\u001c\u00031yW\u000f\u001e*po\u001a{'/\\1u\u0011\u001d\u0011i%\ba\u0001\u0005\u0003\nAB]3d_J$'+Z1eKJDqA!\u0015\u001e\u0001\u0004\u0011\u0019&\u0001\u0006tG\",W.\u0019'fgN\u0004BAa\u0002\u0003V%\u0019!qK\"\u0003\u000f\t{w\u000e\\3b]\u0006Yr/\u001b;i%\u0016\u0004\u0018M\u001d;ji&|gNQ=FqB\u0014Xm]:j_:$rA\u0014B/\u0005K\u0012)\b\u0003\u0004X=\u0001\u0007!q\f\t\u00043\n\u0005\u0014b\u0001B2[\nA\u0012+^3ss>\u0013x-\u00198ju\u0006$\u0018n\u001c8D_:$X\r\u001f;\t\u000f\t\u001dd\u00041\u0001\u0003j\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t!\u0019\ti(a\"\u0003lA!!Q\u000eB9\u001b\t\u0011yGC\u0002\u0003hMJAAa\u001d\u0003p\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\r\t]d\u00041\u0001O\u0003\u0015\tX/\u001a:z\u0003]1\u0018n]5u\u0013:\u001cXM\u001d;Pm\u0016\u0014xO]5uK\u0012K'\u000f\u0006\u0003\u0003~\t\u0015\u0005\u0003\u0002B@\u0005\u0003k\u0011\u0001A\u0005\u0004\u0005\u0007+$aD%og\u0016\u0014H\u000fR5s!\u0006\u0014\u0018-\\:\t\r]{\u0002\u0019\u0001BD!\rI&\u0011R\u0005\u0004\u0005\u0017k'!G%og\u0016\u0014Ho\u0014<fe^\u0014\u0018\u000e^3ESJ\u001cuN\u001c;fqR\f1D^5tSRLen]3si>3XM]<sSR,\u0007*\u001b<f\t&\u0014H\u0003\u0002B?\u0005#Caa\u0016\u0011A\u0002\tM\u0005cA-\u0003\u0016&\u0019!qS7\u0003;%s7/\u001a:u\u001fZ,'o\u001e:ji\u0016D\u0015N^3ESJ\u001cuN\u001c;fqR\fac];qKJ$c/[:ji\u000e\u0013X-\u0019;f)\u0006\u0014G.\u001a\u000b\u0004\u001d\nu\u0005BB,\"\u0001\u0004\ti+C\u0002\u0002(V\u0002")
public class SparkSqlAstBuilder
extends AstBuilder {
    private final Regex configKeyValueDef = new StringOps(Predef$.MODULE$.augmentString("([a-zA-Z_\\d\\\\.:]+)\\s*=([^;]*);*")).r();
    private final Regex configKeyDef = new StringOps(Predef$.MODULE$.augmentString("([a-zA-Z_\\d\\\\.:]+)$")).r();
    private final Regex configValueDef = new StringOps(Predef$.MODULE$.augmentString("([^;]*);*")).r();

    private /* synthetic */ LogicalPlan super$visitCreateTable(SqlBaseParser.CreateTableContext ctx) {
        return super.visitCreateTable(ctx);
    }

    private Regex configKeyValueDef() {
        return this.configKeyValueDef;
    }

    private Regex configKeyDef() {
        return this.configKeyDef;
    }

    private Regex configValueDef() {
        return this.configValueDef;
    }

    public LogicalPlan visitSetConfiguration(SqlBaseParser.SetConfigurationContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            SetCommand setCommand;
            if (ctx.configKey() != null) {
                String keyStr = ctx.configKey().getText();
                if (ctx.EQ() != null) {
                    String string = ParserUtils$.MODULE$.remainder(ctx.EQ().getSymbol()).trim();
                    Option option = this.configValueDef().unapplySeq((CharSequence)string);
                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                        throw new ParseException(new StringBuilder(66).append("'").append(string).append("' is an invalid property ").append("value, please use quotes, e.g. SET `").append(keyStr).append("`=`").append(string).append("`").toString(), (ParserRuleContext)ctx);
                    }
                    String valueStr = (String)((LinearSeqOptimized)option.get()).apply(0);
                    SetCommand setCommand2 = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)keyStr), (Object)Option$.MODULE$.apply((Object)valueStr))));
                    setCommand = setCommand2;
                } else {
                    setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)keyStr), (Object)None$.MODULE$)));
                }
            } else {
                SetCommand setCommand3;
                String string = ParserUtils$.MODULE$.remainder(ctx.SET().getSymbol()).trim();
                Option option = this.configKeyValueDef().unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                    String key = (String)((LinearSeqOptimized)option.get()).apply(0);
                    String value = (String)((LinearSeqOptimized)option.get()).apply(1);
                    setCommand3 = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)Option$.MODULE$.apply((Object)value.trim()))));
                } else {
                    Option option2 = this.configKeyDef().unapplySeq((CharSequence)string);
                    if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                        String key = (String)((LinearSeqOptimized)option2.get()).apply(0);
                        setCommand3 = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)None$.MODULE$)));
                    } else {
                        String string2 = string;
                        String string3 = "-v";
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            setCommand3 = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-v"), (Object)None$.MODULE$)));
                        } else if (string.isEmpty()) {
                            setCommand3 = new SetCommand((Option<Tuple2<String, Option<String>>>)None$.MODULE$);
                        } else {
                            throw new ParseException("Expected format is 'SET', 'SET key', or 'SET key=value'. If you want to include special characters in key, or include semicolon in value, please use quotes, e.g., SET `ke y`=`v;alue`.", (ParserRuleContext)ctx);
                        }
                    }
                }
                setCommand = setCommand3;
            }
            return setCommand;
        });
    }

    public LogicalPlan visitSetQuotedConfiguration(SqlBaseParser.SetQuotedConfigurationContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            SetCommand setCommand;
            Predef$.MODULE$.assert(ctx.configValue() != null);
            if (ctx.configKey() != null) {
                setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ctx.configKey().getText()), (Object)Option$.MODULE$.apply((Object)ctx.configValue().getText()))));
            } else {
                String keyCandidate;
                String valueStr = ctx.configValue().getText();
                String string = keyCandidate = ParserUtils$.MODULE$.interval(ctx.SET().getSymbol(), ctx.EQ().getSymbol()).trim();
                Option option = this.configKeyDef().unapplySeq((CharSequence)string);
                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                    throw new ParseException(new StringBuilder(64).append("'").append(keyCandidate).append("' is an invalid property ").append("key, please use quotes, e.g. SET `").append(keyCandidate).append("`=`").append(valueStr).append("`").toString(), (ParserRuleContext)ctx);
                }
                String key = (String)((LinearSeqOptimized)option.get()).apply(0);
                SetCommand setCommand2 = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)Option$.MODULE$.apply((Object)valueStr))));
                setCommand = setCommand2;
            }
            return setCommand;
        });
    }

    public LogicalPlan visitResetConfiguration(SqlBaseParser.ResetConfigurationContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            ResetCommand resetCommand;
            String string = ParserUtils$.MODULE$.remainder(ctx.RESET().getSymbol()).trim();
            Option option = this.configKeyDef().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String key = (String)((LinearSeqOptimized)option.get()).apply(0);
                resetCommand = new ResetCommand((Option<String>)new Some((Object)key));
            } else if (string.trim().isEmpty()) {
                resetCommand = new ResetCommand((Option<String>)None$.MODULE$);
            } else {
                throw new ParseException("Expected format is 'RESET' or 'RESET key'. If you want to include special characters in key, please use quotes, e.g., RESET `ke y`.", (ParserRuleContext)ctx);
            }
            return resetCommand;
        });
    }

    public LogicalPlan visitResetQuotedConfiguration(SqlBaseParser.ResetQuotedConfigurationContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> new ResetCommand((Option<String>)new Some((Object)ctx.configKey().getText())));
    }

    public LogicalPlan visitSetTimeZone(SqlBaseParser.SetTimeZoneContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            SetCommand setCommand;
            String key = SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key();
            if (ctx.interval() != null) {
                CalendarInterval interval = this.parseIntervalLiteral(ctx.interval());
                if (interval.months != 0 || interval.days != 0 || package$.MODULE$.abs(interval.microseconds) > 64800000000L || interval.microseconds % 1000000L != 0L) {
                    throw new ParseException("The interval value must be in the range of [-18, +18] hours with second precision", (ParserRuleContext)ctx.interval());
                }
                int seconds = (int)(interval.microseconds / 1000000L);
                setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new Some((Object)ZoneOffset.ofTotalSeconds(seconds).toString()))));
            } else if (ctx$5.timezone != null) {
                int n = ctx$5.timezone.getType();
                switch (n) {
                    case 136: {
                        setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new Some((Object)TimeZone.getDefault().getID()))));
                        break;
                    }
                    default: {
                        setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new Some((Object)ParserUtils$.MODULE$.string(ctx.STRING())))));
                        break;
                    }
                }
            } else {
                throw new ParseException("Invalid time zone displacement value", (ParserRuleContext)ctx);
            }
            return setCommand;
        });
    }

    public LogicalPlan visitRefreshResource(SqlBaseParser.RefreshResourceContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            String path = ctx.STRING() != null ? ParserUtils$.MODULE$.string(ctx.STRING()) : this.extractUnquotedResourcePath(ctx);
            return new RefreshResource(path);
        });
    }

    private String extractUnquotedResourcePath(SqlBaseParser.RefreshResourceContext ctx) {
        return (String)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            String unquotedPath = ParserUtils$.MODULE$.remainder(ctx.REFRESH().getSymbol()).trim();
            ParserUtils$.MODULE$.validate((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> unquotedPath != null && !unquotedPath.isEmpty(), "Resource paths cannot be empty in REFRESH statements. Use / to match everything", (ParserRuleContext)ctx);
            Seq forbiddenSymbols = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", "\n", "\r", "\t"}));
            ParserUtils$.MODULE$.validate((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !forbiddenSymbols.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)unquotedPath.contains(x$1))), "REFRESH statements cannot contain ' ', '\\n', '\\r', '\\t' inside unquoted resource paths", (ParserRuleContext)ctx);
            return var1_1;
        });
    }

    public LogicalPlan visitCacheTable(SqlBaseParser.CacheTableContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            Option query = Option$.MODULE$.apply((Object)ctx.query()).map((Function1 & Serializable & scala.Serializable)tree -> this.plan((ParserRuleContext)tree));
            Seq tableName = this.visitMultipartIdentifier(ctx.multipartIdentifier());
            if (query.isDefined() && tableName.length() > 1) {
                Seq catalogAndNamespace = (Seq)tableName.init();
                throw new ParseException(new StringBuilder(93).append("It is not allowed to add catalog/namespace ").append("prefix ").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(catalogAndNamespace).quoted()).append(" to ").append("the table name in CACHE TABLE AS SELECT").toString(), (ParserRuleContext)ctx);
            }
            Option queryText = Option$.MODULE$.apply((Object)ctx.query()).map((Function1 & Serializable & scala.Serializable)x$2 -> ParserUtils$.MODULE$.source((ParserRuleContext)x$2));
            Map options = (Map)Option$.MODULE$.apply((Object)ctx$8.options).map((Function1 & Serializable & scala.Serializable)ctx -> this.visitPropertyKeyValues((SqlBaseParser.TablePropertyListContext)ctx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
            return new CacheTableCommand((Seq<String>)tableName, (Option<LogicalPlan>)query, (Option<String>)queryText, ctx.LAZY() != null, (Map<String, String>)options);
        });
    }

    public LogicalPlan visitUncacheTable(SqlBaseParser.UncacheTableContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> new UncacheTableCommand((Seq<String>)this.visitMultipartIdentifier(ctx.multipartIdentifier()), ctx.EXISTS() != null));
    }

    public LogicalPlan visitClearCache(SqlBaseParser.ClearCacheContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> ClearCacheCommand$.MODULE$);
    }

    public LogicalPlan visitExplain(SqlBaseParser.ExplainContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            if (ctx.LOGICAL() != null) {
                throw ParserUtils$.MODULE$.operationNotAllowed("EXPLAIN LOGICAL", (ParserRuleContext)ctx);
            }
            LogicalPlan statement = this.plan((ParserRuleContext)ctx.statement());
            return statement == null ? null : new ExplainCommand(statement, ctx.EXTENDED() != null ? ExtendedMode$.MODULE$ : (ctx.CODEGEN() != null ? CodegenMode$.MODULE$ : (ctx.COST() != null ? CostMode$.MODULE$ : (ctx.FORMATTED() != null ? FormattedMode$.MODULE$ : SimpleMode$.MODULE$))));
        });
    }

    public LogicalPlan visitDescribeQuery(SqlBaseParser.DescribeQueryContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> new DescribeQueryCommand(ParserUtils$.MODULE$.source((ParserRuleContext)ctx.query()), this.visitQuery(ctx.query())));
    }

    public TableIdentifier tableIdentifier(Seq<String> multipart, String command, ParserRuleContext ctx) {
        TableIdentifier tableIdentifier;
        Seq<String> seq = multipart;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            String tableName = (String)((SeqLike)some.get()).apply(0);
            tableIdentifier = TableIdentifier$.MODULE$.apply(tableName);
        } else {
            Some some2 = Seq$.MODULE$.unapplySeq(seq);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(2) == 0) {
                String database = (String)((SeqLike)some2.get()).apply(0);
                String tableName = (String)((SeqLike)some2.get()).apply(1);
                tableIdentifier = new TableIdentifier(tableName, (Option)new Some((Object)database));
            } else {
                throw ParserUtils$.MODULE$.operationNotAllowed(new StringBuilder(40).append(command).append(" does not support multi-part identifiers").toString(), ctx);
            }
        }
        return tableIdentifier;
    }

    public LogicalPlan visitCreateTable(SqlBaseParser.CreateTableContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            LogicalPlan logicalPlan2;
            Tuple4 tuple4 = this.visitCreateTableHeader(ctx.createTableHeader());
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            Seq ident = (Seq)tuple4._1();
            boolean temp = BoxesRunTime.unboxToBoolean((Object)tuple4._2());
            boolean ifNotExists = BoxesRunTime.unboxToBoolean((Object)tuple4._3());
            boolean external = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
            Tuple4 tuple42 = new Tuple4((Object)ident, (Object)BoxesRunTime.boxToBoolean((boolean)temp), (Object)BoxesRunTime.boxToBoolean((boolean)ifNotExists), (Object)BoxesRunTime.boxToBoolean((boolean)external));
            Tuple4 tuple43 = tuple42;
            Seq ident2 = (Seq)tuple43._1();
            boolean temp2 = BoxesRunTime.unboxToBoolean((Object)tuple43._2());
            boolean ifNotExists2 = BoxesRunTime.unboxToBoolean((Object)tuple43._3());
            boolean external2 = BoxesRunTime.unboxToBoolean((Object)tuple43._4());
            if (!temp2 || ctx.query() != null) {
                logicalPlan2 = this.super$visitCreateTable(ctx);
            } else {
                if (external2) {
                    throw ParserUtils$.MODULE$.operationNotAllowed("CREATE EXTERNAL TABLE ... USING", (ParserRuleContext)ctx);
                }
                if (ifNotExists2) {
                    throw ParserUtils$.MODULE$.operationNotAllowed("CREATE TEMPORARY TABLE IF NOT EXISTS", (ParserRuleContext)ctx);
                }
                Tuple8 tuple8 = this.visitCreateTableClauses(ctx.createTableClauses());
                if (tuple8 == null) {
                    throw new MatchError((Object)tuple8);
                }
                Map options = (Map)tuple8._5();
                Option location = (Option)tuple8._6();
                Tuple2 tuple2 = new Tuple2((Object)options, (Object)location);
                Tuple2 tuple22 = tuple2;
                Map options2 = (Map)tuple22._1();
                Option location2 = (Option)tuple22._2();
                String provider = (String)Option$.MODULE$.apply((Object)ctx.tableProvider()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.multipartIdentifier().getText()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new ParseException("CREATE TEMPORARY TABLE without a provider is not allowed.", (ParserRuleContext)ctx);
                });
                Option schema = Option$.MODULE$.apply((Object)ctx.colTypeList()).map((Function1 & Serializable & scala.Serializable)ctx -> this.createSchema((SqlBaseParser.ColTypeListContext)ctx));
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(106).append("CREATE TEMPORARY TABLE ... USING ... is deprecated, please use ").append("CREATE TEMPORARY VIEW ... USING ... instead").toString());
                TableIdentifier table = this.tableIdentifier((Seq<String>)ident2, "CREATE TEMPORARY VIEW", (ParserRuleContext)ctx);
                Map optionsWithLocation = (Map)location2.map((Function1 & Serializable & scala.Serializable)l -> options2.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), l))).getOrElse((Function0 & Serializable & scala.Serializable)() -> options2);
                logicalPlan2 = new CreateTempViewUsing(table, (Option<StructType>)schema, false, false, provider, (Map<String, String>)optionsWithLocation);
            }
            return logicalPlan2;
        });
    }

    public LogicalPlan visitCreateTempViewUsing(SqlBaseParser.CreateTempViewUsingContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> new CreateTempViewUsing(this.visitTableIdentifier(ctx.tableIdentifier()), (Option<StructType>)Option$.MODULE$.apply((Object)ctx.colTypeList()).map((Function1 & Serializable & scala.Serializable)ctx -> this.createSchema((SqlBaseParser.ColTypeListContext)ctx)), ctx.REPLACE() != null, ctx.GLOBAL() != null, ctx.tableProvider().multipartIdentifier().getText(), (Map<String, String>)((Map)Option$.MODULE$.apply((Object)ctx.tablePropertyList()).map((Function1 & Serializable & scala.Serializable)ctx -> this.visitPropertyKeyValues((SqlBaseParser.TablePropertyListContext)ctx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()))));
    }

    public Seq<Seq<String>> visitNestedConstantList(SqlBaseParser.NestedConstantListContext ctx) {
        return (Seq)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.constantList()).asScala()).map((Function1 & Serializable & scala.Serializable)ctx -> this.visitConstantList((SqlBaseParser.ConstantListContext)ctx), Buffer$.MODULE$.canBuildFrom())).toSeq());
    }

    public Seq<String> visitConstantList(SqlBaseParser.ConstantListContext ctx) {
        return (Seq)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.constant()).asScala()).map((Function1 & Serializable & scala.Serializable)v -> this.visitStringConstant((SqlBaseParser.ConstantContext)v, false), Buffer$.MODULE$.canBuildFrom())).toSeq());
    }

    public LogicalPlan visitFailNativeCommand(SqlBaseParser.FailNativeCommandContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            String keywords = ctx.unsupportedHiveNativeCommands() != null ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx$16.unsupportedHiveNativeCommands().children).asScala()).collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends ParseTree, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof TerminalNode) {
                        TerminalNode terminalNode = (TerminalNode)A1;
                        object = terminalNode.getText();
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(ParseTree x1) {
                    ParseTree parseTree = x1;
                    boolean bl = parseTree instanceof TerminalNode;
                    return bl;
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(" ") : "SET ROLE";
            return ParserUtils$.MODULE$.operationNotAllowed(keywords, (ParserRuleContext)ctx);
        });
    }

    public LogicalPlan visitManageResource(SqlBaseParser.ManageResourceContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            LogicalPlan logicalPlan2;
            String maybePaths = ctx.STRING() != null ? ParserUtils$.MODULE$.string(ctx.STRING()) : ParserUtils$.MODULE$.remainder((ParserRuleContext)ctx.identifier()).trim();
            int n = ctx$17.op.getType();
            switch (n) {
                case 12: {
                    LogicalPlan logicalPlan3;
                    String string = ctx.identifier().getText().toLowerCase(Locale.ROOT);
                    if ("file".equals(string)) {
                        logicalPlan3 = new AddFileCommand(maybePaths);
                    } else if ("jar".equals(string)) {
                        logicalPlan3 = new AddJarCommand(maybePaths);
                    } else {
                        throw ParserUtils$.MODULE$.operationNotAllowed(new StringBuilder(25).append("ADD with resource type '").append(string).append("'").toString(), (ParserRuleContext)ctx);
                    }
                    logicalPlan2 = logicalPlan3;
                    break;
                }
                case 134: {
                    LogicalPlan logicalPlan4;
                    String string = ctx.identifier().getText().toLowerCase(Locale.ROOT);
                    boolean bl = "files".equals(string) ? true : "file".equals(string);
                    if (bl) {
                        logicalPlan4 = maybePaths.length() > 0 ? new ListFilesCommand((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])maybePaths.split("\\s+"))) : new ListFilesCommand(ListFilesCommand$.MODULE$.apply$default$1());
                    } else {
                        boolean bl2 = "jars".equals(string) ? true : "jar".equals(string);
                        if (bl2) {
                            logicalPlan4 = maybePaths.length() > 0 ? new ListJarsCommand((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])maybePaths.split("\\s+"))) : new ListJarsCommand(ListJarsCommand$.MODULE$.apply$default$1());
                        } else {
                            throw ParserUtils$.MODULE$.operationNotAllowed(new StringBuilder(26).append("LIST with resource type '").append(string).append("'").toString(), (ParserRuleContext)ctx);
                        }
                    }
                    logicalPlan2 = logicalPlan4;
                    break;
                }
                default: {
                    throw ParserUtils$.MODULE$.operationNotAllowed("Other types of operation on resources", (ParserRuleContext)ctx);
                }
            }
            return logicalPlan2;
        });
    }

    private CatalogStorageFormat toStorageFormat(Option<String> location, Option<SerdeInfo> maybeSerdeInfo, ParserRuleContext ctx) {
        CatalogStorageFormat catalogStorageFormat;
        if (maybeSerdeInfo.isEmpty()) {
            catalogStorageFormat = CatalogStorageFormat$.MODULE$.empty().copy(location.map((Function1 & Serializable & scala.Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str)), CatalogStorageFormat$.MODULE$.empty().copy$default$2(), CatalogStorageFormat$.MODULE$.empty().copy$default$3(), CatalogStorageFormat$.MODULE$.empty().copy$default$4(), CatalogStorageFormat$.MODULE$.empty().copy$default$5(), CatalogStorageFormat$.MODULE$.empty().copy$default$6());
        } else {
            SerdeInfo serdeInfo = (SerdeInfo)maybeSerdeInfo.get();
            if (serdeInfo.storedAs().isEmpty()) {
                Option x$1 = location.map((Function1 & Serializable & scala.Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str));
                Option x$2 = serdeInfo.formatClasses().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.input());
                Option x$3 = serdeInfo.formatClasses().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.output());
                Option x$4 = serdeInfo.serde();
                Map x$5 = serdeInfo.serdeProperties();
                boolean x$62 = CatalogStorageFormat$.MODULE$.empty().copy$default$5();
                catalogStorageFormat = CatalogStorageFormat$.MODULE$.empty().copy(x$1, x$2, x$3, x$4, x$62, x$5);
            } else {
                Option<HiveSerDe> option = HiveSerDe$.MODULE$.sourceToSerDe((String)serdeInfo.storedAs().get());
                if (!(option instanceof Some)) {
                    throw ParserUtils$.MODULE$.operationNotAllowed(new StringBuilder(29).append("STORED AS with file format '").append(serdeInfo.storedAs().get()).append("'").toString(), ctx);
                }
                Some some = (Some)option;
                HiveSerDe hiveSerde = (HiveSerDe)some.value();
                Option x$72 = location.map((Function1 & Serializable & scala.Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str));
                Option<String> x$8 = hiveSerde.inputFormat();
                Option<String> x$9 = hiveSerde.outputFormat();
                Option x$10 = serdeInfo.serde().orElse((Function0 & Serializable & scala.Serializable)() -> hiveSerde.serde());
                Map x$11 = serdeInfo.serdeProperties();
                boolean x$12 = CatalogStorageFormat$.MODULE$.empty().copy$default$5();
                CatalogStorageFormat catalogStorageFormat2 = CatalogStorageFormat$.MODULE$.empty().copy(x$72, x$8, x$9, x$10, x$12, x$11);
                catalogStorageFormat = catalogStorageFormat2;
            }
        }
        return catalogStorageFormat;
    }

    public LogicalPlan visitCreateTableLike(SqlBaseParser.CreateTableLikeContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            Some some;
            SerdeInfo serdeInfo;
            TableIdentifier targetTable = this.visitTableIdentifier(ctx$18.target);
            TableIdentifier sourceTable = this.visitTableIdentifier(ctx$18.source);
            ParserUtils$.MODULE$.checkDuplicateClauses(ctx.tableProvider(), "PROVIDER", (ParserRuleContext)ctx);
            ParserUtils$.MODULE$.checkDuplicateClauses(ctx.createFileFormat(), "STORED AS/BY", (ParserRuleContext)ctx);
            ParserUtils$.MODULE$.checkDuplicateClauses(ctx.rowFormat(), "ROW FORMAT", (ParserRuleContext)ctx);
            ParserUtils$.MODULE$.checkDuplicateClauses(ctx.locationSpec(), "LOCATION", (ParserRuleContext)ctx);
            ParserUtils$.MODULE$.checkDuplicateClauses(ctx.TBLPROPERTIES(), "TBLPROPERTIES", (ParserRuleContext)ctx);
            Option provider = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.tableProvider()).asScala()).headOption().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.multipartIdentifier().getText());
            Option location = this.visitLocationSpecList(ctx.locationSpec());
            Option serdeInfo2 = this.getSerdeInfo(((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.rowFormat()).asScala()).toSeq(), ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.createFileFormat()).asScala()).toSeq(), (ParserRuleContext)ctx, true);
            if (provider.isDefined() && serdeInfo2.isDefined()) {
                throw ParserUtils$.MODULE$.operationNotAllowed(new StringBuilder(32).append("CREATE TABLE LIKE ... USING ... ").append(((SerdeInfo)serdeInfo2.get()).describe()).toString(), (ParserRuleContext)ctx);
            }
            Option option = serdeInfo2;
            if (option instanceof Some && (serdeInfo = (SerdeInfo)(some = (Some)option).value()) != null) {
                Option storedAs = serdeInfo.storedAs();
                Option formatClasses = serdeInfo.formatClasses();
                Option serde = serdeInfo.serde();
                if (storedAs.isEmpty() && formatClasses.isEmpty() && serde.isDefined()) {
                    throw new ParseException("'ROW FORMAT' must be used with 'STORED AS'", (ParserRuleContext)ctx);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            CatalogStorageFormat storage = this.toStorageFormat((Option<String>)location, (Option<SerdeInfo>)serdeInfo2, (ParserRuleContext)ctx);
            Map properties = (Map)Option$.MODULE$.apply((Object)ctx$18.tableProps).map((Function1 & Serializable & scala.Serializable)ctx -> this.visitPropertyKeyValues((SqlBaseParser.TablePropertyListContext)ctx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
            return new CreateTableLikeCommand(targetTable, sourceTable, storage, (Option<String>)provider, (Map<String, String>)properties, ctx.EXISTS() != null);
        });
    }

    public ScriptInputOutputSchema withScriptIOSchema(ParserRuleContext ctx, SqlBaseParser.RowFormatContext inRowFormat, Token recordWriter, SqlBaseParser.RowFormatContext outRowFormat, Token recordReader, boolean schemaLess) {
        if (recordWriter != null || recordReader != null) {
            throw new ParseException("Unsupported operation: Used defined record reader/writer classes.", ctx);
        }
        Tuple4 tuple4 = this.format$1(inRowFormat, "hive.script.recordreader", "org.apache.hadoop.hive.ql.exec.TextRecordReader");
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        Seq inFormat = (Seq)tuple4._1();
        Option inSerdeClass = (Option)tuple4._2();
        Seq inSerdeProps = (Seq)tuple4._3();
        Option reader = (Option)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)inFormat, (Object)inSerdeClass, (Object)inSerdeProps, (Object)reader);
        Tuple4 tuple43 = tuple42;
        Seq inFormat2 = (Seq)tuple43._1();
        Option inSerdeClass2 = (Option)tuple43._2();
        Seq inSerdeProps2 = (Seq)tuple43._3();
        Option reader2 = (Option)tuple43._4();
        Tuple4 tuple44 = this.format$1(outRowFormat, "hive.script.recordwriter", "org.apache.hadoop.hive.ql.exec.TextRecordWriter");
        if (tuple44 == null) {
            throw new MatchError((Object)tuple44);
        }
        Seq outFormat = (Seq)tuple44._1();
        Option outSerdeClass = (Option)tuple44._2();
        Seq outSerdeProps = (Seq)tuple44._3();
        Option writer = (Option)tuple44._4();
        Tuple4 tuple45 = new Tuple4((Object)outFormat, (Object)outSerdeClass, (Object)outSerdeProps, (Object)writer);
        Tuple4 tuple46 = tuple45;
        Seq outFormat2 = (Seq)tuple46._1();
        Option outSerdeClass2 = (Option)tuple46._2();
        Seq outSerdeProps2 = (Seq)tuple46._3();
        Option writer2 = (Option)tuple46._4();
        return new ScriptInputOutputSchema(inFormat2, outFormat2, inSerdeClass2, outSerdeClass2, inSerdeProps2, outSerdeProps2, reader2, writer2, schemaLess);
    }

    public LogicalPlan withRepartitionByExpression(SqlBaseParser.QueryOrganizationContext ctx, Seq<Expression> expressions, LogicalPlan query) {
        return new RepartitionByExpression(expressions, query, (Option)None$.MODULE$);
    }

    public Tuple3<Object, CatalogStorageFormat, Option<String>> visitInsertOverwriteDir(SqlBaseParser.InsertOverwriteDirContext ctx) {
        return (Tuple3)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            Map options = (Map)Option$.MODULE$.apply((Object)ctx$19.options).map((Function1 & Serializable & scala.Serializable)ctx -> this.visitPropertyKeyValues((SqlBaseParser.TablePropertyListContext)ctx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
            CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions((Map<String, String>)options);
            String path = (String)Option$.MODULE$.apply((Object)ctx$19.path).map((Function1 & Serializable & scala.Serializable)token -> ParserUtils$.MODULE$.string(token)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            if (!(path.isEmpty() ^ storage.locationUri().isEmpty())) {
                throw new ParseException("Directory path and 'path' in OPTIONS should be specified one, but not both", (ParserRuleContext)ctx);
            }
            if (!path.isEmpty()) {
                Some customLocation = new Some((Object)CatalogUtils$.MODULE$.stringToURI(path));
                CatalogStorageFormat qual$1 = storage;
                Some x$1 = customLocation;
                Option x$2 = qual$1.copy$default$2();
                Option x$3 = qual$1.copy$default$3();
                Option x$4 = qual$1.copy$default$4();
                boolean x$5 = qual$1.copy$default$5();
                Map x$6 = qual$1.copy$default$6();
                storage = qual$1.copy((Option)x$1, x$2, x$3, x$4, x$5, x$6);
            }
            if (ctx.LOCAL() != null) {
                Some some;
                String pathScheme;
                Option scheme = Option$.MODULE$.apply((Object)((URI)storage.locationUri().get()).getScheme());
                Option option = scheme;
                if (option instanceof Some && !(pathScheme = (String)(some = (Some)option).value()).equals("file")) {
                    throw new ParseException("LOCAL is supported only with file: scheme", (ParserRuleContext)ctx);
                }
                Some loc = new Some((Object)UriBuilder.fromUri((URI)CatalogUtils$.MODULE$.stringToURI(path)).scheme("file").build(new Object[0]));
                CatalogStorageFormat qual$2 = storage;
                Some x$7 = loc;
                Option x$8 = qual$2.copy$default$2();
                Option x$9 = qual$2.copy$default$3();
                Option x$10 = qual$2.copy$default$4();
                boolean x$11 = qual$2.copy$default$5();
                Map x$12 = qual$2.copy$default$6();
                storage = qual$2.copy((Option)x$7, x$8, x$9, x$10, x$11, x$12);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            String provider = ctx.tableProvider().multipartIdentifier().getText();
            return new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)storage, (Object)new Some((Object)provider));
        });
    }

    public Tuple3<Object, CatalogStorageFormat, Option<String>> visitInsertOverwriteHiveDir(SqlBaseParser.InsertOverwriteHiveDirContext ctx) {
        return (Tuple3)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            Option serdeInfo = this.getSerdeInfo(Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)ctx.rowFormat())).toSeq(), Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)ctx.createFileFormat())).toSeq(), (ParserRuleContext)ctx, this.getSerdeInfo$default$4());
            String path = ParserUtils$.MODULE$.string(ctx$20.path);
            if (path.isEmpty()) {
                throw ParserUtils$.MODULE$.operationNotAllowed("INSERT OVERWRITE DIRECTORY must be accompanied by path", (ParserRuleContext)ctx);
            }
            CatalogStorageFormat catalogStorageFormat = HiveSerDe$.MODULE$.getDefaultStorage(this.conf());
            CatalogStorageFormat storage = this.toStorageFormat((Option<String>)new Some((Object)path), (Option<SerdeInfo>)serdeInfo, (ParserRuleContext)ctx);
            Option x$1 = storage.inputFormat().orElse((Function0 & Serializable & scala.Serializable)() -> catalogStorageFormat.inputFormat());
            Option x$2 = storage.outputFormat().orElse((Function0 & Serializable & scala.Serializable)() -> catalogStorageFormat.outputFormat());
            Option x$3 = storage.serde().orElse((Function0 & Serializable & scala.Serializable)() -> catalogStorageFormat.serde());
            Option x$4 = storage.copy$default$1();
            boolean x$5 = storage.copy$default$5();
            Map x$6 = storage.copy$default$6();
            CatalogStorageFormat finalStorage = storage.copy(x$4, x$1, x$2, x$3, x$5, x$6);
            return new Tuple3((Object)BoxesRunTime.boxToBoolean((ctx.LOCAL() != null ? 1 : 0) != 0), (Object)finalStorage, (Object)new Some((Object)DDLUtils$.MODULE$.HIVE_PROVIDER()));
        });
    }

    private final Tuple4 format$1(SqlBaseParser.RowFormatContext fmt, String configKey, String defaultConfigValue) {
        Tuple4 tuple4;
        block6: {
            SqlBaseParser.RowFormatContext rowFormatContext;
            block7: {
                Map props;
                Option option;
                block9: {
                    SerdeInfo serdeInfo;
                    block8: {
                        block5: {
                            rowFormatContext = fmt;
                            if (!(rowFormatContext instanceof SqlBaseParser.RowFormatDelimitedContext)) break block5;
                            SqlBaseParser.RowFormatDelimitedContext rowFormatDelimitedContext = (SqlBaseParser.RowFormatDelimitedContext)rowFormatContext;
                            Seq entries = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)ParserUtils$.MODULE$.entry("TOK_TABLEROWFORMATFIELD", rowFormatDelimitedContext.fieldsTerminatedBy).$plus$plus((GenTraversableOnce)ParserUtils$.MODULE$.entry("TOK_TABLEROWFORMATCOLLITEMS", rowFormatDelimitedContext.collectionItemsTerminatedBy), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)ParserUtils$.MODULE$.entry("TOK_TABLEROWFORMATMAPKEYS", rowFormatDelimitedContext.keysTerminatedBy), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)ParserUtils$.MODULE$.entry("TOK_TABLEROWFORMATNULL", rowFormatDelimitedContext.nullDefinedAs), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)rowFormatDelimitedContext.linesSeparatedBy)).toSeq().map((Function1 & Serializable & scala.Serializable)token -> {
                                String value = ParserUtils$.MODULE$.string(token);
                                ParserUtils$.MODULE$.validate((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                                    String string = value;
                                    String string2 = "\n";
                                    return !(string != null ? !string.equals(string2) : string2 != null);
                                }, new StringBuilder(58).append("LINES TERMINATED BY only supports newline '\\n' right now: ").append(value).toString(), (ParserRuleContext)rowFormatDelimitedContext);
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TOK_TABLEROWFORMATLINES"), (Object)value);
                            }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                            tuple4 = new Tuple4((Object)entries, (Object)None$.MODULE$, (Object)Seq$.MODULE$.empty(), (Object)None$.MODULE$);
                            break block6;
                        }
                        if (!(rowFormatContext instanceof SqlBaseParser.RowFormatSerdeContext)) break block7;
                        SqlBaseParser.RowFormatSerdeContext rowFormatSerdeContext = (SqlBaseParser.RowFormatSerdeContext)rowFormatContext;
                        serdeInfo = this.visitRowFormatSerde(rowFormatSerdeContext);
                        if (serdeInfo == null) break block8;
                        Option option2 = serdeInfo.storedAs();
                        Option option3 = serdeInfo.formatClasses();
                        option = serdeInfo.serde();
                        props = serdeInfo.serdeProperties();
                        if (None$.MODULE$.equals(option2) && None$.MODULE$.equals(option3) && option instanceof Some) break block9;
                    }
                    throw new MatchError((Object)serdeInfo);
                }
                Some some = (Some)option;
                String name = (String)some.value();
                Tuple2 tuple2 = new Tuple2((Object)name, (Object)props);
                Tuple2 tuple22 = tuple2;
                String name2 = (String)tuple22._1();
                Map props2 = (Map)tuple22._2();
                String string = name2;
                String string2 = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
                None$ recordHandler = !(string != null ? !string.equals(string2) : string2 != null) ? Option$.MODULE$.apply((Object)this.conf().getConfString(configKey, defaultConfigValue)) : None$.MODULE$;
                tuple4 = new Tuple4((Object)Seq$.MODULE$.empty(), (Object)Option$.MODULE$.apply((Object)name2), (Object)props2.toSeq(), (Object)recordHandler);
                break block6;
            }
            if (rowFormatContext == null) {
                String name = this.conf().getConfString("hive.script.serde", "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
                Seq props = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"field.delim"), (Object)"\t"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"serialization.last.column.takes.rest"), (Object)"true")}));
                Option recordHandler = Option$.MODULE$.apply((Object)this.conf().getConfString(configKey, defaultConfigValue));
                tuple4 = new Tuple4((Object)Nil$.MODULE$, (Object)Option$.MODULE$.apply((Object)name), (Object)props, (Object)recordHandler);
            } else {
                throw new MatchError((Object)rowFormatContext);
            }
        }
        return tuple4;
    }
}

