/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.annotation.Stable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.json.JacksonParser$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsCatalogOptions;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.TextInputCSVDataSource$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation$;
import org.apache.spark.sql.execution.datasources.json.TextInputJsonDataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Stable
@ScalaSignature(bytes="\u0006\u0001\t=e\u0001\u0002\u00180\u0001aB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u0007\u0015\u0002!\taL&\t\u000b9\u0003A\u0011A(\t\u000bu\u0003A\u0011\u00010\t\u000bu\u0003A\u0011\u00014\t\u000b%\u0004A\u0011\u00016\t\u000b%\u0004A\u0011A8\t\u000b%\u0004A\u0011A;\t\u000b%\u0004A\u0011A>\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!9\u00111\u0001\u0001\u0005\u0002\u0005U\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003O\u0001A\u0011AA\u001d\u0011\u001d\t9\u0003\u0001C\u0001\u0003\u007fAq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002`\u0001!\t!!\u0019\t\u000f\u0005}\u0003\u0001\"\u0001\u0002v!9\u0011q\f\u0001\u0005\u0002\u0005U\u0005bBAT\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003O\u0003A\u0011AAW\u0011\u001d\t9\u000b\u0001C\u0001\u0003gCq!a*\u0001\t\u0003\t9\u000eC\u0004\u0002(\u0002!\t!!;\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9\u0011Q\u001f\u0001\u0005\u0002\u0005m\bbBA{\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005\u000f\u0001A\u0011\u0001B\u0005\u0011\u001d\u00119\u0001\u0001C\u0001\u0005\u001bAqAa\u0005\u0001\t\u0003\u0011)\u0002C\u0004\u0003\u0014\u0001!\tA!\u0007\t\u000f\u0005%\u0004\u0001\"\u0001\u0003 !9!Q\u0005\u0001\u0005\u0002\t\u001d\u0002b\u0002B\u0013\u0001\u0011\u0005!1\u0006\u0005\b\u0005c\u0001A\u0011\u0001B\u001a\u0011\u001d\u0011\t\u0004\u0001C\u0001\u0005oAqA!\u0010\u0001\t\u0013\u0011y\u0004\u0003\u0005R\u0001\u0001\u0007I\u0011\u0002B&\u0011%\u0011i\u0005\u0001a\u0001\n\u0013\u0011y\u0005C\u0004\u0003V\u0001\u0001\u000b\u0015\u0002*\t\u0013\t]\u0003\u00011A\u0005\n\te\u0003\"\u0003B1\u0001\u0001\u0007I\u0011\u0002B2\u0011!\u00119\u0007\u0001Q!\n\tm\u0003\"\u0003B5\u0001\u0001\u0007I\u0011\u0002B6\u0011%\u0011Y\b\u0001a\u0001\n\u0013\u0011i\b\u0003\u0005\u0003\u0002\u0002\u0001\u000b\u0015\u0002B7\u0005=!\u0015\r^1Ge\u0006lWMU3bI\u0016\u0014(B\u0001\u00192\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003eM\nQa\u001d9be.T!\u0001N\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0014aA8sO\u000e\u00011c\u0001\u0001:\u007fA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t1\u0011I\\=SK\u001a\u0004\"\u0001Q\"\u000e\u0003\u0005S!AQ\u0019\u0002\u0011%tG/\u001a:oC2L!\u0001R!\u0003\u000f1{wmZ5oO\u0006a1\u000f]1sWN+7o]5p]B\u0011q\tS\u0007\u0002_%\u0011\u0011j\f\u0002\r'B\f'o[*fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051k\u0005CA$\u0001\u0011\u0015)%\u00011\u0001G\u0003\u00191wN]7biR\u0011A\n\u0015\u0005\u0006#\u000e\u0001\rAU\u0001\u0007g>,(oY3\u0011\u0005MSfB\u0001+Y!\t)6(D\u0001W\u0015\t9v'\u0001\u0004=e>|GOP\u0005\u00033n\na\u0001\u0015:fI\u00164\u0017BA.]\u0005\u0019\u0019FO]5oO*\u0011\u0011lO\u0001\u0007g\u000eDW-\\1\u0015\u00051{\u0006\"B/\u0005\u0001\u0004\u0001\u0007CA1e\u001b\u0005\u0011'BA20\u0003\u0015!\u0018\u0010]3t\u0013\t)'M\u0001\u0006TiJ,8\r\u001e+za\u0016$\"\u0001T4\t\u000b!,\u0001\u0019\u0001*\u0002\u0019M\u001c\u0007.Z7b'R\u0014\u0018N\\4\u0002\r=\u0004H/[8o)\ra5.\u001c\u0005\u0006Y\u001a\u0001\rAU\u0001\u0004W\u0016L\b\"\u00028\u0007\u0001\u0004\u0011\u0016!\u0002<bYV,Gc\u0001'qc\")An\u0002a\u0001%\")an\u0002a\u0001eB\u0011!h]\u0005\u0003in\u0012qAQ8pY\u0016\fg\u000eF\u0002Mm^DQ\u0001\u001c\u0005A\u0002ICQA\u001c\u0005A\u0002a\u0004\"AO=\n\u0005i\\$\u0001\u0002'p]\u001e$2\u0001\u0014?~\u0011\u0015a\u0017\u00021\u0001S\u0011\u0015q\u0017\u00021\u0001\u007f!\tQt0C\u0002\u0002\u0002m\u0012a\u0001R8vE2,\u0017aB8qi&|gn\u001d\u000b\u0004\u0019\u0006\u001d\u0001bBA\u0002\u0015\u0001\u0007\u0011\u0011\u0002\t\u0007\u0003\u0017\t\tB\u0015*\u000e\u0005\u00055!bAA\bw\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0011Q\u0002\u0002\u0004\u001b\u0006\u0004Hc\u0001'\u0002\u0018!9\u00111A\u0006A\u0002\u0005e\u0001CBA\u000e\u0003K\u0011&+\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u0011)H/\u001b7\u000b\u0005\u0005\r\u0012\u0001\u00026bm\u0006LA!a\u0005\u0002\u001e\u0005!An\\1e)\t\tY\u0003\u0005\u0003\u0002.\u0005MbbA$\u00020%\u0019\u0011\u0011G\u0018\u0002\u000fA\f7m[1hK&!\u0011QGA\u001c\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u00022=\"B!a\u000b\u0002<!1\u0011QH\u0007A\u0002I\u000bA\u0001]1uQR!\u00111FA!\u0011\u001d\t\u0019E\u0004a\u0001\u0003\u000b\nQ\u0001]1uQN\u0004BAOA$%&\u0019\u0011\u0011J\u001e\u0003\u0015q\u0012X\r]3bi\u0016$g\bK\u0002\u000f\u0003\u001b\u0002B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'Z\u0014AC1o]>$\u0018\r^5p]&!\u0011qKA)\u0005\u001d1\u0018M]1sON\fA\u0002\\8bIZ\u000b4k\\;sG\u0016$B!a\u000b\u0002^!9\u00111I\bA\u0002\u0005\u0015\u0013\u0001\u00026eE\u000e$\u0002\"a\u000b\u0002d\u0005\u001d\u00141\u000e\u0005\u0007\u0003K\u0002\u0002\u0019\u0001*\u0002\u0007U\u0014H\u000e\u0003\u0004\u0002jA\u0001\rAU\u0001\u0006i\u0006\u0014G.\u001a\u0005\b\u0003[\u0002\u0002\u0019AA8\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0005\u00037\t\t(\u0003\u0003\u0002t\u0005u!A\u0003)s_B,'\u000f^5fgR\u0001\u00121FA<\u0003s\nY(a \u0002\u0004\u0006\u001d\u0015\u0011\u0013\u0005\u0007\u0003K\n\u0002\u0019\u0001*\t\r\u0005%\u0014\u00031\u0001S\u0011\u0019\ti(\u0005a\u0001%\u0006Q1m\u001c7v[:t\u0015-\\3\t\r\u0005\u0005\u0015\u00031\u0001y\u0003)awn^3s\u0005>,h\u000e\u001a\u0005\u0007\u0003\u000b\u000b\u0002\u0019\u0001=\u0002\u0015U\u0004\b/\u001a:C_VtG\rC\u0004\u0002\nF\u0001\r!a#\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t!\rQ\u0014QR\u0005\u0004\u0003\u001f[$aA%oi\"9\u00111S\tA\u0002\u0005=\u0014\u0001F2p]:,7\r^5p]B\u0013x\u000e]3si&,7\u000f\u0006\u0006\u0002,\u0005]\u0015\u0011TAN\u0003KCa!!\u001a\u0013\u0001\u0004\u0011\u0006BBA5%\u0001\u0007!\u000bC\u0004\u0002\u001eJ\u0001\r!a(\u0002\u0015A\u0014X\rZ5dCR,7\u000f\u0005\u0003;\u0003C\u0013\u0016bAARw\t)\u0011I\u001d:bs\"9\u00111\u0013\nA\u0002\u0005=\u0014\u0001\u00026t_:$B!a\u000b\u0002,\"1\u0011QH\nA\u0002I#B!a\u000b\u00020\"9\u00111\t\u000bA\u0002\u0005\u0015\u0003f\u0001\u000b\u0002NQ!\u00111FA[\u0011\u001d\t9,\u0006a\u0001\u0003s\u000bqA[:p]J#E\tE\u0003\u0002<\u0006\r'+\u0004\u0002\u0002>*!\u00111EA`\u0015\r\t\t-M\u0001\u0004CBL\u0017\u0002BAc\u0003{\u0013qAS1wCJ#E\tK\u0004\u0016\u0003\u0013\fy-a5\u0011\u0007i\nY-C\u0002\u0002Nn\u0012!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\t\t.\u0001\u0012Vg\u0016\u0004#n]8oQ\u0011\u000bG/Y:fin\u001bFO]5oOvK\u0003%\u001b8ti\u0016\fGML\u0011\u0003\u0003+\fQA\r\u00183]A\"B!a\u000b\u0002Z\"9\u0011q\u0017\fA\u0002\u0005m\u0007#BAo\u0003G\u0014VBAAp\u0015\r\t\t/M\u0001\u0004e\u0012$\u0017\u0002BAs\u0003?\u00141A\u0015#EQ\u001d1\u0012\u0011ZAh\u0003'$B!a\u000b\u0002l\"9\u0011Q^\fA\u0002\u0005=\u0018a\u00036t_:$\u0015\r^1tKR\u0004BaRAy%&\u0019\u00111_\u0018\u0003\u000f\u0011\u000bG/Y:fi\u0006\u00191m\u001d<\u0015\t\u0005-\u0012\u0011 \u0005\u0007\u0003{A\u0002\u0019\u0001*\u0015\t\u0005-\u0012Q \u0005\b\u0003\u007fL\u0002\u0019AAx\u0003)\u00197O\u001e#bi\u0006\u001cX\r\u001e\u000b\u0005\u0003W\u0011\u0019\u0001C\u0004\u0002Di\u0001\r!!\u0012)\u0007i\ti%A\u0004qCJ\fX/\u001a;\u0015\t\u0005-\"1\u0002\u0005\u0007\u0003{Y\u0002\u0019\u0001*\u0015\t\u0005-\"q\u0002\u0005\b\u0003\u0007b\u0002\u0019AA#Q\ra\u0012QJ\u0001\u0004_J\u001cG\u0003BA\u0016\u0005/Aa!!\u0010\u001e\u0001\u0004\u0011F\u0003BA\u0016\u00057Aq!a\u0011\u001f\u0001\u0004\t)\u0005K\u0002\u001f\u0003\u001b\"B!a\u000b\u0003\"!1!1E\u0010A\u0002I\u000b\u0011\u0002^1cY\u0016t\u0015-\\3\u0002\tQ,\u0007\u0010\u001e\u000b\u0005\u0003W\u0011I\u0003\u0003\u0004\u0002>\u0001\u0002\rA\u0015\u000b\u0005\u0003W\u0011i\u0003C\u0004\u0002D\u0005\u0002\r!!\u0012)\u0007\u0005\ni%\u0001\u0005uKb$h)\u001b7f)\u0011\tyO!\u000e\t\r\u0005u\"\u00051\u0001S)\u0011\tyO!\u000f\t\u000f\u0005\r3\u00051\u0001\u0002F!\u001a1%!\u0014\u0002/\u0005\u001c8/\u001a:u\u001d>\u001c\u0006/Z2jM&,GmU2iK6\fG\u0003\u0002B!\u0005\u000f\u00022A\u000fB\"\u0013\r\u0011)e\u000f\u0002\u0005+:LG\u000f\u0003\u0004\u0003J\u0011\u0002\rAU\u0001\n_B,'/\u0019;j_:,\u0012AU\u0001\u000bg>,(oY3`I\u0015\fH\u0003\u0002B!\u0005#B\u0001Ba\u0015'\u0003\u0003\u0005\rAU\u0001\u0004q\u0012\n\u0014aB:pkJ\u001cW\rI\u0001\u0014kN,'o\u00159fG&4\u0017.\u001a3TG\",W.Y\u000b\u0003\u00057\u0002BA\u000fB/A&\u0019!qL\u001e\u0003\r=\u0003H/[8o\u0003])8/\u001a:Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7b?\u0012*\u0017\u000f\u0006\u0003\u0003B\t\u0015\u0004\"\u0003B*S\u0005\u0005\t\u0019\u0001B.\u0003Q)8/\u001a:Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7bA\u0005aQ\r\u001f;sC>\u0003H/[8ogV\u0011!Q\u000e\t\u0006\u0005_\u00129HU\u0007\u0003\u0005cRA!a\b\u0003t)\u0019!QO\u0018\u0002\u0011\r\fG/\u00197zgRLAA!\u001f\u0003r\t\u00112)Y:f\u0013:\u001cXM\\:ji&4X-T1q\u0003A)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u0003B\t}\u0004\"\u0003B*Y\u0005\u0005\t\u0019\u0001B7\u00035)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8tA!\u001a\u0001A!\"\u0011\t\t\u001d%1R\u0007\u0003\u0005\u0013S1!a\u00152\u0013\u0011\u0011iI!#\u0003\rM#\u0018M\u00197f\u0001")
public class DataFrameReader
implements Logging {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private CaseInsensitiveMap<String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Dataset<Row> load(String ... paths) {
        return this.load((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> json(String ... paths) {
        return this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> csv(String ... paths) {
        return this.csv((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> parquet(String ... paths) {
        return this.parquet((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> orc(String ... paths) {
        return this.orc((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> text(String ... paths) {
        return this.text((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<String> textFile(String ... paths) {
        return this.textFile((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrameReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameReader schema(StructType schema) {
        block0: {
            if (schema == null) break block0;
            StructType replaced = (StructType)CharVarcharUtils$.MODULE$.failIfHasCharVarchar((DataType)schema);
            this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)replaced));
        }
        return this;
    }

    public DataFrameReader schema(String schemaString) {
        return this.schema(StructType$.MODULE$.fromDDL(schemaString));
    }

    public DataFrameReader option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataFrameReader option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameReader option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameReader option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameReader options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataFrameReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public Dataset<Row> load() {
        return this.load((Seq<String>)((Seq)Seq$.MODULE$.empty()));
    }

    public Dataset<Row> load(String path) {
        return this.sparkSession.sessionState().conf().legacyPathOptionBehavior() ? this.option("path", path).load((Seq<String>)((Seq)Seq$.MODULE$.empty())) : this.load((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> load(Seq<String> paths) {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not read files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        boolean legacyPathOptionBehavior = this.sparkSession.sessionState().conf().legacyPathOptionBehavior();
        if (!legacyPathOptionBehavior && (this.extraOptions().contains("path") || this.extraOptions().contains("paths")) && paths.nonEmpty()) {
            throw new AnalysisException(new StringBuilder(265).append("There is a 'path' or 'paths' option set and load() is called with path parameters. Either remove the path option if it's the same as the path parameter, or add it to the load() parameter if you do want to read multiple paths. ").append("To ignore this check, set '").append(SQLConf$.MODULE$.LEGACY_PATH_OPTION_BEHAVIOR().key()).append("' to 'true'.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return (Dataset)DataSource$.MODULE$.lookupDataSourceV2(this.source(), this.sparkSession.sessionState().conf()).map((Function1 & Serializable & scala.Serializable)provider -> {
            Tuple3 tuple3;
            CaseInsensitiveMap caseInsensitiveMap;
            CatalogManager catalogManager = $this.sparkSession.sessionState().catalogManager();
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs((TableProvider)provider, $this.sparkSession.sessionState().conf());
            if (paths.isEmpty()) {
                caseInsensitiveMap = this.extraOptions();
            } else if (paths.length() == 1) {
                caseInsensitiveMap = this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), paths.head()));
            } else {
                ObjectMapper objectMapper = new ObjectMapper();
                caseInsensitiveMap = this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paths"), (Object)objectMapper.writeValueAsString(paths.toArray(ClassTag$.MODULE$.apply(String.class)))));
            }
            CaseInsensitiveMap optionsWithPath = caseInsensitiveMap;
            scala.collection.immutable.Map finalOptions = sessionOptions.filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$load$2(optionsWithPath, x$1))).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)optionsWithPath.originalMap());
            CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)finalOptions).asJava());
            boolean bl = false;
            SupportsCatalogOptions supportsCatalogOptions = null;
            TableProvider tableProvider = provider;
            if (tableProvider instanceof SupportsCatalogOptions) {
                bl = true;
                supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
                if (this.userSpecifiedSchema().nonEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(73).append(this.source()).append(" does not support user specified schema. Please don't specify the schema.").toString());
                }
            }
            if (bl) {
                Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
                TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
                tuple3 = new Tuple3((Object)catalog.loadTable(ident), (Object)new Some((Object)catalog), (Object)new Some((Object)ident));
            } else {
                Table tbl = DataSourceV2Utils$.MODULE$.getTableFromProvider((TableProvider)provider, dsOptions, this.userSpecifiedSchema());
                tuple3 = new Tuple3((Object)tbl, (Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            Tuple3 tuple32 = tuple3;
            if (tuple32 == null) {
                throw new MatchError((Object)tuple32);
            }
            Table table = (Table)tuple32._1();
            Option catalog = (Option)tuple32._2();
            Option ident = (Option)tuple32._3();
            Tuple3 tuple33 = new Tuple3((Object)table, (Object)catalog, (Object)ident);
            Tuple3 tuple34 = tuple33;
            Table table2 = (Table)tuple34._1();
            Option catalog2 = (Option)tuple34._2();
            Option ident2 = (Option)tuple34._3();
            Table table3 = table2;
            Dataset<Row> dataset = table3 instanceof SupportsRead && DataSourceV2Implicits$.MODULE$.TableHelper(table2).supports(TableCapability.BATCH_READ) ? Dataset$.MODULE$.ofRows($this.sparkSession, (LogicalPlan)DataSourceV2Relation$.MODULE$.create(table2, catalog2, ident2, dsOptions)) : this.loadV1Source(paths);
            return dataset;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.loadV1Source(paths));
    }

    private Dataset<Row> loadV1Source(Seq<String> paths) {
        Tuple2 tuple2;
        boolean legacyPathOptionBehavior = this.sparkSession.sessionState().conf().legacyPathOptionBehavior();
        Tuple2 tuple22 = tuple2 = !legacyPathOptionBehavior && paths.length() == 1 ? new Tuple2((Object)Nil$.MODULE$, (Object)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), paths.head()))) : new Tuple2(paths, this.extraOptions());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq finalPaths = (Seq)tuple2._1();
        CaseInsensitiveMap finalOptions = (CaseInsensitiveMap)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)finalPaths, (Object)finalOptions);
        Tuple2 tuple24 = tuple23;
        Seq finalPaths2 = (Seq)tuple24._1();
        CaseInsensitiveMap finalOptions2 = (CaseInsensitiveMap)tuple24._2();
        SparkSession x$1 = this.sparkSession;
        Seq x$2 = finalPaths2;
        Option<StructType> x$3 = this.userSpecifiedSchema();
        String x$4 = this.source();
        scala.collection.immutable.Map x$5 = finalOptions2.originalMap();
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource qual$1 = new DataSource(x$1, x$4, (Seq<String>)x$2, x$3, x$6, x$7, (scala.collection.immutable.Map<String, String>)x$5, x$8);
        boolean x$9 = qual$1.resolveRelation$default$1();
        return this.sparkSession.baseRelationToDataFrame(qual$1.resolveRelation(x$9));
    }

    public Dataset<Row> jdbc(String url, String table, Properties properties) {
        this.assertNoSpecifiedSchema("jdbc");
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(properties).asScala()));
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_URL()), (Object)url), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)table)}))));
        return this.format("jdbc").load();
    }

    public Dataset<Row> jdbc(String url, String table, String columnName, long lowerBound, long upperBound, int numPartitions, Properties connectionProperties) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_PARTITION_COLUMN()), (Object)columnName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_LOWER_BOUND()), (Object)((Object)BoxesRunTime.boxToLong((long)lowerBound)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_UPPER_BOUND()), (Object)((Object)BoxesRunTime.boxToLong((long)upperBound)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_NUM_PARTITIONS()), (Object)((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString())}))));
        return this.jdbc(url, table, connectionProperties);
    }

    public Dataset<Row> jdbc(String url, String table, String[] predicates, Properties connectionProperties) {
        this.assertNoSpecifiedSchema("jdbc");
        CaseInsensitiveMap params = this.extraOptions().$plus$plus((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala());
        JDBCOptions options = new JDBCOptions(url, table, (scala.collection.immutable.Map<String, String>)params);
        Partition[] parts = (Partition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicates)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String part = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            JDBCPartition jDBCPartition = new JDBCPartition(part, i);
            return jDBCPartition;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Partition.class)));
        JDBCRelation relation = JDBCRelation$.MODULE$.apply(parts, options, this.sparkSession);
        return this.sparkSession.baseRelationToDataFrame(relation);
    }

    public Dataset<Row> json(String path) {
        return this.json((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> json(Seq<String> paths) {
        return this.format("json").load(paths);
    }

    public Dataset<Row> json(JavaRDD<String> jsonRDD) {
        return this.json((RDD<String>)jsonRDD.rdd());
    }

    public Dataset<Row> json(RDD<String> jsonRDD) {
        return this.json(this.sparkSession.createDataset(jsonRDD, Encoders$.MODULE$.STRING()));
    }

    public Dataset<Row> json(Dataset<String> jsonDataset) {
        JSONOptions parsedOptions = new JSONOptions(this.extraOptions().toMap(), this.sparkSession.sessionState().conf().sessionLocalTimeZone(), this.sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        StructType schema = (StructType)this.userSpecifiedSchema().getOrElse((Function0 & Serializable & scala.Serializable)() -> TextInputJsonDataSource$.MODULE$.inferFromDataset(jsonDataset, parsedOptions));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$json$2(parsedOptions, x$4))));
        Function2 & Serializable & scala.Serializable createParser = (Function2 & Serializable & scala.Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.string(jsonFactory, record);
        RDD parsed = jsonDataset.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            JacksonParser rawParser = new JacksonParser((DataType)actualSchema, parsedOptions, true, JacksonParser$.MODULE$.$lessinit$greater$default$4());
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable & scala.Serializable)x$1 -> UTF8String.fromString((String)x$1)), parsedOptions.parseMode(), schema, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable & scala.Serializable)input -> parser.parse(input));
        }, jsonDataset.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema, jsonDataset.isStreaming());
    }

    public Dataset<Row> csv(String path) {
        return this.csv((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> csv(Dataset<String> csvDataset) {
        CSVOptions parsedOptions = new CSVOptions(this.extraOptions().toMap(), this.sparkSession.sessionState().conf().csvColumnPruning(), this.sparkSession.sessionState().conf().sessionLocalTimeZone());
        Dataset<String> filteredLines = CSVUtils$.MODULE$.filterCommentAndEmpty(csvDataset, parsedOptions);
        None$ maybeFirstLine = this.userSpecifiedSchema().isEmpty() || parsedOptions.headerFlag() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredLines.take(1))).headOption() : None$.MODULE$;
        StructType schema = (StructType)this.userSpecifiedSchema().getOrElse(() -> DataFrameReader.$anonfun$csv$1(this, csvDataset, (Option)maybeFirstLine, parsedOptions));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$csv$2(parsedOptions, x$5))));
        RDD linesWithoutHeader = (RDD)maybeFirstLine.map((Function1 & Serializable & scala.Serializable)firstLine -> {
            CSVHeaderChecker headerChecker = new CSVHeaderChecker(actualSchema, parsedOptions, new StringBuilder(12).append("CSV source: ").append(csvDataset).toString(), CSVHeaderChecker$.MODULE$.$lessinit$greater$default$4());
            headerChecker.checkHeaderColumnNames(firstLine);
            return filteredLines.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)x$6 -> CSVUtils$.MODULE$.filterHeaderLine((Iterator<String>)x$6, (String)firstLine, parsedOptions), filteredLines.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(String.class));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> filteredLines.rdd());
        RDD parsed = linesWithoutHeader.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            UnivocityParser rawParser = new UnivocityParser(actualSchema, parsedOptions);
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> Option$.MODULE$.option2Iterable((Option)rawParser.parse().apply(input)), parsedOptions.parseMode(), schema, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable & scala.Serializable)input -> parser.parse(input));
        }, linesWithoutHeader.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema, csvDataset.isStreaming());
    }

    public Dataset<Row> csv(Seq<String> paths) {
        return this.format("csv").load(paths);
    }

    public Dataset<Row> parquet(String path) {
        return this.parquet((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> parquet(Seq<String> paths) {
        return this.format("parquet").load(paths);
    }

    public Dataset<Row> orc(String path) {
        return this.orc((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> orc(Seq<String> paths) {
        return this.format("orc").load(paths);
    }

    public Dataset<Row> table(String tableName) {
        this.assertNoSpecifiedSchema("table");
        Seq multipartIdentifier = this.sparkSession.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new UnresolvedRelation(multipartIdentifier, new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.extraOptions().toMap()).asJava()), UnresolvedRelation$.MODULE$.apply$default$3()));
    }

    public Dataset<Row> text(String path) {
        return this.text((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> text(Seq<String> paths) {
        return this.format("text").load(paths);
    }

    public Dataset<String> textFile(String path) {
        return this.textFile((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<String> textFile(Seq<String> paths) {
        this.assertNoSpecifiedSchema("textFile");
        return this.text(paths).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(this.sparkSession.implicits().newStringEncoder());
    }

    private void assertNoSpecifiedSchema(String operation) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw new AnalysisException(new StringBuilder(43).append("User specified schema not supported with `").append(operation).append("`").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$load$2(CaseInsensitiveMap optionsWithPath$1, String x$1) {
        return !optionsWithPath$1.contains(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$json$2(JSONOptions parsedOptions$1, StructField x$4) {
        String string = x$4.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ StructType $anonfun$csv$1(DataFrameReader $this, Dataset csvDataset$1, Option maybeFirstLine$1, CSVOptions parsedOptions$2) {
        return TextInputCSVDataSource$.MODULE$.inferFromDataset($this.sparkSession, csvDataset$1, (Option<String>)maybeFirstLine$1, parsedOptions$2);
    }

    public static final /* synthetic */ boolean $anonfun$csv$2(CSVOptions parsedOptions$2, StructField x$5) {
        String string = x$5.name();
        String string2 = parsedOptions$2.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public DataFrameReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
    }
}

