/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog;
import org.apache.spark.sql.execution.streaming.SinkFileStatus;
import org.apache.spark.sql.execution.streaming.SinkFileStatus$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001\u0002\u000e\u001c\u0001!B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005y!)\u0001\n\u0001C\u0001\u0013\"Ia\n\u0001a\u0001\u0002\u0004%Ia\u0014\u0005\n1\u0002\u0001\r\u00111A\u0005\neC\u0011b\u0018\u0001A\u0002\u0003\u0005\u000b\u0015\u0002)\t\u0013\u0011\u0004\u0001\u0019!a\u0001\n\u0013)\u0007\"C5\u0001\u0001\u0004\u0005\r\u0011\"\u0003k\u0011%a\u0007\u00011A\u0001B\u0003&a\rC\u0005o\u0001\u0001\u0007\t\u0019!C\u0005_\"I1\u000f\u0001a\u0001\u0002\u0004%I\u0001\u001e\u0005\nm\u0002\u0001\r\u0011!Q!\nAD\u0011b\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002=\t\u0017\u0005\u0015\u0001\u00011AA\u0002\u0013%\u0011q\u0001\u0005\u000b\u0003\u0017\u0001\u0001\u0019!A!B\u0013I\bbBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003/\u0001A\u0011IA\r\u0011\u001d\tY\u0003\u0001C!\u0003[Aq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002p\u0001!\t%!\u001d\t\u000f\u0005]\u0004\u0001\"\u0011\u0002z!9\u0011Q\u0011\u0001\u0005B\u0005\u001d\u0005bBAM\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003K\u0003A\u0011IAT\u0011\u001d\tY\u000b\u0001C!\u0003[\u0013!$T1oS\u001a,7\u000f\u001e$jY\u0016\u001cu.\\7jiB\u0013x\u000e^8d_2T!\u0001H\u000f\u0002\u0013M$(/Z1nS:<'B\u0001\u0010 \u0003%)\u00070Z2vi&|gN\u0003\u0002!C\u0005\u00191/\u001d7\u000b\u0005\t\u001a\u0013!B:qCJ\\'B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001SE:\u0004C\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\tIwN\u0003\u0002/C\u0005A\u0011N\u001c;fe:\fG.\u0003\u00021W\t\u0011b)\u001b7f\u0007>lW.\u001b;Qe>$xnY8m!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u00051\u0019VM]5bY&T\u0018M\u00197f!\tA\u0014(D\u0001.\u0013\tQTFA\u0004M_\u001e<\u0017N\\4\u0002\u000b)|'-\u00133\u0011\u0005u\"eB\u0001 C!\ty4'D\u0001A\u0015\t\tu%\u0001\u0004=e>|GOP\u0005\u0003\u0007N\na\u0001\u0015:fI\u00164\u0017BA#G\u0005\u0019\u0019FO]5oO*\u00111iM\u0001\u0005a\u0006$\b.\u0001\u0004=S:LGO\u0010\u000b\u0004\u00152k\u0005CA&\u0001\u001b\u0005Y\u0002\"B\u001e\u0004\u0001\u0004a\u0004\"B$\u0004\u0001\u0004a\u0014AC1eI\u0016$g)\u001b7fgV\t\u0001\u000bE\u0002R-rj\u0011A\u0015\u0006\u0003'R\u000bq!\\;uC\ndWM\u0003\u0002Vg\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005]\u0013&aC!se\u0006L()\u001e4gKJ\fa\"\u00193eK\u00124\u0015\u000e\\3t?\u0012*\u0017\u000f\u0006\u0002[;B\u0011!gW\u0005\u00039N\u0012A!\u00168ji\"9a,BA\u0001\u0002\u0004\u0001\u0016a\u0001=%c\u0005Y\u0011\r\u001a3fI\u001aKG.Z:!Q\t1\u0011\r\u0005\u00023E&\u00111m\r\u0002\niJ\fgn]5f]R\fqAZ5mK2{w-F\u0001g!\tYu-\u0003\u0002i7\t\tb)\u001b7f'R\u0014X-Y7TS:\\Gj\\4\u0002\u0017\u0019LG.\u001a'pO~#S-\u001d\u000b\u00035.DqA\u0018\u0005\u0002\u0002\u0003\u0007a-\u0001\u0005gS2,Gj\\4!Q\tI\u0011-A\u0004cCR\u001c\u0007.\u00133\u0016\u0003A\u0004\"AM9\n\u0005I\u001c$\u0001\u0002'p]\u001e\f1BY1uG\"LEm\u0018\u0013fcR\u0011!,\u001e\u0005\b=.\t\t\u00111\u0001q\u0003!\u0011\u0017\r^2i\u0013\u0012\u0004\u0013A\u00059f]\u0012LgnZ\"p[6LGOR5mKN,\u0012!\u001f\t\u0004#ZS\bcA>\u0002\u00025\tAP\u0003\u0002~}\u0006\u0011am\u001d\u0006\u0003\u007f\u000e\na\u0001[1e_>\u0004\u0018bAA\u0002y\n!\u0001+\u0019;i\u0003Y\u0001XM\u001c3j]\u001e\u001cu.\\7ji\u001aKG.Z:`I\u0015\fHc\u0001.\u0002\n!9aLDA\u0001\u0002\u0004I\u0018a\u00059f]\u0012LgnZ\"p[6LGOR5mKN\u0004\u0003FA\bb\u0003Q\u0019X\r^;q\u001b\u0006t\u0017NZ3ti>\u0003H/[8ogR)!,a\u0005\u0002\u0016!)A\r\u0005a\u0001M\")a\u000e\u0005a\u0001a\u0006A1/\u001a;va*{'\rF\u0002[\u00037Aq!!\b\u0012\u0001\u0004\ty\"\u0001\u0006k_\n\u001cuN\u001c;fqR\u0004B!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003Kq\u0018!C7baJ,G-^2f\u0013\u0011\tI#a\t\u0003\u0015){'mQ8oi\u0016DH/A\u0005d_6l\u0017\u000e\u001e&pER)!,a\f\u00022!9\u0011Q\u0004\nA\u0002\u0005}\u0001bBA\u001a%\u0001\u0007\u0011QG\u0001\fi\u0006\u001c8nQ8n[&$8\u000f\u0005\u0004\u00028\u0005\u0005\u0013q\t\b\u0005\u0003s\tiDD\u0002@\u0003wI\u0011\u0001N\u0005\u0004\u0003\u007f\u0019\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003\u0007\n)EA\u0002TKFT1!a\u00104!\u0011\tI%a\u0019\u000f\t\u0005-\u0013q\f\b\u0005\u0003\u001b\niF\u0004\u0003\u0002P\u0005mc\u0002BA)\u00033rA!a\u0015\u0002X9\u0019q(!\u0016\n\u0003\u0019J!\u0001J\u0013\n\u0005\t\u001a\u0013B\u0001\u0018\"\u0013\taS&C\u0002\u0002b-\n!CR5mK\u000e{W.\\5u!J|Go\\2pY&!\u0011QMA4\u0005E!\u0016m]6D_6l\u0017\u000e^'fgN\fw-\u001a\u0006\u0004\u0003CZ\u0013\u0001C1c_J$(j\u001c2\u0015\u0007i\u000bi\u0007C\u0004\u0002\u001eM\u0001\r!a\b\u0002\u0019=tG+Y:l\u0007>lW.\u001b;\u0015\u0007i\u000b\u0019\bC\u0004\u0002vQ\u0001\r!a\u0012\u0002\u0015Q\f7o[\"p[6LG/A\u0005tKR,\b\u000fV1tWR\u0019!,a\u001f\t\u000f\u0005uT\u00031\u0001\u0002\u0000\u0005YA/Y:l\u0007>tG/\u001a=u!\u0011\t\t#!!\n\t\u0005\r\u00151\u0005\u0002\u0013)\u0006\u001c8.\u0011;uK6\u0004HoQ8oi\u0016DH/A\boK^$\u0016m]6UK6\u0004h)\u001b7f)\u001da\u0014\u0011RAF\u0003+Cq!! \u0017\u0001\u0004\ty\bC\u0004\u0002\u000eZ\u0001\r!a$\u0002\u0007\u0011L'\u000f\u0005\u00033\u0003#c\u0014bAAJg\t1q\n\u001d;j_:Da!a&\u0017\u0001\u0004a\u0014aA3yi\u00061b.Z<UCN\\G+Z7q\r&dW-\u00112t!\u0006$\b\u000eF\u0004=\u0003;\u000by*a)\t\u000f\u0005ut\u00031\u0001\u0002\u0000!1\u0011\u0011U\fA\u0002q\n1\"\u00192t_2,H/\u001a#je\"1\u0011qS\fA\u0002q\n!bY8n[&$H+Y:l)\u0011\t9%!+\t\u000f\u0005u\u0004\u00041\u0001\u0002\u0000\u0005I\u0011MY8siR\u000b7o\u001b\u000b\u00045\u0006=\u0006bBA?3\u0001\u0007\u0011q\u0010")
public class ManifestFileCommitProtocol
extends FileCommitProtocol
implements scala.Serializable {
    private final String path;
    private transient ArrayBuffer<String> addedFiles;
    private transient FileStreamSinkLog fileLog;
    private long batchId;
    private transient ArrayBuffer<Path> pendingCommitFiles;

    private ArrayBuffer<String> addedFiles() {
        return this.addedFiles;
    }

    private void addedFiles_$eq(ArrayBuffer<String> x$1) {
        this.addedFiles = x$1;
    }

    private FileStreamSinkLog fileLog() {
        return this.fileLog;
    }

    private void fileLog_$eq(FileStreamSinkLog x$1) {
        this.fileLog = x$1;
    }

    private long batchId() {
        return this.batchId;
    }

    private void batchId_$eq(long x$1) {
        this.batchId = x$1;
    }

    private ArrayBuffer<Path> pendingCommitFiles() {
        return this.pendingCommitFiles;
    }

    private void pendingCommitFiles_$eq(ArrayBuffer<Path> x$1) {
        this.pendingCommitFiles = x$1;
    }

    public void setupManifestOptions(FileStreamSinkLog fileLog, long batchId) {
        this.fileLog_$eq(fileLog);
        this.batchId_$eq(batchId);
    }

    public void setupJob(JobContext jobContext) {
        Predef$.MODULE$.require(this.fileLog() != null, (Function0 & Serializable & scala.Serializable)() -> "setupManifestOptions must be called before this function");
        this.pendingCommitFiles_$eq((ArrayBuffer<Path>)new ArrayBuffer());
    }

    public void commitJob(JobContext jobContext, Seq<FileCommitProtocol.TaskCommitMessage> taskCommits) {
        Predef$.MODULE$.require(this.fileLog() != null, (Function0 & Serializable & scala.Serializable)() -> "setupManifestOptions must be called before this function");
        SinkFileStatus[] fileStatuses = (SinkFileStatus[])((TraversableOnce)taskCommits.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)x$1.obj(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SinkFileStatus.class));
        this.pendingCommitFiles().clear();
        if (!this.fileLog().add(this.batchId(), (Object[])fileStatuses)) {
            throw new IllegalStateException(new StringBuilder(25).append("Race while writing batch ").append(this.batchId()).toString());
        }
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Committed batch ").append(this.batchId()).toString());
    }

    public void abortJob(JobContext jobContext) {
        block0: {
            Predef$.MODULE$.require(this.fileLog() != null, (Function0 & Serializable & scala.Serializable)() -> "setupManifestOptions must be called before this function");
            if (!this.pendingCommitFiles().nonEmpty()) break block0;
            this.pendingCommitFiles().foreach((Function1 & Serializable & scala.Serializable)path -> {
                Object object;
                block3: {
                    try {
                        FileSystem fs = path.getFileSystem(jobContext.getConfiguration());
                        if (fs.exists(path)) {
                            object = BoxesRunTime.boxToBoolean((boolean)fs.delete(path, false));
                            break block3;
                        }
                        object = BoxedUnit.UNIT;
                    }
                    catch (IOException e) {
                        this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Fail to remove temporary file ").append(path).append(", continue removing next.").toString(), e);
                        object = BoxedUnit.UNIT;
                    }
                }
                return object;
            });
            this.pendingCommitFiles().clear();
        }
    }

    public void onTaskCommit(FileCommitProtocol.TaskCommitMessage taskCommit) {
        this.pendingCommitFiles().$plus$plus$eq((TraversableOnce)((Seq)taskCommit.obj()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toFileStatus().getPath(), Seq$.MODULE$.canBuildFrom()));
    }

    public void setupTask(TaskAttemptContext taskContext) {
        this.addedFiles_$eq((ArrayBuffer<String>)new ArrayBuffer());
    }

    public String newTaskTempFile(TaskAttemptContext taskContext, Option<String> dir, String ext) {
        int split = taskContext.getTaskAttemptID().getTaskID().getId();
        String uuid = UUID.randomUUID().toString();
        int arg$macro$1 = split;
        String arg$macro$2 = uuid;
        String arg$macro$3 = ext;
        String filename = new StringOps("part-%05d-%s%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1), arg$macro$2, arg$macro$3}));
        String file = (String)dir.map((Function1 & Serializable & scala.Serializable)d -> new Path(new Path($this.path, d), filename).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Path($this.path, filename).toString());
        this.addedFiles().$plus$eq((Object)file);
        return file;
    }

    public String newTaskTempFileAbsPath(TaskAttemptContext taskContext, String absoluteDir, String ext) {
        throw new UnsupportedOperationException(new StringBuilder(52).append((Object)this).append(" does not support adding files with an absolute path").toString());
    }

    public FileCommitProtocol.TaskCommitMessage commitTask(TaskAttemptContext taskContext) {
        FileCommitProtocol.TaskCommitMessage taskCommitMessage;
        if (this.addedFiles().nonEmpty()) {
            FileSystem fs = new Path((String)this.addedFiles().head()).getFileSystem(taskContext.getConfiguration());
            Seq statuses = ((SeqLike)this.addedFiles().map((Function1 & Serializable & scala.Serializable)f -> SinkFileStatus$.MODULE$.apply(fs.getFileStatus(new Path(f))), ArrayBuffer$.MODULE$.canBuildFrom())).toSeq();
            taskCommitMessage = new FileCommitProtocol.TaskCommitMessage((Object)statuses);
        } else {
            taskCommitMessage = new FileCommitProtocol.TaskCommitMessage((Object)Seq$.MODULE$.empty());
        }
        return taskCommitMessage;
    }

    public void abortTask(TaskAttemptContext taskContext) {
        block0: {
            if (!this.addedFiles().nonEmpty()) break block0;
            FileSystem fs = new Path((String)this.addedFiles().head()).getFileSystem(taskContext.getConfiguration());
            this.addedFiles().foreach((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)fs.delete(new Path(file), false)));
        }
    }

    public ManifestFileCommitProtocol(String jobId, String path) {
        this.path = path;
    }
}

