/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Catalog;
import org.apache.spark.sql.catalog.Column;
import org.apache.spark.sql.catalog.Database;
import org.apache.spark.sql.catalog.Function;
import org.apache.spark.sql.catalog.Table;
import org.apache.spark.sql.catalyst.DefinedByConstructorParams;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.internal.CatalogImpl$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r-a\u0001\u0002\u001a4\u0001yB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u0006\u0015\u0002!\ta\u0013\u0005\u0006\u001f\u0002!I\u0001\u0015\u0005\u00061\u0002!I!\u0017\u0005\u0006[\u0002!IA\u001c\u0005\u0006e\u0002!\te\u001d\u0005\u0006i\u0002!\t%\u001e\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'Aq!a\u0006\u0001\t\u0003\nI\u0002C\u0004\u0002\u0018\u0001!\t%a\t\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,!9\u0011\u0011\b\u0001\u0005B\u0005m\u0002bBA\u001d\u0001\u0011\u0005\u0013Q\t\u0005\b\u0003\u0017\u0002A\u0011BA'\u0011\u001d\tI\u0006\u0001C!\u00037Bq!!\u0017\u0001\t\u0003\ni\u0007C\u0004\u0002Z\u0001!I!!\u001f\t\u000f\u0005}\u0004\u0001\"\u0011\u0002\u0002\"9\u0011Q\u0011\u0001\u0005B\u0005\u001d\u0005bBAC\u0001\u0011\u0005\u00131\u0012\u0005\b\u0003#\u0003A\u0011IAJ\u0011\u001d\t\t\n\u0001C!\u00033Cq!a(\u0001\t\u0003\n\t\u000bC\u0004\u0002,\u0002!\t%!,\t\u000f\u0005-\u0006\u0001\"\u0011\u00022\"9\u0011q\u0017\u0001\u0005B\u0005e\u0006bBA\\\u0001\u0011\u0005\u0013Q\u0018\u0005\b\u0003\u0007\u0004A\u0011IAc\u0011\u001d\t\u0019\r\u0001C!\u0003WDq!a1\u0001\t\u0003\n)\u0010C\u0004\u0002D\u0002!\tE!\u0002\t\u000f\u0005\r\u0007\u0001\"\u0011\u0003\u0012!9\u00111\u0019\u0001\u0005B\t%\u0002b\u0002B\u001b\u0001\u0011\u0005#q\u0007\u0005\b\u0005{\u0001A\u0011\tB \u0011\u001d\u0011\u0019\u0005\u0001C!\u0005\u000bBqA!\u0013\u0001\t\u0003\u0012Y\u0005C\u0004\u0003P\u0001!\tE!\u0015\t\u000f\t=\u0003\u0001\"\u0011\u0003V!9!\u0011\u000e\u0001\u0005B\t-\u0004b\u0002B8\u0001\u0011\u0005#\u0011\u000f\u0005\t\u0005\u0013\u0002A\u0011C\u001b\u0003t!9!1\u0013\u0001\u0005B\tU\u0005b\u0002BM\u0001\u0011\u0005#1T\u0004\t\u0005C\u001b\u0004\u0012A\u001b\u0003$\u001a9!g\rE\u0001k\t\u0015\u0006B\u0002&0\t\u0003\u0011i\u000bC\u0004\u00030>\"\tA!-\u0003\u0017\r\u000bG/\u00197pO&k\u0007\u000f\u001c\u0006\u0003iU\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003m]\n1a]9m\u0015\tA\u0014(A\u0003ta\u0006\u00148N\u0003\u0002;w\u00051\u0011\r]1dQ\u0016T\u0011\u0001P\u0001\u0004_J<7\u0001A\n\u0003\u0001}\u0002\"\u0001Q\"\u000e\u0003\u0005S!AQ\u001b\u0002\u000f\r\fG/\u00197pO&\u0011A)\u0011\u0002\b\u0007\u0006$\u0018\r\\8h\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\t9\u0005*D\u00016\u0013\tIUG\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003\u0019:\u0003\"!\u0014\u0001\u000e\u0003MBQ!\u0012\u0002A\u0002\u0019\u000bab]3tg&|gnQ1uC2|w-F\u0001R!\t\u0011f+D\u0001T\u0015\t\u0011EK\u0003\u0002Vk\u0005A1-\u0019;bYf\u001cH/\u0003\u0002X'\nq1+Z:tS>t7)\u0019;bY><\u0017!\u0006:fcVL'/\u001a#bi\u0006\u0014\u0017m]3Fq&\u001cHo\u001d\u000b\u00035\u0002\u0004\"a\u00170\u000e\u0003qS\u0011!X\u0001\u0006g\u000e\fG.Y\u0005\u0003?r\u0013A!\u00168ji\")\u0011\r\u0002a\u0001E\u00061AM\u0019(b[\u0016\u0004\"a\u00196\u000f\u0005\u0011D\u0007CA3]\u001b\u00051'BA4>\u0003\u0019a$o\\8u}%\u0011\u0011\u000eX\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002j9\u0006\u0011\"/Z9vSJ,G+\u00192mK\u0016C\u0018n\u001d;t)\rQv\u000e\u001d\u0005\u0006C\u0016\u0001\rA\u0019\u0005\u0006c\u0016\u0001\rAY\u0001\ni\u0006\u0014G.\u001a(b[\u0016\fqbY;se\u0016tG\u000fR1uC\n\f7/Z\u000b\u0002E\u0006\u00112/\u001a;DkJ\u0014XM\u001c;ECR\f'-Y:f)\tQf\u000fC\u0003b\u000f\u0001\u0007!\rK\u0002\bqz\u00042aW=|\u0013\tQHL\u0001\u0004uQJ|wo\u001d\t\u0003\u000frL!!`\u001b\u0003#\u0005s\u0017\r\\=tSN,\u0005pY3qi&|g.I\u0001\u0000\u0003]!\u0017\r^1cCN,\u0007\u0005Z8fg\u0002rw\u000e\u001e\u0011fq&\u001cH/A\u0007mSN$H)\u0019;bE\u0006\u001cXm\u001d\u000b\u0003\u0003\u000b\u0001RaRA\u0004\u0003\u0017I1!!\u00036\u0005\u001d!\u0015\r^1tKR\u00042\u0001QA\u0007\u0013\r\ty!\u0011\u0002\t\t\u0006$\u0018MY1tK\u0006aQ.Y6f\t\u0006$\u0018MY1tKR!\u00111BA\u000b\u0011\u0015\t\u0017\u00021\u0001c\u0003)a\u0017n\u001d;UC\ndWm\u001d\u000b\u0003\u00037\u0001RaRA\u0004\u0003;\u00012\u0001QA\u0010\u0013\r\t\t#\u0011\u0002\u0006)\u0006\u0014G.\u001a\u000b\u0005\u00037\t)\u0003C\u0003b\u0017\u0001\u0007!\rK\u0002\fqz\f\u0011\"\\1lKR\u000b'\r\\3\u0015\t\u0005u\u0011Q\u0006\u0005\b\u0003_a\u0001\u0019AA\u0019\u0003)!\u0018M\u00197f\u0013\u0012,g\u000e\u001e\t\u0005\u0003g\t)$D\u0001U\u0013\r\t9\u0004\u0016\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\u0006iA.[:u\rVt7\r^5p]N$\"!!\u0010\u0011\u000b\u001d\u000b9!a\u0010\u0011\u0007\u0001\u000b\t%C\u0002\u0002D\u0005\u0013\u0001BR;oGRLwN\u001c\u000b\u0005\u0003{\t9\u0005C\u0003b\u001d\u0001\u0007!\rK\u0002\u000fqz\fA\"\\1lK\u001a+hn\u0019;j_:$B!a\u0010\u0002P!9\u0011\u0011K\bA\u0002\u0005M\u0013!\u00034v]\u000eLE-\u001a8u!\u0011\t\u0019$!\u0016\n\u0007\u0005]CK\u0001\nGk:\u001cG/[8o\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018a\u00037jgR\u001cu\u000e\\;n]N$B!!\u0018\u0002fA)q)a\u0002\u0002`A\u0019\u0001)!\u0019\n\u0007\u0005\r\u0014I\u0001\u0004D_2,XN\u001c\u0005\u0006cB\u0001\rA\u0019\u0015\u0005!a\fI'\t\u0002\u0002l\u0005!B/\u00192mK\u0002\"w.Z:!]>$\b%\u001a=jgR$b!!\u0018\u0002p\u0005E\u0004\"B1\u0012\u0001\u0004\u0011\u0007\"B9\u0012\u0001\u0004\u0011\u0007\u0006B\ty\u0003k\n#!a\u001e\u0002A\u0011\fG/\u00192bg\u0016\u0004sN\u001d\u0011uC\ndW\r\t3pKN\u0004cn\u001c;!KbL7\u000f\u001e\u000b\u0005\u0003;\nY\bC\u0004\u0002~I\u0001\r!!\r\u0002\u001fQ\f'\r\\3JI\u0016tG/\u001b4jKJ\f1bZ3u\t\u0006$\u0018MY1tKR!\u00111BAB\u0011\u0015\t7\u00031\u0001c\u0003!9W\r\u001e+bE2,G\u0003BA\u000f\u0003\u0013CQ!\u001d\u000bA\u0002\t$b!!\b\u0002\u000e\u0006=\u0005\"B1\u0016\u0001\u0004\u0011\u0007\"B9\u0016\u0001\u0004\u0011\u0017aC4fi\u001a+hn\u0019;j_:$B!a\u0010\u0002\u0016\"1\u0011q\u0013\fA\u0002\t\fABZ;oGRLwN\u001c(b[\u0016$b!a\u0010\u0002\u001c\u0006u\u0005\"B1\u0018\u0001\u0004\u0011\u0007BBAL/\u0001\u0007!-\u0001\beCR\f'-Y:f\u000bbL7\u000f^:\u0015\t\u0005\r\u0016\u0011\u0016\t\u00047\u0006\u0015\u0016bAAT9\n9!i\\8mK\u0006t\u0007\"B1\u0019\u0001\u0004\u0011\u0017a\u0003;bE2,W\t_5tiN$B!a)\u00020\")\u0011/\u0007a\u0001ER1\u00111UAZ\u0003kCQ!\u0019\u000eA\u0002\tDQ!\u001d\u000eA\u0002\t\faBZ;oGRLwN\\#ySN$8\u000f\u0006\u0003\u0002$\u0006m\u0006BBAL7\u0001\u0007!\r\u0006\u0004\u0002$\u0006}\u0016\u0011\u0019\u0005\u0006Cr\u0001\rA\u0019\u0005\u0007\u0003/c\u0002\u0019\u00012\u0002\u0017\r\u0014X-\u0019;f)\u0006\u0014G.\u001a\u000b\u0007\u0003\u000f\f)/a:\u0011\t\u0005%\u0017q\u001c\b\u0005\u0003\u0017\fYN\u0004\u0003\u0002N\u0006eg\u0002BAh\u0003/tA!!5\u0002V:\u0019Q-a5\n\u0003qJ!AO\u001e\n\u0005aJ\u0014B\u0001\u001c8\u0013\r\ti.N\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t/a9\u0003\u0013\u0011\u000bG/\u0019$sC6,'bAAok!)\u0011/\ba\u0001E\"1\u0011\u0011^\u000fA\u0002\t\fA\u0001]1uQRA\u0011qYAw\u0003_\f\t\u0010C\u0003r=\u0001\u0007!\r\u0003\u0004\u0002jz\u0001\rA\u0019\u0005\u0007\u0003gt\u0002\u0019\u00012\u0002\rM|WO]2f)!\t9-a>\u0002z\u0006m\b\"B9 \u0001\u0004\u0011\u0007BBAz?\u0001\u0007!\rC\u0004\u0002~~\u0001\r!a@\u0002\u000f=\u0004H/[8ogB)1M!\u0001cE&\u0019!1\u00017\u0003\u00075\u000b\u0007\u000f\u0006\u0006\u0002H\n\u001d!\u0011\u0002B\u0006\u0005\u001fAQ!\u001d\u0011A\u0002\tDa!a=!\u0001\u0004\u0011\u0007B\u0002B\u0007A\u0001\u0007!-A\u0006eKN\u001c'/\u001b9uS>t\u0007bBA\u007fA\u0001\u0007\u0011q \u000b\u000b\u0003\u000f\u0014\u0019B!\u0006\u0003\u0018\t\u001d\u0002\"B9\"\u0001\u0004\u0011\u0007BBAzC\u0001\u0007!\rC\u0004\u0003\u001a\u0005\u0002\rAa\u0007\u0002\rM\u001c\u0007.Z7b!\u0011\u0011iBa\t\u000e\u0005\t}!b\u0001B\u0011k\u0005)A/\u001f9fg&!!Q\u0005B\u0010\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0003{\f\u0003\u0019AA\u0000)1\t9Ma\u000b\u0003.\t=\"\u0011\u0007B\u001a\u0011\u0015\t(\u00051\u0001c\u0011\u0019\t\u0019P\ta\u0001E\"9!\u0011\u0004\u0012A\u0002\tm\u0001B\u0002B\u0007E\u0001\u0007!\rC\u0004\u0002~\n\u0002\r!a@\u0002\u0019\u0011\u0014x\u000e\u001d+f[B4\u0016.Z<\u0015\t\u0005\r&\u0011\b\u0005\u0007\u0005w\u0019\u0003\u0019\u00012\u0002\u0011YLWm\u001e(b[\u0016\f!\u0003\u001a:pa\u001ecwNY1m)\u0016l\u0007OV5foR!\u00111\u0015B!\u0011\u0019\u0011Y\u0004\na\u0001E\u0006\t\"/Z2pm\u0016\u0014\b+\u0019:uSRLwN\\:\u0015\u0007i\u00139\u0005C\u0003rK\u0001\u0007!-\u0001\u0005jg\u000e\u000b7\r[3e)\u0011\t\u0019K!\u0014\t\u000bE4\u0003\u0019\u00012\u0002\u0015\r\f7\r[3UC\ndW\rF\u0002[\u0005'BQ!]\u0014A\u0002\t$RA\u0017B,\u00053BQ!\u001d\u0015A\u0002\tDqAa\u0017)\u0001\u0004\u0011i&\u0001\u0007ti>\u0014\u0018mZ3MKZ,G\u000e\u0005\u0003\u0003`\t\u0015TB\u0001B1\u0015\r\u0011\u0019gN\u0001\bgR|'/Y4f\u0013\u0011\u00119G!\u0019\u0003\u0019M#xN]1hK2+g/\u001a7\u0002\u0019Ut7-Y2iKR\u000b'\r\\3\u0015\u0007i\u0013i\u0007C\u0003rS\u0001\u0007!-\u0001\u0006dY\u0016\f'oQ1dQ\u0016$\u0012A\u0017\u000b\u0005\u0003G\u0013)\bC\u0004\u0003x-\u0002\rA!\u001f\u0002\u000bEt\u0015-\\31\t\tm$\u0011\u0011\t\u0006\u000f\u0006\u001d!Q\u0010\t\u0005\u0005\u007f\u0012\t\t\u0004\u0001\u0005\u0019\t\r%QOA\u0001\u0002\u0003\u0015\tA!\"\u0003\u0007}#\u0013'\u0005\u0003\u0003\b\n5\u0005cA.\u0003\n&\u0019!1\u0012/\u0003\u000f9{G\u000f[5oOB\u00191La$\n\u0007\tEELA\u0002B]f\fAB]3ge\u0016\u001c\b\u000eV1cY\u0016$2A\u0017BL\u0011\u0015\tH\u00061\u0001c\u00035\u0011XM\u001a:fg\"\u0014\u0015\u0010U1uQR\u0019!L!(\t\r\t}U\u00061\u0001c\u00031\u0011Xm]8ve\u000e,\u0007+\u0019;i\u0003-\u0019\u0015\r^1m_\u001eLU\u000e\u001d7\u0011\u00055{3cA\u0018\u0003(B\u00191L!+\n\u0007\t-FL\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005G\u000b1\"\\1lK\u0012\u000bG/Y:fiV!!1\u0017B^)\u0019\u0011)L!?\u0004\nQ!!q\u0017Bd!\u00159\u0015q\u0001B]!\u0011\u0011yHa/\u0005\u000f\tu\u0016G1\u0001\u0003@\n\tA+\u0005\u0003\u0003\b\n\u0005\u0007\u0003BA\u001a\u0005\u0007L1A!2U\u0005i!UMZ5oK\u0012\u0014\u0015pQ8ogR\u0014Xo\u0019;peB\u000b'/Y7t\u0011%\u0011I-MA\u0001\u0002\b\u0011Y-\u0001\u0006fm&$WM\\2fIE\u0002bA!4\u0003n\nef\u0002\u0002Bh\u0005OtAA!5\u0003d:!!1\u001bBo\u001d\u0011\u0011)N!7\u000f\u0007\u0015\u00149.C\u0001^\u0013\r\u0011Y\u000eX\u0001\be\u00164G.Z2u\u0013\u0011\u0011yN!9\u0002\u000fI,h\u000e^5nK*\u0019!1\u001c/\n\t\u0005u'Q\u001d\u0006\u0005\u0005?\u0014\t/\u0003\u0003\u0003j\n-\u0018\u0001C;oSZ,'o]3\u000b\t\u0005u'Q]\u0005\u0005\u0005_\u0014\tPA\u0004UsB,G+Y4\n\t\tM(Q\u001f\u0002\t)f\u0004X\rV1hg*!!q\u001fBq\u0003\r\t\u0007/\u001b\u0005\b\u0005w\f\u0004\u0019\u0001B\u007f\u0003\u0011!\u0017\r^1\u0011\r\t}81\u0001B]\u001d\u0011\u0011)n!\u0001\n\u0007\u0005uG,\u0003\u0003\u0004\u0006\r\u001d!aA*fc*\u0019\u0011Q\u001c/\t\u000b\u0015\u000b\u0004\u0019\u0001$")
public class CatalogImpl
extends Catalog {
    private final SparkSession sparkSession;

    public static <T extends DefinedByConstructorParams> Dataset<T> makeDataset(Seq<T> seq, SparkSession sparkSession, TypeTags.TypeTag<T> typeTag) {
        return CatalogImpl$.MODULE$.makeDataset(seq, sparkSession, typeTag);
    }

    private SessionCatalog sessionCatalog() {
        return this.sparkSession.sessionState().catalog();
    }

    private void requireDatabaseExists(String dbName) {
        if (!this.sessionCatalog().databaseExists(dbName)) {
            throw new AnalysisException(new StringBuilder(27).append("Database '").append(dbName).append("' does not exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void requireTableExists(String dbName, String tableName) {
        if (!this.sessionCatalog().tableExists(new TableIdentifier(tableName, (Option)new Some((Object)dbName)))) {
            throw new AnalysisException(new StringBuilder(39).append("Table '").append(tableName).append("' does not exist in database '").append(dbName).append("'.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    @Override
    public String currentDatabase() {
        return this.sessionCatalog().getCurrentDatabase();
    }

    @Override
    public void setCurrentDatabase(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        this.sessionCatalog().setCurrentDatabase(dbName);
    }

    @Override
    public Dataset<Database> listDatabases() {
        Seq databases = (Seq)this.sessionCatalog().listDatabases().map((Function1 & Serializable & scala.Serializable)dbName -> this.makeDatabase((String)dbName), Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Database").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(databases, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(null)));
    }

    private Database makeDatabase(String dbName) {
        CatalogDatabase metadata = this.sessionCatalog().getDatabaseMetadata(dbName);
        return new Database(metadata.name(), metadata.description(), CatalogUtils$.MODULE$.URIToString(metadata.locationUri()));
    }

    @Override
    public Dataset<Table> listTables() {
        return this.listTables(this.currentDatabase());
    }

    @Override
    public Dataset<Table> listTables(String dbName) throws AnalysisException {
        Seq tables = (Seq)this.sessionCatalog().listTables(dbName).map((Function1 & Serializable & scala.Serializable)tableIdent -> this.makeTable((TableIdentifier)tableIdent), Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Table").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$2(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(tables, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$2(null)));
    }

    private Table makeTable(TableIdentifier tableIdent) {
        Some some;
        try {
            some = new Some((Object)this.sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdent));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        Some metadata = some;
        boolean isTemp = this.sessionCatalog().isTemporaryTable(tableIdent);
        return new Table(tableIdent.table(), (String)((Option)metadata.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.identifier().database()).getOrElse((Function0 & Serializable & scala.Serializable)() -> tableIdent.database())).orNull(Predef$.MODULE$.$conforms()), (String)metadata.map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.comment().orNull(Predef$.MODULE$.$conforms())).orNull(Predef$.MODULE$.$conforms()), isTemp ? "TEMPORARY" : (String)metadata.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.tableType().name()).orNull(Predef$.MODULE$.$conforms()), isTemp);
    }

    @Override
    public Dataset<Function> listFunctions() {
        return this.listFunctions(this.currentDatabase());
    }

    @Override
    public Dataset<Function> listFunctions(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        Seq functions2 = (Seq)this.sessionCatalog().listFunctions(dbName).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            FunctionIdentifier functIdent = (FunctionIdentifier)tuple2._1();
            Function function = this.makeFunction(functIdent);
            return function;
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Function").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$3(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(functions2, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$3(null)));
    }

    private Function makeFunction(FunctionIdentifier funcIdent) {
        ExpressionInfo metadata = this.sessionCatalog().lookupFunctionInfo(funcIdent);
        return new Function(metadata.getName(), metadata.getDb(), null, metadata.getClassName(), metadata.getDb() == null);
    }

    @Override
    public Dataset<Column> listColumns(String tableName) throws AnalysisException {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.listColumns(tableIdent);
    }

    @Override
    public Dataset<Column> listColumns(String dbName, String tableName) throws AnalysisException {
        this.requireTableExists(dbName, tableName);
        return this.listColumns(new TableIdentifier(tableName, (Option)new Some((Object)dbName)));
    }

    private Dataset<Column> listColumns(TableIdentifier tableIdentifier) {
        CatalogTable tableMetadata = this.sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdentifier);
        Set partitionColumnNames = tableMetadata.partitionColumnNames().toSet();
        Set bucketColumnNames = ((TraversableOnce)tableMetadata.bucketSpec().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.bucketColumnNames()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).toSet();
        Seq columns = (Seq)tableMetadata.schema().map((Function1 & Serializable & scala.Serializable)c -> new Column(c.name(), (String)c.getComment().orNull(Predef$.MODULE$.$conforms()), ((DataType)CharVarcharUtils$.MODULE$.getRawType(c.metadata()).getOrElse((Function0 & Serializable & scala.Serializable)() -> c.dataType())).catalogString(), c.nullable(), partitionColumnNames.contains((Object)c.name()), bucketColumnNames.contains((Object)c.name())), Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Column").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$4(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(columns, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$4(null)));
    }

    @Override
    public Database getDatabase(String dbName) {
        return this.makeDatabase(dbName);
    }

    @Override
    public Table getTable(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.getTable((String)tableIdent.database().orNull(Predef$.MODULE$.$conforms()), tableIdent.table());
    }

    @Override
    public Table getTable(String dbName, String tableName) {
        if (!this.tableExists(dbName, tableName)) {
            throw new AnalysisException(new StringBuilder(41).append("Table or view '").append(tableName).append("' not found in database '").append(dbName).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.makeTable(new TableIdentifier(tableName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    public Function getFunction(String functionName) {
        FunctionIdentifier functionIdent = this.sparkSession.sessionState().sqlParser().parseFunctionIdentifier(functionName);
        return this.getFunction((String)functionIdent.database().orNull(Predef$.MODULE$.$conforms()), functionIdent.funcName());
    }

    @Override
    public Function getFunction(String dbName, String functionName) {
        return this.makeFunction(new FunctionIdentifier(functionName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    public boolean databaseExists(String dbName) {
        return this.sessionCatalog().databaseExists(dbName);
    }

    @Override
    public boolean tableExists(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.tableExists((String)tableIdent.database().orNull(Predef$.MODULE$.$conforms()), tableIdent.table());
    }

    @Override
    public boolean tableExists(String dbName, String tableName) {
        TableIdentifier tableIdent = new TableIdentifier(tableName, Option$.MODULE$.apply((Object)dbName));
        return this.sessionCatalog().isTemporaryTable(tableIdent) || this.sessionCatalog().tableExists(tableIdent);
    }

    @Override
    public boolean functionExists(String functionName) {
        FunctionIdentifier functionIdent = this.sparkSession.sessionState().sqlParser().parseFunctionIdentifier(functionName);
        return this.functionExists((String)functionIdent.database().orNull(Predef$.MODULE$.$conforms()), functionIdent.funcName());
    }

    @Override
    public boolean functionExists(String dbName, String functionName) {
        return this.sessionCatalog().functionExists(new FunctionIdentifier(functionName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    public Dataset<Row> createTable(String tableName, String path) {
        String dataSourceName = this.sparkSession.sessionState().conf().defaultDataSourceName();
        return this.createTable(tableName, path, dataSourceName);
    }

    @Override
    public Dataset<Row> createTable(String tableName, String path, String source) {
        return this.createTable(tableName, source, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)}))));
    }

    @Override
    public Dataset<Row> createTable(String tableName, String source, Map<String, String> options) {
        return this.createTable(tableName, source, new StructType(), options);
    }

    @Override
    public Dataset<Row> createTable(String tableName, String source, String description, Map<String, String> options) {
        return this.createTable(tableName, source, new StructType(), description, options);
    }

    @Override
    public Dataset<Row> createTable(String tableName, String source, StructType schema, Map<String, String> options) {
        return this.createTable(tableName, source, schema, "", options);
    }

    @Override
    public Dataset<Row> createTable(String tableName, String source, StructType schema, String description, Map<String, String> options) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions(options);
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        TableIdentifier x$1 = tableIdent;
        CatalogTableType x$2 = tableType;
        CatalogStorageFormat x$3 = storage;
        StructType x$4 = schema;
        Some x$5 = new Some((Object)source);
        None$ x$6 = description.isEmpty() ? None$.MODULE$ : new Some((Object)description);
        Seq x$7 = CatalogTable$.MODULE$.apply$default$6();
        Option x$8 = CatalogTable$.MODULE$.apply$default$7();
        String x$9 = CatalogTable$.MODULE$.apply$default$8();
        long x$10 = CatalogTable$.MODULE$.apply$default$9();
        long x$11 = CatalogTable$.MODULE$.apply$default$10();
        String x$12 = CatalogTable$.MODULE$.apply$default$11();
        Map x$13 = CatalogTable$.MODULE$.apply$default$12();
        Option x$14 = CatalogTable$.MODULE$.apply$default$13();
        Option x$15 = CatalogTable$.MODULE$.apply$default$14();
        Seq x$16 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$17 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        Option x$20 = CatalogTable$.MODULE$.apply$default$20();
        CatalogTable tableDesc = new CatalogTable(x$1, x$2, x$3, x$4, (Option)x$5, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option)x$6, x$16, x$17, x$18, x$19, x$20);
        CreateTable plan = new CreateTable(tableDesc, SaveMode.ErrorIfExists, (Option<LogicalPlan>)None$.MODULE$);
        this.sparkSession.sessionState().executePlan(plan).toRdd();
        return this.sparkSession.table(tableIdent);
    }

    @Override
    public boolean dropTempView(String viewName) {
        return this.sparkSession.sessionState().catalog().getTempView(viewName).exists((Function1 & Serializable & scala.Serializable)viewDef -> BoxesRunTime.boxToBoolean((boolean)CatalogImpl.$anonfun$dropTempView$1(this, viewName, viewDef)));
    }

    @Override
    public boolean dropGlobalTempView(String viewName) {
        return this.sparkSession.sessionState().catalog().getGlobalTempView(viewName).exists((Function1 & Serializable & scala.Serializable)viewDef -> BoxesRunTime.boxToBoolean((boolean)CatalogImpl.$anonfun$dropGlobalTempView$1(this, viewName, viewDef)));
    }

    @Override
    public void recoverPartitions(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        this.sparkSession.sessionState().executePlan(new AlterTableRecoverPartitionsCommand(tableIdent, AlterTableRecoverPartitionsCommand$.MODULE$.apply$default$2())).toRdd();
    }

    @Override
    public boolean isCached(String tableName) {
        return this.sparkSession.sharedState().cacheManager().lookupCachedData(this.sparkSession.table(tableName)).nonEmpty();
    }

    @Override
    public void cacheTable(String tableName) {
        this.sparkSession.sharedState().cacheManager().cacheQuery(this.sparkSession.table(tableName), (Option<String>)new Some((Object)tableName), this.sparkSession.sharedState().cacheManager().cacheQuery$default$3());
    }

    @Override
    public void cacheTable(String tableName, StorageLevel storageLevel) {
        this.sparkSession.sharedState().cacheManager().cacheQuery(this.sparkSession.table(tableName), (Option<String>)new Some((Object)tableName), storageLevel);
    }

    @Override
    public void uncacheTable(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        boolean cascade = !this.sessionCatalog().isTemporaryTable(tableIdent);
        this.sparkSession.sharedState().cacheManager().uncacheQuery(this.sparkSession.table(tableName), cascade);
    }

    @Override
    public void clearCache() {
        this.sparkSession.sharedState().cacheManager().clearCache();
    }

    public boolean isCached(Dataset<?> qName) {
        return this.sparkSession.sharedState().cacheManager().lookupCachedData(qName).nonEmpty();
    }

    @Override
    public void refreshTable(String tableName) {
        block2: {
            TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
            CatalogTable tableMetadata = this.sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdent);
            Dataset<Row> table = this.sparkSession.table(tableIdent);
            CatalogTableType catalogTableType = tableMetadata.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
                table.queryExecution().analyzed().refresh();
            } else {
                this.sessionCatalog().refreshTable(tableIdent);
            }
            Option<CachedData> cache = this.sparkSession.sharedState().cacheManager().lookupCachedData(table);
            this.sparkSession.sharedState().cacheManager().uncacheQuery(table, true);
            if (!cache.nonEmpty()) break block2;
            Option<String> cacheName = ((CachedData)cache.get()).cachedRepresentation().cacheBuilder().tableName();
            StorageLevel cacheLevel = ((CachedData)cache.get()).cachedRepresentation().cacheBuilder().storageLevel();
            Dataset<Row> newTable = this.sparkSession.table(tableIdent);
            this.sparkSession.sharedState().cacheManager().cacheQuery(newTable, cacheName, cacheLevel);
        }
    }

    @Override
    public void refreshByPath(String resourcePath) {
        this.sparkSession.sharedState().cacheManager().recacheByPath(this.sparkSession, resourcePath);
    }

    public static final /* synthetic */ boolean $anonfun$dropTempView$1(CatalogImpl $this, String viewName$1, LogicalPlan viewDef) {
        $this.sparkSession.sharedState().cacheManager().uncacheQuery($this.sparkSession, viewDef, false, $this.sparkSession.sharedState().cacheManager().uncacheQuery$default$4());
        return $this.sessionCatalog().dropTempView(viewName$1);
    }

    public static final /* synthetic */ boolean $anonfun$dropGlobalTempView$1(CatalogImpl $this, String viewName$2, LogicalPlan viewDef) {
        $this.sparkSession.sharedState().cacheManager().uncacheQuery($this.sparkSession, viewDef, false, $this.sparkSession.sharedState().cacheManager().uncacheQuery$default$4());
        return $this.sessionCatalog().dropGlobalTempView(viewName$2);
    }

    public CatalogImpl(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
    }
}

