/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.orc;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.orc.OrcConf;
import org.apache.orc.mapred.OrcOutputFormat;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat$;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.execution.datasources.orc.OrcOutputWriter;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.execution.datasources.v2.FileWriteBuilder;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001]4Aa\u0002\u0005\u00013!Aa\u0004\u0001B\u0001B\u0003%q\u0004\u0003\u00056\u0001\t\u0005\t\u0015!\u0003.\u0011!1\u0004A!A!\u0002\u00139\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000b5\u0003A\u0011\u0001(\t\u000bU\u0003A\u0011\t,\u0003\u001f=\u00138m\u0016:ji\u0016\u0014U/\u001b7eKJT!!\u0003\u0006\u0002\u0007=\u00148M\u0003\u0002\f\u0019\u0005\u0011aO\r\u0006\u0003\u001b9\t1\u0002Z1uCN|WO]2fg*\u0011q\u0002E\u0001\nKb,7-\u001e;j_:T!!\u0005\n\u0002\u0007M\fHN\u0003\u0002\u0014)\u0005)1\u000f]1sW*\u0011QCF\u0001\u0007CB\f7\r[3\u000b\u0003]\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005maR\"\u0001\u0006\n\u0005uQ!\u0001\u0005$jY\u0016<&/\u001b;f\u0005VLG\u000eZ3s\u0003\u0015\u0001\u0018\r\u001e5t!\r\u0001#&\f\b\u0003C\u001dr!AI\u0013\u000e\u0003\rR!\u0001\n\r\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0013!B:dC2\f\u0017B\u0001\u0015*\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011AJ\u0005\u0003W1\u00121aU3r\u0015\tA\u0013\u0006\u0005\u0002/e9\u0011q\u0006\r\t\u0003E%J!!M\u0015\u0002\rA\u0013X\rZ3g\u0013\t\u0019DG\u0001\u0004TiJLgn\u001a\u0006\u0003c%\n!BZ8s[\u0006$h*Y7f\u0003A\u0019X\u000f\u001d9peR\u001cH)\u0019;b)f\u0004X\r\u0005\u00039sm\nU\"A\u0015\n\u0005iJ#!\u0003$v]\u000e$\u0018n\u001c82!\tat(D\u0001>\u0015\tq\u0004#A\u0003usB,7/\u0003\u0002A{\tAA)\u0019;b)f\u0004X\r\u0005\u00029\u0005&\u00111)\u000b\u0002\b\u0005>|G.Z1o\u0003\u0011IgNZ8\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015!B<sSR,'B\u0001&\u0011\u0003%\u0019wN\u001c8fGR|'/\u0003\u0002M\u000f\n\u0001Bj\\4jG\u0006dwK]5uK&sgm\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b=\u000b&k\u0015+\u0011\u0005A\u0003Q\"\u0001\u0005\t\u000by)\u0001\u0019A\u0010\t\u000bU*\u0001\u0019A\u0017\t\u000bY*\u0001\u0019A\u001c\t\u000b\u0011+\u0001\u0019A#\u0002\u0019A\u0014X\r]1sK^\u0013\u0018\u000e^3\u0015\u000b][6-\u001c:\u0011\u0005aKV\"\u0001\u0007\n\u0005ic!aE(viB,Ho\u0016:ji\u0016\u0014h)Y2u_JL\b\"\u0002/\u0007\u0001\u0004i\u0016aB:rY\u000e{gN\u001a\t\u0003=\u0006l\u0011a\u0018\u0006\u0003AB\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003E~\u0013qaU)M\u0007>tg\rC\u0003e\r\u0001\u0007Q-A\u0002k_\n\u0004\"AZ6\u000e\u0003\u001dT!\u0001[5\u0002\u00135\f\u0007O]3ek\u000e,'B\u00016\u0015\u0003\u0019A\u0017\rZ8pa&\u0011An\u001a\u0002\u0004\u0015>\u0014\u0007\"\u00028\u0007\u0001\u0004y\u0017aB8qi&|gn\u001d\t\u0005]AlS&\u0003\u0002ri\t\u0019Q*\u00199\t\u000bM4\u0001\u0019\u0001;\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017\r\u0005\u0002=k&\u0011a/\u0010\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007")
public class OrcWriteBuilder
extends FileWriteBuilder {
    @Override
    public OutputWriterFactory prepareWrite(SQLConf sqlConf, Job job, Map<String, String> options, StructType dataSchema) {
        OrcOptions orcOptions = new OrcOptions(options, sqlConf);
        Configuration conf = job.getConfiguration();
        conf.set(OrcConf.MAPRED_OUTPUT_SCHEMA.getAttribute(), OrcFileFormat$.MODULE$.getQuotedSchemaString((DataType)dataSchema));
        conf.set(OrcConf.COMPRESS.getAttribute(), orcOptions.compressionCodec());
        ((JobConf)conf).setOutputFormat(OrcOutputFormat.class);
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new OrcOutputWriter(path, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                String name = context.getConfiguration().get(OrcConf.COMPRESS.getAttribute());
                String compressionExtension = (String)OrcUtils$.MODULE$.extensionsForCompressionCodecNames().getOrElse((Object)name, (Function0 & Serializable & scala.Serializable)() -> "");
                return new StringBuilder(4).append(compressionExtension).append(".orc").toString();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getFileExtension$1()}, serializedLambda);
            }
        };
    }

    public OrcWriteBuilder(Seq<String> paths, String formatName, Function1<DataType, Object> supportsDataType, LogicalWriteInfo info) {
        super(paths, formatName, supportsDataType, info);
    }
}

