/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.IntDelta$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.IntegerType$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005uxA\u0002\u0015*\u0011\u0003[sG\u0002\u0004:S!\u00055F\u000f\u0005\u0006\u0015\u0006!\t\u0001\u0014\u0005\u0006\u001b\u0006!\tE\u0014\u0005\u0006%\u0006!\te\u0015\u0005\u0006m\u0006!\te\u001e\u0005\b\u0003\u0003\tA\u0011IA\u0002\r\u0015Y\u0018\u0001AA\u0012\u0011\u0019Qu\u0001\"\u0001\u0002.!A\u00111G\u0004A\u0002\u0013Ea\nC\u0005\u00026\u001d\u0001\r\u0011\"\u0005\u00028!9\u00111I\u0004!B\u0013y\u0005\u0002CA#\u000f\u0001\u0007I\u0011\u0003(\t\u0013\u0005\u001ds\u00011A\u0005\u0012\u0005%\u0003bBA'\u000f\u0001\u0006Ka\u0014\u0005\u0007\u0003\u001f:A\u0011\t(\t\r\u0005Es\u0001\"\u0011O\u0011)\t\u0019f\u0002a\u0001\u0002\u0004%IA\u0014\u0005\f\u0003+:\u0001\u0019!a\u0001\n\u0013\t9\u0006\u0003\u0006\u0002\\\u001d\u0001\r\u0011!Q!\n=Cq!!\u0018\b\t\u0003\ny\u0006C\u0004\u0002v\u001d!\t%a\u001e\u0007\u000b]\u000b\u0001!!!\t\u0011\u001d4\"\u0011!Q\u0001\n!D\u0011\"\u001d\f\u0003\u0002\u0003\u0006I!!\"\t\r)3B\u0011AAD\u0011)\tyI\u0006a\u0001\u0002\u0004%IA\u0014\u0005\f\u0003#3\u0002\u0019!a\u0001\n\u0013\t\u0019\n\u0003\u0006\u0002\u0018Z\u0001\r\u0011!Q!\n=Cq!!'\u0017\t\u0003\nY\nC\u0004\u0002\u001eZ!\t%a(\t\u000f\u0005\u0015f\u0003\"\u0011\u0002(\"I\u0011QX\u0001\u0002\u0002\u0013\u0005\u0013q\u0018\u0005\t\u0003\u001b\f\u0011\u0011!C\u0001\u001d\"I\u0011qZ\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u001b\u0005\n\u0003+\f\u0011\u0011!C!\u0003/D\u0011\"!:\u0002\u0003\u0003%\t!a:\t\u0013\u0005-\u0018!!A\u0005B\u00055\b\"CAx\u0003\u0005\u0005I\u0011IAy\u0011%\t\u00190AA\u0001\n\u0013\t)0\u0001\u0005J]R$U\r\u001c;b\u0015\tQ3&A\u0006d_6\u0004(/Z:tS>t'B\u0001\u0017.\u0003!\u0019w\u000e\\;n]\u0006\u0014(B\u0001\u00180\u0003%)\u00070Z2vi&|gN\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005I\u001a\u0014!B:qCJ\\'B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001e\u0004\"\u0001O\u0001\u000e\u0003%\u0012\u0001\"\u00138u\t\u0016dG/Y\n\u0006\u0003m\nEi\u0012\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005a\u0012\u0015BA\"*\u0005E\u0019u.\u001c9sKN\u001c\u0018n\u001c8TG\",W.\u001a\t\u0003y\u0015K!AR\u001f\u0003\u000fA\u0013x\u000eZ;diB\u0011A\bS\u0005\u0003\u0013v\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002o\u00051A/\u001f9f\u0013\u0012,\u0012a\u0014\t\u0003yAK!!U\u001f\u0003\u0007%sG/A\u0004eK\u000e|G-\u001a:\u0016\u0005QSFcA+gaB\u0019\u0001H\u0016-\n\u0005]K#a\u0002#fG>$WM\u001d\t\u00033jc\u0001\u0001B\u0003\\\t\t\u0007ALA\u0001U#\ti\u0006\r\u0005\u0002==&\u0011q,\u0010\u0002\b\u001d>$\b.\u001b8h!\t\tG-D\u0001c\u0015\t\u0019w&A\u0003usB,7/\u0003\u0002fE\nQ\u0011\t^8nS\u000e$\u0016\u0010]3\t\u000b\u001d$\u0001\u0019\u00015\u0002\r\t,hMZ3s!\tIg.D\u0001k\u0015\tYG.A\u0002oS>T\u0011!\\\u0001\u0005U\u00064\u0018-\u0003\u0002pU\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000bE$\u0001\u0019\u0001:\u0002\u0015\r|G.^7o)f\u0004X\rE\u0002tibk\u0011aK\u0005\u0003k.\u0012\u0001CT1uSZ,7i\u001c7v[:$\u0016\u0010]3\u0002\u000f\u0015t7m\u001c3feV\u0011\u00010 \u000b\u0003sz\u00042\u0001\u000f>}\u0013\tY\u0018FA\u0004F]\u000e|G-\u001a:\u0011\u0005ekH!B.\u0006\u0005\u0004a\u0006\"B9\u0006\u0001\u0004y\bcA:uy\u0006A1/\u001e9q_J$8\u000f\u0006\u0003\u0002\u0006\u0005-\u0001c\u0001\u001f\u0002\b%\u0019\u0011\u0011B\u001f\u0003\u000f\t{w\u000e\\3b]\"1\u0011O\u0002a\u0001\u0003\u001b\u0001D!a\u0004\u0002\u0018A)1/!\u0005\u0002\u0016%\u0019\u00111C\u0016\u0003\u0015\r{G.^7o)f\u0004X\rE\u0002Z\u0003/!A\"!\u0007\u0002\f\u0005\u0005\t\u0011!B\u0001\u00037\u00111a\u0018\u00136#\ri\u0016Q\u0004\t\u0004y\u0005}\u0011bAA\u0011{\t\u0019\u0011I\\=\u0014\t\u001dY\u0014Q\u0005\t\u0005qi\f9CD\u0002b\u0003SI1!a\u000bc\u0003-Ie\u000e^3hKJ$\u0016\u0010]3\u0015\u0005\u0005=\u0002cAA\u0019\u000f5\t\u0011!A\b`G>l\u0007O]3tg\u0016$7+\u001b>f\u0003My6m\\7qe\u0016\u001c8/\u001a3TSj,w\fJ3r)\u0011\tI$a\u0010\u0011\u0007q\nY$C\u0002\u0002>u\u0012A!\u00168ji\"A\u0011\u0011\t\u0006\u0002\u0002\u0003\u0007q*A\u0002yIE\n\u0001cX2p[B\u0014Xm]:fINK'0\u001a\u0011\u0002#}+hnY8naJ,7o]3e'&TX-A\u000b`k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016|F%Z9\u0015\t\u0005e\u00121\n\u0005\t\u0003\u0003j\u0011\u0011!a\u0001\u001f\u0006\u0011r,\u001e8d_6\u0004(/Z:tK\u0012\u001c\u0016N_3!\u00039\u0019w.\u001c9sKN\u001cX\rZ*ju\u0016\f\u0001#\u001e8d_6\u0004(/Z:tK\u0012\u001c\u0016N_3\u0002\u0013A\u0014XM\u001e,bYV,\u0017!\u00049sKZ4\u0016\r\\;f?\u0012*\u0017\u000f\u0006\u0003\u0002:\u0005e\u0003\u0002CA!%\u0005\u0005\t\u0019A(\u0002\u0015A\u0014XM\u001e,bYV,\u0007%\u0001\u000ehCRDWM]\"p[B\u0014Xm]:jE&d\u0017\u000e^=Ti\u0006$8\u000f\u0006\u0004\u0002:\u0005\u0005\u0014\u0011\u000f\u0005\b\u0003G\"\u0002\u0019AA3\u0003\r\u0011xn\u001e\t\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111N\u0018\u0002\u0011\r\fG/\u00197zgRLA!a\u001c\u0002j\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0019\t\u0019\b\u0006a\u0001\u001f\u00069qN\u001d3j]\u0006d\u0017\u0001C2p[B\u0014Xm]:\u0015\u000b!\fI(! \t\r\u0005mT\u00031\u0001i\u0003\u00111'o\\7\t\r\u0005}T\u00031\u0001i\u0003\t!xn\u0005\u0003\u0017w\u0005\r\u0005\u0003\u0002\u001dW\u0003O\u0001Ba\u001d;\u0002(Q1\u0011\u0011RAF\u0003\u001b\u00032!!\r\u0017\u0011\u00159\u0017\u00041\u0001i\u0011\u0019\t\u0018\u00041\u0001\u0002\u0006\u0006!\u0001O]3w\u0003!\u0001(/\u001a<`I\u0015\fH\u0003BA\u001d\u0003+C\u0001\"!\u0011\u001c\u0003\u0003\u0005\raT\u0001\u0006aJ,g\u000fI\u0001\bQ\u0006\u001ch*\u001a=u+\t\t)!\u0001\u0003oKb$HCBA\u001d\u0003C\u000b\u0019\u000bC\u0004\u0002dy\u0001\r!!\u001a\t\r\u0005Md\u00041\u0001P\u0003)!WmY8naJ,7o\u001d\u000b\u0007\u0003s\tI+!/\t\u000f\u0005-v\u00041\u0001\u0002.\u0006a1m\u001c7v[:4Vm\u0019;peB!\u0011qVA[\u001b\t\t\tLC\u0002\u000246\n!B^3di>\u0014\u0018N_3e\u0013\u0011\t9,!-\u0003)]\u0013\u0018\u000e^1cY\u0016\u001cu\u000e\\;n]Z+7\r^8s\u0011\u0019\tYl\ba\u0001\u001f\u0006A1-\u00199bG&$\u00180A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0003\u0004B!a1\u0002J6\u0011\u0011Q\u0019\u0006\u0004\u0003\u000fd\u0017\u0001\u00027b]\u001eLA!a3\u0002F\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u001e\u0005M\u0007\u0002CA!E\u0005\u0005\t\u0019A(\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!7\u0011\r\u0005m\u0017\u0011]A\u000f\u001b\t\tiNC\u0002\u0002`v\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019/!8\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u000b\tI\u000fC\u0005\u0002B\u0011\n\t\u00111\u0001\u0002\u001e\u0005A\u0001.Y:i\u0007>$W\rF\u0001P\u0003!!xn\u0015;sS:<GCAAa\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005]\b\u0003BAb\u0003sLA!a?\u0002F\n1qJ\u00196fGR\u0004")
public final class IntDelta {
    public static String toString() {
        return IntDelta$.MODULE$.toString();
    }

    public static int hashCode() {
        return IntDelta$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return IntDelta$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return IntDelta$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return IntDelta$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return IntDelta$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return IntDelta$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return IntDelta$.MODULE$.supports(columnType);
    }

    public static <T extends AtomicType> org.apache.spark.sql.execution.columnar.compression.Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return IntDelta$.MODULE$.encoder(nativeColumnType);
    }

    public static <T extends AtomicType> org.apache.spark.sql.execution.columnar.compression.Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return IntDelta$.MODULE$.decoder(byteBuffer, nativeColumnType);
    }

    public static int typeId() {
        return IntDelta$.MODULE$.typeId();
    }

    public static class Decoder
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<IntegerType$> {
        private final ByteBuffer buffer;
        private int prev;

        private int prev() {
            return this.prev;
        }

        private void prev_$eq(int x$1) {
            this.prev = x$1;
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            byte delta = this.buffer.get();
            this.prev_$eq(delta > -128 ? this.prev() + delta : ByteBufferHelper$.MODULE$.getInt(this.buffer));
            row.setInt(ordinal, this.prev());
        }

        @Override
        public void decompress(WritableColumnVector columnVector, int capacity) {
            int prevLocal = 0;
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            for (int pos = 0; pos < capacity; ++pos) {
                if (pos != nextNullIndex) {
                    byte delta = this.buffer.get();
                    prevLocal = delta > -128 ? prevLocal + delta : ByteBufferHelper$.MODULE$.getInt(this.buffer);
                    columnVector.putInt(pos, prevLocal);
                    continue;
                }
                if (++seenNulls < nullCount) {
                    nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                }
                columnVector.putNull(pos);
            }
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<IntegerType$> columnType) {
            this.buffer = buffer;
        }
    }

    public static class Encoder
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<IntegerType$> {
        private int _compressedSize;
        private int _uncompressedSize;
        private int prevValue;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        public int _compressedSize() {
            return this._compressedSize;
        }

        public void _compressedSize_$eq(int x$1) {
            this._compressedSize = x$1;
        }

        public int _uncompressedSize() {
            return this._uncompressedSize;
        }

        public void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        @Override
        public int compressedSize() {
            return this._compressedSize();
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        private int prevValue() {
            return this.prevValue;
        }

        private void prevValue_$eq(int x$1) {
            this.prevValue = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            int value = row.getInt(ordinal);
            int delta = value - this.prevValue();
            this._compressedSize_$eq(this._compressedSize() + 1);
            if (this._uncompressedSize() == 0 || delta <= -128 || delta > 127) {
                this._compressedSize_$eq(this._compressedSize() + INT$.MODULE$.defaultSize());
            }
            this._uncompressedSize_$eq(this._uncompressedSize() + INT$.MODULE$.defaultSize());
            this.prevValue_$eq(value);
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            to.putInt(IntDelta$.MODULE$.typeId());
            if (from.hasRemaining()) {
                int prev = from.getInt();
                to.put((byte)-128);
                to.putInt(prev);
                while (from.hasRemaining()) {
                    ByteBuffer byteBuffer;
                    int current = from.getInt();
                    int delta = current - prev;
                    prev = current;
                    if (-128 < delta && delta <= 127) {
                        byteBuffer = to.put((byte)delta);
                        continue;
                    }
                    to.put((byte)-128);
                    byteBuffer = to.putInt(current);
                }
            }
            return (ByteBuffer)to.rewind();
        }

        public Encoder() {
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._compressedSize = 0;
            this._uncompressedSize = 0;
        }
    }
}

