/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SchemaPruning$;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.execution.datasources.DataSourceStrategy$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class PushDownUtils$
implements PredicateHelper {
    public static PushDownUtils$ MODULE$;

    static {
        new PushDownUtils$();
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Tuple2<Seq<Filter>, Seq<Expression>> pushFilters(ScanBuilder scanBuilder, Seq<Expression> filters) {
        Tuple2 tuple2;
        ScanBuilder scanBuilder2 = scanBuilder;
        if (scanBuilder2 instanceof SupportsPushDownFilters) {
            SupportsPushDownFilters supportsPushDownFilters = (SupportsPushDownFilters)scanBuilder2;
            HashMap translatedFilterToExpr = HashMap$.MODULE$.empty();
            ArrayBuffer translatedFilters = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            ArrayBuffer untranslatableExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            filters.foreach((Function1 & Serializable & scala.Serializable)filterExpr -> {
                Option<Filter> translated = DataSourceStrategy$.MODULE$.translateFilterWithMapping((Expression)filterExpr, (Option<HashMap<Filter, Expression>>)new Some((Object)translatedFilterToExpr), true);
                return translated.isEmpty() ? untranslatableExprs.$plus$eq(filterExpr) : translatedFilters.$plus$eq(translated.get());
            });
            Expression[] postScanFilters = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])supportsPushDownFilters.pushFilters((Filter[])translatedFilters.toArray(ClassTag$.MODULE$.apply(Filter.class))))).map((Function1 & Serializable & scala.Serializable)filter -> DataSourceStrategy$.MODULE$.rebuildExpressionFromFilter((Filter)filter, (HashMap<Filter, Expression>)translatedFilterToExpr), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class)));
            tuple2 = new Tuple2((Object)Predef$.MODULE$.wrapRefArray((Object[])supportsPushDownFilters.pushedFilters()), (Object)untranslatableExprs.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])postScanFilters))));
        } else {
            tuple2 = new Tuple2((Object)Nil$.MODULE$, filters);
        }
        return tuple2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Scan, Seq<AttributeReference>> pruneColumns(ScanBuilder scanBuilder, DataSourceV2Relation relation, Seq<NamedExpression> projects, Seq<Expression> filters) {
        Tuple2 tuple2;
        Seq neededOutput;
        boolean bl = false;
        SupportsPushDownRequiredColumns supportsPushDownRequiredColumns = null;
        ScanBuilder scanBuilder2 = scanBuilder;
        if (scanBuilder2 instanceof SupportsPushDownRequiredColumns) {
            bl = true;
            supportsPushDownRequiredColumns = (SupportsPushDownRequiredColumns)scanBuilder2;
            if (SQLConf$.MODULE$.get().nestedSchemaPruningEnabled()) {
                Seq rootFields = SchemaPruning$.MODULE$.identifyRootFields(projects, filters);
                StructType prunedSchema = rootFields.nonEmpty() ? SchemaPruning$.MODULE$.pruneDataSchema(relation.schema(), rootFields) : new StructType();
                supportsPushDownRequiredColumns.pruneColumns(prunedSchema);
                Scan scan = supportsPushDownRequiredColumns.build();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scan), this.toOutputAttrs(scan.readSchema(), relation));
            }
        }
        if (!bl) return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scanBuilder.build()), (Object)relation.output());
        Seq exprs = (Seq)projects.$plus$plus(filters, Seq$.MODULE$.canBuildFrom());
        AttributeSet requiredColumns = AttributeSet$.MODULE$.apply((Iterable)exprs.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.references(), Seq$.MODULE$.canBuildFrom()));
        Seq seq = neededOutput = (Seq)relation.output().filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)requiredColumns.contains(elem)));
        Seq seq2 = relation.output();
        if (seq == null ? seq2 != null : !seq.equals(seq2)) {
            supportsPushDownRequiredColumns.pruneColumns(package$.MODULE$.AttributeSeq(neededOutput).toStructType());
            Scan scan = supportsPushDownRequiredColumns.build();
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scan), this.toOutputAttrs(scan.readSchema(), relation));
            return tuple2;
        } else {
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)supportsPushDownRequiredColumns.build()), (Object)relation.output());
        }
        return tuple2;
    }

    private Seq<AttributeReference> toOutputAttrs(StructType schema, DataSourceV2Relation relation) {
        Map nameToAttr = ((TraversableOnce)((IterableLike)relation.output().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Seq$.MODULE$.canBuildFrom())).zip((GenIterable)relation.output(), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return (Seq)schema.toAttributes().map((Function1 & Serializable & scala.Serializable)a -> a.withExprId(((AttributeReference)nameToAttr.apply((Object)a.name())).exprId()), Seq$.MODULE$.canBuildFrom());
    }

    private PushDownUtils$() {
        MODULE$ = this;
        PredicateHelper.$init$((PredicateHelper)this);
    }
}

