/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression$;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateMode;
import org.apache.spark.sql.catalyst.expressions.aggregate.Complete$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Final$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Partial$;
import org.apache.spark.sql.catalyst.expressions.aggregate.PartialMerge$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.aggregate.HashAggregateExec;
import org.apache.spark.sql.execution.aggregate.HashAggregateExec$;
import org.apache.spark.sql.execution.aggregate.ObjectHashAggregateExec;
import org.apache.spark.sql.execution.aggregate.ObjectHashAggregateExec$;
import org.apache.spark.sql.execution.aggregate.SortAggregateExec;
import org.apache.spark.sql.execution.streaming.StateStoreRestoreExec;
import org.apache.spark.sql.execution.streaming.StateStoreSaveExec;
import org.apache.spark.sql.execution.streaming.StatefulOperatorStateInfo;
import org.apache.spark.sql.streaming.OutputMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;

public final class AggUtils$ {
    public static AggUtils$ MODULE$;

    static {
        new AggUtils$();
    }

    private Seq<AggregateExpression> mayRemoveAggFilters(Seq<AggregateExpression> exprs) {
        return (Seq)exprs.map((Function1 & Serializable & scala.Serializable)ae -> {
            AggregateExpression aggregateExpression;
            if (ae.filter().isDefined()) {
                AggregateExpression aggregateExpression2;
                AggregateMode aggregateMode = ae.mode();
                boolean bl = Partial$.MODULE$.equals(aggregateMode) ? true : Complete$.MODULE$.equals(aggregateMode);
                if (bl) {
                    aggregateExpression2 = ae;
                } else {
                    None$ x$1 = None$.MODULE$;
                    AggregateFunction x$2 = ae.copy$default$1();
                    AggregateMode x$3 = ae.copy$default$2();
                    boolean x$4 = ae.copy$default$3();
                    ExprId x$5 = ae.copy$default$5();
                    aggregateExpression2 = ae.copy(x$2, x$3, x$4, (Option)x$1, x$5);
                }
                aggregateExpression = aggregateExpression2;
            } else {
                aggregateExpression = ae;
            }
            return aggregateExpression;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private SparkPlan createAggregate(Option<Seq<Expression>> requiredChildDistributionExpressions, Seq<NamedExpression> groupingExpressions, Seq<AggregateExpression> aggregateExpressions, Seq<Attribute> aggregateAttributes, int initialInputBufferOffset, Seq<NamedExpression> resultExpressions, SparkPlan child) {
        SparkPlan sparkPlan;
        boolean useHash = HashAggregateExec$.MODULE$.supportsAggregate((Seq<Attribute>)((Seq)aggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.aggregateFunction().aggBufferAttributes(), Seq$.MODULE$.canBuildFrom())));
        if (useHash) {
            sparkPlan = new HashAggregateExec(requiredChildDistributionExpressions, groupingExpressions, this.mayRemoveAggFilters(aggregateExpressions), aggregateAttributes, initialInputBufferOffset, resultExpressions, child);
        } else {
            boolean objectHashEnabled = child.sqlContext().conf().useObjectHashAggregation();
            boolean useObjectHash = ObjectHashAggregateExec$.MODULE$.supportsAggregate(aggregateExpressions);
            sparkPlan = objectHashEnabled && useObjectHash ? new ObjectHashAggregateExec(requiredChildDistributionExpressions, groupingExpressions, this.mayRemoveAggFilters(aggregateExpressions), aggregateAttributes, initialInputBufferOffset, resultExpressions, child) : new SortAggregateExec(requiredChildDistributionExpressions, groupingExpressions, this.mayRemoveAggFilters(aggregateExpressions), aggregateAttributes, initialInputBufferOffset, resultExpressions, child);
        }
        return sparkPlan;
    }

    private Option<Seq<Expression>> createAggregate$default$1() {
        return None$.MODULE$;
    }

    private Seq<NamedExpression> createAggregate$default$2() {
        return Nil$.MODULE$;
    }

    private Seq<AggregateExpression> createAggregate$default$3() {
        return Nil$.MODULE$;
    }

    private Seq<Attribute> createAggregate$default$4() {
        return Nil$.MODULE$;
    }

    private int createAggregate$default$5() {
        return 0;
    }

    private Seq<NamedExpression> createAggregate$default$6() {
        return Nil$.MODULE$;
    }

    public Seq<SparkPlan> planAggregateWithoutDistinct(Seq<NamedExpression> groupingExpressions, Seq<AggregateExpression> aggregateExpressions, Seq<NamedExpression> resultExpressions, SparkPlan child) {
        SparkPlan finalAggregate;
        Seq groupingAttributes = (Seq)groupingExpressions.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq partialAggregateExpressions = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$3 -> {
            Partial$ x$1 = Partial$.MODULE$;
            AggregateFunction x$2 = x$3.copy$default$1();
            boolean x$32 = x$3.copy$default$3();
            Option x$4 = x$3.copy$default$4();
            ExprId x$5 = x$3.copy$default$5();
            return x$3.copy(x$2, (AggregateMode)x$1, x$32, x$4, x$5);
        }, Seq$.MODULE$.canBuildFrom());
        Seq partialAggregateAttributes = (Seq)partialAggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.aggregateFunction().aggBufferAttributes(), Seq$.MODULE$.canBuildFrom());
        Seq partialResultExpressions = (Seq)groupingAttributes.$plus$plus((GenTraversableOnce)partialAggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        SparkPlan partialAggregate = this.createAggregate((Option<Seq<Expression>>)None$.MODULE$, groupingExpressions, (Seq<AggregateExpression>)partialAggregateExpressions, (Seq<Attribute>)partialAggregateAttributes, 0, (Seq<NamedExpression>)partialResultExpressions, child);
        Seq finalAggregateExpressions = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$6 -> {
            Final$ x$62 = Final$.MODULE$;
            AggregateFunction x$7 = x$6.copy$default$1();
            boolean x$8 = x$6.copy$default$3();
            Option x$9 = x$6.copy$default$4();
            ExprId x$10 = x$6.copy$default$5();
            return x$6.copy(x$7, (AggregateMode)x$62, x$8, x$9, x$10);
        }, Seq$.MODULE$.canBuildFrom());
        Seq finalAggregateAttributes = (Seq)finalAggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        SparkPlan sparkPlan = finalAggregate = this.createAggregate((Option<Seq<Expression>>)new Some((Object)groupingAttributes), (Seq<NamedExpression>)groupingAttributes, (Seq<AggregateExpression>)finalAggregateExpressions, (Seq<Attribute>)finalAggregateAttributes, groupingExpressions.length(), resultExpressions, partialAggregate);
        return Nil$.MODULE$.$colon$colon((Object)sparkPlan);
    }

    public Seq<SparkPlan> planAggregateWithOneDistinct(Seq<NamedExpression> groupingExpressions, Seq<AggregateExpression> functionsWithDistinct, Seq<AggregateExpression> functionsWithoutDistinct, Seq<NamedExpression> resultExpressions, SparkPlan child) {
        SparkPlan finalAndCompleteAggregate;
        Seq distinctExpressions = ((AggregateExpression)functionsWithDistinct.head()).aggregateFunction().children();
        Seq namedDistinctExpressions = (Seq)distinctExpressions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            NamedExpression namedExpression;
            Expression expression = x0$1;
            if (expression instanceof NamedExpression) {
                NamedExpression namedExpression2;
                namedExpression = namedExpression2 = (NamedExpression)expression;
            } else {
                Expression x$1 = expression;
                String x$2 = expression.toString();
                ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
                Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
                namedExpression = new Alias(x$1, x$2, x$3, x$4, x$5);
            }
            return namedExpression;
        }, Seq$.MODULE$.canBuildFrom());
        Seq distinctAttributes = (Seq)namedDistinctExpressions.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq groupingAttributes = (Seq)groupingExpressions.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq aggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$11 -> {
            Partial$ x$6 = Partial$.MODULE$;
            AggregateFunction x$7 = x$11.copy$default$1();
            boolean x$8 = x$11.copy$default$3();
            Option x$9 = x$11.copy$default$4();
            ExprId x$10 = x$11.copy$default$5();
            return x$11.copy(x$7, (AggregateMode)x$6, x$8, x$9, x$10);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq x$112 = (Seq)groupingExpressions.$plus$plus((GenTraversableOnce)namedDistinctExpressions, Seq$.MODULE$.canBuildFrom());
        Seq x$122 = aggregateExpressions;
        Seq x$132 = aggregateAttributes;
        Seq x$142 = (Seq)((TraversableLike)groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)aggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$13 -> x$13.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        SparkPlan x$152 = child;
        Option<Seq<Expression>> x$162 = this.createAggregate$default$1();
        int x$172 = this.createAggregate$default$5();
        SparkPlan partialAggregate = this.createAggregate(x$162, (Seq<NamedExpression>)x$112, (Seq<AggregateExpression>)x$122, (Seq<Attribute>)x$132, x$172, (Seq<NamedExpression>)x$142, x$152);
        Seq aggregateExpressions2 = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$14 -> {
            PartialMerge$ x$18 = PartialMerge$.MODULE$;
            AggregateFunction x$19 = x$14.copy$default$1();
            boolean x$20 = x$14.copy$default$3();
            Option x$21 = x$14.copy$default$4();
            ExprId x$22 = x$14.copy$default$5();
            return x$14.copy(x$19, (AggregateMode)x$18, x$20, x$21, x$22);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes2 = (Seq)aggregateExpressions2.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        SparkPlan partialMergeAggregate = this.createAggregate((Option<Seq<Expression>>)new Some(groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom())), (Seq<NamedExpression>)((Seq)groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom())), (Seq<AggregateExpression>)aggregateExpressions2, (Seq<Attribute>)aggregateAttributes2, ((SeqLike)groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom())).length(), (Seq<NamedExpression>)((Seq)((TraversableLike)groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)aggregateExpressions2.flatMap((Function1 & Serializable & scala.Serializable)x$16 -> x$16.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())), partialAggregate);
        Map distinctColumnAttributeLookup = ((TraversableOnce)distinctExpressions.zip((GenIterable)distinctAttributes, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq rewrittenDistinctFunctions = (Seq)functionsWithDistinct.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            AggregateFunction aggregateFunction;
            block3: {
                AggregateExpression aggregateExpression;
                block2: {
                    aggregateExpression = x0$2;
                    if (aggregateExpression == null) break block2;
                    aggregateFunction = aggregateExpression.aggregateFunction();
                    boolean bl = aggregateExpression.isDistinct();
                    if (bl) break block3;
                }
                throw new IllegalArgumentException(new StringBuilder(90).append("Non-distinct aggregate is found in functionsWithDistinct ").append("at planAggregateWithOneDistinct: ").append(aggregateExpression).toString());
            }
            AggregateFunction aggregateFunction2 = (AggregateFunction)aggregateFunction.transformDown((PartialFunction)distinctColumnAttributeLookup);
            return aggregateFunction2;
        }, Seq$.MODULE$.canBuildFrom());
        Seq mergeAggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$17 -> {
            PartialMerge$ x$23 = PartialMerge$.MODULE$;
            AggregateFunction x$24 = x$17.copy$default$1();
            boolean x$25 = x$17.copy$default$3();
            Option x$26 = x$17.copy$default$4();
            ExprId x$27 = x$17.copy$default$5();
            return x$17.copy(x$24, (AggregateMode)x$23, x$25, x$26, x$27);
        }, Seq$.MODULE$.canBuildFrom());
        Seq mergeAggregateAttributes = (Seq)mergeAggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = ((GenericTraversableTemplate)((TraversableLike)rewrittenDistinctFunctions.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AggregateFunction func = (AggregateFunction)tuple2._1();
            int i = tuple2._2$mcI$sp();
            AggregateExpression expr = AggregateExpression$.MODULE$.apply(func, (AggregateMode)Partial$.MODULE$, true, AggregateExpression$.MODULE$.apply$default$4());
            Attribute attr = ((AggregateExpression)functionsWithDistinct.apply(i)).resultAttribute();
            Tuple2 tuple22 = new Tuple2((Object)expr, (Object)attr);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq distinctAggregateExpressions = (Seq)tuple2._1();
        Seq distinctAggregateAttributes = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)distinctAggregateExpressions, (Object)distinctAggregateAttributes);
        Tuple2 tuple23 = tuple22;
        Seq distinctAggregateExpressions2 = (Seq)tuple23._1();
        Seq distinctAggregateAttributes2 = (Seq)tuple23._2();
        Seq partialAggregateResult = (Seq)((TraversableLike)groupingAttributes.$plus$plus((GenTraversableOnce)mergeAggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$20 -> x$20.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)distinctAggregateExpressions2.flatMap((Function1 & Serializable & scala.Serializable)x$21 -> x$21.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Seq x$28 = groupingAttributes;
        Seq x$29 = (Seq)mergeAggregateExpressions.$plus$plus((GenTraversableOnce)distinctAggregateExpressions2, Seq$.MODULE$.canBuildFrom());
        Seq x$30 = (Seq)mergeAggregateAttributes.$plus$plus((GenTraversableOnce)distinctAggregateAttributes2, Seq$.MODULE$.canBuildFrom());
        int x$31 = ((SeqLike)groupingAttributes.$plus$plus((GenTraversableOnce)distinctAttributes, Seq$.MODULE$.canBuildFrom())).length();
        Seq x$32 = partialAggregateResult;
        SparkPlan x$33 = partialMergeAggregate;
        Option<Seq<Expression>> x$34 = this.createAggregate$default$1();
        SparkPlan partialDistinctAggregate = this.createAggregate(x$34, (Seq<NamedExpression>)x$28, (Seq<AggregateExpression>)x$29, (Seq<Attribute>)x$30, x$31, (Seq<NamedExpression>)x$32, x$33);
        Seq finalAggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$22 -> {
            Final$ x$35 = Final$.MODULE$;
            AggregateFunction x$36 = x$22.copy$default$1();
            boolean x$37 = x$22.copy$default$3();
            Option x$38 = x$22.copy$default$4();
            ExprId x$39 = x$22.copy$default$5();
            return x$22.copy(x$36, (AggregateMode)x$35, x$37, x$38, x$39);
        }, Seq$.MODULE$.canBuildFrom());
        Seq finalAggregateAttributes = (Seq)finalAggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple24 = ((GenericTraversableTemplate)((TraversableLike)rewrittenDistinctFunctions.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AggregateFunction func = (AggregateFunction)tuple2._1();
            int i = tuple2._2$mcI$sp();
            AggregateExpression expr = AggregateExpression$.MODULE$.apply(func, (AggregateMode)Final$.MODULE$, true, AggregateExpression$.MODULE$.apply$default$4());
            Attribute attr = ((AggregateExpression)functionsWithDistinct.apply(i)).resultAttribute();
            Tuple2 tuple22 = new Tuple2((Object)expr, (Object)attr);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Seq distinctAggregateExpressions3 = (Seq)tuple24._1();
        Seq distinctAggregateAttributes3 = (Seq)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)distinctAggregateExpressions3, (Object)distinctAggregateAttributes3);
        Tuple2 tuple26 = tuple25;
        Seq distinctAggregateExpressions4 = (Seq)tuple26._1();
        Seq distinctAggregateAttributes4 = (Seq)tuple26._2();
        SparkPlan sparkPlan = finalAndCompleteAggregate = this.createAggregate((Option<Seq<Expression>>)new Some((Object)groupingAttributes), (Seq<NamedExpression>)groupingAttributes, (Seq<AggregateExpression>)((Seq)finalAggregateExpressions.$plus$plus((GenTraversableOnce)distinctAggregateExpressions4, Seq$.MODULE$.canBuildFrom())), (Seq<Attribute>)((Seq)finalAggregateAttributes.$plus$plus((GenTraversableOnce)distinctAggregateAttributes4, Seq$.MODULE$.canBuildFrom())), groupingAttributes.length(), resultExpressions, partialDistinctAggregate);
        return Nil$.MODULE$.$colon$colon((Object)sparkPlan);
    }

    public Seq<SparkPlan> planStreamingAggregation(Seq<NamedExpression> groupingExpressions, Seq<AggregateExpression> functionsWithoutDistinct, Seq<NamedExpression> resultExpressions, int stateFormatVersion, SparkPlan child) {
        SparkPlan finalAndCompleteAggregate;
        Seq groupingAttributes = (Seq)groupingExpressions.map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq aggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$27 -> {
            Partial$ x$1 = Partial$.MODULE$;
            AggregateFunction x$2 = x$27.copy$default$1();
            boolean x$3 = x$27.copy$default$3();
            Option x$4 = x$27.copy$default$4();
            ExprId x$5 = x$27.copy$default$5();
            return x$27.copy(x$2, (AggregateMode)x$1, x$3, x$4, x$5);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes = (Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq<NamedExpression> x$6 = groupingExpressions;
        Seq x$7 = aggregateExpressions;
        Seq x$8 = aggregateAttributes;
        Seq x$9 = (Seq)groupingAttributes.$plus$plus((GenTraversableOnce)aggregateExpressions.flatMap((Function1 & Serializable & scala.Serializable)x$29 -> x$29.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        SparkPlan x$10 = child;
        Option<Seq<Expression>> x$11 = this.createAggregate$default$1();
        int x$12 = this.createAggregate$default$5();
        SparkPlan partialAggregate = this.createAggregate(x$11, x$6, (Seq<AggregateExpression>)x$7, (Seq<Attribute>)x$8, x$12, (Seq<NamedExpression>)x$9, x$10);
        Seq aggregateExpressions2 = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$30 -> {
            PartialMerge$ x$13 = PartialMerge$.MODULE$;
            AggregateFunction x$14 = x$30.copy$default$1();
            boolean x$15 = x$30.copy$default$3();
            Option x$16 = x$30.copy$default$4();
            ExprId x$17 = x$30.copy$default$5();
            return x$30.copy(x$14, (AggregateMode)x$13, x$15, x$16, x$17);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes2 = (Seq)aggregateExpressions2.map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        SparkPlan partialMerged1 = this.createAggregate((Option<Seq<Expression>>)new Some((Object)groupingAttributes), (Seq<NamedExpression>)groupingAttributes, (Seq<AggregateExpression>)aggregateExpressions2, (Seq<Attribute>)aggregateAttributes2, groupingAttributes.length(), (Seq<NamedExpression>)((Seq)groupingAttributes.$plus$plus((GenTraversableOnce)aggregateExpressions2.flatMap((Function1 & Serializable & scala.Serializable)x$32 -> x$32.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())), partialAggregate);
        StateStoreRestoreExec restored = new StateStoreRestoreExec((Seq<Attribute>)groupingAttributes, (Option<StatefulOperatorStateInfo>)None$.MODULE$, stateFormatVersion, partialMerged1);
        Seq aggregateExpressions3 = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$33 -> {
            PartialMerge$ x$18 = PartialMerge$.MODULE$;
            AggregateFunction x$19 = x$33.copy$default$1();
            boolean x$20 = x$33.copy$default$3();
            Option x$21 = x$33.copy$default$4();
            ExprId x$22 = x$33.copy$default$5();
            return x$33.copy(x$19, (AggregateMode)x$18, x$20, x$21, x$22);
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregateAttributes3 = (Seq)aggregateExpressions3.map((Function1 & Serializable & scala.Serializable)x$34 -> x$34.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        SparkPlan partialMerged2 = this.createAggregate((Option<Seq<Expression>>)new Some((Object)groupingAttributes), (Seq<NamedExpression>)groupingAttributes, (Seq<AggregateExpression>)aggregateExpressions3, (Seq<Attribute>)aggregateAttributes3, groupingAttributes.length(), (Seq<NamedExpression>)((Seq)groupingAttributes.$plus$plus((GenTraversableOnce)aggregateExpressions3.flatMap((Function1 & Serializable & scala.Serializable)x$35 -> x$35.aggregateFunction().inputAggBufferAttributes(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())), restored);
        StateStoreSaveExec saved = new StateStoreSaveExec((Seq<Attribute>)groupingAttributes, (Option<StatefulOperatorStateInfo>)None$.MODULE$, (Option<OutputMode>)None$.MODULE$, (Option<Object>)None$.MODULE$, stateFormatVersion, partialMerged2);
        Seq finalAggregateExpressions = (Seq)functionsWithoutDistinct.map((Function1 & Serializable & scala.Serializable)x$36 -> {
            Final$ x$23 = Final$.MODULE$;
            AggregateFunction x$24 = x$36.copy$default$1();
            boolean x$25 = x$36.copy$default$3();
            Option x$26 = x$36.copy$default$4();
            ExprId x$27 = x$36.copy$default$5();
            return x$36.copy(x$24, (AggregateMode)x$23, x$25, x$26, x$27);
        }, Seq$.MODULE$.canBuildFrom());
        Seq finalAggregateAttributes = (Seq)finalAggregateExpressions.map((Function1 & Serializable & scala.Serializable)x$37 -> x$37.resultAttribute(), Seq$.MODULE$.canBuildFrom());
        SparkPlan sparkPlan = finalAndCompleteAggregate = this.createAggregate((Option<Seq<Expression>>)new Some((Object)groupingAttributes), (Seq<NamedExpression>)groupingAttributes, (Seq<AggregateExpression>)finalAggregateExpressions, (Seq<Attribute>)finalAggregateAttributes, groupingAttributes.length(), resultExpressions, saved);
        return Nil$.MODULE$.$colon$colon((Object)sparkPlan);
    }

    private AggUtils$() {
        MODULE$ = this;
    }
}

