/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.AppendData$;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelectStatement;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic$;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelectStatement;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsCatalogOptions;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Stable
@ScalaSignature(bytes="\u0006\u0001\r}a\u0001\u0002\u001f>\u0005\u0019C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\u0007=\u0002!\t!P0\t\u000f\t\u0004!\u0019!C\u0005G\"11\u000e\u0001Q\u0001\n\u0011DQ\u0001\u001c\u0001\u0005\u00025DQ\u0001\u001c\u0001\u0005\u0002MDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\n\u0001!\t!a\u0003\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\u0016!9\u0011\u0011\u0002\u0001\u0005\u0002\u0005\u0005\u0002bBA\u0005\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003s\u0001A\u0011AA\u001e\u0011\u001d\tI\u0004\u0001C\u0001\u0003\u0017Bq!!\u0018\u0001\t\u0003\ty\u0006C\u0004\u0002z\u0001!\t!a\u001f\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005m\u0005bBAM\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0003S\u0003A\u0011BAT\u0011\u001d\tY\u000b\u0001C\u0001\u0003[Cq!a+\u0001\t\u0013\t\u0019\fC\u0004\u0002,\u0002!I!!5\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\"9\u0011q\u001f\u0001\u0005\n\u0005e\bbBA\u0000\u0001\u0011%!\u0011\u0001\u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u0011\u001d\u0011)\u0001\u0001C\u0005\u0005\u0017AqA!\u0002\u0001\t\u0013\u0011Y\u0003C\u0004\u00030\u0001!IA!\r\t\u000f\tU\u0002\u0001\"\u0003\u00038!9!q\t\u0001\u0005\n\t%\u0003b\u0002B+\u0001\u0011\u0005!q\u000b\u0005\b\u0005W\u0002A\u0011\u0001B7\u0011\u001d\u0011\t\b\u0001C\u0001\u0005gBqAa\u001e\u0001\t\u0003\u0011I\bC\u0004\u0003~\u0001!\tAa \t\u000f\t\r\u0005\u0001\"\u0001\u0003\u0006\"9!\u0011\u0012\u0001\u0005\n\t-\u0005b\u0002BY\u0001\u0011%!1\u0017\u0005\n\u0003\u000f\u0001\u0001\u0019!C\u0005\u0005{C\u0011Ba0\u0001\u0001\u0004%IA!1\t\u000f\t\u001d\u0007\u0001)Q\u0005k\"AA\u000e\u0001a\u0001\n\u0013\u0011I\rC\u0005\u0003L\u0002\u0001\r\u0011\"\u0003\u0003N\"9!\u0011\u001b\u0001!B\u0013\u0001\b\"\u0003Bj\u0001\t\u0007I\u0011\u0002Bk\u0011!\u0011\u0019\u000f\u0001Q\u0001\n\t]\u0007\"\u0003Bs\u0001\u0001\u0007I\u0011\u0002Bt\u0011%\u0011Y\u000f\u0001a\u0001\n\u0013\u0011i\u000f\u0003\u0005\u0003r\u0002\u0001\u000b\u0015\u0002Bu\u0011%\u0011\u0019\u0010\u0001a\u0001\n\u0013\u00119\u000fC\u0005\u0003v\u0002\u0001\r\u0011\"\u0003\u0003x\"A!1 \u0001!B\u0013\u0011I\u000fC\u0005\u0002\u0000\u0001\u0001\r\u0011\"\u0003\u0003~\"I1\u0011\u0001\u0001A\u0002\u0013%11\u0001\u0005\t\u0007\u000f\u0001\u0001\u0015)\u0003\u0003\u0000\"I1\u0011\u0002\u0001A\u0002\u0013%!q\u001d\u0005\n\u0007\u0017\u0001\u0001\u0019!C\u0005\u0007\u001bA\u0001b!\u0005\u0001A\u0003&!\u0011\u001e\u0002\u0010\t\u0006$\u0018M\u0012:b[\u0016<&/\u001b;fe*\u0011ahP\u0001\u0004gFd'B\u0001!B\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00115)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\t\u0006\u0019qN]4\u0004\u0001U\u0011q)V\n\u0003\u0001!\u0003\"!\u0013'\u000e\u0003)S\u0011aS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b*\u0013a!\u00118z%\u00164\u0017A\u00013t!\r\u0001\u0016kU\u0007\u0002{%\u0011!+\u0010\u0002\b\t\u0006$\u0018m]3u!\t!V\u000b\u0004\u0001\u0005\u000bY\u0003!\u0019A,\u0003\u0003Q\u000b\"\u0001W.\u0011\u0005%K\u0016B\u0001.K\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\u0013/\n\u0005uS%aA!os\u00061A(\u001b8jiz\"\"\u0001Y1\u0011\u0007A\u00031\u000bC\u0003O\u0005\u0001\u0007q*\u0001\u0002eMV\tA\r\u0005\u0002fQ:\u0011\u0001KZ\u0005\u0003Ov\nq\u0001]1dW\u0006<W-\u0003\u0002jU\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003Ov\n1\u0001\u001a4!\u0003\u0011iw\u000eZ3\u0015\u0005\u0001t\u0007\"B8\u0006\u0001\u0004\u0001\u0018\u0001C:bm\u0016lu\u000eZ3\u0011\u0005A\u000b\u0018B\u0001:>\u0005!\u0019\u0016M^3N_\u0012,GC\u00011u\u0011\u0015yg\u00011\u0001v!\t1XP\u0004\u0002xwB\u0011\u0001PS\u0007\u0002s*\u0011!0R\u0001\u0007yI|w\u000e\u001e \n\u0005qT\u0015A\u0002)sK\u0012,g-\u0003\u0002\u007f\u007f\n11\u000b\u001e:j]\u001eT!\u0001 &\u0002\r\u0019|'/\\1u)\r\u0001\u0017Q\u0001\u0005\u0007\u0003\u000f9\u0001\u0019A;\u0002\rM|WO]2f\u0003\u0019y\u0007\u000f^5p]R)\u0001-!\u0004\u0002\u0012!1\u0011q\u0002\u0005A\u0002U\f1a[3z\u0011\u0019\t\u0019\u0002\u0003a\u0001k\u0006)a/\u00197vKR)\u0001-a\u0006\u0002\u001a!1\u0011qB\u0005A\u0002UDq!a\u0005\n\u0001\u0004\tY\u0002E\u0002J\u0003;I1!a\bK\u0005\u001d\u0011un\u001c7fC:$R\u0001YA\u0012\u0003KAa!a\u0004\u000b\u0001\u0004)\bbBA\n\u0015\u0001\u0007\u0011q\u0005\t\u0004\u0013\u0006%\u0012bAA\u0016\u0015\n!Aj\u001c8h)\u0015\u0001\u0017qFA\u0019\u0011\u0019\tya\u0003a\u0001k\"9\u00111C\u0006A\u0002\u0005M\u0002cA%\u00026%\u0019\u0011q\u0007&\u0003\r\u0011{WO\u00197f\u0003\u001dy\u0007\u000f^5p]N$2\u0001YA\u001f\u0011\u001d\tI\u0004\u0004a\u0001\u0003\u007f\u0001b!!\u0011\u0002HU,XBAA\"\u0015\r\t)ES\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA%\u0003\u0007\u00121!T1q)\r\u0001\u0017Q\n\u0005\b\u0003si\u0001\u0019AA(!\u0019\t\t&a\u0017vk6\u0011\u00111\u000b\u0006\u0005\u0003+\n9&\u0001\u0003vi&d'BAA-\u0003\u0011Q\u0017M^1\n\t\u0005%\u00131K\u0001\fa\u0006\u0014H/\u001b;j_:\u0014\u0015\u0010F\u0002a\u0003CBq!a\u0019\u000f\u0001\u0004\t)'\u0001\u0005d_2t\u0015-\\3t!\u0011I\u0015qM;\n\u0007\u0005%$J\u0001\u0006=e\u0016\u0004X-\u0019;fIzB3ADA7!\u0011\ty'!\u001e\u000e\u0005\u0005E$bAA:\u0015\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0014\u0011\u000f\u0002\bm\u0006\u0014\u0018M]4t\u0003!\u0011WoY6fi\nKHc\u00021\u0002~\u0005\u001d\u00151\u0012\u0005\b\u0003\u007fz\u0001\u0019AAA\u0003)qW/\u001c\"vG.,Go\u001d\t\u0004\u0013\u0006\r\u0015bAAC\u0015\n\u0019\u0011J\u001c;\t\r\u0005%u\u00021\u0001v\u0003\u001d\u0019w\u000e\u001c(b[\u0016Dq!a\u0019\u0010\u0001\u0004\t)\u0007K\u0002\u0010\u0003[\naa]8si\nKH#\u00021\u0002\u0014\u0006U\u0005BBAE!\u0001\u0007Q\u000fC\u0004\u0002dA\u0001\r!!\u001a)\u0007A\ti'\u0001\u0003tCZ,G\u0003BAO\u0003G\u00032!SAP\u0013\r\t\tK\u0013\u0002\u0005+:LG\u000f\u0003\u0004\u0002&F\u0001\r!^\u0001\u0005a\u0006$\b\u000e\u0006\u0002\u0002\u001e\u0006q1/\u0019<f)>4\u0016gU8ve\u000e,\u0017AC5og\u0016\u0014H/\u00138u_R!\u0011QTAX\u0011\u0019\t\t\f\u0006a\u0001k\u0006IA/\u00192mK:\u000bW.\u001a\u000b\u0007\u0003;\u000b),a2\t\u000f\u0005]V\u00031\u0001\u0002:\u000691-\u0019;bY><\u0007\u0003BA^\u0003\u0007l!!!0\u000b\t\u0005]\u0016q\u0018\u0006\u0004\u0003\u0003l\u0014!C2p]:,7\r^8s\u0013\u0011\t)-!0\u0003\u001b\r\u000bG/\u00197pOBcWoZ5o\u0011\u001d\tI-\u0006a\u0001\u0003\u0017\fQ!\u001b3f]R\u0004B!a/\u0002N&!\u0011qZA_\u0005)IE-\u001a8uS\u001aLWM\u001d\u000b\u0005\u0003;\u000b\u0019\u000eC\u0004\u0002VZ\u0001\r!a6\u0002\u0015Q\f'\r\\3JI\u0016tG\u000f\u0005\u0003\u0002Z\u0006}WBAAn\u0015\r\ti.P\u0001\tG\u0006$\u0018\r\\=ti&!\u0011\u0011]An\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018!D4fi\n+8m[3u'B,7-\u0006\u0002\u0002hB)\u0011*!;\u0002n&\u0019\u00111\u001e&\u0003\r=\u0003H/[8o!\u0011\ty/a=\u000e\u0005\u0005E(\u0002BA\\\u00037LA!!>\u0002r\nQ!)^2lKR\u001c\u0006/Z2\u0002#\u0005\u001c8/\u001a:u\u001d>$()^2lKR,G\r\u0006\u0003\u0002\u001e\u0006m\bBBA\u007f1\u0001\u0007Q/A\u0005pa\u0016\u0014\u0018\r^5p]\u0006!\u0012m]:feRtu\u000e\u001e)beRLG/[8oK\u0012$B!!(\u0003\u0004!1\u0011Q`\rA\u0002U\f1b]1wK\u0006\u001bH+\u00192mKR!\u0011Q\u0014B\u0005\u0011\u0019\t\tL\u0007a\u0001kRA\u0011Q\u0014B\u0007\u0005+\u00119\u0002C\u0004\u00028n\u0001\rAa\u0004\u0011\t\u0005m&\u0011C\u0005\u0005\u0005'\tiL\u0001\u0007UC\ndWmQ1uC2|w\rC\u0004\u0002Jn\u0001\r!a3\t\u000f\te1\u00041\u0001\u0003\u001c\u0005Ia.Y7f!\u0006\u0014Ho\u001d\t\u0006\u0005;\u0011)#\u001e\b\u0005\u0005?\u0011\u0019CD\u0002y\u0005CI\u0011aS\u0005\u0003O*KAAa\n\u0003*\t\u00191+Z9\u000b\u0005\u001dTE\u0003BAO\u0005[Aq!!6\u001d\u0001\u0004\t9.A\u0006de\u0016\fG/\u001a+bE2,G\u0003BAO\u0005gAq!!6\u001e\u0001\u0004\t9.\u0001\tqCJ$\u0018\u000e^5p]&tw-Q:WeU\u0011!\u0011\b\t\u0007\u0005;\u0011)Ca\u000f\u0011\t\tu\"1I\u0007\u0003\u0005\u007fQAA!\u0011\u0002@\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\u0011)Ea\u0010\u0003\u0013Q\u0013\u0018M\\:g_Jl\u0017aH2iK\u000e\\\u0007+\u0019:uSRLwN\\5oO6\u000bGo\u00195fgZ\u0013D+\u00192mKR!\u0011Q\u0014B&\u0011\u001d\u0011ie\ba\u0001\u0005\u001f\nQ\"\u001a=jgRLgn\u001a+bE2,\u0007\u0003BA^\u0005#JAAa\u0015\u0002>\n)A+\u00192mK\u0006!!\u000e\u001a2d)!\tiJ!\u0017\u0003^\t\u0005\u0004B\u0002B.A\u0001\u0007Q/A\u0002ve2DaAa\u0018!\u0001\u0004)\u0018!\u0002;bE2,\u0007b\u0002B2A\u0001\u0007!QM\u0001\u0015G>tg.Z2uS>t\u0007K]8qKJ$\u0018.Z:\u0011\t\u0005E#qM\u0005\u0005\u0005S\n\u0019F\u0001\u0006Qe>\u0004XM\u001d;jKN\fAA[:p]R!\u0011Q\u0014B8\u0011\u0019\t)+\ta\u0001k\u00069\u0001/\u0019:rk\u0016$H\u0003BAO\u0005kBa!!*#\u0001\u0004)\u0018aA8sGR!\u0011Q\u0014B>\u0011\u0019\t)k\ta\u0001k\u0006!A/\u001a=u)\u0011\tiJ!!\t\r\u0005\u0015F\u00051\u0001v\u0003\r\u00197O\u001e\u000b\u0005\u0003;\u00139\t\u0003\u0004\u0002&\u0016\u0002\r!^\u0001\u000beVt7i\\7nC:$GC\u0002BG\u0005G\u0013i\u000b\u0006\u0003\u0002\u001e\n=\u0005b\u0002BIM\u0001\u0007!1S\u0001\bG>lW.\u00198e!\u0011\u0011)Ja(\u000e\u0005\t]%\u0002\u0002BM\u00057\u000bq\u0001\\8hS\u000e\fGN\u0003\u0003\u0003\u001e\u0006m\u0017!\u00029mC:\u001c\u0018\u0002\u0002BQ\u0005/\u00131\u0002T8hS\u000e\fG\u000e\u00157b]\"9!Q\u0015\u0014A\u0002\t\u001d\u0016aB:fgNLwN\u001c\t\u0004!\n%\u0016b\u0001BV{\ta1\u000b]1sWN+7o]5p]\"1!q\u0016\u0014A\u0002U\fAA\\1nK\u0006\u0001Bn\\8lkB4&\u0007\u0015:pm&$WM\u001d\u000b\u0003\u0005k\u0003R!SAu\u0005o\u0003B!a/\u0003:&!!1XA_\u00055!\u0016M\u00197f!J|g/\u001b3feV\tQ/\u0001\u0006t_V\u00148-Z0%KF$B!!(\u0003D\"A!QY\u0015\u0002\u0002\u0003\u0007Q/A\u0002yIE\nqa]8ve\u000e,\u0007%F\u0001q\u0003!iw\u000eZ3`I\u0015\fH\u0003BAO\u0005\u001fD\u0001B!2-\u0003\u0003\u0005\r\u0001]\u0001\u0006[>$W\rI\u0001\rKb$(/Y(qi&|gn]\u000b\u0003\u0005/\u0004bA!7\u0003`V,XB\u0001Bn\u0015\u0011\u0011i.a\u0011\u0002\u000f5,H/\u00192mK&!!\u0011\u001dBn\u0005\u001dA\u0015m\u001d5NCB\fQ\"\u001a=ue\u0006|\u0005\u000f^5p]N\u0004\u0013a\u00059beRLG/[8oS:<7i\u001c7v[:\u001cXC\u0001Bu!\u0015I\u0015\u0011\u001eB\u000e\u0003]\u0001\u0018M\u001d;ji&|g.\u001b8h\u0007>dW/\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\n=\b\"\u0003Bcc\u0005\u0005\t\u0019\u0001Bu\u0003Q\u0001\u0018M\u001d;ji&|g.\u001b8h\u0007>dW/\u001c8tA\u0005\t\"-^2lKR\u001cu\u000e\\;n]:\u000bW.Z:\u0002+\t,8m[3u\u0007>dW/\u001c8OC6,7o\u0018\u0013fcR!\u0011Q\u0014B}\u0011%\u0011)\rNA\u0001\u0002\u0004\u0011I/\u0001\nck\u000e\\W\r^\"pYVlgNT1nKN\u0004SC\u0001B\u0000!\u0015I\u0015\u0011^AA\u00039qW/\u001c\"vG.,Go]0%KF$B!!(\u0004\u0006!I!QY\u001c\u0002\u0002\u0003\u0007!q`\u0001\f]Vl')^2lKR\u001c\b%A\bt_J$8i\u001c7v[:t\u0015-\\3t\u0003M\u0019xN\u001d;D_2,XN\u001c(b[\u0016\u001cx\fJ3r)\u0011\tija\u0004\t\u0013\t\u0015'(!AA\u0002\t%\u0018\u0001E:peR\u001cu\u000e\\;n]:\u000bW.Z:!Q\r\u00011Q\u0003\t\u0005\u0007/\u0019Y\"\u0004\u0002\u0004\u001a)\u0019\u00111O \n\t\ru1\u0011\u0004\u0002\u0007'R\f'\r\\3")
public final class DataFrameWriter<T> {
    private final Dataset<Row> df;
    private String source;
    private SaveMode mode;
    private final HashMap<String, String> extraOptions;
    private Option<Seq<String>> partitioningColumns;
    private Option<Seq<String>> bucketColumnNames;
    private Option<Object> numBuckets;
    private Option<Seq<String>> sortColumnNames;

    public DataFrameWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, String ... colNames) {
        return this.bucketBy(numBuckets, colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> sortBy(String colName, String ... colNames) {
        return this.sortBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataFrameWriter<T> mode(SaveMode saveMode) {
        this.mode_$eq(saveMode);
        return this;
    }

    public DataFrameWriter<T> mode(String saveMode) {
        DataFrameWriter<T> dataFrameWriter;
        String string = saveMode.toLowerCase(Locale.ROOT);
        if ("overwrite".equals(string)) {
            dataFrameWriter = this.mode(SaveMode.Overwrite);
        } else if ("append".equals(string)) {
            dataFrameWriter = this.mode(SaveMode.Append);
        } else if ("ignore".equals(string)) {
            dataFrameWriter = this.mode(SaveMode.Ignore);
        } else {
            boolean bl = "error".equals(string) ? true : ("errorifexists".equals(string) ? true : "default".equals(string));
            if (bl) {
                dataFrameWriter = this.mode(SaveMode.ErrorIfExists);
            } else {
                throw new IllegalArgumentException(new StringBuilder(114).append("Unknown save mode: ").append(saveMode).append(". Accepted ").append("save modes are 'overwrite', 'append', 'ignore', 'error', 'errorifexists', 'default'.").toString());
            }
        }
        return dataFrameWriter;
    }

    public DataFrameWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameWriter<T> option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameWriter<T> option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameWriter<T> option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameWriter<T> option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameWriter<T> options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataFrameWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public DataFrameWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, Seq<String> colNames) {
        this.numBuckets_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets)));
        String string = colName;
        this.bucketColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public DataFrameWriter<T> sortBy(String colName, Seq<String> colNames) {
        String string = colName;
        this.sortColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public void save(String path) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path));
        this.save();
    }

    public void save() {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not write files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        this.assertNotBucketed("save");
        Option<TableProvider> maybeV2Provider = this.lookupV2Provider();
        if (maybeV2Provider.isDefined()) {
            TableProvider provider = (TableProvider)maybeV2Provider.get();
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(provider, this.df().sparkSession().sessionState().conf());
            scala.collection.immutable.Map options = sessionOptions.$plus$plus(this.extraOptions());
            CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)options).asJava());
            CatalogManager catalogManager = this.df().sparkSession().sessionState().catalogManager();
            SaveMode saveMode = this.mode();
            boolean bl = ((Object)((Object)SaveMode.Append)).equals((Object)saveMode) ? true : ((Object)((Object)SaveMode.Overwrite)).equals((Object)saveMode);
            if (bl) {
                BoxedUnit boxedUnit;
                Tuple3 tuple3;
                TableProvider tableProvider = provider;
                if (tableProvider instanceof SupportsCatalogOptions) {
                    SupportsCatalogOptions supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
                    Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
                    TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
                    tuple3 = new Tuple3((Object)catalog.loadTable(ident), (Object)new Some((Object)catalog), (Object)new Some((Object)ident));
                } else if (tableProvider != null) {
                    Table t = this.getTable$1(provider, dsOptions);
                    if (!DataSourceV2Implicits$.MODULE$.TableHelper(t).supports(TableCapability.BATCH_WRITE)) {
                        this.saveToV1Source();
                        return;
                    }
                    tuple3 = new Tuple3((Object)t, (Object)None$.MODULE$, (Object)None$.MODULE$);
                } else {
                    throw new MatchError((Object)tableProvider);
                }
                Tuple3 tuple32 = tuple3;
                if (tuple32 == null) {
                    throw new MatchError((Object)tuple32);
                }
                Table table = (Table)tuple32._1();
                Option catalog = (Option)tuple32._2();
                Option ident = (Option)tuple32._3();
                Tuple3 tuple33 = new Tuple3((Object)table, (Object)catalog, (Object)ident);
                Tuple3 tuple34 = tuple33;
                Table table2 = (Table)tuple34._1();
                Option catalog2 = (Option)tuple34._2();
                Option ident2 = (Option)tuple34._3();
                DataSourceV2Relation relation = DataSourceV2Relation$.MODULE$.create(table2, catalog2, ident2, dsOptions);
                this.checkPartitioningMatchesV2Table(table2);
                SaveMode saveMode2 = this.mode();
                SaveMode saveMode3 = SaveMode.Append;
                if (!(saveMode2 != null ? !((Object)((Object)saveMode2)).equals((Object)saveMode3) : saveMode3 != null)) {
                    this.runCommand(this.df().sparkSession(), "save", (LogicalPlan)AppendData$.MODULE$.byName((NamedRelation)relation, this.df().logicalPlan(), this.extraOptions().toMap(Predef$.MODULE$.$conforms())));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.runCommand(this.df().sparkSession(), "save", (LogicalPlan)OverwriteByExpression$.MODULE$.byName((NamedRelation)relation, this.df().logicalPlan(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.extraOptions().toMap(Predef$.MODULE$.$conforms())));
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                TableProvider tableProvider = provider;
                if (tableProvider instanceof SupportsCatalogOptions) {
                    SupportsCatalogOptions supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
                    Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
                    TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
                    Option location = Option$.MODULE$.apply((Object)dsOptions.get((Object)"path")).map((Function1 & Serializable & scala.Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"location"), x$4));
                    SaveMode saveMode4 = saveMode;
                    SaveMode saveMode5 = SaveMode.Ignore;
                    this.runCommand(this.df().sparkSession(), "save", (LogicalPlan)new CreateTableAsSelect(catalog, ident, this.partitioningAsV2(), this.df().queryExecution().analyzed(), ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)this.source())}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(location)), this.extraOptions().toMap(Predef$.MODULE$.$conforms()), !(saveMode4 != null ? !((Object)((Object)saveMode4)).equals((Object)saveMode5) : saveMode5 != null)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (tableProvider != null) {
                    if (DataSourceV2Implicits$.MODULE$.TableHelper(this.getTable$1(provider, dsOptions)).supports(TableCapability.BATCH_WRITE)) {
                        throw new AnalysisException(new StringBuilder(105).append("TableProvider implementation ").append(this.source()).append(" cannot be ").append("written with ").append((Object)saveMode).append(" mode, please use Append or Overwrite ").append("modes instead.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    this.saveToV1Source();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)tableProvider);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            this.saveToV1Source();
        }
    }

    private void saveToV1Source() {
        this.partitioningColumns().foreach((Function1 & Serializable & scala.Serializable)columns -> this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.PARTITIONING_COLUMNS_KEY()), (Object)DataSourceUtils$.MODULE$.encodePartitioningColumns((Seq<String>)columns))));
        SparkSession x$1 = this.df().sparkSession();
        String x$2 = this.source();
        Seq x$3 = (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        scala.collection.immutable.Map x$4 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        this.runCommand(this.df().sparkSession(), "save", new DataSource(x$1, x$2, x$5, x$6, (Seq<String>)x$3, x$7, (scala.collection.immutable.Map<String, String>)x$4, x$8).planForWriting(this.mode(), this.df().logicalPlan()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void insertInto(String tableName) {
        Option option;
        this.assertNotBucketed("insertInto");
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException("insertInto() can't be used together with partitionBy(). Partition columns have already been defined for the table. It is not necessary to use partitionBy().", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        SparkSession session = this.df().sparkSession();
        boolean canUseV2 = this.lookupV2Provider().isDefined();
        Seq seq = session.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        Option option2 = this.df().sparkSession().sessionState().analyzer().NonSessionCatalogAndIdentifier().unapply(seq);
        if (!option2.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option2.get())._1();
            Identifier ident = (Identifier)((Tuple2)option2.get())._2();
            this.insertInto(catalog, ident);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        Option option3 = this.df().sparkSession().sessionState().analyzer().SessionCatalogAndIdentifier().unapply(seq);
        if (!option3.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option3.get())._1();
            Identifier ident = (Identifier)((Tuple2)option3.get())._2();
            if (canUseV2 && ident.namespace().length <= 1) {
                this.insertInto(catalog, ident);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if ((option = this.df().sparkSession().sessionState().analyzer().AsTableIdentifier().unapply(seq)).isEmpty()) throw new AnalysisException(new StringBuilder(50).append("Couldn't find a catalog to handle the identifier ").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(seq).quoted()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        TableIdentifier tableIdentifier = (TableIdentifier)option.get();
        this.insertInto(tableIdentifier);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Unable to fully structure code
     */
    private void insertInto(CatalogPlugin catalog, Identifier ident) {
        block4: {
            block5: {
                block3: {
                    var7_3 = CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog().loadTable(ident);
                    if (var7_3 instanceof V1Table) {
                        this.insertInto(new TableIdentifier(ident.name(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).headOption()));
                        return;
                    }
                    table = var5_4 = DataSourceV2Relation$.MODULE$.create(var7_3, (Option)new Some((Object)catalog), (Option)new Some((Object)ident));
                    var9_6 = this.mode();
                    var4_7 = SaveMode.Append.equals((Object)var9_6) != false ? true : (SaveMode.ErrorIfExists.equals((Object)var9_6) != false ? true : SaveMode.Ignore.equals((Object)var9_6) != false);
                    if (!var4_7) break block3;
                    var3_8 = AppendData$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), this.extraOptions().toMap(Predef$.MODULE$.$conforms()));
                    break block4;
                }
                if (!SaveMode.Overwrite.equals((Object)var9_6)) break block5;
                conf = this.df().sparkSession().sessionState().conf();
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.table().partitioning())).size() <= 0) ** GOTO lbl-1000
                v0 = conf.partitionOverwriteMode();
                var12_10 = SQLConf.PartitionOverwriteMode$.MODULE$.DYNAMIC();
                if (!(v0 != null ? v0.equals(var12_10) == false : var12_10 != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                dynamicPartitionOverwrite = v1;
                var3_8 = dynamicPartitionOverwrite != false ? OverwritePartitionsDynamic$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), this.extraOptions().toMap(Predef$.MODULE$.$conforms())) : OverwriteByExpression$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.extraOptions().toMap(Predef$.MODULE$.$conforms()));
                break block4;
            }
            throw new MatchError((Object)var9_6);
        }
        command = var3_8;
        this.runCommand(this.df().sparkSession(), "insertInto", (LogicalPlan)command);
    }

    private void insertInto(TableIdentifier tableIdent) {
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Overwrite;
        this.runCommand(this.df().sparkSession(), "insertInto", (LogicalPlan)new InsertIntoStatement((LogicalPlan)UnresolvedRelation$.MODULE$.apply(tableIdent), Predef$.MODULE$.Map().empty(), this.df().logicalPlan(), !(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode2) : saveMode2 != null), false));
    }

    private Option<BucketSpec> getBucketSpec() {
        if (this.sortColumnNames().isDefined() && this.numBuckets().isEmpty()) {
            throw new AnalysisException("sortBy must be used together with bucketBy", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.numBuckets().map((Function1 & Serializable & scala.Serializable)n -> DataFrameWriter.$anonfun$getBucketSpec$1(this, BoxesRunTime.unboxToInt((Object)n)));
    }

    private void assertNotBucketed(String operation) {
        if (this.getBucketSpec().isDefined()) {
            if (this.sortColumnNames().isEmpty()) {
                throw new AnalysisException(new StringBuilder(38).append("'").append(operation).append("' does not support bucketBy right now").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            throw new AnalysisException(new StringBuilder(49).append("'").append(operation).append("' does not support bucketBy and sortBy right now").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException(new StringBuilder(32).append("'").append(operation).append("' does not support partitioning").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void saveAsTable(String tableName) {
        Option option;
        SparkSession session = this.df().sparkSession();
        boolean canUseV2 = this.lookupV2Provider().isDefined();
        Seq seq = session.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        Option option2 = this.df().sparkSession().sessionState().analyzer().NonSessionCatalogAndIdentifier().unapply(seq);
        if (!option2.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option2.get())._1();
            Identifier ident = (Identifier)((Tuple2)option2.get())._2();
            this.saveAsTable(CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog(), ident, (Seq<String>)seq);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        Option option3 = this.df().sparkSession().sessionState().analyzer().SessionCatalogAndIdentifier().unapply(seq);
        if (!option3.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option3.get())._1();
            Identifier ident = (Identifier)((Tuple2)option3.get())._2();
            if (canUseV2 && ident.namespace().length <= 1) {
                this.saveAsTable(CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog(), ident, (Seq<String>)seq);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if ((option = this.df().sparkSession().sessionState().analyzer().AsTableIdentifier().unapply(seq)).isEmpty()) throw new AnalysisException(new StringBuilder(50).append("Couldn't find a catalog to handle the identifier ").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(seq).quoted()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        TableIdentifier tableIdentifier = (TableIdentifier)option.get();
        this.saveAsTable(tableIdentifier);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Unable to fully structure code
     */
    private void saveAsTable(TableCatalog catalog, Identifier ident, Seq<String> nameParts) {
        try {
            v0 = Option$.MODULE$.apply((Object)catalog.loadTable(ident));
        }
        catch (NoSuchTableException v1) {
            v0 = None$.MODULE$;
        }
        tableOpt = v0;
        var7_5 = new Tuple2((Object)this.mode(), (Object)tableOpt);
        if (var7_5 != null && (var8_6 = (Option)var7_5._2()) instanceof Some && (var9_7 = (Some)var8_6).value() instanceof V1Table) {
            this.saveAsTable(new TableIdentifier(ident.name(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).headOption()));
            return;
        }
        if (var7_5 == null) ** GOTO lbl-1000
        var10_8 = (SaveMode)var7_5._1();
        var11_9 = (Option)var7_5._2();
        if (SaveMode.Append.equals((Object)var10_8) && var11_9 instanceof Some) {
            var12_10 = (Some)var11_9;
            table = (Table)var12_10.value();
            this.checkPartitioningMatchesV2Table(table);
            v2Relation = DataSourceV2Relation$.MODULE$.create(table, (Option)new Some((Object)catalog), (Option)new Some((Object)ident));
            var4_13 = AppendData$.MODULE$.byName((NamedRelation)v2Relation, this.df().logicalPlan(), this.extraOptions().toMap(Predef$.MODULE$.$conforms()));
        } else if (var7_5 != null && SaveMode.Overwrite.equals((Object)(var15_14 = (SaveMode)var7_5._1()))) {
            var4_13 = new ReplaceTableAsSelectStatement(nameParts, this.df().queryExecution().analyzed(), this.partitioningAsV2(), (Option)None$.MODULE$, Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), Predef$.MODULE$.Map().empty(), this.extraOptions().get((Object)"path"), this.extraOptions().get((Object)"comment"), this.extraOptions().toMap(Predef$.MODULE$.$conforms()), true);
        } else if (var7_5 != null) {
            other = (SaveMode)var7_5._1();
            v2 = other;
            var17_16 = SaveMode.Ignore;
            var4_13 = new CreateTableAsSelectStatement(nameParts, this.df().queryExecution().analyzed(), this.partitioningAsV2(), (Option)None$.MODULE$, Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), Predef$.MODULE$.Map().empty(), this.extraOptions().get((Object)"path"), this.extraOptions().get((Object)"comment"), this.extraOptions().toMap(Predef$.MODULE$.$conforms()), !(v2 != null ? v2.equals((Object)var17_16) == false : var17_16 != null));
        } else {
            throw new MatchError((Object)var7_5);
        }
        command = var4_13;
        this.runCommand(this.df().sparkSession(), "saveAsTable", (LogicalPlan)command);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void saveAsTable(TableIdentifier tableIdent) {
        SessionCatalog catalog = this.df().sparkSession().sessionState().catalog();
        boolean tableExists = catalog.tableExists(tableIdent);
        String db = (String)tableIdent.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> catalog.getCurrentDatabase());
        Some x$1 = new Some((Object)db);
        String x$2 = tableIdent.copy$default$1();
        TableIdentifier tableIdentWithDB = tableIdent.copy(x$2, (Option)x$1);
        String tableName = tableIdentWithDB.unquotedString();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)tableExists), (Object)this.mode());
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Ignore)).equals((Object)saveMode)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.ErrorIfExists)).equals((Object)saveMode)) {
                throw new AnalysisException(new StringBuilder(22).append("Table ").append(tableIdent).append(" already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Overwrite)).equals((Object)saveMode)) {
                HiveTableRelation hiveTableRelation;
                BaseRelation baseRelation;
                LogicalRelation logicalRelation;
                BaseRelation dest;
                Seq srcRelations = this.df().logicalPlan().collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        A1 A1 = x1;
                        if (A1 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)A1).relation()) != null) {
                            BaseRelation baseRelation = src;
                            object = baseRelation;
                        } else if (A1 instanceof HiveTableRelation) {
                            HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                            object = hiveTableRelation.tableMeta().identifier();
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        LogicalPlan logicalPlan2 = x1;
                        boolean bl = logicalPlan2 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null ? true : logicalPlan2 instanceof HiveTableRelation;
                        return bl;
                    }
                });
                LogicalPlan tableRelation = this.df().sparkSession().table(tableIdentWithDB).queryExecution().analyzed();
                LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(tableRelation);
                if (logicalPlan2 instanceof LogicalRelation && (dest = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null && srcRelations.contains((Object)(baseRelation = dest))) {
                    throw new AnalysisException(new StringBuilder(52).append("Cannot overwrite table ").append(tableName).append(" that is also being read from").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                if (logicalPlan2 instanceof HiveTableRelation && srcRelations.contains((Object)(hiveTableRelation = (HiveTableRelation)logicalPlan2).tableMeta().identifier())) {
                    throw new AnalysisException(new StringBuilder(52).append("Cannot overwrite table ").append(tableName).append(" that is also being read from").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                catalog.dropTable(tableIdentWithDB, true, false);
                this.createTable(tableIdentWithDB);
                catalog.refreshTable(tableIdentWithDB);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
        }
        this.createTable(tableIdent);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void createTable(TableIdentifier tableIdent) {
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.$conforms()));
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        CatalogTable tableDesc = new CatalogTable(tableIdent, tableType, storage, new StructType(), (Option)new Some((Object)this.source()), (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), this.getBucketSpec(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
        this.runCommand(this.df().sparkSession(), "saveAsTable", new CreateTable(tableDesc, this.mode(), (Option<LogicalPlan>)new Some((Object)this.df().logicalPlan())));
    }

    private Seq<Transform> partitioningAsV2() {
        Seq partitioning = (Seq)this.partitioningColumns().map((Function1 & Serializable & scala.Serializable)colNames -> (Seq)colNames.map((Function1 & Serializable & scala.Serializable)name -> new IdentityTransform(FieldReference$.MODULE$.apply(name)), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Seq bucketing = Option$.MODULE$.option2Iterable(this.getBucketSpec().map((Function1 & Serializable & scala.Serializable)spec -> CatalogV2Implicits$.MODULE$.BucketSpecHelper(spec).asTransform())).toSeq();
        return (Seq)partitioning.$plus$plus((GenTraversableOnce)bucketing, Seq$.MODULE$.canBuildFrom());
    }

    private void checkPartitioningMatchesV2Table(Table existingTable) {
        Seq<Transform> v2Partitions = this.partitioningAsV2();
        if (v2Partitions.isEmpty()) {
            return;
        }
        Predef$.MODULE$.require(v2Partitions.sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])existingTable.partitioning())), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("The provided partitioning does not match of the table.\n").append(" - provided: ").append(v2Partitions.mkString(", ")).append("\n").append(" - table: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existingTable.partitioning())).mkString(", ")).toString());
    }

    public void jdbc(String url, String table, Properties connectionProperties) {
        this.assertNotPartitioned("jdbc");
        this.assertNotBucketed("jdbc");
        this.extraOptions().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala());
        this.extraOptions().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)url), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)table), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.format("jdbc").save();
    }

    public void json(String path) {
        this.format("json").save(path);
    }

    public void parquet(String path) {
        this.format("parquet").save(path);
    }

    public void orc(String path) {
        this.format("orc").save(path);
    }

    public void text(String path) {
        this.format("text").save(path);
    }

    public void csv(String path) {
        this.format("csv").save(path);
    }

    private void runCommand(SparkSession session, String name, LogicalPlan command) {
        QueryExecution qe = session.sessionState().executePlan(command);
        SQLExecution$.MODULE$.withNewExecutionId(qe, (Option<String>)new Some((Object)name), (Function0 & Serializable & scala.Serializable)() -> qe.toRdd());
    }

    private Option<TableProvider> lookupV2Provider() {
        Some some;
        None$ none$ = DataSource$.MODULE$.lookupDataSourceV2(this.source(), this.df().sparkSession().sessionState().conf());
        None$ none$2 = none$ instanceof Some && (some = (Some)none$).value() instanceof FileDataSourceV2 ? None$.MODULE$ : none$;
        return none$2;
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private Option<Seq<String>> bucketColumnNames() {
        return this.bucketColumnNames;
    }

    private void bucketColumnNames_$eq(Option<Seq<String>> x$1) {
        this.bucketColumnNames = x$1;
    }

    private Option<Object> numBuckets() {
        return this.numBuckets;
    }

    private void numBuckets_$eq(Option<Object> x$1) {
        this.numBuckets = x$1;
    }

    private Option<Seq<String>> sortColumnNames() {
        return this.sortColumnNames;
    }

    private void sortColumnNames_$eq(Option<Seq<String>> x$1) {
        this.sortColumnNames = x$1;
    }

    private final Table getTable$1(TableProvider provider$1, CaseInsensitiveStringMap dsOptions$1) {
        return provider$1 instanceof FileDataSourceV2 ? provider$1.getTable(this.df().schema().asNullable(), (Transform[])this.partitioningAsV2().toArray(ClassTag$.MODULE$.apply(Transform.class)), dsOptions$1.asCaseSensitiveMap()) : DataSourceV2Utils$.MODULE$.getTableFromProvider(provider$1, dsOptions$1, (Option<StructType>)None$.MODULE$);
    }

    public static final /* synthetic */ BucketSpec $anonfun$getBucketSpec$1(DataFrameWriter $this, int n) {
        return new BucketSpec(n, (Seq)$this.bucketColumnNames().get(), (Seq)$this.sortColumnNames().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
    }

    public DataFrameWriter(Dataset<T> ds) {
        this.df = ds.toDF();
        this.source = this.df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.mode = SaveMode.ErrorIfExists;
        this.extraOptions = new HashMap();
        this.partitioningColumns = None$.MODULE$;
        this.bucketColumnNames = None$.MODULE$;
        this.numBuckets = None$.MODULE$;
        this.sortColumnNames = None$.MODULE$;
    }
}

