/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.CompactibleFileStreamLog$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tMb!B\u0014)\u0003\u0003)\u0004\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011A\u0003!\u0011!Q\u0001\nEC\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\tC\u0002\u0011\u0019\u0011)A\u0006E\")\u0001\u000e\u0001C\u0001S\"9\u0001\u000f\u0001b\u0001\n\u0017\t\bbBA\u000b\u0001\u0001\u0006IA\u001d\u0005\n\u0003/\u0001!\u0019!C\u0006\u00033A\u0001\"!\t\u0001A\u0003%\u00111\u0004\u0005\n\u0003G\u0001!\u0019!C\t\u0003KAq!a\n\u0001A\u0003%Q\nC\u0004\u0002*\u00011\t\"a\u000b\t\u000f\u0005M\u0002A\"\u0005\u00026!9\u0011Q\b\u0001\u0007\u0012\u0005\u0015\u0002BCA \u0001!\u0015\r\u0011\"\u0006\u0002&!9\u0011\u0011\t\u0001\u0007\u0002\u0005\r\u0003bBA.\u0001\u0011\u0005\u0013Q\f\u0005\b\u0003g\u0002A\u0011IA;\u0011\u001d\tI\b\u0001C!\u0003wBq!a \u0001\t\u0003\n\t\tC\u0004\u0002\"\u0002!\t%a)\t\u000f\u0005=\u0006\u0001\"\u0011\u00022\"9\u0011q\u0017\u0001\u0005B\u0005e\u0006bBA`\u0001\u0011%\u0011\u0011\u0019\u0005\b\u0003\u000f\u0004A\u0011AAe\u0011\u001d\tY\r\u0001C\u0005\u0003\u001bDa\"a5\u0001!\u0003\r\t\u0011!C\u0005\u0003+\fynB\u0004\u0002d\"B\t!!:\u0007\r\u001dB\u0003\u0012AAt\u0011\u0019AW\u0004\"\u0001\u0002j\"I\u00111^\u000fC\u0002\u0013\u0005\u0011Q\u001e\u0005\t\u0003sl\u0002\u0015!\u0003\u0002p\"9\u00111`\u000f\u0005\u0002\u0005u\bb\u0002B\u0002;\u0011\u0005!Q\u0001\u0005\b\u0005\u0017iB\u0011\u0001B\u0007\u0011\u001d\u00119\"\bC\u0001\u00053AqAa\b\u001e\t\u0003\u0011\t\u0003C\u0004\u0003(u!\tA!\u000b\u00031\r{W\u000e]1di&\u0014G.\u001a$jY\u0016\u001cFO]3b[2{wM\u0003\u0002*U\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003W1\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u00055r\u0013aA:rY*\u0011q\u0006M\u0001\u0006gB\f'o\u001b\u0006\u0003cI\na!\u00199bG\",'\"A\u001a\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005Y\u001a5C\u0001\u00018!\rA\u0014hO\u0007\u0002Q%\u0011!\b\u000b\u0002\u0010\u0011\u001235+T3uC\u0012\fG/\u0019'pOB\u0019AhP!\u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012Q!\u0011:sCf\u0004\"AQ\"\r\u0001\u0011)A\t\u0001b\u0001\u000b\n\tA+\u0005\u0002G\u0013B\u0011AhR\u0005\u0003\u0011v\u0012qAT8uQ&tw\r\u0005\u0002=\u0015&\u00111*\u0010\u0002\u0007\u0003:L(+\u001a4\u0002%5,G/\u00193bi\u0006dun\u001a,feNLwN\u001c\t\u0003y9K!aT\u001f\u0003\u0007%sG/\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002S'6\tA&\u0003\u0002UY\ta1\u000b]1sWN+7o]5p]\u0006!\u0001/\u0019;i!\t9fL\u0004\u0002Y9B\u0011\u0011,P\u0007\u00025*\u00111\fN\u0001\u0007yI|w\u000e\u001e \n\u0005uk\u0014A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!X\u001f\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002dM\u0006k\u0011\u0001\u001a\u0006\u0003Kv\nqA]3gY\u0016\u001cG/\u0003\u0002hI\nA1\t\\1tgR\u000bw-\u0001\u0004=S:LGO\u0010\u000b\u0005U6tw\u000e\u0006\u0002lYB\u0019\u0001\bA!\t\u000b\u0005,\u00019\u00012\t\u000b1+\u0001\u0019A'\t\u000bA+\u0001\u0019A)\t\u000bU+\u0001\u0019\u0001,\u0002\u000f\u0019|'/\\1ugV\t!OE\u0002t\u0013j4A\u0001\u001e\u0001\u0001e\naAH]3gS:,W.\u001a8u}%\u0011\u0001O^\u0005\u0003ob\u0014QbU3sS\u0006d\u0017N_1uS>t'BA=3\u0003\u0019Q7o\u001c85gB\u00111\u0010`\u0007\u0002q&\u0011Q\u0010\u001f\u0002\b\r>\u0014X.\u0019;t\u0011!y8O1A\u0005\u0002\u0005\u0005\u0011A\u00033bi\u00164uN]7biV\u0011\u00111\u0001\t\u0004w\u0006\u0015\u0011bAA\u0004q\nQA)\u0019;f\r>\u0014X.\u0019;\t\u0013\u0005-1O1A\u0005\u0002\u00055\u0011!\u0003;za\u0016D\u0015N\u001c;t+\t\ty\u0001E\u0002|\u0003#I1!a\u0005y\u0005%!\u0016\u0010]3IS:$8/\u0001\u0005g_Jl\u0017\r^:!\u0003!i\u0017M\\5gKN$XCAA\u000e!\u0011\u0019\u0017QD!\n\u0007\u0005}AM\u0001\u0005NC:Lg-Z:u\u0003%i\u0017M\\5gKN$\b%\u0001\nnS:\u0014\u0015\r^2iKN$vNU3uC&tW#A'\u0002'5LgNQ1uG\",7\u000fV8SKR\f\u0017N\u001c\u0011\u0002%\u0019LG.Z\"mK\u0006tW\u000f\u001d#fY\u0006LXj]\u000b\u0003\u0003[\u00012\u0001PA\u0018\u0013\r\t\t$\u0010\u0002\u0005\u0019>tw-\u0001\u000bjg\u0012+G.\u001a;j]\u001e,\u0005\u0010]5sK\u0012dunZ\u000b\u0003\u0003o\u00012\u0001PA\u001d\u0013\r\tY$\u0010\u0002\b\u0005>|G.Z1o\u0003Y!WMZ1vYR\u001cu.\u001c9bGRLe\u000e^3sm\u0006d\u0017aD2p[B\f7\r^%oi\u0016\u0014h/\u00197\u0002\u0017\r|W\u000e]1di2{wm\u001d\u000b\u0005\u0003\u000b\n9\u0006E\u0003\u0002H\u0005E\u0013I\u0004\u0003\u0002J\u00055cbA-\u0002L%\ta(C\u0002\u0002Pu\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002T\u0005U#aA*fc*\u0019\u0011qJ\u001f\t\u000f\u0005e\u0003\u00031\u0001\u0002F\u0005!An\\4t\u00035\u0011\u0017\r^2i\u0013\u0012$v\u000eU1uQR!\u0011qLA8!\u0011\t\t'a\u001b\u000e\u0005\u0005\r$\u0002BA3\u0003O\n!AZ:\u000b\u0007\u0005%\u0004'\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003[\n\u0019G\u0001\u0003QCRD\u0007bBA9#\u0001\u0007\u0011QF\u0001\bE\u0006$8\r[%e\u00035\u0001\u0018\r\u001e5U_\n\u000bGo\u00195JIR!\u0011QFA<\u0011\u0019)&\u00031\u0001\u0002`\u0005Y\u0011n\u001d\"bi\u000eDg)\u001b7f)\u0011\t9$! \t\rU\u001b\u0002\u0019AA0\u0003%\u0019XM]5bY&TX\r\u0006\u0004\u0002\u0004\u0006%\u0015Q\u0012\t\u0004y\u0005\u0015\u0015bAAD{\t!QK\\5u\u0011\u0019\tY\t\u0006a\u0001w\u00059An\\4ECR\f\u0007bBAH)\u0001\u0007\u0011\u0011S\u0001\u0004_V$\b\u0003BAJ\u0003;k!!!&\u000b\t\u0005]\u0015\u0011T\u0001\u0003S>T!!a'\u0002\t)\fg/Y\u0005\u0005\u0003?\u000b)J\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW.A\u0006eKN,'/[1mSj,GcA\u001e\u0002&\"9\u0011qU\u000bA\u0002\u0005%\u0016AA5o!\u0011\t\u0019*a+\n\t\u00055\u0016Q\u0013\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW.A\u0002bI\u0012$b!a\u000e\u00024\u0006U\u0006bBA9-\u0001\u0007\u0011Q\u0006\u0005\u0007\u000332\u0002\u0019A\u001e\u0002\u000bA,(oZ3\u0015\t\u0005\r\u00151\u0018\u0005\b\u0003{;\u0002\u0019AA\u0017\u0003A!\bN]3tQ>dGMQ1uG\"LE-A\u0004d_6\u0004\u0018m\u0019;\u0015\r\u0005]\u00121YAc\u0011\u001d\t\t\b\u0007a\u0001\u0003[Aa!!\u0017\u0019\u0001\u0004Y\u0014\u0001C1mY\u001aKG.Z:\u0015\u0003m\n\u0001\u0003Z3mKR,W\t\u001f9je\u0016$Gj\\4\u0015\t\u0005\r\u0015q\u001a\u0005\b\u0003#T\u0002\u0019AA\u0017\u00039\u0019WO\u001d:f]R\u0014\u0015\r^2i\u0013\u0012\f\u0011b];qKJ$s-\u001a;\u0015\t\u0005]\u0017Q\u001c\t\u0005y\u0005e7(C\u0002\u0002\\v\u0012aa\u00149uS>t\u0007bBA97\u0001\u0007\u0011QF\u0005\u0004\u0003CL\u0014aA4fi\u0006A2i\\7qC\u000e$\u0018N\u00197f\r&dWm\u0015;sK\u0006lGj\\4\u0011\u0005aj2CA\u000fJ)\t\t)/A\nD\u001f6\u0003\u0016i\u0011+`\r&cUiX*V\r\u001aK\u0005,\u0006\u0002\u0002pB!\u0011\u0011_A|\u001b\t\t\u0019P\u0003\u0003\u0002v\u0006e\u0015\u0001\u00027b]\u001eL1aXAz\u0003Q\u0019u*\u0014)B\u0007R{f)\u0013'F?N+fIR%YA\u00051r-\u001a;CCR\u001c\u0007.\u00133Ge>lg)\u001b7f\u001d\u0006lW\r\u0006\u0003\u0002.\u0005}\bB\u0002B\u0001C\u0001\u0007a+\u0001\u0005gS2,g*Y7f\u0003EI7oQ8na\u0006\u001cG/[8o\u0005\u0006$8\r\u001b\u000b\u0007\u0003o\u00119A!\u0003\t\u000f\u0005E$\u00051\u0001\u0002.!1\u0011q\b\u0012A\u00025\u000bAeZ3u-\u0006d\u0017\u000e\u001a\"bi\u000eDWm\u001d\"fM>\u0014XmQ8na\u0006\u001cG/[8o\u0005\u0006$8\r\u001b\u000b\u0007\u0005\u001f\u0011\tB!\u0006\u0011\r\u0005\u001d\u0013\u0011KA\u0017\u0011\u001d\u0011\u0019b\ta\u0001\u0003[\t\u0011cY8na\u0006\u001cG/[8o\u0005\u0006$8\r[%e\u0011\u0019\tyd\ta\u0001\u001b\u0006\u0011r-\u001a;BY24\u0016\r\\5e\u0005\u0006$8\r[3t)\u0019\u0011yAa\u0007\u0003\u001e!9\u0011\u0011\u000f\u0013A\u0002\u00055\u0002bBA I\u0001\u0007\u0011QF\u0001\u0016]\u0016DHoQ8na\u0006\u001cG/[8o\u0005\u0006$8\r[%e)\u0019\tiCa\t\u0003&!9\u0011\u0011O\u0013A\u0002\u00055\u0002bBA K\u0001\u0007\u0011QF\u0001\u0016I\u0016\u0014\u0018N^3D_6\u0004\u0018m\u0019;J]R,'O^1m)\u0015i%1\u0006B\u0018\u0011\u0019\u0011iC\na\u0001\u001b\u0006yA-\u001a4bk2$\u0018J\u001c;feZ\fG\u000e\u0003\u0004\u00032\u0019\u0002\r!T\u0001\u0015Y\u0006$Xm\u001d;D_6\u0004\u0018m\u0019;CCR\u001c\u0007.\u00133")
public abstract class CompactibleFileStreamLog<T>
extends HDFSMetadataLog<T[]> {
    private int compactInterval;
    private final int metadataLogVersion;
    private final Formats formats;
    private final Manifest<T> manifest;
    private final int minBatchesToRetain;
    private volatile boolean bitmap$0;

    public static int deriveCompactInterval(int n, int n2) {
        return CompactibleFileStreamLog$.MODULE$.deriveCompactInterval(n, n2);
    }

    public static long nextCompactionBatchId(long l, long l2) {
        return CompactibleFileStreamLog$.MODULE$.nextCompactionBatchId(l, l2);
    }

    public static Seq<Object> getAllValidBatches(long l, long l2) {
        return CompactibleFileStreamLog$.MODULE$.getAllValidBatches(l, l2);
    }

    public static Seq<Object> getValidBatchesBeforeCompactionBatch(long l, int n) {
        return CompactibleFileStreamLog$.MODULE$.getValidBatchesBeforeCompactionBatch(l, n);
    }

    public static boolean isCompactionBatch(long l, int n) {
        return CompactibleFileStreamLog$.MODULE$.isCompactionBatch(l, n);
    }

    public static long getBatchIdFromFileName(String string) {
        return CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(string);
    }

    public static String COMPACT_FILE_SUFFIX() {
        return CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX();
    }

    private /* synthetic */ Option super$get(long batchId) {
        return super.get(batchId);
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public int minBatchesToRetain() {
        return this.minBatchesToRetain;
    }

    public abstract long fileCleanupDelayMs();

    public abstract boolean isDeletingExpiredLog();

    public abstract int defaultCompactInterval();

    private int compactInterval$lzycompute() {
        CompactibleFileStreamLog compactibleFileStreamLog = this;
        synchronized (compactibleFileStreamLog) {
            if (!this.bitmap$0) {
                long[] compactibleBatchIds = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CompactibleFileStreamLog.$anonfun$compactInterval$1(f))))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sorted(Ordering.Long$.MODULE$.reverse());
                IntRef interval = IntRef.create((int)this.defaultCompactInterval());
                if (compactibleBatchIds.length >= 2) {
                    long latestCompactBatchId = compactibleBatchIds[0];
                    long previousCompactBatchId = compactibleBatchIds[1];
                    interval.elem = (int)(latestCompactBatchId - previousCompactBatchId);
                } else if (compactibleBatchIds.length == 1) {
                    interval.elem = CompactibleFileStreamLog$.MODULE$.deriveCompactInterval(this.defaultCompactInterval(), (int)compactibleBatchIds[0]);
                }
                Predef$.MODULE$.assert(interval.elem > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("intervalValue = ").append(interval$1.elem).append(" not positive value.").toString());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Set the compact interval to ").append(interval$1.elem).append(" ").append("[defaultCompactInterval: ").append(this.defaultCompactInterval()).append("]").toString());
                this.compactInterval = interval.elem;
                this.bitmap$0 = true;
            }
        }
        return this.compactInterval;
    }

    public final int compactInterval() {
        return !this.bitmap$0 ? this.compactInterval$lzycompute() : this.compactInterval;
    }

    public abstract Seq<T> compactLogs(Seq<T> var1);

    @Override
    public Path batchIdToPath(long batchId) {
        return CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, this.compactInterval()) ? new Path(this.metadataPath(), new StringBuilder(0).append(batchId).append(CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX()).toString()) : new Path(this.metadataPath(), ((Object)BoxesRunTime.boxToLong((long)batchId)).toString());
    }

    @Override
    public long pathToBatchId(Path path) {
        return CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
    }

    @Override
    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void serialize(T[] logData, OutputStream out) {
        out.write(new StringBuilder(1).append("v").append(this.metadataLogVersion).toString().getBytes(StandardCharsets.UTF_8));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logData)).foreach((Function1 & Serializable & scala.Serializable)data -> {
            CompactibleFileStreamLog.$anonfun$serialize$1(this, out, data);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public T[] deserialize(InputStream in) {
        Iterator lines = Source$.MODULE$.fromInputStream(in, StandardCharsets.UTF_8.name()).getLines();
        if (!lines.hasNext()) {
            throw new IllegalStateException("Incomplete log file");
        }
        this.validateVersion((String)lines.next(), this.metadataLogVersion);
        return (Object[])lines.map((Function1 & Serializable & scala.Serializable)json -> Serialization$.MODULE$.read(json, this.formats(), this.manifest())).toArray(this.manifest());
    }

    @Override
    public boolean add(long batchId, T[] logs) {
        boolean batchAdded;
        block0: {
            boolean bl = batchAdded = CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, this.compactInterval()) ? this.compact(batchId, logs) : super.add(batchId, logs);
            if (!batchAdded || !this.isDeletingExpiredLog()) break block0;
            this.deleteExpiredLog(batchId);
        }
        return batchAdded;
    }

    @Override
    public void purge(long thresholdBatchId) {
        throw new UnsupportedOperationException("Cannot purge as it might break internal state.");
    }

    private boolean compact(long batchId, T[] logs) {
        Seq<Object> validBatches = CompactibleFileStreamLog$.MODULE$.getValidBatchesBeforeCompactionBatch(batchId, this.compactInterval());
        Seq allLogs = (Seq)((TraversableLike)validBatches.flatMap((Function1 & Serializable & scala.Serializable)id -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.super$get(BoxesRunTime.unboxToLong((Object)id)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(57).append($this.batchIdToPath(id)).append(" doesn't exist when compacting batch ").append(batchId$1).append(" ").append("(compactInterval: ").append($this.compactInterval()).append(")").toString());
        }))), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logs)), Seq$.MODULE$.canBuildFrom());
        return super.add(batchId, this.compactLogs(allLogs).toArray(this.manifest()));
    }

    public T[] allFiles() {
        LongRef latestId = LongRef.create((long)BoxesRunTime.unboxToLong((Object)this.getLatest().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1._1$mcJ$sp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)));
        while (latestId.elem >= 0L) {
            try {
                Seq logs = (Seq)CompactibleFileStreamLog$.MODULE$.getAllValidBatches(latestId.elem, this.compactInterval()).flatMap((Function1 & Serializable & scala.Serializable)id -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.super$get(BoxesRunTime.unboxToLong((Object)id)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(46).append($this.batchIdToPath(id)).append(" doesn't exist ").append("(latestId: ").append(latestId$1.elem).append(", compactInterval: ").append($this.compactInterval()).append(")").toString());
                }))), Seq$.MODULE$.canBuildFrom());
                return (Object[])this.compactLogs(logs).toArray(this.manifest());
            }
            catch (IOException e) {
                latestId.elem = CompactibleFileStreamLog$.MODULE$.nextCompactionBatchId(latestId.elem, this.compactInterval());
                super.get(latestId.elem).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw e;
                });
            }
        }
        return (Object[])Array$.MODULE$.empty(this.manifest());
    }

    private void deleteExpiredLog(long currentBatchId) {
        block0: {
            if ((long)this.compactInterval() > currentBatchId + 1L - (long)this.minBatchesToRetain()) break block0;
            long minBatchId = currentBatchId + 1L - (long)this.minBatchesToRetain();
            long minCompactionBatchId = minBatchId - minBatchId % (long)this.compactInterval() - 1L;
            Predef$.MODULE$.assert(CompactibleFileStreamLog$.MODULE$.isCompactionBatch(minCompactionBatchId, this.compactInterval()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append(minCompactionBatchId).append(" is not a compaction batch").toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Current compact batch id = ").append(currentBatchId).append(" ").append("min compaction batch id to delete = ").append(minCompactionBatchId).toString());
            long expiredTime = System.currentTimeMillis() - this.fileCleanupDelayMs();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), path -> {
                boolean bl;
                block3: {
                    try {
                        long batchId = CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
                        if (batchId < minCompactionBatchId) {
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                }
                return bl;
            }))).foreach((Function1 & Serializable & scala.Serializable)f -> {
                CompactibleFileStreamLog.$anonfun$deleteExpiredLog$4(this, expiredTime, f);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$compactInterval$1(FileStatus f) {
        return f.getPath().toString().endsWith(CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX());
    }

    public static final /* synthetic */ void $anonfun$serialize$1(CompactibleFileStreamLog $this, OutputStream out$1, Object data) {
        out$1.write(10);
        out$1.write(Serialization$.MODULE$.write(data, $this.formats()).getBytes(StandardCharsets.UTF_8));
    }

    public static final /* synthetic */ void $anonfun$deleteExpiredLog$4(CompactibleFileStreamLog $this, long expiredTime$1, FileStatus f) {
        block0: {
            if (f.getModificationTime() > expiredTime$1) break block0;
            $this.fileManager().delete(f.getPath());
        }
    }

    public CompactibleFileStreamLog(int metadataLogVersion, SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.metadataLogVersion = metadataLogVersion;
        super(sparkSession, path, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$1.runtimeClass())));
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        this.minBatchesToRetain = sparkSession.sessionState().conf().minBatchesToRetain();
    }
}

