/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.optimizer.EliminateResolvedHint$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.IgnoreCachedData;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryRelation$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.FileTable;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\t-a\u0001\u0002\f\u0018\u0001\tBQa\f\u0001\u0005\u0002ABqa\r\u0001A\u0002\u0013%A\u0007C\u0004A\u0001\u0001\u0007I\u0011B!\t\r\u001d\u0003\u0001\u0015)\u00036\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u00159\u0006\u0001\"\u0001Y\u0011%\t9\u0001AI\u0001\n\u0003\tI\u0001C\u0005\u0002 \u0001\t\n\u0011\"\u0001\u0002\"!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002bBA\u0013\u0001\u0011\u0005\u0011\u0011\b\u0005\n\u0003C\u0002\u0011\u0013!C\u0001\u0003GB\u0001\"a\u001a\u0001\t\u0003I\u0012\u0011\u000e\u0005\b\u0003'\u0003A\u0011AAK\u0011\u001d\tY\n\u0001C\u0005\u0003;Cq!a+\u0001\t\u0003\ti\u000bC\u0004\u0002,\u0002!\t!!0\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002D\"9\u0011q\u0019\u0001\u0005\u0002\u0005%\u0007bBAi\u0001\u0011%\u00111\u001b\u0005\b\u0003g\u0004A\u0011BA{\u00051\u0019\u0015m\u00195f\u001b\u0006t\u0017mZ3s\u0015\tA\u0012$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011!dG\u0001\u0004gFd'B\u0001\u000f\u001e\u0003\u0015\u0019\b/\u0019:l\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aI\u0015\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\r\u0005s\u0017PU3g!\tQS&D\u0001,\u0015\ta3$\u0001\u0005j]R,'O\\1m\u0013\tq3FA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\t\u0004C\u0001\u001a\u0001\u001b\u00059\u0012AC2bG\",G\rR1uCV\tQ\u0007E\u00027wuj\u0011a\u000e\u0006\u0003qe\n\u0011\"[7nkR\f'\r\\3\u000b\u0005i*\u0013AC2pY2,7\r^5p]&\u0011Ah\u000e\u0002\u000b\u0013:$W\r_3e'\u0016\f\bC\u0001\u001a?\u0013\tytC\u0001\u0006DC\u000eDW\r\u001a#bi\u0006\fabY1dQ\u0016$G)\u0019;b?\u0012*\u0017\u000f\u0006\u0002C\u000bB\u0011AeQ\u0005\u0003\t\u0016\u0012A!\u00168ji\"9aiAA\u0001\u0002\u0004)\u0014a\u0001=%c\u0005Y1-Y2iK\u0012$\u0015\r^1!Q\t!\u0011\n\u0005\u0002%\u0015&\u00111*\n\u0002\tm>d\u0017\r^5mK\"\u0012A!\u0014\t\u0003I9K!aT\u0013\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018AC2mK\u0006\u00148)Y2iKR\t!)A\u0004jg\u0016k\u0007\u000f^=\u0016\u0003Q\u0003\"\u0001J+\n\u0005Y+#a\u0002\"p_2,\u0017M\\\u0001\u000bG\u0006\u001c\u0007.Z)vKJLH\u0003\u0002\"ZWnDQAW\u0004A\u0002m\u000bQ!];fef\u0004$\u0001\u00182\u0011\u0007us\u0006-D\u0001\u001a\u0013\ty\u0016DA\u0004ECR\f7/\u001a;\u0011\u0005\u0005\u0014G\u0002\u0001\u0003\nGf\u000b\t\u0011!A\u0003\u0002\u0011\u00141a\u0018\u00132#\t)\u0007\u000e\u0005\u0002%M&\u0011q-\n\u0002\b\u001d>$\b.\u001b8h!\t!\u0013.\u0003\u0002kK\t\u0019\u0011I\\=\t\u000f1<\u0001\u0013!a\u0001[\u0006IA/\u00192mK:\u000bW.\u001a\t\u0004I9\u0004\u0018BA8&\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011\u000f\u001f\b\u0003eZ\u0004\"a]\u0013\u000e\u0003QT!!^\u0011\u0002\rq\u0012xn\u001c;?\u0013\t9X%\u0001\u0004Qe\u0016$WMZ\u0005\u0003sj\u0014aa\u0015;sS:<'BA<&\u0011\u001dax\u0001%AA\u0002u\fAb\u001d;pe\u0006<W\rT3wK2\u00042A`A\u0002\u001b\u0005y(bAA\u00017\u000591\u000f^8sC\u001e,\u0017bAA\u0003\u007f\na1\u000b^8sC\u001e,G*\u001a<fY\u0006!2-Y2iKF+XM]=%I\u00164\u0017-\u001e7uII*\"!a\u0003+\u00075\fia\u000b\u0002\u0002\u0010A!\u0011\u0011CA\u000e\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011!C;oG\",7m[3e\u0015\r\tI\"J\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u000f\u0003'\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Q\u0019\u0017m\u00195f#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0005\u0016\u0004{\u00065\u0011\u0001D;oG\u0006\u001c\u0007.Z)vKJLH#\u0002\"\u0002*\u0005U\u0002B\u0002.\u000b\u0001\u0004\tY\u0003\r\u0003\u0002.\u0005E\u0002\u0003B/_\u0003_\u00012!YA\u0019\t-\t\u0019$!\u000b\u0002\u0002\u0003\u0005)\u0011\u00013\u0003\u0007}##\u0007\u0003\u0004\u00028)\u0001\r\u0001V\u0001\bG\u0006\u001c8-\u00193f)%\u0011\u00151HA\"\u00037\ni\u0006\u0003\u0004\u001d\u0017\u0001\u0007\u0011Q\b\t\u0004;\u0006}\u0012bAA!3\ta1\u000b]1sWN+7o]5p]\"9\u0011QI\u0006A\u0002\u0005\u001d\u0013\u0001\u00029mC:\u0004B!!\u0013\u0002X5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%A\u0004m_\u001eL7-\u00197\u000b\t\u0005E\u00131K\u0001\u0006a2\fgn\u001d\u0006\u0004\u0003+J\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005e\u00131\n\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0003\u0004\u00028-\u0001\r\u0001\u0016\u0005\t\u0003?Z\u0001\u0013!a\u0001)\u0006A!\r\\8dW&tw-\u0001\fv]\u000e\f7\r[3Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\t)GK\u0002U\u0003\u001b\tq#\u00198bYfTXmQ8mk6t7)Y2iKF+XM]=\u0015\u000f\t\u000bY'a\u001c\u0002r!9\u0011QN\u0007A\u0002\u0005u\u0012\u0001D:qCJ\\7+Z:tS>t\u0007\"B\u001a\u000e\u0001\u0004i\u0004bBA:\u001b\u0001\u0007\u0011QO\u0001\u0007G>dW/\u001c8\u0011\r\u0005]\u0014\u0011QAD\u001d\u0011\tI(! \u000f\u0007M\fY(C\u0001'\u0013\r\ty(J\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019)!\"\u0003\u0007M+\u0017OC\u0002\u0002\u0000\u0015\u0002B!!#\u0002\u00106\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000b\u0019&A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002BAI\u0003\u0017\u0013\u0011\"\u0011;ue&\u0014W\u000f^3\u0002\u001bI,7-Y2iK\nK\b\u000b\\1o)\u0015\u0011\u0015qSAM\u0011\u0019ab\u00021\u0001\u0002>!9\u0011Q\t\bA\u0002\u0005\u001d\u0013A\u0005:fG\u0006\u001c\u0007.\u001a\"z\u0007>tG-\u001b;j_:$RAQAP\u0003CCa\u0001H\bA\u0002\u0005u\u0002bBAR\u001f\u0001\u0007\u0011QU\u0001\nG>tG-\u001b;j_:\u0004R\u0001JAT{QK1!!+&\u0005%1UO\\2uS>t\u0017'\u0001\tm_>\\W\u000f]\"bG\",G\rR1uCR!\u0011qVAY!\r!c.\u0010\u0005\u00075B\u0001\r!a-1\t\u0005U\u0016\u0011\u0018\t\u0005;z\u000b9\fE\u0002b\u0003s#1\"a/\u00022\u0006\u0005\t\u0011!B\u0001I\n\u0019q\fJ\u001a\u0015\t\u0005=\u0016q\u0018\u0005\b\u0003\u000b\n\u0002\u0019AA$\u00035)8/Z\"bG\",G\rR1uCR!\u0011qIAc\u0011\u001d\t)E\u0005a\u0001\u0003\u000f\nQB]3dC\u000eDWMQ=QCRDG#\u0002\"\u0002L\u00065\u0007B\u0002\u000f\u0014\u0001\u0004\ti\u0004\u0003\u0004\u0002PN\u0001\r\u0001]\u0001\re\u0016\u001cx.\u001e:dKB\u000bG\u000f[\u0001\u0011Y>|7.\u001e9B]\u0012\u0014VM\u001a:fg\"$r\u0001VAk\u0003/\fI\u000fC\u0004\u0002FQ\u0001\r!a\u0012\t\u000f\u0005eG\u00031\u0001\u0002\\\u0006\u0011am\u001d\t\u0005\u0003;\f)/\u0004\u0002\u0002`*!\u0011\u0011\\Aq\u0015\r\t\u0019/H\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005\u001d\u0018q\u001c\u0002\u000b\r&dWmU=ti\u0016l\u0007bBAv)\u0001\u0007\u0011Q^\u0001\u000ecV\fG.\u001b4jK\u0012\u0004\u0016\r\u001e5\u0011\t\u0005u\u0017q^\u0005\u0005\u0003c\fyN\u0001\u0003QCRD\u0017a\u0007:fMJ,7\u000f\u001b$jY\u0016Le\u000eZ3y\u0013\u001atUmY3tg\u0006\u0014\u0018\u0010F\u0004U\u0003o\u00149A!\u0003\t\u000f\u0005eX\u00031\u0001\u0002|\u0006Ia-\u001b7f\u0013:$W\r\u001f\t\u0005\u0003{\u0014\u0019!\u0004\u0002\u0002\u0000*\u0019!\u0011A\f\u0002\u0017\u0011\fG/Y:pkJ\u001cWm]\u0005\u0005\u0005\u000b\tyPA\u0005GS2,\u0017J\u001c3fq\"9\u0011\u0011\\\u000bA\u0002\u0005m\u0007bBAv+\u0001\u0007\u0011Q\u001e")
public class CacheManager
implements Logging {
    private volatile transient IndexedSeq<CachedData> cachedData;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private IndexedSeq<CachedData> cachedData() {
        return this.cachedData;
    }

    private void cachedData_$eq(IndexedSeq<CachedData> x$1) {
        this.cachedData = x$1;
    }

    public synchronized void clearCache() {
        this.cachedData().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            CacheManager.$anonfun$clearCache$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)IndexedSeq$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    public boolean isEmpty() {
        return this.cachedData().isEmpty();
    }

    public void cacheQuery(Dataset<?> query, Option<String> tableName, StorageLevel storageLevel) {
        LogicalPlan planToCache = query.logicalPlan();
        if (this.lookupCachedData(planToCache).nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Asked to cache already cached data.");
        } else {
            SparkSession sparkSession = query.sparkSession();
            QueryExecution qe = sparkSession.sessionState().executePlan(planToCache);
            InMemoryRelation inMemoryRelation = InMemoryRelation$.MODULE$.apply(sparkSession.sessionState().conf().useCompression(), sparkSession.sessionState().conf().columnBatchSize(), storageLevel, qe.executedPlan(), tableName, qe.optimizedPlan());
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                if (this.lookupCachedData(planToCache).nonEmpty()) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Data has already been cached.");
                } else {
                    CachedData cachedData = new CachedData(planToCache, inMemoryRelation);
                    this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().$plus$colon((Object)cachedData, IndexedSeq$.MODULE$.canBuildFrom())));
                }
            }
        }
    }

    public Option<String> cacheQuery$default$2() {
        return None$.MODULE$;
    }

    public StorageLevel cacheQuery$default$3() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade) {
        this.uncacheQuery(query.sparkSession(), query.logicalPlan(), cascade, this.uncacheQuery$default$4());
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        block3: {
            Function1 & Serializable & scala.Serializable shouldRemove = cascade ? (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$1(plan, x$3)) : (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.sameResult((QueryPlan)plan));
            IndexedSeq plansToUncache = (IndexedSeq)this.cachedData().filter((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$4(shouldRemove, cd)));
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plansToUncache.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$6(cd, x$6)))))));
            }
            plansToUncache.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                CacheManager.$anonfun$uncacheQuery$7(blocking, x$7);
                return BoxedUnit.UNIT;
            });
            if (cascade) break block3;
            this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$8(plan, cd)));
        }
    }

    public boolean uncacheQuery$default$4() {
        return false;
    }

    public void analyzeColumnCacheQuery(SparkSession sparkSession, CachedData cachedData, Seq<Attribute> column) {
        InMemoryRelation relation = cachedData.cachedRepresentation();
        Tuple2<Object, Map<Attribute, ColumnStat>> tuple2 = CommandUtils$.MODULE$.computeColumnStats(sparkSession, (LogicalPlan)relation, column);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long rowCount = tuple2._1$mcJ$sp();
        Map newColStats = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)newColStats);
        Tuple2 tuple23 = tuple22;
        long rowCount2 = tuple23._1$mcJ$sp();
        Map newColStats2 = (Map)tuple23._2();
        relation.updateStats(rowCount2, (Map<Attribute, ColumnStat>)newColStats2);
    }

    public void recacheByPlan(SparkSession spark, LogicalPlan plan) {
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPlan$1(plan, x$10)));
    }

    private void recacheByCondition(SparkSession spark, Function1<CachedData, Object> condition) {
        IndexedSeq needToRecache = (IndexedSeq)this.cachedData().filter(condition);
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)needToRecache.exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByCondition$2(cd, x$12)))))));
        }
        needToRecache.map((Function1 & Serializable & scala.Serializable)cd -> {
            CacheManager.$anonfun$recacheByCondition$3(this, spark, cd);
            return BoxedUnit.UNIT;
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Option<CachedData> lookupCachedData(Dataset<?> query) {
        return this.lookupCachedData(query.logicalPlan());
    }

    public Option<CachedData> lookupCachedData(LogicalPlan plan) {
        return this.cachedData().find((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plan.sameResult((QueryPlan)cd.plan())));
    }

    public LogicalPlan useCachedData(LogicalPlan plan) {
        LogicalPlan newPlan = plan.transformDown((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                IgnoreCachedData ignoreCachedData;
                A1 A1 = x1;
                Object object = A1 instanceof IgnoreCachedData ? (ignoreCachedData = (IgnoreCachedData)A1) : this.$outer.lookupCachedData(A1).map((Function1 & Serializable & scala.Serializable)cached -> {
                    Seq hints = (Seq)EliminateResolvedHint$.MODULE$.extractHintsFromPlan(A1)._2();
                    InMemoryRelation cachedPlan = cached.cachedRepresentation().withOutput((Seq<Attribute>)A1.output());
                    return (LogicalPlan)hints.foldRight((Object)((Object)cachedPlan), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        HintInfo hint = (HintInfo)tuple2._1();
                        LogicalPlan p = (LogicalPlan)tuple2._2();
                        ResolvedHint resolvedHint = new ResolvedHint(p, hint);
                        return resolvedHint;
                    });
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> A1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof IgnoreCachedData ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.execution.CachedData ), $anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.HintInfo org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
        return newPlan.transformAllExpressions((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    object = subqueryExpression.withNewPlan(this.$outer.useCachedData((LogicalPlan)subqueryExpression.plan()));
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                boolean bl = expression instanceof SubqueryExpression;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void recacheByPath(SparkSession spark, String resourcePath) {
        Path path = new Path(resourcePath);
        FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConf());
        Tuple2 tuple2 = new Tuple2((Object)fs, (Object)fs.makeQualified(path));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FileSystem fs2 = (FileSystem)tuple2._1();
        Path qualifiedPath = (Path)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fs2, (Object)qualifiedPath);
        Tuple2 tuple23 = tuple22;
        FileSystem fs3 = (FileSystem)tuple23._1();
        Path qualifiedPath2 = (Path)tuple23._2();
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPath$1(this, fs3, qualifiedPath2, x$15)));
    }

    private boolean lookupAndRefresh(LogicalPlan plan, FileSystem fs, Path qualifiedPath) {
        DataSourceV2Relation dataSourceV2Relation;
        Table fileTable;
        boolean bl;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalRelation) {
            boolean bl2;
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan2;
            BaseRelation baseRelation = logicalRelation.relation();
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                bl2 = this.refreshFileIndexIfNecessary(hadoopFsRelation.location(), fs, qualifiedPath);
            } else {
                bl2 = false;
            }
            bl = bl2;
        } else if (logicalPlan2 instanceof DataSourceV2Relation && (fileTable = (dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2).table()) instanceof FileTable) {
            FileTable fileTable2 = (FileTable)fileTable;
            bl = this.refreshFileIndexIfNecessary(fileTable2.fileIndex(), fs, qualifiedPath);
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean refreshFileIndexIfNecessary(FileIndex fileIndex, FileSystem fs, Path qualifiedPath) {
        boolean needToRefresh;
        block0: {
            String prefixToInvalidate = qualifiedPath.toString();
            needToRefresh = ((IterableLike)fileIndex.rootPaths().map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString(), Seq$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.startsWith(prefixToInvalidate)));
            if (!needToRefresh) break block0;
            fileIndex.refresh();
        }
        return needToRefresh;
    }

    public static final /* synthetic */ void $anonfun$clearCache$1(CachedData x$1) {
        x$1.cachedRepresentation().cacheBuilder().clearCache(x$1.cachedRepresentation().cacheBuilder().clearCache$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$1(LogicalPlan plan$1, LogicalPlan x$3) {
        return x$3.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.sameResult((QueryPlan)plan$1))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$4(Function1 shouldRemove$1, CachedData cd) {
        return BoxesRunTime.unboxToBoolean((Object)shouldRemove$1.apply((Object)cd.plan()));
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$6(CachedData cd$1, CachedData x$6) {
        return x$6 == cd$1;
    }

    public static final /* synthetic */ void $anonfun$uncacheQuery$7(boolean blocking$1, CachedData x$7) {
        x$7.cachedRepresentation().cacheBuilder().clearCache(blocking$1);
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$8(LogicalPlan plan$1, CachedData cd) {
        boolean cacheAlreadyLoaded = cd.cachedRepresentation().cacheBuilder().isCachedColumnBuffersLoaded();
        return cd.plan().find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.sameResult((QueryPlan)plan$1))).isDefined() && !cacheAlreadyLoaded;
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPlan$1(LogicalPlan plan$2, CachedData x$10) {
        return x$10.plan().find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.sameResult((QueryPlan)plan$2))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$recacheByCondition$2(CachedData cd$2, CachedData x$12) {
        return x$12 == cd$2;
    }

    public static final /* synthetic */ void $anonfun$recacheByCondition$3(CacheManager $this, SparkSession spark$1, CachedData cd) {
        InMemoryRelation newCache;
        cd.cachedRepresentation().cacheBuilder().clearCache(cd.cachedRepresentation().cacheBuilder().clearCache$default$1());
        QueryExecution qe = spark$1.sessionState().executePlan(cd.plan());
        SparkPlan x$1 = qe.executedPlan();
        boolean x$2 = cd.cachedRepresentation().cacheBuilder().copy$default$1();
        int x$3 = cd.cachedRepresentation().cacheBuilder().copy$default$2();
        StorageLevel x$4 = cd.cachedRepresentation().cacheBuilder().copy$default$3();
        Option<String> x$5 = cd.cachedRepresentation().cacheBuilder().copy$default$5();
        InMemoryRelation x$6 = newCache = InMemoryRelation$.MODULE$.apply(cd.cachedRepresentation().cacheBuilder().copy(x$2, x$3, x$4, x$1, x$5), qe.optimizedPlan());
        LogicalPlan x$7 = cd.copy$default$1();
        CachedData recomputedPlan = cd.copy(x$7, x$6);
        CacheManager cacheManager = $this;
        synchronized (cacheManager) {
            if ($this.lookupCachedData(recomputedPlan.plan()).nonEmpty()) {
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "While recaching, data was already added to cache.");
            } else {
                CachedData cachedData = recomputedPlan;
                $this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)$this.cachedData().$plus$colon((Object)cachedData, IndexedSeq$.MODULE$.canBuildFrom())));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPath$1(CacheManager $this, FileSystem fs$1, Path qualifiedPath$1, CachedData x$15) {
        return x$15.plan().find((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)$this.lookupAndRefresh(x$16, fs$1, qualifiedPath$1))).isDefined();
    }

    public CacheManager() {
        Logging.$init$((Logging)this);
        this.cachedData = (IndexedSeq)IndexedSeq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

