/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.execution.streaming.sources.TextSocketTable;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0002\u0004\u0001+!)\u0011\u0007\u0001C\u0001e!)Q\u0007\u0001C\u0005m!)Q\t\u0001C!\r\")A\n\u0001C!\u001b\nAB+\u001a=u'>\u001c7.\u001a;T_V\u00148-\u001a)s_ZLG-\u001a:\u000b\u0005\u001dA\u0011aB:pkJ\u001cWm\u001d\u0006\u0003\u0013)\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005-a\u0011!C3yK\u000e,H/[8o\u0015\tia\"A\u0002tc2T!a\u0004\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\u0015\u0001aC\b\u0014,!\t9B$D\u0001\u0019\u0015\tI\"$\u0001\u0003mC:<'\"A\u000e\u0002\t)\fg/Y\u0005\u0003;a\u0011aa\u00142kK\u000e$\bCA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\u001d\u0019\u0017\r^1m_\u001eT!a\t\u0007\u0002\u0013\r|gN\\3di>\u0014\u0018BA\u0013!\u00055!\u0016M\u00197f!J|g/\u001b3feB\u0011q%K\u0007\u0002Q)\u0011q\u0001D\u0005\u0003U!\u0012!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;feB\u0011AfL\u0007\u0002[)\u0011aFD\u0001\tS:$XM\u001d8bY&\u0011\u0001'\f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t1\u0007\u0005\u00025\u00015\ta!A\bdQ\u0016\u001c7\u000eU1sC6,G/\u001a:t)\t9T\b\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014H\u0001\u0003V]&$\b\"\u0002 \u0003\u0001\u0004y\u0014A\u00029be\u0006l7\u000f\u0005\u0002A\u00076\t\u0011I\u0003\u0002C\u0019\u0005!Q\u000f^5m\u0013\t!\u0015I\u0001\rDCN,\u0017J\\:f]NLG/\u001b<f'R\u0014\u0018N\\4NCB\f\u0001bZ3u)\u0006\u0014G.\u001a\u000b\u0003\u000f*\u0003\"a\b%\n\u0005%\u0003#!\u0002+bE2,\u0007\"B&\u0004\u0001\u0004y\u0014aB8qi&|gn]\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012A\u0014\t\u0003\u001fZs!\u0001\u0015+\u0011\u0005EKT\"\u0001*\u000b\u0005M#\u0012A\u0002\u001fs_>$h(\u0003\u0002Vs\u00051\u0001K]3eK\u001aL!a\u0016-\u0003\rM#(/\u001b8h\u0015\t)\u0016\b")
public class TextSocketSourceProvider
implements TableProvider,
DataSourceRegister,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Table getTable(CaseInsensitiveStringMap x$1, StructType x$2) {
        return super.getTable(x$1, x$2);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private void checkParameters(CaseInsensitiveStringMap params) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The socket source should not be used for production applications! It does not support recovery.");
        if (!params.containsKey((Object)"host")) {
            throw new AnalysisException("Set a host to read from with option(\"host\", ...).", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (!params.containsKey((Object)"port")) {
            throw new AnalysisException("Set a port to read from with option(\"port\", ...).", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> params.getBoolean("includeTimestamp", false));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                throw new AnalysisException("includeTimestamp must be set to either \"true\" or \"false\"", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            throw new MatchError((Object)try_);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Table getTable(CaseInsensitiveStringMap options) {
        this.checkParameters(options);
        return new TextSocketTable(options.get((Object)"host"), options.getInt("port", -1), options.getInt("numPartitions", SparkSession$.MODULE$.active().sparkContext().defaultParallelism()), options.getBoolean("includeTimestamp", false));
    }

    @Override
    public String shortName() {
        return "socket";
    }

    public TextSocketSourceProvider() {
        Logging.$init$((Logging)this);
    }
}

