/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.CurrentBatchTimestamp;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.SparkDataStream;
import org.apache.spark.sql.connector.write.streaming.StreamingWrite;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.StreamWriterCommitProgress;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.WriteToDataSourceV2Exec;
import org.apache.spark.sql.execution.streaming.CommitMetadata;
import org.apache.spark.sql.execution.streaming.IncrementalExecution;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution$;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.OffsetHolder;
import org.apache.spark.sql.execution.streaming.OffsetSeq;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata$;
import org.apache.spark.sql.execution.streaming.OneTimeExecutor;
import org.apache.spark.sql.execution.streaming.OneTimeTrigger$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor;
import org.apache.spark.sql.execution.streaming.ProcessingTimeTrigger;
import org.apache.spark.sql.execution.streaming.ProgressReporter;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelationV2;
import org.apache.spark.sql.execution.streaming.TERMINATED$;
import org.apache.spark.sql.execution.streaming.TriggerExecutor;
import org.apache.spark.sql.execution.streaming.WatermarkTracker;
import org.apache.spark.sql.execution.streaming.WatermarkTracker$;
import org.apache.spark.sql.execution.streaming.sources.RateControlMicroBatchStream;
import org.apache.spark.sql.execution.streaming.sources.WriteToMicroBatchDataSource;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQueryStatus;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Clock;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t}a\u0001B\u0015+\u0001]B\u0011\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!P!\t\u0013\t\u0003!\u0011!Q\u0001\n\r\u0003\u0006\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u0011I\u0003!\u0011!Q\u0001\nMC\u0011\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u00184\t\u0013\u001d\u0004!\u0011!Q\u0001\n!l\u0007\"\u00038\u0001\u0005\u0003\u0005\u000b\u0011B8v\u0011%1\bA!A!\u0002\u00139(\u0010\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003}\u0011%y\bA!A!\u0002\u0013\t\t\u0001C\u0004\u0002\n\u0001!\t!a\u0003\t\u0013\u0005\r\u0002\u00011A\u0005\u0012\u0005\u0015\u0002\"CA$\u0001\u0001\u0007I\u0011CA%\u0011!\t)\u0006\u0001Q!\n\u0005\u001d\u0002\"CA0\u0001\t\u0007I\u0011BA1\u0011!\tY\b\u0001Q\u0001\n\u0005\r\u0004bCA?\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u007fB1\"a\"\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\n\"Y\u0011Q\u0012\u0001A\u0002\u0003\u0005\u000b\u0015BAA\u0011)\ty\t\u0001EC\u0002\u0013\u0005\u0013\u0011\u0013\u0005\n\u0003'\u0003\u0001\u0019!C\u0005\u0003+C\u0011\"a&\u0001\u0001\u0004%I!!'\t\u0011\u0005u\u0005\u0001)Q\u0005\u0003\u0003Aq!a(\u0001\t\u0003\n\t\u000bC\u0004\u0002$\u0002!\t&!)\t\u000f\u0005\u0015\u0006\u0001\"\u0005\u0002(\"9\u0011Q\u0016\u0001\u0005\n\u0005=\u0006bBA[\u0001\u0011%\u0011Q\u0013\u0005\b\u0003o\u0003A\u0011BA]\u0011\u001d\ty\f\u0001C\u0005\u0003\u0003D\u0001\"a2\u0001\t\u0003q\u0013\u0011\u001a\u0005\u000e\u0003[\u0004\u0001\u0013aA\u0001\u0002\u0013%\u0011q^!\t\u001b\u0005E\b\u0001%A\u0002\u0002\u0003%I!a=v\u00115\t)\u0010\u0001I\u0001\u0004\u0003\u0005I\u0011BA|u\"i\u0011\u0011 \u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0002|\u001a<q!!@+\u0011\u0003\tyP\u0002\u0004*U!\u0005!\u0011\u0001\u0005\b\u0003\u0013)C\u0011\u0001B\u0005\u0011%\u0011Y!\nb\u0001\n\u0003\u0011i\u0001\u0003\u0005\u0003\u001e\u0015\u0002\u000b\u0011\u0002B\b\u0005Mi\u0015n\u0019:p\u0005\u0006$8\r[#yK\u000e,H/[8o\u0015\tYC&A\u0005tiJ,\u0017-\\5oO*\u0011QFL\u0001\nKb,7-\u001e;j_:T!a\f\u0019\u0002\u0007M\fHN\u0003\u00022e\u0005)1\u000f]1sW*\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u001d\u0011\u0005eRT\"\u0001\u0016\n\u0005mR#aD*ue\u0016\fW.\u0012=fGV$\u0018n\u001c8\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005yzT\"\u0001\u0018\n\u0005\u0001s#\u0001D*qCJ\\7+Z:tS>t\u0017B\u0001\u001f;\u0003\u0011q\u0017-\\3\u0011\u0005\u0011keBA#L!\t1\u0015*D\u0001H\u0015\tAe'\u0001\u0004=e>|GO\u0010\u0006\u0002\u0015\u0006)1oY1mC&\u0011A*S\u0001\u0007!J,G-\u001a4\n\u00059{%AB*ue&twM\u0003\u0002M\u0013&\u0011!IO\u0001\u000fG\",7m\u001b9pS:$(k\\8u\u00031\tg.\u00197zu\u0016$\u0007\u000b\\1o!\t!6,D\u0001V\u0015\t1v+A\u0004m_\u001eL7-\u00197\u000b\u0005aK\u0016!\u00029mC:\u001c(B\u0001./\u0003!\u0019\u0017\r^1msN$\u0018B\u0001/V\u0005-aunZ5dC2\u0004F.\u00198\u0002\tMLgn\u001b\t\u0003?\u0012l\u0011\u0001\u0019\u0006\u0003C\n\fqaY1uC2|wM\u0003\u0002d]\u0005I1m\u001c8oK\u000e$xN]\u0005\u0003K\u0002\u0014Q\u0001V1cY\u0016L!!\u0018\u001e\u0002\u000fQ\u0014\u0018nZ4feB\u0011\u0011n[\u0007\u0002U*\u00111FL\u0005\u0003Y*\u0014q\u0001\u0016:jO\u001e,'/\u0003\u0002hu\u0005aAO]5hO\u0016\u00148\t\\8dWB\u0011\u0001o]\u0007\u0002c*\u0011!\u000fM\u0001\u0005kRLG.\u0003\u0002uc\n)1\t\\8dW&\u0011aNO\u0001\u000b_V$\b/\u001e;N_\u0012,\u0007CA5y\u0013\tI(N\u0001\u0006PkR\u0004X\u000f^'pI\u0016L!A\u001e\u001e\u0002\u0019\u0015DHO]1PaRLwN\\:\u0011\t\u0011k8iQ\u0005\u0003}>\u00131!T1q\u0003Y!W\r\\3uK\u000eCWmY6q_&tGo\u00148Ti>\u0004\b\u0003BA\u0002\u0003\u000bi\u0011!S\u0005\u0004\u0003\u000fI%a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015-\u00055\u0011qBA\t\u0003'\t)\"a\u0006\u0002\u001a\u0005m\u0011QDA\u0010\u0003C\u0001\"!\u000f\u0001\t\u000bqZ\u0001\u0019A\u001f\t\u000b\t[\u0001\u0019A\"\t\u000bE[\u0001\u0019A\"\t\u000bI[\u0001\u0019A*\t\u000bu[\u0001\u0019\u00010\t\u000b\u001d\\\u0001\u0019\u00015\t\u000b9\\\u0001\u0019A8\t\u000bY\\\u0001\u0019A<\t\u000bm\\\u0001\u0019\u0001?\t\r}\\\u0001\u0019AA\u0001\u0003\u001d\u0019x.\u001e:dKN,\"!a\n\u0011\r\u0005%\u00121GA\u001d\u001d\u0011\tY#a\f\u000f\u0007\u0019\u000bi#C\u0001K\u0013\r\t\t$S\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)$a\u000e\u0003\u0007M+\u0017OC\u0002\u00022%\u0003B!a\u000f\u0002D5\u0011\u0011Q\b\u0006\u0004W\u0005}\"bAA!E\u0006!!/Z1e\u0013\u0011\t)%!\u0010\u0003\u001fM\u0003\u0018M]6ECR\f7\u000b\u001e:fC6\f1b]8ve\u000e,7o\u0018\u0013fcR!\u00111JA)!\u0011\t\u0019!!\u0014\n\u0007\u0005=\u0013J\u0001\u0003V]&$\b\"CA*\u001b\u0005\u0005\t\u0019AA\u0014\u0003\rAH%M\u0001\tg>,(oY3tA!\u001aa\"!\u0017\u0011\t\u0005\r\u00111L\u0005\u0004\u0003;J%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u001fQ\u0014\u0018nZ4fe\u0016CXmY;u_J,\"!a\u0019\u0013\u0011\u0005\u0015\u0014\u0011NA8\u0003k2a!a\u001a\u0001\u0001\u0005\r$\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004\u0003BA\u0002\u0003WJ1!!\u001cJ\u0005\u001d\u0001&o\u001c3vGR\u0004B!a\u0001\u0002r%\u0019\u00111O%\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0007e\n9(C\u0002\u0002z)\u0012q\u0002\u0016:jO\u001e,'/\u0012=fGV$xN]\u0001\u0011iJLwmZ3s\u000bb,7-\u001e;pe\u0002\n\u0001c^1uKJl\u0017M]6Ue\u0006\u001c7.\u001a:\u0016\u0005\u0005\u0005\u0005cA\u001d\u0002\u0004&\u0019\u0011Q\u0011\u0016\u0003!]\u000bG/\u001a:nCJ\\GK]1dW\u0016\u0014\u0018\u0001F<bi\u0016\u0014X.\u0019:l)J\f7m[3s?\u0012*\u0017\u000f\u0006\u0003\u0002L\u0005-\u0005\"CA*%\u0005\u0005\t\u0019AAA\u0003E9\u0018\r^3s[\u0006\u00148\u000e\u0016:bG.,'\u000fI\u0001\fY><\u0017nY1m!2\fg.F\u0001T\u0003eI7oQ;se\u0016tGOQ1uG\"\u001cuN\\:ueV\u001cG/\u001a3\u0016\u0005\u0005\u0005\u0011!H5t\u0007V\u0014(/\u001a8u\u0005\u0006$8\r[\"p]N$(/^2uK\u0012|F%Z9\u0015\t\u0005-\u00131\u0014\u0005\n\u0003'2\u0012\u0011!a\u0001\u0003\u0003\t!$[:DkJ\u0014XM\u001c;CCR\u001c\u0007nQ8ogR\u0014Xo\u0019;fI\u0002\nAa\u001d;paR\u0011\u00111J\u0001\rgR\f'\u000f\u001e+sS\u001e<WM]\u0001\u0013eVt\u0017i\u0019;jm\u0006$X\rZ*ue\u0016\fW\u000e\u0006\u0003\u0002L\u0005%\u0006BBAV5\u0001\u0007Q(A\u000bta\u0006\u00148nU3tg&|gNR8s'R\u0014X-Y7\u0002)A|\u0007/\u001e7bi\u0016\u001cF/\u0019:u\u001f\u001a47/\u001a;t)\u0011\tY%!-\t\r\u0005M6\u00041\u0001>\u0003a\u0019\b/\u0019:l'\u0016\u001c8/[8o)>\u0014VO\u001c\"bi\u000eDWm]\u0001\u0013SNtUm\u001e#bi\u0006\fe/Y5mC\ndW-\u0001\nd_:\u001cHO];di:+\u0007\u0010\u001e\"bi\u000eDG\u0003BA\u0001\u0003wCq!!0\u001e\u0001\u0004\t\t!\u0001\u000bo_\u0012\u000bG/\u0019\"bi\u000eDWm]#oC\ndW\rZ\u0001\teVt')\u0019;dQR!\u00111JAb\u0011\u0019\t)M\ba\u0001{\u000512\u000f]1sWN+7o]5p]R{'+\u001e8CCR\u001c\u0007.\u0001\nxSRD\u0007K]8he\u0016\u001c8\u000fT8dW\u0016$W\u0003BAf\u0003#$B!!4\u0002dB!\u0011qZAi\u0019\u0001!q!a5 \u0005\u0004\t)NA\u0001U#\u0011\t9.!8\u0011\t\u0005\r\u0011\u0011\\\u0005\u0004\u00037L%a\u0002(pi\"Lgn\u001a\t\u0005\u0003\u0007\ty.C\u0002\u0002b&\u00131!\u00118z\u0011!\t)o\bCA\u0002\u0005\u001d\u0018!\u00014\u0011\r\u0005\r\u0011\u0011^Ag\u0013\r\tY/\u0013\u0002\ty\tLh.Y7f}\u0005\u00112/\u001e9fe\u0012\u001a\b/\u0019:l'\u0016\u001c8/[8o+\u0005i\u0014AE:va\u0016\u0014H\u0005\u001e:jO\u001e,'o\u00117pG.,\u0012a\\\u0001\u0011gV\u0004XM\u001d\u0013pkR\u0004X\u000f^'pI\u0016,\u0012a^\u0001\u000bgV\u0004XM\u001d\u0013tS:\\W#\u00010\u0002'5K7M]8CCR\u001c\u0007.\u0012=fGV$\u0018n\u001c8\u0011\u0005e*3cA\u0013\u0003\u0004A!\u00111\u0001B\u0003\u0013\r\u00119!\u0013\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005}\u0018\u0001\u0004\"B)\u000eCu,\u0013#`\u0017\u0016KVC\u0001B\b!\u0011\u0011\tBa\u0007\u000e\u0005\tM!\u0002\u0002B\u000b\u0005/\tA\u0001\\1oO*\u0011!\u0011D\u0001\u0005U\u00064\u0018-C\u0002O\u0005'\tQBQ!U\u0007\"{\u0016\nR0L\u000bf\u0003\u0003")
public class MicroBatchExecution
extends StreamExecution {
    private LogicalPlan logicalPlan;
    private final LogicalPlan analyzedPlan;
    private final scala.collection.immutable.Map<String, String> extraOptions;
    private volatile Seq<SparkDataStream> sources;
    private final Product triggerExecutor;
    private WatermarkTracker watermarkTracker;
    private boolean isCurrentBatchConstructed;
    private volatile boolean bitmap$0;

    public static String BATCH_ID_KEY() {
        return MicroBatchExecution$.MODULE$.BATCH_ID_KEY();
    }

    public /* synthetic */ SparkSession org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession() {
        return super.sparkSession();
    }

    private /* synthetic */ Clock super$triggerClock() {
        return super.triggerClock();
    }

    private /* synthetic */ OutputMode super$outputMode() {
        return super.outputMode();
    }

    private /* synthetic */ Table super$sink() {
        return super.sink();
    }

    @Override
    public Seq<SparkDataStream> sources() {
        return this.sources;
    }

    public void sources_$eq(Seq<SparkDataStream> x$1) {
        this.sources = x$1;
    }

    private Product triggerExecutor() {
        return this.triggerExecutor;
    }

    private WatermarkTracker watermarkTracker() {
        return this.watermarkTracker;
    }

    private void watermarkTracker_$eq(WatermarkTracker x$1) {
        this.watermarkTracker = x$1;
    }

    private LogicalPlan logicalPlan$lzycompute() {
        MicroBatchExecution microBatchExecution = this;
        synchronized (microBatchExecution) {
            if (!this.bitmap$0) {
                LogicalPlan logicalPlan2;
                Predef$.MODULE$.assert(this.queryExecutionThread() == Thread.currentThread(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("logicalPlan must be initialized in QueryExecutionThread ").append("but the current thread was ").append(Thread.currentThread()).toString());
                LongRef nextSourceId = LongRef.create((long)0L);
                Map toExecutionRelationMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                Map v2ToExecutionRelationMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                Map v2ToRelationMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                String[] disabledSources = super.sparkSession().sqlContext().conf().disabledV2StreamingMicroBatchReaders().split(",");
                LogicalPlan _logicalPlan = (LogicalPlan)this.analyzedPlan.transform((PartialFunction)new scala.Serializable(this, toExecutionRelationMap, nextSourceId, disabledSources, v2ToRelationMap, v2ToExecutionRelationMap){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MicroBatchExecution $outer;
                    private final Map toExecutionRelationMap$1;
                    private final LongRef nextSourceId$1;
                    private final String[] disabledSources$1;
                    private final Map v2ToRelationMap$1;
                    private final Map v2ToExecutionRelationMap$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof StreamingRelation) {
                            StreamingRelation streamingRelation = (StreamingRelation)A1;
                            DataSource dataSourceV1 = streamingRelation.dataSource();
                            String sourceName = streamingRelation.sourceName();
                            Seq<Attribute> output = streamingRelation.output();
                            object = this.toExecutionRelationMap$1.getOrElseUpdate((Object)((Object)streamingRelation), (Function0 & Serializable & scala.Serializable)() -> {
                                String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                Source source = dataSourceV1.createSource(metadataPath);
                                ++$this.nextSourceId$1.elem;
                                $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Using Source [").append(source).append("] from DataSourceV1 named '").append(sourceName).append("' [").append(dataSourceV1).append("]").toString());
                                return new StreamingExecutionRelation(source, output, $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession());
                            });
                            return (B1)object;
                        }
                        if (A1 instanceof StreamingRelationV2) {
                            StreamingRelationV2 streamingRelationV2 = (StreamingRelationV2)A1;
                            TableProvider src = streamingRelationV2.source();
                            String srcName = streamingRelationV2.sourceName();
                            Table table = streamingRelationV2.table();
                            CaseInsensitiveStringMap options = streamingRelationV2.extraOptions();
                            Seq<Attribute> output = streamingRelationV2.output();
                            Option<StreamingRelation> v1 = streamingRelationV2.v1Relation();
                            if (table instanceof SupportsRead) {
                                Object object2;
                                SupportsRead supportsRead = (SupportsRead)table;
                                boolean v2Disabled = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.disabledSources$1)).contains((Object)src.getClass().getCanonicalName());
                                if (!v2Disabled && DataSourceV2Implicits$.MODULE$.TableHelper((Table)supportsRead).supports(TableCapability.MICRO_BATCH_READ)) {
                                    object2 = this.v2ToRelationMap$1.getOrElseUpdate((Object)((Object)streamingRelationV2), (Function0 & Serializable & scala.Serializable)() -> {
                                        String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                        ++$this.nextSourceId$1.elem;
                                        $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Reading table [").append(supportsRead).append("] from DataSourceV2 named '").append(srcName).append("' [").append(src).append("]").toString());
                                        Scan scan = supportsRead.newScanBuilder(options).build();
                                        MicroBatchStream stream = scan.toMicroBatchStream(metadataPath);
                                        return new StreamingDataSourceV2Relation(output, scan, (SparkDataStream)stream, StreamingDataSourceV2Relation$.MODULE$.apply$default$4(), StreamingDataSourceV2Relation$.MODULE$.apply$default$5());
                                    });
                                } else {
                                    if (v1.isEmpty()) {
                                        throw new UnsupportedOperationException(new StringBuilder(52).append("Data source ").append(srcName).append(" does not support microbatch processing.").toString());
                                    }
                                    object2 = this.v2ToExecutionRelationMap$1.getOrElseUpdate((Object)((Object)streamingRelationV2), (Function0 & Serializable & scala.Serializable)() -> {
                                        String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                        Source source = ((StreamingRelation)((Object)((Object)v1.get()))).dataSource().createSource(metadataPath);
                                        ++$this.nextSourceId$1.elem;
                                        $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Using Source [").append(source).append("] from DataSourceV2 named '").append(srcName).append("' [").append(src).append("]").toString());
                                        return new StreamingExecutionRelation(source, output, $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession());
                                    });
                                }
                                object = object2;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        StreamingRelationV2 streamingRelationV2;
                        Table table;
                        LogicalPlan logicalPlan2 = x1;
                        boolean bl = logicalPlan2 instanceof StreamingRelation ? true : logicalPlan2 instanceof StreamingRelationV2 && (table = (streamingRelationV2 = (StreamingRelationV2)logicalPlan2).table()) instanceof SupportsRead;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.toExecutionRelationMap$1 = toExecutionRelationMap$1;
                        this.nextSourceId$1 = nextSourceId$1;
                        this.disabledSources$1 = disabledSources$1;
                        this.v2ToRelationMap$1 = v2ToRelationMap$1;
                        this.v2ToExecutionRelationMap$1 = v2ToExecutionRelationMap$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 org.apache.spark.sql.execution.datasources.DataSource java.lang.String scala.collection.Seq ), $anonfun$applyOrElse$3(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 org.apache.spark.sql.connector.catalog.SupportsRead java.lang.String org.apache.spark.sql.connector.catalog.TableProvider org.apache.spark.sql.util.CaseInsensitiveStringMap scala.collection.Seq ), $anonfun$applyOrElse$5(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 scala.Option java.lang.String org.apache.spark.sql.connector.catalog.TableProvider scala.collection.Seq ), $anonfun$applyOrElse$2(org.apache.spark.sql.execution.streaming.Source java.lang.String org.apache.spark.sql.execution.datasources.DataSource ), $anonfun$applyOrElse$4(org.apache.spark.sql.connector.catalog.SupportsRead java.lang.String org.apache.spark.sql.connector.catalog.TableProvider ), $anonfun$applyOrElse$6(org.apache.spark.sql.execution.streaming.Source java.lang.String org.apache.spark.sql.connector.catalog.TableProvider )}, serializedLambda);
                    }
                });
                this.sources_$eq((Seq<SparkDataStream>)_logicalPlan.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 instanceof StreamingExecutionRelation) {
                            StreamingExecutionRelation streamingExecutionRelation = (StreamingExecutionRelation)A1;
                            object = streamingExecutionRelation.source();
                        } else if (A1 instanceof StreamingDataSourceV2Relation) {
                            StreamingDataSourceV2Relation streamingDataSourceV2Relation = (StreamingDataSourceV2Relation)A1;
                            object = streamingDataSourceV2Relation.stream();
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x2) {
                        LogicalPlan logicalPlan2 = x2;
                        boolean bl = logicalPlan2 instanceof StreamingExecutionRelation ? true : logicalPlan2 instanceof StreamingDataSourceV2Relation;
                        return bl;
                    }
                }));
                this.uniqueSources_$eq((Seq<SparkDataStream>)((Seq)this.sources().distinct()));
                Table table = super.sink();
                if (table instanceof SupportsWrite) {
                    SupportsWrite supportsWrite = (SupportsWrite)table;
                    StreamingWrite streamingWrite = this.createStreamingWrite(supportsWrite, this.extraOptions, _logicalPlan);
                    logicalPlan2 = new WriteToMicroBatchDataSource(streamingWrite, _logicalPlan);
                } else {
                    logicalPlan2 = _logicalPlan;
                }
                this.logicalPlan = logicalPlan2;
                this.bitmap$0 = true;
            }
        }
        return this.logicalPlan;
    }

    @Override
    public LogicalPlan logicalPlan() {
        return !this.bitmap$0 ? this.logicalPlan$lzycompute() : this.logicalPlan;
    }

    private boolean isCurrentBatchConstructed() {
        return this.isCurrentBatchConstructed;
    }

    private void isCurrentBatchConstructed_$eq(boolean x$1) {
        this.isCurrentBatchConstructed = x$1;
    }

    @Override
    public void stop() {
        this.state().set(TERMINATED$.MODULE$);
        if (this.queryExecutionThread().isAlive()) {
            super.sparkSession().sparkContext().cancelJobGroup(this.runId().toString());
            this.queryExecutionThread().interrupt();
            this.queryExecutionThread().join();
            super.sparkSession().sparkContext().cancelJobGroup(this.runId().toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Query ").append(this.prettyIdString()).append(" was stopped").toString());
    }

    @Override
    public void startTrigger() {
        ProgressReporter.startTrigger$(this);
        StreamingQueryStatus qual$1 = this.currentStatus();
        boolean x$1 = true;
        String x$2 = qual$1.copy$default$1();
        boolean x$3 = qual$1.copy$default$2();
        this.currentStatus_$eq(qual$1.copy(x$2, x$3, x$1));
    }

    @Override
    public void runActivatedStream(SparkSession sparkSessionForStream) {
        boolean noDataBatchesEnabled = sparkSessionForStream.sessionState().conf().streamingNoDataMicroBatchesEnabled();
        ((TriggerExecutor)this.triggerExecutor()).execute((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            if (this.isActive()) {
                BooleanRef currentBatchHasNewData = BooleanRef.create((boolean)false);
                this.startTrigger();
                this.reportTimeTaken("triggerExecution", (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    if (this.currentBatchId() < 0L) {
                        this.populateStartOffsets(sparkSessionForStream);
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Stream started from ").append(this.committedOffsets()).toString());
                    }
                    this.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession().sparkContext().setJobDescription(this.getBatchDescriptionString());
                    if (!this.isCurrentBatchConstructed()) {
                        this.isCurrentBatchConstructed_$eq(this.constructNextBatch(noDataBatchesEnabled));
                    }
                    this.recordTriggerOffsets(this.committedOffsets(), this.availableOffsets());
                    currentBatchHasNewData$1.elem = this.isNewDataAvailable();
                    StreamingQueryStatus qual$1 = this.currentStatus();
                    boolean x$1 = this.isNewDataAvailable();
                    String x$2 = qual$1.copy$default$1();
                    boolean x$3 = qual$1.copy$default$3();
                    this.currentStatus_$eq(qual$1.copy(x$2, x$1, x$3));
                    if (this.isCurrentBatchConstructed()) {
                        if (currentBatchHasNewData$1.elem) {
                            this.updateStatusMessage("Processing new data");
                        } else {
                            this.updateStatusMessage("No new data but cleaning up state");
                        }
                        this.runBatch(sparkSessionForStream);
                    } else {
                        this.updateStatusMessage("Waiting for data to arrive");
                    }
                });
                this.finishTrigger(currentBatchHasNewData.elem);
                this.withProgressLocked((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.awaitProgressLockCondition().signalAll());
                if (this.isCurrentBatchConstructed()) {
                    this.currentBatchId_$eq(this.currentBatchId() + 1L);
                    this.isCurrentBatchConstructed_$eq(false);
                } else {
                    Thread.sleep(this.pollingDelayMs());
                }
            }
            this.updateStatusMessage("Waiting for next trigger");
            return this.isActive();
        });
    }

    private void populateStartOffsets(SparkSession sparkSessionToRunBatches) {
        Some some;
        Tuple2 tuple2;
        this.sinkCommitProgress_$eq((Option<StreamWriterCommitProgress>)None$.MODULE$);
        Option option = this.offsetLog().getLatest();
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Some some2;
            Tuple2 tuple22;
            long latestBatchId = tuple2._1$mcJ$sp();
            OffsetSeq nextOffsets = (OffsetSeq)tuple2._2();
            this.currentBatchId_$eq(latestBatchId);
            this.isCurrentBatchConstructed_$eq(true);
            this.availableOffsets_$eq(nextOffsets.toStreamProgress(this.sources()));
            if (latestBatchId != 0L) {
                OffsetSeq secondLatestOffsets = (OffsetSeq)this.offsetLog().get(latestBatchId - 1L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(20).append("batch ").append(latestBatchId - 1L).append(" doesn't exist").toString());
                });
                this.committedOffsets_$eq(secondLatestOffsets.toStreamProgress(this.sources()));
            }
            nextOffsets.metadata().foreach((Function1 & Serializable & scala.Serializable)metadata -> {
                MicroBatchExecution.$anonfun$populateStartOffsets$2(this, sparkSessionToRunBatches, metadata);
                return BoxedUnit.UNIT;
            });
            Option option2 = this.commitLog().getLatest();
            if (option2 instanceof Some && (tuple22 = (Tuple2)(some2 = (Some)option2).value()) != null) {
                BoxedUnit boxedUnit;
                long latestCommittedBatchId = tuple22._1$mcJ$sp();
                CommitMetadata commitMetadata = (CommitMetadata)tuple22._2();
                if (latestBatchId == latestCommittedBatchId) {
                    this.availableOffsets().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        void var2_10;
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            SparkDataStream source = (SparkDataStream)tuple2._1();
                            org.apache.spark.sql.connector.read.streaming.Offset end = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
                            if (source instanceof Source) {
                                Source source2 = (Source)source;
                                if (end instanceof Offset) {
                                    Offset offset = (Offset)end;
                                    Option start = this.committedOffsets().get(source2).map((Function1 & Serializable & scala.Serializable)x$1 -> (Offset)((Object)((Object)x$1)));
                                    Dataset<Row> dataset = source2.getBatch((Option<Offset>)start, offset);
                                    return var2_10;
                                }
                            }
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return var2_10;
                    });
                    this.currentBatchId_$eq(latestCommittedBatchId + 1L);
                    this.isCurrentBatchConstructed_$eq(false);
                    this.committedOffsets_$eq(this.committedOffsets().$plus$plus((GenTraversableOnce<Tuple2<SparkDataStream, org.apache.spark.sql.connector.read.streaming.Offset>>)this.availableOffsets()));
                    this.watermarkTracker().setWatermark(package$.MODULE$.max(this.watermarkTracker().currentWatermark(), commitMetadata.nextBatchWatermarkMs()));
                    boxedUnit = BoxedUnit.UNIT;
                } else if (latestCommittedBatchId < latestBatchId - 1L) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Batch completion log latest batch id is ").append(latestCommittedBatchId).append(", which is not trailing ").append("batchid ").append(latestBatchId).append(" by one").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (None$.MODULE$.equals(option2)) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "no commit log present");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option2);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Resuming at batch ").append(this.currentBatchId()).append(" with committed offsets ").append(this.committedOffsets()).append(" and available offsets ").append(this.availableOffsets()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting new streaming query.");
            this.currentBatchId_$eq(0L);
            this.watermarkTracker_$eq(WatermarkTracker$.MODULE$.apply(sparkSessionToRunBatches.conf()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    private boolean isNewDataAvailable() {
        return this.availableOffsets().exists((Function1<Tuple2<SparkDataStream, org.apache.spark.sql.connector.read.streaming.Offset>, Object>)(Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$isNewDataAvailable$1(this, x0$1)));
    }

    private boolean constructNextBatch(boolean noDataBatchesEnabled) {
        boolean bl;
        Object object = new Object();
        try {
            bl = BoxesRunTime.unboxToBoolean(this.withProgressLocked((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                if (this.isCurrentBatchConstructed()) {
                    throw new NonLocalReturnControl.mcZ.sp(object, true);
                }
                scala.collection.immutable.Map latestOffsets = ((TraversableOnce)this.uniqueSources().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2;
                    SparkDataStream sparkDataStream = x0$1;
                    if (sparkDataStream instanceof Source) {
                        Source source = (Source)sparkDataStream;
                        this.updateStatusMessage(new StringBuilder(21).append("Getting offsets from ").append(source).toString());
                        tuple2 = (Tuple2)this.reportTimeTaken("getOffset", (Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)source, source.getOffset()));
                    } else if (sparkDataStream instanceof RateControlMicroBatchStream) {
                        RateControlMicroBatchStream rateControlMicroBatchStream = (RateControlMicroBatchStream)sparkDataStream;
                        this.updateStatusMessage(new StringBuilder(21).append("Getting offsets from ").append(rateControlMicroBatchStream).toString());
                        tuple2 = (Tuple2)this.reportTimeTaken("latestOffset", (Function0 & Serializable & scala.Serializable)() -> {
                            org.apache.spark.sql.connector.read.streaming.Offset startOffset = (org.apache.spark.sql.connector.read.streaming.Offset)this.availableOffsets().get((SparkDataStream)rateControlMicroBatchStream).map((Function1 & Serializable & scala.Serializable)off -> rateControlMicroBatchStream.deserializeOffset(off.json())).getOrElse((Function0 & Serializable & scala.Serializable)() -> rateControlMicroBatchStream.initialOffset());
                            return new Tuple2((Object)rateControlMicroBatchStream, (Object)Option$.MODULE$.apply((Object)rateControlMicroBatchStream.latestOffset(startOffset)));
                        });
                    } else if (sparkDataStream instanceof MicroBatchStream) {
                        MicroBatchStream microBatchStream = (MicroBatchStream)sparkDataStream;
                        this.updateStatusMessage(new StringBuilder(21).append("Getting offsets from ").append(microBatchStream).toString());
                        tuple2 = (Tuple2)this.reportTimeTaken("latestOffset", (Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)microBatchStream, (Object)Option$.MODULE$.apply((Object)microBatchStream.latestOffset())));
                    } else {
                        throw new MatchError((Object)sparkDataStream);
                    }
                    return tuple2;
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.availableOffsets_$eq(this.availableOffsets().$plus$plus((GenTraversableOnce<Tuple2<SparkDataStream, org.apache.spark.sql.connector.read.streaming.Offset>>)((MapLike)latestOffsets.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$constructNextBatch$8(x0$2)))).mapValues((Function1 & Serializable & scala.Serializable)x$2 -> (org.apache.spark.sql.connector.read.streaming.Offset)x$2.get())));
                OffsetSeqMetadata qual$1 = this.offsetSeqMetadata();
                long x$1 = this.watermarkTracker().currentWatermark();
                long x$22 = this.super$triggerClock().getTimeMillis();
                scala.collection.immutable.Map<String, String> x$32 = qual$1.copy$default$3();
                this.offsetSeqMetadata_$eq(qual$1.copy(x$1, x$22, x$32));
                boolean lastExecutionRequiresAnotherBatch = noDataBatchesEnabled && Option$.MODULE$.apply((Object)this.lastExecution()).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.shouldRunAnotherBatch(this.offsetSeqMetadata())));
                boolean shouldConstructNextBatch = this.isNewDataAvailable() || lastExecutionRequiresAnotherBatch;
                this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(113).append("noDataBatchesEnabled = ").append(noDataBatchesEnabled).append(", ").append("lastExecutionRequiresAnotherBatch = ").append(lastExecutionRequiresAnotherBatch).append(", ").append("isNewDataAvailable = ").append(this.isNewDataAvailable()).append(", ").append("shouldConstructNextBatch = ").append(shouldConstructNextBatch).toString());
                if (shouldConstructNextBatch) {
                    this.updateStatusMessage("Writing offsets to log");
                    this.reportTimeTaken("walCommit", (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        block3: {
                            Predef$.MODULE$.assert(this.offsetLog().add(this.currentBatchId(), this.availableOffsets().toOffsetSeq(this.sources(), this.offsetSeqMetadata())), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Concurrent update to the log. Multiple streaming jobs detected for ").append(this.currentBatchId()).toString());
                            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Committed offsets for batch ").append(this.currentBatchId()).append(". ").append("Metadata ").append(this.offsetSeqMetadata().toString()).toString());
                            if (this.currentBatchId() != 0L) {
                                Option prevBatchOff = this.offsetLog().get(this.currentBatchId() - 1L);
                                if (prevBatchOff.isDefined()) {
                                    ((OffsetSeq)prevBatchOff.get()).toStreamProgress(this.sources()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                                        MicroBatchExecution.$anonfun$constructNextBatch$15(x0$3);
                                        return BoxedUnit.UNIT;
                                    });
                                } else {
                                    throw new IllegalStateException(new StringBuilder(20).append("batch ").append(this.currentBatchId() - 1L).append(" doesn't exist").toString());
                                }
                            }
                            if ((long)this.minLogEntriesToMaintain() >= this.currentBatchId()) break block3;
                            this.purge(this.currentBatchId() - (long)this.minLogEntriesToMaintain());
                        }
                    });
                    this.noNewData_$eq(false);
                } else {
                    this.noNewData_$eq(true);
                    this.awaitProgressLockCondition().signalAll();
                }
                return shouldConstructNextBatch;
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    private void runBatch(SparkSession sparkSessionToRunBatch) {
        LogicalPlan logicalPlan2;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Running batch ").append(this.currentBatchId()).toString());
        this.newData_$eq((scala.collection.immutable.Map<SparkDataStream, LogicalPlan>)((scala.collection.immutable.Map)this.reportTimeTaken("getBatch", (Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Map)this.availableOffsets().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            org.apache.spark.sql.connector.read.streaming.Offset offset;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                SparkDataStream source = (SparkDataStream)tuple2._1();
                org.apache.spark.sql.connector.read.streaming.Offset available = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
                if (source instanceof Source) {
                    Source source2 = (Source)source;
                    if (available instanceof Offset) {
                        Offset offset2 = (Offset)available;
                        if (BoxesRunTime.unboxToBoolean((Object)this.committedOffsets().get(source2).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$runBatch$4(offset2, x$4))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true))) {
                            Option current = this.committedOffsets().get(source2).map((Function1 & Serializable & scala.Serializable)x$5 -> (Offset)((Object)((Object)((Object)x$5))));
                            Dataset<Row> batch = source2.getBatch((Option<Offset>)current, offset2);
                            Predef$.MODULE$.assert(batch.isStreaming(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("DataFrame returned by getBatch from ").append(source2).append(" did not have isStreaming=true\n").append(batch.queryExecution().logical()).toString());
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Retrieving data from ").append(source2).append(": ").append(current).append(" -> ").append((Object)offset2).toString());
                            return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source2), (Object)batch.logicalPlan())));
                        }
                    }
                }
            }
            if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            SparkDataStream stream = (SparkDataStream)tuple2._1();
            org.apache.spark.sql.connector.read.streaming.Offset available = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
            if (!(stream instanceof MicroBatchStream)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            MicroBatchStream microBatchStream = (MicroBatchStream)stream;
            if (!BoxesRunTime.unboxToBoolean((Object)this.committedOffsets().get((SparkDataStream)microBatchStream).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$runBatch$9(available, x$6))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true))) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            Option current = this.committedOffsets().get((SparkDataStream)microBatchStream).map((Function1 & Serializable & scala.Serializable)off -> microBatchStream.deserializeOffset(off.json()));
            org.apache.spark.sql.connector.read.streaming.Offset offset3 = available;
            if (offset3 instanceof SerializedOffset) {
                SerializedOffset serializedOffset = (SerializedOffset)offset3;
                offset = microBatchStream.deserializeOffset(serializedOffset.json());
            } else {
                org.apache.spark.sql.connector.read.streaming.Offset offset4;
                if (offset3 == null) throw new MatchError((Object)offset3);
                offset = offset4 = offset3;
            }
            org.apache.spark.sql.connector.read.streaming.Offset endOffset = offset;
            org.apache.spark.sql.connector.read.streaming.Offset startOffset = (org.apache.spark.sql.connector.read.streaming.Offset)current.getOrElse((Function0 & Serializable & scala.Serializable)() -> microBatchStream.initialOffset());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Retrieving data from ").append(microBatchStream).append(": ").append(current).append(" -> ").append(endOffset).toString());
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)microBatchStream), (Object)new OffsetHolder(startOffset, endOffset))));
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()))));
        LogicalPlan newBatchesPlan = (LogicalPlan)this.logicalPlan().transform((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MicroBatchExecution $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StreamingExecutionRelation) {
                    StreamingExecutionRelation streamingExecutionRelation = (StreamingExecutionRelation)A1;
                    SparkDataStream source = streamingExecutionRelation.source();
                    Seq<Attribute> output = streamingExecutionRelation.output();
                    object = this.$outer.newData().get((Object)source).map((Function1 & Serializable & scala.Serializable)dataPlan -> {
                        int maxFields = SQLConf$.MODULE$.get().maxToStringFields();
                        Predef$.MODULE$.assert(output.size() == dataPlan.output().size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Invalid batch: ").append(org.apache.spark.sql.catalyst.util.package$.MODULE$.truncatedString(output, ",", maxFields)).append(" != ").append(org.apache.spark.sql.catalyst.util.package$.MODULE$.truncatedString(dataPlan.output(), ",", maxFields)).toString());
                        Seq aliases = (Seq)((TraversableLike)output.zip((GenIterable)dataPlan.output(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            Attribute from;
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Attribute to = (Attribute)tuple2._1();
                            Attribute x$1 = from = (Attribute)tuple2._2();
                            String x$2 = to.name();
                            ExprId x$3 = to.exprId();
                            Some x$4 = new Some((Object)from.metadata());
                            Seq x$5 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
                            Alias alias = new Alias((Expression)x$1, x$2, x$3, x$5, (Option)x$4);
                            return alias;
                        }, Seq$.MODULE$.canBuildFrom());
                        return new Project(aliases, dataPlan);
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        Seq x$6 = output;
                        boolean x$7 = true;
                        Seq x$8 = LocalRelation$.MODULE$.apply$default$2();
                        return new LocalRelation(x$6, x$8, x$7);
                    });
                } else if (A1 instanceof StreamingDataSourceV2Relation) {
                    StreamingDataSourceV2Relation streamingDataSourceV2Relation = (StreamingDataSourceV2Relation)A1;
                    object = this.$outer.newData().get((Object)streamingDataSourceV2Relation.stream()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        LogicalPlan logicalPlan2 = x0$2;
                        if (!(logicalPlan2 instanceof OffsetHolder)) {
                            throw new MatchError((Object)logicalPlan2);
                        }
                        OffsetHolder offsetHolder = (OffsetHolder)logicalPlan2;
                        org.apache.spark.sql.connector.read.streaming.Offset start = offsetHolder.start();
                        org.apache.spark.sql.connector.read.streaming.Offset end = offsetHolder.end();
                        Some x$9 = new Some((Object)start);
                        Some x$10 = new Some((Object)end);
                        Seq x$11 = streamingDataSourceV2Relation.copy$default$1();
                        Scan x$12 = streamingDataSourceV2Relation.copy$default$2();
                        SparkDataStream x$13 = streamingDataSourceV2Relation.copy$default$3();
                        StreamingDataSourceV2Relation streamingDataSourceV2Relation = streamingDataSourceV2Relation.copy(x$11, x$12, x$13, (Option)x$9, (Option)x$10);
                        return streamingDataSourceV2Relation;
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        Seq x$14 = streamingDataSourceV2Relation.output();
                        boolean x$15 = true;
                        Seq x$16 = LocalRelation$.MODULE$.apply$default$2();
                        return new LocalRelation(x$14, x$16, x$15);
                    });
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof StreamingExecutionRelation ? true : logicalPlan2 instanceof StreamingDataSourceV2Relation;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$7(scala.collection.Seq org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$10(scala.collection.Seq ), $anonfun$applyOrElse$11(org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$12(org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation ), $anonfun$applyOrElse$8(scala.collection.Seq int org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$9(scala.Tuple2 )}, serializedLambda);
            }
        });
        LogicalPlan newAttributePlan = newBatchesPlan.transformAllExpressions((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MicroBatchExecution $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof CurrentTimestamp) {
                    CurrentTimestamp currentTimestamp = (CurrentTimestamp)A1;
                    object = new CurrentBatchTimestamp(this.$outer.offsetSeqMetadata().batchTimestampMs(), currentTimestamp.dataType(), (Option)new Some((Object)"Dummy TimeZoneId"));
                } else if (A1 instanceof CurrentDate) {
                    CurrentDate currentDate = (CurrentDate)A1;
                    object = new CurrentBatchTimestamp(this.$outer.offsetSeqMetadata().batchTimestampMs(), currentDate.dataType(), currentDate.timeZoneId());
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                boolean bl = expression instanceof CurrentTimestamp ? true : expression instanceof CurrentDate;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Table table = super.sink();
        if (table instanceof Sink) {
            logicalPlan2 = newAttributePlan;
        } else if (table instanceof SupportsWrite) {
            logicalPlan2 = ((WriteToMicroBatchDataSource)newAttributePlan).createPlan(this.currentBatchId());
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append("unknown sink type for ").append(super.sink()).toString());
        }
        LogicalPlan triggerLogicalPlan = logicalPlan2;
        sparkSessionToRunBatch.sparkContext().setLocalProperty(MicroBatchExecution$.MODULE$.BATCH_ID_KEY(), ((Object)BoxesRunTime.boxToLong((long)this.currentBatchId())).toString());
        sparkSessionToRunBatch.sparkContext().setLocalProperty(StreamExecution$.MODULE$.IS_CONTINUOUS_PROCESSING(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.reportTimeTaken("queryPlanning", (Function0 & Serializable & scala.Serializable)() -> {
            this.lastExecution_$eq(new IncrementalExecution(sparkSessionToRunBatch, triggerLogicalPlan, this.super$outputMode(), this.checkpointFile("state"), this.id(), this.runId(), this.currentBatchId(), this.offsetSeqMetadata()));
            return this.lastExecution().executedPlan();
        });
        Dataset nextBatch = new Dataset(sparkSessionToRunBatch, this.lastExecution(), RowEncoder$.MODULE$.apply(this.lastExecution().analyzed().schema()));
        Option batchSinkProgress = (Option)this.reportTimeTaken("addBatch", (Function0 & Serializable & scala.Serializable)() -> (Option)SQLExecution$.MODULE$.withNewExecutionId(sparkSessionToRunBatch, this.lastExecution(), SQLExecution$.MODULE$.withNewExecutionId$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
            Option<StreamWriterCommitProgress> option;
            Object object;
            Table table = this.super$sink();
            if (table instanceof Sink) {
                Sink sink = (Sink)table;
                sink.addBatch(this.currentBatchId(), nextBatch);
                object = BoxedUnit.UNIT;
            } else if (table instanceof SupportsWrite) {
                object = nextBatch.collect();
            } else {
                throw new MatchError((Object)table);
            }
            SparkPlan sparkPlan = this.lastExecution().executedPlan();
            if (sparkPlan instanceof WriteToDataSourceV2Exec) {
                WriteToDataSourceV2Exec writeToDataSourceV2Exec = (WriteToDataSourceV2Exec)sparkPlan;
                option = writeToDataSourceV2Exec.commitProgress();
            } else {
                option = None$.MODULE$;
            }
            return option;
        }));
        this.withProgressLocked((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sinkCommitProgress_$eq((Option<StreamWriterCommitProgress>)batchSinkProgress);
            this.watermarkTracker().updateWatermark(this.lastExecution().executedPlan());
            this.commitLog().add(this.currentBatchId(), new CommitMetadata(this.watermarkTracker().currentWatermark()));
            this.committedOffsets_$eq(this.committedOffsets().$plus$plus((GenTraversableOnce<Tuple2<SparkDataStream, org.apache.spark.sql.connector.read.streaming.Offset>>)this.availableOffsets()));
        });
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Completed batch ").append(this.currentBatchId()).toString());
    }

    public <T> T withProgressLocked(Function0<T> f) {
        Object object;
        this.awaitProgressLock().lock();
        try {
            object = f.apply();
        }
        finally {
            this.awaitProgressLock().unlock();
        }
        return (T)object;
    }

    public static final /* synthetic */ void $anonfun$populateStartOffsets$2(MicroBatchExecution $this, SparkSession sparkSessionToRunBatches$1, OffsetSeqMetadata metadata) {
        OffsetSeqMetadata$.MODULE$.setSessionConf(metadata, sparkSessionToRunBatches$1.conf());
        $this.offsetSeqMetadata_$eq(OffsetSeqMetadata$.MODULE$.apply(metadata.batchWatermarkMs(), metadata.batchTimestampMs(), sparkSessionToRunBatches$1.conf()));
        $this.watermarkTracker_$eq(WatermarkTracker$.MODULE$.apply(sparkSessionToRunBatches$1.conf()));
        $this.watermarkTracker().setWatermark(metadata.batchWatermarkMs());
    }

    public static final /* synthetic */ boolean $anonfun$isNewDataAvailable$2(org.apache.spark.sql.connector.read.streaming.Offset available$1, org.apache.spark.sql.connector.read.streaming.Offset committed) {
        org.apache.spark.sql.connector.read.streaming.Offset offset = committed;
        org.apache.spark.sql.connector.read.streaming.Offset offset2 = available$1;
        return offset == null ? offset2 != null : !offset.equals(offset2);
    }

    public static final /* synthetic */ boolean $anonfun$isNewDataAvailable$1(MicroBatchExecution $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SparkDataStream source = (SparkDataStream)tuple2._1();
        org.apache.spark.sql.connector.read.streaming.Offset available = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)$this.committedOffsets().get(source).map((Function1 & Serializable & scala.Serializable)committed -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$isNewDataAvailable$2(available, committed))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$constructNextBatch$8(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option o = (Option)tuple2._2();
        boolean bl = o.nonEmpty();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$constructNextBatch$15(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            SparkDataStream src = (SparkDataStream)tuple2._1();
            org.apache.spark.sql.connector.read.streaming.Offset off = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
            if (src instanceof Source) {
                Source source = (Source)src;
                if (off instanceof Offset) {
                    Offset offset = (Offset)off;
                    source.commit(offset);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 != null) {
            SparkDataStream stream = (SparkDataStream)tuple2._1();
            org.apache.spark.sql.connector.read.streaming.Offset off = (org.apache.spark.sql.connector.read.streaming.Offset)tuple2._2();
            if (stream instanceof MicroBatchStream) {
                MicroBatchStream microBatchStream = (MicroBatchStream)stream;
                microBatchStream.commit(microBatchStream.deserializeOffset(off.json()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        SparkDataStream src = (SparkDataStream)tuple2._1();
        throw new IllegalArgumentException(new StringBuilder(47).append("Unknown source is found at constructNextBatch: ").append(src).toString());
    }

    public static final /* synthetic */ boolean $anonfun$runBatch$4(Offset x3$2, org.apache.spark.sql.connector.read.streaming.Offset x$4) {
        org.apache.spark.sql.connector.read.streaming.Offset offset = x$4;
        Offset offset2 = x3$2;
        return offset == null ? offset2 != null : !offset.equals((Object)offset2);
    }

    public static final /* synthetic */ boolean $anonfun$runBatch$9(org.apache.spark.sql.connector.read.streaming.Offset available$2, org.apache.spark.sql.connector.read.streaming.Offset x$6) {
        org.apache.spark.sql.connector.read.streaming.Offset offset = x$6;
        org.apache.spark.sql.connector.read.streaming.Offset offset2 = available$2;
        return offset == null ? offset2 != null : !offset.equals(offset2);
    }

    public MicroBatchExecution(SparkSession sparkSession, String name, String checkpointRoot, LogicalPlan analyzedPlan, Table sink, Trigger trigger, Clock triggerClock, OutputMode outputMode, scala.collection.immutable.Map<String, String> extraOptions, boolean deleteCheckpointOnStop) {
        Product product;
        this.analyzedPlan = analyzedPlan;
        this.extraOptions = extraOptions;
        super(sparkSession, name, checkpointRoot, analyzedPlan, sink, trigger, triggerClock, outputMode, deleteCheckpointOnStop);
        this.sources = (Seq)Seq$.MODULE$.empty();
        Trigger trigger2 = super.trigger();
        if (trigger2 instanceof ProcessingTimeTrigger) {
            ProcessingTimeTrigger processingTimeTrigger = (ProcessingTimeTrigger)trigger2;
            product = new ProcessingTimeExecutor(processingTimeTrigger, super.triggerClock());
        } else if (OneTimeTrigger$.MODULE$.equals(trigger2)) {
            product = new OneTimeExecutor();
        } else {
            throw new IllegalStateException(new StringBuilder(25).append("Unknown type of trigger: ").append(super.trigger()).toString());
        }
        this.triggerExecutor = product;
        this.isCurrentBatchConstructed = false;
    }
}

